from sapiopylib.rest.pojo.datatype.FieldDefinition import FieldType
from sapiopylib.rest.utils.recordmodel.RecordModelWrapper import WrappedRecordModel, WrapperField
from sapiopylib.rest.pojo.DateRange import DateRange
from typing import Optional


class ABI2700ResultModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type ABI2700Result
    Data Type Display Name: ABI2700 Result (ABI2700 Results)
    Fields: CreatedBy, Ct, CtSD, DataRecordName, DateCreated, Detector, OtherSampleId, SampleId, VeloxLastModifiedBy, VeloxLastModifiedDate, Well
    """
    DATA_TYPE_NAME: str = 'ABI2700Result'
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    CT__FIELD_NAME: WrapperField = WrapperField("Ct", FieldType.DOUBLE)
    CTSD__FIELD_NAME: WrapperField = WrapperField("CtSD", FieldType.DOUBLE)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    DETECTOR__FIELD_NAME: WrapperField = WrapperField("Detector", FieldType.STRING)
    OTHERSAMPLEID__FIELD_NAME: WrapperField = WrapperField("OtherSampleId", FieldType.STRING)
    SAMPLEID__FIELD_NAME: WrapperField = WrapperField("SampleId", FieldType.STRING)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)
    WELL__FIELD_NAME: WrapperField = WrapperField("Well", FieldType.STRING)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def set_Ct_field(self, value: Optional[float]):
        """
        Set data field with field name 'Ct' on this record model
        """
        self.set_field_value(self.CT__FIELD_NAME.field_name, value)

    def get_Ct_field(self) -> Optional[float]:
        """
        Get data field value with field name 'Ct' from this record model
        """
        return self.get_field_value(self.CT__FIELD_NAME.field_name)

    def set_CtSD_field(self, value: Optional[float]):
        """
        Set data field with field name 'CtSD' on this record model
        """
        self.set_field_value(self.CTSD__FIELD_NAME.field_name, value)

    def get_CtSD_field(self) -> Optional[float]:
        """
        Get data field value with field name 'CtSD' from this record model
        """
        return self.get_field_value(self.CTSD__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_Detector_field(self, value: Optional[str]):
        """
        Set data field with field name 'Detector' on this record model
        """
        self.set_field_value(self.DETECTOR__FIELD_NAME.field_name, value)

    def get_Detector_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Detector' from this record model
        """
        return self.get_field_value(self.DETECTOR__FIELD_NAME.field_name)

    def set_OtherSampleId_field(self, value: Optional[str]):
        """
        Set data field with field name 'OtherSampleId' on this record model
        """
        self.set_field_value(self.OTHERSAMPLEID__FIELD_NAME.field_name, value)

    def get_OtherSampleId_field(self) -> Optional[str]:
        """
        Get data field value with field name 'OtherSampleId' from this record model
        """
        return self.get_field_value(self.OTHERSAMPLEID__FIELD_NAME.field_name)

    def set_SampleId_field(self, value: Optional[str]):
        """
        Set data field with field name 'SampleId' on this record model
        """
        self.set_field_value(self.SAMPLEID__FIELD_NAME.field_name, value)

    def get_SampleId_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SampleId' from this record model
        """
        return self.get_field_value(self.SAMPLEID__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)

    def set_Well_field(self, value: Optional[str]):
        """
        Set data field with field name 'Well' on this record model
        """
        self.set_field_value(self.WELL__FIELD_NAME.field_name, value)

    def get_Well_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Well' from this record model
        """
        return self.get_field_value(self.WELL__FIELD_NAME.field_name)


class AccessionConfigModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type AccessionConfig
    Data Type Display Name: Accession Configuration (Accession Configurations)
    Fields: AccessionOnCreate, CreatedBy, CustomPluginClassPath, DataFieldName, DataRecordName, DataTypeField, DateCreated, IsGlobal, NumberOfDigits, PrefixField, StartNumber, SuffixField, VeloxLastModifiedBy, VeloxLastModifiedDate
    Accession configuration can be used to modify default accessioning behaviors for out-of-box plugins from Sapio Sciences. Convenient methods can be found in AccessioningWithConfigManager class to accession according to the configuration. All Sapio plugins who accession samples should use this util for accessioning.
    """
    DATA_TYPE_NAME: str = 'AccessionConfig'
    ACCESSIONONCREATE__FIELD_NAME: WrapperField = WrapperField("AccessionOnCreate", FieldType.BOOLEAN)
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    CUSTOMPLUGINCLASSPATH__FIELD_NAME: WrapperField = WrapperField("CustomPluginClassPath", FieldType.STRING)
    DATAFIELDNAME__FIELD_NAME: WrapperField = WrapperField("DataFieldName", FieldType.SELECTION)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATATYPEFIELD__FIELD_NAME: WrapperField = WrapperField("DataTypeField", FieldType.SELECTION)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    ISGLOBAL__FIELD_NAME: WrapperField = WrapperField("IsGlobal", FieldType.BOOLEAN)
    NUMBEROFDIGITS__FIELD_NAME: WrapperField = WrapperField("NumberOfDigits", FieldType.INTEGER)
    PREFIXFIELD__FIELD_NAME: WrapperField = WrapperField("PrefixField", FieldType.STRING)
    STARTNUMBER__FIELD_NAME: WrapperField = WrapperField("StartNumber", FieldType.INTEGER)
    SUFFIXFIELD__FIELD_NAME: WrapperField = WrapperField("SuffixField", FieldType.STRING)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_AccessionOnCreate_field(self, value: Optional[bool]):
        """
        Set data field with field name 'AccessionOnCreate' on this record model
        """
        self.set_field_value(self.ACCESSIONONCREATE__FIELD_NAME.field_name, value)

    def get_AccessionOnCreate_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'AccessionOnCreate' from this record model
        """
        return self.get_field_value(self.ACCESSIONONCREATE__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def set_CustomPluginClassPath_field(self, value: Optional[str]):
        """
        Set data field with field name 'CustomPluginClassPath' on this record model
        """
        self.set_field_value(self.CUSTOMPLUGINCLASSPATH__FIELD_NAME.field_name, value)

    def get_CustomPluginClassPath_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CustomPluginClassPath' from this record model
        """
        return self.get_field_value(self.CUSTOMPLUGINCLASSPATH__FIELD_NAME.field_name)

    def set_DataFieldName_field(self, value: Optional[str]):
        """
        Set data field with field name 'DataFieldName' on this record model
        """
        self.set_field_value(self.DATAFIELDNAME__FIELD_NAME.field_name, value)

    def get_DataFieldName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'DataFieldName' from this record model
        """
        return self.get_field_value(self.DATAFIELDNAME__FIELD_NAME.field_name)

    def set_DataTypeField_field(self, value: Optional[str]):
        """
        Set data field with field name 'DataTypeField' on this record model
        """
        self.set_field_value(self.DATATYPEFIELD__FIELD_NAME.field_name, value)

    def get_DataTypeField_field(self) -> Optional[str]:
        """
        Get data field value with field name 'DataTypeField' from this record model
        """
        return self.get_field_value(self.DATATYPEFIELD__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_IsGlobal_field(self, value: Optional[bool]):
        """
        Set data field with field name 'IsGlobal' on this record model
        """
        self.set_field_value(self.ISGLOBAL__FIELD_NAME.field_name, value)

    def get_IsGlobal_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'IsGlobal' from this record model
        """
        return self.get_field_value(self.ISGLOBAL__FIELD_NAME.field_name)

    def set_NumberOfDigits_field(self, value: Optional[int]):
        """
        Set data field with field name 'NumberOfDigits' on this record model
        """
        self.set_field_value(self.NUMBEROFDIGITS__FIELD_NAME.field_name, value)

    def get_NumberOfDigits_field(self) -> Optional[int]:
        """
        Get data field value with field name 'NumberOfDigits' from this record model
        """
        return self.get_field_value(self.NUMBEROFDIGITS__FIELD_NAME.field_name)

    def set_PrefixField_field(self, value: Optional[str]):
        """
        Set data field with field name 'PrefixField' on this record model
        """
        self.set_field_value(self.PREFIXFIELD__FIELD_NAME.field_name, value)

    def get_PrefixField_field(self) -> Optional[str]:
        """
        Get data field value with field name 'PrefixField' from this record model
        """
        return self.get_field_value(self.PREFIXFIELD__FIELD_NAME.field_name)

    def set_StartNumber_field(self, value: Optional[int]):
        """
        Set data field with field name 'StartNumber' on this record model
        """
        self.set_field_value(self.STARTNUMBER__FIELD_NAME.field_name, value)

    def get_StartNumber_field(self) -> Optional[int]:
        """
        Get data field value with field name 'StartNumber' from this record model
        """
        return self.get_field_value(self.STARTNUMBER__FIELD_NAME.field_name)

    def set_SuffixField_field(self, value: Optional[str]):
        """
        Set data field with field name 'SuffixField' on this record model
        """
        self.set_field_value(self.SUFFIXFIELD__FIELD_NAME.field_name, value)

    def get_SuffixField_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SuffixField' from this record model
        """
        return self.get_field_value(self.SUFFIXFIELD__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class AgentModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type Agent
    Data Type Display Name: Agent (Agents)
    Fields: AgentName, AgentType, CreatedBy, DataRecordName, DateCreated, MultiParentLink649, VeloxLastModifiedBy, VeloxLastModifiedDate
    """
    DATA_TYPE_NAME: str = 'Agent'
    AGENTNAME__FIELD_NAME: WrapperField = WrapperField("AgentName", FieldType.SELECTION)
    AGENTTYPE__FIELD_NAME: WrapperField = WrapperField("AgentType", FieldType.SELECTION)
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    MULTIPARENTLINK649__FIELD_NAME: WrapperField = WrapperField("MultiParentLink649", FieldType.MULTIPARENTLINK)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_AgentName_field(self, value: Optional[str]):
        """
        Set data field with field name 'AgentName' on this record model
        """
        self.set_field_value(self.AGENTNAME__FIELD_NAME.field_name, value)

    def get_AgentName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'AgentName' from this record model
        """
        return self.get_field_value(self.AGENTNAME__FIELD_NAME.field_name)

    def set_AgentType_field(self, value: Optional[str]):
        """
        Set data field with field name 'AgentType' on this record model
        """
        self.set_field_value(self.AGENTTYPE__FIELD_NAME.field_name, value)

    def get_AgentType_field(self) -> Optional[str]:
        """
        Get data field value with field name 'AgentType' from this record model
        """
        return self.get_field_value(self.AGENTTYPE__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class AnalysisStatusModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type AnalysisStatus
    Data Type Display Name: Analysis Status (Analysis Statuses)
    Fields: CreatedBy, DataRecordName, DateCreated, Invocation, Script, Status, VeloxLastModifiedBy, VeloxLastModifiedDate
    """
    DATA_TYPE_NAME: str = 'AnalysisStatus'
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    INVOCATION__FIELD_NAME: WrapperField = WrapperField("Invocation", FieldType.PICKLIST)
    SCRIPT__FIELD_NAME: WrapperField = WrapperField("Script", FieldType.STRING)
    STATUS__FIELD_NAME: WrapperField = WrapperField("Status", FieldType.PICKLIST)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_Invocation_field(self, value: Optional[str]):
        """
        Set data field with field name 'Invocation' on this record model
        """
        self.set_field_value(self.INVOCATION__FIELD_NAME.field_name, value)

    def get_Invocation_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Invocation' from this record model
        """
        return self.get_field_value(self.INVOCATION__FIELD_NAME.field_name)

    def set_Script_field(self, value: Optional[str]):
        """
        Set data field with field name 'Script' on this record model
        """
        self.set_field_value(self.SCRIPT__FIELD_NAME.field_name, value)

    def get_Script_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Script' from this record model
        """
        return self.get_field_value(self.SCRIPT__FIELD_NAME.field_name)

    def set_Status_field(self, value: Optional[str]):
        """
        Set data field with field name 'Status' on this record model
        """
        self.set_field_value(self.STATUS__FIELD_NAME.field_name, value)

    def get_Status_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Status' from this record model
        """
        return self.get_field_value(self.STATUS__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class AnalyticsWizardChartDataModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type AnalyticsWizardChartData
    Data Type Display Name: Analytics Wizard Chart Datum (Analytics Wizard Chart Data)
    Fields: CreatedBy, DataRecordName, DateCreated, FilePath, VeloxCurrentVersion, VeloxLastModifiedBy, VeloxLastModifiedDate
    Holds a single chart data for a jarvis analytic run result. A run result can have more than one chart.
    """
    DATA_TYPE_NAME: str = 'AnalyticsWizardChartData'
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    FILEPATH__FIELD_NAME: WrapperField = WrapperField("FilePath", FieldType.STRING)
    VELOXCURRENTVERSION__FIELD_NAME: WrapperField = WrapperField("VeloxCurrentVersion", FieldType.INTEGER)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_FilePath_field(self, value: Optional[str]):
        """
        Set data field with field name 'FilePath' on this record model
        """
        self.set_field_value(self.FILEPATH__FIELD_NAME.field_name, value)

    def get_FilePath_field(self) -> Optional[str]:
        """
        Get data field value with field name 'FilePath' from this record model
        """
        return self.get_field_value(self.FILEPATH__FIELD_NAME.field_name)

    def set_VeloxCurrentVersion_field(self, value: Optional[int]):
        """
        Set data field with field name 'VeloxCurrentVersion' on this record model
        """
        self.set_field_value(self.VELOXCURRENTVERSION__FIELD_NAME.field_name, value)

    def get_VeloxCurrentVersion_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxCurrentVersion' from this record model
        """
        return self.get_field_value(self.VELOXCURRENTVERSION__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class AnalyticsWizardRunModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type AnalyticsWizardRun
    Data Type Display Name: Analytics Wizard Run (Analytics Wizard Runs)
    Fields: CreatedBy, DataRecordName, DateCreated, FilePath, Name, OperatorName, ParametersJSON, RunId, VeloxCurrentVersion, VeloxLastModifiedBy, VeloxLastModifiedDate
    Stored a single run of particular run settings within a top level result of data frame.
    """
    DATA_TYPE_NAME: str = 'AnalyticsWizardRun'
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    FILEPATH__FIELD_NAME: WrapperField = WrapperField("FilePath", FieldType.STRING)
    NAME__FIELD_NAME: WrapperField = WrapperField("Name", FieldType.STRING)
    OPERATORNAME__FIELD_NAME: WrapperField = WrapperField("OperatorName", FieldType.STRING)
    PARAMETERSJSON__FIELD_NAME: WrapperField = WrapperField("ParametersJSON", FieldType.STRING)
    RUNID__FIELD_NAME: WrapperField = WrapperField("RunId", FieldType.INTEGER)
    VELOXCURRENTVERSION__FIELD_NAME: WrapperField = WrapperField("VeloxCurrentVersion", FieldType.INTEGER)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_FilePath_field(self, value: Optional[str]):
        """
        Set data field with field name 'FilePath' on this record model
        """
        self.set_field_value(self.FILEPATH__FIELD_NAME.field_name, value)

    def get_FilePath_field(self) -> Optional[str]:
        """
        Get data field value with field name 'FilePath' from this record model
        """
        return self.get_field_value(self.FILEPATH__FIELD_NAME.field_name)

    def set_Name_field(self, value: Optional[str]):
        """
        Set data field with field name 'Name' on this record model
        """
        self.set_field_value(self.NAME__FIELD_NAME.field_name, value)

    def get_Name_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Name' from this record model
        """
        return self.get_field_value(self.NAME__FIELD_NAME.field_name)

    def set_OperatorName_field(self, value: Optional[str]):
        """
        Set data field with field name 'OperatorName' on this record model
        """
        self.set_field_value(self.OPERATORNAME__FIELD_NAME.field_name, value)

    def get_OperatorName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'OperatorName' from this record model
        """
        return self.get_field_value(self.OPERATORNAME__FIELD_NAME.field_name)

    def set_ParametersJSON_field(self, value: Optional[str]):
        """
        Set data field with field name 'ParametersJSON' on this record model
        """
        self.set_field_value(self.PARAMETERSJSON__FIELD_NAME.field_name, value)

    def get_ParametersJSON_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ParametersJSON' from this record model
        """
        return self.get_field_value(self.PARAMETERSJSON__FIELD_NAME.field_name)

    def set_RunId_field(self, value: Optional[int]):
        """
        Set data field with field name 'RunId' on this record model
        """
        self.set_field_value(self.RUNID__FIELD_NAME.field_name, value)

    def get_RunId_field(self) -> Optional[int]:
        """
        Get data field value with field name 'RunId' from this record model
        """
        return self.get_field_value(self.RUNID__FIELD_NAME.field_name)

    def set_VeloxCurrentVersion_field(self, value: Optional[int]):
        """
        Set data field with field name 'VeloxCurrentVersion' on this record model
        """
        self.set_field_value(self.VELOXCURRENTVERSION__FIELD_NAME.field_name, value)

    def get_VeloxCurrentVersion_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxCurrentVersion' from this record model
        """
        return self.get_field_value(self.VELOXCURRENTVERSION__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class AnalyticsWizardSavedSettingModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type AnalyticsWizardSavedSetting
    Data Type Display Name: Analytics Wizard Saved Setting (Analytics Wizard Saved Settings)
    Fields: CreatedBy, DataRecordName, DateCreated, OpName, SettingsContent, SettingsName, VeloxLastModifiedBy, VeloxLastModifiedDate
    Saves the settings for Jarvis Analytic data and parameter mappings.

Saving is only allowed if the exact settings has not been repeated.
    """
    DATA_TYPE_NAME: str = 'AnalyticsWizardSavedSetting'
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    OPNAME__FIELD_NAME: WrapperField = WrapperField("OpName", FieldType.STRING)
    SETTINGSCONTENT__FIELD_NAME: WrapperField = WrapperField("SettingsContent", FieldType.STRING)
    SETTINGSNAME__FIELD_NAME: WrapperField = WrapperField("SettingsName", FieldType.STRING)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_OpName_field(self, value: Optional[str]):
        """
        Set data field with field name 'OpName' on this record model
        """
        self.set_field_value(self.OPNAME__FIELD_NAME.field_name, value)

    def get_OpName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'OpName' from this record model
        """
        return self.get_field_value(self.OPNAME__FIELD_NAME.field_name)

    def set_SettingsContent_field(self, value: Optional[str]):
        """
        Set data field with field name 'SettingsContent' on this record model
        """
        self.set_field_value(self.SETTINGSCONTENT__FIELD_NAME.field_name, value)

    def get_SettingsContent_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SettingsContent' from this record model
        """
        return self.get_field_value(self.SETTINGSCONTENT__FIELD_NAME.field_name)

    def set_SettingsName_field(self, value: Optional[str]):
        """
        Set data field with field name 'SettingsName' on this record model
        """
        self.set_field_value(self.SETTINGSNAME__FIELD_NAME.field_name, value)

    def get_SettingsName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SettingsName' from this record model
        """
        return self.get_field_value(self.SETTINGSNAME__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class AnalyticsWizardTopLevelResultModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type AnalyticsWizardTopLevelResult
    Data Type Display Name: Analytics Wizard Top Level Result (Analytics Wizard Top Level Results)
    Fields: CreatedBy, CspFieldDefinitionJson, DataRecordName, DateCreated, FilePath, Name, VeloxCurrentVersion, VeloxLastModifiedBy, VeloxLastModifiedDate
    Stores the top level results of a single jarvis analytics saved run.
    """
    DATA_TYPE_NAME: str = 'AnalyticsWizardTopLevelResult'
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    CSPFIELDDEFINITIONJSON__FIELD_NAME: WrapperField = WrapperField("CspFieldDefinitionJson", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    FILEPATH__FIELD_NAME: WrapperField = WrapperField("FilePath", FieldType.STRING)
    NAME__FIELD_NAME: WrapperField = WrapperField("Name", FieldType.STRING)
    VELOXCURRENTVERSION__FIELD_NAME: WrapperField = WrapperField("VeloxCurrentVersion", FieldType.INTEGER)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def set_CspFieldDefinitionJson_field(self, value: Optional[str]):
        """
        Set data field with field name 'CspFieldDefinitionJson' on this record model
        """
        self.set_field_value(self.CSPFIELDDEFINITIONJSON__FIELD_NAME.field_name, value)

    def get_CspFieldDefinitionJson_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CspFieldDefinitionJson' from this record model
        """
        return self.get_field_value(self.CSPFIELDDEFINITIONJSON__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_FilePath_field(self, value: Optional[str]):
        """
        Set data field with field name 'FilePath' on this record model
        """
        self.set_field_value(self.FILEPATH__FIELD_NAME.field_name, value)

    def get_FilePath_field(self) -> Optional[str]:
        """
        Get data field value with field name 'FilePath' from this record model
        """
        return self.get_field_value(self.FILEPATH__FIELD_NAME.field_name)

    def set_Name_field(self, value: Optional[str]):
        """
        Set data field with field name 'Name' on this record model
        """
        self.set_field_value(self.NAME__FIELD_NAME.field_name, value)

    def get_Name_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Name' from this record model
        """
        return self.get_field_value(self.NAME__FIELD_NAME.field_name)

    def set_VeloxCurrentVersion_field(self, value: Optional[int]):
        """
        Set data field with field name 'VeloxCurrentVersion' on this record model
        """
        self.set_field_value(self.VELOXCURRENTVERSION__FIELD_NAME.field_name, value)

    def get_VeloxCurrentVersion_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxCurrentVersion' from this record model
        """
        return self.get_field_value(self.VELOXCURRENTVERSION__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class AntibodyModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type Antibody
    Data Type Display Name: Antibody (Antibodies)
    Fields: ConsumableName, ConsumableType, CreatedBy, DataRecordName, DateCreated, ExpirationDate, HELM, LotNumber, PartNumber, RegistryId, VeloxLastModifiedBy, VeloxLastModifiedDate, Vendor
    """
    DATA_TYPE_NAME: str = 'Antibody'
    CONSUMABLENAME__FIELD_NAME: WrapperField = WrapperField("ConsumableName", FieldType.STRING)
    CONSUMABLETYPE__FIELD_NAME: WrapperField = WrapperField("ConsumableType", FieldType.SELECTION)
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    EXPIRATIONDATE__FIELD_NAME: WrapperField = WrapperField("ExpirationDate", FieldType.DATE)
    HELM__FIELD_NAME: WrapperField = WrapperField("HELM", FieldType.STRING)
    LOTNUMBER__FIELD_NAME: WrapperField = WrapperField("LotNumber", FieldType.STRING)
    PARTNUMBER__FIELD_NAME: WrapperField = WrapperField("PartNumber", FieldType.STRING)
    REGISTRYID__FIELD_NAME: WrapperField = WrapperField("RegistryId", FieldType.STRING)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)
    VENDOR__FIELD_NAME: WrapperField = WrapperField("Vendor", FieldType.SELECTION)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_ConsumableName_field(self, value: Optional[str]):
        """
        Set data field with field name 'ConsumableName' on this record model
        """
        self.set_field_value(self.CONSUMABLENAME__FIELD_NAME.field_name, value)

    def get_ConsumableName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ConsumableName' from this record model
        """
        return self.get_field_value(self.CONSUMABLENAME__FIELD_NAME.field_name)

    def set_ConsumableType_field(self, value: Optional[str]):
        """
        Set data field with field name 'ConsumableType' on this record model
        """
        self.set_field_value(self.CONSUMABLETYPE__FIELD_NAME.field_name, value)

    def get_ConsumableType_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ConsumableType' from this record model
        """
        return self.get_field_value(self.CONSUMABLETYPE__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_ExpirationDate_field(self, value: Optional[int]):
        """
        Set data field with field name 'ExpirationDate' on this record model
        """
        self.set_field_value(self.EXPIRATIONDATE__FIELD_NAME.field_name, value)

    def get_ExpirationDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'ExpirationDate' from this record model
        """
        return self.get_field_value(self.EXPIRATIONDATE__FIELD_NAME.field_name)

    def set_HELM_field(self, value: Optional[str]):
        """
        Set data field with field name 'HELM' on this record model
        """
        self.set_field_value(self.HELM__FIELD_NAME.field_name, value)

    def get_HELM_field(self) -> Optional[str]:
        """
        Get data field value with field name 'HELM' from this record model
        """
        return self.get_field_value(self.HELM__FIELD_NAME.field_name)

    def set_LotNumber_field(self, value: Optional[str]):
        """
        Set data field with field name 'LotNumber' on this record model
        """
        self.set_field_value(self.LOTNUMBER__FIELD_NAME.field_name, value)

    def get_LotNumber_field(self) -> Optional[str]:
        """
        Get data field value with field name 'LotNumber' from this record model
        """
        return self.get_field_value(self.LOTNUMBER__FIELD_NAME.field_name)

    def set_PartNumber_field(self, value: Optional[str]):
        """
        Set data field with field name 'PartNumber' on this record model
        """
        self.set_field_value(self.PARTNUMBER__FIELD_NAME.field_name, value)

    def get_PartNumber_field(self) -> Optional[str]:
        """
        Get data field value with field name 'PartNumber' from this record model
        """
        return self.get_field_value(self.PARTNUMBER__FIELD_NAME.field_name)

    def set_RegistryId_field(self, value: Optional[str]):
        """
        Set data field with field name 'RegistryId' on this record model
        """
        self.set_field_value(self.REGISTRYID__FIELD_NAME.field_name, value)

    def get_RegistryId_field(self) -> Optional[str]:
        """
        Get data field value with field name 'RegistryId' from this record model
        """
        return self.get_field_value(self.REGISTRYID__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)

    def set_Vendor_field(self, value: Optional[str]):
        """
        Set data field with field name 'Vendor' on this record model
        """
        self.set_field_value(self.VENDOR__FIELD_NAME.field_name, value)

    def get_Vendor_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Vendor' from this record model
        """
        return self.get_field_value(self.VENDOR__FIELD_NAME.field_name)


class AntibodyPartModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type AntibodyPart
    Data Type Display Name: Antibody Part (Antibody Parts)
    Fields: ChemicalProperties, ConsumableName, ConsumableType, CreatedBy, DataRecordName, DateCreated, HELM, HELMHash, MultiParentLink201, QuantityOnHand, QuantityPerItem, RegistryId, ReorderLevelQuantity, Units, VeloxLastModifiedBy, VeloxLastModifiedDate, Vendor
    """
    DATA_TYPE_NAME: str = 'AntibodyPart'
    CHEMICALPROPERTIES__FIELD_NAME: WrapperField = WrapperField("ChemicalProperties", FieldType.SIDE_LINK)
    CONSUMABLENAME__FIELD_NAME: WrapperField = WrapperField("ConsumableName", FieldType.STRING)
    CONSUMABLETYPE__FIELD_NAME: WrapperField = WrapperField("ConsumableType", FieldType.PICKLIST)
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    HELM__FIELD_NAME: WrapperField = WrapperField("HELM", FieldType.STRING)
    HELMHASH__FIELD_NAME: WrapperField = WrapperField("HELMHash", FieldType.STRING)
    MULTIPARENTLINK201__FIELD_NAME: WrapperField = WrapperField("MultiParentLink201", FieldType.MULTIPARENTLINK)
    QUANTITYONHAND__FIELD_NAME: WrapperField = WrapperField("QuantityOnHand", FieldType.DOUBLE)
    QUANTITYPERITEM__FIELD_NAME: WrapperField = WrapperField("QuantityPerItem", FieldType.DOUBLE)
    REGISTRYID__FIELD_NAME: WrapperField = WrapperField("RegistryId", FieldType.STRING)
    REORDERLEVELQUANTITY__FIELD_NAME: WrapperField = WrapperField("ReorderLevelQuantity", FieldType.DOUBLE)
    UNITS__FIELD_NAME: WrapperField = WrapperField("Units", FieldType.PICKLIST)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)
    VENDOR__FIELD_NAME: WrapperField = WrapperField("Vendor", FieldType.SELECTION)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_ChemicalProperties_field(self, value: Optional[int]):
        """
        Set data field with field name 'ChemicalProperties' on this record model
        """
        self.set_field_value(self.CHEMICALPROPERTIES__FIELD_NAME.field_name, value)

    def get_ChemicalProperties_field(self) -> Optional[int]:
        """
        Get data field value with field name 'ChemicalProperties' from this record model
        """
        return self.get_field_value(self.CHEMICALPROPERTIES__FIELD_NAME.field_name)

    def set_ConsumableName_field(self, value: Optional[str]):
        """
        Set data field with field name 'ConsumableName' on this record model
        """
        self.set_field_value(self.CONSUMABLENAME__FIELD_NAME.field_name, value)

    def get_ConsumableName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ConsumableName' from this record model
        """
        return self.get_field_value(self.CONSUMABLENAME__FIELD_NAME.field_name)

    def set_ConsumableType_field(self, value: Optional[str]):
        """
        Set data field with field name 'ConsumableType' on this record model
        """
        self.set_field_value(self.CONSUMABLETYPE__FIELD_NAME.field_name, value)

    def get_ConsumableType_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ConsumableType' from this record model
        """
        return self.get_field_value(self.CONSUMABLETYPE__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_HELM_field(self, value: Optional[str]):
        """
        Set data field with field name 'HELM' on this record model
        """
        self.set_field_value(self.HELM__FIELD_NAME.field_name, value)

    def get_HELM_field(self) -> Optional[str]:
        """
        Get data field value with field name 'HELM' from this record model
        """
        return self.get_field_value(self.HELM__FIELD_NAME.field_name)

    def set_HELMHash_field(self, value: Optional[str]):
        """
        Set data field with field name 'HELMHash' on this record model
        """
        self.set_field_value(self.HELMHASH__FIELD_NAME.field_name, value)

    def get_HELMHash_field(self) -> Optional[str]:
        """
        Get data field value with field name 'HELMHash' from this record model
        """
        return self.get_field_value(self.HELMHASH__FIELD_NAME.field_name)

    def set_QuantityOnHand_field(self, value: Optional[float]):
        """
        Set data field with field name 'QuantityOnHand' on this record model
        """
        self.set_field_value(self.QUANTITYONHAND__FIELD_NAME.field_name, value)

    def get_QuantityOnHand_field(self) -> Optional[float]:
        """
        Get data field value with field name 'QuantityOnHand' from this record model
        """
        return self.get_field_value(self.QUANTITYONHAND__FIELD_NAME.field_name)

    def set_QuantityPerItem_field(self, value: Optional[float]):
        """
        Set data field with field name 'QuantityPerItem' on this record model
        """
        self.set_field_value(self.QUANTITYPERITEM__FIELD_NAME.field_name, value)

    def get_QuantityPerItem_field(self) -> Optional[float]:
        """
        Get data field value with field name 'QuantityPerItem' from this record model
        """
        return self.get_field_value(self.QUANTITYPERITEM__FIELD_NAME.field_name)

    def set_RegistryId_field(self, value: Optional[str]):
        """
        Set data field with field name 'RegistryId' on this record model
        """
        self.set_field_value(self.REGISTRYID__FIELD_NAME.field_name, value)

    def get_RegistryId_field(self) -> Optional[str]:
        """
        Get data field value with field name 'RegistryId' from this record model
        """
        return self.get_field_value(self.REGISTRYID__FIELD_NAME.field_name)

    def set_ReorderLevelQuantity_field(self, value: Optional[float]):
        """
        Set data field with field name 'ReorderLevelQuantity' on this record model
        """
        self.set_field_value(self.REORDERLEVELQUANTITY__FIELD_NAME.field_name, value)

    def get_ReorderLevelQuantity_field(self) -> Optional[float]:
        """
        Get data field value with field name 'ReorderLevelQuantity' from this record model
        """
        return self.get_field_value(self.REORDERLEVELQUANTITY__FIELD_NAME.field_name)

    def set_Units_field(self, value: Optional[str]):
        """
        Set data field with field name 'Units' on this record model
        """
        self.set_field_value(self.UNITS__FIELD_NAME.field_name, value)

    def get_Units_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Units' from this record model
        """
        return self.get_field_value(self.UNITS__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)

    def set_Vendor_field(self, value: Optional[str]):
        """
        Set data field with field name 'Vendor' on this record model
        """
        self.set_field_value(self.VENDOR__FIELD_NAME.field_name, value)

    def get_Vendor_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Vendor' from this record model
        """
        return self.get_field_value(self.VENDOR__FIELD_NAME.field_name)


class AssignedProcessModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type AssignedProcess
    Data Type Display Name: Assigned Process (Assigned Processes)
    Fields: AwaitingRequestApproval, BranchLongId, CompletedDate, CreatedBy, DataRecordName, DateCreated, DoNotProceed, HasBeenReprocessed, OtherSampleId, PauseTracking, ProcessName, ProcessStepNumber, ProcessTAT, Reprocessing, RequestRecordId, SampleId, SampleRecordId, ScheduledDate, SourceAssignedProcessIds, Status, TurnAroundHours, TurnAroundMinutes, VeloxLastModifiedBy, VeloxLastModifiedDate
    """
    DATA_TYPE_NAME: str = 'AssignedProcess'
    AWAITINGREQUESTAPPROVAL__FIELD_NAME: WrapperField = WrapperField("AwaitingRequestApproval", FieldType.BOOLEAN)
    BRANCHLONGID__FIELD_NAME: WrapperField = WrapperField("BranchLongId", FieldType.LONG)
    COMPLETEDDATE__FIELD_NAME: WrapperField = WrapperField("CompletedDate", FieldType.DATE)
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    DONOTPROCEED__FIELD_NAME: WrapperField = WrapperField("DoNotProceed", FieldType.BOOLEAN)
    HASBEENREPROCESSED__FIELD_NAME: WrapperField = WrapperField("HasBeenReprocessed", FieldType.BOOLEAN)
    OTHERSAMPLEID__FIELD_NAME: WrapperField = WrapperField("OtherSampleId", FieldType.STRING)
    PAUSETRACKING__FIELD_NAME: WrapperField = WrapperField("PauseTracking", FieldType.BOOLEAN)
    PROCESSNAME__FIELD_NAME: WrapperField = WrapperField("ProcessName", FieldType.SELECTION)
    PROCESSSTEPNUMBER__FIELD_NAME: WrapperField = WrapperField("ProcessStepNumber", FieldType.LONG)
    PROCESSTAT__FIELD_NAME: WrapperField = WrapperField("ProcessTAT", FieldType.DOUBLE)
    REPROCESSING__FIELD_NAME: WrapperField = WrapperField("Reprocessing", FieldType.BOOLEAN)
    REQUESTRECORDID__FIELD_NAME: WrapperField = WrapperField("RequestRecordId", FieldType.LONG)
    SAMPLEID__FIELD_NAME: WrapperField = WrapperField("SampleId", FieldType.STRING)
    SAMPLERECORDID__FIELD_NAME: WrapperField = WrapperField("SampleRecordId", FieldType.LONG)
    SCHEDULEDDATE__FIELD_NAME: WrapperField = WrapperField("ScheduledDate", FieldType.DATE)
    SOURCEASSIGNEDPROCESSIDS__FIELD_NAME: WrapperField = WrapperField("SourceAssignedProcessIds", FieldType.STRING)
    STATUS__FIELD_NAME: WrapperField = WrapperField("Status", FieldType.SELECTION)
    TURNAROUNDHOURS__FIELD_NAME: WrapperField = WrapperField("TurnAroundHours", FieldType.LONG)
    TURNAROUNDMINUTES__FIELD_NAME: WrapperField = WrapperField("TurnAroundMinutes", FieldType.LONG)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_AwaitingRequestApproval_field(self, value: Optional[bool]):
        """
        Set data field with field name 'AwaitingRequestApproval' on this record model
        """
        self.set_field_value(self.AWAITINGREQUESTAPPROVAL__FIELD_NAME.field_name, value)

    def get_AwaitingRequestApproval_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'AwaitingRequestApproval' from this record model
        """
        return self.get_field_value(self.AWAITINGREQUESTAPPROVAL__FIELD_NAME.field_name)

    def set_BranchLongId_field(self, value: Optional[int]):
        """
        Set data field with field name 'BranchLongId' on this record model
        """
        self.set_field_value(self.BRANCHLONGID__FIELD_NAME.field_name, value)

    def get_BranchLongId_field(self) -> Optional[int]:
        """
        Get data field value with field name 'BranchLongId' from this record model
        """
        return self.get_field_value(self.BRANCHLONGID__FIELD_NAME.field_name)

    def set_CompletedDate_field(self, value: Optional[int]):
        """
        Set data field with field name 'CompletedDate' on this record model
        """
        self.set_field_value(self.COMPLETEDDATE__FIELD_NAME.field_name, value)

    def get_CompletedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'CompletedDate' from this record model
        """
        return self.get_field_value(self.COMPLETEDDATE__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_DoNotProceed_field(self, value: Optional[bool]):
        """
        Set data field with field name 'DoNotProceed' on this record model
        """
        self.set_field_value(self.DONOTPROCEED__FIELD_NAME.field_name, value)

    def get_DoNotProceed_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'DoNotProceed' from this record model
        """
        return self.get_field_value(self.DONOTPROCEED__FIELD_NAME.field_name)

    def set_HasBeenReprocessed_field(self, value: Optional[bool]):
        """
        Set data field with field name 'HasBeenReprocessed' on this record model
        """
        self.set_field_value(self.HASBEENREPROCESSED__FIELD_NAME.field_name, value)

    def get_HasBeenReprocessed_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'HasBeenReprocessed' from this record model
        """
        return self.get_field_value(self.HASBEENREPROCESSED__FIELD_NAME.field_name)

    def set_OtherSampleId_field(self, value: Optional[str]):
        """
        Set data field with field name 'OtherSampleId' on this record model
        """
        self.set_field_value(self.OTHERSAMPLEID__FIELD_NAME.field_name, value)

    def get_OtherSampleId_field(self) -> Optional[str]:
        """
        Get data field value with field name 'OtherSampleId' from this record model
        """
        return self.get_field_value(self.OTHERSAMPLEID__FIELD_NAME.field_name)

    def set_PauseTracking_field(self, value: Optional[bool]):
        """
        Set data field with field name 'PauseTracking' on this record model
        """
        self.set_field_value(self.PAUSETRACKING__FIELD_NAME.field_name, value)

    def get_PauseTracking_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'PauseTracking' from this record model
        """
        return self.get_field_value(self.PAUSETRACKING__FIELD_NAME.field_name)

    def set_ProcessName_field(self, value: Optional[str]):
        """
        Set data field with field name 'ProcessName' on this record model
        """
        self.set_field_value(self.PROCESSNAME__FIELD_NAME.field_name, value)

    def get_ProcessName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ProcessName' from this record model
        """
        return self.get_field_value(self.PROCESSNAME__FIELD_NAME.field_name)

    def set_ProcessStepNumber_field(self, value: Optional[int]):
        """
        Set data field with field name 'ProcessStepNumber' on this record model
        """
        self.set_field_value(self.PROCESSSTEPNUMBER__FIELD_NAME.field_name, value)

    def get_ProcessStepNumber_field(self) -> Optional[int]:
        """
        Get data field value with field name 'ProcessStepNumber' from this record model
        """
        return self.get_field_value(self.PROCESSSTEPNUMBER__FIELD_NAME.field_name)

    def set_ProcessTAT_field(self, value: Optional[float]):
        """
        Set data field with field name 'ProcessTAT' on this record model
        """
        self.set_field_value(self.PROCESSTAT__FIELD_NAME.field_name, value)

    def get_ProcessTAT_field(self) -> Optional[float]:
        """
        Get data field value with field name 'ProcessTAT' from this record model
        """
        return self.get_field_value(self.PROCESSTAT__FIELD_NAME.field_name)

    def set_Reprocessing_field(self, value: Optional[bool]):
        """
        Set data field with field name 'Reprocessing' on this record model
        """
        self.set_field_value(self.REPROCESSING__FIELD_NAME.field_name, value)

    def get_Reprocessing_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'Reprocessing' from this record model
        """
        return self.get_field_value(self.REPROCESSING__FIELD_NAME.field_name)

    def set_RequestRecordId_field(self, value: Optional[int]):
        """
        Set data field with field name 'RequestRecordId' on this record model
        """
        self.set_field_value(self.REQUESTRECORDID__FIELD_NAME.field_name, value)

    def get_RequestRecordId_field(self) -> Optional[int]:
        """
        Get data field value with field name 'RequestRecordId' from this record model
        """
        return self.get_field_value(self.REQUESTRECORDID__FIELD_NAME.field_name)

    def set_SampleId_field(self, value: Optional[str]):
        """
        Set data field with field name 'SampleId' on this record model
        """
        self.set_field_value(self.SAMPLEID__FIELD_NAME.field_name, value)

    def get_SampleId_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SampleId' from this record model
        """
        return self.get_field_value(self.SAMPLEID__FIELD_NAME.field_name)

    def set_SampleRecordId_field(self, value: Optional[int]):
        """
        Set data field with field name 'SampleRecordId' on this record model
        """
        self.set_field_value(self.SAMPLERECORDID__FIELD_NAME.field_name, value)

    def get_SampleRecordId_field(self) -> Optional[int]:
        """
        Get data field value with field name 'SampleRecordId' from this record model
        """
        return self.get_field_value(self.SAMPLERECORDID__FIELD_NAME.field_name)

    def set_ScheduledDate_field(self, value: Optional[int]):
        """
        Set data field with field name 'ScheduledDate' on this record model
        """
        self.set_field_value(self.SCHEDULEDDATE__FIELD_NAME.field_name, value)

    def get_ScheduledDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'ScheduledDate' from this record model
        """
        return self.get_field_value(self.SCHEDULEDDATE__FIELD_NAME.field_name)

    def set_SourceAssignedProcessIds_field(self, value: Optional[str]):
        """
        Set data field with field name 'SourceAssignedProcessIds' on this record model
        """
        self.set_field_value(self.SOURCEASSIGNEDPROCESSIDS__FIELD_NAME.field_name, value)

    def get_SourceAssignedProcessIds_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SourceAssignedProcessIds' from this record model
        """
        return self.get_field_value(self.SOURCEASSIGNEDPROCESSIDS__FIELD_NAME.field_name)

    def set_Status_field(self, value: Optional[str]):
        """
        Set data field with field name 'Status' on this record model
        """
        self.set_field_value(self.STATUS__FIELD_NAME.field_name, value)

    def get_Status_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Status' from this record model
        """
        return self.get_field_value(self.STATUS__FIELD_NAME.field_name)

    def set_TurnAroundHours_field(self, value: Optional[int]):
        """
        Set data field with field name 'TurnAroundHours' on this record model
        """
        self.set_field_value(self.TURNAROUNDHOURS__FIELD_NAME.field_name, value)

    def get_TurnAroundHours_field(self) -> Optional[int]:
        """
        Get data field value with field name 'TurnAroundHours' from this record model
        """
        return self.get_field_value(self.TURNAROUNDHOURS__FIELD_NAME.field_name)

    def set_TurnAroundMinutes_field(self, value: Optional[int]):
        """
        Set data field with field name 'TurnAroundMinutes' on this record model
        """
        self.set_field_value(self.TURNAROUNDMINUTES__FIELD_NAME.field_name, value)

    def get_TurnAroundMinutes_field(self) -> Optional[int]:
        """
        Get data field value with field name 'TurnAroundMinutes' from this record model
        """
        return self.get_field_value(self.TURNAROUNDMINUTES__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class AttachmentModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type Attachment
    Data Type Display Name: Attachment (Attachments)
    Fields: AttachmentId, Comments, CreatedBy, DataRecordName, DateCreated, Description, FilePath, IsGeneratedByReportBuilder, MultiParentLink175, MultiParentLink179, MultiParentLink215, MultiParentLink230, MultiParentLink308, TestBoolean, V_AttachmentId, V_Comments, V_VersionNumber, VeloxCurrentVersion, VeloxLastModifiedBy, VeloxLastModifiedDate, VersionNumber, Volume
    Data type for document attachments
    """
    DATA_TYPE_NAME: str = 'Attachment'
    ATTACHMENTID__FIELD_NAME: WrapperField = WrapperField("AttachmentId", FieldType.STRING)
    COMMENTS__FIELD_NAME: WrapperField = WrapperField("Comments", FieldType.STRING)
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    DESCRIPTION__FIELD_NAME: WrapperField = WrapperField("Description", FieldType.STRING)
    FILEPATH__FIELD_NAME: WrapperField = WrapperField("FilePath", FieldType.STRING)
    ISGENERATEDBYREPORTBUILDER__FIELD_NAME: WrapperField = WrapperField("IsGeneratedByReportBuilder", FieldType.BOOLEAN)
    MULTIPARENTLINK175__FIELD_NAME: WrapperField = WrapperField("MultiParentLink175", FieldType.MULTIPARENTLINK)
    MULTIPARENTLINK179__FIELD_NAME: WrapperField = WrapperField("MultiParentLink179", FieldType.MULTIPARENTLINK)
    MULTIPARENTLINK215__FIELD_NAME: WrapperField = WrapperField("MultiParentLink215", FieldType.MULTIPARENTLINK)
    MULTIPARENTLINK230__FIELD_NAME: WrapperField = WrapperField("MultiParentLink230", FieldType.MULTIPARENTLINK)
    MULTIPARENTLINK308__FIELD_NAME: WrapperField = WrapperField("MultiParentLink308", FieldType.MULTIPARENTLINK)
    TESTBOOLEAN__FIELD_NAME: WrapperField = WrapperField("TestBoolean", FieldType.BOOLEAN)
    V_ATTACHMENTID__FIELD_NAME: WrapperField = WrapperField("V_AttachmentId", FieldType.STRING)
    V_COMMENTS__FIELD_NAME: WrapperField = WrapperField("V_Comments", FieldType.STRING)
    V_VERSIONNUMBER__FIELD_NAME: WrapperField = WrapperField("V_VersionNumber", FieldType.STRING)
    VELOXCURRENTVERSION__FIELD_NAME: WrapperField = WrapperField("VeloxCurrentVersion", FieldType.INTEGER)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)
    VERSIONNUMBER__FIELD_NAME: WrapperField = WrapperField("VersionNumber", FieldType.STRING)
    VOLUME__FIELD_NAME: WrapperField = WrapperField("Volume", FieldType.INTEGER)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_AttachmentId_field(self, value: Optional[str]):
        """
        Set data field with field name 'AttachmentId' on this record model
        """
        self.set_field_value(self.ATTACHMENTID__FIELD_NAME.field_name, value)

    def get_AttachmentId_field(self) -> Optional[str]:
        """
        Get data field value with field name 'AttachmentId' from this record model
        """
        return self.get_field_value(self.ATTACHMENTID__FIELD_NAME.field_name)

    def set_Comments_field(self, value: Optional[str]):
        """
        Set data field with field name 'Comments' on this record model
        """
        self.set_field_value(self.COMMENTS__FIELD_NAME.field_name, value)

    def get_Comments_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Comments' from this record model
        """
        return self.get_field_value(self.COMMENTS__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_Description_field(self, value: Optional[str]):
        """
        Set data field with field name 'Description' on this record model
        """
        self.set_field_value(self.DESCRIPTION__FIELD_NAME.field_name, value)

    def get_Description_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Description' from this record model
        """
        return self.get_field_value(self.DESCRIPTION__FIELD_NAME.field_name)

    def set_FilePath_field(self, value: Optional[str]):
        """
        Set data field with field name 'FilePath' on this record model
        """
        self.set_field_value(self.FILEPATH__FIELD_NAME.field_name, value)

    def get_FilePath_field(self) -> Optional[str]:
        """
        Get data field value with field name 'FilePath' from this record model
        """
        return self.get_field_value(self.FILEPATH__FIELD_NAME.field_name)

    def set_IsGeneratedByReportBuilder_field(self, value: Optional[bool]):
        """
        Set data field with field name 'IsGeneratedByReportBuilder' on this record model
        """
        self.set_field_value(self.ISGENERATEDBYREPORTBUILDER__FIELD_NAME.field_name, value)

    def get_IsGeneratedByReportBuilder_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'IsGeneratedByReportBuilder' from this record model
        """
        return self.get_field_value(self.ISGENERATEDBYREPORTBUILDER__FIELD_NAME.field_name)

    def set_TestBoolean_field(self, value: Optional[bool]):
        """
        Set data field with field name 'TestBoolean' on this record model
        """
        self.set_field_value(self.TESTBOOLEAN__FIELD_NAME.field_name, value)

    def get_TestBoolean_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'TestBoolean' from this record model
        """
        return self.get_field_value(self.TESTBOOLEAN__FIELD_NAME.field_name)

    def set_V_AttachmentId_field(self, value: Optional[str]):
        """
        Set data field with field name 'V_AttachmentId' on this record model
        """
        self.set_field_value(self.V_ATTACHMENTID__FIELD_NAME.field_name, value)

    def get_V_AttachmentId_field(self) -> Optional[str]:
        """
        Get data field value with field name 'V_AttachmentId' from this record model
        """
        return self.get_field_value(self.V_ATTACHMENTID__FIELD_NAME.field_name)

    def set_V_Comments_field(self, value: Optional[str]):
        """
        Set data field with field name 'V_Comments' on this record model
        """
        self.set_field_value(self.V_COMMENTS__FIELD_NAME.field_name, value)

    def get_V_Comments_field(self) -> Optional[str]:
        """
        Get data field value with field name 'V_Comments' from this record model
        """
        return self.get_field_value(self.V_COMMENTS__FIELD_NAME.field_name)

    def set_V_VersionNumber_field(self, value: Optional[str]):
        """
        Set data field with field name 'V_VersionNumber' on this record model
        """
        self.set_field_value(self.V_VERSIONNUMBER__FIELD_NAME.field_name, value)

    def get_V_VersionNumber_field(self) -> Optional[str]:
        """
        Get data field value with field name 'V_VersionNumber' from this record model
        """
        return self.get_field_value(self.V_VERSIONNUMBER__FIELD_NAME.field_name)

    def set_VeloxCurrentVersion_field(self, value: Optional[int]):
        """
        Set data field with field name 'VeloxCurrentVersion' on this record model
        """
        self.set_field_value(self.VELOXCURRENTVERSION__FIELD_NAME.field_name, value)

    def get_VeloxCurrentVersion_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxCurrentVersion' from this record model
        """
        return self.get_field_value(self.VELOXCURRENTVERSION__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)

    def set_VersionNumber_field(self, value: Optional[str]):
        """
        Set data field with field name 'VersionNumber' on this record model
        """
        self.set_field_value(self.VERSIONNUMBER__FIELD_NAME.field_name, value)

    def get_VersionNumber_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VersionNumber' from this record model
        """
        return self.get_field_value(self.VERSIONNUMBER__FIELD_NAME.field_name)

    def set_Volume_field(self, value: Optional[int]):
        """
        Set data field with field name 'Volume' on this record model
        """
        self.set_field_value(self.VOLUME__FIELD_NAME.field_name, value)

    def get_Volume_field(self) -> Optional[int]:
        """
        Get data field value with field name 'Volume' from this record model
        """
        return self.get_field_value(self.VOLUME__FIELD_NAME.field_name)


class AW_ANOVASummaryTableModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type AW_ANOVASummaryTable
    Data Type Display Name: ANOVA Summary (ANOVA Summary)
    Fields: CreatedBy, CritF, DataRecordName, DateCreated, DegreeOfFreedom, FValue, GroupName, PrGreaterThanF, Statement, VeloxLastModifiedBy, VeloxLastModifiedDate
    """
    DATA_TYPE_NAME: str = 'AW_ANOVASummaryTable'
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    CRITF__FIELD_NAME: WrapperField = WrapperField("CritF", FieldType.DOUBLE)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    DEGREEOFFREEDOM__FIELD_NAME: WrapperField = WrapperField("DegreeOfFreedom", FieldType.DOUBLE)
    FVALUE__FIELD_NAME: WrapperField = WrapperField("FValue", FieldType.DOUBLE)
    GROUPNAME__FIELD_NAME: WrapperField = WrapperField("GroupName", FieldType.STRING)
    PRGREATERTHANF__FIELD_NAME: WrapperField = WrapperField("PrGreaterThanF", FieldType.DOUBLE)
    STATEMENT__FIELD_NAME: WrapperField = WrapperField("Statement", FieldType.STRING)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def set_CritF_field(self, value: Optional[float]):
        """
        Set data field with field name 'CritF' on this record model
        """
        self.set_field_value(self.CRITF__FIELD_NAME.field_name, value)

    def get_CritF_field(self) -> Optional[float]:
        """
        Get data field value with field name 'CritF' from this record model
        """
        return self.get_field_value(self.CRITF__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_DegreeOfFreedom_field(self, value: Optional[float]):
        """
        Set data field with field name 'DegreeOfFreedom' on this record model
        """
        self.set_field_value(self.DEGREEOFFREEDOM__FIELD_NAME.field_name, value)

    def get_DegreeOfFreedom_field(self) -> Optional[float]:
        """
        Get data field value with field name 'DegreeOfFreedom' from this record model
        """
        return self.get_field_value(self.DEGREEOFFREEDOM__FIELD_NAME.field_name)

    def set_FValue_field(self, value: Optional[float]):
        """
        Set data field with field name 'FValue' on this record model
        """
        self.set_field_value(self.FVALUE__FIELD_NAME.field_name, value)

    def get_FValue_field(self) -> Optional[float]:
        """
        Get data field value with field name 'FValue' from this record model
        """
        return self.get_field_value(self.FVALUE__FIELD_NAME.field_name)

    def set_GroupName_field(self, value: Optional[str]):
        """
        Set data field with field name 'GroupName' on this record model
        """
        self.set_field_value(self.GROUPNAME__FIELD_NAME.field_name, value)

    def get_GroupName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'GroupName' from this record model
        """
        return self.get_field_value(self.GROUPNAME__FIELD_NAME.field_name)

    def set_PrGreaterThanF_field(self, value: Optional[float]):
        """
        Set data field with field name 'PrGreaterThanF' on this record model
        """
        self.set_field_value(self.PRGREATERTHANF__FIELD_NAME.field_name, value)

    def get_PrGreaterThanF_field(self) -> Optional[float]:
        """
        Get data field value with field name 'PrGreaterThanF' from this record model
        """
        return self.get_field_value(self.PRGREATERTHANF__FIELD_NAME.field_name)

    def set_Statement_field(self, value: Optional[str]):
        """
        Set data field with field name 'Statement' on this record model
        """
        self.set_field_value(self.STATEMENT__FIELD_NAME.field_name, value)

    def get_Statement_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Statement' from this record model
        """
        return self.get_field_value(self.STATEMENT__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class AW_CoefficientsModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type AW_Coefficients
    Data Type Display Name: Coefficients (Coefficients)
    Fields: CreatedBy, DataRecordName, DateCreated, Estimate, PValue, SeriesName, StdErr, SummaryName, TValue, VeloxLastModifiedBy, VeloxLastModifiedDate
    """
    DATA_TYPE_NAME: str = 'AW_Coefficients'
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    ESTIMATE__FIELD_NAME: WrapperField = WrapperField("Estimate", FieldType.DOUBLE)
    PVALUE__FIELD_NAME: WrapperField = WrapperField("PValue", FieldType.DOUBLE)
    SERIESNAME__FIELD_NAME: WrapperField = WrapperField("SeriesName", FieldType.STRING)
    STDERR__FIELD_NAME: WrapperField = WrapperField("StdErr", FieldType.DOUBLE)
    SUMMARYNAME__FIELD_NAME: WrapperField = WrapperField("SummaryName", FieldType.STRING)
    TVALUE__FIELD_NAME: WrapperField = WrapperField("TValue", FieldType.DOUBLE)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_Estimate_field(self, value: Optional[float]):
        """
        Set data field with field name 'Estimate' on this record model
        """
        self.set_field_value(self.ESTIMATE__FIELD_NAME.field_name, value)

    def get_Estimate_field(self) -> Optional[float]:
        """
        Get data field value with field name 'Estimate' from this record model
        """
        return self.get_field_value(self.ESTIMATE__FIELD_NAME.field_name)

    def set_PValue_field(self, value: Optional[float]):
        """
        Set data field with field name 'PValue' on this record model
        """
        self.set_field_value(self.PVALUE__FIELD_NAME.field_name, value)

    def get_PValue_field(self) -> Optional[float]:
        """
        Get data field value with field name 'PValue' from this record model
        """
        return self.get_field_value(self.PVALUE__FIELD_NAME.field_name)

    def set_SeriesName_field(self, value: Optional[str]):
        """
        Set data field with field name 'SeriesName' on this record model
        """
        self.set_field_value(self.SERIESNAME__FIELD_NAME.field_name, value)

    def get_SeriesName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SeriesName' from this record model
        """
        return self.get_field_value(self.SERIESNAME__FIELD_NAME.field_name)

    def set_StdErr_field(self, value: Optional[float]):
        """
        Set data field with field name 'StdErr' on this record model
        """
        self.set_field_value(self.STDERR__FIELD_NAME.field_name, value)

    def get_StdErr_field(self) -> Optional[float]:
        """
        Get data field value with field name 'StdErr' from this record model
        """
        return self.get_field_value(self.STDERR__FIELD_NAME.field_name)

    def set_SummaryName_field(self, value: Optional[str]):
        """
        Set data field with field name 'SummaryName' on this record model
        """
        self.set_field_value(self.SUMMARYNAME__FIELD_NAME.field_name, value)

    def get_SummaryName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SummaryName' from this record model
        """
        return self.get_field_value(self.SUMMARYNAME__FIELD_NAME.field_name)

    def set_TValue_field(self, value: Optional[float]):
        """
        Set data field with field name 'TValue' on this record model
        """
        self.set_field_value(self.TVALUE__FIELD_NAME.field_name, value)

    def get_TValue_field(self) -> Optional[float]:
        """
        Get data field value with field name 'TValue' from this record model
        """
        return self.get_field_value(self.TVALUE__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class AW_EDValueModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type AW_EDValue
    Data Type Display Name: ED-Value (ED-Values)
    Fields: CreatedBy, DataRecordName, DateCreated, EDStdErr, EDValue, SeriesName, SummaryName, VeloxLastModifiedBy, VeloxLastModifiedDate
    """
    DATA_TYPE_NAME: str = 'AW_EDValue'
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    EDSTDERR__FIELD_NAME: WrapperField = WrapperField("EDStdErr", FieldType.DOUBLE)
    EDVALUE__FIELD_NAME: WrapperField = WrapperField("EDValue", FieldType.DOUBLE)
    SERIESNAME__FIELD_NAME: WrapperField = WrapperField("SeriesName", FieldType.STRING)
    SUMMARYNAME__FIELD_NAME: WrapperField = WrapperField("SummaryName", FieldType.STRING)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_EDStdErr_field(self, value: Optional[float]):
        """
        Set data field with field name 'EDStdErr' on this record model
        """
        self.set_field_value(self.EDSTDERR__FIELD_NAME.field_name, value)

    def get_EDStdErr_field(self) -> Optional[float]:
        """
        Get data field value with field name 'EDStdErr' from this record model
        """
        return self.get_field_value(self.EDSTDERR__FIELD_NAME.field_name)

    def set_EDValue_field(self, value: Optional[float]):
        """
        Set data field with field name 'EDValue' on this record model
        """
        self.set_field_value(self.EDVALUE__FIELD_NAME.field_name, value)

    def get_EDValue_field(self) -> Optional[float]:
        """
        Get data field value with field name 'EDValue' from this record model
        """
        return self.get_field_value(self.EDVALUE__FIELD_NAME.field_name)

    def set_SeriesName_field(self, value: Optional[str]):
        """
        Set data field with field name 'SeriesName' on this record model
        """
        self.set_field_value(self.SERIESNAME__FIELD_NAME.field_name, value)

    def get_SeriesName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SeriesName' from this record model
        """
        return self.get_field_value(self.SERIESNAME__FIELD_NAME.field_name)

    def set_SummaryName_field(self, value: Optional[str]):
        """
        Set data field with field name 'SummaryName' on this record model
        """
        self.set_field_value(self.SUMMARYNAME__FIELD_NAME.field_name, value)

    def get_SummaryName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SummaryName' from this record model
        """
        return self.get_field_value(self.SUMMARYNAME__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class AW_GenericSummaryTableModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type AW_GenericSummaryTable
    Data Type Display Name: Summary (Summary)
    Fields: CreatedBy, DataRecordName, DateCreated, SummaryName, SummaryValue, VeloxLastModifiedBy, VeloxLastModifiedDate
    """
    DATA_TYPE_NAME: str = 'AW_GenericSummaryTable'
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    SUMMARYNAME__FIELD_NAME: WrapperField = WrapperField("SummaryName", FieldType.STRING)
    SUMMARYVALUE__FIELD_NAME: WrapperField = WrapperField("SummaryValue", FieldType.STRING)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_SummaryName_field(self, value: Optional[str]):
        """
        Set data field with field name 'SummaryName' on this record model
        """
        self.set_field_value(self.SUMMARYNAME__FIELD_NAME.field_name, value)

    def get_SummaryName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SummaryName' from this record model
        """
        return self.get_field_value(self.SUMMARYNAME__FIELD_NAME.field_name)

    def set_SummaryValue_field(self, value: Optional[str]):
        """
        Set data field with field name 'SummaryValue' on this record model
        """
        self.set_field_value(self.SUMMARYVALUE__FIELD_NAME.field_name, value)

    def get_SummaryValue_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SummaryValue' from this record model
        """
        return self.get_field_value(self.SUMMARYVALUE__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class AW_ProphetPredictionDFModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type AW_ProphetPredictionDF
    Data Type Display Name: Prophet Prediction Frame (Prophet Prediction Frames)
    Fields: additive_terms, additive_terms_lower, additive_terms_upper, CreatedBy, daily, daily_lower, daily_upper, DataRecordName, DateCreated, ds, multiplicative_terms, multiplicative_terms_lower, multiplicative_terms_upper, trend, trend_lower, trend_upper, VeloxLastModifiedBy, VeloxLastModifiedDate, weekly, weekly_lower, weekly_upper, yhat, yhat_lower, yhat_upper
    """
    DATA_TYPE_NAME: str = 'AW_ProphetPredictionDF'
    ADDITIVE_TERMS__FIELD_NAME: WrapperField = WrapperField("additive_terms", FieldType.DOUBLE)
    ADDITIVE_TERMS_LOWER__FIELD_NAME: WrapperField = WrapperField("additive_terms_lower", FieldType.DOUBLE)
    ADDITIVE_TERMS_UPPER__FIELD_NAME: WrapperField = WrapperField("additive_terms_upper", FieldType.DOUBLE)
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DAILY__FIELD_NAME: WrapperField = WrapperField("daily", FieldType.DOUBLE)
    DAILY_LOWER__FIELD_NAME: WrapperField = WrapperField("daily_lower", FieldType.DOUBLE)
    DAILY_UPPER__FIELD_NAME: WrapperField = WrapperField("daily_upper", FieldType.DOUBLE)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    DS__FIELD_NAME: WrapperField = WrapperField("ds", FieldType.STRING)
    MULTIPLICATIVE_TERMS__FIELD_NAME: WrapperField = WrapperField("multiplicative_terms", FieldType.DOUBLE)
    MULTIPLICATIVE_TERMS_LOWER__FIELD_NAME: WrapperField = WrapperField("multiplicative_terms_lower", FieldType.DOUBLE)
    MULTIPLICATIVE_TERMS_UPPER__FIELD_NAME: WrapperField = WrapperField("multiplicative_terms_upper", FieldType.DOUBLE)
    TREND__FIELD_NAME: WrapperField = WrapperField("trend", FieldType.DOUBLE)
    TREND_LOWER__FIELD_NAME: WrapperField = WrapperField("trend_lower", FieldType.DOUBLE)
    TREND_UPPER__FIELD_NAME: WrapperField = WrapperField("trend_upper", FieldType.DOUBLE)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)
    WEEKLY__FIELD_NAME: WrapperField = WrapperField("weekly", FieldType.DOUBLE)
    WEEKLY_LOWER__FIELD_NAME: WrapperField = WrapperField("weekly_lower", FieldType.DOUBLE)
    WEEKLY_UPPER__FIELD_NAME: WrapperField = WrapperField("weekly_upper", FieldType.DOUBLE)
    YHAT__FIELD_NAME: WrapperField = WrapperField("yhat", FieldType.DOUBLE)
    YHAT_LOWER__FIELD_NAME: WrapperField = WrapperField("yhat_lower", FieldType.DOUBLE)
    YHAT_UPPER__FIELD_NAME: WrapperField = WrapperField("yhat_upper", FieldType.DOUBLE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_additive_terms_field(self, value: Optional[float]):
        """
        Set data field with field name 'additive_terms' on this record model
        """
        self.set_field_value(self.ADDITIVE_TERMS__FIELD_NAME.field_name, value)

    def get_additive_terms_field(self) -> Optional[float]:
        """
        Get data field value with field name 'additive_terms' from this record model
        """
        return self.get_field_value(self.ADDITIVE_TERMS__FIELD_NAME.field_name)

    def set_additive_terms_lower_field(self, value: Optional[float]):
        """
        Set data field with field name 'additive_terms_lower' on this record model
        """
        self.set_field_value(self.ADDITIVE_TERMS_LOWER__FIELD_NAME.field_name, value)

    def get_additive_terms_lower_field(self) -> Optional[float]:
        """
        Get data field value with field name 'additive_terms_lower' from this record model
        """
        return self.get_field_value(self.ADDITIVE_TERMS_LOWER__FIELD_NAME.field_name)

    def set_additive_terms_upper_field(self, value: Optional[float]):
        """
        Set data field with field name 'additive_terms_upper' on this record model
        """
        self.set_field_value(self.ADDITIVE_TERMS_UPPER__FIELD_NAME.field_name, value)

    def get_additive_terms_upper_field(self) -> Optional[float]:
        """
        Get data field value with field name 'additive_terms_upper' from this record model
        """
        return self.get_field_value(self.ADDITIVE_TERMS_UPPER__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def set_daily_field(self, value: Optional[float]):
        """
        Set data field with field name 'daily' on this record model
        """
        self.set_field_value(self.DAILY__FIELD_NAME.field_name, value)

    def get_daily_field(self) -> Optional[float]:
        """
        Get data field value with field name 'daily' from this record model
        """
        return self.get_field_value(self.DAILY__FIELD_NAME.field_name)

    def set_daily_lower_field(self, value: Optional[float]):
        """
        Set data field with field name 'daily_lower' on this record model
        """
        self.set_field_value(self.DAILY_LOWER__FIELD_NAME.field_name, value)

    def get_daily_lower_field(self) -> Optional[float]:
        """
        Get data field value with field name 'daily_lower' from this record model
        """
        return self.get_field_value(self.DAILY_LOWER__FIELD_NAME.field_name)

    def set_daily_upper_field(self, value: Optional[float]):
        """
        Set data field with field name 'daily_upper' on this record model
        """
        self.set_field_value(self.DAILY_UPPER__FIELD_NAME.field_name, value)

    def get_daily_upper_field(self) -> Optional[float]:
        """
        Get data field value with field name 'daily_upper' from this record model
        """
        return self.get_field_value(self.DAILY_UPPER__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_ds_field(self, value: Optional[str]):
        """
        Set data field with field name 'ds' on this record model
        """
        self.set_field_value(self.DS__FIELD_NAME.field_name, value)

    def get_ds_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ds' from this record model
        """
        return self.get_field_value(self.DS__FIELD_NAME.field_name)

    def set_multiplicative_terms_field(self, value: Optional[float]):
        """
        Set data field with field name 'multiplicative_terms' on this record model
        """
        self.set_field_value(self.MULTIPLICATIVE_TERMS__FIELD_NAME.field_name, value)

    def get_multiplicative_terms_field(self) -> Optional[float]:
        """
        Get data field value with field name 'multiplicative_terms' from this record model
        """
        return self.get_field_value(self.MULTIPLICATIVE_TERMS__FIELD_NAME.field_name)

    def set_multiplicative_terms_lower_field(self, value: Optional[float]):
        """
        Set data field with field name 'multiplicative_terms_lower' on this record model
        """
        self.set_field_value(self.MULTIPLICATIVE_TERMS_LOWER__FIELD_NAME.field_name, value)

    def get_multiplicative_terms_lower_field(self) -> Optional[float]:
        """
        Get data field value with field name 'multiplicative_terms_lower' from this record model
        """
        return self.get_field_value(self.MULTIPLICATIVE_TERMS_LOWER__FIELD_NAME.field_name)

    def set_multiplicative_terms_upper_field(self, value: Optional[float]):
        """
        Set data field with field name 'multiplicative_terms_upper' on this record model
        """
        self.set_field_value(self.MULTIPLICATIVE_TERMS_UPPER__FIELD_NAME.field_name, value)

    def get_multiplicative_terms_upper_field(self) -> Optional[float]:
        """
        Get data field value with field name 'multiplicative_terms_upper' from this record model
        """
        return self.get_field_value(self.MULTIPLICATIVE_TERMS_UPPER__FIELD_NAME.field_name)

    def set_trend_field(self, value: Optional[float]):
        """
        Set data field with field name 'trend' on this record model
        """
        self.set_field_value(self.TREND__FIELD_NAME.field_name, value)

    def get_trend_field(self) -> Optional[float]:
        """
        Get data field value with field name 'trend' from this record model
        """
        return self.get_field_value(self.TREND__FIELD_NAME.field_name)

    def set_trend_lower_field(self, value: Optional[float]):
        """
        Set data field with field name 'trend_lower' on this record model
        """
        self.set_field_value(self.TREND_LOWER__FIELD_NAME.field_name, value)

    def get_trend_lower_field(self) -> Optional[float]:
        """
        Get data field value with field name 'trend_lower' from this record model
        """
        return self.get_field_value(self.TREND_LOWER__FIELD_NAME.field_name)

    def set_trend_upper_field(self, value: Optional[float]):
        """
        Set data field with field name 'trend_upper' on this record model
        """
        self.set_field_value(self.TREND_UPPER__FIELD_NAME.field_name, value)

    def get_trend_upper_field(self) -> Optional[float]:
        """
        Get data field value with field name 'trend_upper' from this record model
        """
        return self.get_field_value(self.TREND_UPPER__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)

    def set_weekly_field(self, value: Optional[float]):
        """
        Set data field with field name 'weekly' on this record model
        """
        self.set_field_value(self.WEEKLY__FIELD_NAME.field_name, value)

    def get_weekly_field(self) -> Optional[float]:
        """
        Get data field value with field name 'weekly' from this record model
        """
        return self.get_field_value(self.WEEKLY__FIELD_NAME.field_name)

    def set_weekly_lower_field(self, value: Optional[float]):
        """
        Set data field with field name 'weekly_lower' on this record model
        """
        self.set_field_value(self.WEEKLY_LOWER__FIELD_NAME.field_name, value)

    def get_weekly_lower_field(self) -> Optional[float]:
        """
        Get data field value with field name 'weekly_lower' from this record model
        """
        return self.get_field_value(self.WEEKLY_LOWER__FIELD_NAME.field_name)

    def set_weekly_upper_field(self, value: Optional[float]):
        """
        Set data field with field name 'weekly_upper' on this record model
        """
        self.set_field_value(self.WEEKLY_UPPER__FIELD_NAME.field_name, value)

    def get_weekly_upper_field(self) -> Optional[float]:
        """
        Get data field value with field name 'weekly_upper' from this record model
        """
        return self.get_field_value(self.WEEKLY_UPPER__FIELD_NAME.field_name)

    def set_yhat_field(self, value: Optional[float]):
        """
        Set data field with field name 'yhat' on this record model
        """
        self.set_field_value(self.YHAT__FIELD_NAME.field_name, value)

    def get_yhat_field(self) -> Optional[float]:
        """
        Get data field value with field name 'yhat' from this record model
        """
        return self.get_field_value(self.YHAT__FIELD_NAME.field_name)

    def set_yhat_lower_field(self, value: Optional[float]):
        """
        Set data field with field name 'yhat_lower' on this record model
        """
        self.set_field_value(self.YHAT_LOWER__FIELD_NAME.field_name, value)

    def get_yhat_lower_field(self) -> Optional[float]:
        """
        Get data field value with field name 'yhat_lower' from this record model
        """
        return self.get_field_value(self.YHAT_LOWER__FIELD_NAME.field_name)

    def set_yhat_upper_field(self, value: Optional[float]):
        """
        Set data field with field name 'yhat_upper' on this record model
        """
        self.set_field_value(self.YHAT_UPPER__FIELD_NAME.field_name, value)

    def get_yhat_upper_field(self) -> Optional[float]:
        """
        Get data field value with field name 'yhat_upper' from this record model
        """
        return self.get_field_value(self.YHAT_UPPER__FIELD_NAME.field_name)


class AWSSageMakerClientConfigModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type AWSSageMakerClientConfig
    Data Type Display Name: AWS SageMaker Client Configuration (AWS SageMaker Client Configurations)
    Fields: AccessKeyId, CreatedBy, DataRecordName, DateCreated, Region, SecretKey, VeloxLastModifiedBy, VeloxLastModifiedDate
    """
    DATA_TYPE_NAME: str = 'AWSSageMakerClientConfig'
    ACCESSKEYID__FIELD_NAME: WrapperField = WrapperField("AccessKeyId", FieldType.STRING)
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    REGION__FIELD_NAME: WrapperField = WrapperField("Region", FieldType.STRING)
    SECRETKEY__FIELD_NAME: WrapperField = WrapperField("SecretKey", FieldType.STRING)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_AccessKeyId_field(self, value: Optional[str]):
        """
        Set data field with field name 'AccessKeyId' on this record model
        """
        self.set_field_value(self.ACCESSKEYID__FIELD_NAME.field_name, value)

    def get_AccessKeyId_field(self) -> Optional[str]:
        """
        Get data field value with field name 'AccessKeyId' from this record model
        """
        return self.get_field_value(self.ACCESSKEYID__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_Region_field(self, value: Optional[str]):
        """
        Set data field with field name 'Region' on this record model
        """
        self.set_field_value(self.REGION__FIELD_NAME.field_name, value)

    def get_Region_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Region' from this record model
        """
        return self.get_field_value(self.REGION__FIELD_NAME.field_name)

    def set_SecretKey_field(self, value: Optional[str]):
        """
        Set data field with field name 'SecretKey' on this record model
        """
        self.set_field_value(self.SECRETKEY__FIELD_NAME.field_name, value)

    def get_SecretKey_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SecretKey' from this record model
        """
        return self.get_field_value(self.SECRETKEY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class BarcodeConfigModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type BarcodeConfig
    Data Type Display Name: Barcode Configuration (Barcode Configurations)
    Fields: BarcodeConfigName, CreatedBy, CustomPluginClassPath, DataRecordName, DataType, DateCreated, DefaultPrinter, Field1, Field2, Field3, Field4, Field5, Field6, Field7, Field8, Field9, Field10, VeloxLastModifiedBy, VeloxLastModifiedDate
    The Barcode Configurations Data Type
    """
    DATA_TYPE_NAME: str = 'BarcodeConfig'
    BARCODECONFIGNAME__FIELD_NAME: WrapperField = WrapperField("BarcodeConfigName", FieldType.STRING)
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    CUSTOMPLUGINCLASSPATH__FIELD_NAME: WrapperField = WrapperField("CustomPluginClassPath", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATATYPE__FIELD_NAME: WrapperField = WrapperField("DataType", FieldType.SELECTION)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    DEFAULTPRINTER__FIELD_NAME: WrapperField = WrapperField("DefaultPrinter", FieldType.SELECTION)
    FIELD1__FIELD_NAME: WrapperField = WrapperField("Field1", FieldType.SELECTION)
    FIELD2__FIELD_NAME: WrapperField = WrapperField("Field2", FieldType.SELECTION)
    FIELD3__FIELD_NAME: WrapperField = WrapperField("Field3", FieldType.SELECTION)
    FIELD4__FIELD_NAME: WrapperField = WrapperField("Field4", FieldType.SELECTION)
    FIELD5__FIELD_NAME: WrapperField = WrapperField("Field5", FieldType.SELECTION)
    FIELD6__FIELD_NAME: WrapperField = WrapperField("Field6", FieldType.SELECTION)
    FIELD7__FIELD_NAME: WrapperField = WrapperField("Field7", FieldType.SELECTION)
    FIELD8__FIELD_NAME: WrapperField = WrapperField("Field8", FieldType.SELECTION)
    FIELD9__FIELD_NAME: WrapperField = WrapperField("Field9", FieldType.SELECTION)
    FIELD10__FIELD_NAME: WrapperField = WrapperField("Field10", FieldType.SELECTION)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_BarcodeConfigName_field(self, value: Optional[str]):
        """
        Set data field with field name 'BarcodeConfigName' on this record model
        """
        self.set_field_value(self.BARCODECONFIGNAME__FIELD_NAME.field_name, value)

    def get_BarcodeConfigName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'BarcodeConfigName' from this record model
        """
        return self.get_field_value(self.BARCODECONFIGNAME__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def set_CustomPluginClassPath_field(self, value: Optional[str]):
        """
        Set data field with field name 'CustomPluginClassPath' on this record model
        """
        self.set_field_value(self.CUSTOMPLUGINCLASSPATH__FIELD_NAME.field_name, value)

    def get_CustomPluginClassPath_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CustomPluginClassPath' from this record model
        """
        return self.get_field_value(self.CUSTOMPLUGINCLASSPATH__FIELD_NAME.field_name)

    def set_DataType_field(self, value: Optional[str]):
        """
        Set data field with field name 'DataType' on this record model
        """
        self.set_field_value(self.DATATYPE__FIELD_NAME.field_name, value)

    def get_DataType_field(self) -> Optional[str]:
        """
        Get data field value with field name 'DataType' from this record model
        """
        return self.get_field_value(self.DATATYPE__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_DefaultPrinter_field(self, value: Optional[str]):
        """
        Set data field with field name 'DefaultPrinter' on this record model
        """
        self.set_field_value(self.DEFAULTPRINTER__FIELD_NAME.field_name, value)

    def get_DefaultPrinter_field(self) -> Optional[str]:
        """
        Get data field value with field name 'DefaultPrinter' from this record model
        """
        return self.get_field_value(self.DEFAULTPRINTER__FIELD_NAME.field_name)

    def set_Field1_field(self, value: Optional[str]):
        """
        Set data field with field name 'Field1' on this record model
        """
        self.set_field_value(self.FIELD1__FIELD_NAME.field_name, value)

    def get_Field1_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Field1' from this record model
        """
        return self.get_field_value(self.FIELD1__FIELD_NAME.field_name)

    def set_Field2_field(self, value: Optional[str]):
        """
        Set data field with field name 'Field2' on this record model
        """
        self.set_field_value(self.FIELD2__FIELD_NAME.field_name, value)

    def get_Field2_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Field2' from this record model
        """
        return self.get_field_value(self.FIELD2__FIELD_NAME.field_name)

    def set_Field3_field(self, value: Optional[str]):
        """
        Set data field with field name 'Field3' on this record model
        """
        self.set_field_value(self.FIELD3__FIELD_NAME.field_name, value)

    def get_Field3_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Field3' from this record model
        """
        return self.get_field_value(self.FIELD3__FIELD_NAME.field_name)

    def set_Field4_field(self, value: Optional[str]):
        """
        Set data field with field name 'Field4' on this record model
        """
        self.set_field_value(self.FIELD4__FIELD_NAME.field_name, value)

    def get_Field4_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Field4' from this record model
        """
        return self.get_field_value(self.FIELD4__FIELD_NAME.field_name)

    def set_Field5_field(self, value: Optional[str]):
        """
        Set data field with field name 'Field5' on this record model
        """
        self.set_field_value(self.FIELD5__FIELD_NAME.field_name, value)

    def get_Field5_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Field5' from this record model
        """
        return self.get_field_value(self.FIELD5__FIELD_NAME.field_name)

    def set_Field6_field(self, value: Optional[str]):
        """
        Set data field with field name 'Field6' on this record model
        """
        self.set_field_value(self.FIELD6__FIELD_NAME.field_name, value)

    def get_Field6_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Field6' from this record model
        """
        return self.get_field_value(self.FIELD6__FIELD_NAME.field_name)

    def set_Field7_field(self, value: Optional[str]):
        """
        Set data field with field name 'Field7' on this record model
        """
        self.set_field_value(self.FIELD7__FIELD_NAME.field_name, value)

    def get_Field7_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Field7' from this record model
        """
        return self.get_field_value(self.FIELD7__FIELD_NAME.field_name)

    def set_Field8_field(self, value: Optional[str]):
        """
        Set data field with field name 'Field8' on this record model
        """
        self.set_field_value(self.FIELD8__FIELD_NAME.field_name, value)

    def get_Field8_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Field8' from this record model
        """
        return self.get_field_value(self.FIELD8__FIELD_NAME.field_name)

    def set_Field9_field(self, value: Optional[str]):
        """
        Set data field with field name 'Field9' on this record model
        """
        self.set_field_value(self.FIELD9__FIELD_NAME.field_name, value)

    def get_Field9_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Field9' from this record model
        """
        return self.get_field_value(self.FIELD9__FIELD_NAME.field_name)

    def set_Field10_field(self, value: Optional[str]):
        """
        Set data field with field name 'Field10' on this record model
        """
        self.set_field_value(self.FIELD10__FIELD_NAME.field_name, value)

    def get_Field10_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Field10' from this record model
        """
        return self.get_field_value(self.FIELD10__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class Basic3DScatterDataModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type Basic3DScatterData
    Data Type Display Name: Basic 3D Scatter Datum (Basic 3D Scatter Data)
    Fields: CreatedBy, DataRecordName, DateCreated, VeloxLastModifiedBy, VeloxLastModifiedDate, x, y, z
    """
    DATA_TYPE_NAME: str = 'Basic3DScatterData'
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)
    X__FIELD_NAME: WrapperField = WrapperField("x", FieldType.DOUBLE)
    Y__FIELD_NAME: WrapperField = WrapperField("y", FieldType.DOUBLE)
    Z__FIELD_NAME: WrapperField = WrapperField("z", FieldType.DOUBLE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)

    def set_x_field(self, value: Optional[float]):
        """
        Set data field with field name 'x' on this record model
        """
        self.set_field_value(self.X__FIELD_NAME.field_name, value)

    def get_x_field(self) -> Optional[float]:
        """
        Get data field value with field name 'x' from this record model
        """
        return self.get_field_value(self.X__FIELD_NAME.field_name)

    def set_y_field(self, value: Optional[float]):
        """
        Set data field with field name 'y' on this record model
        """
        self.set_field_value(self.Y__FIELD_NAME.field_name, value)

    def get_y_field(self) -> Optional[float]:
        """
        Get data field value with field name 'y' from this record model
        """
        return self.get_field_value(self.Y__FIELD_NAME.field_name)

    def set_z_field(self, value: Optional[float]):
        """
        Set data field with field name 'z' on this record model
        """
        self.set_field_value(self.Z__FIELD_NAME.field_name, value)

    def get_z_field(self) -> Optional[float]:
        """
        Get data field value with field name 'z' from this record model
        """
        return self.get_field_value(self.Z__FIELD_NAME.field_name)


class BasicIsoSurfacePlotExampleModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type BasicIsoSurfacePlotExample
    Data Type Display Name: Basic Iso Surface Plot Example (Basic Iso Surface Plot Examples)
    Fields: CreatedBy, DataRecordName, DateCreated, Svalue, VeloxLastModifiedBy, VeloxLastModifiedDate, x, y, z
    """
    DATA_TYPE_NAME: str = 'BasicIsoSurfacePlotExample'
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    SVALUE__FIELD_NAME: WrapperField = WrapperField("Svalue", FieldType.DOUBLE)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)
    X__FIELD_NAME: WrapperField = WrapperField("x", FieldType.DOUBLE)
    Y__FIELD_NAME: WrapperField = WrapperField("y", FieldType.DOUBLE)
    Z__FIELD_NAME: WrapperField = WrapperField("z", FieldType.DOUBLE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_Svalue_field(self, value: Optional[float]):
        """
        Set data field with field name 'Svalue' on this record model
        """
        self.set_field_value(self.SVALUE__FIELD_NAME.field_name, value)

    def get_Svalue_field(self) -> Optional[float]:
        """
        Get data field value with field name 'Svalue' from this record model
        """
        return self.get_field_value(self.SVALUE__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)

    def set_x_field(self, value: Optional[float]):
        """
        Set data field with field name 'x' on this record model
        """
        self.set_field_value(self.X__FIELD_NAME.field_name, value)

    def get_x_field(self) -> Optional[float]:
        """
        Get data field value with field name 'x' from this record model
        """
        return self.get_field_value(self.X__FIELD_NAME.field_name)

    def set_y_field(self, value: Optional[float]):
        """
        Set data field with field name 'y' on this record model
        """
        self.set_field_value(self.Y__FIELD_NAME.field_name, value)

    def get_y_field(self) -> Optional[float]:
        """
        Get data field value with field name 'y' from this record model
        """
        return self.get_field_value(self.Y__FIELD_NAME.field_name)

    def set_z_field(self, value: Optional[float]):
        """
        Set data field with field name 'z' on this record model
        """
        self.set_field_value(self.Z__FIELD_NAME.field_name, value)

    def get_z_field(self) -> Optional[float]:
        """
        Get data field value with field name 'z' from this record model
        """
        return self.get_field_value(self.Z__FIELD_NAME.field_name)


class BatchModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type Batch
    Data Type Display Name: Batch (Batches)
    Fields: AssignedTo, BatchId, BatchName, CreatedBy, DataRecordName, DateCreated, ExemplarBatchStatus, NumberOfSamples, PriorityLevel, StartDate, VeloxLastModifiedBy, VeloxLastModifiedDate, WorkflowName
    """
    DATA_TYPE_NAME: str = 'Batch'
    ASSIGNEDTO__FIELD_NAME: WrapperField = WrapperField("AssignedTo", FieldType.SELECTION)
    BATCHID__FIELD_NAME: WrapperField = WrapperField("BatchId", FieldType.STRING)
    BATCHNAME__FIELD_NAME: WrapperField = WrapperField("BatchName", FieldType.STRING)
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    EXEMPLARBATCHSTATUS__FIELD_NAME: WrapperField = WrapperField("ExemplarBatchStatus", FieldType.SELECTION)
    NUMBEROFSAMPLES__FIELD_NAME: WrapperField = WrapperField("NumberOfSamples", FieldType.LONG)
    PRIORITYLEVEL__FIELD_NAME: WrapperField = WrapperField("PriorityLevel", FieldType.PICKLIST)
    STARTDATE__FIELD_NAME: WrapperField = WrapperField("StartDate", FieldType.DATE)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)
    WORKFLOWNAME__FIELD_NAME: WrapperField = WrapperField("WorkflowName", FieldType.SELECTION)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_AssignedTo_field(self, value: Optional[str]):
        """
        Set data field with field name 'AssignedTo' on this record model
        """
        self.set_field_value(self.ASSIGNEDTO__FIELD_NAME.field_name, value)

    def get_AssignedTo_field(self) -> Optional[str]:
        """
        Get data field value with field name 'AssignedTo' from this record model
        """
        return self.get_field_value(self.ASSIGNEDTO__FIELD_NAME.field_name)

    def set_BatchId_field(self, value: Optional[str]):
        """
        Set data field with field name 'BatchId' on this record model
        """
        self.set_field_value(self.BATCHID__FIELD_NAME.field_name, value)

    def get_BatchId_field(self) -> Optional[str]:
        """
        Get data field value with field name 'BatchId' from this record model
        """
        return self.get_field_value(self.BATCHID__FIELD_NAME.field_name)

    def set_BatchName_field(self, value: Optional[str]):
        """
        Set data field with field name 'BatchName' on this record model
        """
        self.set_field_value(self.BATCHNAME__FIELD_NAME.field_name, value)

    def get_BatchName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'BatchName' from this record model
        """
        return self.get_field_value(self.BATCHNAME__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_ExemplarBatchStatus_field(self, value: Optional[str]):
        """
        Set data field with field name 'ExemplarBatchStatus' on this record model
        """
        self.set_field_value(self.EXEMPLARBATCHSTATUS__FIELD_NAME.field_name, value)

    def get_ExemplarBatchStatus_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ExemplarBatchStatus' from this record model
        """
        return self.get_field_value(self.EXEMPLARBATCHSTATUS__FIELD_NAME.field_name)

    def set_NumberOfSamples_field(self, value: Optional[int]):
        """
        Set data field with field name 'NumberOfSamples' on this record model
        """
        self.set_field_value(self.NUMBEROFSAMPLES__FIELD_NAME.field_name, value)

    def get_NumberOfSamples_field(self) -> Optional[int]:
        """
        Get data field value with field name 'NumberOfSamples' from this record model
        """
        return self.get_field_value(self.NUMBEROFSAMPLES__FIELD_NAME.field_name)

    def set_PriorityLevel_field(self, value: Optional[str]):
        """
        Set data field with field name 'PriorityLevel' on this record model
        """
        self.set_field_value(self.PRIORITYLEVEL__FIELD_NAME.field_name, value)

    def get_PriorityLevel_field(self) -> Optional[str]:
        """
        Get data field value with field name 'PriorityLevel' from this record model
        """
        return self.get_field_value(self.PRIORITYLEVEL__FIELD_NAME.field_name)

    def set_StartDate_field(self, value: Optional[int]):
        """
        Set data field with field name 'StartDate' on this record model
        """
        self.set_field_value(self.STARTDATE__FIELD_NAME.field_name, value)

    def get_StartDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'StartDate' from this record model
        """
        return self.get_field_value(self.STARTDATE__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)

    def set_WorkflowName_field(self, value: Optional[str]):
        """
        Set data field with field name 'WorkflowName' on this record model
        """
        self.set_field_value(self.WORKFLOWNAME__FIELD_NAME.field_name, value)

    def get_WorkflowName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'WorkflowName' from this record model
        """
        return self.get_field_value(self.WORKFLOWNAME__FIELD_NAME.field_name)


class BioAnalyzerResultModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type BioAnalyzerResult
    Data Type Display Name: BioAnalyzer Result (BioAnalyzer Results)
    Fields: Area, AvgBPSize, CreatedBy, DataRecordName, DateCreated, Molarity, MolarityUnits, PeakRegionIdentifier, PeakValue, VeloxLastModifiedBy, VeloxLastModifiedDate
    """
    DATA_TYPE_NAME: str = 'BioAnalyzerResult'
    AREA__FIELD_NAME: WrapperField = WrapperField("Area", FieldType.DOUBLE)
    AVGBPSIZE__FIELD_NAME: WrapperField = WrapperField("AvgBPSize", FieldType.DOUBLE)
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    MOLARITY__FIELD_NAME: WrapperField = WrapperField("Molarity", FieldType.DOUBLE)
    MOLARITYUNITS__FIELD_NAME: WrapperField = WrapperField("MolarityUnits", FieldType.STRING)
    PEAKREGIONIDENTIFIER__FIELD_NAME: WrapperField = WrapperField("PeakRegionIdentifier", FieldType.STRING)
    PEAKVALUE__FIELD_NAME: WrapperField = WrapperField("PeakValue", FieldType.DOUBLE)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_Area_field(self, value: Optional[float]):
        """
        Set data field with field name 'Area' on this record model
        """
        self.set_field_value(self.AREA__FIELD_NAME.field_name, value)

    def get_Area_field(self) -> Optional[float]:
        """
        Get data field value with field name 'Area' from this record model
        """
        return self.get_field_value(self.AREA__FIELD_NAME.field_name)

    def set_AvgBPSize_field(self, value: Optional[float]):
        """
        Set data field with field name 'AvgBPSize' on this record model
        """
        self.set_field_value(self.AVGBPSIZE__FIELD_NAME.field_name, value)

    def get_AvgBPSize_field(self) -> Optional[float]:
        """
        Get data field value with field name 'AvgBPSize' from this record model
        """
        return self.get_field_value(self.AVGBPSIZE__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_Molarity_field(self, value: Optional[float]):
        """
        Set data field with field name 'Molarity' on this record model
        """
        self.set_field_value(self.MOLARITY__FIELD_NAME.field_name, value)

    def get_Molarity_field(self) -> Optional[float]:
        """
        Get data field value with field name 'Molarity' from this record model
        """
        return self.get_field_value(self.MOLARITY__FIELD_NAME.field_name)

    def set_MolarityUnits_field(self, value: Optional[str]):
        """
        Set data field with field name 'MolarityUnits' on this record model
        """
        self.set_field_value(self.MOLARITYUNITS__FIELD_NAME.field_name, value)

    def get_MolarityUnits_field(self) -> Optional[str]:
        """
        Get data field value with field name 'MolarityUnits' from this record model
        """
        return self.get_field_value(self.MOLARITYUNITS__FIELD_NAME.field_name)

    def set_PeakRegionIdentifier_field(self, value: Optional[str]):
        """
        Set data field with field name 'PeakRegionIdentifier' on this record model
        """
        self.set_field_value(self.PEAKREGIONIDENTIFIER__FIELD_NAME.field_name, value)

    def get_PeakRegionIdentifier_field(self) -> Optional[str]:
        """
        Get data field value with field name 'PeakRegionIdentifier' from this record model
        """
        return self.get_field_value(self.PEAKREGIONIDENTIFIER__FIELD_NAME.field_name)

    def set_PeakValue_field(self, value: Optional[float]):
        """
        Set data field with field name 'PeakValue' on this record model
        """
        self.set_field_value(self.PEAKVALUE__FIELD_NAME.field_name, value)

    def get_PeakValue_field(self) -> Optional[float]:
        """
        Get data field value with field name 'PeakValue' from this record model
        """
        return self.get_field_value(self.PEAKVALUE__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class BioConjugateModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type BioConjugate
    Data Type Display Name: Bio Conjugate (Bio Conjugates)
    Fields: ConsumableName, ConsumableType, CreatedBy, DataRecordName, DateCreated, ExpirationDate, LotNumber, RegistryId, VeloxLastModifiedBy, VeloxLastModifiedDate, Vendor
    """
    DATA_TYPE_NAME: str = 'BioConjugate'
    CONSUMABLENAME__FIELD_NAME: WrapperField = WrapperField("ConsumableName", FieldType.STRING)
    CONSUMABLETYPE__FIELD_NAME: WrapperField = WrapperField("ConsumableType", FieldType.SELECTION)
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    EXPIRATIONDATE__FIELD_NAME: WrapperField = WrapperField("ExpirationDate", FieldType.DATE)
    LOTNUMBER__FIELD_NAME: WrapperField = WrapperField("LotNumber", FieldType.STRING)
    REGISTRYID__FIELD_NAME: WrapperField = WrapperField("RegistryId", FieldType.STRING)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)
    VENDOR__FIELD_NAME: WrapperField = WrapperField("Vendor", FieldType.SELECTION)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_ConsumableName_field(self, value: Optional[str]):
        """
        Set data field with field name 'ConsumableName' on this record model
        """
        self.set_field_value(self.CONSUMABLENAME__FIELD_NAME.field_name, value)

    def get_ConsumableName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ConsumableName' from this record model
        """
        return self.get_field_value(self.CONSUMABLENAME__FIELD_NAME.field_name)

    def set_ConsumableType_field(self, value: Optional[str]):
        """
        Set data field with field name 'ConsumableType' on this record model
        """
        self.set_field_value(self.CONSUMABLETYPE__FIELD_NAME.field_name, value)

    def get_ConsumableType_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ConsumableType' from this record model
        """
        return self.get_field_value(self.CONSUMABLETYPE__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_ExpirationDate_field(self, value: Optional[int]):
        """
        Set data field with field name 'ExpirationDate' on this record model
        """
        self.set_field_value(self.EXPIRATIONDATE__FIELD_NAME.field_name, value)

    def get_ExpirationDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'ExpirationDate' from this record model
        """
        return self.get_field_value(self.EXPIRATIONDATE__FIELD_NAME.field_name)

    def set_LotNumber_field(self, value: Optional[str]):
        """
        Set data field with field name 'LotNumber' on this record model
        """
        self.set_field_value(self.LOTNUMBER__FIELD_NAME.field_name, value)

    def get_LotNumber_field(self) -> Optional[str]:
        """
        Get data field value with field name 'LotNumber' from this record model
        """
        return self.get_field_value(self.LOTNUMBER__FIELD_NAME.field_name)

    def set_RegistryId_field(self, value: Optional[str]):
        """
        Set data field with field name 'RegistryId' on this record model
        """
        self.set_field_value(self.REGISTRYID__FIELD_NAME.field_name, value)

    def get_RegistryId_field(self) -> Optional[str]:
        """
        Get data field value with field name 'RegistryId' from this record model
        """
        return self.get_field_value(self.REGISTRYID__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)

    def set_Vendor_field(self, value: Optional[str]):
        """
        Set data field with field name 'Vendor' on this record model
        """
        self.set_field_value(self.VENDOR__FIELD_NAME.field_name, value)

    def get_Vendor_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Vendor' from this record model
        """
        return self.get_field_value(self.VENDOR__FIELD_NAME.field_name)


class BioConjugatePartModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type BioConjugatePart
    Data Type Display Name: Bio Conjugate Part (Bio Conjugate Parts)
    Fields: ChemicalProperties, ConsumableName, ConsumableType, CreatedBy, DataRecordName, DateCreated, HELM, HELMHash, MultiParentLink152, MultiParentLink201, MultiParentLink276, QuantityOnHand, QuantityPerItem, RegistryId, ReorderLevelQuantity, Sequence, SequenceHash, Units, VeloxLastModifiedBy, VeloxLastModifiedDate, Vendor
    """
    DATA_TYPE_NAME: str = 'BioConjugatePart'
    CHEMICALPROPERTIES__FIELD_NAME: WrapperField = WrapperField("ChemicalProperties", FieldType.SIDE_LINK)
    CONSUMABLENAME__FIELD_NAME: WrapperField = WrapperField("ConsumableName", FieldType.STRING)
    CONSUMABLETYPE__FIELD_NAME: WrapperField = WrapperField("ConsumableType", FieldType.SELECTION)
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    HELM__FIELD_NAME: WrapperField = WrapperField("HELM", FieldType.STRING)
    HELMHASH__FIELD_NAME: WrapperField = WrapperField("HELMHash", FieldType.STRING)
    MULTIPARENTLINK152__FIELD_NAME: WrapperField = WrapperField("MultiParentLink152", FieldType.MULTIPARENTLINK)
    MULTIPARENTLINK201__FIELD_NAME: WrapperField = WrapperField("MultiParentLink201", FieldType.MULTIPARENTLINK)
    MULTIPARENTLINK276__FIELD_NAME: WrapperField = WrapperField("MultiParentLink276", FieldType.MULTIPARENTLINK)
    QUANTITYONHAND__FIELD_NAME: WrapperField = WrapperField("QuantityOnHand", FieldType.DOUBLE)
    QUANTITYPERITEM__FIELD_NAME: WrapperField = WrapperField("QuantityPerItem", FieldType.DOUBLE)
    REGISTRYID__FIELD_NAME: WrapperField = WrapperField("RegistryId", FieldType.STRING)
    REORDERLEVELQUANTITY__FIELD_NAME: WrapperField = WrapperField("ReorderLevelQuantity", FieldType.DOUBLE)
    SEQUENCE__FIELD_NAME: WrapperField = WrapperField("Sequence", FieldType.STRING)
    SEQUENCEHASH__FIELD_NAME: WrapperField = WrapperField("SequenceHash", FieldType.STRING)
    UNITS__FIELD_NAME: WrapperField = WrapperField("Units", FieldType.PICKLIST)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)
    VENDOR__FIELD_NAME: WrapperField = WrapperField("Vendor", FieldType.SELECTION)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_ChemicalProperties_field(self, value: Optional[int]):
        """
        Set data field with field name 'ChemicalProperties' on this record model
        """
        self.set_field_value(self.CHEMICALPROPERTIES__FIELD_NAME.field_name, value)

    def get_ChemicalProperties_field(self) -> Optional[int]:
        """
        Get data field value with field name 'ChemicalProperties' from this record model
        """
        return self.get_field_value(self.CHEMICALPROPERTIES__FIELD_NAME.field_name)

    def set_ConsumableName_field(self, value: Optional[str]):
        """
        Set data field with field name 'ConsumableName' on this record model
        """
        self.set_field_value(self.CONSUMABLENAME__FIELD_NAME.field_name, value)

    def get_ConsumableName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ConsumableName' from this record model
        """
        return self.get_field_value(self.CONSUMABLENAME__FIELD_NAME.field_name)

    def set_ConsumableType_field(self, value: Optional[str]):
        """
        Set data field with field name 'ConsumableType' on this record model
        """
        self.set_field_value(self.CONSUMABLETYPE__FIELD_NAME.field_name, value)

    def get_ConsumableType_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ConsumableType' from this record model
        """
        return self.get_field_value(self.CONSUMABLETYPE__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_HELM_field(self, value: Optional[str]):
        """
        Set data field with field name 'HELM' on this record model
        """
        self.set_field_value(self.HELM__FIELD_NAME.field_name, value)

    def get_HELM_field(self) -> Optional[str]:
        """
        Get data field value with field name 'HELM' from this record model
        """
        return self.get_field_value(self.HELM__FIELD_NAME.field_name)

    def set_HELMHash_field(self, value: Optional[str]):
        """
        Set data field with field name 'HELMHash' on this record model
        """
        self.set_field_value(self.HELMHASH__FIELD_NAME.field_name, value)

    def get_HELMHash_field(self) -> Optional[str]:
        """
        Get data field value with field name 'HELMHash' from this record model
        """
        return self.get_field_value(self.HELMHASH__FIELD_NAME.field_name)

    def set_QuantityOnHand_field(self, value: Optional[float]):
        """
        Set data field with field name 'QuantityOnHand' on this record model
        """
        self.set_field_value(self.QUANTITYONHAND__FIELD_NAME.field_name, value)

    def get_QuantityOnHand_field(self) -> Optional[float]:
        """
        Get data field value with field name 'QuantityOnHand' from this record model
        """
        return self.get_field_value(self.QUANTITYONHAND__FIELD_NAME.field_name)

    def set_QuantityPerItem_field(self, value: Optional[float]):
        """
        Set data field with field name 'QuantityPerItem' on this record model
        """
        self.set_field_value(self.QUANTITYPERITEM__FIELD_NAME.field_name, value)

    def get_QuantityPerItem_field(self) -> Optional[float]:
        """
        Get data field value with field name 'QuantityPerItem' from this record model
        """
        return self.get_field_value(self.QUANTITYPERITEM__FIELD_NAME.field_name)

    def set_RegistryId_field(self, value: Optional[str]):
        """
        Set data field with field name 'RegistryId' on this record model
        """
        self.set_field_value(self.REGISTRYID__FIELD_NAME.field_name, value)

    def get_RegistryId_field(self) -> Optional[str]:
        """
        Get data field value with field name 'RegistryId' from this record model
        """
        return self.get_field_value(self.REGISTRYID__FIELD_NAME.field_name)

    def set_ReorderLevelQuantity_field(self, value: Optional[float]):
        """
        Set data field with field name 'ReorderLevelQuantity' on this record model
        """
        self.set_field_value(self.REORDERLEVELQUANTITY__FIELD_NAME.field_name, value)

    def get_ReorderLevelQuantity_field(self) -> Optional[float]:
        """
        Get data field value with field name 'ReorderLevelQuantity' from this record model
        """
        return self.get_field_value(self.REORDERLEVELQUANTITY__FIELD_NAME.field_name)

    def set_Sequence_field(self, value: Optional[str]):
        """
        Set data field with field name 'Sequence' on this record model
        """
        self.set_field_value(self.SEQUENCE__FIELD_NAME.field_name, value)

    def get_Sequence_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Sequence' from this record model
        """
        return self.get_field_value(self.SEQUENCE__FIELD_NAME.field_name)

    def set_SequenceHash_field(self, value: Optional[str]):
        """
        Set data field with field name 'SequenceHash' on this record model
        """
        self.set_field_value(self.SEQUENCEHASH__FIELD_NAME.field_name, value)

    def get_SequenceHash_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SequenceHash' from this record model
        """
        return self.get_field_value(self.SEQUENCEHASH__FIELD_NAME.field_name)

    def set_Units_field(self, value: Optional[str]):
        """
        Set data field with field name 'Units' on this record model
        """
        self.set_field_value(self.UNITS__FIELD_NAME.field_name, value)

    def get_Units_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Units' from this record model
        """
        return self.get_field_value(self.UNITS__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)

    def set_Vendor_field(self, value: Optional[str]):
        """
        Set data field with field name 'Vendor' on this record model
        """
        self.set_field_value(self.VENDOR__FIELD_NAME.field_name, value)

    def get_Vendor_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Vendor' from this record model
        """
        return self.get_field_value(self.VENDOR__FIELD_NAME.field_name)


class BioRadResultModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type BioRadResult
    Data Type Display Name: Bio-Rad qPCR Result (Bio-Rad qPCR Results)
    Fields: BiologicalSetName, Content, Cq, CqMean, CqStdDev, CreatedBy, DataRecordName, DateCreated, Fluor, LogStartingQuantity, SetPoint, SQMean, SQStdDev, Target, VeloxLastModifiedBy, VeloxLastModifiedDate, WellNote
    """
    DATA_TYPE_NAME: str = 'BioRadResult'
    BIOLOGICALSETNAME__FIELD_NAME: WrapperField = WrapperField("BiologicalSetName", FieldType.STRING)
    CONTENT__FIELD_NAME: WrapperField = WrapperField("Content", FieldType.STRING)
    CQ__FIELD_NAME: WrapperField = WrapperField("Cq", FieldType.DOUBLE)
    CQMEAN__FIELD_NAME: WrapperField = WrapperField("CqMean", FieldType.DOUBLE)
    CQSTDDEV__FIELD_NAME: WrapperField = WrapperField("CqStdDev", FieldType.DOUBLE)
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    FLUOR__FIELD_NAME: WrapperField = WrapperField("Fluor", FieldType.STRING)
    LOGSTARTINGQUANTITY__FIELD_NAME: WrapperField = WrapperField("LogStartingQuantity", FieldType.DOUBLE)
    SETPOINT__FIELD_NAME: WrapperField = WrapperField("SetPoint", FieldType.DOUBLE)
    SQMEAN__FIELD_NAME: WrapperField = WrapperField("SQMean", FieldType.DOUBLE)
    SQSTDDEV__FIELD_NAME: WrapperField = WrapperField("SQStdDev", FieldType.DOUBLE)
    TARGET__FIELD_NAME: WrapperField = WrapperField("Target", FieldType.STRING)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)
    WELLNOTE__FIELD_NAME: WrapperField = WrapperField("WellNote", FieldType.STRING)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_BiologicalSetName_field(self, value: Optional[str]):
        """
        Set data field with field name 'BiologicalSetName' on this record model
        """
        self.set_field_value(self.BIOLOGICALSETNAME__FIELD_NAME.field_name, value)

    def get_BiologicalSetName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'BiologicalSetName' from this record model
        """
        return self.get_field_value(self.BIOLOGICALSETNAME__FIELD_NAME.field_name)

    def set_Content_field(self, value: Optional[str]):
        """
        Set data field with field name 'Content' on this record model
        """
        self.set_field_value(self.CONTENT__FIELD_NAME.field_name, value)

    def get_Content_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Content' from this record model
        """
        return self.get_field_value(self.CONTENT__FIELD_NAME.field_name)

    def set_Cq_field(self, value: Optional[float]):
        """
        Set data field with field name 'Cq' on this record model
        """
        self.set_field_value(self.CQ__FIELD_NAME.field_name, value)

    def get_Cq_field(self) -> Optional[float]:
        """
        Get data field value with field name 'Cq' from this record model
        """
        return self.get_field_value(self.CQ__FIELD_NAME.field_name)

    def set_CqMean_field(self, value: Optional[float]):
        """
        Set data field with field name 'CqMean' on this record model
        """
        self.set_field_value(self.CQMEAN__FIELD_NAME.field_name, value)

    def get_CqMean_field(self) -> Optional[float]:
        """
        Get data field value with field name 'CqMean' from this record model
        """
        return self.get_field_value(self.CQMEAN__FIELD_NAME.field_name)

    def set_CqStdDev_field(self, value: Optional[float]):
        """
        Set data field with field name 'CqStdDev' on this record model
        """
        self.set_field_value(self.CQSTDDEV__FIELD_NAME.field_name, value)

    def get_CqStdDev_field(self) -> Optional[float]:
        """
        Get data field value with field name 'CqStdDev' from this record model
        """
        return self.get_field_value(self.CQSTDDEV__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_Fluor_field(self, value: Optional[str]):
        """
        Set data field with field name 'Fluor' on this record model
        """
        self.set_field_value(self.FLUOR__FIELD_NAME.field_name, value)

    def get_Fluor_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Fluor' from this record model
        """
        return self.get_field_value(self.FLUOR__FIELD_NAME.field_name)

    def set_LogStartingQuantity_field(self, value: Optional[float]):
        """
        Set data field with field name 'LogStartingQuantity' on this record model
        """
        self.set_field_value(self.LOGSTARTINGQUANTITY__FIELD_NAME.field_name, value)

    def get_LogStartingQuantity_field(self) -> Optional[float]:
        """
        Get data field value with field name 'LogStartingQuantity' from this record model
        """
        return self.get_field_value(self.LOGSTARTINGQUANTITY__FIELD_NAME.field_name)

    def set_SetPoint_field(self, value: Optional[float]):
        """
        Set data field with field name 'SetPoint' on this record model
        """
        self.set_field_value(self.SETPOINT__FIELD_NAME.field_name, value)

    def get_SetPoint_field(self) -> Optional[float]:
        """
        Get data field value with field name 'SetPoint' from this record model
        """
        return self.get_field_value(self.SETPOINT__FIELD_NAME.field_name)

    def set_SQMean_field(self, value: Optional[float]):
        """
        Set data field with field name 'SQMean' on this record model
        """
        self.set_field_value(self.SQMEAN__FIELD_NAME.field_name, value)

    def get_SQMean_field(self) -> Optional[float]:
        """
        Get data field value with field name 'SQMean' from this record model
        """
        return self.get_field_value(self.SQMEAN__FIELD_NAME.field_name)

    def set_SQStdDev_field(self, value: Optional[float]):
        """
        Set data field with field name 'SQStdDev' on this record model
        """
        self.set_field_value(self.SQSTDDEV__FIELD_NAME.field_name, value)

    def get_SQStdDev_field(self) -> Optional[float]:
        """
        Get data field value with field name 'SQStdDev' from this record model
        """
        return self.get_field_value(self.SQSTDDEV__FIELD_NAME.field_name)

    def set_Target_field(self, value: Optional[str]):
        """
        Set data field with field name 'Target' on this record model
        """
        self.set_field_value(self.TARGET__FIELD_NAME.field_name, value)

    def get_Target_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Target' from this record model
        """
        return self.get_field_value(self.TARGET__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)

    def set_WellNote_field(self, value: Optional[str]):
        """
        Set data field with field name 'WellNote' on this record model
        """
        self.set_field_value(self.WELLNOTE__FIELD_NAME.field_name, value)

    def get_WellNote_field(self) -> Optional[str]:
        """
        Get data field value with field name 'WellNote' from this record model
        """
        return self.get_field_value(self.WELLNOTE__FIELD_NAME.field_name)


class BioRegSeqAnnotationModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type BioRegSeqAnnotation
    Data Type Display Name: Bio Reg Seq Annotation (Bio Reg Seq Annotations)
    Fields: AnnotationType, Chromosome, CreatedBy, DataRecordName, DateCreated, db_xref, EndPosition, Experiment, Gene, Label, LocusTag, NCBIFunction, NegativeStrand, Note, Operon, Organism, Product, ProteinId, StandardName, StartPosition, VeloxLastModifiedBy, VeloxLastModifiedDate
    Includes useful annotations imported via NCBI Genbank file feature format.
https://www.insdc.org/submitting-standards/feature-table/
    """
    DATA_TYPE_NAME: str = 'BioRegSeqAnnotation'
    ANNOTATIONTYPE__FIELD_NAME: WrapperField = WrapperField("AnnotationType", FieldType.STRING)
    CHROMOSOME__FIELD_NAME: WrapperField = WrapperField("Chromosome", FieldType.STRING)
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    DB_XREF__FIELD_NAME: WrapperField = WrapperField("db_xref", FieldType.STRING)
    ENDPOSITION__FIELD_NAME: WrapperField = WrapperField("EndPosition", FieldType.LONG)
    EXPERIMENT__FIELD_NAME: WrapperField = WrapperField("Experiment", FieldType.STRING)
    GENE__FIELD_NAME: WrapperField = WrapperField("Gene", FieldType.STRING)
    LABEL__FIELD_NAME: WrapperField = WrapperField("Label", FieldType.STRING)
    LOCUSTAG__FIELD_NAME: WrapperField = WrapperField("LocusTag", FieldType.STRING)
    NCBIFUNCTION__FIELD_NAME: WrapperField = WrapperField("NCBIFunction", FieldType.STRING)
    NEGATIVESTRAND__FIELD_NAME: WrapperField = WrapperField("NegativeStrand", FieldType.BOOLEAN)
    NOTE__FIELD_NAME: WrapperField = WrapperField("Note", FieldType.STRING)
    OPERON__FIELD_NAME: WrapperField = WrapperField("Operon", FieldType.STRING)
    ORGANISM__FIELD_NAME: WrapperField = WrapperField("Organism", FieldType.STRING)
    PRODUCT__FIELD_NAME: WrapperField = WrapperField("Product", FieldType.STRING)
    PROTEINID__FIELD_NAME: WrapperField = WrapperField("ProteinId", FieldType.STRING)
    STANDARDNAME__FIELD_NAME: WrapperField = WrapperField("StandardName", FieldType.STRING)
    STARTPOSITION__FIELD_NAME: WrapperField = WrapperField("StartPosition", FieldType.LONG)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_AnnotationType_field(self, value: Optional[str]):
        """
        Set data field with field name 'AnnotationType' on this record model
        """
        self.set_field_value(self.ANNOTATIONTYPE__FIELD_NAME.field_name, value)

    def get_AnnotationType_field(self) -> Optional[str]:
        """
        Get data field value with field name 'AnnotationType' from this record model
        """
        return self.get_field_value(self.ANNOTATIONTYPE__FIELD_NAME.field_name)

    def set_Chromosome_field(self, value: Optional[str]):
        """
        Set data field with field name 'Chromosome' on this record model
        """
        self.set_field_value(self.CHROMOSOME__FIELD_NAME.field_name, value)

    def get_Chromosome_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Chromosome' from this record model
        """
        return self.get_field_value(self.CHROMOSOME__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_db_xref_field(self, value: Optional[str]):
        """
        Set data field with field name 'db_xref' on this record model
        """
        self.set_field_value(self.DB_XREF__FIELD_NAME.field_name, value)

    def get_db_xref_field(self) -> Optional[str]:
        """
        Get data field value with field name 'db_xref' from this record model
        """
        return self.get_field_value(self.DB_XREF__FIELD_NAME.field_name)

    def set_EndPosition_field(self, value: Optional[int]):
        """
        Set data field with field name 'EndPosition' on this record model
        """
        self.set_field_value(self.ENDPOSITION__FIELD_NAME.field_name, value)

    def get_EndPosition_field(self) -> Optional[int]:
        """
        Get data field value with field name 'EndPosition' from this record model
        """
        return self.get_field_value(self.ENDPOSITION__FIELD_NAME.field_name)

    def set_Experiment_field(self, value: Optional[str]):
        """
        Set data field with field name 'Experiment' on this record model
        """
        self.set_field_value(self.EXPERIMENT__FIELD_NAME.field_name, value)

    def get_Experiment_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Experiment' from this record model
        """
        return self.get_field_value(self.EXPERIMENT__FIELD_NAME.field_name)

    def set_Gene_field(self, value: Optional[str]):
        """
        Set data field with field name 'Gene' on this record model
        """
        self.set_field_value(self.GENE__FIELD_NAME.field_name, value)

    def get_Gene_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Gene' from this record model
        """
        return self.get_field_value(self.GENE__FIELD_NAME.field_name)

    def set_Label_field(self, value: Optional[str]):
        """
        Set data field with field name 'Label' on this record model
        """
        self.set_field_value(self.LABEL__FIELD_NAME.field_name, value)

    def get_Label_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Label' from this record model
        """
        return self.get_field_value(self.LABEL__FIELD_NAME.field_name)

    def set_LocusTag_field(self, value: Optional[str]):
        """
        Set data field with field name 'LocusTag' on this record model
        """
        self.set_field_value(self.LOCUSTAG__FIELD_NAME.field_name, value)

    def get_LocusTag_field(self) -> Optional[str]:
        """
        Get data field value with field name 'LocusTag' from this record model
        """
        return self.get_field_value(self.LOCUSTAG__FIELD_NAME.field_name)

    def set_NCBIFunction_field(self, value: Optional[str]):
        """
        Set data field with field name 'NCBIFunction' on this record model
        """
        self.set_field_value(self.NCBIFUNCTION__FIELD_NAME.field_name, value)

    def get_NCBIFunction_field(self) -> Optional[str]:
        """
        Get data field value with field name 'NCBIFunction' from this record model
        """
        return self.get_field_value(self.NCBIFUNCTION__FIELD_NAME.field_name)

    def set_NegativeStrand_field(self, value: Optional[bool]):
        """
        Set data field with field name 'NegativeStrand' on this record model
        """
        self.set_field_value(self.NEGATIVESTRAND__FIELD_NAME.field_name, value)

    def get_NegativeStrand_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'NegativeStrand' from this record model
        """
        return self.get_field_value(self.NEGATIVESTRAND__FIELD_NAME.field_name)

    def set_Note_field(self, value: Optional[str]):
        """
        Set data field with field name 'Note' on this record model
        """
        self.set_field_value(self.NOTE__FIELD_NAME.field_name, value)

    def get_Note_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Note' from this record model
        """
        return self.get_field_value(self.NOTE__FIELD_NAME.field_name)

    def set_Operon_field(self, value: Optional[str]):
        """
        Set data field with field name 'Operon' on this record model
        """
        self.set_field_value(self.OPERON__FIELD_NAME.field_name, value)

    def get_Operon_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Operon' from this record model
        """
        return self.get_field_value(self.OPERON__FIELD_NAME.field_name)

    def set_Organism_field(self, value: Optional[str]):
        """
        Set data field with field name 'Organism' on this record model
        """
        self.set_field_value(self.ORGANISM__FIELD_NAME.field_name, value)

    def get_Organism_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Organism' from this record model
        """
        return self.get_field_value(self.ORGANISM__FIELD_NAME.field_name)

    def set_Product_field(self, value: Optional[str]):
        """
        Set data field with field name 'Product' on this record model
        """
        self.set_field_value(self.PRODUCT__FIELD_NAME.field_name, value)

    def get_Product_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Product' from this record model
        """
        return self.get_field_value(self.PRODUCT__FIELD_NAME.field_name)

    def set_ProteinId_field(self, value: Optional[str]):
        """
        Set data field with field name 'ProteinId' on this record model
        """
        self.set_field_value(self.PROTEINID__FIELD_NAME.field_name, value)

    def get_ProteinId_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ProteinId' from this record model
        """
        return self.get_field_value(self.PROTEINID__FIELD_NAME.field_name)

    def set_StandardName_field(self, value: Optional[str]):
        """
        Set data field with field name 'StandardName' on this record model
        """
        self.set_field_value(self.STANDARDNAME__FIELD_NAME.field_name, value)

    def get_StandardName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'StandardName' from this record model
        """
        return self.get_field_value(self.STANDARDNAME__FIELD_NAME.field_name)

    def set_StartPosition_field(self, value: Optional[int]):
        """
        Set data field with field name 'StartPosition' on this record model
        """
        self.set_field_value(self.STARTPOSITION__FIELD_NAME.field_name, value)

    def get_StartPosition_field(self) -> Optional[int]:
        """
        Get data field value with field name 'StartPosition' from this record model
        """
        return self.get_field_value(self.STARTPOSITION__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class BioRegSequenceTypeSettingModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type BioRegSequenceTypeSetting
    Data Type Display Name: Bio Reg Sequence Type Setting (Bio Reg Sequence Type Settings)
    Fields: AutoRegisterChildType, CreatedBy, DataRecordName, DateCreated, DisableDuplicateCheck, DisableSequenceValiation, InheritParentRegistryID, RegistrationIDPrefix, RegistryDataType, RegistryIdPaddingDigits, SequenceDataField, SequenceType, UniqueDataFields, VeloxLastModifiedBy, VeloxLastModifiedDate
    """
    DATA_TYPE_NAME: str = 'BioRegSequenceTypeSetting'
    AUTOREGISTERCHILDTYPE__FIELD_NAME: WrapperField = WrapperField("AutoRegisterChildType", FieldType.SELECTION)
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    DISABLEDUPLICATECHECK__FIELD_NAME: WrapperField = WrapperField("DisableDuplicateCheck", FieldType.BOOLEAN)
    DISABLESEQUENCEVALIATION__FIELD_NAME: WrapperField = WrapperField("DisableSequenceValiation", FieldType.BOOLEAN)
    INHERITPARENTREGISTRYID__FIELD_NAME: WrapperField = WrapperField("InheritParentRegistryID", FieldType.BOOLEAN)
    REGISTRATIONIDPREFIX__FIELD_NAME: WrapperField = WrapperField("RegistrationIDPrefix", FieldType.STRING)
    REGISTRYDATATYPE__FIELD_NAME: WrapperField = WrapperField("RegistryDataType", FieldType.SELECTION)
    REGISTRYIDPADDINGDIGITS__FIELD_NAME: WrapperField = WrapperField("RegistryIdPaddingDigits", FieldType.INTEGER)
    SEQUENCEDATAFIELD__FIELD_NAME: WrapperField = WrapperField("SequenceDataField", FieldType.SELECTION)
    SEQUENCETYPE__FIELD_NAME: WrapperField = WrapperField("SequenceType", FieldType.PICKLIST)
    UNIQUEDATAFIELDS__FIELD_NAME: WrapperField = WrapperField("UniqueDataFields", FieldType.SELECTION)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_AutoRegisterChildType_field(self, value: Optional[str]):
        """
        Set data field with field name 'AutoRegisterChildType' on this record model
        """
        self.set_field_value(self.AUTOREGISTERCHILDTYPE__FIELD_NAME.field_name, value)

    def get_AutoRegisterChildType_field(self) -> Optional[str]:
        """
        Get data field value with field name 'AutoRegisterChildType' from this record model
        """
        return self.get_field_value(self.AUTOREGISTERCHILDTYPE__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_DisableDuplicateCheck_field(self, value: Optional[bool]):
        """
        Set data field with field name 'DisableDuplicateCheck' on this record model
        """
        self.set_field_value(self.DISABLEDUPLICATECHECK__FIELD_NAME.field_name, value)

    def get_DisableDuplicateCheck_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'DisableDuplicateCheck' from this record model
        """
        return self.get_field_value(self.DISABLEDUPLICATECHECK__FIELD_NAME.field_name)

    def set_DisableSequenceValiation_field(self, value: Optional[bool]):
        """
        Set data field with field name 'DisableSequenceValiation' on this record model
        """
        self.set_field_value(self.DISABLESEQUENCEVALIATION__FIELD_NAME.field_name, value)

    def get_DisableSequenceValiation_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'DisableSequenceValiation' from this record model
        """
        return self.get_field_value(self.DISABLESEQUENCEVALIATION__FIELD_NAME.field_name)

    def set_InheritParentRegistryID_field(self, value: Optional[bool]):
        """
        Set data field with field name 'InheritParentRegistryID' on this record model
        """
        self.set_field_value(self.INHERITPARENTREGISTRYID__FIELD_NAME.field_name, value)

    def get_InheritParentRegistryID_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'InheritParentRegistryID' from this record model
        """
        return self.get_field_value(self.INHERITPARENTREGISTRYID__FIELD_NAME.field_name)

    def set_RegistrationIDPrefix_field(self, value: Optional[str]):
        """
        Set data field with field name 'RegistrationIDPrefix' on this record model
        """
        self.set_field_value(self.REGISTRATIONIDPREFIX__FIELD_NAME.field_name, value)

    def get_RegistrationIDPrefix_field(self) -> Optional[str]:
        """
        Get data field value with field name 'RegistrationIDPrefix' from this record model
        """
        return self.get_field_value(self.REGISTRATIONIDPREFIX__FIELD_NAME.field_name)

    def set_RegistryDataType_field(self, value: Optional[str]):
        """
        Set data field with field name 'RegistryDataType' on this record model
        """
        self.set_field_value(self.REGISTRYDATATYPE__FIELD_NAME.field_name, value)

    def get_RegistryDataType_field(self) -> Optional[str]:
        """
        Get data field value with field name 'RegistryDataType' from this record model
        """
        return self.get_field_value(self.REGISTRYDATATYPE__FIELD_NAME.field_name)

    def set_RegistryIdPaddingDigits_field(self, value: Optional[int]):
        """
        Set data field with field name 'RegistryIdPaddingDigits' on this record model
        """
        self.set_field_value(self.REGISTRYIDPADDINGDIGITS__FIELD_NAME.field_name, value)

    def get_RegistryIdPaddingDigits_field(self) -> Optional[int]:
        """
        Get data field value with field name 'RegistryIdPaddingDigits' from this record model
        """
        return self.get_field_value(self.REGISTRYIDPADDINGDIGITS__FIELD_NAME.field_name)

    def set_SequenceDataField_field(self, value: Optional[str]):
        """
        Set data field with field name 'SequenceDataField' on this record model
        """
        self.set_field_value(self.SEQUENCEDATAFIELD__FIELD_NAME.field_name, value)

    def get_SequenceDataField_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SequenceDataField' from this record model
        """
        return self.get_field_value(self.SEQUENCEDATAFIELD__FIELD_NAME.field_name)

    def set_SequenceType_field(self, value: Optional[str]):
        """
        Set data field with field name 'SequenceType' on this record model
        """
        self.set_field_value(self.SEQUENCETYPE__FIELD_NAME.field_name, value)

    def get_SequenceType_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SequenceType' from this record model
        """
        return self.get_field_value(self.SEQUENCETYPE__FIELD_NAME.field_name)

    def set_UniqueDataFields_field(self, value: Optional[str]):
        """
        Set data field with field name 'UniqueDataFields' on this record model
        """
        self.set_field_value(self.UNIQUEDATAFIELDS__FIELD_NAME.field_name, value)

    def get_UniqueDataFields_field(self) -> Optional[str]:
        """
        Get data field value with field name 'UniqueDataFields' from this record model
        """
        return self.get_field_value(self.UNIQUEDATAFIELDS__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class BioSpecResultModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type BioSpecResult
    Data Type Display Name: BioSpec Result (BioSpec Results)
    Fields: A260230, A260280, CreatedBy, DataRecordName, DateCreated, VeloxLastModifiedBy, VeloxLastModifiedDate
    """
    DATA_TYPE_NAME: str = 'BioSpecResult'
    A260230__FIELD_NAME: WrapperField = WrapperField("A260230", FieldType.DOUBLE)
    A260280__FIELD_NAME: WrapperField = WrapperField("A260280", FieldType.DOUBLE)
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_A260230_field(self, value: Optional[float]):
        """
        Set data field with field name 'A260230' on this record model
        """
        self.set_field_value(self.A260230__FIELD_NAME.field_name, value)

    def get_A260230_field(self) -> Optional[float]:
        """
        Get data field value with field name 'A260230' from this record model
        """
        return self.get_field_value(self.A260230__FIELD_NAME.field_name)

    def set_A260280_field(self, value: Optional[float]):
        """
        Set data field with field name 'A260280' on this record model
        """
        self.set_field_value(self.A260280__FIELD_NAME.field_name, value)

    def get_A260280_field(self) -> Optional[float]:
        """
        Get data field value with field name 'A260280' from this record model
        """
        return self.get_field_value(self.A260280__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class BloodModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type Blood
    Data Type Display Name: Blood (Bloods)
    Fields: CreatedBy, DataRecordName, DateCreated, DrawSite, VeloxLastModifiedBy, VeloxLastModifiedDate
    """
    DATA_TYPE_NAME: str = 'Blood'
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    DRAWSITE__FIELD_NAME: WrapperField = WrapperField("DrawSite", FieldType.PICKLIST)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_DrawSite_field(self, value: Optional[str]):
        """
        Set data field with field name 'DrawSite' on this record model
        """
        self.set_field_value(self.DRAWSITE__FIELD_NAME.field_name, value)

    def get_DrawSite_field(self) -> Optional[str]:
        """
        Get data field value with field name 'DrawSite' from this record model
        """
        return self.get_field_value(self.DRAWSITE__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class BodyMassModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type BodyMass
    Data Type Display Name: Body Mass (Body Masses)
    Fields: CreatedBy, DataRecordName, DateCreated, Mass, MassUnits, ObservationInstrument, VeloxLastModifiedBy, VeloxLastModifiedDate
    """
    DATA_TYPE_NAME: str = 'BodyMass'
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    MASS__FIELD_NAME: WrapperField = WrapperField("Mass", FieldType.DOUBLE)
    MASSUNITS__FIELD_NAME: WrapperField = WrapperField("MassUnits", FieldType.PICKLIST)
    OBSERVATIONINSTRUMENT__FIELD_NAME: WrapperField = WrapperField("ObservationInstrument", FieldType.SELECTION)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_Mass_field(self, value: Optional[float]):
        """
        Set data field with field name 'Mass' on this record model
        """
        self.set_field_value(self.MASS__FIELD_NAME.field_name, value)

    def get_Mass_field(self) -> Optional[float]:
        """
        Get data field value with field name 'Mass' from this record model
        """
        return self.get_field_value(self.MASS__FIELD_NAME.field_name)

    def set_MassUnits_field(self, value: Optional[str]):
        """
        Set data field with field name 'MassUnits' on this record model
        """
        self.set_field_value(self.MASSUNITS__FIELD_NAME.field_name, value)

    def get_MassUnits_field(self) -> Optional[str]:
        """
        Get data field value with field name 'MassUnits' from this record model
        """
        return self.get_field_value(self.MASSUNITS__FIELD_NAME.field_name)

    def set_ObservationInstrument_field(self, value: Optional[str]):
        """
        Set data field with field name 'ObservationInstrument' on this record model
        """
        self.set_field_value(self.OBSERVATIONINSTRUMENT__FIELD_NAME.field_name, value)

    def get_ObservationInstrument_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ObservationInstrument' from this record model
        """
        return self.get_field_value(self.OBSERVATIONINSTRUMENT__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class BrainTissueModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type BrainTissue
    Data Type Display Name: Brain Tissue (Brain Tissues)
    Fields: BrainTissueType, CreatedBy, DataRecordName, DateCreated, VeloxLastModifiedBy, VeloxLastModifiedDate
    """
    DATA_TYPE_NAME: str = 'BrainTissue'
    BRAINTISSUETYPE__FIELD_NAME: WrapperField = WrapperField("BrainTissueType", FieldType.SELECTION)
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_BrainTissueType_field(self, value: Optional[str]):
        """
        Set data field with field name 'BrainTissueType' on this record model
        """
        self.set_field_value(self.BRAINTISSUETYPE__FIELD_NAME.field_name, value)

    def get_BrainTissueType_field(self) -> Optional[str]:
        """
        Get data field value with field name 'BrainTissueType' from this record model
        """
        return self.get_field_value(self.BRAINTISSUETYPE__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class C_SapioCon23Model(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type C_SapioCon23
    Data Type Display Name: SAPIOCON 23 (SAPIOCON 23)
    Fields: C_DisplayName, C_ExampleSelectionList, C_HomeWorld, C_SapioConComments, CreatedBy, DataRecordName, DateCreated, VeloxLastModifiedBy, VeloxLastModifiedDate
    """
    DATA_TYPE_NAME: str = 'C_SapioCon23'
    C_DISPLAYNAME__FIELD_NAME: WrapperField = WrapperField("C_DisplayName", FieldType.STRING)
    C_EXAMPLESELECTIONLIST__FIELD_NAME: WrapperField = WrapperField("C_ExampleSelectionList", FieldType.SELECTION)
    C_HOMEWORLD__FIELD_NAME: WrapperField = WrapperField("C_HomeWorld", FieldType.SELECTION)
    C_SAPIOCONCOMMENTS__FIELD_NAME: WrapperField = WrapperField("C_SapioConComments", FieldType.STRING)
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_C_DisplayName_field(self, value: Optional[str]):
        """
        Set data field with field name 'C_DisplayName' on this record model
        """
        self.set_field_value(self.C_DISPLAYNAME__FIELD_NAME.field_name, value)

    def get_C_DisplayName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'C_DisplayName' from this record model
        """
        return self.get_field_value(self.C_DISPLAYNAME__FIELD_NAME.field_name)

    def set_C_ExampleSelectionList_field(self, value: Optional[str]):
        """
        Set data field with field name 'C_ExampleSelectionList' on this record model
        """
        self.set_field_value(self.C_EXAMPLESELECTIONLIST__FIELD_NAME.field_name, value)

    def get_C_ExampleSelectionList_field(self) -> Optional[str]:
        """
        Get data field value with field name 'C_ExampleSelectionList' from this record model
        """
        return self.get_field_value(self.C_EXAMPLESELECTIONLIST__FIELD_NAME.field_name)

    def set_C_HomeWorld_field(self, value: Optional[str]):
        """
        Set data field with field name 'C_HomeWorld' on this record model
        """
        self.set_field_value(self.C_HOMEWORLD__FIELD_NAME.field_name, value)

    def get_C_HomeWorld_field(self) -> Optional[str]:
        """
        Get data field value with field name 'C_HomeWorld' from this record model
        """
        return self.get_field_value(self.C_HOMEWORLD__FIELD_NAME.field_name)

    def set_C_SapioConComments_field(self, value: Optional[str]):
        """
        Set data field with field name 'C_SapioConComments' on this record model
        """
        self.set_field_value(self.C_SAPIOCONCOMMENTS__FIELD_NAME.field_name, value)

    def get_C_SapioConComments_field(self) -> Optional[str]:
        """
        Get data field value with field name 'C_SapioConComments' from this record model
        """
        return self.get_field_value(self.C_SAPIOCONCOMMENTS__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class C_SapioConTestModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type C_SapioConTest
    Data Type Display Name: Sapio Con Test (Sapio Con Tests)
    Fields: CreatedBy, DataRecordName, DateCreated, Description, Name, VeloxLastModifiedBy, VeloxLastModifiedDate
    """
    DATA_TYPE_NAME: str = 'C_SapioConTest'
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    DESCRIPTION__FIELD_NAME: WrapperField = WrapperField("Description", FieldType.STRING)
    NAME__FIELD_NAME: WrapperField = WrapperField("Name", FieldType.STRING)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_Description_field(self, value: Optional[str]):
        """
        Set data field with field name 'Description' on this record model
        """
        self.set_field_value(self.DESCRIPTION__FIELD_NAME.field_name, value)

    def get_Description_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Description' from this record model
        """
        return self.get_field_value(self.DESCRIPTION__FIELD_NAME.field_name)

    def set_Name_field(self, value: Optional[str]):
        """
        Set data field with field name 'Name' on this record model
        """
        self.set_field_value(self.NAME__FIELD_NAME.field_name, value)

    def get_Name_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Name' from this record model
        """
        return self.get_field_value(self.NAME__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class CDLConfigModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type CDLConfig
    Data Type Display Name: Complex Data Loader Config (Complex Data Loader Configs)
    Fields: ConfigurationName, CreatedBy, DataRecordName, DataTypeName, DataTypeRules, DataTypeRules2, DateCreated, ExplicitlyMapped, IdentifierType, Options, Options2, VeloxLastModifiedBy, VeloxLastModifiedDate
    <!-- CONFIG: Static --><!-- CONFIG: REPLACEABLE -->
    """
    DATA_TYPE_NAME: str = 'CDLConfig'
    CONFIGURATIONNAME__FIELD_NAME: WrapperField = WrapperField("ConfigurationName", FieldType.STRING)
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATATYPENAME__FIELD_NAME: WrapperField = WrapperField("DataTypeName", FieldType.SELECTION)
    DATATYPERULES__FIELD_NAME: WrapperField = WrapperField("DataTypeRules", FieldType.SELECTION)
    DATATYPERULES2__FIELD_NAME: WrapperField = WrapperField("DataTypeRules2", FieldType.SELECTION)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    EXPLICITLYMAPPED__FIELD_NAME: WrapperField = WrapperField("ExplicitlyMapped", FieldType.BOOLEAN)
    IDENTIFIERTYPE__FIELD_NAME: WrapperField = WrapperField("IdentifierType", FieldType.SELECTION)
    OPTIONS__FIELD_NAME: WrapperField = WrapperField("Options", FieldType.SELECTION)
    OPTIONS2__FIELD_NAME: WrapperField = WrapperField("Options2", FieldType.SELECTION)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_ConfigurationName_field(self, value: Optional[str]):
        """
        Set data field with field name 'ConfigurationName' on this record model
        """
        self.set_field_value(self.CONFIGURATIONNAME__FIELD_NAME.field_name, value)

    def get_ConfigurationName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ConfigurationName' from this record model
        """
        return self.get_field_value(self.CONFIGURATIONNAME__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def set_DataTypeName_field(self, value: Optional[str]):
        """
        Set data field with field name 'DataTypeName' on this record model
        """
        self.set_field_value(self.DATATYPENAME__FIELD_NAME.field_name, value)

    def get_DataTypeName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'DataTypeName' from this record model
        """
        return self.get_field_value(self.DATATYPENAME__FIELD_NAME.field_name)

    def set_DataTypeRules_field(self, value: Optional[str]):
        """
        Set data field with field name 'DataTypeRules' on this record model
        """
        self.set_field_value(self.DATATYPERULES__FIELD_NAME.field_name, value)

    def get_DataTypeRules_field(self) -> Optional[str]:
        """
        Get data field value with field name 'DataTypeRules' from this record model
        """
        return self.get_field_value(self.DATATYPERULES__FIELD_NAME.field_name)

    def set_DataTypeRules2_field(self, value: Optional[str]):
        """
        Set data field with field name 'DataTypeRules2' on this record model
        """
        self.set_field_value(self.DATATYPERULES2__FIELD_NAME.field_name, value)

    def get_DataTypeRules2_field(self) -> Optional[str]:
        """
        Get data field value with field name 'DataTypeRules2' from this record model
        """
        return self.get_field_value(self.DATATYPERULES2__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_ExplicitlyMapped_field(self, value: Optional[bool]):
        """
        Set data field with field name 'ExplicitlyMapped' on this record model
        """
        self.set_field_value(self.EXPLICITLYMAPPED__FIELD_NAME.field_name, value)

    def get_ExplicitlyMapped_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'ExplicitlyMapped' from this record model
        """
        return self.get_field_value(self.EXPLICITLYMAPPED__FIELD_NAME.field_name)

    def set_IdentifierType_field(self, value: Optional[str]):
        """
        Set data field with field name 'IdentifierType' on this record model
        """
        self.set_field_value(self.IDENTIFIERTYPE__FIELD_NAME.field_name, value)

    def get_IdentifierType_field(self) -> Optional[str]:
        """
        Get data field value with field name 'IdentifierType' from this record model
        """
        return self.get_field_value(self.IDENTIFIERTYPE__FIELD_NAME.field_name)

    def set_Options_field(self, value: Optional[str]):
        """
        Set data field with field name 'Options' on this record model
        """
        self.set_field_value(self.OPTIONS__FIELD_NAME.field_name, value)

    def get_Options_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Options' from this record model
        """
        return self.get_field_value(self.OPTIONS__FIELD_NAME.field_name)

    def set_Options2_field(self, value: Optional[str]):
        """
        Set data field with field name 'Options2' on this record model
        """
        self.set_field_value(self.OPTIONS2__FIELD_NAME.field_name, value)

    def get_Options2_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Options2' from this record model
        """
        return self.get_field_value(self.OPTIONS2__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class CDLFieldMapModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type CDLFieldMap
    Data Type Display Name: Complex Data Loader Field Mapping (Complex Data Loader Field Mappings)
    Fields: ConfigurationName, CreatedBy, DataRecordName, DataTypeName, DateCreated, FieldRules, FieldRules2, FieldType, FromHeader, HeaderNameAliasList, IdentifiedBy, IsIdentifierField, IsListField, Options, Options2, ToField, VeloxLastModifiedBy, VeloxLastModifiedDate
    <!-- CONFIG: Static --><!-- CONFIG: REPLACEABLE -->
    """
    DATA_TYPE_NAME: str = 'CDLFieldMap'
    CONFIGURATIONNAME__FIELD_NAME: WrapperField = WrapperField("ConfigurationName", FieldType.STRING)
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATATYPENAME__FIELD_NAME: WrapperField = WrapperField("DataTypeName", FieldType.SELECTION)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    FIELDRULES__FIELD_NAME: WrapperField = WrapperField("FieldRules", FieldType.SELECTION)
    FIELDRULES2__FIELD_NAME: WrapperField = WrapperField("FieldRules2", FieldType.SELECTION)
    FIELDTYPE__FIELD_NAME: WrapperField = WrapperField("FieldType", FieldType.SELECTION)
    FROMHEADER__FIELD_NAME: WrapperField = WrapperField("FromHeader", FieldType.SELECTION)
    HEADERNAMEALIASLIST__FIELD_NAME: WrapperField = WrapperField("HeaderNameAliasList", FieldType.SELECTION)
    IDENTIFIEDBY__FIELD_NAME: WrapperField = WrapperField("IdentifiedBy", FieldType.STRING)
    ISIDENTIFIERFIELD__FIELD_NAME: WrapperField = WrapperField("IsIdentifierField", FieldType.BOOLEAN)
    ISLISTFIELD__FIELD_NAME: WrapperField = WrapperField("IsListField", FieldType.BOOLEAN)
    OPTIONS__FIELD_NAME: WrapperField = WrapperField("Options", FieldType.SELECTION)
    OPTIONS2__FIELD_NAME: WrapperField = WrapperField("Options2", FieldType.SELECTION)
    TOFIELD__FIELD_NAME: WrapperField = WrapperField("ToField", FieldType.SELECTION)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_ConfigurationName_field(self, value: Optional[str]):
        """
        Set data field with field name 'ConfigurationName' on this record model
        """
        self.set_field_value(self.CONFIGURATIONNAME__FIELD_NAME.field_name, value)

    def get_ConfigurationName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ConfigurationName' from this record model
        """
        return self.get_field_value(self.CONFIGURATIONNAME__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def set_DataTypeName_field(self, value: Optional[str]):
        """
        Set data field with field name 'DataTypeName' on this record model
        """
        self.set_field_value(self.DATATYPENAME__FIELD_NAME.field_name, value)

    def get_DataTypeName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'DataTypeName' from this record model
        """
        return self.get_field_value(self.DATATYPENAME__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_FieldRules_field(self, value: Optional[str]):
        """
        Set data field with field name 'FieldRules' on this record model
        """
        self.set_field_value(self.FIELDRULES__FIELD_NAME.field_name, value)

    def get_FieldRules_field(self) -> Optional[str]:
        """
        Get data field value with field name 'FieldRules' from this record model
        """
        return self.get_field_value(self.FIELDRULES__FIELD_NAME.field_name)

    def set_FieldRules2_field(self, value: Optional[str]):
        """
        Set data field with field name 'FieldRules2' on this record model
        """
        self.set_field_value(self.FIELDRULES2__FIELD_NAME.field_name, value)

    def get_FieldRules2_field(self) -> Optional[str]:
        """
        Get data field value with field name 'FieldRules2' from this record model
        """
        return self.get_field_value(self.FIELDRULES2__FIELD_NAME.field_name)

    def set_FieldType_field(self, value: Optional[str]):
        """
        Set data field with field name 'FieldType' on this record model
        """
        self.set_field_value(self.FIELDTYPE__FIELD_NAME.field_name, value)

    def get_FieldType_field(self) -> Optional[str]:
        """
        Get data field value with field name 'FieldType' from this record model
        """
        return self.get_field_value(self.FIELDTYPE__FIELD_NAME.field_name)

    def set_FromHeader_field(self, value: Optional[str]):
        """
        Set data field with field name 'FromHeader' on this record model
        """
        self.set_field_value(self.FROMHEADER__FIELD_NAME.field_name, value)

    def get_FromHeader_field(self) -> Optional[str]:
        """
        Get data field value with field name 'FromHeader' from this record model
        """
        return self.get_field_value(self.FROMHEADER__FIELD_NAME.field_name)

    def set_HeaderNameAliasList_field(self, value: Optional[str]):
        """
        Set data field with field name 'HeaderNameAliasList' on this record model
        """
        self.set_field_value(self.HEADERNAMEALIASLIST__FIELD_NAME.field_name, value)

    def get_HeaderNameAliasList_field(self) -> Optional[str]:
        """
        Get data field value with field name 'HeaderNameAliasList' from this record model
        """
        return self.get_field_value(self.HEADERNAMEALIASLIST__FIELD_NAME.field_name)

    def set_IdentifiedBy_field(self, value: Optional[str]):
        """
        Set data field with field name 'IdentifiedBy' on this record model
        """
        self.set_field_value(self.IDENTIFIEDBY__FIELD_NAME.field_name, value)

    def get_IdentifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'IdentifiedBy' from this record model
        """
        return self.get_field_value(self.IDENTIFIEDBY__FIELD_NAME.field_name)

    def set_IsIdentifierField_field(self, value: Optional[bool]):
        """
        Set data field with field name 'IsIdentifierField' on this record model
        """
        self.set_field_value(self.ISIDENTIFIERFIELD__FIELD_NAME.field_name, value)

    def get_IsIdentifierField_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'IsIdentifierField' from this record model
        """
        return self.get_field_value(self.ISIDENTIFIERFIELD__FIELD_NAME.field_name)

    def set_IsListField_field(self, value: Optional[bool]):
        """
        Set data field with field name 'IsListField' on this record model
        """
        self.set_field_value(self.ISLISTFIELD__FIELD_NAME.field_name, value)

    def get_IsListField_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'IsListField' from this record model
        """
        return self.get_field_value(self.ISLISTFIELD__FIELD_NAME.field_name)

    def set_Options_field(self, value: Optional[str]):
        """
        Set data field with field name 'Options' on this record model
        """
        self.set_field_value(self.OPTIONS__FIELD_NAME.field_name, value)

    def get_Options_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Options' from this record model
        """
        return self.get_field_value(self.OPTIONS__FIELD_NAME.field_name)

    def set_Options2_field(self, value: Optional[str]):
        """
        Set data field with field name 'Options2' on this record model
        """
        self.set_field_value(self.OPTIONS2__FIELD_NAME.field_name, value)

    def get_Options2_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Options2' from this record model
        """
        return self.get_field_value(self.OPTIONS2__FIELD_NAME.field_name)

    def set_ToField_field(self, value: Optional[str]):
        """
        Set data field with field name 'ToField' on this record model
        """
        self.set_field_value(self.TOFIELD__FIELD_NAME.field_name, value)

    def get_ToField_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ToField' from this record model
        """
        return self.get_field_value(self.TOFIELD__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class CDLFileFieldModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type CDLFileField
    Data Type Display Name: Complex Data Loader File Field Header (Complex Data Loader File Field Headers)
    Fields: ConfigurationName, CreatedBy, DataRecordName, DateCreated, FileFieldHeader, VeloxLastModifiedBy, VeloxLastModifiedDate
    These records represent the field headers that were found in the example file.  These records are used by the plugin backing the selection list to the header field on the Complex Data Loader Field Mapping records.
<!-- CONFIG: Static --><!-- CONFIG: REPLACEABLE -->
    """
    DATA_TYPE_NAME: str = 'CDLFileField'
    CONFIGURATIONNAME__FIELD_NAME: WrapperField = WrapperField("ConfigurationName", FieldType.STRING)
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    FILEFIELDHEADER__FIELD_NAME: WrapperField = WrapperField("FileFieldHeader", FieldType.STRING)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_ConfigurationName_field(self, value: Optional[str]):
        """
        Set data field with field name 'ConfigurationName' on this record model
        """
        self.set_field_value(self.CONFIGURATIONNAME__FIELD_NAME.field_name, value)

    def get_ConfigurationName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ConfigurationName' from this record model
        """
        return self.get_field_value(self.CONFIGURATIONNAME__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_FileFieldHeader_field(self, value: Optional[str]):
        """
        Set data field with field name 'FileFieldHeader' on this record model
        """
        self.set_field_value(self.FILEFIELDHEADER__FIELD_NAME.field_name, value)

    def get_FileFieldHeader_field(self) -> Optional[str]:
        """
        Get data field value with field name 'FileFieldHeader' from this record model
        """
        return self.get_field_value(self.FILEFIELDHEADER__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class CDLGroupingConfigModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type CDLGroupingConfig
    Data Type Display Name: Complex Data Loader Grouping Config (Complex Data Loader Grouping Configs)
    Fields: AllowDynamicHeaders, ConfigurationName, CreatedBy, DataRecordName, DateCreated, FileParser, RestrictToGroups, VeloxLastModifiedBy, VeloxLastModifiedDate
    <!-- CONFIG: Static --><!-- CONFIG: REPLACEABLE -->
    """
    DATA_TYPE_NAME: str = 'CDLGroupingConfig'
    ALLOWDYNAMICHEADERS__FIELD_NAME: WrapperField = WrapperField("AllowDynamicHeaders", FieldType.BOOLEAN)
    CONFIGURATIONNAME__FIELD_NAME: WrapperField = WrapperField("ConfigurationName", FieldType.STRING)
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    FILEPARSER__FIELD_NAME: WrapperField = WrapperField("FileParser", FieldType.SELECTION)
    RESTRICTTOGROUPS__FIELD_NAME: WrapperField = WrapperField("RestrictToGroups", FieldType.SELECTION)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_AllowDynamicHeaders_field(self, value: Optional[bool]):
        """
        Set data field with field name 'AllowDynamicHeaders' on this record model
        """
        self.set_field_value(self.ALLOWDYNAMICHEADERS__FIELD_NAME.field_name, value)

    def get_AllowDynamicHeaders_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'AllowDynamicHeaders' from this record model
        """
        return self.get_field_value(self.ALLOWDYNAMICHEADERS__FIELD_NAME.field_name)

    def set_ConfigurationName_field(self, value: Optional[str]):
        """
        Set data field with field name 'ConfigurationName' on this record model
        """
        self.set_field_value(self.CONFIGURATIONNAME__FIELD_NAME.field_name, value)

    def get_ConfigurationName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ConfigurationName' from this record model
        """
        return self.get_field_value(self.CONFIGURATIONNAME__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_FileParser_field(self, value: Optional[str]):
        """
        Set data field with field name 'FileParser' on this record model
        """
        self.set_field_value(self.FILEPARSER__FIELD_NAME.field_name, value)

    def get_FileParser_field(self) -> Optional[str]:
        """
        Get data field value with field name 'FileParser' from this record model
        """
        return self.get_field_value(self.FILEPARSER__FIELD_NAME.field_name)

    def set_RestrictToGroups_field(self, value: Optional[str]):
        """
        Set data field with field name 'RestrictToGroups' on this record model
        """
        self.set_field_value(self.RESTRICTTOGROUPS__FIELD_NAME.field_name, value)

    def get_RestrictToGroups_field(self) -> Optional[str]:
        """
        Get data field value with field name 'RestrictToGroups' from this record model
        """
        return self.get_field_value(self.RESTRICTTOGROUPS__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class CellExperimentReferenceModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type CellExperimentReference
    Data Type Display Name: Cell Ontology Reference (Cell Ontology References)
    Fields: Class1, CreatedBy, DataRecordName, DateCreated, Subclass1_1, Subclass1_1_1, Subclass1_1_1_1, VeloxLastModifiedBy, VeloxLastModifiedDate
    """
    DATA_TYPE_NAME: str = 'CellExperimentReference'
    CLASS1__FIELD_NAME: WrapperField = WrapperField("Class1", FieldType.SELECTION)
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    SUBCLASS1_1__FIELD_NAME: WrapperField = WrapperField("Subclass1_1", FieldType.SELECTION)
    SUBCLASS1_1_1__FIELD_NAME: WrapperField = WrapperField("Subclass1_1_1", FieldType.SELECTION)
    SUBCLASS1_1_1_1__FIELD_NAME: WrapperField = WrapperField("Subclass1_1_1_1", FieldType.SELECTION)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_Class1_field(self, value: Optional[str]):
        """
        Set data field with field name 'Class1' on this record model
        """
        self.set_field_value(self.CLASS1__FIELD_NAME.field_name, value)

    def get_Class1_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Class1' from this record model
        """
        return self.get_field_value(self.CLASS1__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_Subclass1_1_field(self, value: Optional[str]):
        """
        Set data field with field name 'Subclass1_1' on this record model
        """
        self.set_field_value(self.SUBCLASS1_1__FIELD_NAME.field_name, value)

    def get_Subclass1_1_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Subclass1_1' from this record model
        """
        return self.get_field_value(self.SUBCLASS1_1__FIELD_NAME.field_name)

    def set_Subclass1_1_1_field(self, value: Optional[str]):
        """
        Set data field with field name 'Subclass1_1_1' on this record model
        """
        self.set_field_value(self.SUBCLASS1_1_1__FIELD_NAME.field_name, value)

    def get_Subclass1_1_1_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Subclass1_1_1' from this record model
        """
        return self.get_field_value(self.SUBCLASS1_1_1__FIELD_NAME.field_name)

    def set_Subclass1_1_1_1_field(self, value: Optional[str]):
        """
        Set data field with field name 'Subclass1_1_1_1' on this record model
        """
        self.set_field_value(self.SUBCLASS1_1_1_1__FIELD_NAME.field_name, value)

    def get_Subclass1_1_1_1_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Subclass1_1_1_1' from this record model
        """
        return self.get_field_value(self.SUBCLASS1_1_1_1__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class CellLineModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type CellLine
    Data Type Display Name: Cell Line (Cell Lines)
    Fields: Class1, CreatedBy, DataRecordName, DateCreated, MultiParentLink215, Subclass1_1, Subclass1_1_1, TotalCellNumbers, VeloxLastModifiedBy, VeloxLastModifiedDate, ViableCellNumbers
    The CellLine Data Type
    """
    DATA_TYPE_NAME: str = 'CellLine'
    CLASS1__FIELD_NAME: WrapperField = WrapperField("Class1", FieldType.SELECTION)
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    MULTIPARENTLINK215__FIELD_NAME: WrapperField = WrapperField("MultiParentLink215", FieldType.MULTIPARENTLINK)
    SUBCLASS1_1__FIELD_NAME: WrapperField = WrapperField("Subclass1_1", FieldType.SELECTION)
    SUBCLASS1_1_1__FIELD_NAME: WrapperField = WrapperField("Subclass1_1_1", FieldType.SELECTION)
    TOTALCELLNUMBERS__FIELD_NAME: WrapperField = WrapperField("TotalCellNumbers", FieldType.LONG)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)
    VIABLECELLNUMBERS__FIELD_NAME: WrapperField = WrapperField("ViableCellNumbers", FieldType.LONG)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_Class1_field(self, value: Optional[str]):
        """
        Set data field with field name 'Class1' on this record model
        """
        self.set_field_value(self.CLASS1__FIELD_NAME.field_name, value)

    def get_Class1_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Class1' from this record model
        """
        return self.get_field_value(self.CLASS1__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_Subclass1_1_field(self, value: Optional[str]):
        """
        Set data field with field name 'Subclass1_1' on this record model
        """
        self.set_field_value(self.SUBCLASS1_1__FIELD_NAME.field_name, value)

    def get_Subclass1_1_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Subclass1_1' from this record model
        """
        return self.get_field_value(self.SUBCLASS1_1__FIELD_NAME.field_name)

    def set_Subclass1_1_1_field(self, value: Optional[str]):
        """
        Set data field with field name 'Subclass1_1_1' on this record model
        """
        self.set_field_value(self.SUBCLASS1_1_1__FIELD_NAME.field_name, value)

    def get_Subclass1_1_1_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Subclass1_1_1' from this record model
        """
        return self.get_field_value(self.SUBCLASS1_1_1__FIELD_NAME.field_name)

    def set_TotalCellNumbers_field(self, value: Optional[int]):
        """
        Set data field with field name 'TotalCellNumbers' on this record model
        """
        self.set_field_value(self.TOTALCELLNUMBERS__FIELD_NAME.field_name, value)

    def get_TotalCellNumbers_field(self) -> Optional[int]:
        """
        Get data field value with field name 'TotalCellNumbers' from this record model
        """
        return self.get_field_value(self.TOTALCELLNUMBERS__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)

    def set_ViableCellNumbers_field(self, value: Optional[int]):
        """
        Set data field with field name 'ViableCellNumbers' on this record model
        """
        self.set_field_value(self.VIABLECELLNUMBERS__FIELD_NAME.field_name, value)

    def get_ViableCellNumbers_field(self) -> Optional[int]:
        """
        Get data field value with field name 'ViableCellNumbers' from this record model
        """
        return self.get_field_value(self.VIABLECELLNUMBERS__FIELD_NAME.field_name)


class CellOntologyModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type CellOntology
    Data Type Display Name: Cell Ontology (Cell Ontologies)
    Fields: ClassID, CreatedBy, DataRecordName, DateCreated, Definitions, MultiParentLink695, PreferredLabel, Synonyms, VeloxLastModifiedBy, VeloxLastModifiedDate
    """
    DATA_TYPE_NAME: str = 'CellOntology'
    CLASSID__FIELD_NAME: WrapperField = WrapperField("ClassID", FieldType.STRING)
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    DEFINITIONS__FIELD_NAME: WrapperField = WrapperField("Definitions", FieldType.STRING)
    MULTIPARENTLINK695__FIELD_NAME: WrapperField = WrapperField("MultiParentLink695", FieldType.MULTIPARENTLINK)
    PREFERREDLABEL__FIELD_NAME: WrapperField = WrapperField("PreferredLabel", FieldType.STRING)
    SYNONYMS__FIELD_NAME: WrapperField = WrapperField("Synonyms", FieldType.STRING)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_ClassID_field(self, value: Optional[str]):
        """
        Set data field with field name 'ClassID' on this record model
        """
        self.set_field_value(self.CLASSID__FIELD_NAME.field_name, value)

    def get_ClassID_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ClassID' from this record model
        """
        return self.get_field_value(self.CLASSID__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_Definitions_field(self, value: Optional[str]):
        """
        Set data field with field name 'Definitions' on this record model
        """
        self.set_field_value(self.DEFINITIONS__FIELD_NAME.field_name, value)

    def get_Definitions_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Definitions' from this record model
        """
        return self.get_field_value(self.DEFINITIONS__FIELD_NAME.field_name)

    def set_PreferredLabel_field(self, value: Optional[str]):
        """
        Set data field with field name 'PreferredLabel' on this record model
        """
        self.set_field_value(self.PREFERREDLABEL__FIELD_NAME.field_name, value)

    def get_PreferredLabel_field(self) -> Optional[str]:
        """
        Get data field value with field name 'PreferredLabel' from this record model
        """
        return self.get_field_value(self.PREFERREDLABEL__FIELD_NAME.field_name)

    def set_Synonyms_field(self, value: Optional[str]):
        """
        Set data field with field name 'Synonyms' on this record model
        """
        self.set_field_value(self.SYNONYMS__FIELD_NAME.field_name, value)

    def get_Synonyms_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Synonyms' from this record model
        """
        return self.get_field_value(self.SYNONYMS__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class CentrifugeRunParametersModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type CentrifugeRunParameters
    Data Type Display Name: Centrifuge Run Parameters (Centrifuge Run Parameters)
    Fields: CreatedBy, DataRecordName, DateCreated, Duration, GForce, MultiParentLink215, RPM, TargetConcentration, TargetVolume, Temperature, VeloxLastModifiedBy, VeloxLastModifiedDate
    """
    DATA_TYPE_NAME: str = 'CentrifugeRunParameters'
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    DURATION__FIELD_NAME: WrapperField = WrapperField("Duration", FieldType.DOUBLE)
    GFORCE__FIELD_NAME: WrapperField = WrapperField("GForce", FieldType.DOUBLE)
    MULTIPARENTLINK215__FIELD_NAME: WrapperField = WrapperField("MultiParentLink215", FieldType.MULTIPARENTLINK)
    RPM__FIELD_NAME: WrapperField = WrapperField("RPM", FieldType.DOUBLE)
    TARGETCONCENTRATION__FIELD_NAME: WrapperField = WrapperField("TargetConcentration", FieldType.DOUBLE)
    TARGETVOLUME__FIELD_NAME: WrapperField = WrapperField("TargetVolume", FieldType.DOUBLE)
    TEMPERATURE__FIELD_NAME: WrapperField = WrapperField("Temperature", FieldType.DOUBLE)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_Duration_field(self, value: Optional[float]):
        """
        Set data field with field name 'Duration' on this record model
        """
        self.set_field_value(self.DURATION__FIELD_NAME.field_name, value)

    def get_Duration_field(self) -> Optional[float]:
        """
        Get data field value with field name 'Duration' from this record model
        """
        return self.get_field_value(self.DURATION__FIELD_NAME.field_name)

    def set_GForce_field(self, value: Optional[float]):
        """
        Set data field with field name 'GForce' on this record model
        """
        self.set_field_value(self.GFORCE__FIELD_NAME.field_name, value)

    def get_GForce_field(self) -> Optional[float]:
        """
        Get data field value with field name 'GForce' from this record model
        """
        return self.get_field_value(self.GFORCE__FIELD_NAME.field_name)

    def set_RPM_field(self, value: Optional[float]):
        """
        Set data field with field name 'RPM' on this record model
        """
        self.set_field_value(self.RPM__FIELD_NAME.field_name, value)

    def get_RPM_field(self) -> Optional[float]:
        """
        Get data field value with field name 'RPM' from this record model
        """
        return self.get_field_value(self.RPM__FIELD_NAME.field_name)

    def set_TargetConcentration_field(self, value: Optional[float]):
        """
        Set data field with field name 'TargetConcentration' on this record model
        """
        self.set_field_value(self.TARGETCONCENTRATION__FIELD_NAME.field_name, value)

    def get_TargetConcentration_field(self) -> Optional[float]:
        """
        Get data field value with field name 'TargetConcentration' from this record model
        """
        return self.get_field_value(self.TARGETCONCENTRATION__FIELD_NAME.field_name)

    def set_TargetVolume_field(self, value: Optional[float]):
        """
        Set data field with field name 'TargetVolume' on this record model
        """
        self.set_field_value(self.TARGETVOLUME__FIELD_NAME.field_name, value)

    def get_TargetVolume_field(self) -> Optional[float]:
        """
        Get data field value with field name 'TargetVolume' from this record model
        """
        return self.get_field_value(self.TARGETVOLUME__FIELD_NAME.field_name)

    def set_Temperature_field(self, value: Optional[float]):
        """
        Set data field with field name 'Temperature' on this record model
        """
        self.set_field_value(self.TEMPERATURE__FIELD_NAME.field_name, value)

    def get_Temperature_field(self) -> Optional[float]:
        """
        Get data field value with field name 'Temperature' from this record model
        """
        return self.get_field_value(self.TEMPERATURE__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class ChemCuratorQueueModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type ChemCuratorQueue
    Data Type Display Name: Chem Curator Queue (Chem Curator Queues)
    Fields: CreatedBy, DataRecordName, DateCreated, HeaderNameListJSON, ImportConfigLink, MOL, PartDataTypeName, PayloadData, ProblemType, VeloxLastModifiedBy, VeloxLastModifiedDate
    Describes data in the chem curator queue when automatic identity fails to completely determine which material a registered part or lot would have.
    """
    DATA_TYPE_NAME: str = 'ChemCuratorQueue'
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    HEADERNAMELISTJSON__FIELD_NAME: WrapperField = WrapperField("HeaderNameListJSON", FieldType.STRING)
    IMPORTCONFIGLINK__FIELD_NAME: WrapperField = WrapperField("ImportConfigLink", FieldType.SIDE_LINK)
    MOL__FIELD_NAME: WrapperField = WrapperField("MOL", FieldType.STRING)
    PARTDATATYPENAME__FIELD_NAME: WrapperField = WrapperField("PartDataTypeName", FieldType.STRING)
    PAYLOADDATA__FIELD_NAME: WrapperField = WrapperField("PayloadData", FieldType.STRING)
    PROBLEMTYPE__FIELD_NAME: WrapperField = WrapperField("ProblemType", FieldType.STRING)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_HeaderNameListJSON_field(self, value: Optional[str]):
        """
        Set data field with field name 'HeaderNameListJSON' on this record model
        """
        self.set_field_value(self.HEADERNAMELISTJSON__FIELD_NAME.field_name, value)

    def get_HeaderNameListJSON_field(self) -> Optional[str]:
        """
        Get data field value with field name 'HeaderNameListJSON' from this record model
        """
        return self.get_field_value(self.HEADERNAMELISTJSON__FIELD_NAME.field_name)

    def set_ImportConfigLink_field(self, value: Optional[int]):
        """
        Set data field with field name 'ImportConfigLink' on this record model
        """
        self.set_field_value(self.IMPORTCONFIGLINK__FIELD_NAME.field_name, value)

    def get_ImportConfigLink_field(self) -> Optional[int]:
        """
        Get data field value with field name 'ImportConfigLink' from this record model
        """
        return self.get_field_value(self.IMPORTCONFIGLINK__FIELD_NAME.field_name)

    def set_MOL_field(self, value: Optional[str]):
        """
        Set data field with field name 'MOL' on this record model
        """
        self.set_field_value(self.MOL__FIELD_NAME.field_name, value)

    def get_MOL_field(self) -> Optional[str]:
        """
        Get data field value with field name 'MOL' from this record model
        """
        return self.get_field_value(self.MOL__FIELD_NAME.field_name)

    def set_PartDataTypeName_field(self, value: Optional[str]):
        """
        Set data field with field name 'PartDataTypeName' on this record model
        """
        self.set_field_value(self.PARTDATATYPENAME__FIELD_NAME.field_name, value)

    def get_PartDataTypeName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'PartDataTypeName' from this record model
        """
        return self.get_field_value(self.PARTDATATYPENAME__FIELD_NAME.field_name)

    def set_PayloadData_field(self, value: Optional[str]):
        """
        Set data field with field name 'PayloadData' on this record model
        """
        self.set_field_value(self.PAYLOADDATA__FIELD_NAME.field_name, value)

    def get_PayloadData_field(self) -> Optional[str]:
        """
        Get data field value with field name 'PayloadData' from this record model
        """
        return self.get_field_value(self.PAYLOADDATA__FIELD_NAME.field_name)

    def set_ProblemType_field(self, value: Optional[str]):
        """
        Set data field with field name 'ProblemType' on this record model
        """
        self.set_field_value(self.PROBLEMTYPE__FIELD_NAME.field_name, value)

    def get_ProblemType_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ProblemType' from this record model
        """
        return self.get_field_value(self.PROBLEMTYPE__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class ChemicalReagentModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type ChemicalReagent
    Data Type Display Name: Chemical Reagent (Chemical Reagents)
    Fields: CAS, Charge, cLogP, ConsumableType, CreatedBy, CXSMILESHash, DataRecordName, DateCreated, ExactMass, ExpirationDate, Formula, GHSCautionCode, GHSHazardCode, GHSPictoCode, GHSSignal, HasOrStereoGroup, inchi, InchiKey, IsGHSClassified, IUPAC, LotNumber, MolecularWeight, PolarSurfaceArea, PubchemCid, Purity, RegistryId, SMILES, StereoRegHash, TotalHBondAcceptors, TotalHBondCount, VeloxLastModifiedBy, VeloxLastModifiedDate, Yield
    """
    DATA_TYPE_NAME: str = 'ChemicalReagent'
    CAS__FIELD_NAME: WrapperField = WrapperField("CAS", FieldType.STRING)
    CHARGE__FIELD_NAME: WrapperField = WrapperField("Charge", FieldType.INTEGER)
    CLOGP__FIELD_NAME: WrapperField = WrapperField("cLogP", FieldType.DOUBLE)
    CONSUMABLETYPE__FIELD_NAME: WrapperField = WrapperField("ConsumableType", FieldType.SELECTION)
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    CXSMILESHASH__FIELD_NAME: WrapperField = WrapperField("CXSMILESHash", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    EXACTMASS__FIELD_NAME: WrapperField = WrapperField("ExactMass", FieldType.DOUBLE)
    EXPIRATIONDATE__FIELD_NAME: WrapperField = WrapperField("ExpirationDate", FieldType.DATE)
    FORMULA__FIELD_NAME: WrapperField = WrapperField("Formula", FieldType.STRING)
    GHSCAUTIONCODE__FIELD_NAME: WrapperField = WrapperField("GHSCautionCode", FieldType.STRING)
    GHSHAZARDCODE__FIELD_NAME: WrapperField = WrapperField("GHSHazardCode", FieldType.STRING)
    GHSPICTOCODE__FIELD_NAME: WrapperField = WrapperField("GHSPictoCode", FieldType.STRING)
    GHSSIGNAL__FIELD_NAME: WrapperField = WrapperField("GHSSignal", FieldType.STRING)
    HASORSTEREOGROUP__FIELD_NAME: WrapperField = WrapperField("HasOrStereoGroup", FieldType.BOOLEAN)
    INCHI__FIELD_NAME: WrapperField = WrapperField("inchi", FieldType.STRING)
    INCHIKEY__FIELD_NAME: WrapperField = WrapperField("InchiKey", FieldType.STRING)
    ISGHSCLASSIFIED__FIELD_NAME: WrapperField = WrapperField("IsGHSClassified", FieldType.BOOLEAN)
    IUPAC__FIELD_NAME: WrapperField = WrapperField("IUPAC", FieldType.STRING)
    LOTNUMBER__FIELD_NAME: WrapperField = WrapperField("LotNumber", FieldType.STRING)
    MOLECULARWEIGHT__FIELD_NAME: WrapperField = WrapperField("MolecularWeight", FieldType.DOUBLE)
    POLARSURFACEAREA__FIELD_NAME: WrapperField = WrapperField("PolarSurfaceArea", FieldType.DOUBLE)
    PUBCHEMCID__FIELD_NAME: WrapperField = WrapperField("PubchemCid", FieldType.INTEGER)
    PURITY__FIELD_NAME: WrapperField = WrapperField("Purity", FieldType.DOUBLE)
    REGISTRYID__FIELD_NAME: WrapperField = WrapperField("RegistryId", FieldType.STRING)
    SMILES__FIELD_NAME: WrapperField = WrapperField("SMILES", FieldType.STRING)
    STEREOREGHASH__FIELD_NAME: WrapperField = WrapperField("StereoRegHash", FieldType.STRING)
    TOTALHBONDACCEPTORS__FIELD_NAME: WrapperField = WrapperField("TotalHBondAcceptors", FieldType.INTEGER)
    TOTALHBONDCOUNT__FIELD_NAME: WrapperField = WrapperField("TotalHBondCount", FieldType.INTEGER)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)
    YIELD__FIELD_NAME: WrapperField = WrapperField("Yield", FieldType.DOUBLE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_CAS_field(self, value: Optional[str]):
        """
        Set data field with field name 'CAS' on this record model
        """
        self.set_field_value(self.CAS__FIELD_NAME.field_name, value)

    def get_CAS_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CAS' from this record model
        """
        return self.get_field_value(self.CAS__FIELD_NAME.field_name)

    def set_Charge_field(self, value: Optional[int]):
        """
        Set data field with field name 'Charge' on this record model
        """
        self.set_field_value(self.CHARGE__FIELD_NAME.field_name, value)

    def get_Charge_field(self) -> Optional[int]:
        """
        Get data field value with field name 'Charge' from this record model
        """
        return self.get_field_value(self.CHARGE__FIELD_NAME.field_name)

    def set_cLogP_field(self, value: Optional[float]):
        """
        Set data field with field name 'cLogP' on this record model
        """
        self.set_field_value(self.CLOGP__FIELD_NAME.field_name, value)

    def get_cLogP_field(self) -> Optional[float]:
        """
        Get data field value with field name 'cLogP' from this record model
        """
        return self.get_field_value(self.CLOGP__FIELD_NAME.field_name)

    def set_ConsumableType_field(self, value: Optional[str]):
        """
        Set data field with field name 'ConsumableType' on this record model
        """
        self.set_field_value(self.CONSUMABLETYPE__FIELD_NAME.field_name, value)

    def get_ConsumableType_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ConsumableType' from this record model
        """
        return self.get_field_value(self.CONSUMABLETYPE__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def set_CXSMILESHash_field(self, value: Optional[str]):
        """
        Set data field with field name 'CXSMILESHash' on this record model
        """
        self.set_field_value(self.CXSMILESHASH__FIELD_NAME.field_name, value)

    def get_CXSMILESHash_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CXSMILESHash' from this record model
        """
        return self.get_field_value(self.CXSMILESHASH__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_ExactMass_field(self, value: Optional[float]):
        """
        Set data field with field name 'ExactMass' on this record model
        """
        self.set_field_value(self.EXACTMASS__FIELD_NAME.field_name, value)

    def get_ExactMass_field(self) -> Optional[float]:
        """
        Get data field value with field name 'ExactMass' from this record model
        """
        return self.get_field_value(self.EXACTMASS__FIELD_NAME.field_name)

    def set_ExpirationDate_field(self, value: Optional[int]):
        """
        Set data field with field name 'ExpirationDate' on this record model
        """
        self.set_field_value(self.EXPIRATIONDATE__FIELD_NAME.field_name, value)

    def get_ExpirationDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'ExpirationDate' from this record model
        """
        return self.get_field_value(self.EXPIRATIONDATE__FIELD_NAME.field_name)

    def set_Formula_field(self, value: Optional[str]):
        """
        Set data field with field name 'Formula' on this record model
        """
        self.set_field_value(self.FORMULA__FIELD_NAME.field_name, value)

    def get_Formula_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Formula' from this record model
        """
        return self.get_field_value(self.FORMULA__FIELD_NAME.field_name)

    def set_GHSCautionCode_field(self, value: Optional[str]):
        """
        Set data field with field name 'GHSCautionCode' on this record model
        """
        self.set_field_value(self.GHSCAUTIONCODE__FIELD_NAME.field_name, value)

    def get_GHSCautionCode_field(self) -> Optional[str]:
        """
        Get data field value with field name 'GHSCautionCode' from this record model
        """
        return self.get_field_value(self.GHSCAUTIONCODE__FIELD_NAME.field_name)

    def set_GHSHazardCode_field(self, value: Optional[str]):
        """
        Set data field with field name 'GHSHazardCode' on this record model
        """
        self.set_field_value(self.GHSHAZARDCODE__FIELD_NAME.field_name, value)

    def get_GHSHazardCode_field(self) -> Optional[str]:
        """
        Get data field value with field name 'GHSHazardCode' from this record model
        """
        return self.get_field_value(self.GHSHAZARDCODE__FIELD_NAME.field_name)

    def set_GHSPictoCode_field(self, value: Optional[str]):
        """
        Set data field with field name 'GHSPictoCode' on this record model
        """
        self.set_field_value(self.GHSPICTOCODE__FIELD_NAME.field_name, value)

    def get_GHSPictoCode_field(self) -> Optional[str]:
        """
        Get data field value with field name 'GHSPictoCode' from this record model
        """
        return self.get_field_value(self.GHSPICTOCODE__FIELD_NAME.field_name)

    def set_GHSSignal_field(self, value: Optional[str]):
        """
        Set data field with field name 'GHSSignal' on this record model
        """
        self.set_field_value(self.GHSSIGNAL__FIELD_NAME.field_name, value)

    def get_GHSSignal_field(self) -> Optional[str]:
        """
        Get data field value with field name 'GHSSignal' from this record model
        """
        return self.get_field_value(self.GHSSIGNAL__FIELD_NAME.field_name)

    def set_HasOrStereoGroup_field(self, value: Optional[bool]):
        """
        Set data field with field name 'HasOrStereoGroup' on this record model
        """
        self.set_field_value(self.HASORSTEREOGROUP__FIELD_NAME.field_name, value)

    def get_HasOrStereoGroup_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'HasOrStereoGroup' from this record model
        """
        return self.get_field_value(self.HASORSTEREOGROUP__FIELD_NAME.field_name)

    def set_inchi_field(self, value: Optional[str]):
        """
        Set data field with field name 'inchi' on this record model
        """
        self.set_field_value(self.INCHI__FIELD_NAME.field_name, value)

    def get_inchi_field(self) -> Optional[str]:
        """
        Get data field value with field name 'inchi' from this record model
        """
        return self.get_field_value(self.INCHI__FIELD_NAME.field_name)

    def set_InchiKey_field(self, value: Optional[str]):
        """
        Set data field with field name 'InchiKey' on this record model
        """
        self.set_field_value(self.INCHIKEY__FIELD_NAME.field_name, value)

    def get_InchiKey_field(self) -> Optional[str]:
        """
        Get data field value with field name 'InchiKey' from this record model
        """
        return self.get_field_value(self.INCHIKEY__FIELD_NAME.field_name)

    def set_IsGHSClassified_field(self, value: Optional[bool]):
        """
        Set data field with field name 'IsGHSClassified' on this record model
        """
        self.set_field_value(self.ISGHSCLASSIFIED__FIELD_NAME.field_name, value)

    def get_IsGHSClassified_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'IsGHSClassified' from this record model
        """
        return self.get_field_value(self.ISGHSCLASSIFIED__FIELD_NAME.field_name)

    def set_IUPAC_field(self, value: Optional[str]):
        """
        Set data field with field name 'IUPAC' on this record model
        """
        self.set_field_value(self.IUPAC__FIELD_NAME.field_name, value)

    def get_IUPAC_field(self) -> Optional[str]:
        """
        Get data field value with field name 'IUPAC' from this record model
        """
        return self.get_field_value(self.IUPAC__FIELD_NAME.field_name)

    def set_LotNumber_field(self, value: Optional[str]):
        """
        Set data field with field name 'LotNumber' on this record model
        """
        self.set_field_value(self.LOTNUMBER__FIELD_NAME.field_name, value)

    def get_LotNumber_field(self) -> Optional[str]:
        """
        Get data field value with field name 'LotNumber' from this record model
        """
        return self.get_field_value(self.LOTNUMBER__FIELD_NAME.field_name)

    def set_MolecularWeight_field(self, value: Optional[float]):
        """
        Set data field with field name 'MolecularWeight' on this record model
        """
        self.set_field_value(self.MOLECULARWEIGHT__FIELD_NAME.field_name, value)

    def get_MolecularWeight_field(self) -> Optional[float]:
        """
        Get data field value with field name 'MolecularWeight' from this record model
        """
        return self.get_field_value(self.MOLECULARWEIGHT__FIELD_NAME.field_name)

    def set_PolarSurfaceArea_field(self, value: Optional[float]):
        """
        Set data field with field name 'PolarSurfaceArea' on this record model
        """
        self.set_field_value(self.POLARSURFACEAREA__FIELD_NAME.field_name, value)

    def get_PolarSurfaceArea_field(self) -> Optional[float]:
        """
        Get data field value with field name 'PolarSurfaceArea' from this record model
        """
        return self.get_field_value(self.POLARSURFACEAREA__FIELD_NAME.field_name)

    def set_PubchemCid_field(self, value: Optional[int]):
        """
        Set data field with field name 'PubchemCid' on this record model
        """
        self.set_field_value(self.PUBCHEMCID__FIELD_NAME.field_name, value)

    def get_PubchemCid_field(self) -> Optional[int]:
        """
        Get data field value with field name 'PubchemCid' from this record model
        """
        return self.get_field_value(self.PUBCHEMCID__FIELD_NAME.field_name)

    def set_Purity_field(self, value: Optional[float]):
        """
        Set data field with field name 'Purity' on this record model
        """
        self.set_field_value(self.PURITY__FIELD_NAME.field_name, value)

    def get_Purity_field(self) -> Optional[float]:
        """
        Get data field value with field name 'Purity' from this record model
        """
        return self.get_field_value(self.PURITY__FIELD_NAME.field_name)

    def set_RegistryId_field(self, value: Optional[str]):
        """
        Set data field with field name 'RegistryId' on this record model
        """
        self.set_field_value(self.REGISTRYID__FIELD_NAME.field_name, value)

    def get_RegistryId_field(self) -> Optional[str]:
        """
        Get data field value with field name 'RegistryId' from this record model
        """
        return self.get_field_value(self.REGISTRYID__FIELD_NAME.field_name)

    def set_SMILES_field(self, value: Optional[str]):
        """
        Set data field with field name 'SMILES' on this record model
        """
        self.set_field_value(self.SMILES__FIELD_NAME.field_name, value)

    def get_SMILES_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SMILES' from this record model
        """
        return self.get_field_value(self.SMILES__FIELD_NAME.field_name)

    def set_StereoRegHash_field(self, value: Optional[str]):
        """
        Set data field with field name 'StereoRegHash' on this record model
        """
        self.set_field_value(self.STEREOREGHASH__FIELD_NAME.field_name, value)

    def get_StereoRegHash_field(self) -> Optional[str]:
        """
        Get data field value with field name 'StereoRegHash' from this record model
        """
        return self.get_field_value(self.STEREOREGHASH__FIELD_NAME.field_name)

    def set_TotalHBondAcceptors_field(self, value: Optional[int]):
        """
        Set data field with field name 'TotalHBondAcceptors' on this record model
        """
        self.set_field_value(self.TOTALHBONDACCEPTORS__FIELD_NAME.field_name, value)

    def get_TotalHBondAcceptors_field(self) -> Optional[int]:
        """
        Get data field value with field name 'TotalHBondAcceptors' from this record model
        """
        return self.get_field_value(self.TOTALHBONDACCEPTORS__FIELD_NAME.field_name)

    def set_TotalHBondCount_field(self, value: Optional[int]):
        """
        Set data field with field name 'TotalHBondCount' on this record model
        """
        self.set_field_value(self.TOTALHBONDCOUNT__FIELD_NAME.field_name, value)

    def get_TotalHBondCount_field(self) -> Optional[int]:
        """
        Get data field value with field name 'TotalHBondCount' from this record model
        """
        return self.get_field_value(self.TOTALHBONDCOUNT__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)

    def set_Yield_field(self, value: Optional[float]):
        """
        Set data field with field name 'Yield' on this record model
        """
        self.set_field_value(self.YIELD__FIELD_NAME.field_name, value)

    def get_Yield_field(self) -> Optional[float]:
        """
        Get data field value with field name 'Yield' from this record model
        """
        return self.get_field_value(self.YIELD__FIELD_NAME.field_name)


class ChemicalReagentPartModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type ChemicalReagentPart
    Data Type Display Name: Chemical Reagent Part (Chemical Reagent Parts)
    Fields: CAS, Charge, cLogP, ConsumableType, CreatedBy, CXSMILESHash, DataRecordName, DateCreated, Density, EditLock, ExactMass, Formula, GHSCautionCode, GHSHazardCode, GHSPictoCode, GHSSignal, HasOrStereoGroup, inchi, InchiKey, INCHIShadow, IsGHSClassified, IUPAC, MOL, MolecularWeight, PolarSurfaceArea, PubchemCid, QuantityOnHand, QuantityPerItem, RegisteredToCartridge, RegistryId, ReorderLevelQuantity, RequestImageUpdate, SMILES, SMILESShadow, StereoRegHash, TotalHBondAcceptors, TotalHBondCount, Units, VeloxLastModifiedBy, VeloxLastModifiedDate, Vendor
    """
    DATA_TYPE_NAME: str = 'ChemicalReagentPart'
    CAS__FIELD_NAME: WrapperField = WrapperField("CAS", FieldType.STRING)
    CHARGE__FIELD_NAME: WrapperField = WrapperField("Charge", FieldType.INTEGER)
    CLOGP__FIELD_NAME: WrapperField = WrapperField("cLogP", FieldType.DOUBLE)
    CONSUMABLETYPE__FIELD_NAME: WrapperField = WrapperField("ConsumableType", FieldType.SELECTION)
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    CXSMILESHASH__FIELD_NAME: WrapperField = WrapperField("CXSMILESHash", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    DENSITY__FIELD_NAME: WrapperField = WrapperField("Density", FieldType.DOUBLE)
    EDITLOCK__FIELD_NAME: WrapperField = WrapperField("EditLock", FieldType.BOOLEAN)
    EXACTMASS__FIELD_NAME: WrapperField = WrapperField("ExactMass", FieldType.DOUBLE)
    FORMULA__FIELD_NAME: WrapperField = WrapperField("Formula", FieldType.STRING)
    GHSCAUTIONCODE__FIELD_NAME: WrapperField = WrapperField("GHSCautionCode", FieldType.STRING)
    GHSHAZARDCODE__FIELD_NAME: WrapperField = WrapperField("GHSHazardCode", FieldType.STRING)
    GHSPICTOCODE__FIELD_NAME: WrapperField = WrapperField("GHSPictoCode", FieldType.STRING)
    GHSSIGNAL__FIELD_NAME: WrapperField = WrapperField("GHSSignal", FieldType.STRING)
    HASORSTEREOGROUP__FIELD_NAME: WrapperField = WrapperField("HasOrStereoGroup", FieldType.BOOLEAN)
    INCHI__FIELD_NAME: WrapperField = WrapperField("inchi", FieldType.STRING)
    INCHIKEY__FIELD_NAME: WrapperField = WrapperField("InchiKey", FieldType.STRING)
    INCHISHADOW__FIELD_NAME: WrapperField = WrapperField("INCHIShadow", FieldType.STRING)
    ISGHSCLASSIFIED__FIELD_NAME: WrapperField = WrapperField("IsGHSClassified", FieldType.BOOLEAN)
    IUPAC__FIELD_NAME: WrapperField = WrapperField("IUPAC", FieldType.STRING)
    MOL__FIELD_NAME: WrapperField = WrapperField("MOL", FieldType.STRING)
    MOLECULARWEIGHT__FIELD_NAME: WrapperField = WrapperField("MolecularWeight", FieldType.DOUBLE)
    POLARSURFACEAREA__FIELD_NAME: WrapperField = WrapperField("PolarSurfaceArea", FieldType.DOUBLE)
    PUBCHEMCID__FIELD_NAME: WrapperField = WrapperField("PubchemCid", FieldType.INTEGER)
    QUANTITYONHAND__FIELD_NAME: WrapperField = WrapperField("QuantityOnHand", FieldType.DOUBLE)
    QUANTITYPERITEM__FIELD_NAME: WrapperField = WrapperField("QuantityPerItem", FieldType.DOUBLE)
    REGISTEREDTOCARTRIDGE__FIELD_NAME: WrapperField = WrapperField("RegisteredToCartridge", FieldType.BOOLEAN)
    REGISTRYID__FIELD_NAME: WrapperField = WrapperField("RegistryId", FieldType.STRING)
    REORDERLEVELQUANTITY__FIELD_NAME: WrapperField = WrapperField("ReorderLevelQuantity", FieldType.DOUBLE)
    REQUESTIMAGEUPDATE__FIELD_NAME: WrapperField = WrapperField("RequestImageUpdate", FieldType.BOOLEAN)
    SMILES__FIELD_NAME: WrapperField = WrapperField("SMILES", FieldType.STRING)
    SMILESSHADOW__FIELD_NAME: WrapperField = WrapperField("SMILESShadow", FieldType.STRING)
    STEREOREGHASH__FIELD_NAME: WrapperField = WrapperField("StereoRegHash", FieldType.STRING)
    TOTALHBONDACCEPTORS__FIELD_NAME: WrapperField = WrapperField("TotalHBondAcceptors", FieldType.INTEGER)
    TOTALHBONDCOUNT__FIELD_NAME: WrapperField = WrapperField("TotalHBondCount", FieldType.INTEGER)
    UNITS__FIELD_NAME: WrapperField = WrapperField("Units", FieldType.PICKLIST)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)
    VENDOR__FIELD_NAME: WrapperField = WrapperField("Vendor", FieldType.SELECTION)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_CAS_field(self, value: Optional[str]):
        """
        Set data field with field name 'CAS' on this record model
        """
        self.set_field_value(self.CAS__FIELD_NAME.field_name, value)

    def get_CAS_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CAS' from this record model
        """
        return self.get_field_value(self.CAS__FIELD_NAME.field_name)

    def set_Charge_field(self, value: Optional[int]):
        """
        Set data field with field name 'Charge' on this record model
        """
        self.set_field_value(self.CHARGE__FIELD_NAME.field_name, value)

    def get_Charge_field(self) -> Optional[int]:
        """
        Get data field value with field name 'Charge' from this record model
        """
        return self.get_field_value(self.CHARGE__FIELD_NAME.field_name)

    def set_cLogP_field(self, value: Optional[float]):
        """
        Set data field with field name 'cLogP' on this record model
        """
        self.set_field_value(self.CLOGP__FIELD_NAME.field_name, value)

    def get_cLogP_field(self) -> Optional[float]:
        """
        Get data field value with field name 'cLogP' from this record model
        """
        return self.get_field_value(self.CLOGP__FIELD_NAME.field_name)

    def set_ConsumableType_field(self, value: Optional[str]):
        """
        Set data field with field name 'ConsumableType' on this record model
        """
        self.set_field_value(self.CONSUMABLETYPE__FIELD_NAME.field_name, value)

    def get_ConsumableType_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ConsumableType' from this record model
        """
        return self.get_field_value(self.CONSUMABLETYPE__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def set_CXSMILESHash_field(self, value: Optional[str]):
        """
        Set data field with field name 'CXSMILESHash' on this record model
        """
        self.set_field_value(self.CXSMILESHASH__FIELD_NAME.field_name, value)

    def get_CXSMILESHash_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CXSMILESHash' from this record model
        """
        return self.get_field_value(self.CXSMILESHASH__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_Density_field(self, value: Optional[float]):
        """
        Set data field with field name 'Density' on this record model
        """
        self.set_field_value(self.DENSITY__FIELD_NAME.field_name, value)

    def get_Density_field(self) -> Optional[float]:
        """
        Get data field value with field name 'Density' from this record model
        """
        return self.get_field_value(self.DENSITY__FIELD_NAME.field_name)

    def set_EditLock_field(self, value: Optional[bool]):
        """
        Set data field with field name 'EditLock' on this record model
        """
        self.set_field_value(self.EDITLOCK__FIELD_NAME.field_name, value)

    def get_EditLock_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'EditLock' from this record model
        """
        return self.get_field_value(self.EDITLOCK__FIELD_NAME.field_name)

    def set_ExactMass_field(self, value: Optional[float]):
        """
        Set data field with field name 'ExactMass' on this record model
        """
        self.set_field_value(self.EXACTMASS__FIELD_NAME.field_name, value)

    def get_ExactMass_field(self) -> Optional[float]:
        """
        Get data field value with field name 'ExactMass' from this record model
        """
        return self.get_field_value(self.EXACTMASS__FIELD_NAME.field_name)

    def set_Formula_field(self, value: Optional[str]):
        """
        Set data field with field name 'Formula' on this record model
        """
        self.set_field_value(self.FORMULA__FIELD_NAME.field_name, value)

    def get_Formula_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Formula' from this record model
        """
        return self.get_field_value(self.FORMULA__FIELD_NAME.field_name)

    def set_GHSCautionCode_field(self, value: Optional[str]):
        """
        Set data field with field name 'GHSCautionCode' on this record model
        """
        self.set_field_value(self.GHSCAUTIONCODE__FIELD_NAME.field_name, value)

    def get_GHSCautionCode_field(self) -> Optional[str]:
        """
        Get data field value with field name 'GHSCautionCode' from this record model
        """
        return self.get_field_value(self.GHSCAUTIONCODE__FIELD_NAME.field_name)

    def set_GHSHazardCode_field(self, value: Optional[str]):
        """
        Set data field with field name 'GHSHazardCode' on this record model
        """
        self.set_field_value(self.GHSHAZARDCODE__FIELD_NAME.field_name, value)

    def get_GHSHazardCode_field(self) -> Optional[str]:
        """
        Get data field value with field name 'GHSHazardCode' from this record model
        """
        return self.get_field_value(self.GHSHAZARDCODE__FIELD_NAME.field_name)

    def set_GHSPictoCode_field(self, value: Optional[str]):
        """
        Set data field with field name 'GHSPictoCode' on this record model
        """
        self.set_field_value(self.GHSPICTOCODE__FIELD_NAME.field_name, value)

    def get_GHSPictoCode_field(self) -> Optional[str]:
        """
        Get data field value with field name 'GHSPictoCode' from this record model
        """
        return self.get_field_value(self.GHSPICTOCODE__FIELD_NAME.field_name)

    def set_GHSSignal_field(self, value: Optional[str]):
        """
        Set data field with field name 'GHSSignal' on this record model
        """
        self.set_field_value(self.GHSSIGNAL__FIELD_NAME.field_name, value)

    def get_GHSSignal_field(self) -> Optional[str]:
        """
        Get data field value with field name 'GHSSignal' from this record model
        """
        return self.get_field_value(self.GHSSIGNAL__FIELD_NAME.field_name)

    def set_HasOrStereoGroup_field(self, value: Optional[bool]):
        """
        Set data field with field name 'HasOrStereoGroup' on this record model
        """
        self.set_field_value(self.HASORSTEREOGROUP__FIELD_NAME.field_name, value)

    def get_HasOrStereoGroup_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'HasOrStereoGroup' from this record model
        """
        return self.get_field_value(self.HASORSTEREOGROUP__FIELD_NAME.field_name)

    def set_inchi_field(self, value: Optional[str]):
        """
        Set data field with field name 'inchi' on this record model
        """
        self.set_field_value(self.INCHI__FIELD_NAME.field_name, value)

    def get_inchi_field(self) -> Optional[str]:
        """
        Get data field value with field name 'inchi' from this record model
        """
        return self.get_field_value(self.INCHI__FIELD_NAME.field_name)

    def set_InchiKey_field(self, value: Optional[str]):
        """
        Set data field with field name 'InchiKey' on this record model
        """
        self.set_field_value(self.INCHIKEY__FIELD_NAME.field_name, value)

    def get_InchiKey_field(self) -> Optional[str]:
        """
        Get data field value with field name 'InchiKey' from this record model
        """
        return self.get_field_value(self.INCHIKEY__FIELD_NAME.field_name)

    def set_INCHIShadow_field(self, value: Optional[str]):
        """
        Set data field with field name 'INCHIShadow' on this record model
        """
        self.set_field_value(self.INCHISHADOW__FIELD_NAME.field_name, value)

    def get_INCHIShadow_field(self) -> Optional[str]:
        """
        Get data field value with field name 'INCHIShadow' from this record model
        """
        return self.get_field_value(self.INCHISHADOW__FIELD_NAME.field_name)

    def set_IsGHSClassified_field(self, value: Optional[bool]):
        """
        Set data field with field name 'IsGHSClassified' on this record model
        """
        self.set_field_value(self.ISGHSCLASSIFIED__FIELD_NAME.field_name, value)

    def get_IsGHSClassified_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'IsGHSClassified' from this record model
        """
        return self.get_field_value(self.ISGHSCLASSIFIED__FIELD_NAME.field_name)

    def set_IUPAC_field(self, value: Optional[str]):
        """
        Set data field with field name 'IUPAC' on this record model
        """
        self.set_field_value(self.IUPAC__FIELD_NAME.field_name, value)

    def get_IUPAC_field(self) -> Optional[str]:
        """
        Get data field value with field name 'IUPAC' from this record model
        """
        return self.get_field_value(self.IUPAC__FIELD_NAME.field_name)

    def set_MOL_field(self, value: Optional[str]):
        """
        Set data field with field name 'MOL' on this record model
        """
        self.set_field_value(self.MOL__FIELD_NAME.field_name, value)

    def get_MOL_field(self) -> Optional[str]:
        """
        Get data field value with field name 'MOL' from this record model
        """
        return self.get_field_value(self.MOL__FIELD_NAME.field_name)

    def set_MolecularWeight_field(self, value: Optional[float]):
        """
        Set data field with field name 'MolecularWeight' on this record model
        """
        self.set_field_value(self.MOLECULARWEIGHT__FIELD_NAME.field_name, value)

    def get_MolecularWeight_field(self) -> Optional[float]:
        """
        Get data field value with field name 'MolecularWeight' from this record model
        """
        return self.get_field_value(self.MOLECULARWEIGHT__FIELD_NAME.field_name)

    def set_PolarSurfaceArea_field(self, value: Optional[float]):
        """
        Set data field with field name 'PolarSurfaceArea' on this record model
        """
        self.set_field_value(self.POLARSURFACEAREA__FIELD_NAME.field_name, value)

    def get_PolarSurfaceArea_field(self) -> Optional[float]:
        """
        Get data field value with field name 'PolarSurfaceArea' from this record model
        """
        return self.get_field_value(self.POLARSURFACEAREA__FIELD_NAME.field_name)

    def set_PubchemCid_field(self, value: Optional[int]):
        """
        Set data field with field name 'PubchemCid' on this record model
        """
        self.set_field_value(self.PUBCHEMCID__FIELD_NAME.field_name, value)

    def get_PubchemCid_field(self) -> Optional[int]:
        """
        Get data field value with field name 'PubchemCid' from this record model
        """
        return self.get_field_value(self.PUBCHEMCID__FIELD_NAME.field_name)

    def set_QuantityOnHand_field(self, value: Optional[float]):
        """
        Set data field with field name 'QuantityOnHand' on this record model
        """
        self.set_field_value(self.QUANTITYONHAND__FIELD_NAME.field_name, value)

    def get_QuantityOnHand_field(self) -> Optional[float]:
        """
        Get data field value with field name 'QuantityOnHand' from this record model
        """
        return self.get_field_value(self.QUANTITYONHAND__FIELD_NAME.field_name)

    def set_QuantityPerItem_field(self, value: Optional[float]):
        """
        Set data field with field name 'QuantityPerItem' on this record model
        """
        self.set_field_value(self.QUANTITYPERITEM__FIELD_NAME.field_name, value)

    def get_QuantityPerItem_field(self) -> Optional[float]:
        """
        Get data field value with field name 'QuantityPerItem' from this record model
        """
        return self.get_field_value(self.QUANTITYPERITEM__FIELD_NAME.field_name)

    def set_RegisteredToCartridge_field(self, value: Optional[bool]):
        """
        Set data field with field name 'RegisteredToCartridge' on this record model
        """
        self.set_field_value(self.REGISTEREDTOCARTRIDGE__FIELD_NAME.field_name, value)

    def get_RegisteredToCartridge_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'RegisteredToCartridge' from this record model
        """
        return self.get_field_value(self.REGISTEREDTOCARTRIDGE__FIELD_NAME.field_name)

    def set_RegistryId_field(self, value: Optional[str]):
        """
        Set data field with field name 'RegistryId' on this record model
        """
        self.set_field_value(self.REGISTRYID__FIELD_NAME.field_name, value)

    def get_RegistryId_field(self) -> Optional[str]:
        """
        Get data field value with field name 'RegistryId' from this record model
        """
        return self.get_field_value(self.REGISTRYID__FIELD_NAME.field_name)

    def set_ReorderLevelQuantity_field(self, value: Optional[float]):
        """
        Set data field with field name 'ReorderLevelQuantity' on this record model
        """
        self.set_field_value(self.REORDERLEVELQUANTITY__FIELD_NAME.field_name, value)

    def get_ReorderLevelQuantity_field(self) -> Optional[float]:
        """
        Get data field value with field name 'ReorderLevelQuantity' from this record model
        """
        return self.get_field_value(self.REORDERLEVELQUANTITY__FIELD_NAME.field_name)

    def set_RequestImageUpdate_field(self, value: Optional[bool]):
        """
        Set data field with field name 'RequestImageUpdate' on this record model
        """
        self.set_field_value(self.REQUESTIMAGEUPDATE__FIELD_NAME.field_name, value)

    def get_RequestImageUpdate_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'RequestImageUpdate' from this record model
        """
        return self.get_field_value(self.REQUESTIMAGEUPDATE__FIELD_NAME.field_name)

    def set_SMILES_field(self, value: Optional[str]):
        """
        Set data field with field name 'SMILES' on this record model
        """
        self.set_field_value(self.SMILES__FIELD_NAME.field_name, value)

    def get_SMILES_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SMILES' from this record model
        """
        return self.get_field_value(self.SMILES__FIELD_NAME.field_name)

    def set_SMILESShadow_field(self, value: Optional[str]):
        """
        Set data field with field name 'SMILESShadow' on this record model
        """
        self.set_field_value(self.SMILESSHADOW__FIELD_NAME.field_name, value)

    def get_SMILESShadow_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SMILESShadow' from this record model
        """
        return self.get_field_value(self.SMILESSHADOW__FIELD_NAME.field_name)

    def set_StereoRegHash_field(self, value: Optional[str]):
        """
        Set data field with field name 'StereoRegHash' on this record model
        """
        self.set_field_value(self.STEREOREGHASH__FIELD_NAME.field_name, value)

    def get_StereoRegHash_field(self) -> Optional[str]:
        """
        Get data field value with field name 'StereoRegHash' from this record model
        """
        return self.get_field_value(self.STEREOREGHASH__FIELD_NAME.field_name)

    def set_TotalHBondAcceptors_field(self, value: Optional[int]):
        """
        Set data field with field name 'TotalHBondAcceptors' on this record model
        """
        self.set_field_value(self.TOTALHBONDACCEPTORS__FIELD_NAME.field_name, value)

    def get_TotalHBondAcceptors_field(self) -> Optional[int]:
        """
        Get data field value with field name 'TotalHBondAcceptors' from this record model
        """
        return self.get_field_value(self.TOTALHBONDACCEPTORS__FIELD_NAME.field_name)

    def set_TotalHBondCount_field(self, value: Optional[int]):
        """
        Set data field with field name 'TotalHBondCount' on this record model
        """
        self.set_field_value(self.TOTALHBONDCOUNT__FIELD_NAME.field_name, value)

    def get_TotalHBondCount_field(self) -> Optional[int]:
        """
        Get data field value with field name 'TotalHBondCount' from this record model
        """
        return self.get_field_value(self.TOTALHBONDCOUNT__FIELD_NAME.field_name)

    def set_Units_field(self, value: Optional[str]):
        """
        Set data field with field name 'Units' on this record model
        """
        self.set_field_value(self.UNITS__FIELD_NAME.field_name, value)

    def get_Units_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Units' from this record model
        """
        return self.get_field_value(self.UNITS__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)

    def set_Vendor_field(self, value: Optional[str]):
        """
        Set data field with field name 'Vendor' on this record model
        """
        self.set_field_value(self.VENDOR__FIELD_NAME.field_name, value)

    def get_Vendor_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Vendor' from this record model
        """
        return self.get_field_value(self.VENDOR__FIELD_NAME.field_name)


class ChemistryMaterialTypeSettingsModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type ChemistryMaterialTypeSettings
    Data Type Display Name: Chemistry Material Type Settings (Chemistry Material Type Settingses)
    Fields: AccessionCode, AccessionPaddings, AccessionStartingValue, CreatedBy, DataRecordName, DateCreated, EnableEnhancedStereochemistry, LockedFieldsOverride, ManagerGroups, ManualStereoResolution, ReactionProduct, ReactionReactant, RegistryDataType, ResolveCanonicalTautomer, SaltMode, SaltPaddings, SystemDefined, ThreeTier, VeloxLastModifiedBy, VeloxLastModifiedDate
    """
    DATA_TYPE_NAME: str = 'ChemistryMaterialTypeSettings'
    ACCESSIONCODE__FIELD_NAME: WrapperField = WrapperField("AccessionCode", FieldType.STRING)
    ACCESSIONPADDINGS__FIELD_NAME: WrapperField = WrapperField("AccessionPaddings", FieldType.INTEGER)
    ACCESSIONSTARTINGVALUE__FIELD_NAME: WrapperField = WrapperField("AccessionStartingValue", FieldType.INTEGER)
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    ENABLEENHANCEDSTEREOCHEMISTRY__FIELD_NAME: WrapperField = WrapperField("EnableEnhancedStereochemistry", FieldType.BOOLEAN)
    LOCKEDFIELDSOVERRIDE__FIELD_NAME: WrapperField = WrapperField("LockedFieldsOverride", FieldType.SELECTION)
    MANAGERGROUPS__FIELD_NAME: WrapperField = WrapperField("ManagerGroups", FieldType.SELECTION)
    MANUALSTEREORESOLUTION__FIELD_NAME: WrapperField = WrapperField("ManualStereoResolution", FieldType.BOOLEAN)
    REACTIONPRODUCT__FIELD_NAME: WrapperField = WrapperField("ReactionProduct", FieldType.BOOLEAN)
    REACTIONREACTANT__FIELD_NAME: WrapperField = WrapperField("ReactionReactant", FieldType.BOOLEAN)
    REGISTRYDATATYPE__FIELD_NAME: WrapperField = WrapperField("RegistryDataType", FieldType.SELECTION)
    RESOLVECANONICALTAUTOMER__FIELD_NAME: WrapperField = WrapperField("ResolveCanonicalTautomer", FieldType.BOOLEAN)
    SALTMODE__FIELD_NAME: WrapperField = WrapperField("SaltMode", FieldType.PICKLIST)
    SALTPADDINGS__FIELD_NAME: WrapperField = WrapperField("SaltPaddings", FieldType.INTEGER)
    SYSTEMDEFINED__FIELD_NAME: WrapperField = WrapperField("SystemDefined", FieldType.BOOLEAN)
    THREETIER__FIELD_NAME: WrapperField = WrapperField("ThreeTier", FieldType.BOOLEAN)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_AccessionCode_field(self, value: Optional[str]):
        """
        Set data field with field name 'AccessionCode' on this record model
        """
        self.set_field_value(self.ACCESSIONCODE__FIELD_NAME.field_name, value)

    def get_AccessionCode_field(self) -> Optional[str]:
        """
        Get data field value with field name 'AccessionCode' from this record model
        """
        return self.get_field_value(self.ACCESSIONCODE__FIELD_NAME.field_name)

    def set_AccessionPaddings_field(self, value: Optional[int]):
        """
        Set data field with field name 'AccessionPaddings' on this record model
        """
        self.set_field_value(self.ACCESSIONPADDINGS__FIELD_NAME.field_name, value)

    def get_AccessionPaddings_field(self) -> Optional[int]:
        """
        Get data field value with field name 'AccessionPaddings' from this record model
        """
        return self.get_field_value(self.ACCESSIONPADDINGS__FIELD_NAME.field_name)

    def set_AccessionStartingValue_field(self, value: Optional[int]):
        """
        Set data field with field name 'AccessionStartingValue' on this record model
        """
        self.set_field_value(self.ACCESSIONSTARTINGVALUE__FIELD_NAME.field_name, value)

    def get_AccessionStartingValue_field(self) -> Optional[int]:
        """
        Get data field value with field name 'AccessionStartingValue' from this record model
        """
        return self.get_field_value(self.ACCESSIONSTARTINGVALUE__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_EnableEnhancedStereochemistry_field(self, value: Optional[bool]):
        """
        Set data field with field name 'EnableEnhancedStereochemistry' on this record model
        """
        self.set_field_value(self.ENABLEENHANCEDSTEREOCHEMISTRY__FIELD_NAME.field_name, value)

    def get_EnableEnhancedStereochemistry_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'EnableEnhancedStereochemistry' from this record model
        """
        return self.get_field_value(self.ENABLEENHANCEDSTEREOCHEMISTRY__FIELD_NAME.field_name)

    def set_LockedFieldsOverride_field(self, value: Optional[str]):
        """
        Set data field with field name 'LockedFieldsOverride' on this record model
        """
        self.set_field_value(self.LOCKEDFIELDSOVERRIDE__FIELD_NAME.field_name, value)

    def get_LockedFieldsOverride_field(self) -> Optional[str]:
        """
        Get data field value with field name 'LockedFieldsOverride' from this record model
        """
        return self.get_field_value(self.LOCKEDFIELDSOVERRIDE__FIELD_NAME.field_name)

    def set_ManagerGroups_field(self, value: Optional[str]):
        """
        Set data field with field name 'ManagerGroups' on this record model
        """
        self.set_field_value(self.MANAGERGROUPS__FIELD_NAME.field_name, value)

    def get_ManagerGroups_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ManagerGroups' from this record model
        """
        return self.get_field_value(self.MANAGERGROUPS__FIELD_NAME.field_name)

    def set_ManualStereoResolution_field(self, value: Optional[bool]):
        """
        Set data field with field name 'ManualStereoResolution' on this record model
        """
        self.set_field_value(self.MANUALSTEREORESOLUTION__FIELD_NAME.field_name, value)

    def get_ManualStereoResolution_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'ManualStereoResolution' from this record model
        """
        return self.get_field_value(self.MANUALSTEREORESOLUTION__FIELD_NAME.field_name)

    def set_ReactionProduct_field(self, value: Optional[bool]):
        """
        Set data field with field name 'ReactionProduct' on this record model
        """
        self.set_field_value(self.REACTIONPRODUCT__FIELD_NAME.field_name, value)

    def get_ReactionProduct_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'ReactionProduct' from this record model
        """
        return self.get_field_value(self.REACTIONPRODUCT__FIELD_NAME.field_name)

    def set_ReactionReactant_field(self, value: Optional[bool]):
        """
        Set data field with field name 'ReactionReactant' on this record model
        """
        self.set_field_value(self.REACTIONREACTANT__FIELD_NAME.field_name, value)

    def get_ReactionReactant_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'ReactionReactant' from this record model
        """
        return self.get_field_value(self.REACTIONREACTANT__FIELD_NAME.field_name)

    def set_RegistryDataType_field(self, value: Optional[str]):
        """
        Set data field with field name 'RegistryDataType' on this record model
        """
        self.set_field_value(self.REGISTRYDATATYPE__FIELD_NAME.field_name, value)

    def get_RegistryDataType_field(self) -> Optional[str]:
        """
        Get data field value with field name 'RegistryDataType' from this record model
        """
        return self.get_field_value(self.REGISTRYDATATYPE__FIELD_NAME.field_name)

    def set_ResolveCanonicalTautomer_field(self, value: Optional[bool]):
        """
        Set data field with field name 'ResolveCanonicalTautomer' on this record model
        """
        self.set_field_value(self.RESOLVECANONICALTAUTOMER__FIELD_NAME.field_name, value)

    def get_ResolveCanonicalTautomer_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'ResolveCanonicalTautomer' from this record model
        """
        return self.get_field_value(self.RESOLVECANONICALTAUTOMER__FIELD_NAME.field_name)

    def set_SaltMode_field(self, value: Optional[str]):
        """
        Set data field with field name 'SaltMode' on this record model
        """
        self.set_field_value(self.SALTMODE__FIELD_NAME.field_name, value)

    def get_SaltMode_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SaltMode' from this record model
        """
        return self.get_field_value(self.SALTMODE__FIELD_NAME.field_name)

    def set_SaltPaddings_field(self, value: Optional[int]):
        """
        Set data field with field name 'SaltPaddings' on this record model
        """
        self.set_field_value(self.SALTPADDINGS__FIELD_NAME.field_name, value)

    def get_SaltPaddings_field(self) -> Optional[int]:
        """
        Get data field value with field name 'SaltPaddings' from this record model
        """
        return self.get_field_value(self.SALTPADDINGS__FIELD_NAME.field_name)

    def set_SystemDefined_field(self, value: Optional[bool]):
        """
        Set data field with field name 'SystemDefined' on this record model
        """
        self.set_field_value(self.SYSTEMDEFINED__FIELD_NAME.field_name, value)

    def get_SystemDefined_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'SystemDefined' from this record model
        """
        return self.get_field_value(self.SYSTEMDEFINED__FIELD_NAME.field_name)

    def set_ThreeTier_field(self, value: Optional[bool]):
        """
        Set data field with field name 'ThreeTier' on this record model
        """
        self.set_field_value(self.THREETIER__FIELD_NAME.field_name, value)

    def get_ThreeTier_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'ThreeTier' from this record model
        """
        return self.get_field_value(self.THREETIER__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class ChemReactionDataFileModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type ChemReactionDataFile
    Data Type Display Name: Chem Reaction Data File (Chem Reaction Data Files)
    Fields: CreatedBy, DataRecordName, DateCreated, FilePath, VeloxCurrentVersion, VeloxLastModifiedBy, VeloxLastModifiedDate
    Describes raw chemical reaction data of the parent reaction data type.
    """
    DATA_TYPE_NAME: str = 'ChemReactionDataFile'
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    FILEPATH__FIELD_NAME: WrapperField = WrapperField("FilePath", FieldType.STRING)
    VELOXCURRENTVERSION__FIELD_NAME: WrapperField = WrapperField("VeloxCurrentVersion", FieldType.INTEGER)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_FilePath_field(self, value: Optional[str]):
        """
        Set data field with field name 'FilePath' on this record model
        """
        self.set_field_value(self.FILEPATH__FIELD_NAME.field_name, value)

    def get_FilePath_field(self) -> Optional[str]:
        """
        Get data field value with field name 'FilePath' from this record model
        """
        return self.get_field_value(self.FILEPATH__FIELD_NAME.field_name)

    def set_VeloxCurrentVersion_field(self, value: Optional[int]):
        """
        Set data field with field name 'VeloxCurrentVersion' on this record model
        """
        self.set_field_value(self.VELOXCURRENTVERSION__FIELD_NAME.field_name, value)

    def get_VeloxCurrentVersion_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxCurrentVersion' from this record model
        """
        return self.get_field_value(self.VELOXCURRENTVERSION__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class ChemRegistrySavedFieldMapModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type ChemRegistrySavedFieldMap
    Data Type Display Name: Chem Registry Saved Field Map (Chem Registry Saved Field Maps)
    Fields: CreatedBy, DataRecordName, DateCreated, FieldMapDataTypeName, FilePath, Name, VeloxCurrentVersion, VeloxLastModifiedBy, VeloxLastModifiedDate
    Saved field maps for people to use in importing CSV and SDF files.
    """
    DATA_TYPE_NAME: str = 'ChemRegistrySavedFieldMap'
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    FIELDMAPDATATYPENAME__FIELD_NAME: WrapperField = WrapperField("FieldMapDataTypeName", FieldType.STRING)
    FILEPATH__FIELD_NAME: WrapperField = WrapperField("FilePath", FieldType.STRING)
    NAME__FIELD_NAME: WrapperField = WrapperField("Name", FieldType.STRING)
    VELOXCURRENTVERSION__FIELD_NAME: WrapperField = WrapperField("VeloxCurrentVersion", FieldType.INTEGER)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_FieldMapDataTypeName_field(self, value: Optional[str]):
        """
        Set data field with field name 'FieldMapDataTypeName' on this record model
        """
        self.set_field_value(self.FIELDMAPDATATYPENAME__FIELD_NAME.field_name, value)

    def get_FieldMapDataTypeName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'FieldMapDataTypeName' from this record model
        """
        return self.get_field_value(self.FIELDMAPDATATYPENAME__FIELD_NAME.field_name)

    def set_FilePath_field(self, value: Optional[str]):
        """
        Set data field with field name 'FilePath' on this record model
        """
        self.set_field_value(self.FILEPATH__FIELD_NAME.field_name, value)

    def get_FilePath_field(self) -> Optional[str]:
        """
        Get data field value with field name 'FilePath' from this record model
        """
        return self.get_field_value(self.FILEPATH__FIELD_NAME.field_name)

    def set_Name_field(self, value: Optional[str]):
        """
        Set data field with field name 'Name' on this record model
        """
        self.set_field_value(self.NAME__FIELD_NAME.field_name, value)

    def get_Name_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Name' from this record model
        """
        return self.get_field_value(self.NAME__FIELD_NAME.field_name)

    def set_VeloxCurrentVersion_field(self, value: Optional[int]):
        """
        Set data field with field name 'VeloxCurrentVersion' on this record model
        """
        self.set_field_value(self.VELOXCURRENTVERSION__FIELD_NAME.field_name, value)

    def get_VeloxCurrentVersion_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxCurrentVersion' from this record model
        """
        return self.get_field_value(self.VELOXCURRENTVERSION__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class ChemRegPartModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type ChemRegPart
    Data Type Display Name: Company X Reagent Part (Company X Reagent Parts)
    Fields: CAS, Charge, cLogP, ConsumableType, CreatedBy, DataRecordName, DateCreated, ExactMass, Formula, GHSCautionCode, GHSHazardCode, GHSPictoCode, GHSSignal, inchi, InchiKey, IsGHSClassified, IUPAC, LotNumber, MolecularWeight, PolarSurfaceArea, PubchemCid, Purity, RegistryId, SMILES, TotalHBondAcceptors, TotalHBondCount, VeloxLastModifiedBy, VeloxLastModifiedDate, Yield
    The ChemRegPart Data Type
    """
    DATA_TYPE_NAME: str = 'ChemRegPart'
    CAS__FIELD_NAME: WrapperField = WrapperField("CAS", FieldType.STRING)
    CHARGE__FIELD_NAME: WrapperField = WrapperField("Charge", FieldType.INTEGER)
    CLOGP__FIELD_NAME: WrapperField = WrapperField("cLogP", FieldType.DOUBLE)
    CONSUMABLETYPE__FIELD_NAME: WrapperField = WrapperField("ConsumableType", FieldType.SELECTION)
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    EXACTMASS__FIELD_NAME: WrapperField = WrapperField("ExactMass", FieldType.DOUBLE)
    FORMULA__FIELD_NAME: WrapperField = WrapperField("Formula", FieldType.STRING)
    GHSCAUTIONCODE__FIELD_NAME: WrapperField = WrapperField("GHSCautionCode", FieldType.STRING)
    GHSHAZARDCODE__FIELD_NAME: WrapperField = WrapperField("GHSHazardCode", FieldType.STRING)
    GHSPICTOCODE__FIELD_NAME: WrapperField = WrapperField("GHSPictoCode", FieldType.STRING)
    GHSSIGNAL__FIELD_NAME: WrapperField = WrapperField("GHSSignal", FieldType.STRING)
    INCHI__FIELD_NAME: WrapperField = WrapperField("inchi", FieldType.STRING)
    INCHIKEY__FIELD_NAME: WrapperField = WrapperField("InchiKey", FieldType.STRING)
    ISGHSCLASSIFIED__FIELD_NAME: WrapperField = WrapperField("IsGHSClassified", FieldType.BOOLEAN)
    IUPAC__FIELD_NAME: WrapperField = WrapperField("IUPAC", FieldType.STRING)
    LOTNUMBER__FIELD_NAME: WrapperField = WrapperField("LotNumber", FieldType.STRING)
    MOLECULARWEIGHT__FIELD_NAME: WrapperField = WrapperField("MolecularWeight", FieldType.DOUBLE)
    POLARSURFACEAREA__FIELD_NAME: WrapperField = WrapperField("PolarSurfaceArea", FieldType.DOUBLE)
    PUBCHEMCID__FIELD_NAME: WrapperField = WrapperField("PubchemCid", FieldType.INTEGER)
    PURITY__FIELD_NAME: WrapperField = WrapperField("Purity", FieldType.DOUBLE)
    REGISTRYID__FIELD_NAME: WrapperField = WrapperField("RegistryId", FieldType.STRING)
    SMILES__FIELD_NAME: WrapperField = WrapperField("SMILES", FieldType.STRING)
    TOTALHBONDACCEPTORS__FIELD_NAME: WrapperField = WrapperField("TotalHBondAcceptors", FieldType.INTEGER)
    TOTALHBONDCOUNT__FIELD_NAME: WrapperField = WrapperField("TotalHBondCount", FieldType.INTEGER)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)
    YIELD__FIELD_NAME: WrapperField = WrapperField("Yield", FieldType.DOUBLE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_CAS_field(self, value: Optional[str]):
        """
        Set data field with field name 'CAS' on this record model
        """
        self.set_field_value(self.CAS__FIELD_NAME.field_name, value)

    def get_CAS_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CAS' from this record model
        """
        return self.get_field_value(self.CAS__FIELD_NAME.field_name)

    def set_Charge_field(self, value: Optional[int]):
        """
        Set data field with field name 'Charge' on this record model
        """
        self.set_field_value(self.CHARGE__FIELD_NAME.field_name, value)

    def get_Charge_field(self) -> Optional[int]:
        """
        Get data field value with field name 'Charge' from this record model
        """
        return self.get_field_value(self.CHARGE__FIELD_NAME.field_name)

    def set_cLogP_field(self, value: Optional[float]):
        """
        Set data field with field name 'cLogP' on this record model
        """
        self.set_field_value(self.CLOGP__FIELD_NAME.field_name, value)

    def get_cLogP_field(self) -> Optional[float]:
        """
        Get data field value with field name 'cLogP' from this record model
        """
        return self.get_field_value(self.CLOGP__FIELD_NAME.field_name)

    def set_ConsumableType_field(self, value: Optional[str]):
        """
        Set data field with field name 'ConsumableType' on this record model
        """
        self.set_field_value(self.CONSUMABLETYPE__FIELD_NAME.field_name, value)

    def get_ConsumableType_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ConsumableType' from this record model
        """
        return self.get_field_value(self.CONSUMABLETYPE__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_ExactMass_field(self, value: Optional[float]):
        """
        Set data field with field name 'ExactMass' on this record model
        """
        self.set_field_value(self.EXACTMASS__FIELD_NAME.field_name, value)

    def get_ExactMass_field(self) -> Optional[float]:
        """
        Get data field value with field name 'ExactMass' from this record model
        """
        return self.get_field_value(self.EXACTMASS__FIELD_NAME.field_name)

    def set_Formula_field(self, value: Optional[str]):
        """
        Set data field with field name 'Formula' on this record model
        """
        self.set_field_value(self.FORMULA__FIELD_NAME.field_name, value)

    def get_Formula_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Formula' from this record model
        """
        return self.get_field_value(self.FORMULA__FIELD_NAME.field_name)

    def set_GHSCautionCode_field(self, value: Optional[str]):
        """
        Set data field with field name 'GHSCautionCode' on this record model
        """
        self.set_field_value(self.GHSCAUTIONCODE__FIELD_NAME.field_name, value)

    def get_GHSCautionCode_field(self) -> Optional[str]:
        """
        Get data field value with field name 'GHSCautionCode' from this record model
        """
        return self.get_field_value(self.GHSCAUTIONCODE__FIELD_NAME.field_name)

    def set_GHSHazardCode_field(self, value: Optional[str]):
        """
        Set data field with field name 'GHSHazardCode' on this record model
        """
        self.set_field_value(self.GHSHAZARDCODE__FIELD_NAME.field_name, value)

    def get_GHSHazardCode_field(self) -> Optional[str]:
        """
        Get data field value with field name 'GHSHazardCode' from this record model
        """
        return self.get_field_value(self.GHSHAZARDCODE__FIELD_NAME.field_name)

    def set_GHSPictoCode_field(self, value: Optional[str]):
        """
        Set data field with field name 'GHSPictoCode' on this record model
        """
        self.set_field_value(self.GHSPICTOCODE__FIELD_NAME.field_name, value)

    def get_GHSPictoCode_field(self) -> Optional[str]:
        """
        Get data field value with field name 'GHSPictoCode' from this record model
        """
        return self.get_field_value(self.GHSPICTOCODE__FIELD_NAME.field_name)

    def set_GHSSignal_field(self, value: Optional[str]):
        """
        Set data field with field name 'GHSSignal' on this record model
        """
        self.set_field_value(self.GHSSIGNAL__FIELD_NAME.field_name, value)

    def get_GHSSignal_field(self) -> Optional[str]:
        """
        Get data field value with field name 'GHSSignal' from this record model
        """
        return self.get_field_value(self.GHSSIGNAL__FIELD_NAME.field_name)

    def set_inchi_field(self, value: Optional[str]):
        """
        Set data field with field name 'inchi' on this record model
        """
        self.set_field_value(self.INCHI__FIELD_NAME.field_name, value)

    def get_inchi_field(self) -> Optional[str]:
        """
        Get data field value with field name 'inchi' from this record model
        """
        return self.get_field_value(self.INCHI__FIELD_NAME.field_name)

    def set_InchiKey_field(self, value: Optional[str]):
        """
        Set data field with field name 'InchiKey' on this record model
        """
        self.set_field_value(self.INCHIKEY__FIELD_NAME.field_name, value)

    def get_InchiKey_field(self) -> Optional[str]:
        """
        Get data field value with field name 'InchiKey' from this record model
        """
        return self.get_field_value(self.INCHIKEY__FIELD_NAME.field_name)

    def set_IsGHSClassified_field(self, value: Optional[bool]):
        """
        Set data field with field name 'IsGHSClassified' on this record model
        """
        self.set_field_value(self.ISGHSCLASSIFIED__FIELD_NAME.field_name, value)

    def get_IsGHSClassified_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'IsGHSClassified' from this record model
        """
        return self.get_field_value(self.ISGHSCLASSIFIED__FIELD_NAME.field_name)

    def set_IUPAC_field(self, value: Optional[str]):
        """
        Set data field with field name 'IUPAC' on this record model
        """
        self.set_field_value(self.IUPAC__FIELD_NAME.field_name, value)

    def get_IUPAC_field(self) -> Optional[str]:
        """
        Get data field value with field name 'IUPAC' from this record model
        """
        return self.get_field_value(self.IUPAC__FIELD_NAME.field_name)

    def set_LotNumber_field(self, value: Optional[str]):
        """
        Set data field with field name 'LotNumber' on this record model
        """
        self.set_field_value(self.LOTNUMBER__FIELD_NAME.field_name, value)

    def get_LotNumber_field(self) -> Optional[str]:
        """
        Get data field value with field name 'LotNumber' from this record model
        """
        return self.get_field_value(self.LOTNUMBER__FIELD_NAME.field_name)

    def set_MolecularWeight_field(self, value: Optional[float]):
        """
        Set data field with field name 'MolecularWeight' on this record model
        """
        self.set_field_value(self.MOLECULARWEIGHT__FIELD_NAME.field_name, value)

    def get_MolecularWeight_field(self) -> Optional[float]:
        """
        Get data field value with field name 'MolecularWeight' from this record model
        """
        return self.get_field_value(self.MOLECULARWEIGHT__FIELD_NAME.field_name)

    def set_PolarSurfaceArea_field(self, value: Optional[float]):
        """
        Set data field with field name 'PolarSurfaceArea' on this record model
        """
        self.set_field_value(self.POLARSURFACEAREA__FIELD_NAME.field_name, value)

    def get_PolarSurfaceArea_field(self) -> Optional[float]:
        """
        Get data field value with field name 'PolarSurfaceArea' from this record model
        """
        return self.get_field_value(self.POLARSURFACEAREA__FIELD_NAME.field_name)

    def set_PubchemCid_field(self, value: Optional[int]):
        """
        Set data field with field name 'PubchemCid' on this record model
        """
        self.set_field_value(self.PUBCHEMCID__FIELD_NAME.field_name, value)

    def get_PubchemCid_field(self) -> Optional[int]:
        """
        Get data field value with field name 'PubchemCid' from this record model
        """
        return self.get_field_value(self.PUBCHEMCID__FIELD_NAME.field_name)

    def set_Purity_field(self, value: Optional[float]):
        """
        Set data field with field name 'Purity' on this record model
        """
        self.set_field_value(self.PURITY__FIELD_NAME.field_name, value)

    def get_Purity_field(self) -> Optional[float]:
        """
        Get data field value with field name 'Purity' from this record model
        """
        return self.get_field_value(self.PURITY__FIELD_NAME.field_name)

    def set_RegistryId_field(self, value: Optional[str]):
        """
        Set data field with field name 'RegistryId' on this record model
        """
        self.set_field_value(self.REGISTRYID__FIELD_NAME.field_name, value)

    def get_RegistryId_field(self) -> Optional[str]:
        """
        Get data field value with field name 'RegistryId' from this record model
        """
        return self.get_field_value(self.REGISTRYID__FIELD_NAME.field_name)

    def set_SMILES_field(self, value: Optional[str]):
        """
        Set data field with field name 'SMILES' on this record model
        """
        self.set_field_value(self.SMILES__FIELD_NAME.field_name, value)

    def get_SMILES_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SMILES' from this record model
        """
        return self.get_field_value(self.SMILES__FIELD_NAME.field_name)

    def set_TotalHBondAcceptors_field(self, value: Optional[int]):
        """
        Set data field with field name 'TotalHBondAcceptors' on this record model
        """
        self.set_field_value(self.TOTALHBONDACCEPTORS__FIELD_NAME.field_name, value)

    def get_TotalHBondAcceptors_field(self) -> Optional[int]:
        """
        Get data field value with field name 'TotalHBondAcceptors' from this record model
        """
        return self.get_field_value(self.TOTALHBONDACCEPTORS__FIELD_NAME.field_name)

    def set_TotalHBondCount_field(self, value: Optional[int]):
        """
        Set data field with field name 'TotalHBondCount' on this record model
        """
        self.set_field_value(self.TOTALHBONDCOUNT__FIELD_NAME.field_name, value)

    def get_TotalHBondCount_field(self) -> Optional[int]:
        """
        Get data field value with field name 'TotalHBondCount' from this record model
        """
        return self.get_field_value(self.TOTALHBONDCOUNT__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)

    def set_Yield_field(self, value: Optional[float]):
        """
        Set data field with field name 'Yield' on this record model
        """
        self.set_field_value(self.YIELD__FIELD_NAME.field_name, value)

    def get_Yield_field(self) -> Optional[float]:
        """
        Get data field value with field name 'Yield' from this record model
        """
        return self.get_field_value(self.YIELD__FIELD_NAME.field_name)


class ChemRegPartPartModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type ChemRegPartPart
    Data Type Display Name: Company X Reagent (Company X Reagents)
    Fields: CAS, Charge, cLogP, ConsumableType, CreatedBy, DataRecordName, DateCreated, EditLock, ExactMass, Formula, GHSCautionCode, GHSHazardCode, GHSPictoCode, GHSSignal, inchi, InchiKey, INCHIShadow, IsGHSClassified, IUPAC, MOL, MolecularWeight, PolarSurfaceArea, PubchemCid, QuantityOnHand, QuantityPerItem, RegisteredToCartridge, RegistryId, ReorderLevelQuantity, RequestImageUpdate, SMILES, SMILESShadow, TotalHBondAcceptors, TotalHBondCount, Units, VeloxLastModifiedBy, VeloxLastModifiedDate
    The ChemRegPartPart Data Type
    """
    DATA_TYPE_NAME: str = 'ChemRegPartPart'
    CAS__FIELD_NAME: WrapperField = WrapperField("CAS", FieldType.STRING)
    CHARGE__FIELD_NAME: WrapperField = WrapperField("Charge", FieldType.INTEGER)
    CLOGP__FIELD_NAME: WrapperField = WrapperField("cLogP", FieldType.DOUBLE)
    CONSUMABLETYPE__FIELD_NAME: WrapperField = WrapperField("ConsumableType", FieldType.SELECTION)
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    EDITLOCK__FIELD_NAME: WrapperField = WrapperField("EditLock", FieldType.BOOLEAN)
    EXACTMASS__FIELD_NAME: WrapperField = WrapperField("ExactMass", FieldType.DOUBLE)
    FORMULA__FIELD_NAME: WrapperField = WrapperField("Formula", FieldType.STRING)
    GHSCAUTIONCODE__FIELD_NAME: WrapperField = WrapperField("GHSCautionCode", FieldType.STRING)
    GHSHAZARDCODE__FIELD_NAME: WrapperField = WrapperField("GHSHazardCode", FieldType.STRING)
    GHSPICTOCODE__FIELD_NAME: WrapperField = WrapperField("GHSPictoCode", FieldType.STRING)
    GHSSIGNAL__FIELD_NAME: WrapperField = WrapperField("GHSSignal", FieldType.STRING)
    INCHI__FIELD_NAME: WrapperField = WrapperField("inchi", FieldType.STRING)
    INCHIKEY__FIELD_NAME: WrapperField = WrapperField("InchiKey", FieldType.STRING)
    INCHISHADOW__FIELD_NAME: WrapperField = WrapperField("INCHIShadow", FieldType.STRING)
    ISGHSCLASSIFIED__FIELD_NAME: WrapperField = WrapperField("IsGHSClassified", FieldType.BOOLEAN)
    IUPAC__FIELD_NAME: WrapperField = WrapperField("IUPAC", FieldType.STRING)
    MOL__FIELD_NAME: WrapperField = WrapperField("MOL", FieldType.STRING)
    MOLECULARWEIGHT__FIELD_NAME: WrapperField = WrapperField("MolecularWeight", FieldType.DOUBLE)
    POLARSURFACEAREA__FIELD_NAME: WrapperField = WrapperField("PolarSurfaceArea", FieldType.DOUBLE)
    PUBCHEMCID__FIELD_NAME: WrapperField = WrapperField("PubchemCid", FieldType.INTEGER)
    QUANTITYONHAND__FIELD_NAME: WrapperField = WrapperField("QuantityOnHand", FieldType.DOUBLE)
    QUANTITYPERITEM__FIELD_NAME: WrapperField = WrapperField("QuantityPerItem", FieldType.DOUBLE)
    REGISTEREDTOCARTRIDGE__FIELD_NAME: WrapperField = WrapperField("RegisteredToCartridge", FieldType.BOOLEAN)
    REGISTRYID__FIELD_NAME: WrapperField = WrapperField("RegistryId", FieldType.STRING)
    REORDERLEVELQUANTITY__FIELD_NAME: WrapperField = WrapperField("ReorderLevelQuantity", FieldType.DOUBLE)
    REQUESTIMAGEUPDATE__FIELD_NAME: WrapperField = WrapperField("RequestImageUpdate", FieldType.BOOLEAN)
    SMILES__FIELD_NAME: WrapperField = WrapperField("SMILES", FieldType.STRING)
    SMILESSHADOW__FIELD_NAME: WrapperField = WrapperField("SMILESShadow", FieldType.STRING)
    TOTALHBONDACCEPTORS__FIELD_NAME: WrapperField = WrapperField("TotalHBondAcceptors", FieldType.INTEGER)
    TOTALHBONDCOUNT__FIELD_NAME: WrapperField = WrapperField("TotalHBondCount", FieldType.INTEGER)
    UNITS__FIELD_NAME: WrapperField = WrapperField("Units", FieldType.PICKLIST)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_CAS_field(self, value: Optional[str]):
        """
        Set data field with field name 'CAS' on this record model
        """
        self.set_field_value(self.CAS__FIELD_NAME.field_name, value)

    def get_CAS_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CAS' from this record model
        """
        return self.get_field_value(self.CAS__FIELD_NAME.field_name)

    def set_Charge_field(self, value: Optional[int]):
        """
        Set data field with field name 'Charge' on this record model
        """
        self.set_field_value(self.CHARGE__FIELD_NAME.field_name, value)

    def get_Charge_field(self) -> Optional[int]:
        """
        Get data field value with field name 'Charge' from this record model
        """
        return self.get_field_value(self.CHARGE__FIELD_NAME.field_name)

    def set_cLogP_field(self, value: Optional[float]):
        """
        Set data field with field name 'cLogP' on this record model
        """
        self.set_field_value(self.CLOGP__FIELD_NAME.field_name, value)

    def get_cLogP_field(self) -> Optional[float]:
        """
        Get data field value with field name 'cLogP' from this record model
        """
        return self.get_field_value(self.CLOGP__FIELD_NAME.field_name)

    def set_ConsumableType_field(self, value: Optional[str]):
        """
        Set data field with field name 'ConsumableType' on this record model
        """
        self.set_field_value(self.CONSUMABLETYPE__FIELD_NAME.field_name, value)

    def get_ConsumableType_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ConsumableType' from this record model
        """
        return self.get_field_value(self.CONSUMABLETYPE__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_EditLock_field(self, value: Optional[bool]):
        """
        Set data field with field name 'EditLock' on this record model
        """
        self.set_field_value(self.EDITLOCK__FIELD_NAME.field_name, value)

    def get_EditLock_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'EditLock' from this record model
        """
        return self.get_field_value(self.EDITLOCK__FIELD_NAME.field_name)

    def set_ExactMass_field(self, value: Optional[float]):
        """
        Set data field with field name 'ExactMass' on this record model
        """
        self.set_field_value(self.EXACTMASS__FIELD_NAME.field_name, value)

    def get_ExactMass_field(self) -> Optional[float]:
        """
        Get data field value with field name 'ExactMass' from this record model
        """
        return self.get_field_value(self.EXACTMASS__FIELD_NAME.field_name)

    def set_Formula_field(self, value: Optional[str]):
        """
        Set data field with field name 'Formula' on this record model
        """
        self.set_field_value(self.FORMULA__FIELD_NAME.field_name, value)

    def get_Formula_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Formula' from this record model
        """
        return self.get_field_value(self.FORMULA__FIELD_NAME.field_name)

    def set_GHSCautionCode_field(self, value: Optional[str]):
        """
        Set data field with field name 'GHSCautionCode' on this record model
        """
        self.set_field_value(self.GHSCAUTIONCODE__FIELD_NAME.field_name, value)

    def get_GHSCautionCode_field(self) -> Optional[str]:
        """
        Get data field value with field name 'GHSCautionCode' from this record model
        """
        return self.get_field_value(self.GHSCAUTIONCODE__FIELD_NAME.field_name)

    def set_GHSHazardCode_field(self, value: Optional[str]):
        """
        Set data field with field name 'GHSHazardCode' on this record model
        """
        self.set_field_value(self.GHSHAZARDCODE__FIELD_NAME.field_name, value)

    def get_GHSHazardCode_field(self) -> Optional[str]:
        """
        Get data field value with field name 'GHSHazardCode' from this record model
        """
        return self.get_field_value(self.GHSHAZARDCODE__FIELD_NAME.field_name)

    def set_GHSPictoCode_field(self, value: Optional[str]):
        """
        Set data field with field name 'GHSPictoCode' on this record model
        """
        self.set_field_value(self.GHSPICTOCODE__FIELD_NAME.field_name, value)

    def get_GHSPictoCode_field(self) -> Optional[str]:
        """
        Get data field value with field name 'GHSPictoCode' from this record model
        """
        return self.get_field_value(self.GHSPICTOCODE__FIELD_NAME.field_name)

    def set_GHSSignal_field(self, value: Optional[str]):
        """
        Set data field with field name 'GHSSignal' on this record model
        """
        self.set_field_value(self.GHSSIGNAL__FIELD_NAME.field_name, value)

    def get_GHSSignal_field(self) -> Optional[str]:
        """
        Get data field value with field name 'GHSSignal' from this record model
        """
        return self.get_field_value(self.GHSSIGNAL__FIELD_NAME.field_name)

    def set_inchi_field(self, value: Optional[str]):
        """
        Set data field with field name 'inchi' on this record model
        """
        self.set_field_value(self.INCHI__FIELD_NAME.field_name, value)

    def get_inchi_field(self) -> Optional[str]:
        """
        Get data field value with field name 'inchi' from this record model
        """
        return self.get_field_value(self.INCHI__FIELD_NAME.field_name)

    def set_InchiKey_field(self, value: Optional[str]):
        """
        Set data field with field name 'InchiKey' on this record model
        """
        self.set_field_value(self.INCHIKEY__FIELD_NAME.field_name, value)

    def get_InchiKey_field(self) -> Optional[str]:
        """
        Get data field value with field name 'InchiKey' from this record model
        """
        return self.get_field_value(self.INCHIKEY__FIELD_NAME.field_name)

    def set_INCHIShadow_field(self, value: Optional[str]):
        """
        Set data field with field name 'INCHIShadow' on this record model
        """
        self.set_field_value(self.INCHISHADOW__FIELD_NAME.field_name, value)

    def get_INCHIShadow_field(self) -> Optional[str]:
        """
        Get data field value with field name 'INCHIShadow' from this record model
        """
        return self.get_field_value(self.INCHISHADOW__FIELD_NAME.field_name)

    def set_IsGHSClassified_field(self, value: Optional[bool]):
        """
        Set data field with field name 'IsGHSClassified' on this record model
        """
        self.set_field_value(self.ISGHSCLASSIFIED__FIELD_NAME.field_name, value)

    def get_IsGHSClassified_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'IsGHSClassified' from this record model
        """
        return self.get_field_value(self.ISGHSCLASSIFIED__FIELD_NAME.field_name)

    def set_IUPAC_field(self, value: Optional[str]):
        """
        Set data field with field name 'IUPAC' on this record model
        """
        self.set_field_value(self.IUPAC__FIELD_NAME.field_name, value)

    def get_IUPAC_field(self) -> Optional[str]:
        """
        Get data field value with field name 'IUPAC' from this record model
        """
        return self.get_field_value(self.IUPAC__FIELD_NAME.field_name)

    def set_MOL_field(self, value: Optional[str]):
        """
        Set data field with field name 'MOL' on this record model
        """
        self.set_field_value(self.MOL__FIELD_NAME.field_name, value)

    def get_MOL_field(self) -> Optional[str]:
        """
        Get data field value with field name 'MOL' from this record model
        """
        return self.get_field_value(self.MOL__FIELD_NAME.field_name)

    def set_MolecularWeight_field(self, value: Optional[float]):
        """
        Set data field with field name 'MolecularWeight' on this record model
        """
        self.set_field_value(self.MOLECULARWEIGHT__FIELD_NAME.field_name, value)

    def get_MolecularWeight_field(self) -> Optional[float]:
        """
        Get data field value with field name 'MolecularWeight' from this record model
        """
        return self.get_field_value(self.MOLECULARWEIGHT__FIELD_NAME.field_name)

    def set_PolarSurfaceArea_field(self, value: Optional[float]):
        """
        Set data field with field name 'PolarSurfaceArea' on this record model
        """
        self.set_field_value(self.POLARSURFACEAREA__FIELD_NAME.field_name, value)

    def get_PolarSurfaceArea_field(self) -> Optional[float]:
        """
        Get data field value with field name 'PolarSurfaceArea' from this record model
        """
        return self.get_field_value(self.POLARSURFACEAREA__FIELD_NAME.field_name)

    def set_PubchemCid_field(self, value: Optional[int]):
        """
        Set data field with field name 'PubchemCid' on this record model
        """
        self.set_field_value(self.PUBCHEMCID__FIELD_NAME.field_name, value)

    def get_PubchemCid_field(self) -> Optional[int]:
        """
        Get data field value with field name 'PubchemCid' from this record model
        """
        return self.get_field_value(self.PUBCHEMCID__FIELD_NAME.field_name)

    def set_QuantityOnHand_field(self, value: Optional[float]):
        """
        Set data field with field name 'QuantityOnHand' on this record model
        """
        self.set_field_value(self.QUANTITYONHAND__FIELD_NAME.field_name, value)

    def get_QuantityOnHand_field(self) -> Optional[float]:
        """
        Get data field value with field name 'QuantityOnHand' from this record model
        """
        return self.get_field_value(self.QUANTITYONHAND__FIELD_NAME.field_name)

    def set_QuantityPerItem_field(self, value: Optional[float]):
        """
        Set data field with field name 'QuantityPerItem' on this record model
        """
        self.set_field_value(self.QUANTITYPERITEM__FIELD_NAME.field_name, value)

    def get_QuantityPerItem_field(self) -> Optional[float]:
        """
        Get data field value with field name 'QuantityPerItem' from this record model
        """
        return self.get_field_value(self.QUANTITYPERITEM__FIELD_NAME.field_name)

    def set_RegisteredToCartridge_field(self, value: Optional[bool]):
        """
        Set data field with field name 'RegisteredToCartridge' on this record model
        """
        self.set_field_value(self.REGISTEREDTOCARTRIDGE__FIELD_NAME.field_name, value)

    def get_RegisteredToCartridge_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'RegisteredToCartridge' from this record model
        """
        return self.get_field_value(self.REGISTEREDTOCARTRIDGE__FIELD_NAME.field_name)

    def set_RegistryId_field(self, value: Optional[str]):
        """
        Set data field with field name 'RegistryId' on this record model
        """
        self.set_field_value(self.REGISTRYID__FIELD_NAME.field_name, value)

    def get_RegistryId_field(self) -> Optional[str]:
        """
        Get data field value with field name 'RegistryId' from this record model
        """
        return self.get_field_value(self.REGISTRYID__FIELD_NAME.field_name)

    def set_ReorderLevelQuantity_field(self, value: Optional[float]):
        """
        Set data field with field name 'ReorderLevelQuantity' on this record model
        """
        self.set_field_value(self.REORDERLEVELQUANTITY__FIELD_NAME.field_name, value)

    def get_ReorderLevelQuantity_field(self) -> Optional[float]:
        """
        Get data field value with field name 'ReorderLevelQuantity' from this record model
        """
        return self.get_field_value(self.REORDERLEVELQUANTITY__FIELD_NAME.field_name)

    def set_RequestImageUpdate_field(self, value: Optional[bool]):
        """
        Set data field with field name 'RequestImageUpdate' on this record model
        """
        self.set_field_value(self.REQUESTIMAGEUPDATE__FIELD_NAME.field_name, value)

    def get_RequestImageUpdate_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'RequestImageUpdate' from this record model
        """
        return self.get_field_value(self.REQUESTIMAGEUPDATE__FIELD_NAME.field_name)

    def set_SMILES_field(self, value: Optional[str]):
        """
        Set data field with field name 'SMILES' on this record model
        """
        self.set_field_value(self.SMILES__FIELD_NAME.field_name, value)

    def get_SMILES_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SMILES' from this record model
        """
        return self.get_field_value(self.SMILES__FIELD_NAME.field_name)

    def set_SMILESShadow_field(self, value: Optional[str]):
        """
        Set data field with field name 'SMILESShadow' on this record model
        """
        self.set_field_value(self.SMILESSHADOW__FIELD_NAME.field_name, value)

    def get_SMILESShadow_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SMILESShadow' from this record model
        """
        return self.get_field_value(self.SMILESSHADOW__FIELD_NAME.field_name)

    def set_TotalHBondAcceptors_field(self, value: Optional[int]):
        """
        Set data field with field name 'TotalHBondAcceptors' on this record model
        """
        self.set_field_value(self.TOTALHBONDACCEPTORS__FIELD_NAME.field_name, value)

    def get_TotalHBondAcceptors_field(self) -> Optional[int]:
        """
        Get data field value with field name 'TotalHBondAcceptors' from this record model
        """
        return self.get_field_value(self.TOTALHBONDACCEPTORS__FIELD_NAME.field_name)

    def set_TotalHBondCount_field(self, value: Optional[int]):
        """
        Set data field with field name 'TotalHBondCount' on this record model
        """
        self.set_field_value(self.TOTALHBONDCOUNT__FIELD_NAME.field_name, value)

    def get_TotalHBondCount_field(self) -> Optional[int]:
        """
        Get data field value with field name 'TotalHBondCount' from this record model
        """
        return self.get_field_value(self.TOTALHBONDCOUNT__FIELD_NAME.field_name)

    def set_Units_field(self, value: Optional[str]):
        """
        Set data field with field name 'Units' on this record model
        """
        self.set_field_value(self.UNITS__FIELD_NAME.field_name, value)

    def get_Units_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Units' from this record model
        """
        return self.get_field_value(self.UNITS__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class ClientConfigurationsModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type ClientConfigurations
    Data Type Display Name: Client Configurations (Client Configurations)
    Fields: COMWebServiceAccountName, COMWebServiceApiKey, COMWebServiceGuid, COMWebServiceUrl, CreatedBy, DataRecordName, DateCreated, ReportingUserPassword, ReportingWebServiceHost, ReportingWebServiceName, ReportingWebServicePort, ReportingWebServiceUserName, SampleSheetPath, SampleSheetPathForPacBio, VeloxLastModifiedBy, VeloxLastModifiedDate
    Client specific configurations.
    """
    DATA_TYPE_NAME: str = 'ClientConfigurations'
    COMWEBSERVICEACCOUNTNAME__FIELD_NAME: WrapperField = WrapperField("COMWebServiceAccountName", FieldType.STRING)
    COMWEBSERVICEAPIKEY__FIELD_NAME: WrapperField = WrapperField("COMWebServiceApiKey", FieldType.STRING)
    COMWEBSERVICEGUID__FIELD_NAME: WrapperField = WrapperField("COMWebServiceGuid", FieldType.STRING)
    COMWEBSERVICEURL__FIELD_NAME: WrapperField = WrapperField("COMWebServiceUrl", FieldType.STRING)
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    REPORTINGUSERPASSWORD__FIELD_NAME: WrapperField = WrapperField("ReportingUserPassword", FieldType.STRING)
    REPORTINGWEBSERVICEHOST__FIELD_NAME: WrapperField = WrapperField("ReportingWebServiceHost", FieldType.STRING)
    REPORTINGWEBSERVICENAME__FIELD_NAME: WrapperField = WrapperField("ReportingWebServiceName", FieldType.STRING)
    REPORTINGWEBSERVICEPORT__FIELD_NAME: WrapperField = WrapperField("ReportingWebServicePort", FieldType.INTEGER)
    REPORTINGWEBSERVICEUSERNAME__FIELD_NAME: WrapperField = WrapperField("ReportingWebServiceUserName", FieldType.STRING)
    SAMPLESHEETPATH__FIELD_NAME: WrapperField = WrapperField("SampleSheetPath", FieldType.STRING)
    SAMPLESHEETPATHFORPACBIO__FIELD_NAME: WrapperField = WrapperField("SampleSheetPathForPacBio", FieldType.STRING)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_COMWebServiceAccountName_field(self, value: Optional[str]):
        """
        Set data field with field name 'COMWebServiceAccountName' on this record model
        """
        self.set_field_value(self.COMWEBSERVICEACCOUNTNAME__FIELD_NAME.field_name, value)

    def get_COMWebServiceAccountName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'COMWebServiceAccountName' from this record model
        """
        return self.get_field_value(self.COMWEBSERVICEACCOUNTNAME__FIELD_NAME.field_name)

    def set_COMWebServiceApiKey_field(self, value: Optional[str]):
        """
        Set data field with field name 'COMWebServiceApiKey' on this record model
        """
        self.set_field_value(self.COMWEBSERVICEAPIKEY__FIELD_NAME.field_name, value)

    def get_COMWebServiceApiKey_field(self) -> Optional[str]:
        """
        Get data field value with field name 'COMWebServiceApiKey' from this record model
        """
        return self.get_field_value(self.COMWEBSERVICEAPIKEY__FIELD_NAME.field_name)

    def set_COMWebServiceGuid_field(self, value: Optional[str]):
        """
        Set data field with field name 'COMWebServiceGuid' on this record model
        """
        self.set_field_value(self.COMWEBSERVICEGUID__FIELD_NAME.field_name, value)

    def get_COMWebServiceGuid_field(self) -> Optional[str]:
        """
        Get data field value with field name 'COMWebServiceGuid' from this record model
        """
        return self.get_field_value(self.COMWEBSERVICEGUID__FIELD_NAME.field_name)

    def set_COMWebServiceUrl_field(self, value: Optional[str]):
        """
        Set data field with field name 'COMWebServiceUrl' on this record model
        """
        self.set_field_value(self.COMWEBSERVICEURL__FIELD_NAME.field_name, value)

    def get_COMWebServiceUrl_field(self) -> Optional[str]:
        """
        Get data field value with field name 'COMWebServiceUrl' from this record model
        """
        return self.get_field_value(self.COMWEBSERVICEURL__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_ReportingUserPassword_field(self, value: Optional[str]):
        """
        Set data field with field name 'ReportingUserPassword' on this record model
        """
        self.set_field_value(self.REPORTINGUSERPASSWORD__FIELD_NAME.field_name, value)

    def get_ReportingUserPassword_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ReportingUserPassword' from this record model
        """
        return self.get_field_value(self.REPORTINGUSERPASSWORD__FIELD_NAME.field_name)

    def set_ReportingWebServiceHost_field(self, value: Optional[str]):
        """
        Set data field with field name 'ReportingWebServiceHost' on this record model
        """
        self.set_field_value(self.REPORTINGWEBSERVICEHOST__FIELD_NAME.field_name, value)

    def get_ReportingWebServiceHost_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ReportingWebServiceHost' from this record model
        """
        return self.get_field_value(self.REPORTINGWEBSERVICEHOST__FIELD_NAME.field_name)

    def set_ReportingWebServiceName_field(self, value: Optional[str]):
        """
        Set data field with field name 'ReportingWebServiceName' on this record model
        """
        self.set_field_value(self.REPORTINGWEBSERVICENAME__FIELD_NAME.field_name, value)

    def get_ReportingWebServiceName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ReportingWebServiceName' from this record model
        """
        return self.get_field_value(self.REPORTINGWEBSERVICENAME__FIELD_NAME.field_name)

    def set_ReportingWebServicePort_field(self, value: Optional[int]):
        """
        Set data field with field name 'ReportingWebServicePort' on this record model
        """
        self.set_field_value(self.REPORTINGWEBSERVICEPORT__FIELD_NAME.field_name, value)

    def get_ReportingWebServicePort_field(self) -> Optional[int]:
        """
        Get data field value with field name 'ReportingWebServicePort' from this record model
        """
        return self.get_field_value(self.REPORTINGWEBSERVICEPORT__FIELD_NAME.field_name)

    def set_ReportingWebServiceUserName_field(self, value: Optional[str]):
        """
        Set data field with field name 'ReportingWebServiceUserName' on this record model
        """
        self.set_field_value(self.REPORTINGWEBSERVICEUSERNAME__FIELD_NAME.field_name, value)

    def get_ReportingWebServiceUserName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ReportingWebServiceUserName' from this record model
        """
        return self.get_field_value(self.REPORTINGWEBSERVICEUSERNAME__FIELD_NAME.field_name)

    def set_SampleSheetPath_field(self, value: Optional[str]):
        """
        Set data field with field name 'SampleSheetPath' on this record model
        """
        self.set_field_value(self.SAMPLESHEETPATH__FIELD_NAME.field_name, value)

    def get_SampleSheetPath_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SampleSheetPath' from this record model
        """
        return self.get_field_value(self.SAMPLESHEETPATH__FIELD_NAME.field_name)

    def set_SampleSheetPathForPacBio_field(self, value: Optional[str]):
        """
        Set data field with field name 'SampleSheetPathForPacBio' on this record model
        """
        self.set_field_value(self.SAMPLESHEETPATHFORPACBIO__FIELD_NAME.field_name, value)

    def get_SampleSheetPathForPacBio_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SampleSheetPathForPacBio' from this record model
        """
        return self.get_field_value(self.SAMPLESHEETPATHFORPACBIO__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class ClinicalObservationModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type ClinicalObservation
    Data Type Display Name: Clinical Observation (Clinical Observations)
    Fields: CreatedBy, DataRecordName, DateCreated, Severity, Site, Status, Symptom, VeloxLastModifiedBy, VeloxLastModifiedDate
    """
    DATA_TYPE_NAME: str = 'ClinicalObservation'
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    SEVERITY__FIELD_NAME: WrapperField = WrapperField("Severity", FieldType.PICKLIST)
    SITE__FIELD_NAME: WrapperField = WrapperField("Site", FieldType.PICKLIST)
    STATUS__FIELD_NAME: WrapperField = WrapperField("Status", FieldType.PICKLIST)
    SYMPTOM__FIELD_NAME: WrapperField = WrapperField("Symptom", FieldType.PICKLIST)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_Severity_field(self, value: Optional[str]):
        """
        Set data field with field name 'Severity' on this record model
        """
        self.set_field_value(self.SEVERITY__FIELD_NAME.field_name, value)

    def get_Severity_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Severity' from this record model
        """
        return self.get_field_value(self.SEVERITY__FIELD_NAME.field_name)

    def set_Site_field(self, value: Optional[str]):
        """
        Set data field with field name 'Site' on this record model
        """
        self.set_field_value(self.SITE__FIELD_NAME.field_name, value)

    def get_Site_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Site' from this record model
        """
        return self.get_field_value(self.SITE__FIELD_NAME.field_name)

    def set_Status_field(self, value: Optional[str]):
        """
        Set data field with field name 'Status' on this record model
        """
        self.set_field_value(self.STATUS__FIELD_NAME.field_name, value)

    def get_Status_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Status' from this record model
        """
        return self.get_field_value(self.STATUS__FIELD_NAME.field_name)

    def set_Symptom_field(self, value: Optional[str]):
        """
        Set data field with field name 'Symptom' on this record model
        """
        self.set_field_value(self.SYMPTOM__FIELD_NAME.field_name, value)

    def get_Symptom_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Symptom' from this record model
        """
        return self.get_field_value(self.SYMPTOM__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class ClusterDetailModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type ClusterDetail
    Data Type Display Name: Tile Details (Tile Details)
    Fields: Aligned, AlignedPM, ClusterDensity, ClusterPassingFilter, ClusterPercentFilter, ColRead, CreatedBy, DataRecordName, DateCreated, DensityPlusMinus, Lane, LaneCol, PassedClustersInAllTiles, PassingPlusMinus, PFPercentPM, Tiles, TotalClustersInAllTiles, VeloxLastModifiedBy, VeloxLastModifiedDate
     <!-- DISPLAY IN INSTRUMENT RUN MONITOR -->
    """
    DATA_TYPE_NAME: str = 'ClusterDetail'
    ALIGNED__FIELD_NAME: WrapperField = WrapperField("Aligned", FieldType.DOUBLE)
    ALIGNEDPM__FIELD_NAME: WrapperField = WrapperField("AlignedPM", FieldType.DOUBLE)
    CLUSTERDENSITY__FIELD_NAME: WrapperField = WrapperField("ClusterDensity", FieldType.DOUBLE)
    CLUSTERPASSINGFILTER__FIELD_NAME: WrapperField = WrapperField("ClusterPassingFilter", FieldType.DOUBLE)
    CLUSTERPERCENTFILTER__FIELD_NAME: WrapperField = WrapperField("ClusterPercentFilter", FieldType.DOUBLE)
    COLREAD__FIELD_NAME: WrapperField = WrapperField("ColRead", FieldType.STRING)
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    DENSITYPLUSMINUS__FIELD_NAME: WrapperField = WrapperField("DensityPlusMinus", FieldType.DOUBLE)
    LANE__FIELD_NAME: WrapperField = WrapperField("Lane", FieldType.LONG)
    LANECOL__FIELD_NAME: WrapperField = WrapperField("LaneCol", FieldType.STRING)
    PASSEDCLUSTERSINALLTILES__FIELD_NAME: WrapperField = WrapperField("PassedClustersInAllTiles", FieldType.DOUBLE)
    PASSINGPLUSMINUS__FIELD_NAME: WrapperField = WrapperField("PassingPlusMinus", FieldType.DOUBLE)
    PFPERCENTPM__FIELD_NAME: WrapperField = WrapperField("PFPercentPM", FieldType.DOUBLE)
    TILES__FIELD_NAME: WrapperField = WrapperField("Tiles", FieldType.INTEGER)
    TOTALCLUSTERSINALLTILES__FIELD_NAME: WrapperField = WrapperField("TotalClustersInAllTiles", FieldType.DOUBLE)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_Aligned_field(self, value: Optional[float]):
        """
        Set data field with field name 'Aligned' on this record model
        """
        self.set_field_value(self.ALIGNED__FIELD_NAME.field_name, value)

    def get_Aligned_field(self) -> Optional[float]:
        """
        Get data field value with field name 'Aligned' from this record model
        """
        return self.get_field_value(self.ALIGNED__FIELD_NAME.field_name)

    def set_AlignedPM_field(self, value: Optional[float]):
        """
        Set data field with field name 'AlignedPM' on this record model
        """
        self.set_field_value(self.ALIGNEDPM__FIELD_NAME.field_name, value)

    def get_AlignedPM_field(self) -> Optional[float]:
        """
        Get data field value with field name 'AlignedPM' from this record model
        """
        return self.get_field_value(self.ALIGNEDPM__FIELD_NAME.field_name)

    def set_ClusterDensity_field(self, value: Optional[float]):
        """
        Set data field with field name 'ClusterDensity' on this record model
        """
        self.set_field_value(self.CLUSTERDENSITY__FIELD_NAME.field_name, value)

    def get_ClusterDensity_field(self) -> Optional[float]:
        """
        Get data field value with field name 'ClusterDensity' from this record model
        """
        return self.get_field_value(self.CLUSTERDENSITY__FIELD_NAME.field_name)

    def set_ClusterPassingFilter_field(self, value: Optional[float]):
        """
        Set data field with field name 'ClusterPassingFilter' on this record model
        """
        self.set_field_value(self.CLUSTERPASSINGFILTER__FIELD_NAME.field_name, value)

    def get_ClusterPassingFilter_field(self) -> Optional[float]:
        """
        Get data field value with field name 'ClusterPassingFilter' from this record model
        """
        return self.get_field_value(self.CLUSTERPASSINGFILTER__FIELD_NAME.field_name)

    def set_ClusterPercentFilter_field(self, value: Optional[float]):
        """
        Set data field with field name 'ClusterPercentFilter' on this record model
        """
        self.set_field_value(self.CLUSTERPERCENTFILTER__FIELD_NAME.field_name, value)

    def get_ClusterPercentFilter_field(self) -> Optional[float]:
        """
        Get data field value with field name 'ClusterPercentFilter' from this record model
        """
        return self.get_field_value(self.CLUSTERPERCENTFILTER__FIELD_NAME.field_name)

    def set_ColRead_field(self, value: Optional[str]):
        """
        Set data field with field name 'ColRead' on this record model
        """
        self.set_field_value(self.COLREAD__FIELD_NAME.field_name, value)

    def get_ColRead_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ColRead' from this record model
        """
        return self.get_field_value(self.COLREAD__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_DensityPlusMinus_field(self, value: Optional[float]):
        """
        Set data field with field name 'DensityPlusMinus' on this record model
        """
        self.set_field_value(self.DENSITYPLUSMINUS__FIELD_NAME.field_name, value)

    def get_DensityPlusMinus_field(self) -> Optional[float]:
        """
        Get data field value with field name 'DensityPlusMinus' from this record model
        """
        return self.get_field_value(self.DENSITYPLUSMINUS__FIELD_NAME.field_name)

    def set_Lane_field(self, value: Optional[int]):
        """
        Set data field with field name 'Lane' on this record model
        """
        self.set_field_value(self.LANE__FIELD_NAME.field_name, value)

    def get_Lane_field(self) -> Optional[int]:
        """
        Get data field value with field name 'Lane' from this record model
        """
        return self.get_field_value(self.LANE__FIELD_NAME.field_name)

    def set_LaneCol_field(self, value: Optional[str]):
        """
        Set data field with field name 'LaneCol' on this record model
        """
        self.set_field_value(self.LANECOL__FIELD_NAME.field_name, value)

    def get_LaneCol_field(self) -> Optional[str]:
        """
        Get data field value with field name 'LaneCol' from this record model
        """
        return self.get_field_value(self.LANECOL__FIELD_NAME.field_name)

    def set_PassedClustersInAllTiles_field(self, value: Optional[float]):
        """
        Set data field with field name 'PassedClustersInAllTiles' on this record model
        """
        self.set_field_value(self.PASSEDCLUSTERSINALLTILES__FIELD_NAME.field_name, value)

    def get_PassedClustersInAllTiles_field(self) -> Optional[float]:
        """
        Get data field value with field name 'PassedClustersInAllTiles' from this record model
        """
        return self.get_field_value(self.PASSEDCLUSTERSINALLTILES__FIELD_NAME.field_name)

    def set_PassingPlusMinus_field(self, value: Optional[float]):
        """
        Set data field with field name 'PassingPlusMinus' on this record model
        """
        self.set_field_value(self.PASSINGPLUSMINUS__FIELD_NAME.field_name, value)

    def get_PassingPlusMinus_field(self) -> Optional[float]:
        """
        Get data field value with field name 'PassingPlusMinus' from this record model
        """
        return self.get_field_value(self.PASSINGPLUSMINUS__FIELD_NAME.field_name)

    def set_PFPercentPM_field(self, value: Optional[float]):
        """
        Set data field with field name 'PFPercentPM' on this record model
        """
        self.set_field_value(self.PFPERCENTPM__FIELD_NAME.field_name, value)

    def get_PFPercentPM_field(self) -> Optional[float]:
        """
        Get data field value with field name 'PFPercentPM' from this record model
        """
        return self.get_field_value(self.PFPERCENTPM__FIELD_NAME.field_name)

    def set_Tiles_field(self, value: Optional[int]):
        """
        Set data field with field name 'Tiles' on this record model
        """
        self.set_field_value(self.TILES__FIELD_NAME.field_name, value)

    def get_Tiles_field(self) -> Optional[int]:
        """
        Get data field value with field name 'Tiles' from this record model
        """
        return self.get_field_value(self.TILES__FIELD_NAME.field_name)

    def set_TotalClustersInAllTiles_field(self, value: Optional[float]):
        """
        Set data field with field name 'TotalClustersInAllTiles' on this record model
        """
        self.set_field_value(self.TOTALCLUSTERSINALLTILES__FIELD_NAME.field_name, value)

    def get_TotalClustersInAllTiles_field(self) -> Optional[float]:
        """
        Get data field value with field name 'TotalClustersInAllTiles' from this record model
        """
        return self.get_field_value(self.TOTALCLUSTERSINALLTILES__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class CompoundModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type Compound
    Data Type Display Name: Compound (Compounds)
    Fields: CAS, Charge, cLogP, ConsumableType, CreatedBy, CXSMILESHash, DataRecordName, DateCreated, Density, ExactMass, ExpirationDate, Formula, GHSCautionCode, GHSHazardCode, GHSPictoCode, GHSSignal, HasOrStereoGroup, inchi, InchiKey, IsGHSClassified, IUPAC, LotNumber, MolecularWeight, PolarSurfaceArea, Pressure, PubchemCid, Purity, RegistryId, SMILES, StereoRegHash, Temperature, TotalHBondAcceptors, TotalHBondCount, VeloxLastModifiedBy, VeloxLastModifiedDate, Yield, ZoBioonly
    """
    DATA_TYPE_NAME: str = 'Compound'
    CAS__FIELD_NAME: WrapperField = WrapperField("CAS", FieldType.STRING)
    CHARGE__FIELD_NAME: WrapperField = WrapperField("Charge", FieldType.INTEGER)
    CLOGP__FIELD_NAME: WrapperField = WrapperField("cLogP", FieldType.DOUBLE)
    CONSUMABLETYPE__FIELD_NAME: WrapperField = WrapperField("ConsumableType", FieldType.SELECTION)
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    CXSMILESHASH__FIELD_NAME: WrapperField = WrapperField("CXSMILESHash", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    DENSITY__FIELD_NAME: WrapperField = WrapperField("Density", FieldType.STRING)
    EXACTMASS__FIELD_NAME: WrapperField = WrapperField("ExactMass", FieldType.DOUBLE)
    EXPIRATIONDATE__FIELD_NAME: WrapperField = WrapperField("ExpirationDate", FieldType.DATE)
    FORMULA__FIELD_NAME: WrapperField = WrapperField("Formula", FieldType.STRING)
    GHSCAUTIONCODE__FIELD_NAME: WrapperField = WrapperField("GHSCautionCode", FieldType.STRING)
    GHSHAZARDCODE__FIELD_NAME: WrapperField = WrapperField("GHSHazardCode", FieldType.STRING)
    GHSPICTOCODE__FIELD_NAME: WrapperField = WrapperField("GHSPictoCode", FieldType.STRING)
    GHSSIGNAL__FIELD_NAME: WrapperField = WrapperField("GHSSignal", FieldType.STRING)
    HASORSTEREOGROUP__FIELD_NAME: WrapperField = WrapperField("HasOrStereoGroup", FieldType.BOOLEAN)
    INCHI__FIELD_NAME: WrapperField = WrapperField("inchi", FieldType.STRING)
    INCHIKEY__FIELD_NAME: WrapperField = WrapperField("InchiKey", FieldType.STRING)
    ISGHSCLASSIFIED__FIELD_NAME: WrapperField = WrapperField("IsGHSClassified", FieldType.BOOLEAN)
    IUPAC__FIELD_NAME: WrapperField = WrapperField("IUPAC", FieldType.STRING)
    LOTNUMBER__FIELD_NAME: WrapperField = WrapperField("LotNumber", FieldType.STRING)
    MOLECULARWEIGHT__FIELD_NAME: WrapperField = WrapperField("MolecularWeight", FieldType.DOUBLE)
    POLARSURFACEAREA__FIELD_NAME: WrapperField = WrapperField("PolarSurfaceArea", FieldType.DOUBLE)
    PRESSURE__FIELD_NAME: WrapperField = WrapperField("Pressure", FieldType.DOUBLE)
    PUBCHEMCID__FIELD_NAME: WrapperField = WrapperField("PubchemCid", FieldType.INTEGER)
    PURITY__FIELD_NAME: WrapperField = WrapperField("Purity", FieldType.DOUBLE)
    REGISTRYID__FIELD_NAME: WrapperField = WrapperField("RegistryId", FieldType.STRING)
    SMILES__FIELD_NAME: WrapperField = WrapperField("SMILES", FieldType.STRING)
    STEREOREGHASH__FIELD_NAME: WrapperField = WrapperField("StereoRegHash", FieldType.STRING)
    TEMPERATURE__FIELD_NAME: WrapperField = WrapperField("Temperature", FieldType.DOUBLE)
    TOTALHBONDACCEPTORS__FIELD_NAME: WrapperField = WrapperField("TotalHBondAcceptors", FieldType.INTEGER)
    TOTALHBONDCOUNT__FIELD_NAME: WrapperField = WrapperField("TotalHBondCount", FieldType.INTEGER)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)
    YIELD__FIELD_NAME: WrapperField = WrapperField("Yield", FieldType.DOUBLE)
    ZOBIOONLY__FIELD_NAME: WrapperField = WrapperField("ZoBioonly", FieldType.BOOLEAN)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_CAS_field(self, value: Optional[str]):
        """
        Set data field with field name 'CAS' on this record model
        """
        self.set_field_value(self.CAS__FIELD_NAME.field_name, value)

    def get_CAS_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CAS' from this record model
        """
        return self.get_field_value(self.CAS__FIELD_NAME.field_name)

    def set_Charge_field(self, value: Optional[int]):
        """
        Set data field with field name 'Charge' on this record model
        """
        self.set_field_value(self.CHARGE__FIELD_NAME.field_name, value)

    def get_Charge_field(self) -> Optional[int]:
        """
        Get data field value with field name 'Charge' from this record model
        """
        return self.get_field_value(self.CHARGE__FIELD_NAME.field_name)

    def set_cLogP_field(self, value: Optional[float]):
        """
        Set data field with field name 'cLogP' on this record model
        """
        self.set_field_value(self.CLOGP__FIELD_NAME.field_name, value)

    def get_cLogP_field(self) -> Optional[float]:
        """
        Get data field value with field name 'cLogP' from this record model
        """
        return self.get_field_value(self.CLOGP__FIELD_NAME.field_name)

    def set_ConsumableType_field(self, value: Optional[str]):
        """
        Set data field with field name 'ConsumableType' on this record model
        """
        self.set_field_value(self.CONSUMABLETYPE__FIELD_NAME.field_name, value)

    def get_ConsumableType_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ConsumableType' from this record model
        """
        return self.get_field_value(self.CONSUMABLETYPE__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def set_CXSMILESHash_field(self, value: Optional[str]):
        """
        Set data field with field name 'CXSMILESHash' on this record model
        """
        self.set_field_value(self.CXSMILESHASH__FIELD_NAME.field_name, value)

    def get_CXSMILESHash_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CXSMILESHash' from this record model
        """
        return self.get_field_value(self.CXSMILESHASH__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_Density_field(self, value: Optional[str]):
        """
        Set data field with field name 'Density' on this record model
        """
        self.set_field_value(self.DENSITY__FIELD_NAME.field_name, value)

    def get_Density_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Density' from this record model
        """
        return self.get_field_value(self.DENSITY__FIELD_NAME.field_name)

    def set_ExactMass_field(self, value: Optional[float]):
        """
        Set data field with field name 'ExactMass' on this record model
        """
        self.set_field_value(self.EXACTMASS__FIELD_NAME.field_name, value)

    def get_ExactMass_field(self) -> Optional[float]:
        """
        Get data field value with field name 'ExactMass' from this record model
        """
        return self.get_field_value(self.EXACTMASS__FIELD_NAME.field_name)

    def set_ExpirationDate_field(self, value: Optional[int]):
        """
        Set data field with field name 'ExpirationDate' on this record model
        """
        self.set_field_value(self.EXPIRATIONDATE__FIELD_NAME.field_name, value)

    def get_ExpirationDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'ExpirationDate' from this record model
        """
        return self.get_field_value(self.EXPIRATIONDATE__FIELD_NAME.field_name)

    def set_Formula_field(self, value: Optional[str]):
        """
        Set data field with field name 'Formula' on this record model
        """
        self.set_field_value(self.FORMULA__FIELD_NAME.field_name, value)

    def get_Formula_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Formula' from this record model
        """
        return self.get_field_value(self.FORMULA__FIELD_NAME.field_name)

    def set_GHSCautionCode_field(self, value: Optional[str]):
        """
        Set data field with field name 'GHSCautionCode' on this record model
        """
        self.set_field_value(self.GHSCAUTIONCODE__FIELD_NAME.field_name, value)

    def get_GHSCautionCode_field(self) -> Optional[str]:
        """
        Get data field value with field name 'GHSCautionCode' from this record model
        """
        return self.get_field_value(self.GHSCAUTIONCODE__FIELD_NAME.field_name)

    def set_GHSHazardCode_field(self, value: Optional[str]):
        """
        Set data field with field name 'GHSHazardCode' on this record model
        """
        self.set_field_value(self.GHSHAZARDCODE__FIELD_NAME.field_name, value)

    def get_GHSHazardCode_field(self) -> Optional[str]:
        """
        Get data field value with field name 'GHSHazardCode' from this record model
        """
        return self.get_field_value(self.GHSHAZARDCODE__FIELD_NAME.field_name)

    def set_GHSPictoCode_field(self, value: Optional[str]):
        """
        Set data field with field name 'GHSPictoCode' on this record model
        """
        self.set_field_value(self.GHSPICTOCODE__FIELD_NAME.field_name, value)

    def get_GHSPictoCode_field(self) -> Optional[str]:
        """
        Get data field value with field name 'GHSPictoCode' from this record model
        """
        return self.get_field_value(self.GHSPICTOCODE__FIELD_NAME.field_name)

    def set_GHSSignal_field(self, value: Optional[str]):
        """
        Set data field with field name 'GHSSignal' on this record model
        """
        self.set_field_value(self.GHSSIGNAL__FIELD_NAME.field_name, value)

    def get_GHSSignal_field(self) -> Optional[str]:
        """
        Get data field value with field name 'GHSSignal' from this record model
        """
        return self.get_field_value(self.GHSSIGNAL__FIELD_NAME.field_name)

    def set_HasOrStereoGroup_field(self, value: Optional[bool]):
        """
        Set data field with field name 'HasOrStereoGroup' on this record model
        """
        self.set_field_value(self.HASORSTEREOGROUP__FIELD_NAME.field_name, value)

    def get_HasOrStereoGroup_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'HasOrStereoGroup' from this record model
        """
        return self.get_field_value(self.HASORSTEREOGROUP__FIELD_NAME.field_name)

    def set_inchi_field(self, value: Optional[str]):
        """
        Set data field with field name 'inchi' on this record model
        """
        self.set_field_value(self.INCHI__FIELD_NAME.field_name, value)

    def get_inchi_field(self) -> Optional[str]:
        """
        Get data field value with field name 'inchi' from this record model
        """
        return self.get_field_value(self.INCHI__FIELD_NAME.field_name)

    def set_InchiKey_field(self, value: Optional[str]):
        """
        Set data field with field name 'InchiKey' on this record model
        """
        self.set_field_value(self.INCHIKEY__FIELD_NAME.field_name, value)

    def get_InchiKey_field(self) -> Optional[str]:
        """
        Get data field value with field name 'InchiKey' from this record model
        """
        return self.get_field_value(self.INCHIKEY__FIELD_NAME.field_name)

    def set_IsGHSClassified_field(self, value: Optional[bool]):
        """
        Set data field with field name 'IsGHSClassified' on this record model
        """
        self.set_field_value(self.ISGHSCLASSIFIED__FIELD_NAME.field_name, value)

    def get_IsGHSClassified_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'IsGHSClassified' from this record model
        """
        return self.get_field_value(self.ISGHSCLASSIFIED__FIELD_NAME.field_name)

    def set_IUPAC_field(self, value: Optional[str]):
        """
        Set data field with field name 'IUPAC' on this record model
        """
        self.set_field_value(self.IUPAC__FIELD_NAME.field_name, value)

    def get_IUPAC_field(self) -> Optional[str]:
        """
        Get data field value with field name 'IUPAC' from this record model
        """
        return self.get_field_value(self.IUPAC__FIELD_NAME.field_name)

    def set_LotNumber_field(self, value: Optional[str]):
        """
        Set data field with field name 'LotNumber' on this record model
        """
        self.set_field_value(self.LOTNUMBER__FIELD_NAME.field_name, value)

    def get_LotNumber_field(self) -> Optional[str]:
        """
        Get data field value with field name 'LotNumber' from this record model
        """
        return self.get_field_value(self.LOTNUMBER__FIELD_NAME.field_name)

    def set_MolecularWeight_field(self, value: Optional[float]):
        """
        Set data field with field name 'MolecularWeight' on this record model
        """
        self.set_field_value(self.MOLECULARWEIGHT__FIELD_NAME.field_name, value)

    def get_MolecularWeight_field(self) -> Optional[float]:
        """
        Get data field value with field name 'MolecularWeight' from this record model
        """
        return self.get_field_value(self.MOLECULARWEIGHT__FIELD_NAME.field_name)

    def set_PolarSurfaceArea_field(self, value: Optional[float]):
        """
        Set data field with field name 'PolarSurfaceArea' on this record model
        """
        self.set_field_value(self.POLARSURFACEAREA__FIELD_NAME.field_name, value)

    def get_PolarSurfaceArea_field(self) -> Optional[float]:
        """
        Get data field value with field name 'PolarSurfaceArea' from this record model
        """
        return self.get_field_value(self.POLARSURFACEAREA__FIELD_NAME.field_name)

    def set_Pressure_field(self, value: Optional[float]):
        """
        Set data field with field name 'Pressure' on this record model
        """
        self.set_field_value(self.PRESSURE__FIELD_NAME.field_name, value)

    def get_Pressure_field(self) -> Optional[float]:
        """
        Get data field value with field name 'Pressure' from this record model
        """
        return self.get_field_value(self.PRESSURE__FIELD_NAME.field_name)

    def set_PubchemCid_field(self, value: Optional[int]):
        """
        Set data field with field name 'PubchemCid' on this record model
        """
        self.set_field_value(self.PUBCHEMCID__FIELD_NAME.field_name, value)

    def get_PubchemCid_field(self) -> Optional[int]:
        """
        Get data field value with field name 'PubchemCid' from this record model
        """
        return self.get_field_value(self.PUBCHEMCID__FIELD_NAME.field_name)

    def set_Purity_field(self, value: Optional[float]):
        """
        Set data field with field name 'Purity' on this record model
        """
        self.set_field_value(self.PURITY__FIELD_NAME.field_name, value)

    def get_Purity_field(self) -> Optional[float]:
        """
        Get data field value with field name 'Purity' from this record model
        """
        return self.get_field_value(self.PURITY__FIELD_NAME.field_name)

    def set_RegistryId_field(self, value: Optional[str]):
        """
        Set data field with field name 'RegistryId' on this record model
        """
        self.set_field_value(self.REGISTRYID__FIELD_NAME.field_name, value)

    def get_RegistryId_field(self) -> Optional[str]:
        """
        Get data field value with field name 'RegistryId' from this record model
        """
        return self.get_field_value(self.REGISTRYID__FIELD_NAME.field_name)

    def set_SMILES_field(self, value: Optional[str]):
        """
        Set data field with field name 'SMILES' on this record model
        """
        self.set_field_value(self.SMILES__FIELD_NAME.field_name, value)

    def get_SMILES_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SMILES' from this record model
        """
        return self.get_field_value(self.SMILES__FIELD_NAME.field_name)

    def set_StereoRegHash_field(self, value: Optional[str]):
        """
        Set data field with field name 'StereoRegHash' on this record model
        """
        self.set_field_value(self.STEREOREGHASH__FIELD_NAME.field_name, value)

    def get_StereoRegHash_field(self) -> Optional[str]:
        """
        Get data field value with field name 'StereoRegHash' from this record model
        """
        return self.get_field_value(self.STEREOREGHASH__FIELD_NAME.field_name)

    def set_Temperature_field(self, value: Optional[float]):
        """
        Set data field with field name 'Temperature' on this record model
        """
        self.set_field_value(self.TEMPERATURE__FIELD_NAME.field_name, value)

    def get_Temperature_field(self) -> Optional[float]:
        """
        Get data field value with field name 'Temperature' from this record model
        """
        return self.get_field_value(self.TEMPERATURE__FIELD_NAME.field_name)

    def set_TotalHBondAcceptors_field(self, value: Optional[int]):
        """
        Set data field with field name 'TotalHBondAcceptors' on this record model
        """
        self.set_field_value(self.TOTALHBONDACCEPTORS__FIELD_NAME.field_name, value)

    def get_TotalHBondAcceptors_field(self) -> Optional[int]:
        """
        Get data field value with field name 'TotalHBondAcceptors' from this record model
        """
        return self.get_field_value(self.TOTALHBONDACCEPTORS__FIELD_NAME.field_name)

    def set_TotalHBondCount_field(self, value: Optional[int]):
        """
        Set data field with field name 'TotalHBondCount' on this record model
        """
        self.set_field_value(self.TOTALHBONDCOUNT__FIELD_NAME.field_name, value)

    def get_TotalHBondCount_field(self) -> Optional[int]:
        """
        Get data field value with field name 'TotalHBondCount' from this record model
        """
        return self.get_field_value(self.TOTALHBONDCOUNT__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)

    def set_Yield_field(self, value: Optional[float]):
        """
        Set data field with field name 'Yield' on this record model
        """
        self.set_field_value(self.YIELD__FIELD_NAME.field_name, value)

    def get_Yield_field(self) -> Optional[float]:
        """
        Get data field value with field name 'Yield' from this record model
        """
        return self.get_field_value(self.YIELD__FIELD_NAME.field_name)

    def set_ZoBioonly_field(self, value: Optional[bool]):
        """
        Set data field with field name 'ZoBioonly' on this record model
        """
        self.set_field_value(self.ZOBIOONLY__FIELD_NAME.field_name, value)

    def get_ZoBioonly_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'ZoBioonly' from this record model
        """
        return self.get_field_value(self.ZOBIOONLY__FIELD_NAME.field_name)


class CompoundPartModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type CompoundPart
    Data Type Display Name: Compound Part (Compound Parts)
    Fields: CAS, Charge, cLogP, ConsumableType, CreatedBy, CXSMILESHash, DataRecordName, DateCreated, EditLock, ExactMass, Formula, GHSCautionCode, GHSHazardCode, GHSPictoCode, GHSSignal, HasOrStereoGroup, inchi, InchiKey, INCHIShadow, IsGHSClassified, IsNormalized, IUPAC, MOL, MolecularWeight, MultiParentLink229, PolarSurfaceArea, PubchemCid, QuantityOnHand, QuantityPerItem, RegisteredToCartridge, RegistryId, ReorderLevelQuantity, RequestImageUpdate, RobTest, Salts, SMILES, SMILESShadow, StereoRegHash, SubstanceClass, TotalHBondAcceptors, TotalHBondCount, Units, VeloxLastModifiedBy, VeloxLastModifiedDate
    """
    DATA_TYPE_NAME: str = 'CompoundPart'
    CAS__FIELD_NAME: WrapperField = WrapperField("CAS", FieldType.STRING)
    CHARGE__FIELD_NAME: WrapperField = WrapperField("Charge", FieldType.INTEGER)
    CLOGP__FIELD_NAME: WrapperField = WrapperField("cLogP", FieldType.DOUBLE)
    CONSUMABLETYPE__FIELD_NAME: WrapperField = WrapperField("ConsumableType", FieldType.SELECTION)
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    CXSMILESHASH__FIELD_NAME: WrapperField = WrapperField("CXSMILESHash", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    EDITLOCK__FIELD_NAME: WrapperField = WrapperField("EditLock", FieldType.BOOLEAN)
    EXACTMASS__FIELD_NAME: WrapperField = WrapperField("ExactMass", FieldType.DOUBLE)
    FORMULA__FIELD_NAME: WrapperField = WrapperField("Formula", FieldType.STRING)
    GHSCAUTIONCODE__FIELD_NAME: WrapperField = WrapperField("GHSCautionCode", FieldType.STRING)
    GHSHAZARDCODE__FIELD_NAME: WrapperField = WrapperField("GHSHazardCode", FieldType.STRING)
    GHSPICTOCODE__FIELD_NAME: WrapperField = WrapperField("GHSPictoCode", FieldType.STRING)
    GHSSIGNAL__FIELD_NAME: WrapperField = WrapperField("GHSSignal", FieldType.STRING)
    HASORSTEREOGROUP__FIELD_NAME: WrapperField = WrapperField("HasOrStereoGroup", FieldType.BOOLEAN)
    INCHI__FIELD_NAME: WrapperField = WrapperField("inchi", FieldType.STRING)
    INCHIKEY__FIELD_NAME: WrapperField = WrapperField("InchiKey", FieldType.STRING)
    INCHISHADOW__FIELD_NAME: WrapperField = WrapperField("INCHIShadow", FieldType.STRING)
    ISGHSCLASSIFIED__FIELD_NAME: WrapperField = WrapperField("IsGHSClassified", FieldType.BOOLEAN)
    ISNORMALIZED__FIELD_NAME: WrapperField = WrapperField("IsNormalized", FieldType.BOOLEAN)
    IUPAC__FIELD_NAME: WrapperField = WrapperField("IUPAC", FieldType.STRING)
    MOL__FIELD_NAME: WrapperField = WrapperField("MOL", FieldType.STRING)
    MOLECULARWEIGHT__FIELD_NAME: WrapperField = WrapperField("MolecularWeight", FieldType.DOUBLE)
    MULTIPARENTLINK229__FIELD_NAME: WrapperField = WrapperField("MultiParentLink229", FieldType.MULTIPARENTLINK)
    POLARSURFACEAREA__FIELD_NAME: WrapperField = WrapperField("PolarSurfaceArea", FieldType.DOUBLE)
    PUBCHEMCID__FIELD_NAME: WrapperField = WrapperField("PubchemCid", FieldType.INTEGER)
    QUANTITYONHAND__FIELD_NAME: WrapperField = WrapperField("QuantityOnHand", FieldType.DOUBLE)
    QUANTITYPERITEM__FIELD_NAME: WrapperField = WrapperField("QuantityPerItem", FieldType.DOUBLE)
    REGISTEREDTOCARTRIDGE__FIELD_NAME: WrapperField = WrapperField("RegisteredToCartridge", FieldType.BOOLEAN)
    REGISTRYID__FIELD_NAME: WrapperField = WrapperField("RegistryId", FieldType.STRING)
    REORDERLEVELQUANTITY__FIELD_NAME: WrapperField = WrapperField("ReorderLevelQuantity", FieldType.DOUBLE)
    REQUESTIMAGEUPDATE__FIELD_NAME: WrapperField = WrapperField("RequestImageUpdate", FieldType.BOOLEAN)
    ROBTEST__FIELD_NAME: WrapperField = WrapperField("RobTest", FieldType.STRING)
    SALTS__FIELD_NAME: WrapperField = WrapperField("Salts", FieldType.STRING)
    SMILES__FIELD_NAME: WrapperField = WrapperField("SMILES", FieldType.STRING)
    SMILESSHADOW__FIELD_NAME: WrapperField = WrapperField("SMILESShadow", FieldType.STRING)
    STEREOREGHASH__FIELD_NAME: WrapperField = WrapperField("StereoRegHash", FieldType.STRING)
    SUBSTANCECLASS__FIELD_NAME: WrapperField = WrapperField("SubstanceClass", FieldType.STRING)
    TOTALHBONDACCEPTORS__FIELD_NAME: WrapperField = WrapperField("TotalHBondAcceptors", FieldType.INTEGER)
    TOTALHBONDCOUNT__FIELD_NAME: WrapperField = WrapperField("TotalHBondCount", FieldType.INTEGER)
    UNITS__FIELD_NAME: WrapperField = WrapperField("Units", FieldType.PICKLIST)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_CAS_field(self, value: Optional[str]):
        """
        Set data field with field name 'CAS' on this record model
        """
        self.set_field_value(self.CAS__FIELD_NAME.field_name, value)

    def get_CAS_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CAS' from this record model
        """
        return self.get_field_value(self.CAS__FIELD_NAME.field_name)

    def set_Charge_field(self, value: Optional[int]):
        """
        Set data field with field name 'Charge' on this record model
        """
        self.set_field_value(self.CHARGE__FIELD_NAME.field_name, value)

    def get_Charge_field(self) -> Optional[int]:
        """
        Get data field value with field name 'Charge' from this record model
        """
        return self.get_field_value(self.CHARGE__FIELD_NAME.field_name)

    def set_cLogP_field(self, value: Optional[float]):
        """
        Set data field with field name 'cLogP' on this record model
        """
        self.set_field_value(self.CLOGP__FIELD_NAME.field_name, value)

    def get_cLogP_field(self) -> Optional[float]:
        """
        Get data field value with field name 'cLogP' from this record model
        """
        return self.get_field_value(self.CLOGP__FIELD_NAME.field_name)

    def set_ConsumableType_field(self, value: Optional[str]):
        """
        Set data field with field name 'ConsumableType' on this record model
        """
        self.set_field_value(self.CONSUMABLETYPE__FIELD_NAME.field_name, value)

    def get_ConsumableType_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ConsumableType' from this record model
        """
        return self.get_field_value(self.CONSUMABLETYPE__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def set_CXSMILESHash_field(self, value: Optional[str]):
        """
        Set data field with field name 'CXSMILESHash' on this record model
        """
        self.set_field_value(self.CXSMILESHASH__FIELD_NAME.field_name, value)

    def get_CXSMILESHash_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CXSMILESHash' from this record model
        """
        return self.get_field_value(self.CXSMILESHASH__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_EditLock_field(self, value: Optional[bool]):
        """
        Set data field with field name 'EditLock' on this record model
        """
        self.set_field_value(self.EDITLOCK__FIELD_NAME.field_name, value)

    def get_EditLock_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'EditLock' from this record model
        """
        return self.get_field_value(self.EDITLOCK__FIELD_NAME.field_name)

    def set_ExactMass_field(self, value: Optional[float]):
        """
        Set data field with field name 'ExactMass' on this record model
        """
        self.set_field_value(self.EXACTMASS__FIELD_NAME.field_name, value)

    def get_ExactMass_field(self) -> Optional[float]:
        """
        Get data field value with field name 'ExactMass' from this record model
        """
        return self.get_field_value(self.EXACTMASS__FIELD_NAME.field_name)

    def set_Formula_field(self, value: Optional[str]):
        """
        Set data field with field name 'Formula' on this record model
        """
        self.set_field_value(self.FORMULA__FIELD_NAME.field_name, value)

    def get_Formula_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Formula' from this record model
        """
        return self.get_field_value(self.FORMULA__FIELD_NAME.field_name)

    def set_GHSCautionCode_field(self, value: Optional[str]):
        """
        Set data field with field name 'GHSCautionCode' on this record model
        """
        self.set_field_value(self.GHSCAUTIONCODE__FIELD_NAME.field_name, value)

    def get_GHSCautionCode_field(self) -> Optional[str]:
        """
        Get data field value with field name 'GHSCautionCode' from this record model
        """
        return self.get_field_value(self.GHSCAUTIONCODE__FIELD_NAME.field_name)

    def set_GHSHazardCode_field(self, value: Optional[str]):
        """
        Set data field with field name 'GHSHazardCode' on this record model
        """
        self.set_field_value(self.GHSHAZARDCODE__FIELD_NAME.field_name, value)

    def get_GHSHazardCode_field(self) -> Optional[str]:
        """
        Get data field value with field name 'GHSHazardCode' from this record model
        """
        return self.get_field_value(self.GHSHAZARDCODE__FIELD_NAME.field_name)

    def set_GHSPictoCode_field(self, value: Optional[str]):
        """
        Set data field with field name 'GHSPictoCode' on this record model
        """
        self.set_field_value(self.GHSPICTOCODE__FIELD_NAME.field_name, value)

    def get_GHSPictoCode_field(self) -> Optional[str]:
        """
        Get data field value with field name 'GHSPictoCode' from this record model
        """
        return self.get_field_value(self.GHSPICTOCODE__FIELD_NAME.field_name)

    def set_GHSSignal_field(self, value: Optional[str]):
        """
        Set data field with field name 'GHSSignal' on this record model
        """
        self.set_field_value(self.GHSSIGNAL__FIELD_NAME.field_name, value)

    def get_GHSSignal_field(self) -> Optional[str]:
        """
        Get data field value with field name 'GHSSignal' from this record model
        """
        return self.get_field_value(self.GHSSIGNAL__FIELD_NAME.field_name)

    def set_HasOrStereoGroup_field(self, value: Optional[bool]):
        """
        Set data field with field name 'HasOrStereoGroup' on this record model
        """
        self.set_field_value(self.HASORSTEREOGROUP__FIELD_NAME.field_name, value)

    def get_HasOrStereoGroup_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'HasOrStereoGroup' from this record model
        """
        return self.get_field_value(self.HASORSTEREOGROUP__FIELD_NAME.field_name)

    def set_inchi_field(self, value: Optional[str]):
        """
        Set data field with field name 'inchi' on this record model
        """
        self.set_field_value(self.INCHI__FIELD_NAME.field_name, value)

    def get_inchi_field(self) -> Optional[str]:
        """
        Get data field value with field name 'inchi' from this record model
        """
        return self.get_field_value(self.INCHI__FIELD_NAME.field_name)

    def set_InchiKey_field(self, value: Optional[str]):
        """
        Set data field with field name 'InchiKey' on this record model
        """
        self.set_field_value(self.INCHIKEY__FIELD_NAME.field_name, value)

    def get_InchiKey_field(self) -> Optional[str]:
        """
        Get data field value with field name 'InchiKey' from this record model
        """
        return self.get_field_value(self.INCHIKEY__FIELD_NAME.field_name)

    def set_INCHIShadow_field(self, value: Optional[str]):
        """
        Set data field with field name 'INCHIShadow' on this record model
        """
        self.set_field_value(self.INCHISHADOW__FIELD_NAME.field_name, value)

    def get_INCHIShadow_field(self) -> Optional[str]:
        """
        Get data field value with field name 'INCHIShadow' from this record model
        """
        return self.get_field_value(self.INCHISHADOW__FIELD_NAME.field_name)

    def set_IsGHSClassified_field(self, value: Optional[bool]):
        """
        Set data field with field name 'IsGHSClassified' on this record model
        """
        self.set_field_value(self.ISGHSCLASSIFIED__FIELD_NAME.field_name, value)

    def get_IsGHSClassified_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'IsGHSClassified' from this record model
        """
        return self.get_field_value(self.ISGHSCLASSIFIED__FIELD_NAME.field_name)

    def set_IsNormalized_field(self, value: Optional[bool]):
        """
        Set data field with field name 'IsNormalized' on this record model
        """
        self.set_field_value(self.ISNORMALIZED__FIELD_NAME.field_name, value)

    def get_IsNormalized_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'IsNormalized' from this record model
        """
        return self.get_field_value(self.ISNORMALIZED__FIELD_NAME.field_name)

    def set_IUPAC_field(self, value: Optional[str]):
        """
        Set data field with field name 'IUPAC' on this record model
        """
        self.set_field_value(self.IUPAC__FIELD_NAME.field_name, value)

    def get_IUPAC_field(self) -> Optional[str]:
        """
        Get data field value with field name 'IUPAC' from this record model
        """
        return self.get_field_value(self.IUPAC__FIELD_NAME.field_name)

    def set_MOL_field(self, value: Optional[str]):
        """
        Set data field with field name 'MOL' on this record model
        """
        self.set_field_value(self.MOL__FIELD_NAME.field_name, value)

    def get_MOL_field(self) -> Optional[str]:
        """
        Get data field value with field name 'MOL' from this record model
        """
        return self.get_field_value(self.MOL__FIELD_NAME.field_name)

    def set_MolecularWeight_field(self, value: Optional[float]):
        """
        Set data field with field name 'MolecularWeight' on this record model
        """
        self.set_field_value(self.MOLECULARWEIGHT__FIELD_NAME.field_name, value)

    def get_MolecularWeight_field(self) -> Optional[float]:
        """
        Get data field value with field name 'MolecularWeight' from this record model
        """
        return self.get_field_value(self.MOLECULARWEIGHT__FIELD_NAME.field_name)

    def set_PolarSurfaceArea_field(self, value: Optional[float]):
        """
        Set data field with field name 'PolarSurfaceArea' on this record model
        """
        self.set_field_value(self.POLARSURFACEAREA__FIELD_NAME.field_name, value)

    def get_PolarSurfaceArea_field(self) -> Optional[float]:
        """
        Get data field value with field name 'PolarSurfaceArea' from this record model
        """
        return self.get_field_value(self.POLARSURFACEAREA__FIELD_NAME.field_name)

    def set_PubchemCid_field(self, value: Optional[int]):
        """
        Set data field with field name 'PubchemCid' on this record model
        """
        self.set_field_value(self.PUBCHEMCID__FIELD_NAME.field_name, value)

    def get_PubchemCid_field(self) -> Optional[int]:
        """
        Get data field value with field name 'PubchemCid' from this record model
        """
        return self.get_field_value(self.PUBCHEMCID__FIELD_NAME.field_name)

    def set_QuantityOnHand_field(self, value: Optional[float]):
        """
        Set data field with field name 'QuantityOnHand' on this record model
        """
        self.set_field_value(self.QUANTITYONHAND__FIELD_NAME.field_name, value)

    def get_QuantityOnHand_field(self) -> Optional[float]:
        """
        Get data field value with field name 'QuantityOnHand' from this record model
        """
        return self.get_field_value(self.QUANTITYONHAND__FIELD_NAME.field_name)

    def set_QuantityPerItem_field(self, value: Optional[float]):
        """
        Set data field with field name 'QuantityPerItem' on this record model
        """
        self.set_field_value(self.QUANTITYPERITEM__FIELD_NAME.field_name, value)

    def get_QuantityPerItem_field(self) -> Optional[float]:
        """
        Get data field value with field name 'QuantityPerItem' from this record model
        """
        return self.get_field_value(self.QUANTITYPERITEM__FIELD_NAME.field_name)

    def set_RegisteredToCartridge_field(self, value: Optional[bool]):
        """
        Set data field with field name 'RegisteredToCartridge' on this record model
        """
        self.set_field_value(self.REGISTEREDTOCARTRIDGE__FIELD_NAME.field_name, value)

    def get_RegisteredToCartridge_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'RegisteredToCartridge' from this record model
        """
        return self.get_field_value(self.REGISTEREDTOCARTRIDGE__FIELD_NAME.field_name)

    def set_RegistryId_field(self, value: Optional[str]):
        """
        Set data field with field name 'RegistryId' on this record model
        """
        self.set_field_value(self.REGISTRYID__FIELD_NAME.field_name, value)

    def get_RegistryId_field(self) -> Optional[str]:
        """
        Get data field value with field name 'RegistryId' from this record model
        """
        return self.get_field_value(self.REGISTRYID__FIELD_NAME.field_name)

    def set_ReorderLevelQuantity_field(self, value: Optional[float]):
        """
        Set data field with field name 'ReorderLevelQuantity' on this record model
        """
        self.set_field_value(self.REORDERLEVELQUANTITY__FIELD_NAME.field_name, value)

    def get_ReorderLevelQuantity_field(self) -> Optional[float]:
        """
        Get data field value with field name 'ReorderLevelQuantity' from this record model
        """
        return self.get_field_value(self.REORDERLEVELQUANTITY__FIELD_NAME.field_name)

    def set_RequestImageUpdate_field(self, value: Optional[bool]):
        """
        Set data field with field name 'RequestImageUpdate' on this record model
        """
        self.set_field_value(self.REQUESTIMAGEUPDATE__FIELD_NAME.field_name, value)

    def get_RequestImageUpdate_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'RequestImageUpdate' from this record model
        """
        return self.get_field_value(self.REQUESTIMAGEUPDATE__FIELD_NAME.field_name)

    def set_RobTest_field(self, value: Optional[str]):
        """
        Set data field with field name 'RobTest' on this record model
        """
        self.set_field_value(self.ROBTEST__FIELD_NAME.field_name, value)

    def get_RobTest_field(self) -> Optional[str]:
        """
        Get data field value with field name 'RobTest' from this record model
        """
        return self.get_field_value(self.ROBTEST__FIELD_NAME.field_name)

    def set_Salts_field(self, value: Optional[str]):
        """
        Set data field with field name 'Salts' on this record model
        """
        self.set_field_value(self.SALTS__FIELD_NAME.field_name, value)

    def get_Salts_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Salts' from this record model
        """
        return self.get_field_value(self.SALTS__FIELD_NAME.field_name)

    def set_SMILES_field(self, value: Optional[str]):
        """
        Set data field with field name 'SMILES' on this record model
        """
        self.set_field_value(self.SMILES__FIELD_NAME.field_name, value)

    def get_SMILES_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SMILES' from this record model
        """
        return self.get_field_value(self.SMILES__FIELD_NAME.field_name)

    def set_SMILESShadow_field(self, value: Optional[str]):
        """
        Set data field with field name 'SMILESShadow' on this record model
        """
        self.set_field_value(self.SMILESSHADOW__FIELD_NAME.field_name, value)

    def get_SMILESShadow_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SMILESShadow' from this record model
        """
        return self.get_field_value(self.SMILESSHADOW__FIELD_NAME.field_name)

    def set_StereoRegHash_field(self, value: Optional[str]):
        """
        Set data field with field name 'StereoRegHash' on this record model
        """
        self.set_field_value(self.STEREOREGHASH__FIELD_NAME.field_name, value)

    def get_StereoRegHash_field(self) -> Optional[str]:
        """
        Get data field value with field name 'StereoRegHash' from this record model
        """
        return self.get_field_value(self.STEREOREGHASH__FIELD_NAME.field_name)

    def set_SubstanceClass_field(self, value: Optional[str]):
        """
        Set data field with field name 'SubstanceClass' on this record model
        """
        self.set_field_value(self.SUBSTANCECLASS__FIELD_NAME.field_name, value)

    def get_SubstanceClass_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SubstanceClass' from this record model
        """
        return self.get_field_value(self.SUBSTANCECLASS__FIELD_NAME.field_name)

    def set_TotalHBondAcceptors_field(self, value: Optional[int]):
        """
        Set data field with field name 'TotalHBondAcceptors' on this record model
        """
        self.set_field_value(self.TOTALHBONDACCEPTORS__FIELD_NAME.field_name, value)

    def get_TotalHBondAcceptors_field(self) -> Optional[int]:
        """
        Get data field value with field name 'TotalHBondAcceptors' from this record model
        """
        return self.get_field_value(self.TOTALHBONDACCEPTORS__FIELD_NAME.field_name)

    def set_TotalHBondCount_field(self, value: Optional[int]):
        """
        Set data field with field name 'TotalHBondCount' on this record model
        """
        self.set_field_value(self.TOTALHBONDCOUNT__FIELD_NAME.field_name, value)

    def get_TotalHBondCount_field(self) -> Optional[int]:
        """
        Get data field value with field name 'TotalHBondCount' from this record model
        """
        return self.get_field_value(self.TOTALHBONDCOUNT__FIELD_NAME.field_name)

    def set_Units_field(self, value: Optional[str]):
        """
        Set data field with field name 'Units' on this record model
        """
        self.set_field_value(self.UNITS__FIELD_NAME.field_name, value)

    def get_Units_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Units' from this record model
        """
        return self.get_field_value(self.UNITS__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class CompoundSaltConfigModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type CompoundSaltConfig
    Data Type Display Name: Compound Salt Config (Compound Salt Configs)
    Fields: CreatedBy, DataRecordName, DateCreated, SaltId, SaltSMARTS, VeloxLastModifiedBy, VeloxLastModifiedDate
    The corporate compound salt database. This will be a list of SMARTS expressions that will be used for desalting when importing a compound part.
    """
    DATA_TYPE_NAME: str = 'CompoundSaltConfig'
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    SALTID__FIELD_NAME: WrapperField = WrapperField("SaltId", FieldType.STRING)
    SALTSMARTS__FIELD_NAME: WrapperField = WrapperField("SaltSMARTS", FieldType.STRING)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_SaltId_field(self, value: Optional[str]):
        """
        Set data field with field name 'SaltId' on this record model
        """
        self.set_field_value(self.SALTID__FIELD_NAME.field_name, value)

    def get_SaltId_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SaltId' from this record model
        """
        return self.get_field_value(self.SALTID__FIELD_NAME.field_name)

    def set_SaltSMARTS_field(self, value: Optional[str]):
        """
        Set data field with field name 'SaltSMARTS' on this record model
        """
        self.set_field_value(self.SALTSMARTS__FIELD_NAME.field_name, value)

    def get_SaltSMARTS_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SaltSMARTS' from this record model
        """
        return self.get_field_value(self.SALTSMARTS__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class ComputedAssayResultsModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type ComputedAssayResults
    Data Type Display Name: Computed Assay Result (Computed Assay Results)
    Fields: AssayType, AssayUnits, ChemReagentPartLink, ChemRegPartPartSideLink, CompoundPartLink, CreatedBy, DataRecordName, DateCreated, Name, NewChem1PartSideLink, NoCanTauPartSideLink, NumericValue, Robs3rdRegPartSideLink, SampleSideLink, TextValue, VeloxLastModifiedBy, VeloxLastModifiedDate
    Stores the computed assay results from a fixed formula for program that operates on data.
    """
    DATA_TYPE_NAME: str = 'ComputedAssayResults'
    ASSAYTYPE__FIELD_NAME: WrapperField = WrapperField("AssayType", FieldType.STRING)
    ASSAYUNITS__FIELD_NAME: WrapperField = WrapperField("AssayUnits", FieldType.SELECTION)
    CHEMREAGENTPARTLINK__FIELD_NAME: WrapperField = WrapperField("ChemReagentPartLink", FieldType.SIDE_LINK)
    CHEMREGPARTPARTSIDELINK__FIELD_NAME: WrapperField = WrapperField("ChemRegPartPartSideLink", FieldType.SIDE_LINK)
    COMPOUNDPARTLINK__FIELD_NAME: WrapperField = WrapperField("CompoundPartLink", FieldType.SIDE_LINK)
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    NAME__FIELD_NAME: WrapperField = WrapperField("Name", FieldType.STRING)
    NEWCHEM1PARTSIDELINK__FIELD_NAME: WrapperField = WrapperField("NewChem1PartSideLink", FieldType.SIDE_LINK)
    NOCANTAUPARTSIDELINK__FIELD_NAME: WrapperField = WrapperField("NoCanTauPartSideLink", FieldType.SIDE_LINK)
    NUMERICVALUE__FIELD_NAME: WrapperField = WrapperField("NumericValue", FieldType.DOUBLE)
    ROBS3RDREGPARTSIDELINK__FIELD_NAME: WrapperField = WrapperField("Robs3rdRegPartSideLink", FieldType.SIDE_LINK)
    SAMPLESIDELINK__FIELD_NAME: WrapperField = WrapperField("SampleSideLink", FieldType.SIDE_LINK)
    TEXTVALUE__FIELD_NAME: WrapperField = WrapperField("TextValue", FieldType.STRING)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_AssayType_field(self, value: Optional[str]):
        """
        Set data field with field name 'AssayType' on this record model
        """
        self.set_field_value(self.ASSAYTYPE__FIELD_NAME.field_name, value)

    def get_AssayType_field(self) -> Optional[str]:
        """
        Get data field value with field name 'AssayType' from this record model
        """
        return self.get_field_value(self.ASSAYTYPE__FIELD_NAME.field_name)

    def set_AssayUnits_field(self, value: Optional[str]):
        """
        Set data field with field name 'AssayUnits' on this record model
        """
        self.set_field_value(self.ASSAYUNITS__FIELD_NAME.field_name, value)

    def get_AssayUnits_field(self) -> Optional[str]:
        """
        Get data field value with field name 'AssayUnits' from this record model
        """
        return self.get_field_value(self.ASSAYUNITS__FIELD_NAME.field_name)

    def set_ChemReagentPartLink_field(self, value: Optional[int]):
        """
        Set data field with field name 'ChemReagentPartLink' on this record model
        """
        self.set_field_value(self.CHEMREAGENTPARTLINK__FIELD_NAME.field_name, value)

    def get_ChemReagentPartLink_field(self) -> Optional[int]:
        """
        Get data field value with field name 'ChemReagentPartLink' from this record model
        """
        return self.get_field_value(self.CHEMREAGENTPARTLINK__FIELD_NAME.field_name)

    def set_ChemRegPartPartSideLink_field(self, value: Optional[int]):
        """
        Set data field with field name 'ChemRegPartPartSideLink' on this record model
        """
        self.set_field_value(self.CHEMREGPARTPARTSIDELINK__FIELD_NAME.field_name, value)

    def get_ChemRegPartPartSideLink_field(self) -> Optional[int]:
        """
        Get data field value with field name 'ChemRegPartPartSideLink' from this record model
        """
        return self.get_field_value(self.CHEMREGPARTPARTSIDELINK__FIELD_NAME.field_name)

    def set_CompoundPartLink_field(self, value: Optional[int]):
        """
        Set data field with field name 'CompoundPartLink' on this record model
        """
        self.set_field_value(self.COMPOUNDPARTLINK__FIELD_NAME.field_name, value)

    def get_CompoundPartLink_field(self) -> Optional[int]:
        """
        Get data field value with field name 'CompoundPartLink' from this record model
        """
        return self.get_field_value(self.COMPOUNDPARTLINK__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_Name_field(self, value: Optional[str]):
        """
        Set data field with field name 'Name' on this record model
        """
        self.set_field_value(self.NAME__FIELD_NAME.field_name, value)

    def get_Name_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Name' from this record model
        """
        return self.get_field_value(self.NAME__FIELD_NAME.field_name)

    def set_NewChem1PartSideLink_field(self, value: Optional[int]):
        """
        Set data field with field name 'NewChem1PartSideLink' on this record model
        """
        self.set_field_value(self.NEWCHEM1PARTSIDELINK__FIELD_NAME.field_name, value)

    def get_NewChem1PartSideLink_field(self) -> Optional[int]:
        """
        Get data field value with field name 'NewChem1PartSideLink' from this record model
        """
        return self.get_field_value(self.NEWCHEM1PARTSIDELINK__FIELD_NAME.field_name)

    def set_NoCanTauPartSideLink_field(self, value: Optional[int]):
        """
        Set data field with field name 'NoCanTauPartSideLink' on this record model
        """
        self.set_field_value(self.NOCANTAUPARTSIDELINK__FIELD_NAME.field_name, value)

    def get_NoCanTauPartSideLink_field(self) -> Optional[int]:
        """
        Get data field value with field name 'NoCanTauPartSideLink' from this record model
        """
        return self.get_field_value(self.NOCANTAUPARTSIDELINK__FIELD_NAME.field_name)

    def set_NumericValue_field(self, value: Optional[float]):
        """
        Set data field with field name 'NumericValue' on this record model
        """
        self.set_field_value(self.NUMERICVALUE__FIELD_NAME.field_name, value)

    def get_NumericValue_field(self) -> Optional[float]:
        """
        Get data field value with field name 'NumericValue' from this record model
        """
        return self.get_field_value(self.NUMERICVALUE__FIELD_NAME.field_name)

    def set_Robs3rdRegPartSideLink_field(self, value: Optional[int]):
        """
        Set data field with field name 'Robs3rdRegPartSideLink' on this record model
        """
        self.set_field_value(self.ROBS3RDREGPARTSIDELINK__FIELD_NAME.field_name, value)

    def get_Robs3rdRegPartSideLink_field(self) -> Optional[int]:
        """
        Get data field value with field name 'Robs3rdRegPartSideLink' from this record model
        """
        return self.get_field_value(self.ROBS3RDREGPARTSIDELINK__FIELD_NAME.field_name)

    def set_SampleSideLink_field(self, value: Optional[int]):
        """
        Set data field with field name 'SampleSideLink' on this record model
        """
        self.set_field_value(self.SAMPLESIDELINK__FIELD_NAME.field_name, value)

    def get_SampleSideLink_field(self) -> Optional[int]:
        """
        Get data field value with field name 'SampleSideLink' from this record model
        """
        return self.get_field_value(self.SAMPLESIDELINK__FIELD_NAME.field_name)

    def set_TextValue_field(self, value: Optional[str]):
        """
        Set data field with field name 'TextValue' on this record model
        """
        self.set_field_value(self.TEXTVALUE__FIELD_NAME.field_name, value)

    def get_TextValue_field(self) -> Optional[str]:
        """
        Get data field value with field name 'TextValue' from this record model
        """
        return self.get_field_value(self.TEXTVALUE__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class ConditionsModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type Conditions
    Data Type Display Name: Conditions (Conditions)
    Fields: CreatedBy, DataRecordName, DateCreated, Pressure, Temperature, VeloxLastModifiedBy, VeloxLastModifiedDate
    """
    DATA_TYPE_NAME: str = 'Conditions'
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    PRESSURE__FIELD_NAME: WrapperField = WrapperField("Pressure", FieldType.DOUBLE)
    TEMPERATURE__FIELD_NAME: WrapperField = WrapperField("Temperature", FieldType.DOUBLE)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_Pressure_field(self, value: Optional[float]):
        """
        Set data field with field name 'Pressure' on this record model
        """
        self.set_field_value(self.PRESSURE__FIELD_NAME.field_name, value)

    def get_Pressure_field(self) -> Optional[float]:
        """
        Get data field value with field name 'Pressure' from this record model
        """
        return self.get_field_value(self.PRESSURE__FIELD_NAME.field_name)

    def set_Temperature_field(self, value: Optional[float]):
        """
        Set data field with field name 'Temperature' on this record model
        """
        self.set_field_value(self.TEMPERATURE__FIELD_NAME.field_name, value)

    def get_Temperature_field(self) -> Optional[float]:
        """
        Get data field value with field name 'Temperature' from this record model
        """
        return self.get_field_value(self.TEMPERATURE__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class ConsumableModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type Consumable
    Data Type Display Name: Reagent Part (Reagent Parts)
    Fields: AspenField, CASNo, ConsumableClassification, ConsumableName, ConsumableType, CreatedBy, DataRecordName, DateCreated, Description, EditConsumableType, PartNumber, QuantityOnHand, QuantityPerItem, ReorderLevelQuantity, Units, VeloxLastModifiedBy, VeloxLastModifiedDate, Vendor
    General definition of a consumable object.
    """
    DATA_TYPE_NAME: str = 'Consumable'
    ASPENFIELD__FIELD_NAME: WrapperField = WrapperField("AspenField", FieldType.STRING)
    CASNO__FIELD_NAME: WrapperField = WrapperField("CASNo", FieldType.STRING)
    CONSUMABLECLASSIFICATION__FIELD_NAME: WrapperField = WrapperField("ConsumableClassification", FieldType.SELECTION)
    CONSUMABLENAME__FIELD_NAME: WrapperField = WrapperField("ConsumableName", FieldType.STRING)
    CONSUMABLETYPE__FIELD_NAME: WrapperField = WrapperField("ConsumableType", FieldType.SELECTION)
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    DESCRIPTION__FIELD_NAME: WrapperField = WrapperField("Description", FieldType.STRING)
    EDITCONSUMABLETYPE__FIELD_NAME: WrapperField = WrapperField("EditConsumableType", FieldType.BOOLEAN)
    PARTNUMBER__FIELD_NAME: WrapperField = WrapperField("PartNumber", FieldType.STRING)
    QUANTITYONHAND__FIELD_NAME: WrapperField = WrapperField("QuantityOnHand", FieldType.DOUBLE)
    QUANTITYPERITEM__FIELD_NAME: WrapperField = WrapperField("QuantityPerItem", FieldType.DOUBLE)
    REORDERLEVELQUANTITY__FIELD_NAME: WrapperField = WrapperField("ReorderLevelQuantity", FieldType.DOUBLE)
    UNITS__FIELD_NAME: WrapperField = WrapperField("Units", FieldType.PICKLIST)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)
    VENDOR__FIELD_NAME: WrapperField = WrapperField("Vendor", FieldType.SELECTION)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_AspenField_field(self, value: Optional[str]):
        """
        Set data field with field name 'AspenField' on this record model
        """
        self.set_field_value(self.ASPENFIELD__FIELD_NAME.field_name, value)

    def get_AspenField_field(self) -> Optional[str]:
        """
        Get data field value with field name 'AspenField' from this record model
        """
        return self.get_field_value(self.ASPENFIELD__FIELD_NAME.field_name)

    def set_CASNo_field(self, value: Optional[str]):
        """
        Set data field with field name 'CASNo' on this record model
        """
        self.set_field_value(self.CASNO__FIELD_NAME.field_name, value)

    def get_CASNo_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CASNo' from this record model
        """
        return self.get_field_value(self.CASNO__FIELD_NAME.field_name)

    def set_ConsumableClassification_field(self, value: Optional[str]):
        """
        Set data field with field name 'ConsumableClassification' on this record model
        """
        self.set_field_value(self.CONSUMABLECLASSIFICATION__FIELD_NAME.field_name, value)

    def get_ConsumableClassification_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ConsumableClassification' from this record model
        """
        return self.get_field_value(self.CONSUMABLECLASSIFICATION__FIELD_NAME.field_name)

    def set_ConsumableName_field(self, value: Optional[str]):
        """
        Set data field with field name 'ConsumableName' on this record model
        """
        self.set_field_value(self.CONSUMABLENAME__FIELD_NAME.field_name, value)

    def get_ConsumableName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ConsumableName' from this record model
        """
        return self.get_field_value(self.CONSUMABLENAME__FIELD_NAME.field_name)

    def set_ConsumableType_field(self, value: Optional[str]):
        """
        Set data field with field name 'ConsumableType' on this record model
        """
        self.set_field_value(self.CONSUMABLETYPE__FIELD_NAME.field_name, value)

    def get_ConsumableType_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ConsumableType' from this record model
        """
        return self.get_field_value(self.CONSUMABLETYPE__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_Description_field(self, value: Optional[str]):
        """
        Set data field with field name 'Description' on this record model
        """
        self.set_field_value(self.DESCRIPTION__FIELD_NAME.field_name, value)

    def get_Description_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Description' from this record model
        """
        return self.get_field_value(self.DESCRIPTION__FIELD_NAME.field_name)

    def set_EditConsumableType_field(self, value: Optional[bool]):
        """
        Set data field with field name 'EditConsumableType' on this record model
        """
        self.set_field_value(self.EDITCONSUMABLETYPE__FIELD_NAME.field_name, value)

    def get_EditConsumableType_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'EditConsumableType' from this record model
        """
        return self.get_field_value(self.EDITCONSUMABLETYPE__FIELD_NAME.field_name)

    def set_PartNumber_field(self, value: Optional[str]):
        """
        Set data field with field name 'PartNumber' on this record model
        """
        self.set_field_value(self.PARTNUMBER__FIELD_NAME.field_name, value)

    def get_PartNumber_field(self) -> Optional[str]:
        """
        Get data field value with field name 'PartNumber' from this record model
        """
        return self.get_field_value(self.PARTNUMBER__FIELD_NAME.field_name)

    def set_QuantityOnHand_field(self, value: Optional[float]):
        """
        Set data field with field name 'QuantityOnHand' on this record model
        """
        self.set_field_value(self.QUANTITYONHAND__FIELD_NAME.field_name, value)

    def get_QuantityOnHand_field(self) -> Optional[float]:
        """
        Get data field value with field name 'QuantityOnHand' from this record model
        """
        return self.get_field_value(self.QUANTITYONHAND__FIELD_NAME.field_name)

    def set_QuantityPerItem_field(self, value: Optional[float]):
        """
        Set data field with field name 'QuantityPerItem' on this record model
        """
        self.set_field_value(self.QUANTITYPERITEM__FIELD_NAME.field_name, value)

    def get_QuantityPerItem_field(self) -> Optional[float]:
        """
        Get data field value with field name 'QuantityPerItem' from this record model
        """
        return self.get_field_value(self.QUANTITYPERITEM__FIELD_NAME.field_name)

    def set_ReorderLevelQuantity_field(self, value: Optional[float]):
        """
        Set data field with field name 'ReorderLevelQuantity' on this record model
        """
        self.set_field_value(self.REORDERLEVELQUANTITY__FIELD_NAME.field_name, value)

    def get_ReorderLevelQuantity_field(self) -> Optional[float]:
        """
        Get data field value with field name 'ReorderLevelQuantity' from this record model
        """
        return self.get_field_value(self.REORDERLEVELQUANTITY__FIELD_NAME.field_name)

    def set_Units_field(self, value: Optional[str]):
        """
        Set data field with field name 'Units' on this record model
        """
        self.set_field_value(self.UNITS__FIELD_NAME.field_name, value)

    def get_Units_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Units' from this record model
        """
        return self.get_field_value(self.UNITS__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)

    def set_Vendor_field(self, value: Optional[str]):
        """
        Set data field with field name 'Vendor' on this record model
        """
        self.set_field_value(self.VENDOR__FIELD_NAME.field_name, value)

    def get_Vendor_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Vendor' from this record model
        """
        return self.get_field_value(self.VENDOR__FIELD_NAME.field_name)


class ConsumableImporterMappingModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type ConsumableImporterMapping
    Data Type Display Name: Consumable Importer Mapping (Consumable Importer Mappings)
    Fields: CreatedBy, DataField, DataRecordName, DataType, DateCreated, DisplayName, MappingGroup, MappingName, MappingOrder, VeloxLastModifiedBy, VeloxLastModifiedDate
    <!-- CONFIG: Static --><!-- CONFIG: REPLACEABLE -->
    """
    DATA_TYPE_NAME: str = 'ConsumableImporterMapping'
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATAFIELD__FIELD_NAME: WrapperField = WrapperField("DataField", FieldType.SELECTION)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATATYPE__FIELD_NAME: WrapperField = WrapperField("DataType", FieldType.PICKLIST)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    DISPLAYNAME__FIELD_NAME: WrapperField = WrapperField("DisplayName", FieldType.STRING)
    MAPPINGGROUP__FIELD_NAME: WrapperField = WrapperField("MappingGroup", FieldType.STRING)
    MAPPINGNAME__FIELD_NAME: WrapperField = WrapperField("MappingName", FieldType.STRING)
    MAPPINGORDER__FIELD_NAME: WrapperField = WrapperField("MappingOrder", FieldType.SHORT)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def set_DataField_field(self, value: Optional[str]):
        """
        Set data field with field name 'DataField' on this record model
        """
        self.set_field_value(self.DATAFIELD__FIELD_NAME.field_name, value)

    def get_DataField_field(self) -> Optional[str]:
        """
        Get data field value with field name 'DataField' from this record model
        """
        return self.get_field_value(self.DATAFIELD__FIELD_NAME.field_name)

    def set_DataType_field(self, value: Optional[str]):
        """
        Set data field with field name 'DataType' on this record model
        """
        self.set_field_value(self.DATATYPE__FIELD_NAME.field_name, value)

    def get_DataType_field(self) -> Optional[str]:
        """
        Get data field value with field name 'DataType' from this record model
        """
        return self.get_field_value(self.DATATYPE__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_DisplayName_field(self, value: Optional[str]):
        """
        Set data field with field name 'DisplayName' on this record model
        """
        self.set_field_value(self.DISPLAYNAME__FIELD_NAME.field_name, value)

    def get_DisplayName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'DisplayName' from this record model
        """
        return self.get_field_value(self.DISPLAYNAME__FIELD_NAME.field_name)

    def set_MappingGroup_field(self, value: Optional[str]):
        """
        Set data field with field name 'MappingGroup' on this record model
        """
        self.set_field_value(self.MAPPINGGROUP__FIELD_NAME.field_name, value)

    def get_MappingGroup_field(self) -> Optional[str]:
        """
        Get data field value with field name 'MappingGroup' from this record model
        """
        return self.get_field_value(self.MAPPINGGROUP__FIELD_NAME.field_name)

    def set_MappingName_field(self, value: Optional[str]):
        """
        Set data field with field name 'MappingName' on this record model
        """
        self.set_field_value(self.MAPPINGNAME__FIELD_NAME.field_name, value)

    def get_MappingName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'MappingName' from this record model
        """
        return self.get_field_value(self.MAPPINGNAME__FIELD_NAME.field_name)

    def set_MappingOrder_field(self, value: Optional[int]):
        """
        Set data field with field name 'MappingOrder' on this record model
        """
        self.set_field_value(self.MAPPINGORDER__FIELD_NAME.field_name, value)

    def get_MappingOrder_field(self) -> Optional[int]:
        """
        Get data field value with field name 'MappingOrder' from this record model
        """
        return self.get_field_value(self.MAPPINGORDER__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class ConsumableImportingMapConfigModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type ConsumableImportingMapConfig
    Data Type Display Name: Consumable Importing Mapping Configuration (Consumable Importing Mapping Configurations)
    Fields: CreatedBy, DataRecordName, DateCreated, MappingGroup, MappingOrder, VeloxLastModifiedBy, VeloxLastModifiedDate
    <!-- CONFIG: Static --><!-- CONFIG: REPLACEABLE -->
    """
    DATA_TYPE_NAME: str = 'ConsumableImportingMapConfig'
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    MAPPINGGROUP__FIELD_NAME: WrapperField = WrapperField("MappingGroup", FieldType.STRING)
    MAPPINGORDER__FIELD_NAME: WrapperField = WrapperField("MappingOrder", FieldType.SHORT)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_MappingGroup_field(self, value: Optional[str]):
        """
        Set data field with field name 'MappingGroup' on this record model
        """
        self.set_field_value(self.MAPPINGGROUP__FIELD_NAME.field_name, value)

    def get_MappingGroup_field(self) -> Optional[str]:
        """
        Get data field value with field name 'MappingGroup' from this record model
        """
        return self.get_field_value(self.MAPPINGGROUP__FIELD_NAME.field_name)

    def set_MappingOrder_field(self, value: Optional[int]):
        """
        Set data field with field name 'MappingOrder' on this record model
        """
        self.set_field_value(self.MAPPINGORDER__FIELD_NAME.field_name, value)

    def get_MappingOrder_field(self) -> Optional[int]:
        """
        Get data field value with field name 'MappingOrder' from this record model
        """
        return self.get_field_value(self.MAPPINGORDER__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class ConsumableItemModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type ConsumableItem
    Data Type Display Name: Reagent (Reagents)
    Fields: BarcodeDefined, CASNo, ColPosition, ConsumableBarcode, ConsumableName, ConsumableType, CostPerUnit, CreatedBy, DataRecordName, DateCreated, ExpirationDate, Expired, KitLotNumbers, LotNumber, LotNumberDefined, MultiParentLink705, PartNumber, QuantityRemaining, RowPosition, StorageLocationBarcode, StorageUnitPath, Units, UnknownExpiration, Validated, ValidationDate, ValidationExperimentId, ValidationTechician, VeloxLastModifiedBy, VeloxLastModifiedDate
    Detailed representation of a more specific consumable object.
    """
    DATA_TYPE_NAME: str = 'ConsumableItem'
    BARCODEDEFINED__FIELD_NAME: WrapperField = WrapperField("BarcodeDefined", FieldType.BOOLEAN)
    CASNO__FIELD_NAME: WrapperField = WrapperField("CASNo", FieldType.STRING)
    COLPOSITION__FIELD_NAME: WrapperField = WrapperField("ColPosition", FieldType.SELECTION)
    CONSUMABLEBARCODE__FIELD_NAME: WrapperField = WrapperField("ConsumableBarcode", FieldType.STRING)
    CONSUMABLENAME__FIELD_NAME: WrapperField = WrapperField("ConsumableName", FieldType.STRING)
    CONSUMABLETYPE__FIELD_NAME: WrapperField = WrapperField("ConsumableType", FieldType.SELECTION)
    COSTPERUNIT__FIELD_NAME: WrapperField = WrapperField("CostPerUnit", FieldType.DOUBLE)
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    EXPIRATIONDATE__FIELD_NAME: WrapperField = WrapperField("ExpirationDate", FieldType.DATE)
    EXPIRED__FIELD_NAME: WrapperField = WrapperField("Expired", FieldType.BOOLEAN)
    KITLOTNUMBERS__FIELD_NAME: WrapperField = WrapperField("KitLotNumbers", FieldType.STRING)
    LOTNUMBER__FIELD_NAME: WrapperField = WrapperField("LotNumber", FieldType.STRING)
    LOTNUMBERDEFINED__FIELD_NAME: WrapperField = WrapperField("LotNumberDefined", FieldType.BOOLEAN)
    MULTIPARENTLINK705__FIELD_NAME: WrapperField = WrapperField("MultiParentLink705", FieldType.MULTIPARENTLINK)
    PARTNUMBER__FIELD_NAME: WrapperField = WrapperField("PartNumber", FieldType.STRING)
    QUANTITYREMAINING__FIELD_NAME: WrapperField = WrapperField("QuantityRemaining", FieldType.DOUBLE)
    ROWPOSITION__FIELD_NAME: WrapperField = WrapperField("RowPosition", FieldType.SELECTION)
    STORAGELOCATIONBARCODE__FIELD_NAME: WrapperField = WrapperField("StorageLocationBarcode", FieldType.SELECTION)
    STORAGEUNITPATH__FIELD_NAME: WrapperField = WrapperField("StorageUnitPath", FieldType.STRING)
    UNITS__FIELD_NAME: WrapperField = WrapperField("Units", FieldType.PICKLIST)
    UNKNOWNEXPIRATION__FIELD_NAME: WrapperField = WrapperField("UnknownExpiration", FieldType.BOOLEAN)
    VALIDATED__FIELD_NAME: WrapperField = WrapperField("Validated", FieldType.BOOLEAN)
    VALIDATIONDATE__FIELD_NAME: WrapperField = WrapperField("ValidationDate", FieldType.DATE)
    VALIDATIONEXPERIMENTID__FIELD_NAME: WrapperField = WrapperField("ValidationExperimentId", FieldType.STRING)
    VALIDATIONTECHICIAN__FIELD_NAME: WrapperField = WrapperField("ValidationTechician", FieldType.SELECTION)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_BarcodeDefined_field(self, value: Optional[bool]):
        """
        Set data field with field name 'BarcodeDefined' on this record model
        """
        self.set_field_value(self.BARCODEDEFINED__FIELD_NAME.field_name, value)

    def get_BarcodeDefined_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'BarcodeDefined' from this record model
        """
        return self.get_field_value(self.BARCODEDEFINED__FIELD_NAME.field_name)

    def set_CASNo_field(self, value: Optional[str]):
        """
        Set data field with field name 'CASNo' on this record model
        """
        self.set_field_value(self.CASNO__FIELD_NAME.field_name, value)

    def get_CASNo_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CASNo' from this record model
        """
        return self.get_field_value(self.CASNO__FIELD_NAME.field_name)

    def set_ColPosition_field(self, value: Optional[str]):
        """
        Set data field with field name 'ColPosition' on this record model
        """
        self.set_field_value(self.COLPOSITION__FIELD_NAME.field_name, value)

    def get_ColPosition_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ColPosition' from this record model
        """
        return self.get_field_value(self.COLPOSITION__FIELD_NAME.field_name)

    def set_ConsumableBarcode_field(self, value: Optional[str]):
        """
        Set data field with field name 'ConsumableBarcode' on this record model
        """
        self.set_field_value(self.CONSUMABLEBARCODE__FIELD_NAME.field_name, value)

    def get_ConsumableBarcode_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ConsumableBarcode' from this record model
        """
        return self.get_field_value(self.CONSUMABLEBARCODE__FIELD_NAME.field_name)

    def set_ConsumableName_field(self, value: Optional[str]):
        """
        Set data field with field name 'ConsumableName' on this record model
        """
        self.set_field_value(self.CONSUMABLENAME__FIELD_NAME.field_name, value)

    def get_ConsumableName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ConsumableName' from this record model
        """
        return self.get_field_value(self.CONSUMABLENAME__FIELD_NAME.field_name)

    def set_ConsumableType_field(self, value: Optional[str]):
        """
        Set data field with field name 'ConsumableType' on this record model
        """
        self.set_field_value(self.CONSUMABLETYPE__FIELD_NAME.field_name, value)

    def get_ConsumableType_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ConsumableType' from this record model
        """
        return self.get_field_value(self.CONSUMABLETYPE__FIELD_NAME.field_name)

    def set_CostPerUnit_field(self, value: Optional[float]):
        """
        Set data field with field name 'CostPerUnit' on this record model
        """
        self.set_field_value(self.COSTPERUNIT__FIELD_NAME.field_name, value)

    def get_CostPerUnit_field(self) -> Optional[float]:
        """
        Get data field value with field name 'CostPerUnit' from this record model
        """
        return self.get_field_value(self.COSTPERUNIT__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_ExpirationDate_field(self, value: Optional[int]):
        """
        Set data field with field name 'ExpirationDate' on this record model
        """
        self.set_field_value(self.EXPIRATIONDATE__FIELD_NAME.field_name, value)

    def get_ExpirationDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'ExpirationDate' from this record model
        """
        return self.get_field_value(self.EXPIRATIONDATE__FIELD_NAME.field_name)

    def set_Expired_field(self, value: Optional[bool]):
        """
        Set data field with field name 'Expired' on this record model
        """
        self.set_field_value(self.EXPIRED__FIELD_NAME.field_name, value)

    def get_Expired_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'Expired' from this record model
        """
        return self.get_field_value(self.EXPIRED__FIELD_NAME.field_name)

    def set_KitLotNumbers_field(self, value: Optional[str]):
        """
        Set data field with field name 'KitLotNumbers' on this record model
        """
        self.set_field_value(self.KITLOTNUMBERS__FIELD_NAME.field_name, value)

    def get_KitLotNumbers_field(self) -> Optional[str]:
        """
        Get data field value with field name 'KitLotNumbers' from this record model
        """
        return self.get_field_value(self.KITLOTNUMBERS__FIELD_NAME.field_name)

    def set_LotNumber_field(self, value: Optional[str]):
        """
        Set data field with field name 'LotNumber' on this record model
        """
        self.set_field_value(self.LOTNUMBER__FIELD_NAME.field_name, value)

    def get_LotNumber_field(self) -> Optional[str]:
        """
        Get data field value with field name 'LotNumber' from this record model
        """
        return self.get_field_value(self.LOTNUMBER__FIELD_NAME.field_name)

    def set_LotNumberDefined_field(self, value: Optional[bool]):
        """
        Set data field with field name 'LotNumberDefined' on this record model
        """
        self.set_field_value(self.LOTNUMBERDEFINED__FIELD_NAME.field_name, value)

    def get_LotNumberDefined_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'LotNumberDefined' from this record model
        """
        return self.get_field_value(self.LOTNUMBERDEFINED__FIELD_NAME.field_name)

    def set_PartNumber_field(self, value: Optional[str]):
        """
        Set data field with field name 'PartNumber' on this record model
        """
        self.set_field_value(self.PARTNUMBER__FIELD_NAME.field_name, value)

    def get_PartNumber_field(self) -> Optional[str]:
        """
        Get data field value with field name 'PartNumber' from this record model
        """
        return self.get_field_value(self.PARTNUMBER__FIELD_NAME.field_name)

    def set_QuantityRemaining_field(self, value: Optional[float]):
        """
        Set data field with field name 'QuantityRemaining' on this record model
        """
        self.set_field_value(self.QUANTITYREMAINING__FIELD_NAME.field_name, value)

    def get_QuantityRemaining_field(self) -> Optional[float]:
        """
        Get data field value with field name 'QuantityRemaining' from this record model
        """
        return self.get_field_value(self.QUANTITYREMAINING__FIELD_NAME.field_name)

    def set_RowPosition_field(self, value: Optional[str]):
        """
        Set data field with field name 'RowPosition' on this record model
        """
        self.set_field_value(self.ROWPOSITION__FIELD_NAME.field_name, value)

    def get_RowPosition_field(self) -> Optional[str]:
        """
        Get data field value with field name 'RowPosition' from this record model
        """
        return self.get_field_value(self.ROWPOSITION__FIELD_NAME.field_name)

    def set_StorageLocationBarcode_field(self, value: Optional[str]):
        """
        Set data field with field name 'StorageLocationBarcode' on this record model
        """
        self.set_field_value(self.STORAGELOCATIONBARCODE__FIELD_NAME.field_name, value)

    def get_StorageLocationBarcode_field(self) -> Optional[str]:
        """
        Get data field value with field name 'StorageLocationBarcode' from this record model
        """
        return self.get_field_value(self.STORAGELOCATIONBARCODE__FIELD_NAME.field_name)

    def set_StorageUnitPath_field(self, value: Optional[str]):
        """
        Set data field with field name 'StorageUnitPath' on this record model
        """
        self.set_field_value(self.STORAGEUNITPATH__FIELD_NAME.field_name, value)

    def get_StorageUnitPath_field(self) -> Optional[str]:
        """
        Get data field value with field name 'StorageUnitPath' from this record model
        """
        return self.get_field_value(self.STORAGEUNITPATH__FIELD_NAME.field_name)

    def set_Units_field(self, value: Optional[str]):
        """
        Set data field with field name 'Units' on this record model
        """
        self.set_field_value(self.UNITS__FIELD_NAME.field_name, value)

    def get_Units_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Units' from this record model
        """
        return self.get_field_value(self.UNITS__FIELD_NAME.field_name)

    def set_UnknownExpiration_field(self, value: Optional[bool]):
        """
        Set data field with field name 'UnknownExpiration' on this record model
        """
        self.set_field_value(self.UNKNOWNEXPIRATION__FIELD_NAME.field_name, value)

    def get_UnknownExpiration_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'UnknownExpiration' from this record model
        """
        return self.get_field_value(self.UNKNOWNEXPIRATION__FIELD_NAME.field_name)

    def set_Validated_field(self, value: Optional[bool]):
        """
        Set data field with field name 'Validated' on this record model
        """
        self.set_field_value(self.VALIDATED__FIELD_NAME.field_name, value)

    def get_Validated_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'Validated' from this record model
        """
        return self.get_field_value(self.VALIDATED__FIELD_NAME.field_name)

    def set_ValidationDate_field(self, value: Optional[int]):
        """
        Set data field with field name 'ValidationDate' on this record model
        """
        self.set_field_value(self.VALIDATIONDATE__FIELD_NAME.field_name, value)

    def get_ValidationDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'ValidationDate' from this record model
        """
        return self.get_field_value(self.VALIDATIONDATE__FIELD_NAME.field_name)

    def set_ValidationExperimentId_field(self, value: Optional[str]):
        """
        Set data field with field name 'ValidationExperimentId' on this record model
        """
        self.set_field_value(self.VALIDATIONEXPERIMENTID__FIELD_NAME.field_name, value)

    def get_ValidationExperimentId_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ValidationExperimentId' from this record model
        """
        return self.get_field_value(self.VALIDATIONEXPERIMENTID__FIELD_NAME.field_name)

    def set_ValidationTechician_field(self, value: Optional[str]):
        """
        Set data field with field name 'ValidationTechician' on this record model
        """
        self.set_field_value(self.VALIDATIONTECHICIAN__FIELD_NAME.field_name, value)

    def get_ValidationTechician_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ValidationTechician' from this record model
        """
        return self.get_field_value(self.VALIDATIONTECHICIAN__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class ConsumableLotUsageModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type ConsumableLotUsage
    Data Type Display Name: Consumable Lot Usage (Consumable Lot Usages)
    Fields: ActiveTaskId, BarcodeFieldName, ConsumableBarcode, CreatedBy, DataRecordName, DateCreated, ElnId, ExpRecordId, LotNumber, LotNumberFieldName, LotRecordId, QuantityUsed, VeloxLastModifiedBy, VeloxLastModifiedDate
    Data type used in workflows to allow memory of what is used.
    """
    DATA_TYPE_NAME: str = 'ConsumableLotUsage'
    ACTIVETASKID__FIELD_NAME: WrapperField = WrapperField("ActiveTaskId", FieldType.LONG)
    BARCODEFIELDNAME__FIELD_NAME: WrapperField = WrapperField("BarcodeFieldName", FieldType.STRING)
    CONSUMABLEBARCODE__FIELD_NAME: WrapperField = WrapperField("ConsumableBarcode", FieldType.STRING)
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    ELNID__FIELD_NAME: WrapperField = WrapperField("ElnId", FieldType.STRING)
    EXPRECORDID__FIELD_NAME: WrapperField = WrapperField("ExpRecordId", FieldType.LONG)
    LOTNUMBER__FIELD_NAME: WrapperField = WrapperField("LotNumber", FieldType.STRING)
    LOTNUMBERFIELDNAME__FIELD_NAME: WrapperField = WrapperField("LotNumberFieldName", FieldType.STRING)
    LOTRECORDID__FIELD_NAME: WrapperField = WrapperField("LotRecordId", FieldType.LONG)
    QUANTITYUSED__FIELD_NAME: WrapperField = WrapperField("QuantityUsed", FieldType.DOUBLE)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_ActiveTaskId_field(self, value: Optional[int]):
        """
        Set data field with field name 'ActiveTaskId' on this record model
        """
        self.set_field_value(self.ACTIVETASKID__FIELD_NAME.field_name, value)

    def get_ActiveTaskId_field(self) -> Optional[int]:
        """
        Get data field value with field name 'ActiveTaskId' from this record model
        """
        return self.get_field_value(self.ACTIVETASKID__FIELD_NAME.field_name)

    def set_BarcodeFieldName_field(self, value: Optional[str]):
        """
        Set data field with field name 'BarcodeFieldName' on this record model
        """
        self.set_field_value(self.BARCODEFIELDNAME__FIELD_NAME.field_name, value)

    def get_BarcodeFieldName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'BarcodeFieldName' from this record model
        """
        return self.get_field_value(self.BARCODEFIELDNAME__FIELD_NAME.field_name)

    def set_ConsumableBarcode_field(self, value: Optional[str]):
        """
        Set data field with field name 'ConsumableBarcode' on this record model
        """
        self.set_field_value(self.CONSUMABLEBARCODE__FIELD_NAME.field_name, value)

    def get_ConsumableBarcode_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ConsumableBarcode' from this record model
        """
        return self.get_field_value(self.CONSUMABLEBARCODE__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_ElnId_field(self, value: Optional[str]):
        """
        Set data field with field name 'ElnId' on this record model
        """
        self.set_field_value(self.ELNID__FIELD_NAME.field_name, value)

    def get_ElnId_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ElnId' from this record model
        """
        return self.get_field_value(self.ELNID__FIELD_NAME.field_name)

    def set_ExpRecordId_field(self, value: Optional[int]):
        """
        Set data field with field name 'ExpRecordId' on this record model
        """
        self.set_field_value(self.EXPRECORDID__FIELD_NAME.field_name, value)

    def get_ExpRecordId_field(self) -> Optional[int]:
        """
        Get data field value with field name 'ExpRecordId' from this record model
        """
        return self.get_field_value(self.EXPRECORDID__FIELD_NAME.field_name)

    def set_LotNumber_field(self, value: Optional[str]):
        """
        Set data field with field name 'LotNumber' on this record model
        """
        self.set_field_value(self.LOTNUMBER__FIELD_NAME.field_name, value)

    def get_LotNumber_field(self) -> Optional[str]:
        """
        Get data field value with field name 'LotNumber' from this record model
        """
        return self.get_field_value(self.LOTNUMBER__FIELD_NAME.field_name)

    def set_LotNumberFieldName_field(self, value: Optional[str]):
        """
        Set data field with field name 'LotNumberFieldName' on this record model
        """
        self.set_field_value(self.LOTNUMBERFIELDNAME__FIELD_NAME.field_name, value)

    def get_LotNumberFieldName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'LotNumberFieldName' from this record model
        """
        return self.get_field_value(self.LOTNUMBERFIELDNAME__FIELD_NAME.field_name)

    def set_LotRecordId_field(self, value: Optional[int]):
        """
        Set data field with field name 'LotRecordId' on this record model
        """
        self.set_field_value(self.LOTRECORDID__FIELD_NAME.field_name, value)

    def get_LotRecordId_field(self) -> Optional[int]:
        """
        Get data field value with field name 'LotRecordId' from this record model
        """
        return self.get_field_value(self.LOTRECORDID__FIELD_NAME.field_name)

    def set_QuantityUsed_field(self, value: Optional[float]):
        """
        Set data field with field name 'QuantityUsed' on this record model
        """
        self.set_field_value(self.QUANTITYUSED__FIELD_NAME.field_name, value)

    def get_QuantityUsed_field(self) -> Optional[float]:
        """
        Get data field value with field name 'QuantityUsed' from this record model
        """
        return self.get_field_value(self.QUANTITYUSED__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class DataLinkConfigModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type DataLinkConfig
    Data Type Display Name: Data Link Configuration (Data Link Configuration)
    Fields: CreatedBy, DataRecordName, DateCreated, VeloxLastModifiedBy, VeloxLastModifiedDate
    """
    DATA_TYPE_NAME: str = 'DataLinkConfig'
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class DataWarehouseRScriptModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type DataWarehouseRScript
    Data Type Display Name: Data Warehouse R Script (Data Warehouse R Scripts)
    Fields: CreatedBy, DataRecordName, DateCreated, ScriptContent, ScriptDescription, ScriptId, VeloxLastModifiedBy, VeloxLastModifiedDate
    """
    DATA_TYPE_NAME: str = 'DataWarehouseRScript'
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    SCRIPTCONTENT__FIELD_NAME: WrapperField = WrapperField("ScriptContent", FieldType.STRING)
    SCRIPTDESCRIPTION__FIELD_NAME: WrapperField = WrapperField("ScriptDescription", FieldType.STRING)
    SCRIPTID__FIELD_NAME: WrapperField = WrapperField("ScriptId", FieldType.STRING)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_ScriptContent_field(self, value: Optional[str]):
        """
        Set data field with field name 'ScriptContent' on this record model
        """
        self.set_field_value(self.SCRIPTCONTENT__FIELD_NAME.field_name, value)

    def get_ScriptContent_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ScriptContent' from this record model
        """
        return self.get_field_value(self.SCRIPTCONTENT__FIELD_NAME.field_name)

    def set_ScriptDescription_field(self, value: Optional[str]):
        """
        Set data field with field name 'ScriptDescription' on this record model
        """
        self.set_field_value(self.SCRIPTDESCRIPTION__FIELD_NAME.field_name, value)

    def get_ScriptDescription_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ScriptDescription' from this record model
        """
        return self.get_field_value(self.SCRIPTDESCRIPTION__FIELD_NAME.field_name)

    def set_ScriptId_field(self, value: Optional[str]):
        """
        Set data field with field name 'ScriptId' on this record model
        """
        self.set_field_value(self.SCRIPTID__FIELD_NAME.field_name, value)

    def get_ScriptId_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ScriptId' from this record model
        """
        return self.get_field_value(self.SCRIPTID__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class DirectoryModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type Directory
    Data Type Display Name: Directory (Directories)
    Fields: CreatedBy, DataRecordName, DateCreated, DirectoryName, VeloxLastModifiedBy, VeloxLastModifiedDate
    """
    DATA_TYPE_NAME: str = 'Directory'
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    DIRECTORYNAME__FIELD_NAME: WrapperField = WrapperField("DirectoryName", FieldType.STRING)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_DirectoryName_field(self, value: Optional[str]):
        """
        Set data field with field name 'DirectoryName' on this record model
        """
        self.set_field_value(self.DIRECTORYNAME__FIELD_NAME.field_name, value)

    def get_DirectoryName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'DirectoryName' from this record model
        """
        return self.get_field_value(self.DIRECTORYNAME__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class DNAModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type DNA
    Data Type Display Name: DNA (DNAs)
    Fields: CreatedBy, DataRecordName, DateCreated, ExpirationDate, ItemId, Name, PartNumber, SequenceType, VeloxLastModifiedBy, VeloxLastModifiedDate
    """
    DATA_TYPE_NAME: str = 'DNA'
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    EXPIRATIONDATE__FIELD_NAME: WrapperField = WrapperField("ExpirationDate", FieldType.DATE)
    ITEMID__FIELD_NAME: WrapperField = WrapperField("ItemId", FieldType.STRING)
    NAME__FIELD_NAME: WrapperField = WrapperField("Name", FieldType.STRING)
    PARTNUMBER__FIELD_NAME: WrapperField = WrapperField("PartNumber", FieldType.STRING)
    SEQUENCETYPE__FIELD_NAME: WrapperField = WrapperField("SequenceType", FieldType.PICKLIST)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_ExpirationDate_field(self, value: Optional[int]):
        """
        Set data field with field name 'ExpirationDate' on this record model
        """
        self.set_field_value(self.EXPIRATIONDATE__FIELD_NAME.field_name, value)

    def get_ExpirationDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'ExpirationDate' from this record model
        """
        return self.get_field_value(self.EXPIRATIONDATE__FIELD_NAME.field_name)

    def set_ItemId_field(self, value: Optional[str]):
        """
        Set data field with field name 'ItemId' on this record model
        """
        self.set_field_value(self.ITEMID__FIELD_NAME.field_name, value)

    def get_ItemId_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ItemId' from this record model
        """
        return self.get_field_value(self.ITEMID__FIELD_NAME.field_name)

    def set_Name_field(self, value: Optional[str]):
        """
        Set data field with field name 'Name' on this record model
        """
        self.set_field_value(self.NAME__FIELD_NAME.field_name, value)

    def get_Name_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Name' from this record model
        """
        return self.get_field_value(self.NAME__FIELD_NAME.field_name)

    def set_PartNumber_field(self, value: Optional[str]):
        """
        Set data field with field name 'PartNumber' on this record model
        """
        self.set_field_value(self.PARTNUMBER__FIELD_NAME.field_name, value)

    def get_PartNumber_field(self) -> Optional[str]:
        """
        Get data field value with field name 'PartNumber' from this record model
        """
        return self.get_field_value(self.PARTNUMBER__FIELD_NAME.field_name)

    def set_SequenceType_field(self, value: Optional[str]):
        """
        Set data field with field name 'SequenceType' on this record model
        """
        self.set_field_value(self.SEQUENCETYPE__FIELD_NAME.field_name, value)

    def get_SequenceType_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SequenceType' from this record model
        """
        return self.get_field_value(self.SEQUENCETYPE__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class DNAPartModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type DNAPart
    Data Type Display Name: DNA Part (DNA Parts)
    Fields: CreatedBy, DataRecordName, DateCreated, Description, EditLock, GenbankAttachment, GenebankAttachment, IsCircular, Name, PartNumber, QuantityOnHand, Sequence, SequenceHash, SequenceType, SourcePart, VeloxLastModifiedBy, VeloxLastModifiedDate
    <-- VIRTUAL ENTITY DATA TYPE -->
    """
    DATA_TYPE_NAME: str = 'DNAPart'
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    DESCRIPTION__FIELD_NAME: WrapperField = WrapperField("Description", FieldType.STRING)
    EDITLOCK__FIELD_NAME: WrapperField = WrapperField("EditLock", FieldType.BOOLEAN)
    GENBANKATTACHMENT__FIELD_NAME: WrapperField = WrapperField("GenbankAttachment", FieldType.SIDE_LINK)
    GENEBANKATTACHMENT__FIELD_NAME: WrapperField = WrapperField("GenebankAttachment", FieldType.STRING)
    ISCIRCULAR__FIELD_NAME: WrapperField = WrapperField("IsCircular", FieldType.BOOLEAN)
    NAME__FIELD_NAME: WrapperField = WrapperField("Name", FieldType.STRING)
    PARTNUMBER__FIELD_NAME: WrapperField = WrapperField("PartNumber", FieldType.STRING)
    QUANTITYONHAND__FIELD_NAME: WrapperField = WrapperField("QuantityOnHand", FieldType.DOUBLE)
    SEQUENCE__FIELD_NAME: WrapperField = WrapperField("Sequence", FieldType.STRING)
    SEQUENCEHASH__FIELD_NAME: WrapperField = WrapperField("SequenceHash", FieldType.STRING)
    SEQUENCETYPE__FIELD_NAME: WrapperField = WrapperField("SequenceType", FieldType.PICKLIST)
    SOURCEPART__FIELD_NAME: WrapperField = WrapperField("SourcePart", FieldType.SIDE_LINK)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_Description_field(self, value: Optional[str]):
        """
        Set data field with field name 'Description' on this record model
        """
        self.set_field_value(self.DESCRIPTION__FIELD_NAME.field_name, value)

    def get_Description_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Description' from this record model
        """
        return self.get_field_value(self.DESCRIPTION__FIELD_NAME.field_name)

    def set_EditLock_field(self, value: Optional[bool]):
        """
        Set data field with field name 'EditLock' on this record model
        """
        self.set_field_value(self.EDITLOCK__FIELD_NAME.field_name, value)

    def get_EditLock_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'EditLock' from this record model
        """
        return self.get_field_value(self.EDITLOCK__FIELD_NAME.field_name)

    def set_GenbankAttachment_field(self, value: Optional[int]):
        """
        Set data field with field name 'GenbankAttachment' on this record model
        """
        self.set_field_value(self.GENBANKATTACHMENT__FIELD_NAME.field_name, value)

    def get_GenbankAttachment_field(self) -> Optional[int]:
        """
        Get data field value with field name 'GenbankAttachment' from this record model
        """
        return self.get_field_value(self.GENBANKATTACHMENT__FIELD_NAME.field_name)

    def set_GenebankAttachment_field(self, value: Optional[str]):
        """
        Set data field with field name 'GenebankAttachment' on this record model
        """
        self.set_field_value(self.GENEBANKATTACHMENT__FIELD_NAME.field_name, value)

    def get_GenebankAttachment_field(self) -> Optional[str]:
        """
        Get data field value with field name 'GenebankAttachment' from this record model
        """
        return self.get_field_value(self.GENEBANKATTACHMENT__FIELD_NAME.field_name)

    def set_IsCircular_field(self, value: Optional[bool]):
        """
        Set data field with field name 'IsCircular' on this record model
        """
        self.set_field_value(self.ISCIRCULAR__FIELD_NAME.field_name, value)

    def get_IsCircular_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'IsCircular' from this record model
        """
        return self.get_field_value(self.ISCIRCULAR__FIELD_NAME.field_name)

    def set_Name_field(self, value: Optional[str]):
        """
        Set data field with field name 'Name' on this record model
        """
        self.set_field_value(self.NAME__FIELD_NAME.field_name, value)

    def get_Name_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Name' from this record model
        """
        return self.get_field_value(self.NAME__FIELD_NAME.field_name)

    def set_PartNumber_field(self, value: Optional[str]):
        """
        Set data field with field name 'PartNumber' on this record model
        """
        self.set_field_value(self.PARTNUMBER__FIELD_NAME.field_name, value)

    def get_PartNumber_field(self) -> Optional[str]:
        """
        Get data field value with field name 'PartNumber' from this record model
        """
        return self.get_field_value(self.PARTNUMBER__FIELD_NAME.field_name)

    def set_QuantityOnHand_field(self, value: Optional[float]):
        """
        Set data field with field name 'QuantityOnHand' on this record model
        """
        self.set_field_value(self.QUANTITYONHAND__FIELD_NAME.field_name, value)

    def get_QuantityOnHand_field(self) -> Optional[float]:
        """
        Get data field value with field name 'QuantityOnHand' from this record model
        """
        return self.get_field_value(self.QUANTITYONHAND__FIELD_NAME.field_name)

    def set_Sequence_field(self, value: Optional[str]):
        """
        Set data field with field name 'Sequence' on this record model
        """
        self.set_field_value(self.SEQUENCE__FIELD_NAME.field_name, value)

    def get_Sequence_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Sequence' from this record model
        """
        return self.get_field_value(self.SEQUENCE__FIELD_NAME.field_name)

    def set_SequenceHash_field(self, value: Optional[str]):
        """
        Set data field with field name 'SequenceHash' on this record model
        """
        self.set_field_value(self.SEQUENCEHASH__FIELD_NAME.field_name, value)

    def get_SequenceHash_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SequenceHash' from this record model
        """
        return self.get_field_value(self.SEQUENCEHASH__FIELD_NAME.field_name)

    def set_SequenceType_field(self, value: Optional[str]):
        """
        Set data field with field name 'SequenceType' on this record model
        """
        self.set_field_value(self.SEQUENCETYPE__FIELD_NAME.field_name, value)

    def get_SequenceType_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SequenceType' from this record model
        """
        return self.get_field_value(self.SEQUENCETYPE__FIELD_NAME.field_name)

    def set_SourcePart_field(self, value: Optional[int]):
        """
        Set data field with field name 'SourcePart' on this record model
        """
        self.set_field_value(self.SOURCEPART__FIELD_NAME.field_name, value)

    def get_SourcePart_field(self) -> Optional[int]:
        """
        Get data field value with field name 'SourcePart' from this record model
        """
        return self.get_field_value(self.SOURCEPART__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class DoseResponseModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type DoseResponse
    Data Type Display Name: Dose Response (Dose Responses)
    Fields: CreatedBy, DataRecordName, DateCreated, Dose, Response, VeloxLastModifiedBy, VeloxLastModifiedDate
    """
    DATA_TYPE_NAME: str = 'DoseResponse'
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    DOSE__FIELD_NAME: WrapperField = WrapperField("Dose", FieldType.DOUBLE)
    RESPONSE__FIELD_NAME: WrapperField = WrapperField("Response", FieldType.DOUBLE)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_Dose_field(self, value: Optional[float]):
        """
        Set data field with field name 'Dose' on this record model
        """
        self.set_field_value(self.DOSE__FIELD_NAME.field_name, value)

    def get_Dose_field(self) -> Optional[float]:
        """
        Get data field value with field name 'Dose' from this record model
        """
        return self.get_field_value(self.DOSE__FIELD_NAME.field_name)

    def set_Response_field(self, value: Optional[float]):
        """
        Set data field with field name 'Response' on this record model
        """
        self.set_field_value(self.RESPONSE__FIELD_NAME.field_name, value)

    def get_Response_field(self) -> Optional[float]:
        """
        Get data field value with field name 'Response' from this record model
        """
        return self.get_field_value(self.RESPONSE__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class DosingResultModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type DosingResult
    Data Type Display Name: Dosing Result (Dosing Results)
    Fields: ActualDose, AgentName, BaseDosage, CreatedBy, DataRecordName, DateCompleted, DateCreated, DoseComments, DoseResult, DoseType, DoseUnit, ExpectedDose, Formulation, RouteOfAdministration, TreatmentId, TreatmentRecordId, VeloxLastModifiedBy, VeloxLastModifiedDate
    """
    DATA_TYPE_NAME: str = 'DosingResult'
    ACTUALDOSE__FIELD_NAME: WrapperField = WrapperField("ActualDose", FieldType.DOUBLE)
    AGENTNAME__FIELD_NAME: WrapperField = WrapperField("AgentName", FieldType.SELECTION)
    BASEDOSAGE__FIELD_NAME: WrapperField = WrapperField("BaseDosage", FieldType.DOUBLE)
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECOMPLETED__FIELD_NAME: WrapperField = WrapperField("DateCompleted", FieldType.DATE)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    DOSECOMMENTS__FIELD_NAME: WrapperField = WrapperField("DoseComments", FieldType.STRING)
    DOSERESULT__FIELD_NAME: WrapperField = WrapperField("DoseResult", FieldType.PICKLIST)
    DOSETYPE__FIELD_NAME: WrapperField = WrapperField("DoseType", FieldType.PICKLIST)
    DOSEUNIT__FIELD_NAME: WrapperField = WrapperField("DoseUnit", FieldType.SELECTION)
    EXPECTEDDOSE__FIELD_NAME: WrapperField = WrapperField("ExpectedDose", FieldType.DOUBLE)
    FORMULATION__FIELD_NAME: WrapperField = WrapperField("Formulation", FieldType.SELECTION)
    ROUTEOFADMINISTRATION__FIELD_NAME: WrapperField = WrapperField("RouteOfAdministration", FieldType.SELECTION)
    TREATMENTID__FIELD_NAME: WrapperField = WrapperField("TreatmentId", FieldType.STRING)
    TREATMENTRECORDID__FIELD_NAME: WrapperField = WrapperField("TreatmentRecordId", FieldType.LONG)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_ActualDose_field(self, value: Optional[float]):
        """
        Set data field with field name 'ActualDose' on this record model
        """
        self.set_field_value(self.ACTUALDOSE__FIELD_NAME.field_name, value)

    def get_ActualDose_field(self) -> Optional[float]:
        """
        Get data field value with field name 'ActualDose' from this record model
        """
        return self.get_field_value(self.ACTUALDOSE__FIELD_NAME.field_name)

    def set_AgentName_field(self, value: Optional[str]):
        """
        Set data field with field name 'AgentName' on this record model
        """
        self.set_field_value(self.AGENTNAME__FIELD_NAME.field_name, value)

    def get_AgentName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'AgentName' from this record model
        """
        return self.get_field_value(self.AGENTNAME__FIELD_NAME.field_name)

    def set_BaseDosage_field(self, value: Optional[float]):
        """
        Set data field with field name 'BaseDosage' on this record model
        """
        self.set_field_value(self.BASEDOSAGE__FIELD_NAME.field_name, value)

    def get_BaseDosage_field(self) -> Optional[float]:
        """
        Get data field value with field name 'BaseDosage' from this record model
        """
        return self.get_field_value(self.BASEDOSAGE__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def set_DateCompleted_field(self, value: Optional[int]):
        """
        Set data field with field name 'DateCompleted' on this record model
        """
        self.set_field_value(self.DATECOMPLETED__FIELD_NAME.field_name, value)

    def get_DateCompleted_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCompleted' from this record model
        """
        return self.get_field_value(self.DATECOMPLETED__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_DoseComments_field(self, value: Optional[str]):
        """
        Set data field with field name 'DoseComments' on this record model
        """
        self.set_field_value(self.DOSECOMMENTS__FIELD_NAME.field_name, value)

    def get_DoseComments_field(self) -> Optional[str]:
        """
        Get data field value with field name 'DoseComments' from this record model
        """
        return self.get_field_value(self.DOSECOMMENTS__FIELD_NAME.field_name)

    def set_DoseResult_field(self, value: Optional[str]):
        """
        Set data field with field name 'DoseResult' on this record model
        """
        self.set_field_value(self.DOSERESULT__FIELD_NAME.field_name, value)

    def get_DoseResult_field(self) -> Optional[str]:
        """
        Get data field value with field name 'DoseResult' from this record model
        """
        return self.get_field_value(self.DOSERESULT__FIELD_NAME.field_name)

    def set_DoseType_field(self, value: Optional[str]):
        """
        Set data field with field name 'DoseType' on this record model
        """
        self.set_field_value(self.DOSETYPE__FIELD_NAME.field_name, value)

    def get_DoseType_field(self) -> Optional[str]:
        """
        Get data field value with field name 'DoseType' from this record model
        """
        return self.get_field_value(self.DOSETYPE__FIELD_NAME.field_name)

    def set_DoseUnit_field(self, value: Optional[str]):
        """
        Set data field with field name 'DoseUnit' on this record model
        """
        self.set_field_value(self.DOSEUNIT__FIELD_NAME.field_name, value)

    def get_DoseUnit_field(self) -> Optional[str]:
        """
        Get data field value with field name 'DoseUnit' from this record model
        """
        return self.get_field_value(self.DOSEUNIT__FIELD_NAME.field_name)

    def set_ExpectedDose_field(self, value: Optional[float]):
        """
        Set data field with field name 'ExpectedDose' on this record model
        """
        self.set_field_value(self.EXPECTEDDOSE__FIELD_NAME.field_name, value)

    def get_ExpectedDose_field(self) -> Optional[float]:
        """
        Get data field value with field name 'ExpectedDose' from this record model
        """
        return self.get_field_value(self.EXPECTEDDOSE__FIELD_NAME.field_name)

    def set_Formulation_field(self, value: Optional[str]):
        """
        Set data field with field name 'Formulation' on this record model
        """
        self.set_field_value(self.FORMULATION__FIELD_NAME.field_name, value)

    def get_Formulation_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Formulation' from this record model
        """
        return self.get_field_value(self.FORMULATION__FIELD_NAME.field_name)

    def set_RouteOfAdministration_field(self, value: Optional[str]):
        """
        Set data field with field name 'RouteOfAdministration' on this record model
        """
        self.set_field_value(self.ROUTEOFADMINISTRATION__FIELD_NAME.field_name, value)

    def get_RouteOfAdministration_field(self) -> Optional[str]:
        """
        Get data field value with field name 'RouteOfAdministration' from this record model
        """
        return self.get_field_value(self.ROUTEOFADMINISTRATION__FIELD_NAME.field_name)

    def set_TreatmentId_field(self, value: Optional[str]):
        """
        Set data field with field name 'TreatmentId' on this record model
        """
        self.set_field_value(self.TREATMENTID__FIELD_NAME.field_name, value)

    def get_TreatmentId_field(self) -> Optional[str]:
        """
        Get data field value with field name 'TreatmentId' from this record model
        """
        return self.get_field_value(self.TREATMENTID__FIELD_NAME.field_name)

    def set_TreatmentRecordId_field(self, value: Optional[int]):
        """
        Set data field with field name 'TreatmentRecordId' on this record model
        """
        self.set_field_value(self.TREATMENTRECORDID__FIELD_NAME.field_name, value)

    def get_TreatmentRecordId_field(self) -> Optional[int]:
        """
        Get data field value with field name 'TreatmentRecordId' from this record model
        """
        return self.get_field_value(self.TREATMENTRECORDID__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class DownstreamProcessingYieldModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type DownstreamProcessingYield
    Data Type Display Name: Downstream Processing Yield (Downstream Processing Yields)
    Fields: CentrifugationYield, CreatedBy, DataRecordName, DateCreated, DiafiltrationYield, MultiParentLink215, OtherSampleId, SampleId, VeloxLastModifiedBy, VeloxLastModifiedDate
    """
    DATA_TYPE_NAME: str = 'DownstreamProcessingYield'
    CENTRIFUGATIONYIELD__FIELD_NAME: WrapperField = WrapperField("CentrifugationYield", FieldType.DOUBLE)
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    DIAFILTRATIONYIELD__FIELD_NAME: WrapperField = WrapperField("DiafiltrationYield", FieldType.DOUBLE)
    MULTIPARENTLINK215__FIELD_NAME: WrapperField = WrapperField("MultiParentLink215", FieldType.MULTIPARENTLINK)
    OTHERSAMPLEID__FIELD_NAME: WrapperField = WrapperField("OtherSampleId", FieldType.STRING)
    SAMPLEID__FIELD_NAME: WrapperField = WrapperField("SampleId", FieldType.STRING)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_CentrifugationYield_field(self, value: Optional[float]):
        """
        Set data field with field name 'CentrifugationYield' on this record model
        """
        self.set_field_value(self.CENTRIFUGATIONYIELD__FIELD_NAME.field_name, value)

    def get_CentrifugationYield_field(self) -> Optional[float]:
        """
        Get data field value with field name 'CentrifugationYield' from this record model
        """
        return self.get_field_value(self.CENTRIFUGATIONYIELD__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_DiafiltrationYield_field(self, value: Optional[float]):
        """
        Set data field with field name 'DiafiltrationYield' on this record model
        """
        self.set_field_value(self.DIAFILTRATIONYIELD__FIELD_NAME.field_name, value)

    def get_DiafiltrationYield_field(self) -> Optional[float]:
        """
        Get data field value with field name 'DiafiltrationYield' from this record model
        """
        return self.get_field_value(self.DIAFILTRATIONYIELD__FIELD_NAME.field_name)

    def set_OtherSampleId_field(self, value: Optional[str]):
        """
        Set data field with field name 'OtherSampleId' on this record model
        """
        self.set_field_value(self.OTHERSAMPLEID__FIELD_NAME.field_name, value)

    def get_OtherSampleId_field(self) -> Optional[str]:
        """
        Get data field value with field name 'OtherSampleId' from this record model
        """
        return self.get_field_value(self.OTHERSAMPLEID__FIELD_NAME.field_name)

    def set_SampleId_field(self, value: Optional[str]):
        """
        Set data field with field name 'SampleId' on this record model
        """
        self.set_field_value(self.SAMPLEID__FIELD_NAME.field_name, value)

    def get_SampleId_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SampleId' from this record model
        """
        return self.get_field_value(self.SAMPLEID__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class DropSenseA260ResultModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type DropSenseA260Result
    Data Type Display Name: DropSense A260 Result (DropSense A260 Results)
    Fields: A260230, A260280, CreatedBy, DataRecordName, DateCreated, DilutionFactor, VeloxLastModifiedBy, VeloxLastModifiedDate
    """
    DATA_TYPE_NAME: str = 'DropSenseA260Result'
    A260230__FIELD_NAME: WrapperField = WrapperField("A260230", FieldType.DOUBLE)
    A260280__FIELD_NAME: WrapperField = WrapperField("A260280", FieldType.DOUBLE)
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    DILUTIONFACTOR__FIELD_NAME: WrapperField = WrapperField("DilutionFactor", FieldType.DOUBLE)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_A260230_field(self, value: Optional[float]):
        """
        Set data field with field name 'A260230' on this record model
        """
        self.set_field_value(self.A260230__FIELD_NAME.field_name, value)

    def get_A260230_field(self) -> Optional[float]:
        """
        Get data field value with field name 'A260230' from this record model
        """
        return self.get_field_value(self.A260230__FIELD_NAME.field_name)

    def set_A260280_field(self, value: Optional[float]):
        """
        Set data field with field name 'A260280' on this record model
        """
        self.set_field_value(self.A260280__FIELD_NAME.field_name, value)

    def get_A260280_field(self) -> Optional[float]:
        """
        Get data field value with field name 'A260280' from this record model
        """
        return self.get_field_value(self.A260280__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_DilutionFactor_field(self, value: Optional[float]):
        """
        Set data field with field name 'DilutionFactor' on this record model
        """
        self.set_field_value(self.DILUTIONFACTOR__FIELD_NAME.field_name, value)

    def get_DilutionFactor_field(self) -> Optional[float]:
        """
        Get data field value with field name 'DilutionFactor' from this record model
        """
        return self.get_field_value(self.DILUTIONFACTOR__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class DropSenseA280ResultModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type DropSenseA280Result
    Data Type Display Name: DropSense A280 Result (DropSense A280 Results)
    Fields: CreatedBy, DataRecordName, DateCreated, ExtinctionCoefficient, VeloxLastModifiedBy, VeloxLastModifiedDate
    """
    DATA_TYPE_NAME: str = 'DropSenseA280Result'
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    EXTINCTIONCOEFFICIENT__FIELD_NAME: WrapperField = WrapperField("ExtinctionCoefficient", FieldType.DOUBLE)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_ExtinctionCoefficient_field(self, value: Optional[float]):
        """
        Set data field with field name 'ExtinctionCoefficient' on this record model
        """
        self.set_field_value(self.EXTINCTIONCOEFFICIENT__FIELD_NAME.field_name, value)

    def get_ExtinctionCoefficient_field(self) -> Optional[float]:
        """
        Get data field value with field name 'ExtinctionCoefficient' from this record model
        """
        return self.get_field_value(self.EXTINCTIONCOEFFICIENT__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class ELNExperimentModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type ELNExperiment
    Data Type Display Name: Experiment (Experiments)
    Fields: CreatedBy, DataRecordName, DataTypeId, DateCreated, TemplateExperimentName, TemplateVersion, VeloxCompletedBy, VeloxDateCompleted, VeloxExperimentStatus, VeloxLastModifiedBy, VeloxLastModifiedDate, VELOXOWNER
    Data type to represent the base E-Notebook data type.
    """
    DATA_TYPE_NAME: str = 'ELNExperiment'
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATATYPEID__FIELD_NAME: WrapperField = WrapperField("DataTypeId", FieldType.LONG)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    TEMPLATEEXPERIMENTNAME__FIELD_NAME: WrapperField = WrapperField("TemplateExperimentName", FieldType.STRING)
    TEMPLATEVERSION__FIELD_NAME: WrapperField = WrapperField("TemplateVersion", FieldType.LONG)
    VELOXCOMPLETEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxCompletedBy", FieldType.STRING)
    VELOXDATECOMPLETED__FIELD_NAME: WrapperField = WrapperField("VeloxDateCompleted", FieldType.DATE)
    VELOXEXPERIMENTSTATUS__FIELD_NAME: WrapperField = WrapperField("VeloxExperimentStatus", FieldType.STRING)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)
    VELOXOWNER__FIELD_NAME: WrapperField = WrapperField("VELOXOWNER", FieldType.STRING)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def set_DataTypeId_field(self, value: Optional[int]):
        """
        Set data field with field name 'DataTypeId' on this record model
        """
        self.set_field_value(self.DATATYPEID__FIELD_NAME.field_name, value)

    def get_DataTypeId_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DataTypeId' from this record model
        """
        return self.get_field_value(self.DATATYPEID__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_TemplateExperimentName_field(self, value: Optional[str]):
        """
        Set data field with field name 'TemplateExperimentName' on this record model
        """
        self.set_field_value(self.TEMPLATEEXPERIMENTNAME__FIELD_NAME.field_name, value)

    def get_TemplateExperimentName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'TemplateExperimentName' from this record model
        """
        return self.get_field_value(self.TEMPLATEEXPERIMENTNAME__FIELD_NAME.field_name)

    def set_TemplateVersion_field(self, value: Optional[int]):
        """
        Set data field with field name 'TemplateVersion' on this record model
        """
        self.set_field_value(self.TEMPLATEVERSION__FIELD_NAME.field_name, value)

    def get_TemplateVersion_field(self) -> Optional[int]:
        """
        Get data field value with field name 'TemplateVersion' from this record model
        """
        return self.get_field_value(self.TEMPLATEVERSION__FIELD_NAME.field_name)

    def set_VeloxCompletedBy_field(self, value: Optional[str]):
        """
        Set data field with field name 'VeloxCompletedBy' on this record model
        """
        self.set_field_value(self.VELOXCOMPLETEDBY__FIELD_NAME.field_name, value)

    def get_VeloxCompletedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxCompletedBy' from this record model
        """
        return self.get_field_value(self.VELOXCOMPLETEDBY__FIELD_NAME.field_name)

    def set_VeloxDateCompleted_field(self, value: Optional[int]):
        """
        Set data field with field name 'VeloxDateCompleted' on this record model
        """
        self.set_field_value(self.VELOXDATECOMPLETED__FIELD_NAME.field_name, value)

    def get_VeloxDateCompleted_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxDateCompleted' from this record model
        """
        return self.get_field_value(self.VELOXDATECOMPLETED__FIELD_NAME.field_name)

    def set_VeloxExperimentStatus_field(self, value: Optional[str]):
        """
        Set data field with field name 'VeloxExperimentStatus' on this record model
        """
        self.set_field_value(self.VELOXEXPERIMENTSTATUS__FIELD_NAME.field_name, value)

    def get_VeloxExperimentStatus_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxExperimentStatus' from this record model
        """
        return self.get_field_value(self.VELOXEXPERIMENTSTATUS__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)

    def set_VELOXOWNER_field(self, value: Optional[str]):
        """
        Set data field with field name 'VELOXOWNER' on this record model
        """
        self.set_field_value(self.VELOXOWNER__FIELD_NAME.field_name, value)

    def get_VELOXOWNER_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VELOXOWNER' from this record model
        """
        return self.get_field_value(self.VELOXOWNER__FIELD_NAME.field_name)


class ELNExperimentDetailModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type ELNExperimentDetail
    Data Type Display Name: Experiment Detail (Experiment Details)
    Fields: CreatedBy, DataRecordName, DataTypeId, DateCreated, VeloxLastModifiedBy, VeloxLastModifiedDate
    Data type to represent the base E-Notebook data type to represent the experiment details.
    """
    DATA_TYPE_NAME: str = 'ELNExperimentDetail'
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATATYPEID__FIELD_NAME: WrapperField = WrapperField("DataTypeId", FieldType.LONG)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def set_DataTypeId_field(self, value: Optional[int]):
        """
        Set data field with field name 'DataTypeId' on this record model
        """
        self.set_field_value(self.DATATYPEID__FIELD_NAME.field_name, value)

    def get_DataTypeId_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DataTypeId' from this record model
        """
        return self.get_field_value(self.DATATYPEID__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class ELNSampleDetailModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type ELNSampleDetail
    Data Type Display Name: Sample Detail (Sample Details)
    Fields: CreatedBy, DataRecordName, DataTypeId, DateCreated, OtherSampleId, SampleId, VeloxLastModifiedBy, VeloxLastModifiedDate
    Data type to represent the base E-Notebook data type to represent the sample level details.
    """
    DATA_TYPE_NAME: str = 'ELNSampleDetail'
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATATYPEID__FIELD_NAME: WrapperField = WrapperField("DataTypeId", FieldType.LONG)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    OTHERSAMPLEID__FIELD_NAME: WrapperField = WrapperField("OtherSampleId", FieldType.STRING)
    SAMPLEID__FIELD_NAME: WrapperField = WrapperField("SampleId", FieldType.STRING)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def set_DataTypeId_field(self, value: Optional[int]):
        """
        Set data field with field name 'DataTypeId' on this record model
        """
        self.set_field_value(self.DATATYPEID__FIELD_NAME.field_name, value)

    def get_DataTypeId_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DataTypeId' from this record model
        """
        return self.get_field_value(self.DATATYPEID__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_OtherSampleId_field(self, value: Optional[str]):
        """
        Set data field with field name 'OtherSampleId' on this record model
        """
        self.set_field_value(self.OTHERSAMPLEID__FIELD_NAME.field_name, value)

    def get_OtherSampleId_field(self) -> Optional[str]:
        """
        Get data field value with field name 'OtherSampleId' from this record model
        """
        return self.get_field_value(self.OTHERSAMPLEID__FIELD_NAME.field_name)

    def set_SampleId_field(self, value: Optional[str]):
        """
        Set data field with field name 'SampleId' on this record model
        """
        self.set_field_value(self.SAMPLEID__FIELD_NAME.field_name, value)

    def get_SampleId_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SampleId' from this record model
        """
        return self.get_field_value(self.SAMPLEID__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class ELNTextEntryDetailModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type ELNTextEntryDetail
    Data Type Display Name: ELN Text Entry Detail (ELN Text Entry Details)
    Fields: CreatedBy, DataRecordName, DateCreated, FilePath, TextField, VeloxCurrentVersion, VeloxLastModifiedBy, VeloxLastModifiedDate
    This data type is used to store the latest PDF file that has been generated from a given notebook.
    """
    DATA_TYPE_NAME: str = 'ELNTextEntryDetail'
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    FILEPATH__FIELD_NAME: WrapperField = WrapperField("FilePath", FieldType.STRING)
    TEXTFIELD__FIELD_NAME: WrapperField = WrapperField("TextField", FieldType.STRING)
    VELOXCURRENTVERSION__FIELD_NAME: WrapperField = WrapperField("VeloxCurrentVersion", FieldType.INTEGER)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_FilePath_field(self, value: Optional[str]):
        """
        Set data field with field name 'FilePath' on this record model
        """
        self.set_field_value(self.FILEPATH__FIELD_NAME.field_name, value)

    def get_FilePath_field(self) -> Optional[str]:
        """
        Get data field value with field name 'FilePath' from this record model
        """
        return self.get_field_value(self.FILEPATH__FIELD_NAME.field_name)

    def set_TextField_field(self, value: Optional[str]):
        """
        Set data field with field name 'TextField' on this record model
        """
        self.set_field_value(self.TEXTFIELD__FIELD_NAME.field_name, value)

    def get_TextField_field(self) -> Optional[str]:
        """
        Get data field value with field name 'TextField' from this record model
        """
        return self.get_field_value(self.TEXTFIELD__FIELD_NAME.field_name)

    def set_VeloxCurrentVersion_field(self, value: Optional[int]):
        """
        Set data field with field name 'VeloxCurrentVersion' on this record model
        """
        self.set_field_value(self.VELOXCURRENTVERSION__FIELD_NAME.field_name, value)

    def get_VeloxCurrentVersion_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxCurrentVersion' from this record model
        """
        return self.get_field_value(self.VELOXCURRENTVERSION__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class EmailModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type Email
    Data Type Display Name: Email (Emails)
    Fields: AddressedTo, Body, CarbonCopy, CreatedBy, DataRecordName, DateCreated, MultiParentLink230, SentDate, SentFrom, Subject, VeloxLastModifiedBy, VeloxLastModifiedDate
    """
    DATA_TYPE_NAME: str = 'Email'
    ADDRESSEDTO__FIELD_NAME: WrapperField = WrapperField("AddressedTo", FieldType.STRING)
    BODY__FIELD_NAME: WrapperField = WrapperField("Body", FieldType.STRING)
    CARBONCOPY__FIELD_NAME: WrapperField = WrapperField("CarbonCopy", FieldType.STRING)
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    MULTIPARENTLINK230__FIELD_NAME: WrapperField = WrapperField("MultiParentLink230", FieldType.MULTIPARENTLINK)
    SENTDATE__FIELD_NAME: WrapperField = WrapperField("SentDate", FieldType.DATE)
    SENTFROM__FIELD_NAME: WrapperField = WrapperField("SentFrom", FieldType.STRING)
    SUBJECT__FIELD_NAME: WrapperField = WrapperField("Subject", FieldType.STRING)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_AddressedTo_field(self, value: Optional[str]):
        """
        Set data field with field name 'AddressedTo' on this record model
        """
        self.set_field_value(self.ADDRESSEDTO__FIELD_NAME.field_name, value)

    def get_AddressedTo_field(self) -> Optional[str]:
        """
        Get data field value with field name 'AddressedTo' from this record model
        """
        return self.get_field_value(self.ADDRESSEDTO__FIELD_NAME.field_name)

    def set_Body_field(self, value: Optional[str]):
        """
        Set data field with field name 'Body' on this record model
        """
        self.set_field_value(self.BODY__FIELD_NAME.field_name, value)

    def get_Body_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Body' from this record model
        """
        return self.get_field_value(self.BODY__FIELD_NAME.field_name)

    def set_CarbonCopy_field(self, value: Optional[str]):
        """
        Set data field with field name 'CarbonCopy' on this record model
        """
        self.set_field_value(self.CARBONCOPY__FIELD_NAME.field_name, value)

    def get_CarbonCopy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CarbonCopy' from this record model
        """
        return self.get_field_value(self.CARBONCOPY__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_SentDate_field(self, value: Optional[int]):
        """
        Set data field with field name 'SentDate' on this record model
        """
        self.set_field_value(self.SENTDATE__FIELD_NAME.field_name, value)

    def get_SentDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'SentDate' from this record model
        """
        return self.get_field_value(self.SENTDATE__FIELD_NAME.field_name)

    def set_SentFrom_field(self, value: Optional[str]):
        """
        Set data field with field name 'SentFrom' on this record model
        """
        self.set_field_value(self.SENTFROM__FIELD_NAME.field_name, value)

    def get_SentFrom_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SentFrom' from this record model
        """
        return self.get_field_value(self.SENTFROM__FIELD_NAME.field_name)

    def set_Subject_field(self, value: Optional[str]):
        """
        Set data field with field name 'Subject' on this record model
        """
        self.set_field_value(self.SUBJECT__FIELD_NAME.field_name, value)

    def get_Subject_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Subject' from this record model
        """
        return self.get_field_value(self.SUBJECT__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class EnbAttachmentThumbnailModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type EnbAttachmentThumbnail
    Data Type Display Name: E-Notebook Attachment Thumbnail (E-Notebook Attachment Thumbnails)
    Fields: CreatedBy, DataRecordName, DateCreated, FilePath, PageNumber, ResolutionHeight, ResolutionWidth, SinglePage, VeloxCurrentVersion, VeloxLastModifiedBy, VeloxLastModifiedDate
    An attachment that stores a cached thumbnail of a page from a document attached to an Experiment entry.
    """
    DATA_TYPE_NAME: str = 'EnbAttachmentThumbnail'
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    FILEPATH__FIELD_NAME: WrapperField = WrapperField("FilePath", FieldType.STRING)
    PAGENUMBER__FIELD_NAME: WrapperField = WrapperField("PageNumber", FieldType.INTEGER)
    RESOLUTIONHEIGHT__FIELD_NAME: WrapperField = WrapperField("ResolutionHeight", FieldType.INTEGER)
    RESOLUTIONWIDTH__FIELD_NAME: WrapperField = WrapperField("ResolutionWidth", FieldType.INTEGER)
    SINGLEPAGE__FIELD_NAME: WrapperField = WrapperField("SinglePage", FieldType.BOOLEAN)
    VELOXCURRENTVERSION__FIELD_NAME: WrapperField = WrapperField("VeloxCurrentVersion", FieldType.INTEGER)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_FilePath_field(self, value: Optional[str]):
        """
        Set data field with field name 'FilePath' on this record model
        """
        self.set_field_value(self.FILEPATH__FIELD_NAME.field_name, value)

    def get_FilePath_field(self) -> Optional[str]:
        """
        Get data field value with field name 'FilePath' from this record model
        """
        return self.get_field_value(self.FILEPATH__FIELD_NAME.field_name)

    def set_PageNumber_field(self, value: Optional[int]):
        """
        Set data field with field name 'PageNumber' on this record model
        """
        self.set_field_value(self.PAGENUMBER__FIELD_NAME.field_name, value)

    def get_PageNumber_field(self) -> Optional[int]:
        """
        Get data field value with field name 'PageNumber' from this record model
        """
        return self.get_field_value(self.PAGENUMBER__FIELD_NAME.field_name)

    def set_ResolutionHeight_field(self, value: Optional[int]):
        """
        Set data field with field name 'ResolutionHeight' on this record model
        """
        self.set_field_value(self.RESOLUTIONHEIGHT__FIELD_NAME.field_name, value)

    def get_ResolutionHeight_field(self) -> Optional[int]:
        """
        Get data field value with field name 'ResolutionHeight' from this record model
        """
        return self.get_field_value(self.RESOLUTIONHEIGHT__FIELD_NAME.field_name)

    def set_ResolutionWidth_field(self, value: Optional[int]):
        """
        Set data field with field name 'ResolutionWidth' on this record model
        """
        self.set_field_value(self.RESOLUTIONWIDTH__FIELD_NAME.field_name, value)

    def get_ResolutionWidth_field(self) -> Optional[int]:
        """
        Get data field value with field name 'ResolutionWidth' from this record model
        """
        return self.get_field_value(self.RESOLUTIONWIDTH__FIELD_NAME.field_name)

    def set_SinglePage_field(self, value: Optional[bool]):
        """
        Set data field with field name 'SinglePage' on this record model
        """
        self.set_field_value(self.SINGLEPAGE__FIELD_NAME.field_name, value)

    def get_SinglePage_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'SinglePage' from this record model
        """
        return self.get_field_value(self.SINGLEPAGE__FIELD_NAME.field_name)

    def set_VeloxCurrentVersion_field(self, value: Optional[int]):
        """
        Set data field with field name 'VeloxCurrentVersion' on this record model
        """
        self.set_field_value(self.VELOXCURRENTVERSION__FIELD_NAME.field_name, value)

    def get_VeloxCurrentVersion_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxCurrentVersion' from this record model
        """
        return self.get_field_value(self.VELOXCURRENTVERSION__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class EnzymeModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type Enzyme
    Data Type Display Name: Enzyme (Enzymes)
    Fields: ConsumableName, ConsumableType, CreatedBy, CuttingPattern, DataRecordName, DateCreated, DateOfPurchase, EnzymeType, ExpirationDate, Isoschizomers, LotNumber, Neoschizomers, PartNumber, VeloxLastModifiedBy, VeloxLastModifiedDate, Vendor
    """
    DATA_TYPE_NAME: str = 'Enzyme'
    CONSUMABLENAME__FIELD_NAME: WrapperField = WrapperField("ConsumableName", FieldType.STRING)
    CONSUMABLETYPE__FIELD_NAME: WrapperField = WrapperField("ConsumableType", FieldType.SELECTION)
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    CUTTINGPATTERN__FIELD_NAME: WrapperField = WrapperField("CuttingPattern", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    DATEOFPURCHASE__FIELD_NAME: WrapperField = WrapperField("DateOfPurchase", FieldType.DATE)
    ENZYMETYPE__FIELD_NAME: WrapperField = WrapperField("EnzymeType", FieldType.PICKLIST)
    EXPIRATIONDATE__FIELD_NAME: WrapperField = WrapperField("ExpirationDate", FieldType.DATE)
    ISOSCHIZOMERS__FIELD_NAME: WrapperField = WrapperField("Isoschizomers", FieldType.STRING)
    LOTNUMBER__FIELD_NAME: WrapperField = WrapperField("LotNumber", FieldType.STRING)
    NEOSCHIZOMERS__FIELD_NAME: WrapperField = WrapperField("Neoschizomers", FieldType.STRING)
    PARTNUMBER__FIELD_NAME: WrapperField = WrapperField("PartNumber", FieldType.STRING)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)
    VENDOR__FIELD_NAME: WrapperField = WrapperField("Vendor", FieldType.SELECTION)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_ConsumableName_field(self, value: Optional[str]):
        """
        Set data field with field name 'ConsumableName' on this record model
        """
        self.set_field_value(self.CONSUMABLENAME__FIELD_NAME.field_name, value)

    def get_ConsumableName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ConsumableName' from this record model
        """
        return self.get_field_value(self.CONSUMABLENAME__FIELD_NAME.field_name)

    def set_ConsumableType_field(self, value: Optional[str]):
        """
        Set data field with field name 'ConsumableType' on this record model
        """
        self.set_field_value(self.CONSUMABLETYPE__FIELD_NAME.field_name, value)

    def get_ConsumableType_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ConsumableType' from this record model
        """
        return self.get_field_value(self.CONSUMABLETYPE__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def set_CuttingPattern_field(self, value: Optional[str]):
        """
        Set data field with field name 'CuttingPattern' on this record model
        """
        self.set_field_value(self.CUTTINGPATTERN__FIELD_NAME.field_name, value)

    def get_CuttingPattern_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CuttingPattern' from this record model
        """
        return self.get_field_value(self.CUTTINGPATTERN__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_DateOfPurchase_field(self, value: Optional[int]):
        """
        Set data field with field name 'DateOfPurchase' on this record model
        """
        self.set_field_value(self.DATEOFPURCHASE__FIELD_NAME.field_name, value)

    def get_DateOfPurchase_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateOfPurchase' from this record model
        """
        return self.get_field_value(self.DATEOFPURCHASE__FIELD_NAME.field_name)

    def set_EnzymeType_field(self, value: Optional[str]):
        """
        Set data field with field name 'EnzymeType' on this record model
        """
        self.set_field_value(self.ENZYMETYPE__FIELD_NAME.field_name, value)

    def get_EnzymeType_field(self) -> Optional[str]:
        """
        Get data field value with field name 'EnzymeType' from this record model
        """
        return self.get_field_value(self.ENZYMETYPE__FIELD_NAME.field_name)

    def set_ExpirationDate_field(self, value: Optional[int]):
        """
        Set data field with field name 'ExpirationDate' on this record model
        """
        self.set_field_value(self.EXPIRATIONDATE__FIELD_NAME.field_name, value)

    def get_ExpirationDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'ExpirationDate' from this record model
        """
        return self.get_field_value(self.EXPIRATIONDATE__FIELD_NAME.field_name)

    def set_Isoschizomers_field(self, value: Optional[str]):
        """
        Set data field with field name 'Isoschizomers' on this record model
        """
        self.set_field_value(self.ISOSCHIZOMERS__FIELD_NAME.field_name, value)

    def get_Isoschizomers_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Isoschizomers' from this record model
        """
        return self.get_field_value(self.ISOSCHIZOMERS__FIELD_NAME.field_name)

    def set_LotNumber_field(self, value: Optional[str]):
        """
        Set data field with field name 'LotNumber' on this record model
        """
        self.set_field_value(self.LOTNUMBER__FIELD_NAME.field_name, value)

    def get_LotNumber_field(self) -> Optional[str]:
        """
        Get data field value with field name 'LotNumber' from this record model
        """
        return self.get_field_value(self.LOTNUMBER__FIELD_NAME.field_name)

    def set_Neoschizomers_field(self, value: Optional[str]):
        """
        Set data field with field name 'Neoschizomers' on this record model
        """
        self.set_field_value(self.NEOSCHIZOMERS__FIELD_NAME.field_name, value)

    def get_Neoschizomers_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Neoschizomers' from this record model
        """
        return self.get_field_value(self.NEOSCHIZOMERS__FIELD_NAME.field_name)

    def set_PartNumber_field(self, value: Optional[str]):
        """
        Set data field with field name 'PartNumber' on this record model
        """
        self.set_field_value(self.PARTNUMBER__FIELD_NAME.field_name, value)

    def get_PartNumber_field(self) -> Optional[str]:
        """
        Get data field value with field name 'PartNumber' from this record model
        """
        return self.get_field_value(self.PARTNUMBER__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)

    def set_Vendor_field(self, value: Optional[str]):
        """
        Set data field with field name 'Vendor' on this record model
        """
        self.set_field_value(self.VENDOR__FIELD_NAME.field_name, value)

    def get_Vendor_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Vendor' from this record model
        """
        return self.get_field_value(self.VENDOR__FIELD_NAME.field_name)


class EnzymePartModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type EnzymePart
    Data Type Display Name: Enzyme Part (Enzyme Parts)
    Fields: ConsumableName, ConsumableType, CreatedBy, DataRecordName, DateCreated, EnzymeType, IsDefault, IsGoldenGate, Isoschizomers, Neoschizomers, PartNumber, QuantityOnHand, QuantityPerItem, ReactionBuffer, RecognitionSequence, ReorderLevelQuantity, Units, VeloxLastModifiedBy, VeloxLastModifiedDate, Vendor
    """
    DATA_TYPE_NAME: str = 'EnzymePart'
    CONSUMABLENAME__FIELD_NAME: WrapperField = WrapperField("ConsumableName", FieldType.AUTO_ACCESSION)
    CONSUMABLETYPE__FIELD_NAME: WrapperField = WrapperField("ConsumableType", FieldType.SELECTION)
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    ENZYMETYPE__FIELD_NAME: WrapperField = WrapperField("EnzymeType", FieldType.PICKLIST)
    ISDEFAULT__FIELD_NAME: WrapperField = WrapperField("IsDefault", FieldType.BOOLEAN)
    ISGOLDENGATE__FIELD_NAME: WrapperField = WrapperField("IsGoldenGate", FieldType.BOOLEAN)
    ISOSCHIZOMERS__FIELD_NAME: WrapperField = WrapperField("Isoschizomers", FieldType.STRING)
    NEOSCHIZOMERS__FIELD_NAME: WrapperField = WrapperField("Neoschizomers", FieldType.STRING)
    PARTNUMBER__FIELD_NAME: WrapperField = WrapperField("PartNumber", FieldType.STRING)
    QUANTITYONHAND__FIELD_NAME: WrapperField = WrapperField("QuantityOnHand", FieldType.DOUBLE)
    QUANTITYPERITEM__FIELD_NAME: WrapperField = WrapperField("QuantityPerItem", FieldType.DOUBLE)
    REACTIONBUFFER__FIELD_NAME: WrapperField = WrapperField("ReactionBuffer", FieldType.STRING)
    RECOGNITIONSEQUENCE__FIELD_NAME: WrapperField = WrapperField("RecognitionSequence", FieldType.STRING)
    REORDERLEVELQUANTITY__FIELD_NAME: WrapperField = WrapperField("ReorderLevelQuantity", FieldType.DOUBLE)
    UNITS__FIELD_NAME: WrapperField = WrapperField("Units", FieldType.PICKLIST)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)
    VENDOR__FIELD_NAME: WrapperField = WrapperField("Vendor", FieldType.SELECTION)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_ConsumableName_field(self, value: Optional[str]):
        """
        Set data field with field name 'ConsumableName' on this record model
        """
        self.set_field_value(self.CONSUMABLENAME__FIELD_NAME.field_name, value)

    def get_ConsumableName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ConsumableName' from this record model
        """
        return self.get_field_value(self.CONSUMABLENAME__FIELD_NAME.field_name)

    def set_ConsumableType_field(self, value: Optional[str]):
        """
        Set data field with field name 'ConsumableType' on this record model
        """
        self.set_field_value(self.CONSUMABLETYPE__FIELD_NAME.field_name, value)

    def get_ConsumableType_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ConsumableType' from this record model
        """
        return self.get_field_value(self.CONSUMABLETYPE__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_EnzymeType_field(self, value: Optional[str]):
        """
        Set data field with field name 'EnzymeType' on this record model
        """
        self.set_field_value(self.ENZYMETYPE__FIELD_NAME.field_name, value)

    def get_EnzymeType_field(self) -> Optional[str]:
        """
        Get data field value with field name 'EnzymeType' from this record model
        """
        return self.get_field_value(self.ENZYMETYPE__FIELD_NAME.field_name)

    def set_IsDefault_field(self, value: Optional[bool]):
        """
        Set data field with field name 'IsDefault' on this record model
        """
        self.set_field_value(self.ISDEFAULT__FIELD_NAME.field_name, value)

    def get_IsDefault_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'IsDefault' from this record model
        """
        return self.get_field_value(self.ISDEFAULT__FIELD_NAME.field_name)

    def set_IsGoldenGate_field(self, value: Optional[bool]):
        """
        Set data field with field name 'IsGoldenGate' on this record model
        """
        self.set_field_value(self.ISGOLDENGATE__FIELD_NAME.field_name, value)

    def get_IsGoldenGate_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'IsGoldenGate' from this record model
        """
        return self.get_field_value(self.ISGOLDENGATE__FIELD_NAME.field_name)

    def set_Isoschizomers_field(self, value: Optional[str]):
        """
        Set data field with field name 'Isoschizomers' on this record model
        """
        self.set_field_value(self.ISOSCHIZOMERS__FIELD_NAME.field_name, value)

    def get_Isoschizomers_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Isoschizomers' from this record model
        """
        return self.get_field_value(self.ISOSCHIZOMERS__FIELD_NAME.field_name)

    def set_Neoschizomers_field(self, value: Optional[str]):
        """
        Set data field with field name 'Neoschizomers' on this record model
        """
        self.set_field_value(self.NEOSCHIZOMERS__FIELD_NAME.field_name, value)

    def get_Neoschizomers_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Neoschizomers' from this record model
        """
        return self.get_field_value(self.NEOSCHIZOMERS__FIELD_NAME.field_name)

    def set_PartNumber_field(self, value: Optional[str]):
        """
        Set data field with field name 'PartNumber' on this record model
        """
        self.set_field_value(self.PARTNUMBER__FIELD_NAME.field_name, value)

    def get_PartNumber_field(self) -> Optional[str]:
        """
        Get data field value with field name 'PartNumber' from this record model
        """
        return self.get_field_value(self.PARTNUMBER__FIELD_NAME.field_name)

    def set_QuantityOnHand_field(self, value: Optional[float]):
        """
        Set data field with field name 'QuantityOnHand' on this record model
        """
        self.set_field_value(self.QUANTITYONHAND__FIELD_NAME.field_name, value)

    def get_QuantityOnHand_field(self) -> Optional[float]:
        """
        Get data field value with field name 'QuantityOnHand' from this record model
        """
        return self.get_field_value(self.QUANTITYONHAND__FIELD_NAME.field_name)

    def set_QuantityPerItem_field(self, value: Optional[float]):
        """
        Set data field with field name 'QuantityPerItem' on this record model
        """
        self.set_field_value(self.QUANTITYPERITEM__FIELD_NAME.field_name, value)

    def get_QuantityPerItem_field(self) -> Optional[float]:
        """
        Get data field value with field name 'QuantityPerItem' from this record model
        """
        return self.get_field_value(self.QUANTITYPERITEM__FIELD_NAME.field_name)

    def set_ReactionBuffer_field(self, value: Optional[str]):
        """
        Set data field with field name 'ReactionBuffer' on this record model
        """
        self.set_field_value(self.REACTIONBUFFER__FIELD_NAME.field_name, value)

    def get_ReactionBuffer_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ReactionBuffer' from this record model
        """
        return self.get_field_value(self.REACTIONBUFFER__FIELD_NAME.field_name)

    def set_RecognitionSequence_field(self, value: Optional[str]):
        """
        Set data field with field name 'RecognitionSequence' on this record model
        """
        self.set_field_value(self.RECOGNITIONSEQUENCE__FIELD_NAME.field_name, value)

    def get_RecognitionSequence_field(self) -> Optional[str]:
        """
        Get data field value with field name 'RecognitionSequence' from this record model
        """
        return self.get_field_value(self.RECOGNITIONSEQUENCE__FIELD_NAME.field_name)

    def set_ReorderLevelQuantity_field(self, value: Optional[float]):
        """
        Set data field with field name 'ReorderLevelQuantity' on this record model
        """
        self.set_field_value(self.REORDERLEVELQUANTITY__FIELD_NAME.field_name, value)

    def get_ReorderLevelQuantity_field(self) -> Optional[float]:
        """
        Get data field value with field name 'ReorderLevelQuantity' from this record model
        """
        return self.get_field_value(self.REORDERLEVELQUANTITY__FIELD_NAME.field_name)

    def set_Units_field(self, value: Optional[str]):
        """
        Set data field with field name 'Units' on this record model
        """
        self.set_field_value(self.UNITS__FIELD_NAME.field_name, value)

    def get_Units_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Units' from this record model
        """
        return self.get_field_value(self.UNITS__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)

    def set_Vendor_field(self, value: Optional[str]):
        """
        Set data field with field name 'Vendor' on this record model
        """
        self.set_field_value(self.VENDOR__FIELD_NAME.field_name, value)

    def get_Vendor_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Vendor' from this record model
        """
        return self.get_field_value(self.VENDOR__FIELD_NAME.field_name)


class ErrorMetricModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type ErrorMetric
    Data Type Display Name: Error Metric (Error Metrics)
    Fields: ColRead, CreatedBy, DataRecordName, DateCreated, ErrorRate, Lane, LaneCol, PlusMinus, VeloxLastModifiedBy, VeloxLastModifiedDate
     <!-- DISPLAY IN INSTRUMENT RUN MONITOR -->
    """
    DATA_TYPE_NAME: str = 'ErrorMetric'
    COLREAD__FIELD_NAME: WrapperField = WrapperField("ColRead", FieldType.STRING)
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    ERRORRATE__FIELD_NAME: WrapperField = WrapperField("ErrorRate", FieldType.DOUBLE)
    LANE__FIELD_NAME: WrapperField = WrapperField("Lane", FieldType.LONG)
    LANECOL__FIELD_NAME: WrapperField = WrapperField("LaneCol", FieldType.STRING)
    PLUSMINUS__FIELD_NAME: WrapperField = WrapperField("PlusMinus", FieldType.DOUBLE)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_ColRead_field(self, value: Optional[str]):
        """
        Set data field with field name 'ColRead' on this record model
        """
        self.set_field_value(self.COLREAD__FIELD_NAME.field_name, value)

    def get_ColRead_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ColRead' from this record model
        """
        return self.get_field_value(self.COLREAD__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_ErrorRate_field(self, value: Optional[float]):
        """
        Set data field with field name 'ErrorRate' on this record model
        """
        self.set_field_value(self.ERRORRATE__FIELD_NAME.field_name, value)

    def get_ErrorRate_field(self) -> Optional[float]:
        """
        Get data field value with field name 'ErrorRate' from this record model
        """
        return self.get_field_value(self.ERRORRATE__FIELD_NAME.field_name)

    def set_Lane_field(self, value: Optional[int]):
        """
        Set data field with field name 'Lane' on this record model
        """
        self.set_field_value(self.LANE__FIELD_NAME.field_name, value)

    def get_Lane_field(self) -> Optional[int]:
        """
        Get data field value with field name 'Lane' from this record model
        """
        return self.get_field_value(self.LANE__FIELD_NAME.field_name)

    def set_LaneCol_field(self, value: Optional[str]):
        """
        Set data field with field name 'LaneCol' on this record model
        """
        self.set_field_value(self.LANECOL__FIELD_NAME.field_name, value)

    def get_LaneCol_field(self) -> Optional[str]:
        """
        Get data field value with field name 'LaneCol' from this record model
        """
        return self.get_field_value(self.LANECOL__FIELD_NAME.field_name)

    def set_PlusMinus_field(self, value: Optional[float]):
        """
        Set data field with field name 'PlusMinus' on this record model
        """
        self.set_field_value(self.PLUSMINUS__FIELD_NAME.field_name, value)

    def get_PlusMinus_field(self) -> Optional[float]:
        """
        Get data field value with field name 'PlusMinus' from this record model
        """
        return self.get_field_value(self.PLUSMINUS__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class EventModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type Event
    Data Type Display Name: Event (Event)
    Fields: Comments, CreatedBy, DataRecordName, DateCreated, EndDateTime, EventDescription, EventName, EventStatus, ReminderDateTime, ReminderSent, StartDateTime, UserName, VeloxLastModifiedBy, VeloxLastModifiedDate
    """
    DATA_TYPE_NAME: str = 'Event'
    COMMENTS__FIELD_NAME: WrapperField = WrapperField("Comments", FieldType.STRING)
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    ENDDATETIME__FIELD_NAME: WrapperField = WrapperField("EndDateTime", FieldType.DATE)
    EVENTDESCRIPTION__FIELD_NAME: WrapperField = WrapperField("EventDescription", FieldType.STRING)
    EVENTNAME__FIELD_NAME: WrapperField = WrapperField("EventName", FieldType.STRING)
    EVENTSTATUS__FIELD_NAME: WrapperField = WrapperField("EventStatus", FieldType.PICKLIST)
    REMINDERDATETIME__FIELD_NAME: WrapperField = WrapperField("ReminderDateTime", FieldType.DATE)
    REMINDERSENT__FIELD_NAME: WrapperField = WrapperField("ReminderSent", FieldType.BOOLEAN)
    STARTDATETIME__FIELD_NAME: WrapperField = WrapperField("StartDateTime", FieldType.DATE)
    USERNAME__FIELD_NAME: WrapperField = WrapperField("UserName", FieldType.SELECTION)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_Comments_field(self, value: Optional[str]):
        """
        Set data field with field name 'Comments' on this record model
        """
        self.set_field_value(self.COMMENTS__FIELD_NAME.field_name, value)

    def get_Comments_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Comments' from this record model
        """
        return self.get_field_value(self.COMMENTS__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_EndDateTime_field(self, value: Optional[int]):
        """
        Set data field with field name 'EndDateTime' on this record model
        """
        self.set_field_value(self.ENDDATETIME__FIELD_NAME.field_name, value)

    def get_EndDateTime_field(self) -> Optional[int]:
        """
        Get data field value with field name 'EndDateTime' from this record model
        """
        return self.get_field_value(self.ENDDATETIME__FIELD_NAME.field_name)

    def set_EventDescription_field(self, value: Optional[str]):
        """
        Set data field with field name 'EventDescription' on this record model
        """
        self.set_field_value(self.EVENTDESCRIPTION__FIELD_NAME.field_name, value)

    def get_EventDescription_field(self) -> Optional[str]:
        """
        Get data field value with field name 'EventDescription' from this record model
        """
        return self.get_field_value(self.EVENTDESCRIPTION__FIELD_NAME.field_name)

    def set_EventName_field(self, value: Optional[str]):
        """
        Set data field with field name 'EventName' on this record model
        """
        self.set_field_value(self.EVENTNAME__FIELD_NAME.field_name, value)

    def get_EventName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'EventName' from this record model
        """
        return self.get_field_value(self.EVENTNAME__FIELD_NAME.field_name)

    def set_EventStatus_field(self, value: Optional[str]):
        """
        Set data field with field name 'EventStatus' on this record model
        """
        self.set_field_value(self.EVENTSTATUS__FIELD_NAME.field_name, value)

    def get_EventStatus_field(self) -> Optional[str]:
        """
        Get data field value with field name 'EventStatus' from this record model
        """
        return self.get_field_value(self.EVENTSTATUS__FIELD_NAME.field_name)

    def set_ReminderDateTime_field(self, value: Optional[int]):
        """
        Set data field with field name 'ReminderDateTime' on this record model
        """
        self.set_field_value(self.REMINDERDATETIME__FIELD_NAME.field_name, value)

    def get_ReminderDateTime_field(self) -> Optional[int]:
        """
        Get data field value with field name 'ReminderDateTime' from this record model
        """
        return self.get_field_value(self.REMINDERDATETIME__FIELD_NAME.field_name)

    def set_ReminderSent_field(self, value: Optional[bool]):
        """
        Set data field with field name 'ReminderSent' on this record model
        """
        self.set_field_value(self.REMINDERSENT__FIELD_NAME.field_name, value)

    def get_ReminderSent_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'ReminderSent' from this record model
        """
        return self.get_field_value(self.REMINDERSENT__FIELD_NAME.field_name)

    def set_StartDateTime_field(self, value: Optional[int]):
        """
        Set data field with field name 'StartDateTime' on this record model
        """
        self.set_field_value(self.STARTDATETIME__FIELD_NAME.field_name, value)

    def get_StartDateTime_field(self) -> Optional[int]:
        """
        Get data field value with field name 'StartDateTime' from this record model
        """
        return self.get_field_value(self.STARTDATETIME__FIELD_NAME.field_name)

    def set_UserName_field(self, value: Optional[str]):
        """
        Set data field with field name 'UserName' on this record model
        """
        self.set_field_value(self.USERNAME__FIELD_NAME.field_name, value)

    def get_UserName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'UserName' from this record model
        """
        return self.get_field_value(self.USERNAME__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class ExemplarConfigModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type ExemplarConfig
    Data Type Display Name: Sapio Configurations (Sapio Configurations)
    Fields: ActiveNotebooksInWorkQueue, AddAllUserAsCandidate, AddAllUserAsCandidateHelp, AddConsumablesToExperiments, AdditionalInstMaintEmails, AdditionalNotificationEmails, AdditionalQCMailingList, AdHocExperimentsInheritAccess, AlwaysLaunchInstMaintWorkflow, ApproverVisibleRoleType, AssignRoleNotificationButton, AssignToProcessUserGroupList, AuthenticationRequired, Bowtie2ExecPath, Bowtie2GRChIndexPrefix, BowtieGrCh38RefIndexPrefix, BowtieIndexDirectory, BroadcastMaintAlert, BroadcastMaintUsers, CanModifyExistingVSMTPItems, ConfigureInstrumentFileField, ConsumableDataTypes, ConsumableDirectories, ConsumableTrackingAttribute, ConsumableTypeMaxTemp, CoolingStorageUnitTypes, CreatedBy, CreateInWorkflow, DataRecordName, DateCreated, DefaultELNExperimentGroupRoles, DefaultELNExperimentRoles, DefaultELNExperimentRolesHelp, DefineConsumableDataTypes, DefineConsumableDirectories, Delimiter, ELNCreateSmplExtentionMultiSel, ELNImportSamplesOverride, Email, EnableAutoLotPopulation, EnableBaselineSampleRec, EnableDND, EnableElnRoleCandidates, EnableMultiTenantDashboards, EnforceConsumableDirectory, EnforceExpiration, EnforceSufficientQuantity, ENotebookSignoffGroups, ENotebookSignoffGroupsHelp, EnumerateStorage, EsignEmailOwnerNotebookUnlock, EsignSendEmailOnDecision, EsignSendEmailOnEntryUnlock, EsignSendEmailOnNotebookUnlock, EsigRequireAllAuthor, EsigRequireAllAuthorHelp, ExperimentBannerExpFields, ExperimentBannerParentFields, ExportExemplarConfigButton, ExportFullConfigButton, ExportSelectedConfigButton, ExportStaticConfigurations, GenerateItemBarcode, GRChFASTAPath, ImportBackupConfigButton, ImportBaseLineDescription, ImportExemplarConfigButton, ImportExportExemplarConfigText, ImportExportSystemConfigsText, ImportSystemConfigButton, IndexedStorageType, InstrumentForceIdvRegistration, MatManEnableFeatureExt, MmForceIdvRegistration, MmSampleFieldsToDisplay, MultiLayerPlatePoolIfSameType, NativePyExecPath, NativeRExecPath, NewConsumableDirName, NotificationUsers, NotifyMaintTechnicians, OverrideGroups, PlasmidDataType, PlateDesignerPrimaryTypes, Port, PreNotificationInterval, PrintConsumableBarcode, QCMailingList, QuantityTracking, RecordReportAccessGroups, RecordReportDataTypeList, RecordStorageEvents, ReqPortalManifestFieldNames, RequireESignature, RestrictAccessByLocation, ReviewerVisibleRoleType, RTransExecPath, S3AccessKeyId, S3SecretAcessKey, SaasMaxNumOfSamplesPerTrans, SaasMaxSamples, SaasMode, SampleReceivingEmails, SampleReceivingUserMenu, SampleTypeMaximumTemperature, SamtoolsExecPath, SDMSRootPath, SecureSocketLayer, SendTestMail, SMTPServer, SmtpUsername, StorageUnitViewerFillByConfig, SystemPassword, TemperatureEnforcement, TLSEnabled, TLSRequired, UseRequestDefaultLayout, VeloxLastModifiedBy, VeloxLastModifiedDate, VerificationTypes, WitnessVisibleRoleType, WriteQCInputFileToUser
    """
    DATA_TYPE_NAME: str = 'ExemplarConfig'
    ACTIVENOTEBOOKSINWORKQUEUE__FIELD_NAME: WrapperField = WrapperField("ActiveNotebooksInWorkQueue", FieldType.BOOLEAN)
    ADDALLUSERASCANDIDATE__FIELD_NAME: WrapperField = WrapperField("AddAllUserAsCandidate", FieldType.BOOLEAN)
    ADDALLUSERASCANDIDATEHELP__FIELD_NAME: WrapperField = WrapperField("AddAllUserAsCandidateHelp", FieldType.STRING)
    ADDCONSUMABLESTOEXPERIMENTS__FIELD_NAME: WrapperField = WrapperField("AddConsumablesToExperiments", FieldType.BOOLEAN)
    ADDITIONALINSTMAINTEMAILS__FIELD_NAME: WrapperField = WrapperField("AdditionalInstMaintEmails", FieldType.STRING)
    ADDITIONALNOTIFICATIONEMAILS__FIELD_NAME: WrapperField = WrapperField("AdditionalNotificationEmails", FieldType.STRING)
    ADDITIONALQCMAILINGLIST__FIELD_NAME: WrapperField = WrapperField("AdditionalQCMailingList", FieldType.STRING)
    ADHOCEXPERIMENTSINHERITACCESS__FIELD_NAME: WrapperField = WrapperField("AdHocExperimentsInheritAccess", FieldType.BOOLEAN)
    ALWAYSLAUNCHINSTMAINTWORKFLOW__FIELD_NAME: WrapperField = WrapperField("AlwaysLaunchInstMaintWorkflow", FieldType.BOOLEAN)
    APPROVERVISIBLEROLETYPE__FIELD_NAME: WrapperField = WrapperField("ApproverVisibleRoleType", FieldType.BOOLEAN)
    ASSIGNROLENOTIFICATIONBUTTON__FIELD_NAME: WrapperField = WrapperField("AssignRoleNotificationButton", FieldType.ACTION)
    ASSIGNTOPROCESSUSERGROUPLIST__FIELD_NAME: WrapperField = WrapperField("AssignToProcessUserGroupList", FieldType.SELECTION)
    AUTHENTICATIONREQUIRED__FIELD_NAME: WrapperField = WrapperField("AuthenticationRequired", FieldType.BOOLEAN)
    BOWTIE2EXECPATH__FIELD_NAME: WrapperField = WrapperField("Bowtie2ExecPath", FieldType.STRING)
    BOWTIE2GRCHINDEXPREFIX__FIELD_NAME: WrapperField = WrapperField("Bowtie2GRChIndexPrefix", FieldType.STRING)
    BOWTIEGRCH38REFINDEXPREFIX__FIELD_NAME: WrapperField = WrapperField("BowtieGrCh38RefIndexPrefix", FieldType.STRING)
    BOWTIEINDEXDIRECTORY__FIELD_NAME: WrapperField = WrapperField("BowtieIndexDirectory", FieldType.STRING)
    BROADCASTMAINTALERT__FIELD_NAME: WrapperField = WrapperField("BroadcastMaintAlert", FieldType.BOOLEAN)
    BROADCASTMAINTUSERS__FIELD_NAME: WrapperField = WrapperField("BroadcastMaintUsers", FieldType.SELECTION)
    CANMODIFYEXISTINGVSMTPITEMS__FIELD_NAME: WrapperField = WrapperField("CanModifyExistingVSMTPItems", FieldType.BOOLEAN)
    CONFIGUREINSTRUMENTFILEFIELD__FIELD_NAME: WrapperField = WrapperField("ConfigureInstrumentFileField", FieldType.ACTION)
    CONSUMABLEDATATYPES__FIELD_NAME: WrapperField = WrapperField("ConsumableDataTypes", FieldType.STRING)
    CONSUMABLEDIRECTORIES__FIELD_NAME: WrapperField = WrapperField("ConsumableDirectories", FieldType.STRING)
    CONSUMABLETRACKINGATTRIBUTE__FIELD_NAME: WrapperField = WrapperField("ConsumableTrackingAttribute", FieldType.PICKLIST)
    CONSUMABLETYPEMAXTEMP__FIELD_NAME: WrapperField = WrapperField("ConsumableTypeMaxTemp", FieldType.STRING)
    COOLINGSTORAGEUNITTYPES__FIELD_NAME: WrapperField = WrapperField("CoolingStorageUnitTypes", FieldType.SELECTION)
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    CREATEINWORKFLOW__FIELD_NAME: WrapperField = WrapperField("CreateInWorkflow", FieldType.BOOLEAN)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    DEFAULTELNEXPERIMENTGROUPROLES__FIELD_NAME: WrapperField = WrapperField("DefaultELNExperimentGroupRoles", FieldType.SELECTION)
    DEFAULTELNEXPERIMENTROLES__FIELD_NAME: WrapperField = WrapperField("DefaultELNExperimentRoles", FieldType.SELECTION)
    DEFAULTELNEXPERIMENTROLESHELP__FIELD_NAME: WrapperField = WrapperField("DefaultELNExperimentRolesHelp", FieldType.STRING)
    DEFINECONSUMABLEDATATYPES__FIELD_NAME: WrapperField = WrapperField("DefineConsumableDataTypes", FieldType.ACTION)
    DEFINECONSUMABLEDIRECTORIES__FIELD_NAME: WrapperField = WrapperField("DefineConsumableDirectories", FieldType.ACTION)
    DELIMITER__FIELD_NAME: WrapperField = WrapperField("Delimiter", FieldType.STRING)
    ELNCREATESMPLEXTENTIONMULTISEL__FIELD_NAME: WrapperField = WrapperField("ELNCreateSmplExtentionMultiSel", FieldType.BOOLEAN)
    ELNIMPORTSAMPLESOVERRIDE__FIELD_NAME: WrapperField = WrapperField("ELNImportSamplesOverride", FieldType.STRING)
    EMAIL__FIELD_NAME: WrapperField = WrapperField("Email", FieldType.STRING)
    ENABLEAUTOLOTPOPULATION__FIELD_NAME: WrapperField = WrapperField("EnableAutoLotPopulation", FieldType.BOOLEAN)
    ENABLEBASELINESAMPLEREC__FIELD_NAME: WrapperField = WrapperField("EnableBaselineSampleRec", FieldType.BOOLEAN)
    ENABLEDND__FIELD_NAME: WrapperField = WrapperField("EnableDND", FieldType.BOOLEAN)
    ENABLEELNROLECANDIDATES__FIELD_NAME: WrapperField = WrapperField("EnableElnRoleCandidates", FieldType.BOOLEAN)
    ENABLEMULTITENANTDASHBOARDS__FIELD_NAME: WrapperField = WrapperField("EnableMultiTenantDashboards", FieldType.BOOLEAN)
    ENFORCECONSUMABLEDIRECTORY__FIELD_NAME: WrapperField = WrapperField("EnforceConsumableDirectory", FieldType.BOOLEAN)
    ENFORCEEXPIRATION__FIELD_NAME: WrapperField = WrapperField("EnforceExpiration", FieldType.BOOLEAN)
    ENFORCESUFFICIENTQUANTITY__FIELD_NAME: WrapperField = WrapperField("EnforceSufficientQuantity", FieldType.BOOLEAN)
    ENOTEBOOKSIGNOFFGROUPS__FIELD_NAME: WrapperField = WrapperField("ENotebookSignoffGroups", FieldType.SELECTION)
    ENOTEBOOKSIGNOFFGROUPSHELP__FIELD_NAME: WrapperField = WrapperField("ENotebookSignoffGroupsHelp", FieldType.STRING)
    ENUMERATESTORAGE__FIELD_NAME: WrapperField = WrapperField("EnumerateStorage", FieldType.BOOLEAN)
    ESIGNEMAILOWNERNOTEBOOKUNLOCK__FIELD_NAME: WrapperField = WrapperField("EsignEmailOwnerNotebookUnlock", FieldType.BOOLEAN)
    ESIGNSENDEMAILONDECISION__FIELD_NAME: WrapperField = WrapperField("EsignSendEmailOnDecision", FieldType.BOOLEAN)
    ESIGNSENDEMAILONENTRYUNLOCK__FIELD_NAME: WrapperField = WrapperField("EsignSendEmailOnEntryUnlock", FieldType.BOOLEAN)
    ESIGNSENDEMAILONNOTEBOOKUNLOCK__FIELD_NAME: WrapperField = WrapperField("EsignSendEmailOnNotebookUnlock", FieldType.BOOLEAN)
    ESIGREQUIREALLAUTHOR__FIELD_NAME: WrapperField = WrapperField("EsigRequireAllAuthor", FieldType.BOOLEAN)
    ESIGREQUIREALLAUTHORHELP__FIELD_NAME: WrapperField = WrapperField("EsigRequireAllAuthorHelp", FieldType.STRING)
    EXPERIMENTBANNEREXPFIELDS__FIELD_NAME: WrapperField = WrapperField("ExperimentBannerExpFields", FieldType.SELECTION)
    EXPERIMENTBANNERPARENTFIELDS__FIELD_NAME: WrapperField = WrapperField("ExperimentBannerParentFields", FieldType.SELECTION)
    EXPORTEXEMPLARCONFIGBUTTON__FIELD_NAME: WrapperField = WrapperField("ExportExemplarConfigButton", FieldType.ACTION)
    EXPORTFULLCONFIGBUTTON__FIELD_NAME: WrapperField = WrapperField("ExportFullConfigButton", FieldType.ACTION)
    EXPORTSELECTEDCONFIGBUTTON__FIELD_NAME: WrapperField = WrapperField("ExportSelectedConfigButton", FieldType.ACTION)
    EXPORTSTATICCONFIGURATIONS__FIELD_NAME: WrapperField = WrapperField("ExportStaticConfigurations", FieldType.ACTION)
    GENERATEITEMBARCODE__FIELD_NAME: WrapperField = WrapperField("GenerateItemBarcode", FieldType.BOOLEAN)
    GRCHFASTAPATH__FIELD_NAME: WrapperField = WrapperField("GRChFASTAPath", FieldType.STRING)
    IMPORTBACKUPCONFIGBUTTON__FIELD_NAME: WrapperField = WrapperField("ImportBackupConfigButton", FieldType.ACTION)
    IMPORTBASELINEDESCRIPTION__FIELD_NAME: WrapperField = WrapperField("ImportBaseLineDescription", FieldType.STRING)
    IMPORTEXEMPLARCONFIGBUTTON__FIELD_NAME: WrapperField = WrapperField("ImportExemplarConfigButton", FieldType.ACTION)
    IMPORTEXPORTEXEMPLARCONFIGTEXT__FIELD_NAME: WrapperField = WrapperField("ImportExportExemplarConfigText", FieldType.STRING)
    IMPORTEXPORTSYSTEMCONFIGSTEXT__FIELD_NAME: WrapperField = WrapperField("ImportExportSystemConfigsText", FieldType.STRING)
    IMPORTSYSTEMCONFIGBUTTON__FIELD_NAME: WrapperField = WrapperField("ImportSystemConfigButton", FieldType.ACTION)
    INDEXEDSTORAGETYPE__FIELD_NAME: WrapperField = WrapperField("IndexedStorageType", FieldType.SELECTION)
    INSTRUMENTFORCEIDVREGISTRATION__FIELD_NAME: WrapperField = WrapperField("InstrumentForceIdvRegistration", FieldType.BOOLEAN)
    MATMANENABLEFEATUREEXT__FIELD_NAME: WrapperField = WrapperField("MatManEnableFeatureExt", FieldType.BOOLEAN)
    MMFORCEIDVREGISTRATION__FIELD_NAME: WrapperField = WrapperField("MmForceIdvRegistration", FieldType.BOOLEAN)
    MMSAMPLEFIELDSTODISPLAY__FIELD_NAME: WrapperField = WrapperField("MmSampleFieldsToDisplay", FieldType.SELECTION)
    MULTILAYERPLATEPOOLIFSAMETYPE__FIELD_NAME: WrapperField = WrapperField("MultiLayerPlatePoolIfSameType", FieldType.BOOLEAN)
    NATIVEPYEXECPATH__FIELD_NAME: WrapperField = WrapperField("NativePyExecPath", FieldType.STRING)
    NATIVEREXECPATH__FIELD_NAME: WrapperField = WrapperField("NativeRExecPath", FieldType.STRING)
    NEWCONSUMABLEDIRNAME__FIELD_NAME: WrapperField = WrapperField("NewConsumableDirName", FieldType.STRING)
    NOTIFICATIONUSERS__FIELD_NAME: WrapperField = WrapperField("NotificationUsers", FieldType.SELECTION)
    NOTIFYMAINTTECHNICIANS__FIELD_NAME: WrapperField = WrapperField("NotifyMaintTechnicians", FieldType.BOOLEAN)
    OVERRIDEGROUPS__FIELD_NAME: WrapperField = WrapperField("OverrideGroups", FieldType.SELECTION)
    PLASMIDDATATYPE__FIELD_NAME: WrapperField = WrapperField("PlasmidDataType", FieldType.SELECTION)
    PLATEDESIGNERPRIMARYTYPES__FIELD_NAME: WrapperField = WrapperField("PlateDesignerPrimaryTypes", FieldType.SELECTION)
    PORT__FIELD_NAME: WrapperField = WrapperField("Port", FieldType.INTEGER)
    PRENOTIFICATIONINTERVAL__FIELD_NAME: WrapperField = WrapperField("PreNotificationInterval", FieldType.LONG)
    PRINTCONSUMABLEBARCODE__FIELD_NAME: WrapperField = WrapperField("PrintConsumableBarcode", FieldType.BOOLEAN)
    QCMAILINGLIST__FIELD_NAME: WrapperField = WrapperField("QCMailingList", FieldType.SELECTION)
    QUANTITYTRACKING__FIELD_NAME: WrapperField = WrapperField("QuantityTracking", FieldType.BOOLEAN)
    RECORDREPORTACCESSGROUPS__FIELD_NAME: WrapperField = WrapperField("RecordReportAccessGroups", FieldType.SELECTION)
    RECORDREPORTDATATYPELIST__FIELD_NAME: WrapperField = WrapperField("RecordReportDataTypeList", FieldType.SELECTION)
    RECORDSTORAGEEVENTS__FIELD_NAME: WrapperField = WrapperField("RecordStorageEvents", FieldType.BOOLEAN)
    REQPORTALMANIFESTFIELDNAMES__FIELD_NAME: WrapperField = WrapperField("ReqPortalManifestFieldNames", FieldType.SELECTION)
    REQUIREESIGNATURE__FIELD_NAME: WrapperField = WrapperField("RequireESignature", FieldType.BOOLEAN)
    RESTRICTACCESSBYLOCATION__FIELD_NAME: WrapperField = WrapperField("RestrictAccessByLocation", FieldType.BOOLEAN)
    REVIEWERVISIBLEROLETYPE__FIELD_NAME: WrapperField = WrapperField("ReviewerVisibleRoleType", FieldType.BOOLEAN)
    RTRANSEXECPATH__FIELD_NAME: WrapperField = WrapperField("RTransExecPath", FieldType.STRING)
    S3ACCESSKEYID__FIELD_NAME: WrapperField = WrapperField("S3AccessKeyId", FieldType.STRING)
    S3SECRETACESSKEY__FIELD_NAME: WrapperField = WrapperField("S3SecretAcessKey", FieldType.STRING)
    SAASMAXNUMOFSAMPLESPERTRANS__FIELD_NAME: WrapperField = WrapperField("SaasMaxNumOfSamplesPerTrans", FieldType.LONG)
    SAASMAXSAMPLES__FIELD_NAME: WrapperField = WrapperField("SaasMaxSamples", FieldType.LONG)
    SAASMODE__FIELD_NAME: WrapperField = WrapperField("SaasMode", FieldType.BOOLEAN)
    SAMPLERECEIVINGEMAILS__FIELD_NAME: WrapperField = WrapperField("SampleReceivingEmails", FieldType.STRING)
    SAMPLERECEIVINGUSERMENU__FIELD_NAME: WrapperField = WrapperField("SampleReceivingUserMenu", FieldType.SELECTION)
    SAMPLETYPEMAXIMUMTEMPERATURE__FIELD_NAME: WrapperField = WrapperField("SampleTypeMaximumTemperature", FieldType.STRING)
    SAMTOOLSEXECPATH__FIELD_NAME: WrapperField = WrapperField("SamtoolsExecPath", FieldType.STRING)
    SDMSROOTPATH__FIELD_NAME: WrapperField = WrapperField("SDMSRootPath", FieldType.STRING)
    SECURESOCKETLAYER__FIELD_NAME: WrapperField = WrapperField("SecureSocketLayer", FieldType.BOOLEAN)
    SENDTESTMAIL__FIELD_NAME: WrapperField = WrapperField("SendTestMail", FieldType.ACTION)
    SMTPSERVER__FIELD_NAME: WrapperField = WrapperField("SMTPServer", FieldType.STRING)
    SMTPUSERNAME__FIELD_NAME: WrapperField = WrapperField("SmtpUsername", FieldType.STRING)
    STORAGEUNITVIEWERFILLBYCONFIG__FIELD_NAME: WrapperField = WrapperField("StorageUnitViewerFillByConfig", FieldType.PICKLIST)
    SYSTEMPASSWORD__FIELD_NAME: WrapperField = WrapperField("SystemPassword", FieldType.STRING)
    TEMPERATUREENFORCEMENT__FIELD_NAME: WrapperField = WrapperField("TemperatureEnforcement", FieldType.PICKLIST)
    TLSENABLED__FIELD_NAME: WrapperField = WrapperField("TLSEnabled", FieldType.BOOLEAN)
    TLSREQUIRED__FIELD_NAME: WrapperField = WrapperField("TLSRequired", FieldType.BOOLEAN)
    USEREQUESTDEFAULTLAYOUT__FIELD_NAME: WrapperField = WrapperField("UseRequestDefaultLayout", FieldType.BOOLEAN)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)
    VERIFICATIONTYPES__FIELD_NAME: WrapperField = WrapperField("VerificationTypes", FieldType.PICKLIST)
    WITNESSVISIBLEROLETYPE__FIELD_NAME: WrapperField = WrapperField("WitnessVisibleRoleType", FieldType.BOOLEAN)
    WRITEQCINPUTFILETOUSER__FIELD_NAME: WrapperField = WrapperField("WriteQCInputFileToUser", FieldType.BOOLEAN)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_ActiveNotebooksInWorkQueue_field(self, value: Optional[bool]):
        """
        Set data field with field name 'ActiveNotebooksInWorkQueue' on this record model
        """
        self.set_field_value(self.ACTIVENOTEBOOKSINWORKQUEUE__FIELD_NAME.field_name, value)

    def get_ActiveNotebooksInWorkQueue_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'ActiveNotebooksInWorkQueue' from this record model
        """
        return self.get_field_value(self.ACTIVENOTEBOOKSINWORKQUEUE__FIELD_NAME.field_name)

    def set_AddAllUserAsCandidate_field(self, value: Optional[bool]):
        """
        Set data field with field name 'AddAllUserAsCandidate' on this record model
        """
        self.set_field_value(self.ADDALLUSERASCANDIDATE__FIELD_NAME.field_name, value)

    def get_AddAllUserAsCandidate_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'AddAllUserAsCandidate' from this record model
        """
        return self.get_field_value(self.ADDALLUSERASCANDIDATE__FIELD_NAME.field_name)

    def set_AddAllUserAsCandidateHelp_field(self, value: Optional[str]):
        """
        Set data field with field name 'AddAllUserAsCandidateHelp' on this record model
        """
        self.set_field_value(self.ADDALLUSERASCANDIDATEHELP__FIELD_NAME.field_name, value)

    def get_AddAllUserAsCandidateHelp_field(self) -> Optional[str]:
        """
        Get data field value with field name 'AddAllUserAsCandidateHelp' from this record model
        """
        return self.get_field_value(self.ADDALLUSERASCANDIDATEHELP__FIELD_NAME.field_name)

    def set_AddConsumablesToExperiments_field(self, value: Optional[bool]):
        """
        Set data field with field name 'AddConsumablesToExperiments' on this record model
        """
        self.set_field_value(self.ADDCONSUMABLESTOEXPERIMENTS__FIELD_NAME.field_name, value)

    def get_AddConsumablesToExperiments_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'AddConsumablesToExperiments' from this record model
        """
        return self.get_field_value(self.ADDCONSUMABLESTOEXPERIMENTS__FIELD_NAME.field_name)

    def set_AdditionalInstMaintEmails_field(self, value: Optional[str]):
        """
        Set data field with field name 'AdditionalInstMaintEmails' on this record model
        """
        self.set_field_value(self.ADDITIONALINSTMAINTEMAILS__FIELD_NAME.field_name, value)

    def get_AdditionalInstMaintEmails_field(self) -> Optional[str]:
        """
        Get data field value with field name 'AdditionalInstMaintEmails' from this record model
        """
        return self.get_field_value(self.ADDITIONALINSTMAINTEMAILS__FIELD_NAME.field_name)

    def set_AdditionalNotificationEmails_field(self, value: Optional[str]):
        """
        Set data field with field name 'AdditionalNotificationEmails' on this record model
        """
        self.set_field_value(self.ADDITIONALNOTIFICATIONEMAILS__FIELD_NAME.field_name, value)

    def get_AdditionalNotificationEmails_field(self) -> Optional[str]:
        """
        Get data field value with field name 'AdditionalNotificationEmails' from this record model
        """
        return self.get_field_value(self.ADDITIONALNOTIFICATIONEMAILS__FIELD_NAME.field_name)

    def set_AdditionalQCMailingList_field(self, value: Optional[str]):
        """
        Set data field with field name 'AdditionalQCMailingList' on this record model
        """
        self.set_field_value(self.ADDITIONALQCMAILINGLIST__FIELD_NAME.field_name, value)

    def get_AdditionalQCMailingList_field(self) -> Optional[str]:
        """
        Get data field value with field name 'AdditionalQCMailingList' from this record model
        """
        return self.get_field_value(self.ADDITIONALQCMAILINGLIST__FIELD_NAME.field_name)

    def set_AdHocExperimentsInheritAccess_field(self, value: Optional[bool]):
        """
        Set data field with field name 'AdHocExperimentsInheritAccess' on this record model
        """
        self.set_field_value(self.ADHOCEXPERIMENTSINHERITACCESS__FIELD_NAME.field_name, value)

    def get_AdHocExperimentsInheritAccess_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'AdHocExperimentsInheritAccess' from this record model
        """
        return self.get_field_value(self.ADHOCEXPERIMENTSINHERITACCESS__FIELD_NAME.field_name)

    def set_AlwaysLaunchInstMaintWorkflow_field(self, value: Optional[bool]):
        """
        Set data field with field name 'AlwaysLaunchInstMaintWorkflow' on this record model
        """
        self.set_field_value(self.ALWAYSLAUNCHINSTMAINTWORKFLOW__FIELD_NAME.field_name, value)

    def get_AlwaysLaunchInstMaintWorkflow_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'AlwaysLaunchInstMaintWorkflow' from this record model
        """
        return self.get_field_value(self.ALWAYSLAUNCHINSTMAINTWORKFLOW__FIELD_NAME.field_name)

    def set_ApproverVisibleRoleType_field(self, value: Optional[bool]):
        """
        Set data field with field name 'ApproverVisibleRoleType' on this record model
        """
        self.set_field_value(self.APPROVERVISIBLEROLETYPE__FIELD_NAME.field_name, value)

    def get_ApproverVisibleRoleType_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'ApproverVisibleRoleType' from this record model
        """
        return self.get_field_value(self.APPROVERVISIBLEROLETYPE__FIELD_NAME.field_name)

    def set_AssignToProcessUserGroupList_field(self, value: Optional[str]):
        """
        Set data field with field name 'AssignToProcessUserGroupList' on this record model
        """
        self.set_field_value(self.ASSIGNTOPROCESSUSERGROUPLIST__FIELD_NAME.field_name, value)

    def get_AssignToProcessUserGroupList_field(self) -> Optional[str]:
        """
        Get data field value with field name 'AssignToProcessUserGroupList' from this record model
        """
        return self.get_field_value(self.ASSIGNTOPROCESSUSERGROUPLIST__FIELD_NAME.field_name)

    def set_AuthenticationRequired_field(self, value: Optional[bool]):
        """
        Set data field with field name 'AuthenticationRequired' on this record model
        """
        self.set_field_value(self.AUTHENTICATIONREQUIRED__FIELD_NAME.field_name, value)

    def get_AuthenticationRequired_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'AuthenticationRequired' from this record model
        """
        return self.get_field_value(self.AUTHENTICATIONREQUIRED__FIELD_NAME.field_name)

    def set_Bowtie2ExecPath_field(self, value: Optional[str]):
        """
        Set data field with field name 'Bowtie2ExecPath' on this record model
        """
        self.set_field_value(self.BOWTIE2EXECPATH__FIELD_NAME.field_name, value)

    def get_Bowtie2ExecPath_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Bowtie2ExecPath' from this record model
        """
        return self.get_field_value(self.BOWTIE2EXECPATH__FIELD_NAME.field_name)

    def set_Bowtie2GRChIndexPrefix_field(self, value: Optional[str]):
        """
        Set data field with field name 'Bowtie2GRChIndexPrefix' on this record model
        """
        self.set_field_value(self.BOWTIE2GRCHINDEXPREFIX__FIELD_NAME.field_name, value)

    def get_Bowtie2GRChIndexPrefix_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Bowtie2GRChIndexPrefix' from this record model
        """
        return self.get_field_value(self.BOWTIE2GRCHINDEXPREFIX__FIELD_NAME.field_name)

    def set_BowtieGrCh38RefIndexPrefix_field(self, value: Optional[str]):
        """
        Set data field with field name 'BowtieGrCh38RefIndexPrefix' on this record model
        """
        self.set_field_value(self.BOWTIEGRCH38REFINDEXPREFIX__FIELD_NAME.field_name, value)

    def get_BowtieGrCh38RefIndexPrefix_field(self) -> Optional[str]:
        """
        Get data field value with field name 'BowtieGrCh38RefIndexPrefix' from this record model
        """
        return self.get_field_value(self.BOWTIEGRCH38REFINDEXPREFIX__FIELD_NAME.field_name)

    def set_BowtieIndexDirectory_field(self, value: Optional[str]):
        """
        Set data field with field name 'BowtieIndexDirectory' on this record model
        """
        self.set_field_value(self.BOWTIEINDEXDIRECTORY__FIELD_NAME.field_name, value)

    def get_BowtieIndexDirectory_field(self) -> Optional[str]:
        """
        Get data field value with field name 'BowtieIndexDirectory' from this record model
        """
        return self.get_field_value(self.BOWTIEINDEXDIRECTORY__FIELD_NAME.field_name)

    def set_BroadcastMaintAlert_field(self, value: Optional[bool]):
        """
        Set data field with field name 'BroadcastMaintAlert' on this record model
        """
        self.set_field_value(self.BROADCASTMAINTALERT__FIELD_NAME.field_name, value)

    def get_BroadcastMaintAlert_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'BroadcastMaintAlert' from this record model
        """
        return self.get_field_value(self.BROADCASTMAINTALERT__FIELD_NAME.field_name)

    def set_BroadcastMaintUsers_field(self, value: Optional[str]):
        """
        Set data field with field name 'BroadcastMaintUsers' on this record model
        """
        self.set_field_value(self.BROADCASTMAINTUSERS__FIELD_NAME.field_name, value)

    def get_BroadcastMaintUsers_field(self) -> Optional[str]:
        """
        Get data field value with field name 'BroadcastMaintUsers' from this record model
        """
        return self.get_field_value(self.BROADCASTMAINTUSERS__FIELD_NAME.field_name)

    def set_CanModifyExistingVSMTPItems_field(self, value: Optional[bool]):
        """
        Set data field with field name 'CanModifyExistingVSMTPItems' on this record model
        """
        self.set_field_value(self.CANMODIFYEXISTINGVSMTPITEMS__FIELD_NAME.field_name, value)

    def get_CanModifyExistingVSMTPItems_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'CanModifyExistingVSMTPItems' from this record model
        """
        return self.get_field_value(self.CANMODIFYEXISTINGVSMTPITEMS__FIELD_NAME.field_name)

    def set_ConsumableDataTypes_field(self, value: Optional[str]):
        """
        Set data field with field name 'ConsumableDataTypes' on this record model
        """
        self.set_field_value(self.CONSUMABLEDATATYPES__FIELD_NAME.field_name, value)

    def get_ConsumableDataTypes_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ConsumableDataTypes' from this record model
        """
        return self.get_field_value(self.CONSUMABLEDATATYPES__FIELD_NAME.field_name)

    def set_ConsumableDirectories_field(self, value: Optional[str]):
        """
        Set data field with field name 'ConsumableDirectories' on this record model
        """
        self.set_field_value(self.CONSUMABLEDIRECTORIES__FIELD_NAME.field_name, value)

    def get_ConsumableDirectories_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ConsumableDirectories' from this record model
        """
        return self.get_field_value(self.CONSUMABLEDIRECTORIES__FIELD_NAME.field_name)

    def set_ConsumableTrackingAttribute_field(self, value: Optional[str]):
        """
        Set data field with field name 'ConsumableTrackingAttribute' on this record model
        """
        self.set_field_value(self.CONSUMABLETRACKINGATTRIBUTE__FIELD_NAME.field_name, value)

    def get_ConsumableTrackingAttribute_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ConsumableTrackingAttribute' from this record model
        """
        return self.get_field_value(self.CONSUMABLETRACKINGATTRIBUTE__FIELD_NAME.field_name)

    def set_ConsumableTypeMaxTemp_field(self, value: Optional[str]):
        """
        Set data field with field name 'ConsumableTypeMaxTemp' on this record model
        """
        self.set_field_value(self.CONSUMABLETYPEMAXTEMP__FIELD_NAME.field_name, value)

    def get_ConsumableTypeMaxTemp_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ConsumableTypeMaxTemp' from this record model
        """
        return self.get_field_value(self.CONSUMABLETYPEMAXTEMP__FIELD_NAME.field_name)

    def set_CoolingStorageUnitTypes_field(self, value: Optional[str]):
        """
        Set data field with field name 'CoolingStorageUnitTypes' on this record model
        """
        self.set_field_value(self.COOLINGSTORAGEUNITTYPES__FIELD_NAME.field_name, value)

    def get_CoolingStorageUnitTypes_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CoolingStorageUnitTypes' from this record model
        """
        return self.get_field_value(self.COOLINGSTORAGEUNITTYPES__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def set_CreateInWorkflow_field(self, value: Optional[bool]):
        """
        Set data field with field name 'CreateInWorkflow' on this record model
        """
        self.set_field_value(self.CREATEINWORKFLOW__FIELD_NAME.field_name, value)

    def get_CreateInWorkflow_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'CreateInWorkflow' from this record model
        """
        return self.get_field_value(self.CREATEINWORKFLOW__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_DefaultELNExperimentGroupRoles_field(self, value: Optional[str]):
        """
        Set data field with field name 'DefaultELNExperimentGroupRoles' on this record model
        """
        self.set_field_value(self.DEFAULTELNEXPERIMENTGROUPROLES__FIELD_NAME.field_name, value)

    def get_DefaultELNExperimentGroupRoles_field(self) -> Optional[str]:
        """
        Get data field value with field name 'DefaultELNExperimentGroupRoles' from this record model
        """
        return self.get_field_value(self.DEFAULTELNEXPERIMENTGROUPROLES__FIELD_NAME.field_name)

    def set_DefaultELNExperimentRoles_field(self, value: Optional[str]):
        """
        Set data field with field name 'DefaultELNExperimentRoles' on this record model
        """
        self.set_field_value(self.DEFAULTELNEXPERIMENTROLES__FIELD_NAME.field_name, value)

    def get_DefaultELNExperimentRoles_field(self) -> Optional[str]:
        """
        Get data field value with field name 'DefaultELNExperimentRoles' from this record model
        """
        return self.get_field_value(self.DEFAULTELNEXPERIMENTROLES__FIELD_NAME.field_name)

    def set_DefaultELNExperimentRolesHelp_field(self, value: Optional[str]):
        """
        Set data field with field name 'DefaultELNExperimentRolesHelp' on this record model
        """
        self.set_field_value(self.DEFAULTELNEXPERIMENTROLESHELP__FIELD_NAME.field_name, value)

    def get_DefaultELNExperimentRolesHelp_field(self) -> Optional[str]:
        """
        Get data field value with field name 'DefaultELNExperimentRolesHelp' from this record model
        """
        return self.get_field_value(self.DEFAULTELNEXPERIMENTROLESHELP__FIELD_NAME.field_name)

    def set_Delimiter_field(self, value: Optional[str]):
        """
        Set data field with field name 'Delimiter' on this record model
        """
        self.set_field_value(self.DELIMITER__FIELD_NAME.field_name, value)

    def get_Delimiter_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Delimiter' from this record model
        """
        return self.get_field_value(self.DELIMITER__FIELD_NAME.field_name)

    def set_ELNCreateSmplExtentionMultiSel_field(self, value: Optional[bool]):
        """
        Set data field with field name 'ELNCreateSmplExtentionMultiSel' on this record model
        """
        self.set_field_value(self.ELNCREATESMPLEXTENTIONMULTISEL__FIELD_NAME.field_name, value)

    def get_ELNCreateSmplExtentionMultiSel_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'ELNCreateSmplExtentionMultiSel' from this record model
        """
        return self.get_field_value(self.ELNCREATESMPLEXTENTIONMULTISEL__FIELD_NAME.field_name)

    def set_ELNImportSamplesOverride_field(self, value: Optional[str]):
        """
        Set data field with field name 'ELNImportSamplesOverride' on this record model
        """
        self.set_field_value(self.ELNIMPORTSAMPLESOVERRIDE__FIELD_NAME.field_name, value)

    def get_ELNImportSamplesOverride_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ELNImportSamplesOverride' from this record model
        """
        return self.get_field_value(self.ELNIMPORTSAMPLESOVERRIDE__FIELD_NAME.field_name)

    def set_Email_field(self, value: Optional[str]):
        """
        Set data field with field name 'Email' on this record model
        """
        self.set_field_value(self.EMAIL__FIELD_NAME.field_name, value)

    def get_Email_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Email' from this record model
        """
        return self.get_field_value(self.EMAIL__FIELD_NAME.field_name)

    def set_EnableAutoLotPopulation_field(self, value: Optional[bool]):
        """
        Set data field with field name 'EnableAutoLotPopulation' on this record model
        """
        self.set_field_value(self.ENABLEAUTOLOTPOPULATION__FIELD_NAME.field_name, value)

    def get_EnableAutoLotPopulation_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'EnableAutoLotPopulation' from this record model
        """
        return self.get_field_value(self.ENABLEAUTOLOTPOPULATION__FIELD_NAME.field_name)

    def set_EnableBaselineSampleRec_field(self, value: Optional[bool]):
        """
        Set data field with field name 'EnableBaselineSampleRec' on this record model
        """
        self.set_field_value(self.ENABLEBASELINESAMPLEREC__FIELD_NAME.field_name, value)

    def get_EnableBaselineSampleRec_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'EnableBaselineSampleRec' from this record model
        """
        return self.get_field_value(self.ENABLEBASELINESAMPLEREC__FIELD_NAME.field_name)

    def set_EnableDND_field(self, value: Optional[bool]):
        """
        Set data field with field name 'EnableDND' on this record model
        """
        self.set_field_value(self.ENABLEDND__FIELD_NAME.field_name, value)

    def get_EnableDND_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'EnableDND' from this record model
        """
        return self.get_field_value(self.ENABLEDND__FIELD_NAME.field_name)

    def set_EnableElnRoleCandidates_field(self, value: Optional[bool]):
        """
        Set data field with field name 'EnableElnRoleCandidates' on this record model
        """
        self.set_field_value(self.ENABLEELNROLECANDIDATES__FIELD_NAME.field_name, value)

    def get_EnableElnRoleCandidates_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'EnableElnRoleCandidates' from this record model
        """
        return self.get_field_value(self.ENABLEELNROLECANDIDATES__FIELD_NAME.field_name)

    def set_EnableMultiTenantDashboards_field(self, value: Optional[bool]):
        """
        Set data field with field name 'EnableMultiTenantDashboards' on this record model
        """
        self.set_field_value(self.ENABLEMULTITENANTDASHBOARDS__FIELD_NAME.field_name, value)

    def get_EnableMultiTenantDashboards_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'EnableMultiTenantDashboards' from this record model
        """
        return self.get_field_value(self.ENABLEMULTITENANTDASHBOARDS__FIELD_NAME.field_name)

    def set_EnforceConsumableDirectory_field(self, value: Optional[bool]):
        """
        Set data field with field name 'EnforceConsumableDirectory' on this record model
        """
        self.set_field_value(self.ENFORCECONSUMABLEDIRECTORY__FIELD_NAME.field_name, value)

    def get_EnforceConsumableDirectory_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'EnforceConsumableDirectory' from this record model
        """
        return self.get_field_value(self.ENFORCECONSUMABLEDIRECTORY__FIELD_NAME.field_name)

    def set_EnforceExpiration_field(self, value: Optional[bool]):
        """
        Set data field with field name 'EnforceExpiration' on this record model
        """
        self.set_field_value(self.ENFORCEEXPIRATION__FIELD_NAME.field_name, value)

    def get_EnforceExpiration_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'EnforceExpiration' from this record model
        """
        return self.get_field_value(self.ENFORCEEXPIRATION__FIELD_NAME.field_name)

    def set_EnforceSufficientQuantity_field(self, value: Optional[bool]):
        """
        Set data field with field name 'EnforceSufficientQuantity' on this record model
        """
        self.set_field_value(self.ENFORCESUFFICIENTQUANTITY__FIELD_NAME.field_name, value)

    def get_EnforceSufficientQuantity_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'EnforceSufficientQuantity' from this record model
        """
        return self.get_field_value(self.ENFORCESUFFICIENTQUANTITY__FIELD_NAME.field_name)

    def set_ENotebookSignoffGroups_field(self, value: Optional[str]):
        """
        Set data field with field name 'ENotebookSignoffGroups' on this record model
        """
        self.set_field_value(self.ENOTEBOOKSIGNOFFGROUPS__FIELD_NAME.field_name, value)

    def get_ENotebookSignoffGroups_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ENotebookSignoffGroups' from this record model
        """
        return self.get_field_value(self.ENOTEBOOKSIGNOFFGROUPS__FIELD_NAME.field_name)

    def set_ENotebookSignoffGroupsHelp_field(self, value: Optional[str]):
        """
        Set data field with field name 'ENotebookSignoffGroupsHelp' on this record model
        """
        self.set_field_value(self.ENOTEBOOKSIGNOFFGROUPSHELP__FIELD_NAME.field_name, value)

    def get_ENotebookSignoffGroupsHelp_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ENotebookSignoffGroupsHelp' from this record model
        """
        return self.get_field_value(self.ENOTEBOOKSIGNOFFGROUPSHELP__FIELD_NAME.field_name)

    def set_EnumerateStorage_field(self, value: Optional[bool]):
        """
        Set data field with field name 'EnumerateStorage' on this record model
        """
        self.set_field_value(self.ENUMERATESTORAGE__FIELD_NAME.field_name, value)

    def get_EnumerateStorage_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'EnumerateStorage' from this record model
        """
        return self.get_field_value(self.ENUMERATESTORAGE__FIELD_NAME.field_name)

    def set_EsignEmailOwnerNotebookUnlock_field(self, value: Optional[bool]):
        """
        Set data field with field name 'EsignEmailOwnerNotebookUnlock' on this record model
        """
        self.set_field_value(self.ESIGNEMAILOWNERNOTEBOOKUNLOCK__FIELD_NAME.field_name, value)

    def get_EsignEmailOwnerNotebookUnlock_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'EsignEmailOwnerNotebookUnlock' from this record model
        """
        return self.get_field_value(self.ESIGNEMAILOWNERNOTEBOOKUNLOCK__FIELD_NAME.field_name)

    def set_EsignSendEmailOnDecision_field(self, value: Optional[bool]):
        """
        Set data field with field name 'EsignSendEmailOnDecision' on this record model
        """
        self.set_field_value(self.ESIGNSENDEMAILONDECISION__FIELD_NAME.field_name, value)

    def get_EsignSendEmailOnDecision_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'EsignSendEmailOnDecision' from this record model
        """
        return self.get_field_value(self.ESIGNSENDEMAILONDECISION__FIELD_NAME.field_name)

    def set_EsignSendEmailOnEntryUnlock_field(self, value: Optional[bool]):
        """
        Set data field with field name 'EsignSendEmailOnEntryUnlock' on this record model
        """
        self.set_field_value(self.ESIGNSENDEMAILONENTRYUNLOCK__FIELD_NAME.field_name, value)

    def get_EsignSendEmailOnEntryUnlock_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'EsignSendEmailOnEntryUnlock' from this record model
        """
        return self.get_field_value(self.ESIGNSENDEMAILONENTRYUNLOCK__FIELD_NAME.field_name)

    def set_EsignSendEmailOnNotebookUnlock_field(self, value: Optional[bool]):
        """
        Set data field with field name 'EsignSendEmailOnNotebookUnlock' on this record model
        """
        self.set_field_value(self.ESIGNSENDEMAILONNOTEBOOKUNLOCK__FIELD_NAME.field_name, value)

    def get_EsignSendEmailOnNotebookUnlock_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'EsignSendEmailOnNotebookUnlock' from this record model
        """
        return self.get_field_value(self.ESIGNSENDEMAILONNOTEBOOKUNLOCK__FIELD_NAME.field_name)

    def set_EsigRequireAllAuthor_field(self, value: Optional[bool]):
        """
        Set data field with field name 'EsigRequireAllAuthor' on this record model
        """
        self.set_field_value(self.ESIGREQUIREALLAUTHOR__FIELD_NAME.field_name, value)

    def get_EsigRequireAllAuthor_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'EsigRequireAllAuthor' from this record model
        """
        return self.get_field_value(self.ESIGREQUIREALLAUTHOR__FIELD_NAME.field_name)

    def set_EsigRequireAllAuthorHelp_field(self, value: Optional[str]):
        """
        Set data field with field name 'EsigRequireAllAuthorHelp' on this record model
        """
        self.set_field_value(self.ESIGREQUIREALLAUTHORHELP__FIELD_NAME.field_name, value)

    def get_EsigRequireAllAuthorHelp_field(self) -> Optional[str]:
        """
        Get data field value with field name 'EsigRequireAllAuthorHelp' from this record model
        """
        return self.get_field_value(self.ESIGREQUIREALLAUTHORHELP__FIELD_NAME.field_name)

    def set_ExperimentBannerExpFields_field(self, value: Optional[str]):
        """
        Set data field with field name 'ExperimentBannerExpFields' on this record model
        """
        self.set_field_value(self.EXPERIMENTBANNEREXPFIELDS__FIELD_NAME.field_name, value)

    def get_ExperimentBannerExpFields_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ExperimentBannerExpFields' from this record model
        """
        return self.get_field_value(self.EXPERIMENTBANNEREXPFIELDS__FIELD_NAME.field_name)

    def set_ExperimentBannerParentFields_field(self, value: Optional[str]):
        """
        Set data field with field name 'ExperimentBannerParentFields' on this record model
        """
        self.set_field_value(self.EXPERIMENTBANNERPARENTFIELDS__FIELD_NAME.field_name, value)

    def get_ExperimentBannerParentFields_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ExperimentBannerParentFields' from this record model
        """
        return self.get_field_value(self.EXPERIMENTBANNERPARENTFIELDS__FIELD_NAME.field_name)

    def set_GenerateItemBarcode_field(self, value: Optional[bool]):
        """
        Set data field with field name 'GenerateItemBarcode' on this record model
        """
        self.set_field_value(self.GENERATEITEMBARCODE__FIELD_NAME.field_name, value)

    def get_GenerateItemBarcode_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'GenerateItemBarcode' from this record model
        """
        return self.get_field_value(self.GENERATEITEMBARCODE__FIELD_NAME.field_name)

    def set_GRChFASTAPath_field(self, value: Optional[str]):
        """
        Set data field with field name 'GRChFASTAPath' on this record model
        """
        self.set_field_value(self.GRCHFASTAPATH__FIELD_NAME.field_name, value)

    def get_GRChFASTAPath_field(self) -> Optional[str]:
        """
        Get data field value with field name 'GRChFASTAPath' from this record model
        """
        return self.get_field_value(self.GRCHFASTAPATH__FIELD_NAME.field_name)

    def set_ImportBaseLineDescription_field(self, value: Optional[str]):
        """
        Set data field with field name 'ImportBaseLineDescription' on this record model
        """
        self.set_field_value(self.IMPORTBASELINEDESCRIPTION__FIELD_NAME.field_name, value)

    def get_ImportBaseLineDescription_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ImportBaseLineDescription' from this record model
        """
        return self.get_field_value(self.IMPORTBASELINEDESCRIPTION__FIELD_NAME.field_name)

    def set_ImportExportExemplarConfigText_field(self, value: Optional[str]):
        """
        Set data field with field name 'ImportExportExemplarConfigText' on this record model
        """
        self.set_field_value(self.IMPORTEXPORTEXEMPLARCONFIGTEXT__FIELD_NAME.field_name, value)

    def get_ImportExportExemplarConfigText_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ImportExportExemplarConfigText' from this record model
        """
        return self.get_field_value(self.IMPORTEXPORTEXEMPLARCONFIGTEXT__FIELD_NAME.field_name)

    def set_ImportExportSystemConfigsText_field(self, value: Optional[str]):
        """
        Set data field with field name 'ImportExportSystemConfigsText' on this record model
        """
        self.set_field_value(self.IMPORTEXPORTSYSTEMCONFIGSTEXT__FIELD_NAME.field_name, value)

    def get_ImportExportSystemConfigsText_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ImportExportSystemConfigsText' from this record model
        """
        return self.get_field_value(self.IMPORTEXPORTSYSTEMCONFIGSTEXT__FIELD_NAME.field_name)

    def set_IndexedStorageType_field(self, value: Optional[str]):
        """
        Set data field with field name 'IndexedStorageType' on this record model
        """
        self.set_field_value(self.INDEXEDSTORAGETYPE__FIELD_NAME.field_name, value)

    def get_IndexedStorageType_field(self) -> Optional[str]:
        """
        Get data field value with field name 'IndexedStorageType' from this record model
        """
        return self.get_field_value(self.INDEXEDSTORAGETYPE__FIELD_NAME.field_name)

    def set_InstrumentForceIdvRegistration_field(self, value: Optional[bool]):
        """
        Set data field with field name 'InstrumentForceIdvRegistration' on this record model
        """
        self.set_field_value(self.INSTRUMENTFORCEIDVREGISTRATION__FIELD_NAME.field_name, value)

    def get_InstrumentForceIdvRegistration_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'InstrumentForceIdvRegistration' from this record model
        """
        return self.get_field_value(self.INSTRUMENTFORCEIDVREGISTRATION__FIELD_NAME.field_name)

    def set_MatManEnableFeatureExt_field(self, value: Optional[bool]):
        """
        Set data field with field name 'MatManEnableFeatureExt' on this record model
        """
        self.set_field_value(self.MATMANENABLEFEATUREEXT__FIELD_NAME.field_name, value)

    def get_MatManEnableFeatureExt_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'MatManEnableFeatureExt' from this record model
        """
        return self.get_field_value(self.MATMANENABLEFEATUREEXT__FIELD_NAME.field_name)

    def set_MmForceIdvRegistration_field(self, value: Optional[bool]):
        """
        Set data field with field name 'MmForceIdvRegistration' on this record model
        """
        self.set_field_value(self.MMFORCEIDVREGISTRATION__FIELD_NAME.field_name, value)

    def get_MmForceIdvRegistration_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'MmForceIdvRegistration' from this record model
        """
        return self.get_field_value(self.MMFORCEIDVREGISTRATION__FIELD_NAME.field_name)

    def set_MmSampleFieldsToDisplay_field(self, value: Optional[str]):
        """
        Set data field with field name 'MmSampleFieldsToDisplay' on this record model
        """
        self.set_field_value(self.MMSAMPLEFIELDSTODISPLAY__FIELD_NAME.field_name, value)

    def get_MmSampleFieldsToDisplay_field(self) -> Optional[str]:
        """
        Get data field value with field name 'MmSampleFieldsToDisplay' from this record model
        """
        return self.get_field_value(self.MMSAMPLEFIELDSTODISPLAY__FIELD_NAME.field_name)

    def set_MultiLayerPlatePoolIfSameType_field(self, value: Optional[bool]):
        """
        Set data field with field name 'MultiLayerPlatePoolIfSameType' on this record model
        """
        self.set_field_value(self.MULTILAYERPLATEPOOLIFSAMETYPE__FIELD_NAME.field_name, value)

    def get_MultiLayerPlatePoolIfSameType_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'MultiLayerPlatePoolIfSameType' from this record model
        """
        return self.get_field_value(self.MULTILAYERPLATEPOOLIFSAMETYPE__FIELD_NAME.field_name)

    def set_NativePyExecPath_field(self, value: Optional[str]):
        """
        Set data field with field name 'NativePyExecPath' on this record model
        """
        self.set_field_value(self.NATIVEPYEXECPATH__FIELD_NAME.field_name, value)

    def get_NativePyExecPath_field(self) -> Optional[str]:
        """
        Get data field value with field name 'NativePyExecPath' from this record model
        """
        return self.get_field_value(self.NATIVEPYEXECPATH__FIELD_NAME.field_name)

    def set_NativeRExecPath_field(self, value: Optional[str]):
        """
        Set data field with field name 'NativeRExecPath' on this record model
        """
        self.set_field_value(self.NATIVEREXECPATH__FIELD_NAME.field_name, value)

    def get_NativeRExecPath_field(self) -> Optional[str]:
        """
        Get data field value with field name 'NativeRExecPath' from this record model
        """
        return self.get_field_value(self.NATIVEREXECPATH__FIELD_NAME.field_name)

    def set_NewConsumableDirName_field(self, value: Optional[str]):
        """
        Set data field with field name 'NewConsumableDirName' on this record model
        """
        self.set_field_value(self.NEWCONSUMABLEDIRNAME__FIELD_NAME.field_name, value)

    def get_NewConsumableDirName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'NewConsumableDirName' from this record model
        """
        return self.get_field_value(self.NEWCONSUMABLEDIRNAME__FIELD_NAME.field_name)

    def set_NotificationUsers_field(self, value: Optional[str]):
        """
        Set data field with field name 'NotificationUsers' on this record model
        """
        self.set_field_value(self.NOTIFICATIONUSERS__FIELD_NAME.field_name, value)

    def get_NotificationUsers_field(self) -> Optional[str]:
        """
        Get data field value with field name 'NotificationUsers' from this record model
        """
        return self.get_field_value(self.NOTIFICATIONUSERS__FIELD_NAME.field_name)

    def set_NotifyMaintTechnicians_field(self, value: Optional[bool]):
        """
        Set data field with field name 'NotifyMaintTechnicians' on this record model
        """
        self.set_field_value(self.NOTIFYMAINTTECHNICIANS__FIELD_NAME.field_name, value)

    def get_NotifyMaintTechnicians_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'NotifyMaintTechnicians' from this record model
        """
        return self.get_field_value(self.NOTIFYMAINTTECHNICIANS__FIELD_NAME.field_name)

    def set_OverrideGroups_field(self, value: Optional[str]):
        """
        Set data field with field name 'OverrideGroups' on this record model
        """
        self.set_field_value(self.OVERRIDEGROUPS__FIELD_NAME.field_name, value)

    def get_OverrideGroups_field(self) -> Optional[str]:
        """
        Get data field value with field name 'OverrideGroups' from this record model
        """
        return self.get_field_value(self.OVERRIDEGROUPS__FIELD_NAME.field_name)

    def set_PlasmidDataType_field(self, value: Optional[str]):
        """
        Set data field with field name 'PlasmidDataType' on this record model
        """
        self.set_field_value(self.PLASMIDDATATYPE__FIELD_NAME.field_name, value)

    def get_PlasmidDataType_field(self) -> Optional[str]:
        """
        Get data field value with field name 'PlasmidDataType' from this record model
        """
        return self.get_field_value(self.PLASMIDDATATYPE__FIELD_NAME.field_name)

    def set_PlateDesignerPrimaryTypes_field(self, value: Optional[str]):
        """
        Set data field with field name 'PlateDesignerPrimaryTypes' on this record model
        """
        self.set_field_value(self.PLATEDESIGNERPRIMARYTYPES__FIELD_NAME.field_name, value)

    def get_PlateDesignerPrimaryTypes_field(self) -> Optional[str]:
        """
        Get data field value with field name 'PlateDesignerPrimaryTypes' from this record model
        """
        return self.get_field_value(self.PLATEDESIGNERPRIMARYTYPES__FIELD_NAME.field_name)

    def set_Port_field(self, value: Optional[int]):
        """
        Set data field with field name 'Port' on this record model
        """
        self.set_field_value(self.PORT__FIELD_NAME.field_name, value)

    def get_Port_field(self) -> Optional[int]:
        """
        Get data field value with field name 'Port' from this record model
        """
        return self.get_field_value(self.PORT__FIELD_NAME.field_name)

    def set_PreNotificationInterval_field(self, value: Optional[int]):
        """
        Set data field with field name 'PreNotificationInterval' on this record model
        """
        self.set_field_value(self.PRENOTIFICATIONINTERVAL__FIELD_NAME.field_name, value)

    def get_PreNotificationInterval_field(self) -> Optional[int]:
        """
        Get data field value with field name 'PreNotificationInterval' from this record model
        """
        return self.get_field_value(self.PRENOTIFICATIONINTERVAL__FIELD_NAME.field_name)

    def set_PrintConsumableBarcode_field(self, value: Optional[bool]):
        """
        Set data field with field name 'PrintConsumableBarcode' on this record model
        """
        self.set_field_value(self.PRINTCONSUMABLEBARCODE__FIELD_NAME.field_name, value)

    def get_PrintConsumableBarcode_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'PrintConsumableBarcode' from this record model
        """
        return self.get_field_value(self.PRINTCONSUMABLEBARCODE__FIELD_NAME.field_name)

    def set_QCMailingList_field(self, value: Optional[str]):
        """
        Set data field with field name 'QCMailingList' on this record model
        """
        self.set_field_value(self.QCMAILINGLIST__FIELD_NAME.field_name, value)

    def get_QCMailingList_field(self) -> Optional[str]:
        """
        Get data field value with field name 'QCMailingList' from this record model
        """
        return self.get_field_value(self.QCMAILINGLIST__FIELD_NAME.field_name)

    def set_QuantityTracking_field(self, value: Optional[bool]):
        """
        Set data field with field name 'QuantityTracking' on this record model
        """
        self.set_field_value(self.QUANTITYTRACKING__FIELD_NAME.field_name, value)

    def get_QuantityTracking_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'QuantityTracking' from this record model
        """
        return self.get_field_value(self.QUANTITYTRACKING__FIELD_NAME.field_name)

    def set_RecordReportAccessGroups_field(self, value: Optional[str]):
        """
        Set data field with field name 'RecordReportAccessGroups' on this record model
        """
        self.set_field_value(self.RECORDREPORTACCESSGROUPS__FIELD_NAME.field_name, value)

    def get_RecordReportAccessGroups_field(self) -> Optional[str]:
        """
        Get data field value with field name 'RecordReportAccessGroups' from this record model
        """
        return self.get_field_value(self.RECORDREPORTACCESSGROUPS__FIELD_NAME.field_name)

    def set_RecordReportDataTypeList_field(self, value: Optional[str]):
        """
        Set data field with field name 'RecordReportDataTypeList' on this record model
        """
        self.set_field_value(self.RECORDREPORTDATATYPELIST__FIELD_NAME.field_name, value)

    def get_RecordReportDataTypeList_field(self) -> Optional[str]:
        """
        Get data field value with field name 'RecordReportDataTypeList' from this record model
        """
        return self.get_field_value(self.RECORDREPORTDATATYPELIST__FIELD_NAME.field_name)

    def set_RecordStorageEvents_field(self, value: Optional[bool]):
        """
        Set data field with field name 'RecordStorageEvents' on this record model
        """
        self.set_field_value(self.RECORDSTORAGEEVENTS__FIELD_NAME.field_name, value)

    def get_RecordStorageEvents_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'RecordStorageEvents' from this record model
        """
        return self.get_field_value(self.RECORDSTORAGEEVENTS__FIELD_NAME.field_name)

    def set_ReqPortalManifestFieldNames_field(self, value: Optional[str]):
        """
        Set data field with field name 'ReqPortalManifestFieldNames' on this record model
        """
        self.set_field_value(self.REQPORTALMANIFESTFIELDNAMES__FIELD_NAME.field_name, value)

    def get_ReqPortalManifestFieldNames_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ReqPortalManifestFieldNames' from this record model
        """
        return self.get_field_value(self.REQPORTALMANIFESTFIELDNAMES__FIELD_NAME.field_name)

    def set_RequireESignature_field(self, value: Optional[bool]):
        """
        Set data field with field name 'RequireESignature' on this record model
        """
        self.set_field_value(self.REQUIREESIGNATURE__FIELD_NAME.field_name, value)

    def get_RequireESignature_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'RequireESignature' from this record model
        """
        return self.get_field_value(self.REQUIREESIGNATURE__FIELD_NAME.field_name)

    def set_RestrictAccessByLocation_field(self, value: Optional[bool]):
        """
        Set data field with field name 'RestrictAccessByLocation' on this record model
        """
        self.set_field_value(self.RESTRICTACCESSBYLOCATION__FIELD_NAME.field_name, value)

    def get_RestrictAccessByLocation_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'RestrictAccessByLocation' from this record model
        """
        return self.get_field_value(self.RESTRICTACCESSBYLOCATION__FIELD_NAME.field_name)

    def set_ReviewerVisibleRoleType_field(self, value: Optional[bool]):
        """
        Set data field with field name 'ReviewerVisibleRoleType' on this record model
        """
        self.set_field_value(self.REVIEWERVISIBLEROLETYPE__FIELD_NAME.field_name, value)

    def get_ReviewerVisibleRoleType_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'ReviewerVisibleRoleType' from this record model
        """
        return self.get_field_value(self.REVIEWERVISIBLEROLETYPE__FIELD_NAME.field_name)

    def set_RTransExecPath_field(self, value: Optional[str]):
        """
        Set data field with field name 'RTransExecPath' on this record model
        """
        self.set_field_value(self.RTRANSEXECPATH__FIELD_NAME.field_name, value)

    def get_RTransExecPath_field(self) -> Optional[str]:
        """
        Get data field value with field name 'RTransExecPath' from this record model
        """
        return self.get_field_value(self.RTRANSEXECPATH__FIELD_NAME.field_name)

    def set_S3AccessKeyId_field(self, value: Optional[str]):
        """
        Set data field with field name 'S3AccessKeyId' on this record model
        """
        self.set_field_value(self.S3ACCESSKEYID__FIELD_NAME.field_name, value)

    def get_S3AccessKeyId_field(self) -> Optional[str]:
        """
        Get data field value with field name 'S3AccessKeyId' from this record model
        """
        return self.get_field_value(self.S3ACCESSKEYID__FIELD_NAME.field_name)

    def set_S3SecretAcessKey_field(self, value: Optional[str]):
        """
        Set data field with field name 'S3SecretAcessKey' on this record model
        """
        self.set_field_value(self.S3SECRETACESSKEY__FIELD_NAME.field_name, value)

    def get_S3SecretAcessKey_field(self) -> Optional[str]:
        """
        Get data field value with field name 'S3SecretAcessKey' from this record model
        """
        return self.get_field_value(self.S3SECRETACESSKEY__FIELD_NAME.field_name)

    def set_SaasMaxNumOfSamplesPerTrans_field(self, value: Optional[int]):
        """
        Set data field with field name 'SaasMaxNumOfSamplesPerTrans' on this record model
        """
        self.set_field_value(self.SAASMAXNUMOFSAMPLESPERTRANS__FIELD_NAME.field_name, value)

    def get_SaasMaxNumOfSamplesPerTrans_field(self) -> Optional[int]:
        """
        Get data field value with field name 'SaasMaxNumOfSamplesPerTrans' from this record model
        """
        return self.get_field_value(self.SAASMAXNUMOFSAMPLESPERTRANS__FIELD_NAME.field_name)

    def set_SaasMaxSamples_field(self, value: Optional[int]):
        """
        Set data field with field name 'SaasMaxSamples' on this record model
        """
        self.set_field_value(self.SAASMAXSAMPLES__FIELD_NAME.field_name, value)

    def get_SaasMaxSamples_field(self) -> Optional[int]:
        """
        Get data field value with field name 'SaasMaxSamples' from this record model
        """
        return self.get_field_value(self.SAASMAXSAMPLES__FIELD_NAME.field_name)

    def set_SaasMode_field(self, value: Optional[bool]):
        """
        Set data field with field name 'SaasMode' on this record model
        """
        self.set_field_value(self.SAASMODE__FIELD_NAME.field_name, value)

    def get_SaasMode_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'SaasMode' from this record model
        """
        return self.get_field_value(self.SAASMODE__FIELD_NAME.field_name)

    def set_SampleReceivingEmails_field(self, value: Optional[str]):
        """
        Set data field with field name 'SampleReceivingEmails' on this record model
        """
        self.set_field_value(self.SAMPLERECEIVINGEMAILS__FIELD_NAME.field_name, value)

    def get_SampleReceivingEmails_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SampleReceivingEmails' from this record model
        """
        return self.get_field_value(self.SAMPLERECEIVINGEMAILS__FIELD_NAME.field_name)

    def set_SampleReceivingUserMenu_field(self, value: Optional[str]):
        """
        Set data field with field name 'SampleReceivingUserMenu' on this record model
        """
        self.set_field_value(self.SAMPLERECEIVINGUSERMENU__FIELD_NAME.field_name, value)

    def get_SampleReceivingUserMenu_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SampleReceivingUserMenu' from this record model
        """
        return self.get_field_value(self.SAMPLERECEIVINGUSERMENU__FIELD_NAME.field_name)

    def set_SampleTypeMaximumTemperature_field(self, value: Optional[str]):
        """
        Set data field with field name 'SampleTypeMaximumTemperature' on this record model
        """
        self.set_field_value(self.SAMPLETYPEMAXIMUMTEMPERATURE__FIELD_NAME.field_name, value)

    def get_SampleTypeMaximumTemperature_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SampleTypeMaximumTemperature' from this record model
        """
        return self.get_field_value(self.SAMPLETYPEMAXIMUMTEMPERATURE__FIELD_NAME.field_name)

    def set_SamtoolsExecPath_field(self, value: Optional[str]):
        """
        Set data field with field name 'SamtoolsExecPath' on this record model
        """
        self.set_field_value(self.SAMTOOLSEXECPATH__FIELD_NAME.field_name, value)

    def get_SamtoolsExecPath_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SamtoolsExecPath' from this record model
        """
        return self.get_field_value(self.SAMTOOLSEXECPATH__FIELD_NAME.field_name)

    def set_SDMSRootPath_field(self, value: Optional[str]):
        """
        Set data field with field name 'SDMSRootPath' on this record model
        """
        self.set_field_value(self.SDMSROOTPATH__FIELD_NAME.field_name, value)

    def get_SDMSRootPath_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SDMSRootPath' from this record model
        """
        return self.get_field_value(self.SDMSROOTPATH__FIELD_NAME.field_name)

    def set_SecureSocketLayer_field(self, value: Optional[bool]):
        """
        Set data field with field name 'SecureSocketLayer' on this record model
        """
        self.set_field_value(self.SECURESOCKETLAYER__FIELD_NAME.field_name, value)

    def get_SecureSocketLayer_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'SecureSocketLayer' from this record model
        """
        return self.get_field_value(self.SECURESOCKETLAYER__FIELD_NAME.field_name)

    def set_SMTPServer_field(self, value: Optional[str]):
        """
        Set data field with field name 'SMTPServer' on this record model
        """
        self.set_field_value(self.SMTPSERVER__FIELD_NAME.field_name, value)

    def get_SMTPServer_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SMTPServer' from this record model
        """
        return self.get_field_value(self.SMTPSERVER__FIELD_NAME.field_name)

    def set_SmtpUsername_field(self, value: Optional[str]):
        """
        Set data field with field name 'SmtpUsername' on this record model
        """
        self.set_field_value(self.SMTPUSERNAME__FIELD_NAME.field_name, value)

    def get_SmtpUsername_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SmtpUsername' from this record model
        """
        return self.get_field_value(self.SMTPUSERNAME__FIELD_NAME.field_name)

    def set_StorageUnitViewerFillByConfig_field(self, value: Optional[str]):
        """
        Set data field with field name 'StorageUnitViewerFillByConfig' on this record model
        """
        self.set_field_value(self.STORAGEUNITVIEWERFILLBYCONFIG__FIELD_NAME.field_name, value)

    def get_StorageUnitViewerFillByConfig_field(self) -> Optional[str]:
        """
        Get data field value with field name 'StorageUnitViewerFillByConfig' from this record model
        """
        return self.get_field_value(self.STORAGEUNITVIEWERFILLBYCONFIG__FIELD_NAME.field_name)

    def set_SystemPassword_field(self, value: Optional[str]):
        """
        Set data field with field name 'SystemPassword' on this record model
        """
        self.set_field_value(self.SYSTEMPASSWORD__FIELD_NAME.field_name, value)

    def get_SystemPassword_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SystemPassword' from this record model
        """
        return self.get_field_value(self.SYSTEMPASSWORD__FIELD_NAME.field_name)

    def set_TemperatureEnforcement_field(self, value: Optional[str]):
        """
        Set data field with field name 'TemperatureEnforcement' on this record model
        """
        self.set_field_value(self.TEMPERATUREENFORCEMENT__FIELD_NAME.field_name, value)

    def get_TemperatureEnforcement_field(self) -> Optional[str]:
        """
        Get data field value with field name 'TemperatureEnforcement' from this record model
        """
        return self.get_field_value(self.TEMPERATUREENFORCEMENT__FIELD_NAME.field_name)

    def set_TLSEnabled_field(self, value: Optional[bool]):
        """
        Set data field with field name 'TLSEnabled' on this record model
        """
        self.set_field_value(self.TLSENABLED__FIELD_NAME.field_name, value)

    def get_TLSEnabled_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'TLSEnabled' from this record model
        """
        return self.get_field_value(self.TLSENABLED__FIELD_NAME.field_name)

    def set_TLSRequired_field(self, value: Optional[bool]):
        """
        Set data field with field name 'TLSRequired' on this record model
        """
        self.set_field_value(self.TLSREQUIRED__FIELD_NAME.field_name, value)

    def get_TLSRequired_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'TLSRequired' from this record model
        """
        return self.get_field_value(self.TLSREQUIRED__FIELD_NAME.field_name)

    def set_UseRequestDefaultLayout_field(self, value: Optional[bool]):
        """
        Set data field with field name 'UseRequestDefaultLayout' on this record model
        """
        self.set_field_value(self.USEREQUESTDEFAULTLAYOUT__FIELD_NAME.field_name, value)

    def get_UseRequestDefaultLayout_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'UseRequestDefaultLayout' from this record model
        """
        return self.get_field_value(self.USEREQUESTDEFAULTLAYOUT__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)

    def set_VerificationTypes_field(self, value: Optional[str]):
        """
        Set data field with field name 'VerificationTypes' on this record model
        """
        self.set_field_value(self.VERIFICATIONTYPES__FIELD_NAME.field_name, value)

    def get_VerificationTypes_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VerificationTypes' from this record model
        """
        return self.get_field_value(self.VERIFICATIONTYPES__FIELD_NAME.field_name)

    def set_WitnessVisibleRoleType_field(self, value: Optional[bool]):
        """
        Set data field with field name 'WitnessVisibleRoleType' on this record model
        """
        self.set_field_value(self.WITNESSVISIBLEROLETYPE__FIELD_NAME.field_name, value)

    def get_WitnessVisibleRoleType_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'WitnessVisibleRoleType' from this record model
        """
        return self.get_field_value(self.WITNESSVISIBLEROLETYPE__FIELD_NAME.field_name)

    def set_WriteQCInputFileToUser_field(self, value: Optional[bool]):
        """
        Set data field with field name 'WriteQCInputFileToUser' on this record model
        """
        self.set_field_value(self.WRITEQCINPUTFILETOUSER__FIELD_NAME.field_name, value)

    def get_WriteQCInputFileToUser_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'WriteQCInputFileToUser' from this record model
        """
        return self.get_field_value(self.WRITEQCINPUTFILETOUSER__FIELD_NAME.field_name)


class ExemplarLabNotebookPDFModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type ExemplarLabNotebookPDF
    Data Type Display Name: Sapio Lab Notebook PDF (Sapio Lab Notebook PDFs)
    Fields: CreatedBy, DataRecordName, DateCreated, FilePath, VeloxCurrentVersion, VeloxLastModifiedBy, VeloxLastModifiedDate
    This data type is used to store the latest PDF file that has been generated from a given notebook.
    """
    DATA_TYPE_NAME: str = 'ExemplarLabNotebookPDF'
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    FILEPATH__FIELD_NAME: WrapperField = WrapperField("FilePath", FieldType.STRING)
    VELOXCURRENTVERSION__FIELD_NAME: WrapperField = WrapperField("VeloxCurrentVersion", FieldType.INTEGER)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_FilePath_field(self, value: Optional[str]):
        """
        Set data field with field name 'FilePath' on this record model
        """
        self.set_field_value(self.FILEPATH__FIELD_NAME.field_name, value)

    def get_FilePath_field(self) -> Optional[str]:
        """
        Get data field value with field name 'FilePath' from this record model
        """
        return self.get_field_value(self.FILEPATH__FIELD_NAME.field_name)

    def set_VeloxCurrentVersion_field(self, value: Optional[int]):
        """
        Set data field with field name 'VeloxCurrentVersion' on this record model
        """
        self.set_field_value(self.VELOXCURRENTVERSION__FIELD_NAME.field_name, value)

    def get_VeloxCurrentVersion_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxCurrentVersion' from this record model
        """
        return self.get_field_value(self.VELOXCURRENTVERSION__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class ExemplarSDMSFileModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type ExemplarSDMSFile
    Data Type Display Name: SDMS File (SDMS Files)
    Fields: CreatedBy, DataRecordName, DateCreated, FileCreationDate, FileHash, FileLastModifiedDate, FilePath, FileSize, FileSourcePath, InstrumentType, IsLoaded, VeloxCurrentVersion, VeloxLastModifiedBy, VeloxLastModifiedDate
    These are potentially very large files that will be stored as SDMS file. They will be retrieved through streamed download.
    """
    DATA_TYPE_NAME: str = 'ExemplarSDMSFile'
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    FILECREATIONDATE__FIELD_NAME: WrapperField = WrapperField("FileCreationDate", FieldType.DATE)
    FILEHASH__FIELD_NAME: WrapperField = WrapperField("FileHash", FieldType.STRING)
    FILELASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("FileLastModifiedDate", FieldType.DATE)
    FILEPATH__FIELD_NAME: WrapperField = WrapperField("FilePath", FieldType.STRING)
    FILESIZE__FIELD_NAME: WrapperField = WrapperField("FileSize", FieldType.LONG)
    FILESOURCEPATH__FIELD_NAME: WrapperField = WrapperField("FileSourcePath", FieldType.STRING)
    INSTRUMENTTYPE__FIELD_NAME: WrapperField = WrapperField("InstrumentType", FieldType.STRING)
    ISLOADED__FIELD_NAME: WrapperField = WrapperField("IsLoaded", FieldType.BOOLEAN)
    VELOXCURRENTVERSION__FIELD_NAME: WrapperField = WrapperField("VeloxCurrentVersion", FieldType.INTEGER)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_FileCreationDate_field(self, value: Optional[int]):
        """
        Set data field with field name 'FileCreationDate' on this record model
        """
        self.set_field_value(self.FILECREATIONDATE__FIELD_NAME.field_name, value)

    def get_FileCreationDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'FileCreationDate' from this record model
        """
        return self.get_field_value(self.FILECREATIONDATE__FIELD_NAME.field_name)

    def set_FileHash_field(self, value: Optional[str]):
        """
        Set data field with field name 'FileHash' on this record model
        """
        self.set_field_value(self.FILEHASH__FIELD_NAME.field_name, value)

    def get_FileHash_field(self) -> Optional[str]:
        """
        Get data field value with field name 'FileHash' from this record model
        """
        return self.get_field_value(self.FILEHASH__FIELD_NAME.field_name)

    def set_FileLastModifiedDate_field(self, value: Optional[int]):
        """
        Set data field with field name 'FileLastModifiedDate' on this record model
        """
        self.set_field_value(self.FILELASTMODIFIEDDATE__FIELD_NAME.field_name, value)

    def get_FileLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'FileLastModifiedDate' from this record model
        """
        return self.get_field_value(self.FILELASTMODIFIEDDATE__FIELD_NAME.field_name)

    def set_FilePath_field(self, value: Optional[str]):
        """
        Set data field with field name 'FilePath' on this record model
        """
        self.set_field_value(self.FILEPATH__FIELD_NAME.field_name, value)

    def get_FilePath_field(self) -> Optional[str]:
        """
        Get data field value with field name 'FilePath' from this record model
        """
        return self.get_field_value(self.FILEPATH__FIELD_NAME.field_name)

    def set_FileSize_field(self, value: Optional[int]):
        """
        Set data field with field name 'FileSize' on this record model
        """
        self.set_field_value(self.FILESIZE__FIELD_NAME.field_name, value)

    def get_FileSize_field(self) -> Optional[int]:
        """
        Get data field value with field name 'FileSize' from this record model
        """
        return self.get_field_value(self.FILESIZE__FIELD_NAME.field_name)

    def set_FileSourcePath_field(self, value: Optional[str]):
        """
        Set data field with field name 'FileSourcePath' on this record model
        """
        self.set_field_value(self.FILESOURCEPATH__FIELD_NAME.field_name, value)

    def get_FileSourcePath_field(self) -> Optional[str]:
        """
        Get data field value with field name 'FileSourcePath' from this record model
        """
        return self.get_field_value(self.FILESOURCEPATH__FIELD_NAME.field_name)

    def set_InstrumentType_field(self, value: Optional[str]):
        """
        Set data field with field name 'InstrumentType' on this record model
        """
        self.set_field_value(self.INSTRUMENTTYPE__FIELD_NAME.field_name, value)

    def get_InstrumentType_field(self) -> Optional[str]:
        """
        Get data field value with field name 'InstrumentType' from this record model
        """
        return self.get_field_value(self.INSTRUMENTTYPE__FIELD_NAME.field_name)

    def set_IsLoaded_field(self, value: Optional[bool]):
        """
        Set data field with field name 'IsLoaded' on this record model
        """
        self.set_field_value(self.ISLOADED__FIELD_NAME.field_name, value)

    def get_IsLoaded_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'IsLoaded' from this record model
        """
        return self.get_field_value(self.ISLOADED__FIELD_NAME.field_name)

    def set_VeloxCurrentVersion_field(self, value: Optional[int]):
        """
        Set data field with field name 'VeloxCurrentVersion' on this record model
        """
        self.set_field_value(self.VELOXCURRENTVERSION__FIELD_NAME.field_name, value)

    def get_VeloxCurrentVersion_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxCurrentVersion' from this record model
        """
        return self.get_field_value(self.VELOXCURRENTVERSION__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class ExperimentGroupModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type ExperimentGroup
    Data Type Display Name: Experiment Group (Experiment Groups)
    Fields: CreatedBy, DataRecordName, DateCreated, GroupMonth, GroupYear, VeloxLastModifiedBy, VeloxLastModifiedDate
    """
    DATA_TYPE_NAME: str = 'ExperimentGroup'
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    GROUPMONTH__FIELD_NAME: WrapperField = WrapperField("GroupMonth", FieldType.PICKLIST)
    GROUPYEAR__FIELD_NAME: WrapperField = WrapperField("GroupYear", FieldType.SHORT)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_GroupMonth_field(self, value: Optional[str]):
        """
        Set data field with field name 'GroupMonth' on this record model
        """
        self.set_field_value(self.GROUPMONTH__FIELD_NAME.field_name, value)

    def get_GroupMonth_field(self) -> Optional[str]:
        """
        Get data field value with field name 'GroupMonth' from this record model
        """
        return self.get_field_value(self.GROUPMONTH__FIELD_NAME.field_name)

    def set_GroupYear_field(self, value: Optional[int]):
        """
        Set data field with field name 'GroupYear' on this record model
        """
        self.set_field_value(self.GROUPYEAR__FIELD_NAME.field_name, value)

    def get_GroupYear_field(self) -> Optional[int]:
        """
        Get data field value with field name 'GroupYear' from this record model
        """
        return self.get_field_value(self.GROUPYEAR__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class ExpoentialDecayModelModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type ExpoentialDecayModel
    Data Type Display Name: Exponential Decay Model (Exponential Decay Models)
    Fields: c, CreatedBy, d, DataRecordName, DateCreated, e, EntryName, Formula, MultiParentLink215, RSE, RSEDOF, RSquared, SeriesName, SourceEntryId, VeloxLastModifiedBy, VeloxLastModifiedDate
    Exponential Decay follows this formula:

Y = c + (d-c) exp(-x/e)
    """
    DATA_TYPE_NAME: str = 'ExpoentialDecayModel'
    C__FIELD_NAME: WrapperField = WrapperField("c", FieldType.DOUBLE)
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    D__FIELD_NAME: WrapperField = WrapperField("d", FieldType.DOUBLE)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    E__FIELD_NAME: WrapperField = WrapperField("e", FieldType.DOUBLE)
    ENTRYNAME__FIELD_NAME: WrapperField = WrapperField("EntryName", FieldType.STRING)
    FORMULA__FIELD_NAME: WrapperField = WrapperField("Formula", FieldType.STRING)
    MULTIPARENTLINK215__FIELD_NAME: WrapperField = WrapperField("MultiParentLink215", FieldType.MULTIPARENTLINK)
    RSE__FIELD_NAME: WrapperField = WrapperField("RSE", FieldType.DOUBLE)
    RSEDOF__FIELD_NAME: WrapperField = WrapperField("RSEDOF", FieldType.DOUBLE)
    RSQUARED__FIELD_NAME: WrapperField = WrapperField("RSquared", FieldType.DOUBLE)
    SERIESNAME__FIELD_NAME: WrapperField = WrapperField("SeriesName", FieldType.STRING)
    SOURCEENTRYID__FIELD_NAME: WrapperField = WrapperField("SourceEntryId", FieldType.LONG)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_c_field(self, value: Optional[float]):
        """
        Set data field with field name 'c' on this record model
        """
        self.set_field_value(self.C__FIELD_NAME.field_name, value)

    def get_c_field(self) -> Optional[float]:
        """
        Get data field value with field name 'c' from this record model
        """
        return self.get_field_value(self.C__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def set_d_field(self, value: Optional[float]):
        """
        Set data field with field name 'd' on this record model
        """
        self.set_field_value(self.D__FIELD_NAME.field_name, value)

    def get_d_field(self) -> Optional[float]:
        """
        Get data field value with field name 'd' from this record model
        """
        return self.get_field_value(self.D__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_e_field(self, value: Optional[float]):
        """
        Set data field with field name 'e' on this record model
        """
        self.set_field_value(self.E__FIELD_NAME.field_name, value)

    def get_e_field(self) -> Optional[float]:
        """
        Get data field value with field name 'e' from this record model
        """
        return self.get_field_value(self.E__FIELD_NAME.field_name)

    def set_EntryName_field(self, value: Optional[str]):
        """
        Set data field with field name 'EntryName' on this record model
        """
        self.set_field_value(self.ENTRYNAME__FIELD_NAME.field_name, value)

    def get_EntryName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'EntryName' from this record model
        """
        return self.get_field_value(self.ENTRYNAME__FIELD_NAME.field_name)

    def set_Formula_field(self, value: Optional[str]):
        """
        Set data field with field name 'Formula' on this record model
        """
        self.set_field_value(self.FORMULA__FIELD_NAME.field_name, value)

    def get_Formula_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Formula' from this record model
        """
        return self.get_field_value(self.FORMULA__FIELD_NAME.field_name)

    def set_RSE_field(self, value: Optional[float]):
        """
        Set data field with field name 'RSE' on this record model
        """
        self.set_field_value(self.RSE__FIELD_NAME.field_name, value)

    def get_RSE_field(self) -> Optional[float]:
        """
        Get data field value with field name 'RSE' from this record model
        """
        return self.get_field_value(self.RSE__FIELD_NAME.field_name)

    def set_RSEDOF_field(self, value: Optional[float]):
        """
        Set data field with field name 'RSEDOF' on this record model
        """
        self.set_field_value(self.RSEDOF__FIELD_NAME.field_name, value)

    def get_RSEDOF_field(self) -> Optional[float]:
        """
        Get data field value with field name 'RSEDOF' from this record model
        """
        return self.get_field_value(self.RSEDOF__FIELD_NAME.field_name)

    def set_RSquared_field(self, value: Optional[float]):
        """
        Set data field with field name 'RSquared' on this record model
        """
        self.set_field_value(self.RSQUARED__FIELD_NAME.field_name, value)

    def get_RSquared_field(self) -> Optional[float]:
        """
        Get data field value with field name 'RSquared' from this record model
        """
        return self.get_field_value(self.RSQUARED__FIELD_NAME.field_name)

    def set_SeriesName_field(self, value: Optional[str]):
        """
        Set data field with field name 'SeriesName' on this record model
        """
        self.set_field_value(self.SERIESNAME__FIELD_NAME.field_name, value)

    def get_SeriesName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SeriesName' from this record model
        """
        return self.get_field_value(self.SERIESNAME__FIELD_NAME.field_name)

    def set_SourceEntryId_field(self, value: Optional[int]):
        """
        Set data field with field name 'SourceEntryId' on this record model
        """
        self.set_field_value(self.SOURCEENTRYID__FIELD_NAME.field_name, value)

    def get_SourceEntryId_field(self) -> Optional[int]:
        """
        Get data field value with field name 'SourceEntryId' from this record model
        """
        return self.get_field_value(self.SOURCEENTRYID__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class ExponentialDecayRegParameterModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type ExponentialDecayRegParameter
    Data Type Display Name: Exponential Decay Regression Parameters (Exponential Decay Regression Parameters)
    Fields: CreatedBy, DataRecordName, DateCreated, DecayRate, Intercept, OriginalAmount, VeloxLastModifiedBy, VeloxLastModifiedDate
    """
    DATA_TYPE_NAME: str = 'ExponentialDecayRegParameter'
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    DECAYRATE__FIELD_NAME: WrapperField = WrapperField("DecayRate", FieldType.DOUBLE)
    INTERCEPT__FIELD_NAME: WrapperField = WrapperField("Intercept", FieldType.DOUBLE)
    ORIGINALAMOUNT__FIELD_NAME: WrapperField = WrapperField("OriginalAmount", FieldType.DOUBLE)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_DecayRate_field(self, value: Optional[float]):
        """
        Set data field with field name 'DecayRate' on this record model
        """
        self.set_field_value(self.DECAYRATE__FIELD_NAME.field_name, value)

    def get_DecayRate_field(self) -> Optional[float]:
        """
        Get data field value with field name 'DecayRate' from this record model
        """
        return self.get_field_value(self.DECAYRATE__FIELD_NAME.field_name)

    def set_Intercept_field(self, value: Optional[float]):
        """
        Set data field with field name 'Intercept' on this record model
        """
        self.set_field_value(self.INTERCEPT__FIELD_NAME.field_name, value)

    def get_Intercept_field(self) -> Optional[float]:
        """
        Get data field value with field name 'Intercept' from this record model
        """
        return self.get_field_value(self.INTERCEPT__FIELD_NAME.field_name)

    def set_OriginalAmount_field(self, value: Optional[float]):
        """
        Set data field with field name 'OriginalAmount' on this record model
        """
        self.set_field_value(self.ORIGINALAMOUNT__FIELD_NAME.field_name, value)

    def get_OriginalAmount_field(self) -> Optional[float]:
        """
        Get data field value with field name 'OriginalAmount' from this record model
        """
        return self.get_field_value(self.ORIGINALAMOUNT__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class FailedSampleDetailsModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type FailedSampleDetails
    Data Type Display Name: Failure Details (Failure Details)
    Fields: ActiveTaskName, ActiveWorkflowName, CreatedBy, DataRecordName, DateCreated, FailureComment, FailureStatus, OtherSampleId, SampleId, VeloxLastModifiedBy, VeloxLastModifiedDate
    """
    DATA_TYPE_NAME: str = 'FailedSampleDetails'
    ACTIVETASKNAME__FIELD_NAME: WrapperField = WrapperField("ActiveTaskName", FieldType.STRING)
    ACTIVEWORKFLOWNAME__FIELD_NAME: WrapperField = WrapperField("ActiveWorkflowName", FieldType.STRING)
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    FAILURECOMMENT__FIELD_NAME: WrapperField = WrapperField("FailureComment", FieldType.STRING)
    FAILURESTATUS__FIELD_NAME: WrapperField = WrapperField("FailureStatus", FieldType.PICKLIST)
    OTHERSAMPLEID__FIELD_NAME: WrapperField = WrapperField("OtherSampleId", FieldType.STRING)
    SAMPLEID__FIELD_NAME: WrapperField = WrapperField("SampleId", FieldType.STRING)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_ActiveTaskName_field(self, value: Optional[str]):
        """
        Set data field with field name 'ActiveTaskName' on this record model
        """
        self.set_field_value(self.ACTIVETASKNAME__FIELD_NAME.field_name, value)

    def get_ActiveTaskName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ActiveTaskName' from this record model
        """
        return self.get_field_value(self.ACTIVETASKNAME__FIELD_NAME.field_name)

    def set_ActiveWorkflowName_field(self, value: Optional[str]):
        """
        Set data field with field name 'ActiveWorkflowName' on this record model
        """
        self.set_field_value(self.ACTIVEWORKFLOWNAME__FIELD_NAME.field_name, value)

    def get_ActiveWorkflowName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ActiveWorkflowName' from this record model
        """
        return self.get_field_value(self.ACTIVEWORKFLOWNAME__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_FailureComment_field(self, value: Optional[str]):
        """
        Set data field with field name 'FailureComment' on this record model
        """
        self.set_field_value(self.FAILURECOMMENT__FIELD_NAME.field_name, value)

    def get_FailureComment_field(self) -> Optional[str]:
        """
        Get data field value with field name 'FailureComment' from this record model
        """
        return self.get_field_value(self.FAILURECOMMENT__FIELD_NAME.field_name)

    def set_FailureStatus_field(self, value: Optional[str]):
        """
        Set data field with field name 'FailureStatus' on this record model
        """
        self.set_field_value(self.FAILURESTATUS__FIELD_NAME.field_name, value)

    def get_FailureStatus_field(self) -> Optional[str]:
        """
        Get data field value with field name 'FailureStatus' from this record model
        """
        return self.get_field_value(self.FAILURESTATUS__FIELD_NAME.field_name)

    def set_OtherSampleId_field(self, value: Optional[str]):
        """
        Set data field with field name 'OtherSampleId' on this record model
        """
        self.set_field_value(self.OTHERSAMPLEID__FIELD_NAME.field_name, value)

    def get_OtherSampleId_field(self) -> Optional[str]:
        """
        Get data field value with field name 'OtherSampleId' from this record model
        """
        return self.get_field_value(self.OTHERSAMPLEID__FIELD_NAME.field_name)

    def set_SampleId_field(self, value: Optional[str]):
        """
        Set data field with field name 'SampleId' on this record model
        """
        self.set_field_value(self.SAMPLEID__FIELD_NAME.field_name, value)

    def get_SampleId_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SampleId' from this record model
        """
        return self.get_field_value(self.SAMPLEID__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class FCSFileModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type FCSFile
    Data Type Display Name: Flow Cytometry Standard File (Flow Cytometry Standard Files)
    Fields: CreatedBy, DataRecordName, DateCreated, FilePath, IsDataComplete, IsMetadataLoaded, IsTopLevel, PercentCellsToParentLevel, PercentCellsToTopLevel, RootFCSRecordId, TotalNumberOfCells, VeloxCurrentVersion, VeloxLastModifiedBy, VeloxLastModifiedDate
    """
    DATA_TYPE_NAME: str = 'FCSFile'
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    FILEPATH__FIELD_NAME: WrapperField = WrapperField("FilePath", FieldType.STRING)
    ISDATACOMPLETE__FIELD_NAME: WrapperField = WrapperField("IsDataComplete", FieldType.BOOLEAN)
    ISMETADATALOADED__FIELD_NAME: WrapperField = WrapperField("IsMetadataLoaded", FieldType.BOOLEAN)
    ISTOPLEVEL__FIELD_NAME: WrapperField = WrapperField("IsTopLevel", FieldType.BOOLEAN)
    PERCENTCELLSTOPARENTLEVEL__FIELD_NAME: WrapperField = WrapperField("PercentCellsToParentLevel", FieldType.DOUBLE)
    PERCENTCELLSTOTOPLEVEL__FIELD_NAME: WrapperField = WrapperField("PercentCellsToTopLevel", FieldType.DOUBLE)
    ROOTFCSRECORDID__FIELD_NAME: WrapperField = WrapperField("RootFCSRecordId", FieldType.LONG)
    TOTALNUMBEROFCELLS__FIELD_NAME: WrapperField = WrapperField("TotalNumberOfCells", FieldType.LONG)
    VELOXCURRENTVERSION__FIELD_NAME: WrapperField = WrapperField("VeloxCurrentVersion", FieldType.INTEGER)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_FilePath_field(self, value: Optional[str]):
        """
        Set data field with field name 'FilePath' on this record model
        """
        self.set_field_value(self.FILEPATH__FIELD_NAME.field_name, value)

    def get_FilePath_field(self) -> Optional[str]:
        """
        Get data field value with field name 'FilePath' from this record model
        """
        return self.get_field_value(self.FILEPATH__FIELD_NAME.field_name)

    def set_IsDataComplete_field(self, value: Optional[bool]):
        """
        Set data field with field name 'IsDataComplete' on this record model
        """
        self.set_field_value(self.ISDATACOMPLETE__FIELD_NAME.field_name, value)

    def get_IsDataComplete_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'IsDataComplete' from this record model
        """
        return self.get_field_value(self.ISDATACOMPLETE__FIELD_NAME.field_name)

    def set_IsMetadataLoaded_field(self, value: Optional[bool]):
        """
        Set data field with field name 'IsMetadataLoaded' on this record model
        """
        self.set_field_value(self.ISMETADATALOADED__FIELD_NAME.field_name, value)

    def get_IsMetadataLoaded_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'IsMetadataLoaded' from this record model
        """
        return self.get_field_value(self.ISMETADATALOADED__FIELD_NAME.field_name)

    def set_IsTopLevel_field(self, value: Optional[bool]):
        """
        Set data field with field name 'IsTopLevel' on this record model
        """
        self.set_field_value(self.ISTOPLEVEL__FIELD_NAME.field_name, value)

    def get_IsTopLevel_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'IsTopLevel' from this record model
        """
        return self.get_field_value(self.ISTOPLEVEL__FIELD_NAME.field_name)

    def set_PercentCellsToParentLevel_field(self, value: Optional[float]):
        """
        Set data field with field name 'PercentCellsToParentLevel' on this record model
        """
        self.set_field_value(self.PERCENTCELLSTOPARENTLEVEL__FIELD_NAME.field_name, value)

    def get_PercentCellsToParentLevel_field(self) -> Optional[float]:
        """
        Get data field value with field name 'PercentCellsToParentLevel' from this record model
        """
        return self.get_field_value(self.PERCENTCELLSTOPARENTLEVEL__FIELD_NAME.field_name)

    def set_PercentCellsToTopLevel_field(self, value: Optional[float]):
        """
        Set data field with field name 'PercentCellsToTopLevel' on this record model
        """
        self.set_field_value(self.PERCENTCELLSTOTOPLEVEL__FIELD_NAME.field_name, value)

    def get_PercentCellsToTopLevel_field(self) -> Optional[float]:
        """
        Get data field value with field name 'PercentCellsToTopLevel' from this record model
        """
        return self.get_field_value(self.PERCENTCELLSTOTOPLEVEL__FIELD_NAME.field_name)

    def set_RootFCSRecordId_field(self, value: Optional[int]):
        """
        Set data field with field name 'RootFCSRecordId' on this record model
        """
        self.set_field_value(self.ROOTFCSRECORDID__FIELD_NAME.field_name, value)

    def get_RootFCSRecordId_field(self) -> Optional[int]:
        """
        Get data field value with field name 'RootFCSRecordId' from this record model
        """
        return self.get_field_value(self.ROOTFCSRECORDID__FIELD_NAME.field_name)

    def set_TotalNumberOfCells_field(self, value: Optional[int]):
        """
        Set data field with field name 'TotalNumberOfCells' on this record model
        """
        self.set_field_value(self.TOTALNUMBEROFCELLS__FIELD_NAME.field_name, value)

    def get_TotalNumberOfCells_field(self) -> Optional[int]:
        """
        Get data field value with field name 'TotalNumberOfCells' from this record model
        """
        return self.get_field_value(self.TOTALNUMBEROFCELLS__FIELD_NAME.field_name)

    def set_VeloxCurrentVersion_field(self, value: Optional[int]):
        """
        Set data field with field name 'VeloxCurrentVersion' on this record model
        """
        self.set_field_value(self.VELOXCURRENTVERSION__FIELD_NAME.field_name, value)

    def get_VeloxCurrentVersion_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxCurrentVersion' from this record model
        """
        return self.get_field_value(self.VELOXCURRENTVERSION__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class FCSStatisticModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type FCSStatistic
    Data Type Display Name: Flow Cytometry Statistic (Flow Cytometry Statistic)
    Fields: ChannelName, CreatedBy, DataRecordName, DateCreated, NumericValue, StatName, VeloxLastModifiedBy, VeloxLastModifiedDate
    A statistic record for FCS file, usually for a specific channel so they are not suited directly added to the FCSFile record.
    """
    DATA_TYPE_NAME: str = 'FCSStatistic'
    CHANNELNAME__FIELD_NAME: WrapperField = WrapperField("ChannelName", FieldType.STRING)
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    NUMERICVALUE__FIELD_NAME: WrapperField = WrapperField("NumericValue", FieldType.DOUBLE)
    STATNAME__FIELD_NAME: WrapperField = WrapperField("StatName", FieldType.STRING)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_ChannelName_field(self, value: Optional[str]):
        """
        Set data field with field name 'ChannelName' on this record model
        """
        self.set_field_value(self.CHANNELNAME__FIELD_NAME.field_name, value)

    def get_ChannelName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ChannelName' from this record model
        """
        return self.get_field_value(self.CHANNELNAME__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_NumericValue_field(self, value: Optional[float]):
        """
        Set data field with field name 'NumericValue' on this record model
        """
        self.set_field_value(self.NUMERICVALUE__FIELD_NAME.field_name, value)

    def get_NumericValue_field(self) -> Optional[float]:
        """
        Get data field value with field name 'NumericValue' from this record model
        """
        return self.get_field_value(self.NUMERICVALUE__FIELD_NAME.field_name)

    def set_StatName_field(self, value: Optional[str]):
        """
        Set data field with field name 'StatName' on this record model
        """
        self.set_field_value(self.STATNAME__FIELD_NAME.field_name, value)

    def get_StatName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'StatName' from this record model
        """
        return self.get_field_value(self.STATNAME__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class FermentationResultModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type FermentationResult
    Data Type Display Name: Fermentation Result (Fermentation Results)
    Fields: AGIT, AIR, CER, CreatedBy, DataRecordName, DateCreated, DO1, LH, O2, OUR, PH, Temperature, TOTFLOW, VeloxLastModifiedBy, VeloxLastModifiedDate
    """
    DATA_TYPE_NAME: str = 'FermentationResult'
    AGIT__FIELD_NAME: WrapperField = WrapperField("AGIT", FieldType.DOUBLE)
    AIR__FIELD_NAME: WrapperField = WrapperField("AIR", FieldType.DOUBLE)
    CER__FIELD_NAME: WrapperField = WrapperField("CER", FieldType.DOUBLE)
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    DO1__FIELD_NAME: WrapperField = WrapperField("DO1", FieldType.DOUBLE)
    LH__FIELD_NAME: WrapperField = WrapperField("LH", FieldType.DOUBLE)
    O2__FIELD_NAME: WrapperField = WrapperField("O2", FieldType.DOUBLE)
    OUR__FIELD_NAME: WrapperField = WrapperField("OUR", FieldType.DOUBLE)
    PH__FIELD_NAME: WrapperField = WrapperField("PH", FieldType.DOUBLE)
    TEMPERATURE__FIELD_NAME: WrapperField = WrapperField("Temperature", FieldType.DOUBLE)
    TOTFLOW__FIELD_NAME: WrapperField = WrapperField("TOTFLOW", FieldType.DOUBLE)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_AGIT_field(self, value: Optional[float]):
        """
        Set data field with field name 'AGIT' on this record model
        """
        self.set_field_value(self.AGIT__FIELD_NAME.field_name, value)

    def get_AGIT_field(self) -> Optional[float]:
        """
        Get data field value with field name 'AGIT' from this record model
        """
        return self.get_field_value(self.AGIT__FIELD_NAME.field_name)

    def set_AIR_field(self, value: Optional[float]):
        """
        Set data field with field name 'AIR' on this record model
        """
        self.set_field_value(self.AIR__FIELD_NAME.field_name, value)

    def get_AIR_field(self) -> Optional[float]:
        """
        Get data field value with field name 'AIR' from this record model
        """
        return self.get_field_value(self.AIR__FIELD_NAME.field_name)

    def set_CER_field(self, value: Optional[float]):
        """
        Set data field with field name 'CER' on this record model
        """
        self.set_field_value(self.CER__FIELD_NAME.field_name, value)

    def get_CER_field(self) -> Optional[float]:
        """
        Get data field value with field name 'CER' from this record model
        """
        return self.get_field_value(self.CER__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_DO1_field(self, value: Optional[float]):
        """
        Set data field with field name 'DO1' on this record model
        """
        self.set_field_value(self.DO1__FIELD_NAME.field_name, value)

    def get_DO1_field(self) -> Optional[float]:
        """
        Get data field value with field name 'DO1' from this record model
        """
        return self.get_field_value(self.DO1__FIELD_NAME.field_name)

    def set_LH_field(self, value: Optional[float]):
        """
        Set data field with field name 'LH' on this record model
        """
        self.set_field_value(self.LH__FIELD_NAME.field_name, value)

    def get_LH_field(self) -> Optional[float]:
        """
        Get data field value with field name 'LH' from this record model
        """
        return self.get_field_value(self.LH__FIELD_NAME.field_name)

    def set_O2_field(self, value: Optional[float]):
        """
        Set data field with field name 'O2' on this record model
        """
        self.set_field_value(self.O2__FIELD_NAME.field_name, value)

    def get_O2_field(self) -> Optional[float]:
        """
        Get data field value with field name 'O2' from this record model
        """
        return self.get_field_value(self.O2__FIELD_NAME.field_name)

    def set_OUR_field(self, value: Optional[float]):
        """
        Set data field with field name 'OUR' on this record model
        """
        self.set_field_value(self.OUR__FIELD_NAME.field_name, value)

    def get_OUR_field(self) -> Optional[float]:
        """
        Get data field value with field name 'OUR' from this record model
        """
        return self.get_field_value(self.OUR__FIELD_NAME.field_name)

    def set_PH_field(self, value: Optional[float]):
        """
        Set data field with field name 'PH' on this record model
        """
        self.set_field_value(self.PH__FIELD_NAME.field_name, value)

    def get_PH_field(self) -> Optional[float]:
        """
        Get data field value with field name 'PH' from this record model
        """
        return self.get_field_value(self.PH__FIELD_NAME.field_name)

    def set_Temperature_field(self, value: Optional[float]):
        """
        Set data field with field name 'Temperature' on this record model
        """
        self.set_field_value(self.TEMPERATURE__FIELD_NAME.field_name, value)

    def get_Temperature_field(self) -> Optional[float]:
        """
        Get data field value with field name 'Temperature' from this record model
        """
        return self.get_field_value(self.TEMPERATURE__FIELD_NAME.field_name)

    def set_TOTFLOW_field(self, value: Optional[float]):
        """
        Set data field with field name 'TOTFLOW' on this record model
        """
        self.set_field_value(self.TOTFLOW__FIELD_NAME.field_name, value)

    def get_TOTFLOW_field(self) -> Optional[float]:
        """
        Get data field value with field name 'TOTFLOW' from this record model
        """
        return self.get_field_value(self.TOTFLOW__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class FileBridgeConnectionModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type FileBridgeConnection
    Data Type Display Name: File Bridge Connection (File Bridge Connections)
    Fields: AesKey, AgentRoot, AuthToken, ConnectionName, CreatedBy, DataRecordName, DateCreated, ProxyHost, ProxyPort, VeloxLastModifiedBy, VeloxLastModifiedDate
    This data type describes the configuration of a File Bridge Connection to be used by Exemplar.
    """
    DATA_TYPE_NAME: str = 'FileBridgeConnection'
    AESKEY__FIELD_NAME: WrapperField = WrapperField("AesKey", FieldType.STRING)
    AGENTROOT__FIELD_NAME: WrapperField = WrapperField("AgentRoot", FieldType.STRING)
    AUTHTOKEN__FIELD_NAME: WrapperField = WrapperField("AuthToken", FieldType.STRING)
    CONNECTIONNAME__FIELD_NAME: WrapperField = WrapperField("ConnectionName", FieldType.STRING)
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    PROXYHOST__FIELD_NAME: WrapperField = WrapperField("ProxyHost", FieldType.STRING)
    PROXYPORT__FIELD_NAME: WrapperField = WrapperField("ProxyPort", FieldType.INTEGER)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_AesKey_field(self, value: Optional[str]):
        """
        Set data field with field name 'AesKey' on this record model
        """
        self.set_field_value(self.AESKEY__FIELD_NAME.field_name, value)

    def get_AesKey_field(self) -> Optional[str]:
        """
        Get data field value with field name 'AesKey' from this record model
        """
        return self.get_field_value(self.AESKEY__FIELD_NAME.field_name)

    def set_AgentRoot_field(self, value: Optional[str]):
        """
        Set data field with field name 'AgentRoot' on this record model
        """
        self.set_field_value(self.AGENTROOT__FIELD_NAME.field_name, value)

    def get_AgentRoot_field(self) -> Optional[str]:
        """
        Get data field value with field name 'AgentRoot' from this record model
        """
        return self.get_field_value(self.AGENTROOT__FIELD_NAME.field_name)

    def set_AuthToken_field(self, value: Optional[str]):
        """
        Set data field with field name 'AuthToken' on this record model
        """
        self.set_field_value(self.AUTHTOKEN__FIELD_NAME.field_name, value)

    def get_AuthToken_field(self) -> Optional[str]:
        """
        Get data field value with field name 'AuthToken' from this record model
        """
        return self.get_field_value(self.AUTHTOKEN__FIELD_NAME.field_name)

    def set_ConnectionName_field(self, value: Optional[str]):
        """
        Set data field with field name 'ConnectionName' on this record model
        """
        self.set_field_value(self.CONNECTIONNAME__FIELD_NAME.field_name, value)

    def get_ConnectionName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ConnectionName' from this record model
        """
        return self.get_field_value(self.CONNECTIONNAME__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_ProxyHost_field(self, value: Optional[str]):
        """
        Set data field with field name 'ProxyHost' on this record model
        """
        self.set_field_value(self.PROXYHOST__FIELD_NAME.field_name, value)

    def get_ProxyHost_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ProxyHost' from this record model
        """
        return self.get_field_value(self.PROXYHOST__FIELD_NAME.field_name)

    def set_ProxyPort_field(self, value: Optional[int]):
        """
        Set data field with field name 'ProxyPort' on this record model
        """
        self.set_field_value(self.PROXYPORT__FIELD_NAME.field_name, value)

    def get_ProxyPort_field(self) -> Optional[int]:
        """
        Get data field value with field name 'ProxyPort' from this record model
        """
        return self.get_field_value(self.PROXYPORT__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class FlowAIRunResultModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type FlowAIRunResult
    Data Type Display Name: FlowAI Run result (FlowAI Run Results)
    Fields: alphaFR, CreatedBy, DataRecordName, DateCreated, decompFR, FilePath, max_cptFS, outlier_binsFS, pen_valueFS, second_fractionFR, sideFM, VeloxCurrentVersion, VeloxLastModifiedBy, VeloxLastModifiedDate
    """
    DATA_TYPE_NAME: str = 'FlowAIRunResult'
    ALPHAFR__FIELD_NAME: WrapperField = WrapperField("alphaFR", FieldType.DOUBLE)
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    DECOMPFR__FIELD_NAME: WrapperField = WrapperField("decompFR", FieldType.BOOLEAN)
    FILEPATH__FIELD_NAME: WrapperField = WrapperField("FilePath", FieldType.STRING)
    MAX_CPTFS__FIELD_NAME: WrapperField = WrapperField("max_cptFS", FieldType.INTEGER)
    OUTLIER_BINSFS__FIELD_NAME: WrapperField = WrapperField("outlier_binsFS", FieldType.BOOLEAN)
    PEN_VALUEFS__FIELD_NAME: WrapperField = WrapperField("pen_valueFS", FieldType.STRING)
    SECOND_FRACTIONFR__FIELD_NAME: WrapperField = WrapperField("second_fractionFR", FieldType.DOUBLE)
    SIDEFM__FIELD_NAME: WrapperField = WrapperField("sideFM", FieldType.PICKLIST)
    VELOXCURRENTVERSION__FIELD_NAME: WrapperField = WrapperField("VeloxCurrentVersion", FieldType.INTEGER)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_alphaFR_field(self, value: Optional[float]):
        """
        Set data field with field name 'alphaFR' on this record model
        """
        self.set_field_value(self.ALPHAFR__FIELD_NAME.field_name, value)

    def get_alphaFR_field(self) -> Optional[float]:
        """
        Get data field value with field name 'alphaFR' from this record model
        """
        return self.get_field_value(self.ALPHAFR__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_decompFR_field(self, value: Optional[bool]):
        """
        Set data field with field name 'decompFR' on this record model
        """
        self.set_field_value(self.DECOMPFR__FIELD_NAME.field_name, value)

    def get_decompFR_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'decompFR' from this record model
        """
        return self.get_field_value(self.DECOMPFR__FIELD_NAME.field_name)

    def set_FilePath_field(self, value: Optional[str]):
        """
        Set data field with field name 'FilePath' on this record model
        """
        self.set_field_value(self.FILEPATH__FIELD_NAME.field_name, value)

    def get_FilePath_field(self) -> Optional[str]:
        """
        Get data field value with field name 'FilePath' from this record model
        """
        return self.get_field_value(self.FILEPATH__FIELD_NAME.field_name)

    def set_max_cptFS_field(self, value: Optional[int]):
        """
        Set data field with field name 'max_cptFS' on this record model
        """
        self.set_field_value(self.MAX_CPTFS__FIELD_NAME.field_name, value)

    def get_max_cptFS_field(self) -> Optional[int]:
        """
        Get data field value with field name 'max_cptFS' from this record model
        """
        return self.get_field_value(self.MAX_CPTFS__FIELD_NAME.field_name)

    def set_outlier_binsFS_field(self, value: Optional[bool]):
        """
        Set data field with field name 'outlier_binsFS' on this record model
        """
        self.set_field_value(self.OUTLIER_BINSFS__FIELD_NAME.field_name, value)

    def get_outlier_binsFS_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'outlier_binsFS' from this record model
        """
        return self.get_field_value(self.OUTLIER_BINSFS__FIELD_NAME.field_name)

    def set_pen_valueFS_field(self, value: Optional[str]):
        """
        Set data field with field name 'pen_valueFS' on this record model
        """
        self.set_field_value(self.PEN_VALUEFS__FIELD_NAME.field_name, value)

    def get_pen_valueFS_field(self) -> Optional[str]:
        """
        Get data field value with field name 'pen_valueFS' from this record model
        """
        return self.get_field_value(self.PEN_VALUEFS__FIELD_NAME.field_name)

    def set_second_fractionFR_field(self, value: Optional[float]):
        """
        Set data field with field name 'second_fractionFR' on this record model
        """
        self.set_field_value(self.SECOND_FRACTIONFR__FIELD_NAME.field_name, value)

    def get_second_fractionFR_field(self) -> Optional[float]:
        """
        Get data field value with field name 'second_fractionFR' from this record model
        """
        return self.get_field_value(self.SECOND_FRACTIONFR__FIELD_NAME.field_name)

    def set_sideFM_field(self, value: Optional[str]):
        """
        Set data field with field name 'sideFM' on this record model
        """
        self.set_field_value(self.SIDEFM__FIELD_NAME.field_name, value)

    def get_sideFM_field(self) -> Optional[str]:
        """
        Get data field value with field name 'sideFM' from this record model
        """
        return self.get_field_value(self.SIDEFM__FIELD_NAME.field_name)

    def set_VeloxCurrentVersion_field(self, value: Optional[int]):
        """
        Set data field with field name 'VeloxCurrentVersion' on this record model
        """
        self.set_field_value(self.VELOXCURRENTVERSION__FIELD_NAME.field_name, value)

    def get_VeloxCurrentVersion_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxCurrentVersion' from this record model
        """
        return self.get_field_value(self.VELOXCURRENTVERSION__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class FlowCellModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type FlowCell
    Data Type Display Name: Flow Cell (Flow Cells)
    Fields: ColPosition, CreatedBy, DataRecordName, DateCreated, FlowcellId, OccupancyProxyClusterCount, OccupiedClusterCount, PercentOccupied, pfClusterCount, RawClusterCount, RowPosition, StorageLocationBarcode, StorageUnitPath, VeloxLastModifiedBy, VeloxLastModifiedDate
    """
    DATA_TYPE_NAME: str = 'FlowCell'
    COLPOSITION__FIELD_NAME: WrapperField = WrapperField("ColPosition", FieldType.SELECTION)
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    FLOWCELLID__FIELD_NAME: WrapperField = WrapperField("FlowcellId", FieldType.STRING)
    OCCUPANCYPROXYCLUSTERCOUNT__FIELD_NAME: WrapperField = WrapperField("OccupancyProxyClusterCount", FieldType.LONG)
    OCCUPIEDCLUSTERCOUNT__FIELD_NAME: WrapperField = WrapperField("OccupiedClusterCount", FieldType.LONG)
    PERCENTOCCUPIED__FIELD_NAME: WrapperField = WrapperField("PercentOccupied", FieldType.DOUBLE)
    PFCLUSTERCOUNT__FIELD_NAME: WrapperField = WrapperField("pfClusterCount", FieldType.LONG)
    RAWCLUSTERCOUNT__FIELD_NAME: WrapperField = WrapperField("RawClusterCount", FieldType.LONG)
    ROWPOSITION__FIELD_NAME: WrapperField = WrapperField("RowPosition", FieldType.SELECTION)
    STORAGELOCATIONBARCODE__FIELD_NAME: WrapperField = WrapperField("StorageLocationBarcode", FieldType.SELECTION)
    STORAGEUNITPATH__FIELD_NAME: WrapperField = WrapperField("StorageUnitPath", FieldType.STRING)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_ColPosition_field(self, value: Optional[str]):
        """
        Set data field with field name 'ColPosition' on this record model
        """
        self.set_field_value(self.COLPOSITION__FIELD_NAME.field_name, value)

    def get_ColPosition_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ColPosition' from this record model
        """
        return self.get_field_value(self.COLPOSITION__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_FlowcellId_field(self, value: Optional[str]):
        """
        Set data field with field name 'FlowcellId' on this record model
        """
        self.set_field_value(self.FLOWCELLID__FIELD_NAME.field_name, value)

    def get_FlowcellId_field(self) -> Optional[str]:
        """
        Get data field value with field name 'FlowcellId' from this record model
        """
        return self.get_field_value(self.FLOWCELLID__FIELD_NAME.field_name)

    def set_OccupancyProxyClusterCount_field(self, value: Optional[int]):
        """
        Set data field with field name 'OccupancyProxyClusterCount' on this record model
        """
        self.set_field_value(self.OCCUPANCYPROXYCLUSTERCOUNT__FIELD_NAME.field_name, value)

    def get_OccupancyProxyClusterCount_field(self) -> Optional[int]:
        """
        Get data field value with field name 'OccupancyProxyClusterCount' from this record model
        """
        return self.get_field_value(self.OCCUPANCYPROXYCLUSTERCOUNT__FIELD_NAME.field_name)

    def set_OccupiedClusterCount_field(self, value: Optional[int]):
        """
        Set data field with field name 'OccupiedClusterCount' on this record model
        """
        self.set_field_value(self.OCCUPIEDCLUSTERCOUNT__FIELD_NAME.field_name, value)

    def get_OccupiedClusterCount_field(self) -> Optional[int]:
        """
        Get data field value with field name 'OccupiedClusterCount' from this record model
        """
        return self.get_field_value(self.OCCUPIEDCLUSTERCOUNT__FIELD_NAME.field_name)

    def set_PercentOccupied_field(self, value: Optional[float]):
        """
        Set data field with field name 'PercentOccupied' on this record model
        """
        self.set_field_value(self.PERCENTOCCUPIED__FIELD_NAME.field_name, value)

    def get_PercentOccupied_field(self) -> Optional[float]:
        """
        Get data field value with field name 'PercentOccupied' from this record model
        """
        return self.get_field_value(self.PERCENTOCCUPIED__FIELD_NAME.field_name)

    def set_pfClusterCount_field(self, value: Optional[int]):
        """
        Set data field with field name 'pfClusterCount' on this record model
        """
        self.set_field_value(self.PFCLUSTERCOUNT__FIELD_NAME.field_name, value)

    def get_pfClusterCount_field(self) -> Optional[int]:
        """
        Get data field value with field name 'pfClusterCount' from this record model
        """
        return self.get_field_value(self.PFCLUSTERCOUNT__FIELD_NAME.field_name)

    def set_RawClusterCount_field(self, value: Optional[int]):
        """
        Set data field with field name 'RawClusterCount' on this record model
        """
        self.set_field_value(self.RAWCLUSTERCOUNT__FIELD_NAME.field_name, value)

    def get_RawClusterCount_field(self) -> Optional[int]:
        """
        Get data field value with field name 'RawClusterCount' from this record model
        """
        return self.get_field_value(self.RAWCLUSTERCOUNT__FIELD_NAME.field_name)

    def set_RowPosition_field(self, value: Optional[str]):
        """
        Set data field with field name 'RowPosition' on this record model
        """
        self.set_field_value(self.ROWPOSITION__FIELD_NAME.field_name, value)

    def get_RowPosition_field(self) -> Optional[str]:
        """
        Get data field value with field name 'RowPosition' from this record model
        """
        return self.get_field_value(self.ROWPOSITION__FIELD_NAME.field_name)

    def set_StorageLocationBarcode_field(self, value: Optional[str]):
        """
        Set data field with field name 'StorageLocationBarcode' on this record model
        """
        self.set_field_value(self.STORAGELOCATIONBARCODE__FIELD_NAME.field_name, value)

    def get_StorageLocationBarcode_field(self) -> Optional[str]:
        """
        Get data field value with field name 'StorageLocationBarcode' from this record model
        """
        return self.get_field_value(self.STORAGELOCATIONBARCODE__FIELD_NAME.field_name)

    def set_StorageUnitPath_field(self, value: Optional[str]):
        """
        Set data field with field name 'StorageUnitPath' on this record model
        """
        self.set_field_value(self.STORAGEUNITPATH__FIELD_NAME.field_name, value)

    def get_StorageUnitPath_field(self) -> Optional[str]:
        """
        Get data field value with field name 'StorageUnitPath' from this record model
        """
        return self.get_field_value(self.STORAGEUNITPATH__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class FlowCellLaneModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type FlowCellLane
    Data Type Display Name: Flow Cell Lane (Flow Cell Lanes)
    Fields: CreatedBy, DataRecordName, DateCreated, ExpRecId, FlowcellId, LaneNum, MultiParentLink215, VeloxLastModifiedBy, VeloxLastModifiedDate
    """
    DATA_TYPE_NAME: str = 'FlowCellLane'
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    EXPRECID__FIELD_NAME: WrapperField = WrapperField("ExpRecId", FieldType.LONG)
    FLOWCELLID__FIELD_NAME: WrapperField = WrapperField("FlowcellId", FieldType.STRING)
    LANENUM__FIELD_NAME: WrapperField = WrapperField("LaneNum", FieldType.LONG)
    MULTIPARENTLINK215__FIELD_NAME: WrapperField = WrapperField("MultiParentLink215", FieldType.MULTIPARENTLINK)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_ExpRecId_field(self, value: Optional[int]):
        """
        Set data field with field name 'ExpRecId' on this record model
        """
        self.set_field_value(self.EXPRECID__FIELD_NAME.field_name, value)

    def get_ExpRecId_field(self) -> Optional[int]:
        """
        Get data field value with field name 'ExpRecId' from this record model
        """
        return self.get_field_value(self.EXPRECID__FIELD_NAME.field_name)

    def set_FlowcellId_field(self, value: Optional[str]):
        """
        Set data field with field name 'FlowcellId' on this record model
        """
        self.set_field_value(self.FLOWCELLID__FIELD_NAME.field_name, value)

    def get_FlowcellId_field(self) -> Optional[str]:
        """
        Get data field value with field name 'FlowcellId' from this record model
        """
        return self.get_field_value(self.FLOWCELLID__FIELD_NAME.field_name)

    def set_LaneNum_field(self, value: Optional[int]):
        """
        Set data field with field name 'LaneNum' on this record model
        """
        self.set_field_value(self.LANENUM__FIELD_NAME.field_name, value)

    def get_LaneNum_field(self) -> Optional[int]:
        """
        Get data field value with field name 'LaneNum' from this record model
        """
        return self.get_field_value(self.LANENUM__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class FlowClustClusterModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type FlowClustCluster
    Data Type Display Name: FlowClust Cluster (FlowClust Clusters)
    Fields: ClusterNum, ColorHTML, ColorName, CreatedBy, DataRecordName, DateCreated, UserAnnotation, VeloxLastModifiedBy, VeloxLastModifiedDate
    """
    DATA_TYPE_NAME: str = 'FlowClustCluster'
    CLUSTERNUM__FIELD_NAME: WrapperField = WrapperField("ClusterNum", FieldType.STRING)
    COLORHTML__FIELD_NAME: WrapperField = WrapperField("ColorHTML", FieldType.STRING)
    COLORNAME__FIELD_NAME: WrapperField = WrapperField("ColorName", FieldType.STRING)
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    USERANNOTATION__FIELD_NAME: WrapperField = WrapperField("UserAnnotation", FieldType.STRING)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_ClusterNum_field(self, value: Optional[str]):
        """
        Set data field with field name 'ClusterNum' on this record model
        """
        self.set_field_value(self.CLUSTERNUM__FIELD_NAME.field_name, value)

    def get_ClusterNum_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ClusterNum' from this record model
        """
        return self.get_field_value(self.CLUSTERNUM__FIELD_NAME.field_name)

    def set_ColorHTML_field(self, value: Optional[str]):
        """
        Set data field with field name 'ColorHTML' on this record model
        """
        self.set_field_value(self.COLORHTML__FIELD_NAME.field_name, value)

    def get_ColorHTML_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ColorHTML' from this record model
        """
        return self.get_field_value(self.COLORHTML__FIELD_NAME.field_name)

    def set_ColorName_field(self, value: Optional[str]):
        """
        Set data field with field name 'ColorName' on this record model
        """
        self.set_field_value(self.COLORNAME__FIELD_NAME.field_name, value)

    def get_ColorName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ColorName' from this record model
        """
        return self.get_field_value(self.COLORNAME__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_UserAnnotation_field(self, value: Optional[str]):
        """
        Set data field with field name 'UserAnnotation' on this record model
        """
        self.set_field_value(self.USERANNOTATION__FIELD_NAME.field_name, value)

    def get_UserAnnotation_field(self) -> Optional[str]:
        """
        Get data field value with field name 'UserAnnotation' from this record model
        """
        return self.get_field_value(self.USERANNOTATION__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class FlowClustConfigModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type FlowClustConfig
    Data Type Display Name: FlowClust Config (FlowClust Configs)
    Fields: BInit, ChannelConfigJSON, ClusterGroupName, CreatedBy, criterion, DataRecordName, DateCreated, FilePath, IsDataComplete, lam, LLevel, maxcount, MaxEMIterations, mincount, nu, nuest, NumberOfClusters, randomStart, seed, tol, tolInit, trans, VeloxCurrentVersion, VeloxLastModifiedBy, VeloxLastModifiedDate, zcutoff
    Sets up a FlowClust clustering package configurations.
    """
    DATA_TYPE_NAME: str = 'FlowClustConfig'
    BINIT__FIELD_NAME: WrapperField = WrapperField("BInit", FieldType.INTEGER)
    CHANNELCONFIGJSON__FIELD_NAME: WrapperField = WrapperField("ChannelConfigJSON", FieldType.STRING)
    CLUSTERGROUPNAME__FIELD_NAME: WrapperField = WrapperField("ClusterGroupName", FieldType.STRING)
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    CRITERION__FIELD_NAME: WrapperField = WrapperField("criterion", FieldType.PICKLIST)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    FILEPATH__FIELD_NAME: WrapperField = WrapperField("FilePath", FieldType.STRING)
    ISDATACOMPLETE__FIELD_NAME: WrapperField = WrapperField("IsDataComplete", FieldType.BOOLEAN)
    LAM__FIELD_NAME: WrapperField = WrapperField("lam", FieldType.DOUBLE)
    LLEVEL__FIELD_NAME: WrapperField = WrapperField("LLevel", FieldType.DOUBLE)
    MAXCOUNT__FIELD_NAME: WrapperField = WrapperField("maxcount", FieldType.INTEGER)
    MAXEMITERATIONS__FIELD_NAME: WrapperField = WrapperField("MaxEMIterations", FieldType.INTEGER)
    MINCOUNT__FIELD_NAME: WrapperField = WrapperField("mincount", FieldType.INTEGER)
    NU__FIELD_NAME: WrapperField = WrapperField("nu", FieldType.INTEGER)
    NUEST__FIELD_NAME: WrapperField = WrapperField("nuest", FieldType.PICKLIST)
    NUMBEROFCLUSTERS__FIELD_NAME: WrapperField = WrapperField("NumberOfClusters", FieldType.INTEGER)
    RANDOMSTART__FIELD_NAME: WrapperField = WrapperField("randomStart", FieldType.INTEGER)
    SEED__FIELD_NAME: WrapperField = WrapperField("seed", FieldType.INTEGER)
    TOL__FIELD_NAME: WrapperField = WrapperField("tol", FieldType.DOUBLE)
    TOLINIT__FIELD_NAME: WrapperField = WrapperField("tolInit", FieldType.DOUBLE)
    TRANS__FIELD_NAME: WrapperField = WrapperField("trans", FieldType.PICKLIST)
    VELOXCURRENTVERSION__FIELD_NAME: WrapperField = WrapperField("VeloxCurrentVersion", FieldType.INTEGER)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)
    ZCUTOFF__FIELD_NAME: WrapperField = WrapperField("zcutoff", FieldType.DOUBLE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_BInit_field(self, value: Optional[int]):
        """
        Set data field with field name 'BInit' on this record model
        """
        self.set_field_value(self.BINIT__FIELD_NAME.field_name, value)

    def get_BInit_field(self) -> Optional[int]:
        """
        Get data field value with field name 'BInit' from this record model
        """
        return self.get_field_value(self.BINIT__FIELD_NAME.field_name)

    def set_ChannelConfigJSON_field(self, value: Optional[str]):
        """
        Set data field with field name 'ChannelConfigJSON' on this record model
        """
        self.set_field_value(self.CHANNELCONFIGJSON__FIELD_NAME.field_name, value)

    def get_ChannelConfigJSON_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ChannelConfigJSON' from this record model
        """
        return self.get_field_value(self.CHANNELCONFIGJSON__FIELD_NAME.field_name)

    def set_ClusterGroupName_field(self, value: Optional[str]):
        """
        Set data field with field name 'ClusterGroupName' on this record model
        """
        self.set_field_value(self.CLUSTERGROUPNAME__FIELD_NAME.field_name, value)

    def get_ClusterGroupName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ClusterGroupName' from this record model
        """
        return self.get_field_value(self.CLUSTERGROUPNAME__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def set_criterion_field(self, value: Optional[str]):
        """
        Set data field with field name 'criterion' on this record model
        """
        self.set_field_value(self.CRITERION__FIELD_NAME.field_name, value)

    def get_criterion_field(self) -> Optional[str]:
        """
        Get data field value with field name 'criterion' from this record model
        """
        return self.get_field_value(self.CRITERION__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_FilePath_field(self, value: Optional[str]):
        """
        Set data field with field name 'FilePath' on this record model
        """
        self.set_field_value(self.FILEPATH__FIELD_NAME.field_name, value)

    def get_FilePath_field(self) -> Optional[str]:
        """
        Get data field value with field name 'FilePath' from this record model
        """
        return self.get_field_value(self.FILEPATH__FIELD_NAME.field_name)

    def set_IsDataComplete_field(self, value: Optional[bool]):
        """
        Set data field with field name 'IsDataComplete' on this record model
        """
        self.set_field_value(self.ISDATACOMPLETE__FIELD_NAME.field_name, value)

    def get_IsDataComplete_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'IsDataComplete' from this record model
        """
        return self.get_field_value(self.ISDATACOMPLETE__FIELD_NAME.field_name)

    def set_lam_field(self, value: Optional[float]):
        """
        Set data field with field name 'lam' on this record model
        """
        self.set_field_value(self.LAM__FIELD_NAME.field_name, value)

    def get_lam_field(self) -> Optional[float]:
        """
        Get data field value with field name 'lam' from this record model
        """
        return self.get_field_value(self.LAM__FIELD_NAME.field_name)

    def set_LLevel_field(self, value: Optional[float]):
        """
        Set data field with field name 'LLevel' on this record model
        """
        self.set_field_value(self.LLEVEL__FIELD_NAME.field_name, value)

    def get_LLevel_field(self) -> Optional[float]:
        """
        Get data field value with field name 'LLevel' from this record model
        """
        return self.get_field_value(self.LLEVEL__FIELD_NAME.field_name)

    def set_maxcount_field(self, value: Optional[int]):
        """
        Set data field with field name 'maxcount' on this record model
        """
        self.set_field_value(self.MAXCOUNT__FIELD_NAME.field_name, value)

    def get_maxcount_field(self) -> Optional[int]:
        """
        Get data field value with field name 'maxcount' from this record model
        """
        return self.get_field_value(self.MAXCOUNT__FIELD_NAME.field_name)

    def set_MaxEMIterations_field(self, value: Optional[int]):
        """
        Set data field with field name 'MaxEMIterations' on this record model
        """
        self.set_field_value(self.MAXEMITERATIONS__FIELD_NAME.field_name, value)

    def get_MaxEMIterations_field(self) -> Optional[int]:
        """
        Get data field value with field name 'MaxEMIterations' from this record model
        """
        return self.get_field_value(self.MAXEMITERATIONS__FIELD_NAME.field_name)

    def set_mincount_field(self, value: Optional[int]):
        """
        Set data field with field name 'mincount' on this record model
        """
        self.set_field_value(self.MINCOUNT__FIELD_NAME.field_name, value)

    def get_mincount_field(self) -> Optional[int]:
        """
        Get data field value with field name 'mincount' from this record model
        """
        return self.get_field_value(self.MINCOUNT__FIELD_NAME.field_name)

    def set_nu_field(self, value: Optional[int]):
        """
        Set data field with field name 'nu' on this record model
        """
        self.set_field_value(self.NU__FIELD_NAME.field_name, value)

    def get_nu_field(self) -> Optional[int]:
        """
        Get data field value with field name 'nu' from this record model
        """
        return self.get_field_value(self.NU__FIELD_NAME.field_name)

    def set_nuest_field(self, value: Optional[str]):
        """
        Set data field with field name 'nuest' on this record model
        """
        self.set_field_value(self.NUEST__FIELD_NAME.field_name, value)

    def get_nuest_field(self) -> Optional[str]:
        """
        Get data field value with field name 'nuest' from this record model
        """
        return self.get_field_value(self.NUEST__FIELD_NAME.field_name)

    def set_NumberOfClusters_field(self, value: Optional[int]):
        """
        Set data field with field name 'NumberOfClusters' on this record model
        """
        self.set_field_value(self.NUMBEROFCLUSTERS__FIELD_NAME.field_name, value)

    def get_NumberOfClusters_field(self) -> Optional[int]:
        """
        Get data field value with field name 'NumberOfClusters' from this record model
        """
        return self.get_field_value(self.NUMBEROFCLUSTERS__FIELD_NAME.field_name)

    def set_randomStart_field(self, value: Optional[int]):
        """
        Set data field with field name 'randomStart' on this record model
        """
        self.set_field_value(self.RANDOMSTART__FIELD_NAME.field_name, value)

    def get_randomStart_field(self) -> Optional[int]:
        """
        Get data field value with field name 'randomStart' from this record model
        """
        return self.get_field_value(self.RANDOMSTART__FIELD_NAME.field_name)

    def set_seed_field(self, value: Optional[int]):
        """
        Set data field with field name 'seed' on this record model
        """
        self.set_field_value(self.SEED__FIELD_NAME.field_name, value)

    def get_seed_field(self) -> Optional[int]:
        """
        Get data field value with field name 'seed' from this record model
        """
        return self.get_field_value(self.SEED__FIELD_NAME.field_name)

    def set_tol_field(self, value: Optional[float]):
        """
        Set data field with field name 'tol' on this record model
        """
        self.set_field_value(self.TOL__FIELD_NAME.field_name, value)

    def get_tol_field(self) -> Optional[float]:
        """
        Get data field value with field name 'tol' from this record model
        """
        return self.get_field_value(self.TOL__FIELD_NAME.field_name)

    def set_tolInit_field(self, value: Optional[float]):
        """
        Set data field with field name 'tolInit' on this record model
        """
        self.set_field_value(self.TOLINIT__FIELD_NAME.field_name, value)

    def get_tolInit_field(self) -> Optional[float]:
        """
        Get data field value with field name 'tolInit' from this record model
        """
        return self.get_field_value(self.TOLINIT__FIELD_NAME.field_name)

    def set_trans_field(self, value: Optional[str]):
        """
        Set data field with field name 'trans' on this record model
        """
        self.set_field_value(self.TRANS__FIELD_NAME.field_name, value)

    def get_trans_field(self) -> Optional[str]:
        """
        Get data field value with field name 'trans' from this record model
        """
        return self.get_field_value(self.TRANS__FIELD_NAME.field_name)

    def set_VeloxCurrentVersion_field(self, value: Optional[int]):
        """
        Set data field with field name 'VeloxCurrentVersion' on this record model
        """
        self.set_field_value(self.VELOXCURRENTVERSION__FIELD_NAME.field_name, value)

    def get_VeloxCurrentVersion_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxCurrentVersion' from this record model
        """
        return self.get_field_value(self.VELOXCURRENTVERSION__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)

    def set_zcutoff_field(self, value: Optional[float]):
        """
        Set data field with field name 'zcutoff' on this record model
        """
        self.set_field_value(self.ZCUTOFF__FIELD_NAME.field_name, value)

    def get_zcutoff_field(self) -> Optional[float]:
        """
        Get data field value with field name 'zcutoff' from this record model
        """
        return self.get_field_value(self.ZCUTOFF__FIELD_NAME.field_name)


class FlowCompensationMatrixDatumModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type FlowCompensationMatrixDatum
    Data Type Display Name: Flow Compensation Matrix Datum (Flow Compensation Matrix Data)
    Fields: ColumnChannelName, ColumnIndex, CompensationValue, CreatedBy, DataRecordName, DateCreated, RowChannelName, RowIndex, VeloxLastModifiedBy, VeloxLastModifiedDate
    Individual flow compensation matrix data value in the matrix.
    """
    DATA_TYPE_NAME: str = 'FlowCompensationMatrixDatum'
    COLUMNCHANNELNAME__FIELD_NAME: WrapperField = WrapperField("ColumnChannelName", FieldType.STRING)
    COLUMNINDEX__FIELD_NAME: WrapperField = WrapperField("ColumnIndex", FieldType.INTEGER)
    COMPENSATIONVALUE__FIELD_NAME: WrapperField = WrapperField("CompensationValue", FieldType.DOUBLE)
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    ROWCHANNELNAME__FIELD_NAME: WrapperField = WrapperField("RowChannelName", FieldType.STRING)
    ROWINDEX__FIELD_NAME: WrapperField = WrapperField("RowIndex", FieldType.INTEGER)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_ColumnChannelName_field(self, value: Optional[str]):
        """
        Set data field with field name 'ColumnChannelName' on this record model
        """
        self.set_field_value(self.COLUMNCHANNELNAME__FIELD_NAME.field_name, value)

    def get_ColumnChannelName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ColumnChannelName' from this record model
        """
        return self.get_field_value(self.COLUMNCHANNELNAME__FIELD_NAME.field_name)

    def set_ColumnIndex_field(self, value: Optional[int]):
        """
        Set data field with field name 'ColumnIndex' on this record model
        """
        self.set_field_value(self.COLUMNINDEX__FIELD_NAME.field_name, value)

    def get_ColumnIndex_field(self) -> Optional[int]:
        """
        Get data field value with field name 'ColumnIndex' from this record model
        """
        return self.get_field_value(self.COLUMNINDEX__FIELD_NAME.field_name)

    def set_CompensationValue_field(self, value: Optional[float]):
        """
        Set data field with field name 'CompensationValue' on this record model
        """
        self.set_field_value(self.COMPENSATIONVALUE__FIELD_NAME.field_name, value)

    def get_CompensationValue_field(self) -> Optional[float]:
        """
        Get data field value with field name 'CompensationValue' from this record model
        """
        return self.get_field_value(self.COMPENSATIONVALUE__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_RowChannelName_field(self, value: Optional[str]):
        """
        Set data field with field name 'RowChannelName' on this record model
        """
        self.set_field_value(self.ROWCHANNELNAME__FIELD_NAME.field_name, value)

    def get_RowChannelName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'RowChannelName' from this record model
        """
        return self.get_field_value(self.ROWCHANNELNAME__FIELD_NAME.field_name)

    def set_RowIndex_field(self, value: Optional[int]):
        """
        Set data field with field name 'RowIndex' on this record model
        """
        self.set_field_value(self.ROWINDEX__FIELD_NAME.field_name, value)

    def get_RowIndex_field(self) -> Optional[int]:
        """
        Get data field value with field name 'RowIndex' from this record model
        """
        return self.get_field_value(self.ROWINDEX__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class FlowCompensationMatrixInfoModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type FlowCompensationMatrixInfo
    Data Type Display Name: Flow Compensation Matrix Info (Flow Compensation Matrix Info)
    Fields: ChannelNameList, CreatedBy, DataRecordName, DateCreated, Emedded, MatrixName, VeloxLastModifiedBy, VeloxLastModifiedDate
    Contains the info about the matrix itself.

The parents of this matrix are those that are used to create this info file. There can be more than one parent.

This is not directly linked to children FCS files. It will be linked through FlowCompMatrixApplication type.
    """
    DATA_TYPE_NAME: str = 'FlowCompensationMatrixInfo'
    CHANNELNAMELIST__FIELD_NAME: WrapperField = WrapperField("ChannelNameList", FieldType.STRING)
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    EMEDDED__FIELD_NAME: WrapperField = WrapperField("Emedded", FieldType.BOOLEAN)
    MATRIXNAME__FIELD_NAME: WrapperField = WrapperField("MatrixName", FieldType.STRING)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_ChannelNameList_field(self, value: Optional[str]):
        """
        Set data field with field name 'ChannelNameList' on this record model
        """
        self.set_field_value(self.CHANNELNAMELIST__FIELD_NAME.field_name, value)

    def get_ChannelNameList_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ChannelNameList' from this record model
        """
        return self.get_field_value(self.CHANNELNAMELIST__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_Emedded_field(self, value: Optional[bool]):
        """
        Set data field with field name 'Emedded' on this record model
        """
        self.set_field_value(self.EMEDDED__FIELD_NAME.field_name, value)

    def get_Emedded_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'Emedded' from this record model
        """
        return self.get_field_value(self.EMEDDED__FIELD_NAME.field_name)

    def set_MatrixName_field(self, value: Optional[str]):
        """
        Set data field with field name 'MatrixName' on this record model
        """
        self.set_field_value(self.MATRIXNAME__FIELD_NAME.field_name, value)

    def get_MatrixName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'MatrixName' from this record model
        """
        return self.get_field_value(self.MATRIXNAME__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class FlowCompMatrixApplicationModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type FlowCompMatrixApplication
    Data Type Display Name: Flow Comp Matrix Application (Flow Comp Matrix Applications)
    Fields: CreatedBy, DataRecordName, DateCreated, Emedded, MatrixInfoRecordId, VeloxLastModifiedBy, VeloxLastModifiedDate
    Apply a flow cyto compensation matrix for a target (parent FCS) file, against a matrix info.
    """
    DATA_TYPE_NAME: str = 'FlowCompMatrixApplication'
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    EMEDDED__FIELD_NAME: WrapperField = WrapperField("Emedded", FieldType.BOOLEAN)
    MATRIXINFORECORDID__FIELD_NAME: WrapperField = WrapperField("MatrixInfoRecordId", FieldType.LONG)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_Emedded_field(self, value: Optional[bool]):
        """
        Set data field with field name 'Emedded' on this record model
        """
        self.set_field_value(self.EMEDDED__FIELD_NAME.field_name, value)

    def get_Emedded_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'Emedded' from this record model
        """
        return self.get_field_value(self.EMEDDED__FIELD_NAME.field_name)

    def set_MatrixInfoRecordId_field(self, value: Optional[int]):
        """
        Set data field with field name 'MatrixInfoRecordId' on this record model
        """
        self.set_field_value(self.MATRIXINFORECORDID__FIELD_NAME.field_name, value)

    def get_MatrixInfoRecordId_field(self) -> Optional[int]:
        """
        Get data field value with field name 'MatrixInfoRecordId' from this record model
        """
        return self.get_field_value(self.MATRIXINFORECORDID__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class FlowCytoFileTemplateModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type FlowCytoFileTemplate
    Data Type Display Name: Flow Cyto File Template (Flow Cyto File Templates)
    Fields: CreatedBy, DataRecordName, DateCreated, TemplateData, TemplateDescription, TemplateName, VeloxLastModifiedBy, VeloxLastModifiedDate
    Describes a saved gating and compensation strategy for a flow cytometry file.
    """
    DATA_TYPE_NAME: str = 'FlowCytoFileTemplate'
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    TEMPLATEDATA__FIELD_NAME: WrapperField = WrapperField("TemplateData", FieldType.STRING)
    TEMPLATEDESCRIPTION__FIELD_NAME: WrapperField = WrapperField("TemplateDescription", FieldType.STRING)
    TEMPLATENAME__FIELD_NAME: WrapperField = WrapperField("TemplateName", FieldType.STRING)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_TemplateData_field(self, value: Optional[str]):
        """
        Set data field with field name 'TemplateData' on this record model
        """
        self.set_field_value(self.TEMPLATEDATA__FIELD_NAME.field_name, value)

    def get_TemplateData_field(self) -> Optional[str]:
        """
        Get data field value with field name 'TemplateData' from this record model
        """
        return self.get_field_value(self.TEMPLATEDATA__FIELD_NAME.field_name)

    def set_TemplateDescription_field(self, value: Optional[str]):
        """
        Set data field with field name 'TemplateDescription' on this record model
        """
        self.set_field_value(self.TEMPLATEDESCRIPTION__FIELD_NAME.field_name, value)

    def get_TemplateDescription_field(self) -> Optional[str]:
        """
        Get data field value with field name 'TemplateDescription' from this record model
        """
        return self.get_field_value(self.TEMPLATEDESCRIPTION__FIELD_NAME.field_name)

    def set_TemplateName_field(self, value: Optional[str]):
        """
        Set data field with field name 'TemplateName' on this record model
        """
        self.set_field_value(self.TEMPLATENAME__FIELD_NAME.field_name, value)

    def get_TemplateName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'TemplateName' from this record model
        """
        return self.get_field_value(self.TEMPLATENAME__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class FlowCytometryChannelInfoModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type FlowCytometryChannelInfo
    Data Type Display Name: Flow Cytometry Channel Info (Flow Cytometry Channel Info)
    Fields: Annotation, AxisMax, AxisMin, AxisRange, ChannelName, CreatedBy, DataRecordName, DateCreated, TransformDenominator, TransformGML2A, TransformGML2B, TransformGML2C, TransformGML2M, TransformGML2T, TransformGML2W, TransformLogicleA, TransformLogicleM, TransformLogicleTop, TransformLogicleW, TransformMethod, TransformNumerator, TransformVarA, TransformVarB, VeloxLastModifiedBy, VeloxLastModifiedDate
    """
    DATA_TYPE_NAME: str = 'FlowCytometryChannelInfo'
    ANNOTATION__FIELD_NAME: WrapperField = WrapperField("Annotation", FieldType.STRING)
    AXISMAX__FIELD_NAME: WrapperField = WrapperField("AxisMax", FieldType.DOUBLE)
    AXISMIN__FIELD_NAME: WrapperField = WrapperField("AxisMin", FieldType.DOUBLE)
    AXISRANGE__FIELD_NAME: WrapperField = WrapperField("AxisRange", FieldType.DOUBLE)
    CHANNELNAME__FIELD_NAME: WrapperField = WrapperField("ChannelName", FieldType.STRING)
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    TRANSFORMDENOMINATOR__FIELD_NAME: WrapperField = WrapperField("TransformDenominator", FieldType.STRING)
    TRANSFORMGML2A__FIELD_NAME: WrapperField = WrapperField("TransformGML2A", FieldType.DOUBLE)
    TRANSFORMGML2B__FIELD_NAME: WrapperField = WrapperField("TransformGML2B", FieldType.DOUBLE)
    TRANSFORMGML2C__FIELD_NAME: WrapperField = WrapperField("TransformGML2C", FieldType.DOUBLE)
    TRANSFORMGML2M__FIELD_NAME: WrapperField = WrapperField("TransformGML2M", FieldType.DOUBLE)
    TRANSFORMGML2T__FIELD_NAME: WrapperField = WrapperField("TransformGML2T", FieldType.DOUBLE)
    TRANSFORMGML2W__FIELD_NAME: WrapperField = WrapperField("TransformGML2W", FieldType.DOUBLE)
    TRANSFORMLOGICLEA__FIELD_NAME: WrapperField = WrapperField("TransformLogicleA", FieldType.DOUBLE)
    TRANSFORMLOGICLEM__FIELD_NAME: WrapperField = WrapperField("TransformLogicleM", FieldType.DOUBLE)
    TRANSFORMLOGICLETOP__FIELD_NAME: WrapperField = WrapperField("TransformLogicleTop", FieldType.DOUBLE)
    TRANSFORMLOGICLEW__FIELD_NAME: WrapperField = WrapperField("TransformLogicleW", FieldType.DOUBLE)
    TRANSFORMMETHOD__FIELD_NAME: WrapperField = WrapperField("TransformMethod", FieldType.PICKLIST)
    TRANSFORMNUMERATOR__FIELD_NAME: WrapperField = WrapperField("TransformNumerator", FieldType.STRING)
    TRANSFORMVARA__FIELD_NAME: WrapperField = WrapperField("TransformVarA", FieldType.DOUBLE)
    TRANSFORMVARB__FIELD_NAME: WrapperField = WrapperField("TransformVarB", FieldType.DOUBLE)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_Annotation_field(self, value: Optional[str]):
        """
        Set data field with field name 'Annotation' on this record model
        """
        self.set_field_value(self.ANNOTATION__FIELD_NAME.field_name, value)

    def get_Annotation_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Annotation' from this record model
        """
        return self.get_field_value(self.ANNOTATION__FIELD_NAME.field_name)

    def set_AxisMax_field(self, value: Optional[float]):
        """
        Set data field with field name 'AxisMax' on this record model
        """
        self.set_field_value(self.AXISMAX__FIELD_NAME.field_name, value)

    def get_AxisMax_field(self) -> Optional[float]:
        """
        Get data field value with field name 'AxisMax' from this record model
        """
        return self.get_field_value(self.AXISMAX__FIELD_NAME.field_name)

    def set_AxisMin_field(self, value: Optional[float]):
        """
        Set data field with field name 'AxisMin' on this record model
        """
        self.set_field_value(self.AXISMIN__FIELD_NAME.field_name, value)

    def get_AxisMin_field(self) -> Optional[float]:
        """
        Get data field value with field name 'AxisMin' from this record model
        """
        return self.get_field_value(self.AXISMIN__FIELD_NAME.field_name)

    def set_AxisRange_field(self, value: Optional[float]):
        """
        Set data field with field name 'AxisRange' on this record model
        """
        self.set_field_value(self.AXISRANGE__FIELD_NAME.field_name, value)

    def get_AxisRange_field(self) -> Optional[float]:
        """
        Get data field value with field name 'AxisRange' from this record model
        """
        return self.get_field_value(self.AXISRANGE__FIELD_NAME.field_name)

    def set_ChannelName_field(self, value: Optional[str]):
        """
        Set data field with field name 'ChannelName' on this record model
        """
        self.set_field_value(self.CHANNELNAME__FIELD_NAME.field_name, value)

    def get_ChannelName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ChannelName' from this record model
        """
        return self.get_field_value(self.CHANNELNAME__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_TransformDenominator_field(self, value: Optional[str]):
        """
        Set data field with field name 'TransformDenominator' on this record model
        """
        self.set_field_value(self.TRANSFORMDENOMINATOR__FIELD_NAME.field_name, value)

    def get_TransformDenominator_field(self) -> Optional[str]:
        """
        Get data field value with field name 'TransformDenominator' from this record model
        """
        return self.get_field_value(self.TRANSFORMDENOMINATOR__FIELD_NAME.field_name)

    def set_TransformGML2A_field(self, value: Optional[float]):
        """
        Set data field with field name 'TransformGML2A' on this record model
        """
        self.set_field_value(self.TRANSFORMGML2A__FIELD_NAME.field_name, value)

    def get_TransformGML2A_field(self) -> Optional[float]:
        """
        Get data field value with field name 'TransformGML2A' from this record model
        """
        return self.get_field_value(self.TRANSFORMGML2A__FIELD_NAME.field_name)

    def set_TransformGML2B_field(self, value: Optional[float]):
        """
        Set data field with field name 'TransformGML2B' on this record model
        """
        self.set_field_value(self.TRANSFORMGML2B__FIELD_NAME.field_name, value)

    def get_TransformGML2B_field(self) -> Optional[float]:
        """
        Get data field value with field name 'TransformGML2B' from this record model
        """
        return self.get_field_value(self.TRANSFORMGML2B__FIELD_NAME.field_name)

    def set_TransformGML2C_field(self, value: Optional[float]):
        """
        Set data field with field name 'TransformGML2C' on this record model
        """
        self.set_field_value(self.TRANSFORMGML2C__FIELD_NAME.field_name, value)

    def get_TransformGML2C_field(self) -> Optional[float]:
        """
        Get data field value with field name 'TransformGML2C' from this record model
        """
        return self.get_field_value(self.TRANSFORMGML2C__FIELD_NAME.field_name)

    def set_TransformGML2M_field(self, value: Optional[float]):
        """
        Set data field with field name 'TransformGML2M' on this record model
        """
        self.set_field_value(self.TRANSFORMGML2M__FIELD_NAME.field_name, value)

    def get_TransformGML2M_field(self) -> Optional[float]:
        """
        Get data field value with field name 'TransformGML2M' from this record model
        """
        return self.get_field_value(self.TRANSFORMGML2M__FIELD_NAME.field_name)

    def set_TransformGML2T_field(self, value: Optional[float]):
        """
        Set data field with field name 'TransformGML2T' on this record model
        """
        self.set_field_value(self.TRANSFORMGML2T__FIELD_NAME.field_name, value)

    def get_TransformGML2T_field(self) -> Optional[float]:
        """
        Get data field value with field name 'TransformGML2T' from this record model
        """
        return self.get_field_value(self.TRANSFORMGML2T__FIELD_NAME.field_name)

    def set_TransformGML2W_field(self, value: Optional[float]):
        """
        Set data field with field name 'TransformGML2W' on this record model
        """
        self.set_field_value(self.TRANSFORMGML2W__FIELD_NAME.field_name, value)

    def get_TransformGML2W_field(self) -> Optional[float]:
        """
        Get data field value with field name 'TransformGML2W' from this record model
        """
        return self.get_field_value(self.TRANSFORMGML2W__FIELD_NAME.field_name)

    def set_TransformLogicleA_field(self, value: Optional[float]):
        """
        Set data field with field name 'TransformLogicleA' on this record model
        """
        self.set_field_value(self.TRANSFORMLOGICLEA__FIELD_NAME.field_name, value)

    def get_TransformLogicleA_field(self) -> Optional[float]:
        """
        Get data field value with field name 'TransformLogicleA' from this record model
        """
        return self.get_field_value(self.TRANSFORMLOGICLEA__FIELD_NAME.field_name)

    def set_TransformLogicleM_field(self, value: Optional[float]):
        """
        Set data field with field name 'TransformLogicleM' on this record model
        """
        self.set_field_value(self.TRANSFORMLOGICLEM__FIELD_NAME.field_name, value)

    def get_TransformLogicleM_field(self) -> Optional[float]:
        """
        Get data field value with field name 'TransformLogicleM' from this record model
        """
        return self.get_field_value(self.TRANSFORMLOGICLEM__FIELD_NAME.field_name)

    def set_TransformLogicleTop_field(self, value: Optional[float]):
        """
        Set data field with field name 'TransformLogicleTop' on this record model
        """
        self.set_field_value(self.TRANSFORMLOGICLETOP__FIELD_NAME.field_name, value)

    def get_TransformLogicleTop_field(self) -> Optional[float]:
        """
        Get data field value with field name 'TransformLogicleTop' from this record model
        """
        return self.get_field_value(self.TRANSFORMLOGICLETOP__FIELD_NAME.field_name)

    def set_TransformLogicleW_field(self, value: Optional[float]):
        """
        Set data field with field name 'TransformLogicleW' on this record model
        """
        self.set_field_value(self.TRANSFORMLOGICLEW__FIELD_NAME.field_name, value)

    def get_TransformLogicleW_field(self) -> Optional[float]:
        """
        Get data field value with field name 'TransformLogicleW' from this record model
        """
        return self.get_field_value(self.TRANSFORMLOGICLEW__FIELD_NAME.field_name)

    def set_TransformMethod_field(self, value: Optional[str]):
        """
        Set data field with field name 'TransformMethod' on this record model
        """
        self.set_field_value(self.TRANSFORMMETHOD__FIELD_NAME.field_name, value)

    def get_TransformMethod_field(self) -> Optional[str]:
        """
        Get data field value with field name 'TransformMethod' from this record model
        """
        return self.get_field_value(self.TRANSFORMMETHOD__FIELD_NAME.field_name)

    def set_TransformNumerator_field(self, value: Optional[str]):
        """
        Set data field with field name 'TransformNumerator' on this record model
        """
        self.set_field_value(self.TRANSFORMNUMERATOR__FIELD_NAME.field_name, value)

    def get_TransformNumerator_field(self) -> Optional[str]:
        """
        Get data field value with field name 'TransformNumerator' from this record model
        """
        return self.get_field_value(self.TRANSFORMNUMERATOR__FIELD_NAME.field_name)

    def set_TransformVarA_field(self, value: Optional[float]):
        """
        Set data field with field name 'TransformVarA' on this record model
        """
        self.set_field_value(self.TRANSFORMVARA__FIELD_NAME.field_name, value)

    def get_TransformVarA_field(self) -> Optional[float]:
        """
        Get data field value with field name 'TransformVarA' from this record model
        """
        return self.get_field_value(self.TRANSFORMVARA__FIELD_NAME.field_name)

    def set_TransformVarB_field(self, value: Optional[float]):
        """
        Set data field with field name 'TransformVarB' on this record model
        """
        self.set_field_value(self.TRANSFORMVARB__FIELD_NAME.field_name, value)

    def get_TransformVarB_field(self) -> Optional[float]:
        """
        Get data field value with field name 'TransformVarB' from this record model
        """
        return self.get_field_value(self.TRANSFORMVARB__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class FlowDensityGateModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type FlowDensityGate
    Data Type Display Name: Flow Density Gate (Flow Density Gates)
    Fields: CreatedBy, DataRecordName, DateCreated, IsPositiveX, IsPositiveY, PercentileX, PercentileY, ShapeJSON, UserAnnotation, VeloxLastModifiedBy, VeloxLastModifiedDate, XChannelName, YChannelName
    """
    DATA_TYPE_NAME: str = 'FlowDensityGate'
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    ISPOSITIVEX__FIELD_NAME: WrapperField = WrapperField("IsPositiveX", FieldType.BOOLEAN)
    ISPOSITIVEY__FIELD_NAME: WrapperField = WrapperField("IsPositiveY", FieldType.BOOLEAN)
    PERCENTILEX__FIELD_NAME: WrapperField = WrapperField("PercentileX", FieldType.DOUBLE)
    PERCENTILEY__FIELD_NAME: WrapperField = WrapperField("PercentileY", FieldType.DOUBLE)
    SHAPEJSON__FIELD_NAME: WrapperField = WrapperField("ShapeJSON", FieldType.STRING)
    USERANNOTATION__FIELD_NAME: WrapperField = WrapperField("UserAnnotation", FieldType.STRING)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)
    XCHANNELNAME__FIELD_NAME: WrapperField = WrapperField("XChannelName", FieldType.STRING)
    YCHANNELNAME__FIELD_NAME: WrapperField = WrapperField("YChannelName", FieldType.STRING)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_IsPositiveX_field(self, value: Optional[bool]):
        """
        Set data field with field name 'IsPositiveX' on this record model
        """
        self.set_field_value(self.ISPOSITIVEX__FIELD_NAME.field_name, value)

    def get_IsPositiveX_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'IsPositiveX' from this record model
        """
        return self.get_field_value(self.ISPOSITIVEX__FIELD_NAME.field_name)

    def set_IsPositiveY_field(self, value: Optional[bool]):
        """
        Set data field with field name 'IsPositiveY' on this record model
        """
        self.set_field_value(self.ISPOSITIVEY__FIELD_NAME.field_name, value)

    def get_IsPositiveY_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'IsPositiveY' from this record model
        """
        return self.get_field_value(self.ISPOSITIVEY__FIELD_NAME.field_name)

    def set_PercentileX_field(self, value: Optional[float]):
        """
        Set data field with field name 'PercentileX' on this record model
        """
        self.set_field_value(self.PERCENTILEX__FIELD_NAME.field_name, value)

    def get_PercentileX_field(self) -> Optional[float]:
        """
        Get data field value with field name 'PercentileX' from this record model
        """
        return self.get_field_value(self.PERCENTILEX__FIELD_NAME.field_name)

    def set_PercentileY_field(self, value: Optional[float]):
        """
        Set data field with field name 'PercentileY' on this record model
        """
        self.set_field_value(self.PERCENTILEY__FIELD_NAME.field_name, value)

    def get_PercentileY_field(self) -> Optional[float]:
        """
        Get data field value with field name 'PercentileY' from this record model
        """
        return self.get_field_value(self.PERCENTILEY__FIELD_NAME.field_name)

    def set_ShapeJSON_field(self, value: Optional[str]):
        """
        Set data field with field name 'ShapeJSON' on this record model
        """
        self.set_field_value(self.SHAPEJSON__FIELD_NAME.field_name, value)

    def get_ShapeJSON_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ShapeJSON' from this record model
        """
        return self.get_field_value(self.SHAPEJSON__FIELD_NAME.field_name)

    def set_UserAnnotation_field(self, value: Optional[str]):
        """
        Set data field with field name 'UserAnnotation' on this record model
        """
        self.set_field_value(self.USERANNOTATION__FIELD_NAME.field_name, value)

    def get_UserAnnotation_field(self) -> Optional[str]:
        """
        Get data field value with field name 'UserAnnotation' from this record model
        """
        return self.get_field_value(self.USERANNOTATION__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)

    def set_XChannelName_field(self, value: Optional[str]):
        """
        Set data field with field name 'XChannelName' on this record model
        """
        self.set_field_value(self.XCHANNELNAME__FIELD_NAME.field_name, value)

    def get_XChannelName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'XChannelName' from this record model
        """
        return self.get_field_value(self.XCHANNELNAME__FIELD_NAME.field_name)

    def set_YChannelName_field(self, value: Optional[str]):
        """
        Set data field with field name 'YChannelName' on this record model
        """
        self.set_field_value(self.YCHANNELNAME__FIELD_NAME.field_name, value)

    def get_YChannelName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'YChannelName' from this record model
        """
        return self.get_field_value(self.YCHANNELNAME__FIELD_NAME.field_name)


class FlowDensityGatingStrategyModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type FlowDensityGatingStrategy
    Data Type Display Name: Flow Density Gating Strategy (Flow Density Gating Strategies)
    Fields: CreatedBy, DataRecordName, DateCreated, FilePath, IsEvaluated, IsPositiveX, IsPositiveY, PercentileX, PercentileY, VeloxCurrentVersion, VeloxLastModifiedBy, VeloxLastModifiedDate, XAxisChannel, YAxisChannel
    """
    DATA_TYPE_NAME: str = 'FlowDensityGatingStrategy'
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    FILEPATH__FIELD_NAME: WrapperField = WrapperField("FilePath", FieldType.STRING)
    ISEVALUATED__FIELD_NAME: WrapperField = WrapperField("IsEvaluated", FieldType.BOOLEAN)
    ISPOSITIVEX__FIELD_NAME: WrapperField = WrapperField("IsPositiveX", FieldType.BOOLEAN)
    ISPOSITIVEY__FIELD_NAME: WrapperField = WrapperField("IsPositiveY", FieldType.BOOLEAN)
    PERCENTILEX__FIELD_NAME: WrapperField = WrapperField("PercentileX", FieldType.DOUBLE)
    PERCENTILEY__FIELD_NAME: WrapperField = WrapperField("PercentileY", FieldType.DOUBLE)
    VELOXCURRENTVERSION__FIELD_NAME: WrapperField = WrapperField("VeloxCurrentVersion", FieldType.INTEGER)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)
    XAXISCHANNEL__FIELD_NAME: WrapperField = WrapperField("XAxisChannel", FieldType.SELECTION)
    YAXISCHANNEL__FIELD_NAME: WrapperField = WrapperField("YAxisChannel", FieldType.SELECTION)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_FilePath_field(self, value: Optional[str]):
        """
        Set data field with field name 'FilePath' on this record model
        """
        self.set_field_value(self.FILEPATH__FIELD_NAME.field_name, value)

    def get_FilePath_field(self) -> Optional[str]:
        """
        Get data field value with field name 'FilePath' from this record model
        """
        return self.get_field_value(self.FILEPATH__FIELD_NAME.field_name)

    def set_IsEvaluated_field(self, value: Optional[bool]):
        """
        Set data field with field name 'IsEvaluated' on this record model
        """
        self.set_field_value(self.ISEVALUATED__FIELD_NAME.field_name, value)

    def get_IsEvaluated_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'IsEvaluated' from this record model
        """
        return self.get_field_value(self.ISEVALUATED__FIELD_NAME.field_name)

    def set_IsPositiveX_field(self, value: Optional[bool]):
        """
        Set data field with field name 'IsPositiveX' on this record model
        """
        self.set_field_value(self.ISPOSITIVEX__FIELD_NAME.field_name, value)

    def get_IsPositiveX_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'IsPositiveX' from this record model
        """
        return self.get_field_value(self.ISPOSITIVEX__FIELD_NAME.field_name)

    def set_IsPositiveY_field(self, value: Optional[bool]):
        """
        Set data field with field name 'IsPositiveY' on this record model
        """
        self.set_field_value(self.ISPOSITIVEY__FIELD_NAME.field_name, value)

    def get_IsPositiveY_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'IsPositiveY' from this record model
        """
        return self.get_field_value(self.ISPOSITIVEY__FIELD_NAME.field_name)

    def set_PercentileX_field(self, value: Optional[float]):
        """
        Set data field with field name 'PercentileX' on this record model
        """
        self.set_field_value(self.PERCENTILEX__FIELD_NAME.field_name, value)

    def get_PercentileX_field(self) -> Optional[float]:
        """
        Get data field value with field name 'PercentileX' from this record model
        """
        return self.get_field_value(self.PERCENTILEX__FIELD_NAME.field_name)

    def set_PercentileY_field(self, value: Optional[float]):
        """
        Set data field with field name 'PercentileY' on this record model
        """
        self.set_field_value(self.PERCENTILEY__FIELD_NAME.field_name, value)

    def get_PercentileY_field(self) -> Optional[float]:
        """
        Get data field value with field name 'PercentileY' from this record model
        """
        return self.get_field_value(self.PERCENTILEY__FIELD_NAME.field_name)

    def set_VeloxCurrentVersion_field(self, value: Optional[int]):
        """
        Set data field with field name 'VeloxCurrentVersion' on this record model
        """
        self.set_field_value(self.VELOXCURRENTVERSION__FIELD_NAME.field_name, value)

    def get_VeloxCurrentVersion_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxCurrentVersion' from this record model
        """
        return self.get_field_value(self.VELOXCURRENTVERSION__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)

    def set_XAxisChannel_field(self, value: Optional[str]):
        """
        Set data field with field name 'XAxisChannel' on this record model
        """
        self.set_field_value(self.XAXISCHANNEL__FIELD_NAME.field_name, value)

    def get_XAxisChannel_field(self) -> Optional[str]:
        """
        Get data field value with field name 'XAxisChannel' from this record model
        """
        return self.get_field_value(self.XAXISCHANNEL__FIELD_NAME.field_name)

    def set_YAxisChannel_field(self, value: Optional[str]):
        """
        Set data field with field name 'YAxisChannel' on this record model
        """
        self.set_field_value(self.YAXISCHANNEL__FIELD_NAME.field_name, value)

    def get_YAxisChannel_field(self) -> Optional[str]:
        """
        Get data field value with field name 'YAxisChannel' from this record model
        """
        return self.get_field_value(self.YAXISCHANNEL__FIELD_NAME.field_name)


class FlowJoWorkspaceFileModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type FlowJoWorkspaceFile
    Data Type Display Name: FlowJo Workspace File (FlowJo Workspace Files)
    Fields: CreatedBy, DataRecordName, DateCreated, FilePath, VeloxCurrentVersion, VeloxLastModifiedBy, VeloxLastModifiedDate
    The raw FlowJo workspace file, in wsp format. Sapio does not use this directly after parsing the root. The workspace file here is for archival purpose.
    """
    DATA_TYPE_NAME: str = 'FlowJoWorkspaceFile'
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    FILEPATH__FIELD_NAME: WrapperField = WrapperField("FilePath", FieldType.STRING)
    VELOXCURRENTVERSION__FIELD_NAME: WrapperField = WrapperField("VeloxCurrentVersion", FieldType.INTEGER)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_FilePath_field(self, value: Optional[str]):
        """
        Set data field with field name 'FilePath' on this record model
        """
        self.set_field_value(self.FILEPATH__FIELD_NAME.field_name, value)

    def get_FilePath_field(self) -> Optional[str]:
        """
        Get data field value with field name 'FilePath' from this record model
        """
        return self.get_field_value(self.FILEPATH__FIELD_NAME.field_name)

    def set_VeloxCurrentVersion_field(self, value: Optional[int]):
        """
        Set data field with field name 'VeloxCurrentVersion' on this record model
        """
        self.set_field_value(self.VELOXCURRENTVERSION__FIELD_NAME.field_name, value)

    def get_VeloxCurrentVersion_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxCurrentVersion' from this record model
        """
        return self.get_field_value(self.VELOXCURRENTVERSION__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class FlowJoWorkspaceGroupModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type FlowJoWorkspaceGroup
    Data Type Display Name: FlowJo Workspace Group (FlowJo Workspace Groups)
    Fields: CreatedBy, DataLoadComplete, DataRecordName, DateCreated, FilePath, GroupName, VeloxCurrentVersion, VeloxLastModifiedBy, VeloxLastModifiedDate
    A group in FlowJo workspace may contain zero, one, or more samples. Each group can have a separate gating hierarchy.
Processing for a group is completed when all samples have been found and processed.
    """
    DATA_TYPE_NAME: str = 'FlowJoWorkspaceGroup'
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATALOADCOMPLETE__FIELD_NAME: WrapperField = WrapperField("DataLoadComplete", FieldType.BOOLEAN)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    FILEPATH__FIELD_NAME: WrapperField = WrapperField("FilePath", FieldType.STRING)
    GROUPNAME__FIELD_NAME: WrapperField = WrapperField("GroupName", FieldType.STRING)
    VELOXCURRENTVERSION__FIELD_NAME: WrapperField = WrapperField("VeloxCurrentVersion", FieldType.INTEGER)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def set_DataLoadComplete_field(self, value: Optional[bool]):
        """
        Set data field with field name 'DataLoadComplete' on this record model
        """
        self.set_field_value(self.DATALOADCOMPLETE__FIELD_NAME.field_name, value)

    def get_DataLoadComplete_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'DataLoadComplete' from this record model
        """
        return self.get_field_value(self.DATALOADCOMPLETE__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_FilePath_field(self, value: Optional[str]):
        """
        Set data field with field name 'FilePath' on this record model
        """
        self.set_field_value(self.FILEPATH__FIELD_NAME.field_name, value)

    def get_FilePath_field(self) -> Optional[str]:
        """
        Get data field value with field name 'FilePath' from this record model
        """
        return self.get_field_value(self.FILEPATH__FIELD_NAME.field_name)

    def set_GroupName_field(self, value: Optional[str]):
        """
        Set data field with field name 'GroupName' on this record model
        """
        self.set_field_value(self.GROUPNAME__FIELD_NAME.field_name, value)

    def get_GroupName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'GroupName' from this record model
        """
        return self.get_field_value(self.GROUPNAME__FIELD_NAME.field_name)

    def set_VeloxCurrentVersion_field(self, value: Optional[int]):
        """
        Set data field with field name 'VeloxCurrentVersion' on this record model
        """
        self.set_field_value(self.VELOXCURRENTVERSION__FIELD_NAME.field_name, value)

    def get_VeloxCurrentVersion_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxCurrentVersion' from this record model
        """
        return self.get_field_value(self.VELOXCURRENTVERSION__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class FlowJoWorkspaceRootModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type FlowJoWorkspaceRoot
    Data Type Display Name: FlowJo Workspace Root (FlowJo Workspace Roots)
    Fields: CreatedBy, DataLoadComplete, DataRecordName, DateCreated, FilePath, VeloxCurrentVersion, VeloxLastModifiedBy, VeloxLastModifiedDate
    At the top of the FlowJo Sapio workspace hierarchy when importing a wsp file. The raw data contains Sapio JSON representation of the FlowJo workspace data. The raw JSON data will be used when processing samples.
    """
    DATA_TYPE_NAME: str = 'FlowJoWorkspaceRoot'
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATALOADCOMPLETE__FIELD_NAME: WrapperField = WrapperField("DataLoadComplete", FieldType.BOOLEAN)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    FILEPATH__FIELD_NAME: WrapperField = WrapperField("FilePath", FieldType.STRING)
    VELOXCURRENTVERSION__FIELD_NAME: WrapperField = WrapperField("VeloxCurrentVersion", FieldType.INTEGER)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def set_DataLoadComplete_field(self, value: Optional[bool]):
        """
        Set data field with field name 'DataLoadComplete' on this record model
        """
        self.set_field_value(self.DATALOADCOMPLETE__FIELD_NAME.field_name, value)

    def get_DataLoadComplete_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'DataLoadComplete' from this record model
        """
        return self.get_field_value(self.DATALOADCOMPLETE__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_FilePath_field(self, value: Optional[str]):
        """
        Set data field with field name 'FilePath' on this record model
        """
        self.set_field_value(self.FILEPATH__FIELD_NAME.field_name, value)

    def get_FilePath_field(self) -> Optional[str]:
        """
        Get data field value with field name 'FilePath' from this record model
        """
        return self.get_field_value(self.FILEPATH__FIELD_NAME.field_name)

    def set_VeloxCurrentVersion_field(self, value: Optional[int]):
        """
        Set data field with field name 'VeloxCurrentVersion' on this record model
        """
        self.set_field_value(self.VELOXCURRENTVERSION__FIELD_NAME.field_name, value)

    def get_VeloxCurrentVersion_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxCurrentVersion' from this record model
        """
        return self.get_field_value(self.VELOXCURRENTVERSION__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class FlowManualGateModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type FlowManualGate
    Data Type Display Name: Flow Manual Gate (Flow Manual Gates)
    Fields: CreatedBy, DataRecordName, DateCreated, IsNegated, ShapeID, ShapeJSON, ShapeType, UserAnnotation, VeloxLastModifiedBy, VeloxLastModifiedDate, XChannelName, YChannelName
    """
    DATA_TYPE_NAME: str = 'FlowManualGate'
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    ISNEGATED__FIELD_NAME: WrapperField = WrapperField("IsNegated", FieldType.BOOLEAN)
    SHAPEID__FIELD_NAME: WrapperField = WrapperField("ShapeID", FieldType.LONG)
    SHAPEJSON__FIELD_NAME: WrapperField = WrapperField("ShapeJSON", FieldType.STRING)
    SHAPETYPE__FIELD_NAME: WrapperField = WrapperField("ShapeType", FieldType.STRING)
    USERANNOTATION__FIELD_NAME: WrapperField = WrapperField("UserAnnotation", FieldType.STRING)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)
    XCHANNELNAME__FIELD_NAME: WrapperField = WrapperField("XChannelName", FieldType.STRING)
    YCHANNELNAME__FIELD_NAME: WrapperField = WrapperField("YChannelName", FieldType.STRING)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_IsNegated_field(self, value: Optional[bool]):
        """
        Set data field with field name 'IsNegated' on this record model
        """
        self.set_field_value(self.ISNEGATED__FIELD_NAME.field_name, value)

    def get_IsNegated_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'IsNegated' from this record model
        """
        return self.get_field_value(self.ISNEGATED__FIELD_NAME.field_name)

    def set_ShapeID_field(self, value: Optional[int]):
        """
        Set data field with field name 'ShapeID' on this record model
        """
        self.set_field_value(self.SHAPEID__FIELD_NAME.field_name, value)

    def get_ShapeID_field(self) -> Optional[int]:
        """
        Get data field value with field name 'ShapeID' from this record model
        """
        return self.get_field_value(self.SHAPEID__FIELD_NAME.field_name)

    def set_ShapeJSON_field(self, value: Optional[str]):
        """
        Set data field with field name 'ShapeJSON' on this record model
        """
        self.set_field_value(self.SHAPEJSON__FIELD_NAME.field_name, value)

    def get_ShapeJSON_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ShapeJSON' from this record model
        """
        return self.get_field_value(self.SHAPEJSON__FIELD_NAME.field_name)

    def set_ShapeType_field(self, value: Optional[str]):
        """
        Set data field with field name 'ShapeType' on this record model
        """
        self.set_field_value(self.SHAPETYPE__FIELD_NAME.field_name, value)

    def get_ShapeType_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ShapeType' from this record model
        """
        return self.get_field_value(self.SHAPETYPE__FIELD_NAME.field_name)

    def set_UserAnnotation_field(self, value: Optional[str]):
        """
        Set data field with field name 'UserAnnotation' on this record model
        """
        self.set_field_value(self.USERANNOTATION__FIELD_NAME.field_name, value)

    def get_UserAnnotation_field(self) -> Optional[str]:
        """
        Get data field value with field name 'UserAnnotation' from this record model
        """
        return self.get_field_value(self.USERANNOTATION__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)

    def set_XChannelName_field(self, value: Optional[str]):
        """
        Set data field with field name 'XChannelName' on this record model
        """
        self.set_field_value(self.XCHANNELNAME__FIELD_NAME.field_name, value)

    def get_XChannelName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'XChannelName' from this record model
        """
        return self.get_field_value(self.XCHANNELNAME__FIELD_NAME.field_name)

    def set_YChannelName_field(self, value: Optional[str]):
        """
        Set data field with field name 'YChannelName' on this record model
        """
        self.set_field_value(self.YCHANNELNAME__FIELD_NAME.field_name, value)

    def get_YChannelName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'YChannelName' from this record model
        """
        return self.get_field_value(self.YCHANNELNAME__FIELD_NAME.field_name)


class FormulationModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type Formulation
    Data Type Display Name: Formulation (Formulations)
    Fields: CreatedBy, DataRecordName, DateCreated, VeloxLastModifiedBy, VeloxLastModifiedDate
    """
    DATA_TYPE_NAME: str = 'Formulation'
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class FourPLLModelModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type FourPLLModel
    Data Type Display Name: Four Parameter Logistic Regression (Four Parameter Logistic Regressions)
    Fields: b, c, CreatedBy, d, DataRecordName, DateCreated, e, ED10, ED50, ED90, ED95, EntryName, FilePath, MultiParentLink215, RSquared, SeriesName, SourceEntryId, VeloxCurrentVersion, VeloxLastModifiedBy, VeloxLastModifiedDate
    Records advanced curve viewer's four parameter logistic regression result, when measuring sample data.
    """
    DATA_TYPE_NAME: str = 'FourPLLModel'
    B__FIELD_NAME: WrapperField = WrapperField("b", FieldType.DOUBLE)
    C__FIELD_NAME: WrapperField = WrapperField("c", FieldType.DOUBLE)
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    D__FIELD_NAME: WrapperField = WrapperField("d", FieldType.DOUBLE)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    E__FIELD_NAME: WrapperField = WrapperField("e", FieldType.DOUBLE)
    ED10__FIELD_NAME: WrapperField = WrapperField("ED10", FieldType.DOUBLE)
    ED50__FIELD_NAME: WrapperField = WrapperField("ED50", FieldType.DOUBLE)
    ED90__FIELD_NAME: WrapperField = WrapperField("ED90", FieldType.DOUBLE)
    ED95__FIELD_NAME: WrapperField = WrapperField("ED95", FieldType.DOUBLE)
    ENTRYNAME__FIELD_NAME: WrapperField = WrapperField("EntryName", FieldType.STRING)
    FILEPATH__FIELD_NAME: WrapperField = WrapperField("FilePath", FieldType.STRING)
    MULTIPARENTLINK215__FIELD_NAME: WrapperField = WrapperField("MultiParentLink215", FieldType.MULTIPARENTLINK)
    RSQUARED__FIELD_NAME: WrapperField = WrapperField("RSquared", FieldType.DOUBLE)
    SERIESNAME__FIELD_NAME: WrapperField = WrapperField("SeriesName", FieldType.STRING)
    SOURCEENTRYID__FIELD_NAME: WrapperField = WrapperField("SourceEntryId", FieldType.LONG)
    VELOXCURRENTVERSION__FIELD_NAME: WrapperField = WrapperField("VeloxCurrentVersion", FieldType.INTEGER)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_b_field(self, value: Optional[float]):
        """
        Set data field with field name 'b' on this record model
        """
        self.set_field_value(self.B__FIELD_NAME.field_name, value)

    def get_b_field(self) -> Optional[float]:
        """
        Get data field value with field name 'b' from this record model
        """
        return self.get_field_value(self.B__FIELD_NAME.field_name)

    def set_c_field(self, value: Optional[float]):
        """
        Set data field with field name 'c' on this record model
        """
        self.set_field_value(self.C__FIELD_NAME.field_name, value)

    def get_c_field(self) -> Optional[float]:
        """
        Get data field value with field name 'c' from this record model
        """
        return self.get_field_value(self.C__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def set_d_field(self, value: Optional[float]):
        """
        Set data field with field name 'd' on this record model
        """
        self.set_field_value(self.D__FIELD_NAME.field_name, value)

    def get_d_field(self) -> Optional[float]:
        """
        Get data field value with field name 'd' from this record model
        """
        return self.get_field_value(self.D__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_e_field(self, value: Optional[float]):
        """
        Set data field with field name 'e' on this record model
        """
        self.set_field_value(self.E__FIELD_NAME.field_name, value)

    def get_e_field(self) -> Optional[float]:
        """
        Get data field value with field name 'e' from this record model
        """
        return self.get_field_value(self.E__FIELD_NAME.field_name)

    def set_ED10_field(self, value: Optional[float]):
        """
        Set data field with field name 'ED10' on this record model
        """
        self.set_field_value(self.ED10__FIELD_NAME.field_name, value)

    def get_ED10_field(self) -> Optional[float]:
        """
        Get data field value with field name 'ED10' from this record model
        """
        return self.get_field_value(self.ED10__FIELD_NAME.field_name)

    def set_ED50_field(self, value: Optional[float]):
        """
        Set data field with field name 'ED50' on this record model
        """
        self.set_field_value(self.ED50__FIELD_NAME.field_name, value)

    def get_ED50_field(self) -> Optional[float]:
        """
        Get data field value with field name 'ED50' from this record model
        """
        return self.get_field_value(self.ED50__FIELD_NAME.field_name)

    def set_ED90_field(self, value: Optional[float]):
        """
        Set data field with field name 'ED90' on this record model
        """
        self.set_field_value(self.ED90__FIELD_NAME.field_name, value)

    def get_ED90_field(self) -> Optional[float]:
        """
        Get data field value with field name 'ED90' from this record model
        """
        return self.get_field_value(self.ED90__FIELD_NAME.field_name)

    def set_ED95_field(self, value: Optional[float]):
        """
        Set data field with field name 'ED95' on this record model
        """
        self.set_field_value(self.ED95__FIELD_NAME.field_name, value)

    def get_ED95_field(self) -> Optional[float]:
        """
        Get data field value with field name 'ED95' from this record model
        """
        return self.get_field_value(self.ED95__FIELD_NAME.field_name)

    def set_EntryName_field(self, value: Optional[str]):
        """
        Set data field with field name 'EntryName' on this record model
        """
        self.set_field_value(self.ENTRYNAME__FIELD_NAME.field_name, value)

    def get_EntryName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'EntryName' from this record model
        """
        return self.get_field_value(self.ENTRYNAME__FIELD_NAME.field_name)

    def set_FilePath_field(self, value: Optional[str]):
        """
        Set data field with field name 'FilePath' on this record model
        """
        self.set_field_value(self.FILEPATH__FIELD_NAME.field_name, value)

    def get_FilePath_field(self) -> Optional[str]:
        """
        Get data field value with field name 'FilePath' from this record model
        """
        return self.get_field_value(self.FILEPATH__FIELD_NAME.field_name)

    def set_RSquared_field(self, value: Optional[float]):
        """
        Set data field with field name 'RSquared' on this record model
        """
        self.set_field_value(self.RSQUARED__FIELD_NAME.field_name, value)

    def get_RSquared_field(self) -> Optional[float]:
        """
        Get data field value with field name 'RSquared' from this record model
        """
        return self.get_field_value(self.RSQUARED__FIELD_NAME.field_name)

    def set_SeriesName_field(self, value: Optional[str]):
        """
        Set data field with field name 'SeriesName' on this record model
        """
        self.set_field_value(self.SERIESNAME__FIELD_NAME.field_name, value)

    def get_SeriesName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SeriesName' from this record model
        """
        return self.get_field_value(self.SERIESNAME__FIELD_NAME.field_name)

    def set_SourceEntryId_field(self, value: Optional[int]):
        """
        Set data field with field name 'SourceEntryId' on this record model
        """
        self.set_field_value(self.SOURCEENTRYID__FIELD_NAME.field_name, value)

    def get_SourceEntryId_field(self) -> Optional[int]:
        """
        Get data field value with field name 'SourceEntryId' from this record model
        """
        return self.get_field_value(self.SOURCEENTRYID__FIELD_NAME.field_name)

    def set_VeloxCurrentVersion_field(self, value: Optional[int]):
        """
        Set data field with field name 'VeloxCurrentVersion' on this record model
        """
        self.set_field_value(self.VELOXCURRENTVERSION__FIELD_NAME.field_name, value)

    def get_VeloxCurrentVersion_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxCurrentVersion' from this record model
        """
        return self.get_field_value(self.VELOXCURRENTVERSION__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class FragmentAnalyzerResultModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type FragmentAnalyzerResult
    Data Type Display Name: Fragment Analyzer Result (Fragment Analyzer Results)
    Fields: AvgBPSize, CreatedBy, DataRecordName, DateCreated, Molarity, MolarityUnits, PeakRegionIdentifier, VeloxLastModifiedBy, VeloxLastModifiedDate
    """
    DATA_TYPE_NAME: str = 'FragmentAnalyzerResult'
    AVGBPSIZE__FIELD_NAME: WrapperField = WrapperField("AvgBPSize", FieldType.DOUBLE)
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    MOLARITY__FIELD_NAME: WrapperField = WrapperField("Molarity", FieldType.DOUBLE)
    MOLARITYUNITS__FIELD_NAME: WrapperField = WrapperField("MolarityUnits", FieldType.STRING)
    PEAKREGIONIDENTIFIER__FIELD_NAME: WrapperField = WrapperField("PeakRegionIdentifier", FieldType.STRING)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_AvgBPSize_field(self, value: Optional[float]):
        """
        Set data field with field name 'AvgBPSize' on this record model
        """
        self.set_field_value(self.AVGBPSIZE__FIELD_NAME.field_name, value)

    def get_AvgBPSize_field(self) -> Optional[float]:
        """
        Get data field value with field name 'AvgBPSize' from this record model
        """
        return self.get_field_value(self.AVGBPSIZE__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_Molarity_field(self, value: Optional[float]):
        """
        Set data field with field name 'Molarity' on this record model
        """
        self.set_field_value(self.MOLARITY__FIELD_NAME.field_name, value)

    def get_Molarity_field(self) -> Optional[float]:
        """
        Get data field value with field name 'Molarity' from this record model
        """
        return self.get_field_value(self.MOLARITY__FIELD_NAME.field_name)

    def set_MolarityUnits_field(self, value: Optional[str]):
        """
        Set data field with field name 'MolarityUnits' on this record model
        """
        self.set_field_value(self.MOLARITYUNITS__FIELD_NAME.field_name, value)

    def get_MolarityUnits_field(self) -> Optional[str]:
        """
        Get data field value with field name 'MolarityUnits' from this record model
        """
        return self.get_field_value(self.MOLARITYUNITS__FIELD_NAME.field_name)

    def set_PeakRegionIdentifier_field(self, value: Optional[str]):
        """
        Set data field with field name 'PeakRegionIdentifier' on this record model
        """
        self.set_field_value(self.PEAKREGIONIDENTIFIER__FIELD_NAME.field_name, value)

    def get_PeakRegionIdentifier_field(self) -> Optional[str]:
        """
        Get data field value with field name 'PeakRegionIdentifier' from this record model
        """
        return self.get_field_value(self.PEAKREGIONIDENTIFIER__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class HelmChemPropertyModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type HelmChemProperty
    Data Type Display Name: Helm Chem Property (Helm Chem Properties)
    Fields: Charge, cLogP, CreatedBy, CXSMILESHash, DataRecordName, DateCreated, ExactMass, Formula, HasOrStereoGroup, inchi, InchiKey, MOL, MolecularWeight, PolarSurfaceArea, SMILES, StereoRegHash, TotalHBondAcceptors, TotalHBondCount, VeloxLastModifiedBy, VeloxLastModifiedDate
    """
    DATA_TYPE_NAME: str = 'HelmChemProperty'
    CHARGE__FIELD_NAME: WrapperField = WrapperField("Charge", FieldType.INTEGER)
    CLOGP__FIELD_NAME: WrapperField = WrapperField("cLogP", FieldType.DOUBLE)
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    CXSMILESHASH__FIELD_NAME: WrapperField = WrapperField("CXSMILESHash", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    EXACTMASS__FIELD_NAME: WrapperField = WrapperField("ExactMass", FieldType.DOUBLE)
    FORMULA__FIELD_NAME: WrapperField = WrapperField("Formula", FieldType.STRING)
    HASORSTEREOGROUP__FIELD_NAME: WrapperField = WrapperField("HasOrStereoGroup", FieldType.BOOLEAN)
    INCHI__FIELD_NAME: WrapperField = WrapperField("inchi", FieldType.STRING)
    INCHIKEY__FIELD_NAME: WrapperField = WrapperField("InchiKey", FieldType.STRING)
    MOL__FIELD_NAME: WrapperField = WrapperField("MOL", FieldType.STRING)
    MOLECULARWEIGHT__FIELD_NAME: WrapperField = WrapperField("MolecularWeight", FieldType.DOUBLE)
    POLARSURFACEAREA__FIELD_NAME: WrapperField = WrapperField("PolarSurfaceArea", FieldType.DOUBLE)
    SMILES__FIELD_NAME: WrapperField = WrapperField("SMILES", FieldType.STRING)
    STEREOREGHASH__FIELD_NAME: WrapperField = WrapperField("StereoRegHash", FieldType.STRING)
    TOTALHBONDACCEPTORS__FIELD_NAME: WrapperField = WrapperField("TotalHBondAcceptors", FieldType.INTEGER)
    TOTALHBONDCOUNT__FIELD_NAME: WrapperField = WrapperField("TotalHBondCount", FieldType.INTEGER)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_Charge_field(self, value: Optional[int]):
        """
        Set data field with field name 'Charge' on this record model
        """
        self.set_field_value(self.CHARGE__FIELD_NAME.field_name, value)

    def get_Charge_field(self) -> Optional[int]:
        """
        Get data field value with field name 'Charge' from this record model
        """
        return self.get_field_value(self.CHARGE__FIELD_NAME.field_name)

    def set_cLogP_field(self, value: Optional[float]):
        """
        Set data field with field name 'cLogP' on this record model
        """
        self.set_field_value(self.CLOGP__FIELD_NAME.field_name, value)

    def get_cLogP_field(self) -> Optional[float]:
        """
        Get data field value with field name 'cLogP' from this record model
        """
        return self.get_field_value(self.CLOGP__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def set_CXSMILESHash_field(self, value: Optional[str]):
        """
        Set data field with field name 'CXSMILESHash' on this record model
        """
        self.set_field_value(self.CXSMILESHASH__FIELD_NAME.field_name, value)

    def get_CXSMILESHash_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CXSMILESHash' from this record model
        """
        return self.get_field_value(self.CXSMILESHASH__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_ExactMass_field(self, value: Optional[float]):
        """
        Set data field with field name 'ExactMass' on this record model
        """
        self.set_field_value(self.EXACTMASS__FIELD_NAME.field_name, value)

    def get_ExactMass_field(self) -> Optional[float]:
        """
        Get data field value with field name 'ExactMass' from this record model
        """
        return self.get_field_value(self.EXACTMASS__FIELD_NAME.field_name)

    def set_Formula_field(self, value: Optional[str]):
        """
        Set data field with field name 'Formula' on this record model
        """
        self.set_field_value(self.FORMULA__FIELD_NAME.field_name, value)

    def get_Formula_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Formula' from this record model
        """
        return self.get_field_value(self.FORMULA__FIELD_NAME.field_name)

    def set_HasOrStereoGroup_field(self, value: Optional[bool]):
        """
        Set data field with field name 'HasOrStereoGroup' on this record model
        """
        self.set_field_value(self.HASORSTEREOGROUP__FIELD_NAME.field_name, value)

    def get_HasOrStereoGroup_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'HasOrStereoGroup' from this record model
        """
        return self.get_field_value(self.HASORSTEREOGROUP__FIELD_NAME.field_name)

    def set_inchi_field(self, value: Optional[str]):
        """
        Set data field with field name 'inchi' on this record model
        """
        self.set_field_value(self.INCHI__FIELD_NAME.field_name, value)

    def get_inchi_field(self) -> Optional[str]:
        """
        Get data field value with field name 'inchi' from this record model
        """
        return self.get_field_value(self.INCHI__FIELD_NAME.field_name)

    def set_InchiKey_field(self, value: Optional[str]):
        """
        Set data field with field name 'InchiKey' on this record model
        """
        self.set_field_value(self.INCHIKEY__FIELD_NAME.field_name, value)

    def get_InchiKey_field(self) -> Optional[str]:
        """
        Get data field value with field name 'InchiKey' from this record model
        """
        return self.get_field_value(self.INCHIKEY__FIELD_NAME.field_name)

    def set_MOL_field(self, value: Optional[str]):
        """
        Set data field with field name 'MOL' on this record model
        """
        self.set_field_value(self.MOL__FIELD_NAME.field_name, value)

    def get_MOL_field(self) -> Optional[str]:
        """
        Get data field value with field name 'MOL' from this record model
        """
        return self.get_field_value(self.MOL__FIELD_NAME.field_name)

    def set_MolecularWeight_field(self, value: Optional[float]):
        """
        Set data field with field name 'MolecularWeight' on this record model
        """
        self.set_field_value(self.MOLECULARWEIGHT__FIELD_NAME.field_name, value)

    def get_MolecularWeight_field(self) -> Optional[float]:
        """
        Get data field value with field name 'MolecularWeight' from this record model
        """
        return self.get_field_value(self.MOLECULARWEIGHT__FIELD_NAME.field_name)

    def set_PolarSurfaceArea_field(self, value: Optional[float]):
        """
        Set data field with field name 'PolarSurfaceArea' on this record model
        """
        self.set_field_value(self.POLARSURFACEAREA__FIELD_NAME.field_name, value)

    def get_PolarSurfaceArea_field(self) -> Optional[float]:
        """
        Get data field value with field name 'PolarSurfaceArea' from this record model
        """
        return self.get_field_value(self.POLARSURFACEAREA__FIELD_NAME.field_name)

    def set_SMILES_field(self, value: Optional[str]):
        """
        Set data field with field name 'SMILES' on this record model
        """
        self.set_field_value(self.SMILES__FIELD_NAME.field_name, value)

    def get_SMILES_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SMILES' from this record model
        """
        return self.get_field_value(self.SMILES__FIELD_NAME.field_name)

    def set_StereoRegHash_field(self, value: Optional[str]):
        """
        Set data field with field name 'StereoRegHash' on this record model
        """
        self.set_field_value(self.STEREOREGHASH__FIELD_NAME.field_name, value)

    def get_StereoRegHash_field(self) -> Optional[str]:
        """
        Get data field value with field name 'StereoRegHash' from this record model
        """
        return self.get_field_value(self.STEREOREGHASH__FIELD_NAME.field_name)

    def set_TotalHBondAcceptors_field(self, value: Optional[int]):
        """
        Set data field with field name 'TotalHBondAcceptors' on this record model
        """
        self.set_field_value(self.TOTALHBONDACCEPTORS__FIELD_NAME.field_name, value)

    def get_TotalHBondAcceptors_field(self) -> Optional[int]:
        """
        Get data field value with field name 'TotalHBondAcceptors' from this record model
        """
        return self.get_field_value(self.TOTALHBONDACCEPTORS__FIELD_NAME.field_name)

    def set_TotalHBondCount_field(self, value: Optional[int]):
        """
        Set data field with field name 'TotalHBondCount' on this record model
        """
        self.set_field_value(self.TOTALHBONDCOUNT__FIELD_NAME.field_name, value)

    def get_TotalHBondCount_field(self) -> Optional[int]:
        """
        Get data field value with field name 'TotalHBondCount' from this record model
        """
        return self.get_field_value(self.TOTALHBONDCOUNT__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class HighThroughputScreeningDetailsModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type HighThroughputScreeningDetails
    Data Type Display Name: High Throughput Screening Details (High Throughput Screening Details)
    Fields: CreatedBy, DataRecordName, DateCreated, Humidity, Length, MultiParentLink159, MultiParentLink215, NumDaughterPlates, RPM, Temperature, TransferVolume, VeloxLastModifiedBy, VeloxLastModifiedDate
    """
    DATA_TYPE_NAME: str = 'HighThroughputScreeningDetails'
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    HUMIDITY__FIELD_NAME: WrapperField = WrapperField("Humidity", FieldType.DOUBLE)
    LENGTH__FIELD_NAME: WrapperField = WrapperField("Length", FieldType.DOUBLE)
    MULTIPARENTLINK159__FIELD_NAME: WrapperField = WrapperField("MultiParentLink159", FieldType.MULTIPARENTLINK)
    MULTIPARENTLINK215__FIELD_NAME: WrapperField = WrapperField("MultiParentLink215", FieldType.MULTIPARENTLINK)
    NUMDAUGHTERPLATES__FIELD_NAME: WrapperField = WrapperField("NumDaughterPlates", FieldType.INTEGER)
    RPM__FIELD_NAME: WrapperField = WrapperField("RPM", FieldType.DOUBLE)
    TEMPERATURE__FIELD_NAME: WrapperField = WrapperField("Temperature", FieldType.DOUBLE)
    TRANSFERVOLUME__FIELD_NAME: WrapperField = WrapperField("TransferVolume", FieldType.DOUBLE)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_Humidity_field(self, value: Optional[float]):
        """
        Set data field with field name 'Humidity' on this record model
        """
        self.set_field_value(self.HUMIDITY__FIELD_NAME.field_name, value)

    def get_Humidity_field(self) -> Optional[float]:
        """
        Get data field value with field name 'Humidity' from this record model
        """
        return self.get_field_value(self.HUMIDITY__FIELD_NAME.field_name)

    def set_Length_field(self, value: Optional[float]):
        """
        Set data field with field name 'Length' on this record model
        """
        self.set_field_value(self.LENGTH__FIELD_NAME.field_name, value)

    def get_Length_field(self) -> Optional[float]:
        """
        Get data field value with field name 'Length' from this record model
        """
        return self.get_field_value(self.LENGTH__FIELD_NAME.field_name)

    def set_NumDaughterPlates_field(self, value: Optional[int]):
        """
        Set data field with field name 'NumDaughterPlates' on this record model
        """
        self.set_field_value(self.NUMDAUGHTERPLATES__FIELD_NAME.field_name, value)

    def get_NumDaughterPlates_field(self) -> Optional[int]:
        """
        Get data field value with field name 'NumDaughterPlates' from this record model
        """
        return self.get_field_value(self.NUMDAUGHTERPLATES__FIELD_NAME.field_name)

    def set_RPM_field(self, value: Optional[float]):
        """
        Set data field with field name 'RPM' on this record model
        """
        self.set_field_value(self.RPM__FIELD_NAME.field_name, value)

    def get_RPM_field(self) -> Optional[float]:
        """
        Get data field value with field name 'RPM' from this record model
        """
        return self.get_field_value(self.RPM__FIELD_NAME.field_name)

    def set_Temperature_field(self, value: Optional[float]):
        """
        Set data field with field name 'Temperature' on this record model
        """
        self.set_field_value(self.TEMPERATURE__FIELD_NAME.field_name, value)

    def get_Temperature_field(self) -> Optional[float]:
        """
        Get data field value with field name 'Temperature' from this record model
        """
        return self.get_field_value(self.TEMPERATURE__FIELD_NAME.field_name)

    def set_TransferVolume_field(self, value: Optional[float]):
        """
        Set data field with field name 'TransferVolume' on this record model
        """
        self.set_field_value(self.TRANSFERVOLUME__FIELD_NAME.field_name, value)

    def get_TransferVolume_field(self) -> Optional[float]:
        """
        Get data field value with field name 'TransferVolume' from this record model
        """
        return self.get_field_value(self.TRANSFERVOLUME__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class HiSeqFirstBaseReportModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type HiSeqFirstBaseReport
    Data Type Display Name: HiSeq First Base Report (HiSeq First Base Reports)
    Fields: A_Focus_Score, A_Intensity, C_Focus_Score, C_Intensity, ClusterDensity, CreatedBy, DataRecordName, DateCreated, G_Focus_Score, G_Intensity, Lane, Surface, T_Focus_Score, T_Intensity, VeloxLastModifiedBy, VeloxLastModifiedDate
     <!-- DISPLAY IN INSTRUMENT RUN MONITOR -->
    """
    DATA_TYPE_NAME: str = 'HiSeqFirstBaseReport'
    A_FOCUS_SCORE__FIELD_NAME: WrapperField = WrapperField("A_Focus_Score", FieldType.DOUBLE)
    A_INTENSITY__FIELD_NAME: WrapperField = WrapperField("A_Intensity", FieldType.DOUBLE)
    C_FOCUS_SCORE__FIELD_NAME: WrapperField = WrapperField("C_Focus_Score", FieldType.DOUBLE)
    C_INTENSITY__FIELD_NAME: WrapperField = WrapperField("C_Intensity", FieldType.DOUBLE)
    CLUSTERDENSITY__FIELD_NAME: WrapperField = WrapperField("ClusterDensity", FieldType.DOUBLE)
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    G_FOCUS_SCORE__FIELD_NAME: WrapperField = WrapperField("G_Focus_Score", FieldType.DOUBLE)
    G_INTENSITY__FIELD_NAME: WrapperField = WrapperField("G_Intensity", FieldType.DOUBLE)
    LANE__FIELD_NAME: WrapperField = WrapperField("Lane", FieldType.STRING)
    SURFACE__FIELD_NAME: WrapperField = WrapperField("Surface", FieldType.STRING)
    T_FOCUS_SCORE__FIELD_NAME: WrapperField = WrapperField("T_Focus_Score", FieldType.DOUBLE)
    T_INTENSITY__FIELD_NAME: WrapperField = WrapperField("T_Intensity", FieldType.DOUBLE)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_A_Focus_Score_field(self, value: Optional[float]):
        """
        Set data field with field name 'A_Focus_Score' on this record model
        """
        self.set_field_value(self.A_FOCUS_SCORE__FIELD_NAME.field_name, value)

    def get_A_Focus_Score_field(self) -> Optional[float]:
        """
        Get data field value with field name 'A_Focus_Score' from this record model
        """
        return self.get_field_value(self.A_FOCUS_SCORE__FIELD_NAME.field_name)

    def set_A_Intensity_field(self, value: Optional[float]):
        """
        Set data field with field name 'A_Intensity' on this record model
        """
        self.set_field_value(self.A_INTENSITY__FIELD_NAME.field_name, value)

    def get_A_Intensity_field(self) -> Optional[float]:
        """
        Get data field value with field name 'A_Intensity' from this record model
        """
        return self.get_field_value(self.A_INTENSITY__FIELD_NAME.field_name)

    def set_C_Focus_Score_field(self, value: Optional[float]):
        """
        Set data field with field name 'C_Focus_Score' on this record model
        """
        self.set_field_value(self.C_FOCUS_SCORE__FIELD_NAME.field_name, value)

    def get_C_Focus_Score_field(self) -> Optional[float]:
        """
        Get data field value with field name 'C_Focus_Score' from this record model
        """
        return self.get_field_value(self.C_FOCUS_SCORE__FIELD_NAME.field_name)

    def set_C_Intensity_field(self, value: Optional[float]):
        """
        Set data field with field name 'C_Intensity' on this record model
        """
        self.set_field_value(self.C_INTENSITY__FIELD_NAME.field_name, value)

    def get_C_Intensity_field(self) -> Optional[float]:
        """
        Get data field value with field name 'C_Intensity' from this record model
        """
        return self.get_field_value(self.C_INTENSITY__FIELD_NAME.field_name)

    def set_ClusterDensity_field(self, value: Optional[float]):
        """
        Set data field with field name 'ClusterDensity' on this record model
        """
        self.set_field_value(self.CLUSTERDENSITY__FIELD_NAME.field_name, value)

    def get_ClusterDensity_field(self) -> Optional[float]:
        """
        Get data field value with field name 'ClusterDensity' from this record model
        """
        return self.get_field_value(self.CLUSTERDENSITY__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_G_Focus_Score_field(self, value: Optional[float]):
        """
        Set data field with field name 'G_Focus_Score' on this record model
        """
        self.set_field_value(self.G_FOCUS_SCORE__FIELD_NAME.field_name, value)

    def get_G_Focus_Score_field(self) -> Optional[float]:
        """
        Get data field value with field name 'G_Focus_Score' from this record model
        """
        return self.get_field_value(self.G_FOCUS_SCORE__FIELD_NAME.field_name)

    def set_G_Intensity_field(self, value: Optional[float]):
        """
        Set data field with field name 'G_Intensity' on this record model
        """
        self.set_field_value(self.G_INTENSITY__FIELD_NAME.field_name, value)

    def get_G_Intensity_field(self) -> Optional[float]:
        """
        Get data field value with field name 'G_Intensity' from this record model
        """
        return self.get_field_value(self.G_INTENSITY__FIELD_NAME.field_name)

    def set_Lane_field(self, value: Optional[str]):
        """
        Set data field with field name 'Lane' on this record model
        """
        self.set_field_value(self.LANE__FIELD_NAME.field_name, value)

    def get_Lane_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Lane' from this record model
        """
        return self.get_field_value(self.LANE__FIELD_NAME.field_name)

    def set_Surface_field(self, value: Optional[str]):
        """
        Set data field with field name 'Surface' on this record model
        """
        self.set_field_value(self.SURFACE__FIELD_NAME.field_name, value)

    def get_Surface_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Surface' from this record model
        """
        return self.get_field_value(self.SURFACE__FIELD_NAME.field_name)

    def set_T_Focus_Score_field(self, value: Optional[float]):
        """
        Set data field with field name 'T_Focus_Score' on this record model
        """
        self.set_field_value(self.T_FOCUS_SCORE__FIELD_NAME.field_name, value)

    def get_T_Focus_Score_field(self) -> Optional[float]:
        """
        Get data field value with field name 'T_Focus_Score' from this record model
        """
        return self.get_field_value(self.T_FOCUS_SCORE__FIELD_NAME.field_name)

    def set_T_Intensity_field(self, value: Optional[float]):
        """
        Set data field with field name 'T_Intensity' on this record model
        """
        self.set_field_value(self.T_INTENSITY__FIELD_NAME.field_name, value)

    def get_T_Intensity_field(self) -> Optional[float]:
        """
        Get data field value with field name 'T_Intensity' from this record model
        """
        return self.get_field_value(self.T_INTENSITY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class HistologyGroupModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type HistologyGroup
    Data Type Display Name: Histology Group (Histology Groups)
    Fields: CreatedBy, DataRecordName, DateCreated, DrugDosingDetails, GroupName, Histology_GroupComment, HistologyGroupID, Stain, StainRecordId, TmContainerType, TmDirection, TmSampleSubtype, TmSampleType, TmTimepoint, TreatmentDetails, VeloxLastModifiedBy, VeloxLastModifiedDate
    """
    DATA_TYPE_NAME: str = 'HistologyGroup'
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    DRUGDOSINGDETAILS__FIELD_NAME: WrapperField = WrapperField("DrugDosingDetails", FieldType.STRING)
    GROUPNAME__FIELD_NAME: WrapperField = WrapperField("GroupName", FieldType.STRING)
    HISTOLOGY_GROUPCOMMENT__FIELD_NAME: WrapperField = WrapperField("Histology_GroupComment", FieldType.STRING)
    HISTOLOGYGROUPID__FIELD_NAME: WrapperField = WrapperField("HistologyGroupID", FieldType.STRING)
    STAIN__FIELD_NAME: WrapperField = WrapperField("Stain", FieldType.SELECTION)
    STAINRECORDID__FIELD_NAME: WrapperField = WrapperField("StainRecordId", FieldType.LONG)
    TMCONTAINERTYPE__FIELD_NAME: WrapperField = WrapperField("TmContainerType", FieldType.STRING)
    TMDIRECTION__FIELD_NAME: WrapperField = WrapperField("TmDirection", FieldType.STRING)
    TMSAMPLESUBTYPE__FIELD_NAME: WrapperField = WrapperField("TmSampleSubtype", FieldType.STRING)
    TMSAMPLETYPE__FIELD_NAME: WrapperField = WrapperField("TmSampleType", FieldType.STRING)
    TMTIMEPOINT__FIELD_NAME: WrapperField = WrapperField("TmTimepoint", FieldType.STRING)
    TREATMENTDETAILS__FIELD_NAME: WrapperField = WrapperField("TreatmentDetails", FieldType.STRING)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_DrugDosingDetails_field(self, value: Optional[str]):
        """
        Set data field with field name 'DrugDosingDetails' on this record model
        """
        self.set_field_value(self.DRUGDOSINGDETAILS__FIELD_NAME.field_name, value)

    def get_DrugDosingDetails_field(self) -> Optional[str]:
        """
        Get data field value with field name 'DrugDosingDetails' from this record model
        """
        return self.get_field_value(self.DRUGDOSINGDETAILS__FIELD_NAME.field_name)

    def set_GroupName_field(self, value: Optional[str]):
        """
        Set data field with field name 'GroupName' on this record model
        """
        self.set_field_value(self.GROUPNAME__FIELD_NAME.field_name, value)

    def get_GroupName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'GroupName' from this record model
        """
        return self.get_field_value(self.GROUPNAME__FIELD_NAME.field_name)

    def set_Histology_GroupComment_field(self, value: Optional[str]):
        """
        Set data field with field name 'Histology_GroupComment' on this record model
        """
        self.set_field_value(self.HISTOLOGY_GROUPCOMMENT__FIELD_NAME.field_name, value)

    def get_Histology_GroupComment_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Histology_GroupComment' from this record model
        """
        return self.get_field_value(self.HISTOLOGY_GROUPCOMMENT__FIELD_NAME.field_name)

    def set_HistologyGroupID_field(self, value: Optional[str]):
        """
        Set data field with field name 'HistologyGroupID' on this record model
        """
        self.set_field_value(self.HISTOLOGYGROUPID__FIELD_NAME.field_name, value)

    def get_HistologyGroupID_field(self) -> Optional[str]:
        """
        Get data field value with field name 'HistologyGroupID' from this record model
        """
        return self.get_field_value(self.HISTOLOGYGROUPID__FIELD_NAME.field_name)

    def set_Stain_field(self, value: Optional[str]):
        """
        Set data field with field name 'Stain' on this record model
        """
        self.set_field_value(self.STAIN__FIELD_NAME.field_name, value)

    def get_Stain_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Stain' from this record model
        """
        return self.get_field_value(self.STAIN__FIELD_NAME.field_name)

    def set_StainRecordId_field(self, value: Optional[int]):
        """
        Set data field with field name 'StainRecordId' on this record model
        """
        self.set_field_value(self.STAINRECORDID__FIELD_NAME.field_name, value)

    def get_StainRecordId_field(self) -> Optional[int]:
        """
        Get data field value with field name 'StainRecordId' from this record model
        """
        return self.get_field_value(self.STAINRECORDID__FIELD_NAME.field_name)

    def set_TmContainerType_field(self, value: Optional[str]):
        """
        Set data field with field name 'TmContainerType' on this record model
        """
        self.set_field_value(self.TMCONTAINERTYPE__FIELD_NAME.field_name, value)

    def get_TmContainerType_field(self) -> Optional[str]:
        """
        Get data field value with field name 'TmContainerType' from this record model
        """
        return self.get_field_value(self.TMCONTAINERTYPE__FIELD_NAME.field_name)

    def set_TmDirection_field(self, value: Optional[str]):
        """
        Set data field with field name 'TmDirection' on this record model
        """
        self.set_field_value(self.TMDIRECTION__FIELD_NAME.field_name, value)

    def get_TmDirection_field(self) -> Optional[str]:
        """
        Get data field value with field name 'TmDirection' from this record model
        """
        return self.get_field_value(self.TMDIRECTION__FIELD_NAME.field_name)

    def set_TmSampleSubtype_field(self, value: Optional[str]):
        """
        Set data field with field name 'TmSampleSubtype' on this record model
        """
        self.set_field_value(self.TMSAMPLESUBTYPE__FIELD_NAME.field_name, value)

    def get_TmSampleSubtype_field(self) -> Optional[str]:
        """
        Get data field value with field name 'TmSampleSubtype' from this record model
        """
        return self.get_field_value(self.TMSAMPLESUBTYPE__FIELD_NAME.field_name)

    def set_TmSampleType_field(self, value: Optional[str]):
        """
        Set data field with field name 'TmSampleType' on this record model
        """
        self.set_field_value(self.TMSAMPLETYPE__FIELD_NAME.field_name, value)

    def get_TmSampleType_field(self) -> Optional[str]:
        """
        Get data field value with field name 'TmSampleType' from this record model
        """
        return self.get_field_value(self.TMSAMPLETYPE__FIELD_NAME.field_name)

    def set_TmTimepoint_field(self, value: Optional[str]):
        """
        Set data field with field name 'TmTimepoint' on this record model
        """
        self.set_field_value(self.TMTIMEPOINT__FIELD_NAME.field_name, value)

    def get_TmTimepoint_field(self) -> Optional[str]:
        """
        Get data field value with field name 'TmTimepoint' from this record model
        """
        return self.get_field_value(self.TMTIMEPOINT__FIELD_NAME.field_name)

    def set_TreatmentDetails_field(self, value: Optional[str]):
        """
        Set data field with field name 'TreatmentDetails' on this record model
        """
        self.set_field_value(self.TREATMENTDETAILS__FIELD_NAME.field_name, value)

    def get_TreatmentDetails_field(self) -> Optional[str]:
        """
        Get data field value with field name 'TreatmentDetails' from this record model
        """
        return self.get_field_value(self.TREATMENTDETAILS__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class HistologyProtocol1Model(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type HistologyProtocol1
    Data Type Display Name: Histology Protocol (Histology Protocols)
    Fields: CreatedBy, DataRecordName, DateCreated, GroupName, MultiParentLink215, NextUidNumberPerPrefix, RequestId, SampleId, SubjectId, SubjectNumber, VeloxLastModifiedBy, VeloxLastModifiedDate
    """
    DATA_TYPE_NAME: str = 'HistologyProtocol1'
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    GROUPNAME__FIELD_NAME: WrapperField = WrapperField("GroupName", FieldType.STRING)
    MULTIPARENTLINK215__FIELD_NAME: WrapperField = WrapperField("MultiParentLink215", FieldType.MULTIPARENTLINK)
    NEXTUIDNUMBERPERPREFIX__FIELD_NAME: WrapperField = WrapperField("NextUidNumberPerPrefix", FieldType.STRING)
    REQUESTID__FIELD_NAME: WrapperField = WrapperField("RequestId", FieldType.STRING)
    SAMPLEID__FIELD_NAME: WrapperField = WrapperField("SampleId", FieldType.STRING)
    SUBJECTID__FIELD_NAME: WrapperField = WrapperField("SubjectId", FieldType.STRING)
    SUBJECTNUMBER__FIELD_NAME: WrapperField = WrapperField("SubjectNumber", FieldType.LONG)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_GroupName_field(self, value: Optional[str]):
        """
        Set data field with field name 'GroupName' on this record model
        """
        self.set_field_value(self.GROUPNAME__FIELD_NAME.field_name, value)

    def get_GroupName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'GroupName' from this record model
        """
        return self.get_field_value(self.GROUPNAME__FIELD_NAME.field_name)

    def set_NextUidNumberPerPrefix_field(self, value: Optional[str]):
        """
        Set data field with field name 'NextUidNumberPerPrefix' on this record model
        """
        self.set_field_value(self.NEXTUIDNUMBERPERPREFIX__FIELD_NAME.field_name, value)

    def get_NextUidNumberPerPrefix_field(self) -> Optional[str]:
        """
        Get data field value with field name 'NextUidNumberPerPrefix' from this record model
        """
        return self.get_field_value(self.NEXTUIDNUMBERPERPREFIX__FIELD_NAME.field_name)

    def set_RequestId_field(self, value: Optional[str]):
        """
        Set data field with field name 'RequestId' on this record model
        """
        self.set_field_value(self.REQUESTID__FIELD_NAME.field_name, value)

    def get_RequestId_field(self) -> Optional[str]:
        """
        Get data field value with field name 'RequestId' from this record model
        """
        return self.get_field_value(self.REQUESTID__FIELD_NAME.field_name)

    def set_SampleId_field(self, value: Optional[str]):
        """
        Set data field with field name 'SampleId' on this record model
        """
        self.set_field_value(self.SAMPLEID__FIELD_NAME.field_name, value)

    def get_SampleId_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SampleId' from this record model
        """
        return self.get_field_value(self.SAMPLEID__FIELD_NAME.field_name)

    def set_SubjectId_field(self, value: Optional[str]):
        """
        Set data field with field name 'SubjectId' on this record model
        """
        self.set_field_value(self.SUBJECTID__FIELD_NAME.field_name, value)

    def get_SubjectId_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SubjectId' from this record model
        """
        return self.get_field_value(self.SUBJECTID__FIELD_NAME.field_name)

    def set_SubjectNumber_field(self, value: Optional[int]):
        """
        Set data field with field name 'SubjectNumber' on this record model
        """
        self.set_field_value(self.SUBJECTNUMBER__FIELD_NAME.field_name, value)

    def get_SubjectNumber_field(self) -> Optional[int]:
        """
        Get data field value with field name 'SubjectNumber' from this record model
        """
        return self.get_field_value(self.SUBJECTNUMBER__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class HistologyProtocol2Model(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type HistologyProtocol2
    Data Type Display Name: Histology Protocol 2 (Histology Protocol 2s)
    Fields: CreatedBy, DataRecordName, DateCreated, SampleId, SlideId, SlidePosition, VeloxLastModifiedBy, VeloxLastModifiedDate
    """
    DATA_TYPE_NAME: str = 'HistologyProtocol2'
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    SAMPLEID__FIELD_NAME: WrapperField = WrapperField("SampleId", FieldType.STRING)
    SLIDEID__FIELD_NAME: WrapperField = WrapperField("SlideId", FieldType.STRING)
    SLIDEPOSITION__FIELD_NAME: WrapperField = WrapperField("SlidePosition", FieldType.SHORT)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_SampleId_field(self, value: Optional[str]):
        """
        Set data field with field name 'SampleId' on this record model
        """
        self.set_field_value(self.SAMPLEID__FIELD_NAME.field_name, value)

    def get_SampleId_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SampleId' from this record model
        """
        return self.get_field_value(self.SAMPLEID__FIELD_NAME.field_name)

    def set_SlideId_field(self, value: Optional[str]):
        """
        Set data field with field name 'SlideId' on this record model
        """
        self.set_field_value(self.SLIDEID__FIELD_NAME.field_name, value)

    def get_SlideId_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SlideId' from this record model
        """
        return self.get_field_value(self.SLIDEID__FIELD_NAME.field_name)

    def set_SlidePosition_field(self, value: Optional[int]):
        """
        Set data field with field name 'SlidePosition' on this record model
        """
        self.set_field_value(self.SLIDEPOSITION__FIELD_NAME.field_name, value)

    def get_SlidePosition_field(self) -> Optional[int]:
        """
        Get data field value with field name 'SlidePosition' from this record model
        """
        return self.get_field_value(self.SLIDEPOSITION__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class HistologyProtocol3Model(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type HistologyProtocol3
    Data Type Display Name: Histology Protocol 3 (Histology Protocol 3s)
    Fields: AssignedSpecialStain, CreatedBy, DataRecordName, DateCreated, SampleId, VeloxLastModifiedBy, VeloxLastModifiedDate
    """
    DATA_TYPE_NAME: str = 'HistologyProtocol3'
    ASSIGNEDSPECIALSTAIN__FIELD_NAME: WrapperField = WrapperField("AssignedSpecialStain", FieldType.STRING)
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    SAMPLEID__FIELD_NAME: WrapperField = WrapperField("SampleId", FieldType.STRING)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_AssignedSpecialStain_field(self, value: Optional[str]):
        """
        Set data field with field name 'AssignedSpecialStain' on this record model
        """
        self.set_field_value(self.ASSIGNEDSPECIALSTAIN__FIELD_NAME.field_name, value)

    def get_AssignedSpecialStain_field(self) -> Optional[str]:
        """
        Get data field value with field name 'AssignedSpecialStain' from this record model
        """
        return self.get_field_value(self.ASSIGNEDSPECIALSTAIN__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_SampleId_field(self, value: Optional[str]):
        """
        Set data field with field name 'SampleId' on this record model
        """
        self.set_field_value(self.SAMPLEID__FIELD_NAME.field_name, value)

    def get_SampleId_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SampleId' from this record model
        """
        return self.get_field_value(self.SAMPLEID__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class HistologySlideModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type HistologySlide
    Data Type Display Name: Histology Slide (Histology Slide)
    Fields: AperioId, AperioImageId, AssignedDosage, AssignedGroups, AssignedStain, AssignedTissue, CreatedBy, DataRecordName, DateCreated, FileIdentifier, FilePath, GeneratedLayoutAssignedStain, GeneratedLayoutSlideId, MultiParentLink215, NumSections, ProtocolNumber, SampleGroupByFieldIds, SlideId, SlideIdClonedFrom, VeloxCurrentVersion, VeloxLastModifiedBy, VeloxLastModifiedDate
    """
    DATA_TYPE_NAME: str = 'HistologySlide'
    APERIOID__FIELD_NAME: WrapperField = WrapperField("AperioId", FieldType.STRING)
    APERIOIMAGEID__FIELD_NAME: WrapperField = WrapperField("AperioImageId", FieldType.STRING)
    ASSIGNEDDOSAGE__FIELD_NAME: WrapperField = WrapperField("AssignedDosage", FieldType.STRING)
    ASSIGNEDGROUPS__FIELD_NAME: WrapperField = WrapperField("AssignedGroups", FieldType.STRING)
    ASSIGNEDSTAIN__FIELD_NAME: WrapperField = WrapperField("AssignedStain", FieldType.STRING)
    ASSIGNEDTISSUE__FIELD_NAME: WrapperField = WrapperField("AssignedTissue", FieldType.STRING)
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    FILEIDENTIFIER__FIELD_NAME: WrapperField = WrapperField("FileIdentifier", FieldType.STRING)
    FILEPATH__FIELD_NAME: WrapperField = WrapperField("FilePath", FieldType.STRING)
    GENERATEDLAYOUTASSIGNEDSTAIN__FIELD_NAME: WrapperField = WrapperField("GeneratedLayoutAssignedStain", FieldType.STRING)
    GENERATEDLAYOUTSLIDEID__FIELD_NAME: WrapperField = WrapperField("GeneratedLayoutSlideId", FieldType.STRING)
    MULTIPARENTLINK215__FIELD_NAME: WrapperField = WrapperField("MultiParentLink215", FieldType.MULTIPARENTLINK)
    NUMSECTIONS__FIELD_NAME: WrapperField = WrapperField("NumSections", FieldType.INTEGER)
    PROTOCOLNUMBER__FIELD_NAME: WrapperField = WrapperField("ProtocolNumber", FieldType.STRING)
    SAMPLEGROUPBYFIELDIDS__FIELD_NAME: WrapperField = WrapperField("SampleGroupByFieldIds", FieldType.STRING)
    SLIDEID__FIELD_NAME: WrapperField = WrapperField("SlideId", FieldType.STRING)
    SLIDEIDCLONEDFROM__FIELD_NAME: WrapperField = WrapperField("SlideIdClonedFrom", FieldType.STRING)
    VELOXCURRENTVERSION__FIELD_NAME: WrapperField = WrapperField("VeloxCurrentVersion", FieldType.INTEGER)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_AperioId_field(self, value: Optional[str]):
        """
        Set data field with field name 'AperioId' on this record model
        """
        self.set_field_value(self.APERIOID__FIELD_NAME.field_name, value)

    def get_AperioId_field(self) -> Optional[str]:
        """
        Get data field value with field name 'AperioId' from this record model
        """
        return self.get_field_value(self.APERIOID__FIELD_NAME.field_name)

    def set_AperioImageId_field(self, value: Optional[str]):
        """
        Set data field with field name 'AperioImageId' on this record model
        """
        self.set_field_value(self.APERIOIMAGEID__FIELD_NAME.field_name, value)

    def get_AperioImageId_field(self) -> Optional[str]:
        """
        Get data field value with field name 'AperioImageId' from this record model
        """
        return self.get_field_value(self.APERIOIMAGEID__FIELD_NAME.field_name)

    def set_AssignedDosage_field(self, value: Optional[str]):
        """
        Set data field with field name 'AssignedDosage' on this record model
        """
        self.set_field_value(self.ASSIGNEDDOSAGE__FIELD_NAME.field_name, value)

    def get_AssignedDosage_field(self) -> Optional[str]:
        """
        Get data field value with field name 'AssignedDosage' from this record model
        """
        return self.get_field_value(self.ASSIGNEDDOSAGE__FIELD_NAME.field_name)

    def set_AssignedGroups_field(self, value: Optional[str]):
        """
        Set data field with field name 'AssignedGroups' on this record model
        """
        self.set_field_value(self.ASSIGNEDGROUPS__FIELD_NAME.field_name, value)

    def get_AssignedGroups_field(self) -> Optional[str]:
        """
        Get data field value with field name 'AssignedGroups' from this record model
        """
        return self.get_field_value(self.ASSIGNEDGROUPS__FIELD_NAME.field_name)

    def set_AssignedStain_field(self, value: Optional[str]):
        """
        Set data field with field name 'AssignedStain' on this record model
        """
        self.set_field_value(self.ASSIGNEDSTAIN__FIELD_NAME.field_name, value)

    def get_AssignedStain_field(self) -> Optional[str]:
        """
        Get data field value with field name 'AssignedStain' from this record model
        """
        return self.get_field_value(self.ASSIGNEDSTAIN__FIELD_NAME.field_name)

    def set_AssignedTissue_field(self, value: Optional[str]):
        """
        Set data field with field name 'AssignedTissue' on this record model
        """
        self.set_field_value(self.ASSIGNEDTISSUE__FIELD_NAME.field_name, value)

    def get_AssignedTissue_field(self) -> Optional[str]:
        """
        Get data field value with field name 'AssignedTissue' from this record model
        """
        return self.get_field_value(self.ASSIGNEDTISSUE__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_FileIdentifier_field(self, value: Optional[str]):
        """
        Set data field with field name 'FileIdentifier' on this record model
        """
        self.set_field_value(self.FILEIDENTIFIER__FIELD_NAME.field_name, value)

    def get_FileIdentifier_field(self) -> Optional[str]:
        """
        Get data field value with field name 'FileIdentifier' from this record model
        """
        return self.get_field_value(self.FILEIDENTIFIER__FIELD_NAME.field_name)

    def set_FilePath_field(self, value: Optional[str]):
        """
        Set data field with field name 'FilePath' on this record model
        """
        self.set_field_value(self.FILEPATH__FIELD_NAME.field_name, value)

    def get_FilePath_field(self) -> Optional[str]:
        """
        Get data field value with field name 'FilePath' from this record model
        """
        return self.get_field_value(self.FILEPATH__FIELD_NAME.field_name)

    def set_GeneratedLayoutAssignedStain_field(self, value: Optional[str]):
        """
        Set data field with field name 'GeneratedLayoutAssignedStain' on this record model
        """
        self.set_field_value(self.GENERATEDLAYOUTASSIGNEDSTAIN__FIELD_NAME.field_name, value)

    def get_GeneratedLayoutAssignedStain_field(self) -> Optional[str]:
        """
        Get data field value with field name 'GeneratedLayoutAssignedStain' from this record model
        """
        return self.get_field_value(self.GENERATEDLAYOUTASSIGNEDSTAIN__FIELD_NAME.field_name)

    def set_GeneratedLayoutSlideId_field(self, value: Optional[str]):
        """
        Set data field with field name 'GeneratedLayoutSlideId' on this record model
        """
        self.set_field_value(self.GENERATEDLAYOUTSLIDEID__FIELD_NAME.field_name, value)

    def get_GeneratedLayoutSlideId_field(self) -> Optional[str]:
        """
        Get data field value with field name 'GeneratedLayoutSlideId' from this record model
        """
        return self.get_field_value(self.GENERATEDLAYOUTSLIDEID__FIELD_NAME.field_name)

    def set_NumSections_field(self, value: Optional[int]):
        """
        Set data field with field name 'NumSections' on this record model
        """
        self.set_field_value(self.NUMSECTIONS__FIELD_NAME.field_name, value)

    def get_NumSections_field(self) -> Optional[int]:
        """
        Get data field value with field name 'NumSections' from this record model
        """
        return self.get_field_value(self.NUMSECTIONS__FIELD_NAME.field_name)

    def set_ProtocolNumber_field(self, value: Optional[str]):
        """
        Set data field with field name 'ProtocolNumber' on this record model
        """
        self.set_field_value(self.PROTOCOLNUMBER__FIELD_NAME.field_name, value)

    def get_ProtocolNumber_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ProtocolNumber' from this record model
        """
        return self.get_field_value(self.PROTOCOLNUMBER__FIELD_NAME.field_name)

    def set_SampleGroupByFieldIds_field(self, value: Optional[str]):
        """
        Set data field with field name 'SampleGroupByFieldIds' on this record model
        """
        self.set_field_value(self.SAMPLEGROUPBYFIELDIDS__FIELD_NAME.field_name, value)

    def get_SampleGroupByFieldIds_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SampleGroupByFieldIds' from this record model
        """
        return self.get_field_value(self.SAMPLEGROUPBYFIELDIDS__FIELD_NAME.field_name)

    def set_SlideId_field(self, value: Optional[str]):
        """
        Set data field with field name 'SlideId' on this record model
        """
        self.set_field_value(self.SLIDEID__FIELD_NAME.field_name, value)

    def get_SlideId_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SlideId' from this record model
        """
        return self.get_field_value(self.SLIDEID__FIELD_NAME.field_name)

    def set_SlideIdClonedFrom_field(self, value: Optional[str]):
        """
        Set data field with field name 'SlideIdClonedFrom' on this record model
        """
        self.set_field_value(self.SLIDEIDCLONEDFROM__FIELD_NAME.field_name, value)

    def get_SlideIdClonedFrom_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SlideIdClonedFrom' from this record model
        """
        return self.get_field_value(self.SLIDEIDCLONEDFROM__FIELD_NAME.field_name)

    def set_VeloxCurrentVersion_field(self, value: Optional[int]):
        """
        Set data field with field name 'VeloxCurrentVersion' on this record model
        """
        self.set_field_value(self.VELOXCURRENTVERSION__FIELD_NAME.field_name, value)

    def get_VeloxCurrentVersion_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxCurrentVersion' from this record model
        """
        return self.get_field_value(self.VELOXCURRENTVERSION__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class HPLCDetailModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type HPLCDetail
    Data Type Display Name: HPLC Detail (HPLC Details)
    Fields: CreatedBy, DataRecordName, DateCreated, HPLCHigh, HPLCLow, HPLCValue, VeloxLastModifiedBy, VeloxLastModifiedDate
    """
    DATA_TYPE_NAME: str = 'HPLCDetail'
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    HPLCHIGH__FIELD_NAME: WrapperField = WrapperField("HPLCHigh", FieldType.DOUBLE)
    HPLCLOW__FIELD_NAME: WrapperField = WrapperField("HPLCLow", FieldType.DOUBLE)
    HPLCVALUE__FIELD_NAME: WrapperField = WrapperField("HPLCValue", FieldType.DOUBLE)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_HPLCHigh_field(self, value: Optional[float]):
        """
        Set data field with field name 'HPLCHigh' on this record model
        """
        self.set_field_value(self.HPLCHIGH__FIELD_NAME.field_name, value)

    def get_HPLCHigh_field(self) -> Optional[float]:
        """
        Get data field value with field name 'HPLCHigh' from this record model
        """
        return self.get_field_value(self.HPLCHIGH__FIELD_NAME.field_name)

    def set_HPLCLow_field(self, value: Optional[float]):
        """
        Set data field with field name 'HPLCLow' on this record model
        """
        self.set_field_value(self.HPLCLOW__FIELD_NAME.field_name, value)

    def get_HPLCLow_field(self) -> Optional[float]:
        """
        Get data field value with field name 'HPLCLow' from this record model
        """
        return self.get_field_value(self.HPLCLOW__FIELD_NAME.field_name)

    def set_HPLCValue_field(self, value: Optional[float]):
        """
        Set data field with field name 'HPLCValue' on this record model
        """
        self.set_field_value(self.HPLCVALUE__FIELD_NAME.field_name, value)

    def get_HPLCValue_field(self) -> Optional[float]:
        """
        Get data field value with field name 'HPLCValue' from this record model
        """
        return self.get_field_value(self.HPLCVALUE__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class IGBlastNGermlineModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type IGBlastNGermline
    Data Type Display Name: igBlastN Germline (igBlastN Germlines)
    Fields: AuxFileName, CreatedBy, DataRecordName, DateCreated, DFileName, FilePath, GermlineName, JFileName, Organism, VeloxCurrentVersion, VeloxLastModifiedBy, VeloxLastModifiedDate, VFileName
    An attachment of germline file used for IGBlastN.
    """
    DATA_TYPE_NAME: str = 'IGBlastNGermline'
    AUXFILENAME__FIELD_NAME: WrapperField = WrapperField("AuxFileName", FieldType.STRING)
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    DFILENAME__FIELD_NAME: WrapperField = WrapperField("DFileName", FieldType.STRING)
    FILEPATH__FIELD_NAME: WrapperField = WrapperField("FilePath", FieldType.STRING)
    GERMLINENAME__FIELD_NAME: WrapperField = WrapperField("GermlineName", FieldType.STRING)
    JFILENAME__FIELD_NAME: WrapperField = WrapperField("JFileName", FieldType.STRING)
    ORGANISM__FIELD_NAME: WrapperField = WrapperField("Organism", FieldType.PICKLIST)
    VELOXCURRENTVERSION__FIELD_NAME: WrapperField = WrapperField("VeloxCurrentVersion", FieldType.INTEGER)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)
    VFILENAME__FIELD_NAME: WrapperField = WrapperField("VFileName", FieldType.STRING)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_AuxFileName_field(self, value: Optional[str]):
        """
        Set data field with field name 'AuxFileName' on this record model
        """
        self.set_field_value(self.AUXFILENAME__FIELD_NAME.field_name, value)

    def get_AuxFileName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'AuxFileName' from this record model
        """
        return self.get_field_value(self.AUXFILENAME__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_DFileName_field(self, value: Optional[str]):
        """
        Set data field with field name 'DFileName' on this record model
        """
        self.set_field_value(self.DFILENAME__FIELD_NAME.field_name, value)

    def get_DFileName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'DFileName' from this record model
        """
        return self.get_field_value(self.DFILENAME__FIELD_NAME.field_name)

    def set_FilePath_field(self, value: Optional[str]):
        """
        Set data field with field name 'FilePath' on this record model
        """
        self.set_field_value(self.FILEPATH__FIELD_NAME.field_name, value)

    def get_FilePath_field(self) -> Optional[str]:
        """
        Get data field value with field name 'FilePath' from this record model
        """
        return self.get_field_value(self.FILEPATH__FIELD_NAME.field_name)

    def set_GermlineName_field(self, value: Optional[str]):
        """
        Set data field with field name 'GermlineName' on this record model
        """
        self.set_field_value(self.GERMLINENAME__FIELD_NAME.field_name, value)

    def get_GermlineName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'GermlineName' from this record model
        """
        return self.get_field_value(self.GERMLINENAME__FIELD_NAME.field_name)

    def set_JFileName_field(self, value: Optional[str]):
        """
        Set data field with field name 'JFileName' on this record model
        """
        self.set_field_value(self.JFILENAME__FIELD_NAME.field_name, value)

    def get_JFileName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'JFileName' from this record model
        """
        return self.get_field_value(self.JFILENAME__FIELD_NAME.field_name)

    def set_Organism_field(self, value: Optional[str]):
        """
        Set data field with field name 'Organism' on this record model
        """
        self.set_field_value(self.ORGANISM__FIELD_NAME.field_name, value)

    def get_Organism_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Organism' from this record model
        """
        return self.get_field_value(self.ORGANISM__FIELD_NAME.field_name)

    def set_VeloxCurrentVersion_field(self, value: Optional[int]):
        """
        Set data field with field name 'VeloxCurrentVersion' on this record model
        """
        self.set_field_value(self.VELOXCURRENTVERSION__FIELD_NAME.field_name, value)

    def get_VeloxCurrentVersion_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxCurrentVersion' from this record model
        """
        return self.get_field_value(self.VELOXCURRENTVERSION__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)

    def set_VFileName_field(self, value: Optional[str]):
        """
        Set data field with field name 'VFileName' on this record model
        """
        self.set_field_value(self.VFILENAME__FIELD_NAME.field_name, value)

    def get_VFileName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VFileName' from this record model
        """
        return self.get_field_value(self.VFILENAME__FIELD_NAME.field_name)


class IGBlastNResultModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type IGBlastNResult
    Data Type Display Name: igBlastN Result (igBlastN Results)
    Fields: CDR3UND, CDRTranslation, CreatedBy, CysNotTwo, DataRecordName, DateCreated, FilePath, FR4_Res1_NoTrp, FR4Res1NoPhe, germline, GermlineAllD, GermlineAllJ, GermlineAllV, NGlycosilationsites, NonProductive, NumCDRHistidine, NumCDRLysine, Siblings, StopCodons, VeloxCurrentVersion, VeloxLastModifiedBy, VeloxLastModifiedDate
    """
    DATA_TYPE_NAME: str = 'IGBlastNResult'
    CDR3UND__FIELD_NAME: WrapperField = WrapperField("CDR3UND", FieldType.BOOLEAN)
    CDRTRANSLATION__FIELD_NAME: WrapperField = WrapperField("CDRTranslation", FieldType.STRING)
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    CYSNOTTWO__FIELD_NAME: WrapperField = WrapperField("CysNotTwo", FieldType.BOOLEAN)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    FILEPATH__FIELD_NAME: WrapperField = WrapperField("FilePath", FieldType.STRING)
    FR4_RES1_NOTRP__FIELD_NAME: WrapperField = WrapperField("FR4_Res1_NoTrp", FieldType.BOOLEAN)
    FR4RES1NOPHE__FIELD_NAME: WrapperField = WrapperField("FR4Res1NoPhe", FieldType.BOOLEAN)
    GERMLINE__FIELD_NAME: WrapperField = WrapperField("germline", FieldType.STRING)
    GERMLINEALLD__FIELD_NAME: WrapperField = WrapperField("GermlineAllD", FieldType.STRING)
    GERMLINEALLJ__FIELD_NAME: WrapperField = WrapperField("GermlineAllJ", FieldType.STRING)
    GERMLINEALLV__FIELD_NAME: WrapperField = WrapperField("GermlineAllV", FieldType.STRING)
    NGLYCOSILATIONSITES__FIELD_NAME: WrapperField = WrapperField("NGlycosilationsites", FieldType.BOOLEAN)
    NONPRODUCTIVE__FIELD_NAME: WrapperField = WrapperField("NonProductive", FieldType.BOOLEAN)
    NUMCDRHISTIDINE__FIELD_NAME: WrapperField = WrapperField("NumCDRHistidine", FieldType.INTEGER)
    NUMCDRLYSINE__FIELD_NAME: WrapperField = WrapperField("NumCDRLysine", FieldType.INTEGER)
    SIBLINGS__FIELD_NAME: WrapperField = WrapperField("Siblings", FieldType.BOOLEAN)
    STOPCODONS__FIELD_NAME: WrapperField = WrapperField("StopCodons", FieldType.BOOLEAN)
    VELOXCURRENTVERSION__FIELD_NAME: WrapperField = WrapperField("VeloxCurrentVersion", FieldType.INTEGER)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_CDR3UND_field(self, value: Optional[bool]):
        """
        Set data field with field name 'CDR3UND' on this record model
        """
        self.set_field_value(self.CDR3UND__FIELD_NAME.field_name, value)

    def get_CDR3UND_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'CDR3UND' from this record model
        """
        return self.get_field_value(self.CDR3UND__FIELD_NAME.field_name)

    def set_CDRTranslation_field(self, value: Optional[str]):
        """
        Set data field with field name 'CDRTranslation' on this record model
        """
        self.set_field_value(self.CDRTRANSLATION__FIELD_NAME.field_name, value)

    def get_CDRTranslation_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CDRTranslation' from this record model
        """
        return self.get_field_value(self.CDRTRANSLATION__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def set_CysNotTwo_field(self, value: Optional[bool]):
        """
        Set data field with field name 'CysNotTwo' on this record model
        """
        self.set_field_value(self.CYSNOTTWO__FIELD_NAME.field_name, value)

    def get_CysNotTwo_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'CysNotTwo' from this record model
        """
        return self.get_field_value(self.CYSNOTTWO__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_FilePath_field(self, value: Optional[str]):
        """
        Set data field with field name 'FilePath' on this record model
        """
        self.set_field_value(self.FILEPATH__FIELD_NAME.field_name, value)

    def get_FilePath_field(self) -> Optional[str]:
        """
        Get data field value with field name 'FilePath' from this record model
        """
        return self.get_field_value(self.FILEPATH__FIELD_NAME.field_name)

    def set_FR4_Res1_NoTrp_field(self, value: Optional[bool]):
        """
        Set data field with field name 'FR4_Res1_NoTrp' on this record model
        """
        self.set_field_value(self.FR4_RES1_NOTRP__FIELD_NAME.field_name, value)

    def get_FR4_Res1_NoTrp_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'FR4_Res1_NoTrp' from this record model
        """
        return self.get_field_value(self.FR4_RES1_NOTRP__FIELD_NAME.field_name)

    def set_FR4Res1NoPhe_field(self, value: Optional[bool]):
        """
        Set data field with field name 'FR4Res1NoPhe' on this record model
        """
        self.set_field_value(self.FR4RES1NOPHE__FIELD_NAME.field_name, value)

    def get_FR4Res1NoPhe_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'FR4Res1NoPhe' from this record model
        """
        return self.get_field_value(self.FR4RES1NOPHE__FIELD_NAME.field_name)

    def set_germline_field(self, value: Optional[str]):
        """
        Set data field with field name 'germline' on this record model
        """
        self.set_field_value(self.GERMLINE__FIELD_NAME.field_name, value)

    def get_germline_field(self) -> Optional[str]:
        """
        Get data field value with field name 'germline' from this record model
        """
        return self.get_field_value(self.GERMLINE__FIELD_NAME.field_name)

    def set_GermlineAllD_field(self, value: Optional[str]):
        """
        Set data field with field name 'GermlineAllD' on this record model
        """
        self.set_field_value(self.GERMLINEALLD__FIELD_NAME.field_name, value)

    def get_GermlineAllD_field(self) -> Optional[str]:
        """
        Get data field value with field name 'GermlineAllD' from this record model
        """
        return self.get_field_value(self.GERMLINEALLD__FIELD_NAME.field_name)

    def set_GermlineAllJ_field(self, value: Optional[str]):
        """
        Set data field with field name 'GermlineAllJ' on this record model
        """
        self.set_field_value(self.GERMLINEALLJ__FIELD_NAME.field_name, value)

    def get_GermlineAllJ_field(self) -> Optional[str]:
        """
        Get data field value with field name 'GermlineAllJ' from this record model
        """
        return self.get_field_value(self.GERMLINEALLJ__FIELD_NAME.field_name)

    def set_GermlineAllV_field(self, value: Optional[str]):
        """
        Set data field with field name 'GermlineAllV' on this record model
        """
        self.set_field_value(self.GERMLINEALLV__FIELD_NAME.field_name, value)

    def get_GermlineAllV_field(self) -> Optional[str]:
        """
        Get data field value with field name 'GermlineAllV' from this record model
        """
        return self.get_field_value(self.GERMLINEALLV__FIELD_NAME.field_name)

    def set_NGlycosilationsites_field(self, value: Optional[bool]):
        """
        Set data field with field name 'NGlycosilationsites' on this record model
        """
        self.set_field_value(self.NGLYCOSILATIONSITES__FIELD_NAME.field_name, value)

    def get_NGlycosilationsites_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'NGlycosilationsites' from this record model
        """
        return self.get_field_value(self.NGLYCOSILATIONSITES__FIELD_NAME.field_name)

    def set_NonProductive_field(self, value: Optional[bool]):
        """
        Set data field with field name 'NonProductive' on this record model
        """
        self.set_field_value(self.NONPRODUCTIVE__FIELD_NAME.field_name, value)

    def get_NonProductive_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'NonProductive' from this record model
        """
        return self.get_field_value(self.NONPRODUCTIVE__FIELD_NAME.field_name)

    def set_NumCDRHistidine_field(self, value: Optional[int]):
        """
        Set data field with field name 'NumCDRHistidine' on this record model
        """
        self.set_field_value(self.NUMCDRHISTIDINE__FIELD_NAME.field_name, value)

    def get_NumCDRHistidine_field(self) -> Optional[int]:
        """
        Get data field value with field name 'NumCDRHistidine' from this record model
        """
        return self.get_field_value(self.NUMCDRHISTIDINE__FIELD_NAME.field_name)

    def set_NumCDRLysine_field(self, value: Optional[int]):
        """
        Set data field with field name 'NumCDRLysine' on this record model
        """
        self.set_field_value(self.NUMCDRLYSINE__FIELD_NAME.field_name, value)

    def get_NumCDRLysine_field(self) -> Optional[int]:
        """
        Get data field value with field name 'NumCDRLysine' from this record model
        """
        return self.get_field_value(self.NUMCDRLYSINE__FIELD_NAME.field_name)

    def set_Siblings_field(self, value: Optional[bool]):
        """
        Set data field with field name 'Siblings' on this record model
        """
        self.set_field_value(self.SIBLINGS__FIELD_NAME.field_name, value)

    def get_Siblings_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'Siblings' from this record model
        """
        return self.get_field_value(self.SIBLINGS__FIELD_NAME.field_name)

    def set_StopCodons_field(self, value: Optional[bool]):
        """
        Set data field with field name 'StopCodons' on this record model
        """
        self.set_field_value(self.STOPCODONS__FIELD_NAME.field_name, value)

    def get_StopCodons_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'StopCodons' from this record model
        """
        return self.get_field_value(self.STOPCODONS__FIELD_NAME.field_name)

    def set_VeloxCurrentVersion_field(self, value: Optional[int]):
        """
        Set data field with field name 'VeloxCurrentVersion' on this record model
        """
        self.set_field_value(self.VELOXCURRENTVERSION__FIELD_NAME.field_name, value)

    def get_VeloxCurrentVersion_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxCurrentVersion' from this record model
        """
        return self.get_field_value(self.VELOXCURRENTVERSION__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class IllSeqReadModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type IllSeqRead
    Data Type Display Name: Illumina Sequencing Read (Illumina Sequencing Reads)
    Fields: CreatedBy, DataRecordName, DateCreated, IsIndexedRead, NumCycles, VeloxLastModifiedBy, VeloxLastModifiedDate
    """
    DATA_TYPE_NAME: str = 'IllSeqRead'
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    ISINDEXEDREAD__FIELD_NAME: WrapperField = WrapperField("IsIndexedRead", FieldType.BOOLEAN)
    NUMCYCLES__FIELD_NAME: WrapperField = WrapperField("NumCycles", FieldType.INTEGER)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_IsIndexedRead_field(self, value: Optional[bool]):
        """
        Set data field with field name 'IsIndexedRead' on this record model
        """
        self.set_field_value(self.ISINDEXEDREAD__FIELD_NAME.field_name, value)

    def get_IsIndexedRead_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'IsIndexedRead' from this record model
        """
        return self.get_field_value(self.ISINDEXEDREAD__FIELD_NAME.field_name)

    def set_NumCycles_field(self, value: Optional[int]):
        """
        Set data field with field name 'NumCycles' on this record model
        """
        self.set_field_value(self.NUMCYCLES__FIELD_NAME.field_name, value)

    def get_NumCycles_field(self) -> Optional[int]:
        """
        Get data field value with field name 'NumCycles' from this record model
        """
        return self.get_field_value(self.NUMCYCLES__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class IlluminaHiSeqRunParametersModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type IlluminaHiSeqRunParameters
    Data Type Display Name: Illumina HiSeq Run Parameters (Illumina HiSeq Run Parameters')
    Fields: AdapterPlate, AlignToPhiXLane, ApplicationName, ApplicationVersion, AutoTiltOnce, Barcode, BaseSpaceRunId, BaseSpaceRunMonitoringOnly, BaseSpaceTempFolder, BaseSpaceUseBaseSpace, BaseSpaceUsername, CameraDriver, CameraFirmware, CanEditRunMode, ChemistryVersion, ComputerName, ControlLane, CopyImages, CPLDVersion, CreatedBy, CVGainPosLocked, CVGainStart, DataRecordName, DateCreated, DitherSize, EnableAnalysis, EnableAutoCenter, EnableBasecalling, EnableCameraLogging, EnableLft, EnableNotifications, ExperimentName, FCPosition, FirstBaseConfirmation, Flowcell, FocusCameraFirmware, FocusMethod, FPGAVersion, HotPixel, IGain, IHistory, ImageHeight, ImageWidth, IndexQuantity, IndexRead, IndexSerialNumber, IntensityCeiling, IsNew50Cycle, IsNew200Cycle, KeepIntensityFiles, LaneLength, MaxInitialZJumpHalfUm, MaxSubsequentZJumpHalfUm, MockRun, MotorDelayFrames, NumAnalysisThreads, NumberCyclesRemaining, NumberOfInitialZJumps, NumSwaths, NumTilesPerSwath, Offset, OutputFolder, PeQuantity, PerformPreRunFluidicsCheck, PeriodicSave, PeSerialNumber, Prime, PromptForPeReagents, Read1, Read2, RecipeFragmentVersion, Rehyb, Resume, ResumeCycle, RTAVersion, RunID, RunMode, RunStartDate, SampleSheet, SbsQuantity, SbsSerialNumber, ScanID, ScannerID, ScanNumber, SelectedSection_1, SelectedSection_2, SelectedSection_3, SelectedSection_4, SelectedSection_5, SelectedSection_6, SelectedSection_7, SelectedSection_8, SelectedSurface, SlideHolder, SupportMultipleSurfacesInUI, SwathScanMode, TempFolder, TemplateCycleCount, TileHeight, TileWidth, UseExistingRecipe, Username, VeloxLastModifiedBy, VeloxLastModifiedDate, WorkFlowType
     <!-- DISPLAY IN INSTRUMENT RUN MONITOR -->
    """
    DATA_TYPE_NAME: str = 'IlluminaHiSeqRunParameters'
    ADAPTERPLATE__FIELD_NAME: WrapperField = WrapperField("AdapterPlate", FieldType.STRING)
    ALIGNTOPHIXLANE__FIELD_NAME: WrapperField = WrapperField("AlignToPhiXLane", FieldType.STRING)
    APPLICATIONNAME__FIELD_NAME: WrapperField = WrapperField("ApplicationName", FieldType.STRING)
    APPLICATIONVERSION__FIELD_NAME: WrapperField = WrapperField("ApplicationVersion", FieldType.STRING)
    AUTOTILTONCE__FIELD_NAME: WrapperField = WrapperField("AutoTiltOnce", FieldType.BOOLEAN)
    BARCODE__FIELD_NAME: WrapperField = WrapperField("Barcode", FieldType.STRING)
    BASESPACERUNID__FIELD_NAME: WrapperField = WrapperField("BaseSpaceRunId", FieldType.STRING)
    BASESPACERUNMONITORINGONLY__FIELD_NAME: WrapperField = WrapperField("BaseSpaceRunMonitoringOnly", FieldType.BOOLEAN)
    BASESPACETEMPFOLDER__FIELD_NAME: WrapperField = WrapperField("BaseSpaceTempFolder", FieldType.STRING)
    BASESPACEUSEBASESPACE__FIELD_NAME: WrapperField = WrapperField("BaseSpaceUseBaseSpace", FieldType.BOOLEAN)
    BASESPACEUSERNAME__FIELD_NAME: WrapperField = WrapperField("BaseSpaceUsername", FieldType.STRING)
    CAMERADRIVER__FIELD_NAME: WrapperField = WrapperField("CameraDriver", FieldType.STRING)
    CAMERAFIRMWARE__FIELD_NAME: WrapperField = WrapperField("CameraFirmware", FieldType.STRING)
    CANEDITRUNMODE__FIELD_NAME: WrapperField = WrapperField("CanEditRunMode", FieldType.BOOLEAN)
    CHEMISTRYVERSION__FIELD_NAME: WrapperField = WrapperField("ChemistryVersion", FieldType.STRING)
    COMPUTERNAME__FIELD_NAME: WrapperField = WrapperField("ComputerName", FieldType.STRING)
    CONTROLLANE__FIELD_NAME: WrapperField = WrapperField("ControlLane", FieldType.STRING)
    COPYIMAGES__FIELD_NAME: WrapperField = WrapperField("CopyImages", FieldType.BOOLEAN)
    CPLDVERSION__FIELD_NAME: WrapperField = WrapperField("CPLDVersion", FieldType.STRING)
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    CVGAINPOSLOCKED__FIELD_NAME: WrapperField = WrapperField("CVGainPosLocked", FieldType.STRING)
    CVGAINSTART__FIELD_NAME: WrapperField = WrapperField("CVGainStart", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    DITHERSIZE__FIELD_NAME: WrapperField = WrapperField("DitherSize", FieldType.STRING)
    ENABLEANALYSIS__FIELD_NAME: WrapperField = WrapperField("EnableAnalysis", FieldType.BOOLEAN)
    ENABLEAUTOCENTER__FIELD_NAME: WrapperField = WrapperField("EnableAutoCenter", FieldType.BOOLEAN)
    ENABLEBASECALLING__FIELD_NAME: WrapperField = WrapperField("EnableBasecalling", FieldType.BOOLEAN)
    ENABLECAMERALOGGING__FIELD_NAME: WrapperField = WrapperField("EnableCameraLogging", FieldType.BOOLEAN)
    ENABLELFT__FIELD_NAME: WrapperField = WrapperField("EnableLft", FieldType.BOOLEAN)
    ENABLENOTIFICATIONS__FIELD_NAME: WrapperField = WrapperField("EnableNotifications", FieldType.BOOLEAN)
    EXPERIMENTNAME__FIELD_NAME: WrapperField = WrapperField("ExperimentName", FieldType.STRING)
    FCPOSITION__FIELD_NAME: WrapperField = WrapperField("FCPosition", FieldType.STRING)
    FIRSTBASECONFIRMATION__FIELD_NAME: WrapperField = WrapperField("FirstBaseConfirmation", FieldType.STRING)
    FLOWCELL__FIELD_NAME: WrapperField = WrapperField("Flowcell", FieldType.STRING)
    FOCUSCAMERAFIRMWARE__FIELD_NAME: WrapperField = WrapperField("FocusCameraFirmware", FieldType.STRING)
    FOCUSMETHOD__FIELD_NAME: WrapperField = WrapperField("FocusMethod", FieldType.STRING)
    FPGAVERSION__FIELD_NAME: WrapperField = WrapperField("FPGAVersion", FieldType.STRING)
    HOTPIXEL__FIELD_NAME: WrapperField = WrapperField("HotPixel", FieldType.STRING)
    IGAIN__FIELD_NAME: WrapperField = WrapperField("IGain", FieldType.STRING)
    IHISTORY__FIELD_NAME: WrapperField = WrapperField("IHistory", FieldType.STRING)
    IMAGEHEIGHT__FIELD_NAME: WrapperField = WrapperField("ImageHeight", FieldType.STRING)
    IMAGEWIDTH__FIELD_NAME: WrapperField = WrapperField("ImageWidth", FieldType.STRING)
    INDEXQUANTITY__FIELD_NAME: WrapperField = WrapperField("IndexQuantity", FieldType.DOUBLE)
    INDEXREAD__FIELD_NAME: WrapperField = WrapperField("IndexRead", FieldType.STRING)
    INDEXSERIALNUMBER__FIELD_NAME: WrapperField = WrapperField("IndexSerialNumber", FieldType.SELECTION)
    INTENSITYCEILING__FIELD_NAME: WrapperField = WrapperField("IntensityCeiling", FieldType.STRING)
    ISNEW50CYCLE__FIELD_NAME: WrapperField = WrapperField("IsNew50Cycle", FieldType.BOOLEAN)
    ISNEW200CYCLE__FIELD_NAME: WrapperField = WrapperField("IsNew200Cycle", FieldType.BOOLEAN)
    KEEPINTENSITYFILES__FIELD_NAME: WrapperField = WrapperField("KeepIntensityFiles", FieldType.STRING)
    LANELENGTH__FIELD_NAME: WrapperField = WrapperField("LaneLength", FieldType.STRING)
    MAXINITIALZJUMPHALFUM__FIELD_NAME: WrapperField = WrapperField("MaxInitialZJumpHalfUm", FieldType.STRING)
    MAXSUBSEQUENTZJUMPHALFUM__FIELD_NAME: WrapperField = WrapperField("MaxSubsequentZJumpHalfUm", FieldType.STRING)
    MOCKRUN__FIELD_NAME: WrapperField = WrapperField("MockRun", FieldType.BOOLEAN)
    MOTORDELAYFRAMES__FIELD_NAME: WrapperField = WrapperField("MotorDelayFrames", FieldType.STRING)
    NUMANALYSISTHREADS__FIELD_NAME: WrapperField = WrapperField("NumAnalysisThreads", FieldType.STRING)
    NUMBERCYCLESREMAINING__FIELD_NAME: WrapperField = WrapperField("NumberCyclesRemaining", FieldType.LONG)
    NUMBEROFINITIALZJUMPS__FIELD_NAME: WrapperField = WrapperField("NumberOfInitialZJumps", FieldType.STRING)
    NUMSWATHS__FIELD_NAME: WrapperField = WrapperField("NumSwaths", FieldType.STRING)
    NUMTILESPERSWATH__FIELD_NAME: WrapperField = WrapperField("NumTilesPerSwath", FieldType.STRING)
    OFFSET__FIELD_NAME: WrapperField = WrapperField("Offset", FieldType.STRING)
    OUTPUTFOLDER__FIELD_NAME: WrapperField = WrapperField("OutputFolder", FieldType.STRING)
    PEQUANTITY__FIELD_NAME: WrapperField = WrapperField("PeQuantity", FieldType.DOUBLE)
    PERFORMPRERUNFLUIDICSCHECK__FIELD_NAME: WrapperField = WrapperField("PerformPreRunFluidicsCheck", FieldType.BOOLEAN)
    PERIODICSAVE__FIELD_NAME: WrapperField = WrapperField("PeriodicSave", FieldType.STRING)
    PESERIALNUMBER__FIELD_NAME: WrapperField = WrapperField("PeSerialNumber", FieldType.SELECTION)
    PRIME__FIELD_NAME: WrapperField = WrapperField("Prime", FieldType.BOOLEAN)
    PROMPTFORPEREAGENTS__FIELD_NAME: WrapperField = WrapperField("PromptForPeReagents", FieldType.BOOLEAN)
    READ1__FIELD_NAME: WrapperField = WrapperField("Read1", FieldType.STRING)
    READ2__FIELD_NAME: WrapperField = WrapperField("Read2", FieldType.STRING)
    RECIPEFRAGMENTVERSION__FIELD_NAME: WrapperField = WrapperField("RecipeFragmentVersion", FieldType.STRING)
    REHYB__FIELD_NAME: WrapperField = WrapperField("Rehyb", FieldType.STRING)
    RESUME__FIELD_NAME: WrapperField = WrapperField("Resume", FieldType.BOOLEAN)
    RESUMECYCLE__FIELD_NAME: WrapperField = WrapperField("ResumeCycle", FieldType.STRING)
    RTAVERSION__FIELD_NAME: WrapperField = WrapperField("RTAVersion", FieldType.STRING)
    RUNID__FIELD_NAME: WrapperField = WrapperField("RunID", FieldType.STRING)
    RUNMODE__FIELD_NAME: WrapperField = WrapperField("RunMode", FieldType.STRING)
    RUNSTARTDATE__FIELD_NAME: WrapperField = WrapperField("RunStartDate", FieldType.DATE)
    SAMPLESHEET__FIELD_NAME: WrapperField = WrapperField("SampleSheet", FieldType.STRING)
    SBSQUANTITY__FIELD_NAME: WrapperField = WrapperField("SbsQuantity", FieldType.DOUBLE)
    SBSSERIALNUMBER__FIELD_NAME: WrapperField = WrapperField("SbsSerialNumber", FieldType.SELECTION)
    SCANID__FIELD_NAME: WrapperField = WrapperField("ScanID", FieldType.STRING)
    SCANNERID__FIELD_NAME: WrapperField = WrapperField("ScannerID", FieldType.STRING)
    SCANNUMBER__FIELD_NAME: WrapperField = WrapperField("ScanNumber", FieldType.LONG)
    SELECTEDSECTION_1__FIELD_NAME: WrapperField = WrapperField("SelectedSection_1", FieldType.STRING)
    SELECTEDSECTION_2__FIELD_NAME: WrapperField = WrapperField("SelectedSection_2", FieldType.STRING)
    SELECTEDSECTION_3__FIELD_NAME: WrapperField = WrapperField("SelectedSection_3", FieldType.STRING)
    SELECTEDSECTION_4__FIELD_NAME: WrapperField = WrapperField("SelectedSection_4", FieldType.STRING)
    SELECTEDSECTION_5__FIELD_NAME: WrapperField = WrapperField("SelectedSection_5", FieldType.STRING)
    SELECTEDSECTION_6__FIELD_NAME: WrapperField = WrapperField("SelectedSection_6", FieldType.STRING)
    SELECTEDSECTION_7__FIELD_NAME: WrapperField = WrapperField("SelectedSection_7", FieldType.STRING)
    SELECTEDSECTION_8__FIELD_NAME: WrapperField = WrapperField("SelectedSection_8", FieldType.STRING)
    SELECTEDSURFACE__FIELD_NAME: WrapperField = WrapperField("SelectedSurface", FieldType.STRING)
    SLIDEHOLDER__FIELD_NAME: WrapperField = WrapperField("SlideHolder", FieldType.STRING)
    SUPPORTMULTIPLESURFACESINUI__FIELD_NAME: WrapperField = WrapperField("SupportMultipleSurfacesInUI", FieldType.BOOLEAN)
    SWATHSCANMODE__FIELD_NAME: WrapperField = WrapperField("SwathScanMode", FieldType.STRING)
    TEMPFOLDER__FIELD_NAME: WrapperField = WrapperField("TempFolder", FieldType.STRING)
    TEMPLATECYCLECOUNT__FIELD_NAME: WrapperField = WrapperField("TemplateCycleCount", FieldType.STRING)
    TILEHEIGHT__FIELD_NAME: WrapperField = WrapperField("TileHeight", FieldType.STRING)
    TILEWIDTH__FIELD_NAME: WrapperField = WrapperField("TileWidth", FieldType.STRING)
    USEEXISTINGRECIPE__FIELD_NAME: WrapperField = WrapperField("UseExistingRecipe", FieldType.BOOLEAN)
    USERNAME__FIELD_NAME: WrapperField = WrapperField("Username", FieldType.STRING)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)
    WORKFLOWTYPE__FIELD_NAME: WrapperField = WrapperField("WorkFlowType", FieldType.STRING)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_AdapterPlate_field(self, value: Optional[str]):
        """
        Set data field with field name 'AdapterPlate' on this record model
        """
        self.set_field_value(self.ADAPTERPLATE__FIELD_NAME.field_name, value)

    def get_AdapterPlate_field(self) -> Optional[str]:
        """
        Get data field value with field name 'AdapterPlate' from this record model
        """
        return self.get_field_value(self.ADAPTERPLATE__FIELD_NAME.field_name)

    def set_AlignToPhiXLane_field(self, value: Optional[str]):
        """
        Set data field with field name 'AlignToPhiXLane' on this record model
        """
        self.set_field_value(self.ALIGNTOPHIXLANE__FIELD_NAME.field_name, value)

    def get_AlignToPhiXLane_field(self) -> Optional[str]:
        """
        Get data field value with field name 'AlignToPhiXLane' from this record model
        """
        return self.get_field_value(self.ALIGNTOPHIXLANE__FIELD_NAME.field_name)

    def set_ApplicationName_field(self, value: Optional[str]):
        """
        Set data field with field name 'ApplicationName' on this record model
        """
        self.set_field_value(self.APPLICATIONNAME__FIELD_NAME.field_name, value)

    def get_ApplicationName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ApplicationName' from this record model
        """
        return self.get_field_value(self.APPLICATIONNAME__FIELD_NAME.field_name)

    def set_ApplicationVersion_field(self, value: Optional[str]):
        """
        Set data field with field name 'ApplicationVersion' on this record model
        """
        self.set_field_value(self.APPLICATIONVERSION__FIELD_NAME.field_name, value)

    def get_ApplicationVersion_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ApplicationVersion' from this record model
        """
        return self.get_field_value(self.APPLICATIONVERSION__FIELD_NAME.field_name)

    def set_AutoTiltOnce_field(self, value: Optional[bool]):
        """
        Set data field with field name 'AutoTiltOnce' on this record model
        """
        self.set_field_value(self.AUTOTILTONCE__FIELD_NAME.field_name, value)

    def get_AutoTiltOnce_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'AutoTiltOnce' from this record model
        """
        return self.get_field_value(self.AUTOTILTONCE__FIELD_NAME.field_name)

    def set_Barcode_field(self, value: Optional[str]):
        """
        Set data field with field name 'Barcode' on this record model
        """
        self.set_field_value(self.BARCODE__FIELD_NAME.field_name, value)

    def get_Barcode_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Barcode' from this record model
        """
        return self.get_field_value(self.BARCODE__FIELD_NAME.field_name)

    def set_BaseSpaceRunId_field(self, value: Optional[str]):
        """
        Set data field with field name 'BaseSpaceRunId' on this record model
        """
        self.set_field_value(self.BASESPACERUNID__FIELD_NAME.field_name, value)

    def get_BaseSpaceRunId_field(self) -> Optional[str]:
        """
        Get data field value with field name 'BaseSpaceRunId' from this record model
        """
        return self.get_field_value(self.BASESPACERUNID__FIELD_NAME.field_name)

    def set_BaseSpaceRunMonitoringOnly_field(self, value: Optional[bool]):
        """
        Set data field with field name 'BaseSpaceRunMonitoringOnly' on this record model
        """
        self.set_field_value(self.BASESPACERUNMONITORINGONLY__FIELD_NAME.field_name, value)

    def get_BaseSpaceRunMonitoringOnly_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'BaseSpaceRunMonitoringOnly' from this record model
        """
        return self.get_field_value(self.BASESPACERUNMONITORINGONLY__FIELD_NAME.field_name)

    def set_BaseSpaceTempFolder_field(self, value: Optional[str]):
        """
        Set data field with field name 'BaseSpaceTempFolder' on this record model
        """
        self.set_field_value(self.BASESPACETEMPFOLDER__FIELD_NAME.field_name, value)

    def get_BaseSpaceTempFolder_field(self) -> Optional[str]:
        """
        Get data field value with field name 'BaseSpaceTempFolder' from this record model
        """
        return self.get_field_value(self.BASESPACETEMPFOLDER__FIELD_NAME.field_name)

    def set_BaseSpaceUseBaseSpace_field(self, value: Optional[bool]):
        """
        Set data field with field name 'BaseSpaceUseBaseSpace' on this record model
        """
        self.set_field_value(self.BASESPACEUSEBASESPACE__FIELD_NAME.field_name, value)

    def get_BaseSpaceUseBaseSpace_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'BaseSpaceUseBaseSpace' from this record model
        """
        return self.get_field_value(self.BASESPACEUSEBASESPACE__FIELD_NAME.field_name)

    def set_BaseSpaceUsername_field(self, value: Optional[str]):
        """
        Set data field with field name 'BaseSpaceUsername' on this record model
        """
        self.set_field_value(self.BASESPACEUSERNAME__FIELD_NAME.field_name, value)

    def get_BaseSpaceUsername_field(self) -> Optional[str]:
        """
        Get data field value with field name 'BaseSpaceUsername' from this record model
        """
        return self.get_field_value(self.BASESPACEUSERNAME__FIELD_NAME.field_name)

    def set_CameraDriver_field(self, value: Optional[str]):
        """
        Set data field with field name 'CameraDriver' on this record model
        """
        self.set_field_value(self.CAMERADRIVER__FIELD_NAME.field_name, value)

    def get_CameraDriver_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CameraDriver' from this record model
        """
        return self.get_field_value(self.CAMERADRIVER__FIELD_NAME.field_name)

    def set_CameraFirmware_field(self, value: Optional[str]):
        """
        Set data field with field name 'CameraFirmware' on this record model
        """
        self.set_field_value(self.CAMERAFIRMWARE__FIELD_NAME.field_name, value)

    def get_CameraFirmware_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CameraFirmware' from this record model
        """
        return self.get_field_value(self.CAMERAFIRMWARE__FIELD_NAME.field_name)

    def set_CanEditRunMode_field(self, value: Optional[bool]):
        """
        Set data field with field name 'CanEditRunMode' on this record model
        """
        self.set_field_value(self.CANEDITRUNMODE__FIELD_NAME.field_name, value)

    def get_CanEditRunMode_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'CanEditRunMode' from this record model
        """
        return self.get_field_value(self.CANEDITRUNMODE__FIELD_NAME.field_name)

    def set_ChemistryVersion_field(self, value: Optional[str]):
        """
        Set data field with field name 'ChemistryVersion' on this record model
        """
        self.set_field_value(self.CHEMISTRYVERSION__FIELD_NAME.field_name, value)

    def get_ChemistryVersion_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ChemistryVersion' from this record model
        """
        return self.get_field_value(self.CHEMISTRYVERSION__FIELD_NAME.field_name)

    def set_ComputerName_field(self, value: Optional[str]):
        """
        Set data field with field name 'ComputerName' on this record model
        """
        self.set_field_value(self.COMPUTERNAME__FIELD_NAME.field_name, value)

    def get_ComputerName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ComputerName' from this record model
        """
        return self.get_field_value(self.COMPUTERNAME__FIELD_NAME.field_name)

    def set_ControlLane_field(self, value: Optional[str]):
        """
        Set data field with field name 'ControlLane' on this record model
        """
        self.set_field_value(self.CONTROLLANE__FIELD_NAME.field_name, value)

    def get_ControlLane_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ControlLane' from this record model
        """
        return self.get_field_value(self.CONTROLLANE__FIELD_NAME.field_name)

    def set_CopyImages_field(self, value: Optional[bool]):
        """
        Set data field with field name 'CopyImages' on this record model
        """
        self.set_field_value(self.COPYIMAGES__FIELD_NAME.field_name, value)

    def get_CopyImages_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'CopyImages' from this record model
        """
        return self.get_field_value(self.COPYIMAGES__FIELD_NAME.field_name)

    def set_CPLDVersion_field(self, value: Optional[str]):
        """
        Set data field with field name 'CPLDVersion' on this record model
        """
        self.set_field_value(self.CPLDVERSION__FIELD_NAME.field_name, value)

    def get_CPLDVersion_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CPLDVersion' from this record model
        """
        return self.get_field_value(self.CPLDVERSION__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def set_CVGainPosLocked_field(self, value: Optional[str]):
        """
        Set data field with field name 'CVGainPosLocked' on this record model
        """
        self.set_field_value(self.CVGAINPOSLOCKED__FIELD_NAME.field_name, value)

    def get_CVGainPosLocked_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CVGainPosLocked' from this record model
        """
        return self.get_field_value(self.CVGAINPOSLOCKED__FIELD_NAME.field_name)

    def set_CVGainStart_field(self, value: Optional[str]):
        """
        Set data field with field name 'CVGainStart' on this record model
        """
        self.set_field_value(self.CVGAINSTART__FIELD_NAME.field_name, value)

    def get_CVGainStart_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CVGainStart' from this record model
        """
        return self.get_field_value(self.CVGAINSTART__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_DitherSize_field(self, value: Optional[str]):
        """
        Set data field with field name 'DitherSize' on this record model
        """
        self.set_field_value(self.DITHERSIZE__FIELD_NAME.field_name, value)

    def get_DitherSize_field(self) -> Optional[str]:
        """
        Get data field value with field name 'DitherSize' from this record model
        """
        return self.get_field_value(self.DITHERSIZE__FIELD_NAME.field_name)

    def set_EnableAnalysis_field(self, value: Optional[bool]):
        """
        Set data field with field name 'EnableAnalysis' on this record model
        """
        self.set_field_value(self.ENABLEANALYSIS__FIELD_NAME.field_name, value)

    def get_EnableAnalysis_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'EnableAnalysis' from this record model
        """
        return self.get_field_value(self.ENABLEANALYSIS__FIELD_NAME.field_name)

    def set_EnableAutoCenter_field(self, value: Optional[bool]):
        """
        Set data field with field name 'EnableAutoCenter' on this record model
        """
        self.set_field_value(self.ENABLEAUTOCENTER__FIELD_NAME.field_name, value)

    def get_EnableAutoCenter_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'EnableAutoCenter' from this record model
        """
        return self.get_field_value(self.ENABLEAUTOCENTER__FIELD_NAME.field_name)

    def set_EnableBasecalling_field(self, value: Optional[bool]):
        """
        Set data field with field name 'EnableBasecalling' on this record model
        """
        self.set_field_value(self.ENABLEBASECALLING__FIELD_NAME.field_name, value)

    def get_EnableBasecalling_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'EnableBasecalling' from this record model
        """
        return self.get_field_value(self.ENABLEBASECALLING__FIELD_NAME.field_name)

    def set_EnableCameraLogging_field(self, value: Optional[bool]):
        """
        Set data field with field name 'EnableCameraLogging' on this record model
        """
        self.set_field_value(self.ENABLECAMERALOGGING__FIELD_NAME.field_name, value)

    def get_EnableCameraLogging_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'EnableCameraLogging' from this record model
        """
        return self.get_field_value(self.ENABLECAMERALOGGING__FIELD_NAME.field_name)

    def set_EnableLft_field(self, value: Optional[bool]):
        """
        Set data field with field name 'EnableLft' on this record model
        """
        self.set_field_value(self.ENABLELFT__FIELD_NAME.field_name, value)

    def get_EnableLft_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'EnableLft' from this record model
        """
        return self.get_field_value(self.ENABLELFT__FIELD_NAME.field_name)

    def set_EnableNotifications_field(self, value: Optional[bool]):
        """
        Set data field with field name 'EnableNotifications' on this record model
        """
        self.set_field_value(self.ENABLENOTIFICATIONS__FIELD_NAME.field_name, value)

    def get_EnableNotifications_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'EnableNotifications' from this record model
        """
        return self.get_field_value(self.ENABLENOTIFICATIONS__FIELD_NAME.field_name)

    def set_ExperimentName_field(self, value: Optional[str]):
        """
        Set data field with field name 'ExperimentName' on this record model
        """
        self.set_field_value(self.EXPERIMENTNAME__FIELD_NAME.field_name, value)

    def get_ExperimentName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ExperimentName' from this record model
        """
        return self.get_field_value(self.EXPERIMENTNAME__FIELD_NAME.field_name)

    def set_FCPosition_field(self, value: Optional[str]):
        """
        Set data field with field name 'FCPosition' on this record model
        """
        self.set_field_value(self.FCPOSITION__FIELD_NAME.field_name, value)

    def get_FCPosition_field(self) -> Optional[str]:
        """
        Get data field value with field name 'FCPosition' from this record model
        """
        return self.get_field_value(self.FCPOSITION__FIELD_NAME.field_name)

    def set_FirstBaseConfirmation_field(self, value: Optional[str]):
        """
        Set data field with field name 'FirstBaseConfirmation' on this record model
        """
        self.set_field_value(self.FIRSTBASECONFIRMATION__FIELD_NAME.field_name, value)

    def get_FirstBaseConfirmation_field(self) -> Optional[str]:
        """
        Get data field value with field name 'FirstBaseConfirmation' from this record model
        """
        return self.get_field_value(self.FIRSTBASECONFIRMATION__FIELD_NAME.field_name)

    def set_Flowcell_field(self, value: Optional[str]):
        """
        Set data field with field name 'Flowcell' on this record model
        """
        self.set_field_value(self.FLOWCELL__FIELD_NAME.field_name, value)

    def get_Flowcell_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Flowcell' from this record model
        """
        return self.get_field_value(self.FLOWCELL__FIELD_NAME.field_name)

    def set_FocusCameraFirmware_field(self, value: Optional[str]):
        """
        Set data field with field name 'FocusCameraFirmware' on this record model
        """
        self.set_field_value(self.FOCUSCAMERAFIRMWARE__FIELD_NAME.field_name, value)

    def get_FocusCameraFirmware_field(self) -> Optional[str]:
        """
        Get data field value with field name 'FocusCameraFirmware' from this record model
        """
        return self.get_field_value(self.FOCUSCAMERAFIRMWARE__FIELD_NAME.field_name)

    def set_FocusMethod_field(self, value: Optional[str]):
        """
        Set data field with field name 'FocusMethod' on this record model
        """
        self.set_field_value(self.FOCUSMETHOD__FIELD_NAME.field_name, value)

    def get_FocusMethod_field(self) -> Optional[str]:
        """
        Get data field value with field name 'FocusMethod' from this record model
        """
        return self.get_field_value(self.FOCUSMETHOD__FIELD_NAME.field_name)

    def set_FPGAVersion_field(self, value: Optional[str]):
        """
        Set data field with field name 'FPGAVersion' on this record model
        """
        self.set_field_value(self.FPGAVERSION__FIELD_NAME.field_name, value)

    def get_FPGAVersion_field(self) -> Optional[str]:
        """
        Get data field value with field name 'FPGAVersion' from this record model
        """
        return self.get_field_value(self.FPGAVERSION__FIELD_NAME.field_name)

    def set_HotPixel_field(self, value: Optional[str]):
        """
        Set data field with field name 'HotPixel' on this record model
        """
        self.set_field_value(self.HOTPIXEL__FIELD_NAME.field_name, value)

    def get_HotPixel_field(self) -> Optional[str]:
        """
        Get data field value with field name 'HotPixel' from this record model
        """
        return self.get_field_value(self.HOTPIXEL__FIELD_NAME.field_name)

    def set_IGain_field(self, value: Optional[str]):
        """
        Set data field with field name 'IGain' on this record model
        """
        self.set_field_value(self.IGAIN__FIELD_NAME.field_name, value)

    def get_IGain_field(self) -> Optional[str]:
        """
        Get data field value with field name 'IGain' from this record model
        """
        return self.get_field_value(self.IGAIN__FIELD_NAME.field_name)

    def set_IHistory_field(self, value: Optional[str]):
        """
        Set data field with field name 'IHistory' on this record model
        """
        self.set_field_value(self.IHISTORY__FIELD_NAME.field_name, value)

    def get_IHistory_field(self) -> Optional[str]:
        """
        Get data field value with field name 'IHistory' from this record model
        """
        return self.get_field_value(self.IHISTORY__FIELD_NAME.field_name)

    def set_ImageHeight_field(self, value: Optional[str]):
        """
        Set data field with field name 'ImageHeight' on this record model
        """
        self.set_field_value(self.IMAGEHEIGHT__FIELD_NAME.field_name, value)

    def get_ImageHeight_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ImageHeight' from this record model
        """
        return self.get_field_value(self.IMAGEHEIGHT__FIELD_NAME.field_name)

    def set_ImageWidth_field(self, value: Optional[str]):
        """
        Set data field with field name 'ImageWidth' on this record model
        """
        self.set_field_value(self.IMAGEWIDTH__FIELD_NAME.field_name, value)

    def get_ImageWidth_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ImageWidth' from this record model
        """
        return self.get_field_value(self.IMAGEWIDTH__FIELD_NAME.field_name)

    def set_IndexQuantity_field(self, value: Optional[float]):
        """
        Set data field with field name 'IndexQuantity' on this record model
        """
        self.set_field_value(self.INDEXQUANTITY__FIELD_NAME.field_name, value)

    def get_IndexQuantity_field(self) -> Optional[float]:
        """
        Get data field value with field name 'IndexQuantity' from this record model
        """
        return self.get_field_value(self.INDEXQUANTITY__FIELD_NAME.field_name)

    def set_IndexRead_field(self, value: Optional[str]):
        """
        Set data field with field name 'IndexRead' on this record model
        """
        self.set_field_value(self.INDEXREAD__FIELD_NAME.field_name, value)

    def get_IndexRead_field(self) -> Optional[str]:
        """
        Get data field value with field name 'IndexRead' from this record model
        """
        return self.get_field_value(self.INDEXREAD__FIELD_NAME.field_name)

    def set_IndexSerialNumber_field(self, value: Optional[str]):
        """
        Set data field with field name 'IndexSerialNumber' on this record model
        """
        self.set_field_value(self.INDEXSERIALNUMBER__FIELD_NAME.field_name, value)

    def get_IndexSerialNumber_field(self) -> Optional[str]:
        """
        Get data field value with field name 'IndexSerialNumber' from this record model
        """
        return self.get_field_value(self.INDEXSERIALNUMBER__FIELD_NAME.field_name)

    def set_IntensityCeiling_field(self, value: Optional[str]):
        """
        Set data field with field name 'IntensityCeiling' on this record model
        """
        self.set_field_value(self.INTENSITYCEILING__FIELD_NAME.field_name, value)

    def get_IntensityCeiling_field(self) -> Optional[str]:
        """
        Get data field value with field name 'IntensityCeiling' from this record model
        """
        return self.get_field_value(self.INTENSITYCEILING__FIELD_NAME.field_name)

    def set_IsNew50Cycle_field(self, value: Optional[bool]):
        """
        Set data field with field name 'IsNew50Cycle' on this record model
        """
        self.set_field_value(self.ISNEW50CYCLE__FIELD_NAME.field_name, value)

    def get_IsNew50Cycle_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'IsNew50Cycle' from this record model
        """
        return self.get_field_value(self.ISNEW50CYCLE__FIELD_NAME.field_name)

    def set_IsNew200Cycle_field(self, value: Optional[bool]):
        """
        Set data field with field name 'IsNew200Cycle' on this record model
        """
        self.set_field_value(self.ISNEW200CYCLE__FIELD_NAME.field_name, value)

    def get_IsNew200Cycle_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'IsNew200Cycle' from this record model
        """
        return self.get_field_value(self.ISNEW200CYCLE__FIELD_NAME.field_name)

    def set_KeepIntensityFiles_field(self, value: Optional[str]):
        """
        Set data field with field name 'KeepIntensityFiles' on this record model
        """
        self.set_field_value(self.KEEPINTENSITYFILES__FIELD_NAME.field_name, value)

    def get_KeepIntensityFiles_field(self) -> Optional[str]:
        """
        Get data field value with field name 'KeepIntensityFiles' from this record model
        """
        return self.get_field_value(self.KEEPINTENSITYFILES__FIELD_NAME.field_name)

    def set_LaneLength_field(self, value: Optional[str]):
        """
        Set data field with field name 'LaneLength' on this record model
        """
        self.set_field_value(self.LANELENGTH__FIELD_NAME.field_name, value)

    def get_LaneLength_field(self) -> Optional[str]:
        """
        Get data field value with field name 'LaneLength' from this record model
        """
        return self.get_field_value(self.LANELENGTH__FIELD_NAME.field_name)

    def set_MaxInitialZJumpHalfUm_field(self, value: Optional[str]):
        """
        Set data field with field name 'MaxInitialZJumpHalfUm' on this record model
        """
        self.set_field_value(self.MAXINITIALZJUMPHALFUM__FIELD_NAME.field_name, value)

    def get_MaxInitialZJumpHalfUm_field(self) -> Optional[str]:
        """
        Get data field value with field name 'MaxInitialZJumpHalfUm' from this record model
        """
        return self.get_field_value(self.MAXINITIALZJUMPHALFUM__FIELD_NAME.field_name)

    def set_MaxSubsequentZJumpHalfUm_field(self, value: Optional[str]):
        """
        Set data field with field name 'MaxSubsequentZJumpHalfUm' on this record model
        """
        self.set_field_value(self.MAXSUBSEQUENTZJUMPHALFUM__FIELD_NAME.field_name, value)

    def get_MaxSubsequentZJumpHalfUm_field(self) -> Optional[str]:
        """
        Get data field value with field name 'MaxSubsequentZJumpHalfUm' from this record model
        """
        return self.get_field_value(self.MAXSUBSEQUENTZJUMPHALFUM__FIELD_NAME.field_name)

    def set_MockRun_field(self, value: Optional[bool]):
        """
        Set data field with field name 'MockRun' on this record model
        """
        self.set_field_value(self.MOCKRUN__FIELD_NAME.field_name, value)

    def get_MockRun_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'MockRun' from this record model
        """
        return self.get_field_value(self.MOCKRUN__FIELD_NAME.field_name)

    def set_MotorDelayFrames_field(self, value: Optional[str]):
        """
        Set data field with field name 'MotorDelayFrames' on this record model
        """
        self.set_field_value(self.MOTORDELAYFRAMES__FIELD_NAME.field_name, value)

    def get_MotorDelayFrames_field(self) -> Optional[str]:
        """
        Get data field value with field name 'MotorDelayFrames' from this record model
        """
        return self.get_field_value(self.MOTORDELAYFRAMES__FIELD_NAME.field_name)

    def set_NumAnalysisThreads_field(self, value: Optional[str]):
        """
        Set data field with field name 'NumAnalysisThreads' on this record model
        """
        self.set_field_value(self.NUMANALYSISTHREADS__FIELD_NAME.field_name, value)

    def get_NumAnalysisThreads_field(self) -> Optional[str]:
        """
        Get data field value with field name 'NumAnalysisThreads' from this record model
        """
        return self.get_field_value(self.NUMANALYSISTHREADS__FIELD_NAME.field_name)

    def set_NumberCyclesRemaining_field(self, value: Optional[int]):
        """
        Set data field with field name 'NumberCyclesRemaining' on this record model
        """
        self.set_field_value(self.NUMBERCYCLESREMAINING__FIELD_NAME.field_name, value)

    def get_NumberCyclesRemaining_field(self) -> Optional[int]:
        """
        Get data field value with field name 'NumberCyclesRemaining' from this record model
        """
        return self.get_field_value(self.NUMBERCYCLESREMAINING__FIELD_NAME.field_name)

    def set_NumberOfInitialZJumps_field(self, value: Optional[str]):
        """
        Set data field with field name 'NumberOfInitialZJumps' on this record model
        """
        self.set_field_value(self.NUMBEROFINITIALZJUMPS__FIELD_NAME.field_name, value)

    def get_NumberOfInitialZJumps_field(self) -> Optional[str]:
        """
        Get data field value with field name 'NumberOfInitialZJumps' from this record model
        """
        return self.get_field_value(self.NUMBEROFINITIALZJUMPS__FIELD_NAME.field_name)

    def set_NumSwaths_field(self, value: Optional[str]):
        """
        Set data field with field name 'NumSwaths' on this record model
        """
        self.set_field_value(self.NUMSWATHS__FIELD_NAME.field_name, value)

    def get_NumSwaths_field(self) -> Optional[str]:
        """
        Get data field value with field name 'NumSwaths' from this record model
        """
        return self.get_field_value(self.NUMSWATHS__FIELD_NAME.field_name)

    def set_NumTilesPerSwath_field(self, value: Optional[str]):
        """
        Set data field with field name 'NumTilesPerSwath' on this record model
        """
        self.set_field_value(self.NUMTILESPERSWATH__FIELD_NAME.field_name, value)

    def get_NumTilesPerSwath_field(self) -> Optional[str]:
        """
        Get data field value with field name 'NumTilesPerSwath' from this record model
        """
        return self.get_field_value(self.NUMTILESPERSWATH__FIELD_NAME.field_name)

    def set_Offset_field(self, value: Optional[str]):
        """
        Set data field with field name 'Offset' on this record model
        """
        self.set_field_value(self.OFFSET__FIELD_NAME.field_name, value)

    def get_Offset_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Offset' from this record model
        """
        return self.get_field_value(self.OFFSET__FIELD_NAME.field_name)

    def set_OutputFolder_field(self, value: Optional[str]):
        """
        Set data field with field name 'OutputFolder' on this record model
        """
        self.set_field_value(self.OUTPUTFOLDER__FIELD_NAME.field_name, value)

    def get_OutputFolder_field(self) -> Optional[str]:
        """
        Get data field value with field name 'OutputFolder' from this record model
        """
        return self.get_field_value(self.OUTPUTFOLDER__FIELD_NAME.field_name)

    def set_PeQuantity_field(self, value: Optional[float]):
        """
        Set data field with field name 'PeQuantity' on this record model
        """
        self.set_field_value(self.PEQUANTITY__FIELD_NAME.field_name, value)

    def get_PeQuantity_field(self) -> Optional[float]:
        """
        Get data field value with field name 'PeQuantity' from this record model
        """
        return self.get_field_value(self.PEQUANTITY__FIELD_NAME.field_name)

    def set_PerformPreRunFluidicsCheck_field(self, value: Optional[bool]):
        """
        Set data field with field name 'PerformPreRunFluidicsCheck' on this record model
        """
        self.set_field_value(self.PERFORMPRERUNFLUIDICSCHECK__FIELD_NAME.field_name, value)

    def get_PerformPreRunFluidicsCheck_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'PerformPreRunFluidicsCheck' from this record model
        """
        return self.get_field_value(self.PERFORMPRERUNFLUIDICSCHECK__FIELD_NAME.field_name)

    def set_PeriodicSave_field(self, value: Optional[str]):
        """
        Set data field with field name 'PeriodicSave' on this record model
        """
        self.set_field_value(self.PERIODICSAVE__FIELD_NAME.field_name, value)

    def get_PeriodicSave_field(self) -> Optional[str]:
        """
        Get data field value with field name 'PeriodicSave' from this record model
        """
        return self.get_field_value(self.PERIODICSAVE__FIELD_NAME.field_name)

    def set_PeSerialNumber_field(self, value: Optional[str]):
        """
        Set data field with field name 'PeSerialNumber' on this record model
        """
        self.set_field_value(self.PESERIALNUMBER__FIELD_NAME.field_name, value)

    def get_PeSerialNumber_field(self) -> Optional[str]:
        """
        Get data field value with field name 'PeSerialNumber' from this record model
        """
        return self.get_field_value(self.PESERIALNUMBER__FIELD_NAME.field_name)

    def set_Prime_field(self, value: Optional[bool]):
        """
        Set data field with field name 'Prime' on this record model
        """
        self.set_field_value(self.PRIME__FIELD_NAME.field_name, value)

    def get_Prime_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'Prime' from this record model
        """
        return self.get_field_value(self.PRIME__FIELD_NAME.field_name)

    def set_PromptForPeReagents_field(self, value: Optional[bool]):
        """
        Set data field with field name 'PromptForPeReagents' on this record model
        """
        self.set_field_value(self.PROMPTFORPEREAGENTS__FIELD_NAME.field_name, value)

    def get_PromptForPeReagents_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'PromptForPeReagents' from this record model
        """
        return self.get_field_value(self.PROMPTFORPEREAGENTS__FIELD_NAME.field_name)

    def set_Read1_field(self, value: Optional[str]):
        """
        Set data field with field name 'Read1' on this record model
        """
        self.set_field_value(self.READ1__FIELD_NAME.field_name, value)

    def get_Read1_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Read1' from this record model
        """
        return self.get_field_value(self.READ1__FIELD_NAME.field_name)

    def set_Read2_field(self, value: Optional[str]):
        """
        Set data field with field name 'Read2' on this record model
        """
        self.set_field_value(self.READ2__FIELD_NAME.field_name, value)

    def get_Read2_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Read2' from this record model
        """
        return self.get_field_value(self.READ2__FIELD_NAME.field_name)

    def set_RecipeFragmentVersion_field(self, value: Optional[str]):
        """
        Set data field with field name 'RecipeFragmentVersion' on this record model
        """
        self.set_field_value(self.RECIPEFRAGMENTVERSION__FIELD_NAME.field_name, value)

    def get_RecipeFragmentVersion_field(self) -> Optional[str]:
        """
        Get data field value with field name 'RecipeFragmentVersion' from this record model
        """
        return self.get_field_value(self.RECIPEFRAGMENTVERSION__FIELD_NAME.field_name)

    def set_Rehyb_field(self, value: Optional[str]):
        """
        Set data field with field name 'Rehyb' on this record model
        """
        self.set_field_value(self.REHYB__FIELD_NAME.field_name, value)

    def get_Rehyb_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Rehyb' from this record model
        """
        return self.get_field_value(self.REHYB__FIELD_NAME.field_name)

    def set_Resume_field(self, value: Optional[bool]):
        """
        Set data field with field name 'Resume' on this record model
        """
        self.set_field_value(self.RESUME__FIELD_NAME.field_name, value)

    def get_Resume_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'Resume' from this record model
        """
        return self.get_field_value(self.RESUME__FIELD_NAME.field_name)

    def set_ResumeCycle_field(self, value: Optional[str]):
        """
        Set data field with field name 'ResumeCycle' on this record model
        """
        self.set_field_value(self.RESUMECYCLE__FIELD_NAME.field_name, value)

    def get_ResumeCycle_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ResumeCycle' from this record model
        """
        return self.get_field_value(self.RESUMECYCLE__FIELD_NAME.field_name)

    def set_RTAVersion_field(self, value: Optional[str]):
        """
        Set data field with field name 'RTAVersion' on this record model
        """
        self.set_field_value(self.RTAVERSION__FIELD_NAME.field_name, value)

    def get_RTAVersion_field(self) -> Optional[str]:
        """
        Get data field value with field name 'RTAVersion' from this record model
        """
        return self.get_field_value(self.RTAVERSION__FIELD_NAME.field_name)

    def set_RunID_field(self, value: Optional[str]):
        """
        Set data field with field name 'RunID' on this record model
        """
        self.set_field_value(self.RUNID__FIELD_NAME.field_name, value)

    def get_RunID_field(self) -> Optional[str]:
        """
        Get data field value with field name 'RunID' from this record model
        """
        return self.get_field_value(self.RUNID__FIELD_NAME.field_name)

    def set_RunMode_field(self, value: Optional[str]):
        """
        Set data field with field name 'RunMode' on this record model
        """
        self.set_field_value(self.RUNMODE__FIELD_NAME.field_name, value)

    def get_RunMode_field(self) -> Optional[str]:
        """
        Get data field value with field name 'RunMode' from this record model
        """
        return self.get_field_value(self.RUNMODE__FIELD_NAME.field_name)

    def set_RunStartDate_field(self, value: Optional[int]):
        """
        Set data field with field name 'RunStartDate' on this record model
        """
        self.set_field_value(self.RUNSTARTDATE__FIELD_NAME.field_name, value)

    def get_RunStartDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'RunStartDate' from this record model
        """
        return self.get_field_value(self.RUNSTARTDATE__FIELD_NAME.field_name)

    def set_SampleSheet_field(self, value: Optional[str]):
        """
        Set data field with field name 'SampleSheet' on this record model
        """
        self.set_field_value(self.SAMPLESHEET__FIELD_NAME.field_name, value)

    def get_SampleSheet_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SampleSheet' from this record model
        """
        return self.get_field_value(self.SAMPLESHEET__FIELD_NAME.field_name)

    def set_SbsQuantity_field(self, value: Optional[float]):
        """
        Set data field with field name 'SbsQuantity' on this record model
        """
        self.set_field_value(self.SBSQUANTITY__FIELD_NAME.field_name, value)

    def get_SbsQuantity_field(self) -> Optional[float]:
        """
        Get data field value with field name 'SbsQuantity' from this record model
        """
        return self.get_field_value(self.SBSQUANTITY__FIELD_NAME.field_name)

    def set_SbsSerialNumber_field(self, value: Optional[str]):
        """
        Set data field with field name 'SbsSerialNumber' on this record model
        """
        self.set_field_value(self.SBSSERIALNUMBER__FIELD_NAME.field_name, value)

    def get_SbsSerialNumber_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SbsSerialNumber' from this record model
        """
        return self.get_field_value(self.SBSSERIALNUMBER__FIELD_NAME.field_name)

    def set_ScanID_field(self, value: Optional[str]):
        """
        Set data field with field name 'ScanID' on this record model
        """
        self.set_field_value(self.SCANID__FIELD_NAME.field_name, value)

    def get_ScanID_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ScanID' from this record model
        """
        return self.get_field_value(self.SCANID__FIELD_NAME.field_name)

    def set_ScannerID_field(self, value: Optional[str]):
        """
        Set data field with field name 'ScannerID' on this record model
        """
        self.set_field_value(self.SCANNERID__FIELD_NAME.field_name, value)

    def get_ScannerID_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ScannerID' from this record model
        """
        return self.get_field_value(self.SCANNERID__FIELD_NAME.field_name)

    def set_ScanNumber_field(self, value: Optional[int]):
        """
        Set data field with field name 'ScanNumber' on this record model
        """
        self.set_field_value(self.SCANNUMBER__FIELD_NAME.field_name, value)

    def get_ScanNumber_field(self) -> Optional[int]:
        """
        Get data field value with field name 'ScanNumber' from this record model
        """
        return self.get_field_value(self.SCANNUMBER__FIELD_NAME.field_name)

    def set_SelectedSection_1_field(self, value: Optional[str]):
        """
        Set data field with field name 'SelectedSection_1' on this record model
        """
        self.set_field_value(self.SELECTEDSECTION_1__FIELD_NAME.field_name, value)

    def get_SelectedSection_1_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SelectedSection_1' from this record model
        """
        return self.get_field_value(self.SELECTEDSECTION_1__FIELD_NAME.field_name)

    def set_SelectedSection_2_field(self, value: Optional[str]):
        """
        Set data field with field name 'SelectedSection_2' on this record model
        """
        self.set_field_value(self.SELECTEDSECTION_2__FIELD_NAME.field_name, value)

    def get_SelectedSection_2_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SelectedSection_2' from this record model
        """
        return self.get_field_value(self.SELECTEDSECTION_2__FIELD_NAME.field_name)

    def set_SelectedSection_3_field(self, value: Optional[str]):
        """
        Set data field with field name 'SelectedSection_3' on this record model
        """
        self.set_field_value(self.SELECTEDSECTION_3__FIELD_NAME.field_name, value)

    def get_SelectedSection_3_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SelectedSection_3' from this record model
        """
        return self.get_field_value(self.SELECTEDSECTION_3__FIELD_NAME.field_name)

    def set_SelectedSection_4_field(self, value: Optional[str]):
        """
        Set data field with field name 'SelectedSection_4' on this record model
        """
        self.set_field_value(self.SELECTEDSECTION_4__FIELD_NAME.field_name, value)

    def get_SelectedSection_4_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SelectedSection_4' from this record model
        """
        return self.get_field_value(self.SELECTEDSECTION_4__FIELD_NAME.field_name)

    def set_SelectedSection_5_field(self, value: Optional[str]):
        """
        Set data field with field name 'SelectedSection_5' on this record model
        """
        self.set_field_value(self.SELECTEDSECTION_5__FIELD_NAME.field_name, value)

    def get_SelectedSection_5_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SelectedSection_5' from this record model
        """
        return self.get_field_value(self.SELECTEDSECTION_5__FIELD_NAME.field_name)

    def set_SelectedSection_6_field(self, value: Optional[str]):
        """
        Set data field with field name 'SelectedSection_6' on this record model
        """
        self.set_field_value(self.SELECTEDSECTION_6__FIELD_NAME.field_name, value)

    def get_SelectedSection_6_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SelectedSection_6' from this record model
        """
        return self.get_field_value(self.SELECTEDSECTION_6__FIELD_NAME.field_name)

    def set_SelectedSection_7_field(self, value: Optional[str]):
        """
        Set data field with field name 'SelectedSection_7' on this record model
        """
        self.set_field_value(self.SELECTEDSECTION_7__FIELD_NAME.field_name, value)

    def get_SelectedSection_7_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SelectedSection_7' from this record model
        """
        return self.get_field_value(self.SELECTEDSECTION_7__FIELD_NAME.field_name)

    def set_SelectedSection_8_field(self, value: Optional[str]):
        """
        Set data field with field name 'SelectedSection_8' on this record model
        """
        self.set_field_value(self.SELECTEDSECTION_8__FIELD_NAME.field_name, value)

    def get_SelectedSection_8_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SelectedSection_8' from this record model
        """
        return self.get_field_value(self.SELECTEDSECTION_8__FIELD_NAME.field_name)

    def set_SelectedSurface_field(self, value: Optional[str]):
        """
        Set data field with field name 'SelectedSurface' on this record model
        """
        self.set_field_value(self.SELECTEDSURFACE__FIELD_NAME.field_name, value)

    def get_SelectedSurface_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SelectedSurface' from this record model
        """
        return self.get_field_value(self.SELECTEDSURFACE__FIELD_NAME.field_name)

    def set_SlideHolder_field(self, value: Optional[str]):
        """
        Set data field with field name 'SlideHolder' on this record model
        """
        self.set_field_value(self.SLIDEHOLDER__FIELD_NAME.field_name, value)

    def get_SlideHolder_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SlideHolder' from this record model
        """
        return self.get_field_value(self.SLIDEHOLDER__FIELD_NAME.field_name)

    def set_SupportMultipleSurfacesInUI_field(self, value: Optional[bool]):
        """
        Set data field with field name 'SupportMultipleSurfacesInUI' on this record model
        """
        self.set_field_value(self.SUPPORTMULTIPLESURFACESINUI__FIELD_NAME.field_name, value)

    def get_SupportMultipleSurfacesInUI_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'SupportMultipleSurfacesInUI' from this record model
        """
        return self.get_field_value(self.SUPPORTMULTIPLESURFACESINUI__FIELD_NAME.field_name)

    def set_SwathScanMode_field(self, value: Optional[str]):
        """
        Set data field with field name 'SwathScanMode' on this record model
        """
        self.set_field_value(self.SWATHSCANMODE__FIELD_NAME.field_name, value)

    def get_SwathScanMode_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SwathScanMode' from this record model
        """
        return self.get_field_value(self.SWATHSCANMODE__FIELD_NAME.field_name)

    def set_TempFolder_field(self, value: Optional[str]):
        """
        Set data field with field name 'TempFolder' on this record model
        """
        self.set_field_value(self.TEMPFOLDER__FIELD_NAME.field_name, value)

    def get_TempFolder_field(self) -> Optional[str]:
        """
        Get data field value with field name 'TempFolder' from this record model
        """
        return self.get_field_value(self.TEMPFOLDER__FIELD_NAME.field_name)

    def set_TemplateCycleCount_field(self, value: Optional[str]):
        """
        Set data field with field name 'TemplateCycleCount' on this record model
        """
        self.set_field_value(self.TEMPLATECYCLECOUNT__FIELD_NAME.field_name, value)

    def get_TemplateCycleCount_field(self) -> Optional[str]:
        """
        Get data field value with field name 'TemplateCycleCount' from this record model
        """
        return self.get_field_value(self.TEMPLATECYCLECOUNT__FIELD_NAME.field_name)

    def set_TileHeight_field(self, value: Optional[str]):
        """
        Set data field with field name 'TileHeight' on this record model
        """
        self.set_field_value(self.TILEHEIGHT__FIELD_NAME.field_name, value)

    def get_TileHeight_field(self) -> Optional[str]:
        """
        Get data field value with field name 'TileHeight' from this record model
        """
        return self.get_field_value(self.TILEHEIGHT__FIELD_NAME.field_name)

    def set_TileWidth_field(self, value: Optional[str]):
        """
        Set data field with field name 'TileWidth' on this record model
        """
        self.set_field_value(self.TILEWIDTH__FIELD_NAME.field_name, value)

    def get_TileWidth_field(self) -> Optional[str]:
        """
        Get data field value with field name 'TileWidth' from this record model
        """
        return self.get_field_value(self.TILEWIDTH__FIELD_NAME.field_name)

    def set_UseExistingRecipe_field(self, value: Optional[bool]):
        """
        Set data field with field name 'UseExistingRecipe' on this record model
        """
        self.set_field_value(self.USEEXISTINGRECIPE__FIELD_NAME.field_name, value)

    def get_UseExistingRecipe_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'UseExistingRecipe' from this record model
        """
        return self.get_field_value(self.USEEXISTINGRECIPE__FIELD_NAME.field_name)

    def set_Username_field(self, value: Optional[str]):
        """
        Set data field with field name 'Username' on this record model
        """
        self.set_field_value(self.USERNAME__FIELD_NAME.field_name, value)

    def get_Username_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Username' from this record model
        """
        return self.get_field_value(self.USERNAME__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)

    def set_WorkFlowType_field(self, value: Optional[str]):
        """
        Set data field with field name 'WorkFlowType' on this record model
        """
        self.set_field_value(self.WORKFLOWTYPE__FIELD_NAME.field_name, value)

    def get_WorkFlowType_field(self) -> Optional[str]:
        """
        Get data field value with field name 'WorkFlowType' from this record model
        """
        return self.get_field_value(self.WORKFLOWTYPE__FIELD_NAME.field_name)


class IlluminaMiSeqRunParametersModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type IlluminaMiSeqRunParameters
    Data Type Display Name: Illumina MiSeq Run Parameters (Illumina MiSeq Run Parameters')
    Fields: AfterRunWashMethod, AnalysisFolder, ApplicationName, ApplicationVersion, Chemistry, CloudRunId, CloudUsername, CopyManifests, CreatedBy, DataRecordName, DateCreated, EnableAnalysis, EnableCloud, ExperimentName, FlowcellExpirationDate, FlowcellPartNumber, FlowcellSerialNumber, FocusMethod, FPGAVersion, ILMNOnlyRecipeFolder, ManifestFolder, MCSVersion, MostRecentWashType, NumLanes, NumSwaths, NumTilesPerSwath, OutputFolder, PR2BottleExpirationDate, PR2BottlePartNumber, PR2BottleSerialNumber, ReagentKitExpirationDate, ReagentKitPartNumber, ReagentKitSerialNumber, ReagentKitVersion, RecipeFolder, Resumable, RTAVersion, RunID, RunNumber, RunStartDate, SampleSheetFolder, SampleSheetName, SaveFocusImages, SaveScanImages, ScannerID, SendInstrumentHealthToILMN, SupportMultipleSurfacesInUI, SurfaceToScan, TempFolder, Username, VeloxLastModifiedBy, VeloxLastModifiedDate
     <!-- DISPLAY IN INSTRUMENT RUN MONITOR -->
    """
    DATA_TYPE_NAME: str = 'IlluminaMiSeqRunParameters'
    AFTERRUNWASHMETHOD__FIELD_NAME: WrapperField = WrapperField("AfterRunWashMethod", FieldType.STRING)
    ANALYSISFOLDER__FIELD_NAME: WrapperField = WrapperField("AnalysisFolder", FieldType.STRING)
    APPLICATIONNAME__FIELD_NAME: WrapperField = WrapperField("ApplicationName", FieldType.STRING)
    APPLICATIONVERSION__FIELD_NAME: WrapperField = WrapperField("ApplicationVersion", FieldType.STRING)
    CHEMISTRY__FIELD_NAME: WrapperField = WrapperField("Chemistry", FieldType.STRING)
    CLOUDRUNID__FIELD_NAME: WrapperField = WrapperField("CloudRunId", FieldType.STRING)
    CLOUDUSERNAME__FIELD_NAME: WrapperField = WrapperField("CloudUsername", FieldType.STRING)
    COPYMANIFESTS__FIELD_NAME: WrapperField = WrapperField("CopyManifests", FieldType.BOOLEAN)
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    ENABLEANALYSIS__FIELD_NAME: WrapperField = WrapperField("EnableAnalysis", FieldType.BOOLEAN)
    ENABLECLOUD__FIELD_NAME: WrapperField = WrapperField("EnableCloud", FieldType.BOOLEAN)
    EXPERIMENTNAME__FIELD_NAME: WrapperField = WrapperField("ExperimentName", FieldType.STRING)
    FLOWCELLEXPIRATIONDATE__FIELD_NAME: WrapperField = WrapperField("FlowcellExpirationDate", FieldType.STRING)
    FLOWCELLPARTNUMBER__FIELD_NAME: WrapperField = WrapperField("FlowcellPartNumber", FieldType.STRING)
    FLOWCELLSERIALNUMBER__FIELD_NAME: WrapperField = WrapperField("FlowcellSerialNumber", FieldType.STRING)
    FOCUSMETHOD__FIELD_NAME: WrapperField = WrapperField("FocusMethod", FieldType.STRING)
    FPGAVERSION__FIELD_NAME: WrapperField = WrapperField("FPGAVersion", FieldType.STRING)
    ILMNONLYRECIPEFOLDER__FIELD_NAME: WrapperField = WrapperField("ILMNOnlyRecipeFolder", FieldType.STRING)
    MANIFESTFOLDER__FIELD_NAME: WrapperField = WrapperField("ManifestFolder", FieldType.STRING)
    MCSVERSION__FIELD_NAME: WrapperField = WrapperField("MCSVersion", FieldType.STRING)
    MOSTRECENTWASHTYPE__FIELD_NAME: WrapperField = WrapperField("MostRecentWashType", FieldType.STRING)
    NUMLANES__FIELD_NAME: WrapperField = WrapperField("NumLanes", FieldType.LONG)
    NUMSWATHS__FIELD_NAME: WrapperField = WrapperField("NumSwaths", FieldType.LONG)
    NUMTILESPERSWATH__FIELD_NAME: WrapperField = WrapperField("NumTilesPerSwath", FieldType.LONG)
    OUTPUTFOLDER__FIELD_NAME: WrapperField = WrapperField("OutputFolder", FieldType.STRING)
    PR2BOTTLEEXPIRATIONDATE__FIELD_NAME: WrapperField = WrapperField("PR2BottleExpirationDate", FieldType.STRING)
    PR2BOTTLEPARTNUMBER__FIELD_NAME: WrapperField = WrapperField("PR2BottlePartNumber", FieldType.STRING)
    PR2BOTTLESERIALNUMBER__FIELD_NAME: WrapperField = WrapperField("PR2BottleSerialNumber", FieldType.STRING)
    REAGENTKITEXPIRATIONDATE__FIELD_NAME: WrapperField = WrapperField("ReagentKitExpirationDate", FieldType.STRING)
    REAGENTKITPARTNUMBER__FIELD_NAME: WrapperField = WrapperField("ReagentKitPartNumber", FieldType.STRING)
    REAGENTKITSERIALNUMBER__FIELD_NAME: WrapperField = WrapperField("ReagentKitSerialNumber", FieldType.STRING)
    REAGENTKITVERSION__FIELD_NAME: WrapperField = WrapperField("ReagentKitVersion", FieldType.STRING)
    RECIPEFOLDER__FIELD_NAME: WrapperField = WrapperField("RecipeFolder", FieldType.STRING)
    RESUMABLE__FIELD_NAME: WrapperField = WrapperField("Resumable", FieldType.BOOLEAN)
    RTAVERSION__FIELD_NAME: WrapperField = WrapperField("RTAVersion", FieldType.STRING)
    RUNID__FIELD_NAME: WrapperField = WrapperField("RunID", FieldType.STRING)
    RUNNUMBER__FIELD_NAME: WrapperField = WrapperField("RunNumber", FieldType.LONG)
    RUNSTARTDATE__FIELD_NAME: WrapperField = WrapperField("RunStartDate", FieldType.DATE)
    SAMPLESHEETFOLDER__FIELD_NAME: WrapperField = WrapperField("SampleSheetFolder", FieldType.STRING)
    SAMPLESHEETNAME__FIELD_NAME: WrapperField = WrapperField("SampleSheetName", FieldType.STRING)
    SAVEFOCUSIMAGES__FIELD_NAME: WrapperField = WrapperField("SaveFocusImages", FieldType.BOOLEAN)
    SAVESCANIMAGES__FIELD_NAME: WrapperField = WrapperField("SaveScanImages", FieldType.BOOLEAN)
    SCANNERID__FIELD_NAME: WrapperField = WrapperField("ScannerID", FieldType.STRING)
    SENDINSTRUMENTHEALTHTOILMN__FIELD_NAME: WrapperField = WrapperField("SendInstrumentHealthToILMN", FieldType.BOOLEAN)
    SUPPORTMULTIPLESURFACESINUI__FIELD_NAME: WrapperField = WrapperField("SupportMultipleSurfacesInUI", FieldType.BOOLEAN)
    SURFACETOSCAN__FIELD_NAME: WrapperField = WrapperField("SurfaceToScan", FieldType.STRING)
    TEMPFOLDER__FIELD_NAME: WrapperField = WrapperField("TempFolder", FieldType.STRING)
    USERNAME__FIELD_NAME: WrapperField = WrapperField("Username", FieldType.STRING)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_AfterRunWashMethod_field(self, value: Optional[str]):
        """
        Set data field with field name 'AfterRunWashMethod' on this record model
        """
        self.set_field_value(self.AFTERRUNWASHMETHOD__FIELD_NAME.field_name, value)

    def get_AfterRunWashMethod_field(self) -> Optional[str]:
        """
        Get data field value with field name 'AfterRunWashMethod' from this record model
        """
        return self.get_field_value(self.AFTERRUNWASHMETHOD__FIELD_NAME.field_name)

    def set_AnalysisFolder_field(self, value: Optional[str]):
        """
        Set data field with field name 'AnalysisFolder' on this record model
        """
        self.set_field_value(self.ANALYSISFOLDER__FIELD_NAME.field_name, value)

    def get_AnalysisFolder_field(self) -> Optional[str]:
        """
        Get data field value with field name 'AnalysisFolder' from this record model
        """
        return self.get_field_value(self.ANALYSISFOLDER__FIELD_NAME.field_name)

    def set_ApplicationName_field(self, value: Optional[str]):
        """
        Set data field with field name 'ApplicationName' on this record model
        """
        self.set_field_value(self.APPLICATIONNAME__FIELD_NAME.field_name, value)

    def get_ApplicationName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ApplicationName' from this record model
        """
        return self.get_field_value(self.APPLICATIONNAME__FIELD_NAME.field_name)

    def set_ApplicationVersion_field(self, value: Optional[str]):
        """
        Set data field with field name 'ApplicationVersion' on this record model
        """
        self.set_field_value(self.APPLICATIONVERSION__FIELD_NAME.field_name, value)

    def get_ApplicationVersion_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ApplicationVersion' from this record model
        """
        return self.get_field_value(self.APPLICATIONVERSION__FIELD_NAME.field_name)

    def set_Chemistry_field(self, value: Optional[str]):
        """
        Set data field with field name 'Chemistry' on this record model
        """
        self.set_field_value(self.CHEMISTRY__FIELD_NAME.field_name, value)

    def get_Chemistry_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Chemistry' from this record model
        """
        return self.get_field_value(self.CHEMISTRY__FIELD_NAME.field_name)

    def set_CloudRunId_field(self, value: Optional[str]):
        """
        Set data field with field name 'CloudRunId' on this record model
        """
        self.set_field_value(self.CLOUDRUNID__FIELD_NAME.field_name, value)

    def get_CloudRunId_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CloudRunId' from this record model
        """
        return self.get_field_value(self.CLOUDRUNID__FIELD_NAME.field_name)

    def set_CloudUsername_field(self, value: Optional[str]):
        """
        Set data field with field name 'CloudUsername' on this record model
        """
        self.set_field_value(self.CLOUDUSERNAME__FIELD_NAME.field_name, value)

    def get_CloudUsername_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CloudUsername' from this record model
        """
        return self.get_field_value(self.CLOUDUSERNAME__FIELD_NAME.field_name)

    def set_CopyManifests_field(self, value: Optional[bool]):
        """
        Set data field with field name 'CopyManifests' on this record model
        """
        self.set_field_value(self.COPYMANIFESTS__FIELD_NAME.field_name, value)

    def get_CopyManifests_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'CopyManifests' from this record model
        """
        return self.get_field_value(self.COPYMANIFESTS__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_EnableAnalysis_field(self, value: Optional[bool]):
        """
        Set data field with field name 'EnableAnalysis' on this record model
        """
        self.set_field_value(self.ENABLEANALYSIS__FIELD_NAME.field_name, value)

    def get_EnableAnalysis_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'EnableAnalysis' from this record model
        """
        return self.get_field_value(self.ENABLEANALYSIS__FIELD_NAME.field_name)

    def set_EnableCloud_field(self, value: Optional[bool]):
        """
        Set data field with field name 'EnableCloud' on this record model
        """
        self.set_field_value(self.ENABLECLOUD__FIELD_NAME.field_name, value)

    def get_EnableCloud_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'EnableCloud' from this record model
        """
        return self.get_field_value(self.ENABLECLOUD__FIELD_NAME.field_name)

    def set_ExperimentName_field(self, value: Optional[str]):
        """
        Set data field with field name 'ExperimentName' on this record model
        """
        self.set_field_value(self.EXPERIMENTNAME__FIELD_NAME.field_name, value)

    def get_ExperimentName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ExperimentName' from this record model
        """
        return self.get_field_value(self.EXPERIMENTNAME__FIELD_NAME.field_name)

    def set_FlowcellExpirationDate_field(self, value: Optional[str]):
        """
        Set data field with field name 'FlowcellExpirationDate' on this record model
        """
        self.set_field_value(self.FLOWCELLEXPIRATIONDATE__FIELD_NAME.field_name, value)

    def get_FlowcellExpirationDate_field(self) -> Optional[str]:
        """
        Get data field value with field name 'FlowcellExpirationDate' from this record model
        """
        return self.get_field_value(self.FLOWCELLEXPIRATIONDATE__FIELD_NAME.field_name)

    def set_FlowcellPartNumber_field(self, value: Optional[str]):
        """
        Set data field with field name 'FlowcellPartNumber' on this record model
        """
        self.set_field_value(self.FLOWCELLPARTNUMBER__FIELD_NAME.field_name, value)

    def get_FlowcellPartNumber_field(self) -> Optional[str]:
        """
        Get data field value with field name 'FlowcellPartNumber' from this record model
        """
        return self.get_field_value(self.FLOWCELLPARTNUMBER__FIELD_NAME.field_name)

    def set_FlowcellSerialNumber_field(self, value: Optional[str]):
        """
        Set data field with field name 'FlowcellSerialNumber' on this record model
        """
        self.set_field_value(self.FLOWCELLSERIALNUMBER__FIELD_NAME.field_name, value)

    def get_FlowcellSerialNumber_field(self) -> Optional[str]:
        """
        Get data field value with field name 'FlowcellSerialNumber' from this record model
        """
        return self.get_field_value(self.FLOWCELLSERIALNUMBER__FIELD_NAME.field_name)

    def set_FocusMethod_field(self, value: Optional[str]):
        """
        Set data field with field name 'FocusMethod' on this record model
        """
        self.set_field_value(self.FOCUSMETHOD__FIELD_NAME.field_name, value)

    def get_FocusMethod_field(self) -> Optional[str]:
        """
        Get data field value with field name 'FocusMethod' from this record model
        """
        return self.get_field_value(self.FOCUSMETHOD__FIELD_NAME.field_name)

    def set_FPGAVersion_field(self, value: Optional[str]):
        """
        Set data field with field name 'FPGAVersion' on this record model
        """
        self.set_field_value(self.FPGAVERSION__FIELD_NAME.field_name, value)

    def get_FPGAVersion_field(self) -> Optional[str]:
        """
        Get data field value with field name 'FPGAVersion' from this record model
        """
        return self.get_field_value(self.FPGAVERSION__FIELD_NAME.field_name)

    def set_ILMNOnlyRecipeFolder_field(self, value: Optional[str]):
        """
        Set data field with field name 'ILMNOnlyRecipeFolder' on this record model
        """
        self.set_field_value(self.ILMNONLYRECIPEFOLDER__FIELD_NAME.field_name, value)

    def get_ILMNOnlyRecipeFolder_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ILMNOnlyRecipeFolder' from this record model
        """
        return self.get_field_value(self.ILMNONLYRECIPEFOLDER__FIELD_NAME.field_name)

    def set_ManifestFolder_field(self, value: Optional[str]):
        """
        Set data field with field name 'ManifestFolder' on this record model
        """
        self.set_field_value(self.MANIFESTFOLDER__FIELD_NAME.field_name, value)

    def get_ManifestFolder_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ManifestFolder' from this record model
        """
        return self.get_field_value(self.MANIFESTFOLDER__FIELD_NAME.field_name)

    def set_MCSVersion_field(self, value: Optional[str]):
        """
        Set data field with field name 'MCSVersion' on this record model
        """
        self.set_field_value(self.MCSVERSION__FIELD_NAME.field_name, value)

    def get_MCSVersion_field(self) -> Optional[str]:
        """
        Get data field value with field name 'MCSVersion' from this record model
        """
        return self.get_field_value(self.MCSVERSION__FIELD_NAME.field_name)

    def set_MostRecentWashType_field(self, value: Optional[str]):
        """
        Set data field with field name 'MostRecentWashType' on this record model
        """
        self.set_field_value(self.MOSTRECENTWASHTYPE__FIELD_NAME.field_name, value)

    def get_MostRecentWashType_field(self) -> Optional[str]:
        """
        Get data field value with field name 'MostRecentWashType' from this record model
        """
        return self.get_field_value(self.MOSTRECENTWASHTYPE__FIELD_NAME.field_name)

    def set_NumLanes_field(self, value: Optional[int]):
        """
        Set data field with field name 'NumLanes' on this record model
        """
        self.set_field_value(self.NUMLANES__FIELD_NAME.field_name, value)

    def get_NumLanes_field(self) -> Optional[int]:
        """
        Get data field value with field name 'NumLanes' from this record model
        """
        return self.get_field_value(self.NUMLANES__FIELD_NAME.field_name)

    def set_NumSwaths_field(self, value: Optional[int]):
        """
        Set data field with field name 'NumSwaths' on this record model
        """
        self.set_field_value(self.NUMSWATHS__FIELD_NAME.field_name, value)

    def get_NumSwaths_field(self) -> Optional[int]:
        """
        Get data field value with field name 'NumSwaths' from this record model
        """
        return self.get_field_value(self.NUMSWATHS__FIELD_NAME.field_name)

    def set_NumTilesPerSwath_field(self, value: Optional[int]):
        """
        Set data field with field name 'NumTilesPerSwath' on this record model
        """
        self.set_field_value(self.NUMTILESPERSWATH__FIELD_NAME.field_name, value)

    def get_NumTilesPerSwath_field(self) -> Optional[int]:
        """
        Get data field value with field name 'NumTilesPerSwath' from this record model
        """
        return self.get_field_value(self.NUMTILESPERSWATH__FIELD_NAME.field_name)

    def set_OutputFolder_field(self, value: Optional[str]):
        """
        Set data field with field name 'OutputFolder' on this record model
        """
        self.set_field_value(self.OUTPUTFOLDER__FIELD_NAME.field_name, value)

    def get_OutputFolder_field(self) -> Optional[str]:
        """
        Get data field value with field name 'OutputFolder' from this record model
        """
        return self.get_field_value(self.OUTPUTFOLDER__FIELD_NAME.field_name)

    def set_PR2BottleExpirationDate_field(self, value: Optional[str]):
        """
        Set data field with field name 'PR2BottleExpirationDate' on this record model
        """
        self.set_field_value(self.PR2BOTTLEEXPIRATIONDATE__FIELD_NAME.field_name, value)

    def get_PR2BottleExpirationDate_field(self) -> Optional[str]:
        """
        Get data field value with field name 'PR2BottleExpirationDate' from this record model
        """
        return self.get_field_value(self.PR2BOTTLEEXPIRATIONDATE__FIELD_NAME.field_name)

    def set_PR2BottlePartNumber_field(self, value: Optional[str]):
        """
        Set data field with field name 'PR2BottlePartNumber' on this record model
        """
        self.set_field_value(self.PR2BOTTLEPARTNUMBER__FIELD_NAME.field_name, value)

    def get_PR2BottlePartNumber_field(self) -> Optional[str]:
        """
        Get data field value with field name 'PR2BottlePartNumber' from this record model
        """
        return self.get_field_value(self.PR2BOTTLEPARTNUMBER__FIELD_NAME.field_name)

    def set_PR2BottleSerialNumber_field(self, value: Optional[str]):
        """
        Set data field with field name 'PR2BottleSerialNumber' on this record model
        """
        self.set_field_value(self.PR2BOTTLESERIALNUMBER__FIELD_NAME.field_name, value)

    def get_PR2BottleSerialNumber_field(self) -> Optional[str]:
        """
        Get data field value with field name 'PR2BottleSerialNumber' from this record model
        """
        return self.get_field_value(self.PR2BOTTLESERIALNUMBER__FIELD_NAME.field_name)

    def set_ReagentKitExpirationDate_field(self, value: Optional[str]):
        """
        Set data field with field name 'ReagentKitExpirationDate' on this record model
        """
        self.set_field_value(self.REAGENTKITEXPIRATIONDATE__FIELD_NAME.field_name, value)

    def get_ReagentKitExpirationDate_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ReagentKitExpirationDate' from this record model
        """
        return self.get_field_value(self.REAGENTKITEXPIRATIONDATE__FIELD_NAME.field_name)

    def set_ReagentKitPartNumber_field(self, value: Optional[str]):
        """
        Set data field with field name 'ReagentKitPartNumber' on this record model
        """
        self.set_field_value(self.REAGENTKITPARTNUMBER__FIELD_NAME.field_name, value)

    def get_ReagentKitPartNumber_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ReagentKitPartNumber' from this record model
        """
        return self.get_field_value(self.REAGENTKITPARTNUMBER__FIELD_NAME.field_name)

    def set_ReagentKitSerialNumber_field(self, value: Optional[str]):
        """
        Set data field with field name 'ReagentKitSerialNumber' on this record model
        """
        self.set_field_value(self.REAGENTKITSERIALNUMBER__FIELD_NAME.field_name, value)

    def get_ReagentKitSerialNumber_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ReagentKitSerialNumber' from this record model
        """
        return self.get_field_value(self.REAGENTKITSERIALNUMBER__FIELD_NAME.field_name)

    def set_ReagentKitVersion_field(self, value: Optional[str]):
        """
        Set data field with field name 'ReagentKitVersion' on this record model
        """
        self.set_field_value(self.REAGENTKITVERSION__FIELD_NAME.field_name, value)

    def get_ReagentKitVersion_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ReagentKitVersion' from this record model
        """
        return self.get_field_value(self.REAGENTKITVERSION__FIELD_NAME.field_name)

    def set_RecipeFolder_field(self, value: Optional[str]):
        """
        Set data field with field name 'RecipeFolder' on this record model
        """
        self.set_field_value(self.RECIPEFOLDER__FIELD_NAME.field_name, value)

    def get_RecipeFolder_field(self) -> Optional[str]:
        """
        Get data field value with field name 'RecipeFolder' from this record model
        """
        return self.get_field_value(self.RECIPEFOLDER__FIELD_NAME.field_name)

    def set_Resumable_field(self, value: Optional[bool]):
        """
        Set data field with field name 'Resumable' on this record model
        """
        self.set_field_value(self.RESUMABLE__FIELD_NAME.field_name, value)

    def get_Resumable_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'Resumable' from this record model
        """
        return self.get_field_value(self.RESUMABLE__FIELD_NAME.field_name)

    def set_RTAVersion_field(self, value: Optional[str]):
        """
        Set data field with field name 'RTAVersion' on this record model
        """
        self.set_field_value(self.RTAVERSION__FIELD_NAME.field_name, value)

    def get_RTAVersion_field(self) -> Optional[str]:
        """
        Get data field value with field name 'RTAVersion' from this record model
        """
        return self.get_field_value(self.RTAVERSION__FIELD_NAME.field_name)

    def set_RunID_field(self, value: Optional[str]):
        """
        Set data field with field name 'RunID' on this record model
        """
        self.set_field_value(self.RUNID__FIELD_NAME.field_name, value)

    def get_RunID_field(self) -> Optional[str]:
        """
        Get data field value with field name 'RunID' from this record model
        """
        return self.get_field_value(self.RUNID__FIELD_NAME.field_name)

    def set_RunNumber_field(self, value: Optional[int]):
        """
        Set data field with field name 'RunNumber' on this record model
        """
        self.set_field_value(self.RUNNUMBER__FIELD_NAME.field_name, value)

    def get_RunNumber_field(self) -> Optional[int]:
        """
        Get data field value with field name 'RunNumber' from this record model
        """
        return self.get_field_value(self.RUNNUMBER__FIELD_NAME.field_name)

    def set_RunStartDate_field(self, value: Optional[int]):
        """
        Set data field with field name 'RunStartDate' on this record model
        """
        self.set_field_value(self.RUNSTARTDATE__FIELD_NAME.field_name, value)

    def get_RunStartDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'RunStartDate' from this record model
        """
        return self.get_field_value(self.RUNSTARTDATE__FIELD_NAME.field_name)

    def set_SampleSheetFolder_field(self, value: Optional[str]):
        """
        Set data field with field name 'SampleSheetFolder' on this record model
        """
        self.set_field_value(self.SAMPLESHEETFOLDER__FIELD_NAME.field_name, value)

    def get_SampleSheetFolder_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SampleSheetFolder' from this record model
        """
        return self.get_field_value(self.SAMPLESHEETFOLDER__FIELD_NAME.field_name)

    def set_SampleSheetName_field(self, value: Optional[str]):
        """
        Set data field with field name 'SampleSheetName' on this record model
        """
        self.set_field_value(self.SAMPLESHEETNAME__FIELD_NAME.field_name, value)

    def get_SampleSheetName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SampleSheetName' from this record model
        """
        return self.get_field_value(self.SAMPLESHEETNAME__FIELD_NAME.field_name)

    def set_SaveFocusImages_field(self, value: Optional[bool]):
        """
        Set data field with field name 'SaveFocusImages' on this record model
        """
        self.set_field_value(self.SAVEFOCUSIMAGES__FIELD_NAME.field_name, value)

    def get_SaveFocusImages_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'SaveFocusImages' from this record model
        """
        return self.get_field_value(self.SAVEFOCUSIMAGES__FIELD_NAME.field_name)

    def set_SaveScanImages_field(self, value: Optional[bool]):
        """
        Set data field with field name 'SaveScanImages' on this record model
        """
        self.set_field_value(self.SAVESCANIMAGES__FIELD_NAME.field_name, value)

    def get_SaveScanImages_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'SaveScanImages' from this record model
        """
        return self.get_field_value(self.SAVESCANIMAGES__FIELD_NAME.field_name)

    def set_ScannerID_field(self, value: Optional[str]):
        """
        Set data field with field name 'ScannerID' on this record model
        """
        self.set_field_value(self.SCANNERID__FIELD_NAME.field_name, value)

    def get_ScannerID_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ScannerID' from this record model
        """
        return self.get_field_value(self.SCANNERID__FIELD_NAME.field_name)

    def set_SendInstrumentHealthToILMN_field(self, value: Optional[bool]):
        """
        Set data field with field name 'SendInstrumentHealthToILMN' on this record model
        """
        self.set_field_value(self.SENDINSTRUMENTHEALTHTOILMN__FIELD_NAME.field_name, value)

    def get_SendInstrumentHealthToILMN_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'SendInstrumentHealthToILMN' from this record model
        """
        return self.get_field_value(self.SENDINSTRUMENTHEALTHTOILMN__FIELD_NAME.field_name)

    def set_SupportMultipleSurfacesInUI_field(self, value: Optional[bool]):
        """
        Set data field with field name 'SupportMultipleSurfacesInUI' on this record model
        """
        self.set_field_value(self.SUPPORTMULTIPLESURFACESINUI__FIELD_NAME.field_name, value)

    def get_SupportMultipleSurfacesInUI_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'SupportMultipleSurfacesInUI' from this record model
        """
        return self.get_field_value(self.SUPPORTMULTIPLESURFACESINUI__FIELD_NAME.field_name)

    def set_SurfaceToScan_field(self, value: Optional[str]):
        """
        Set data field with field name 'SurfaceToScan' on this record model
        """
        self.set_field_value(self.SURFACETOSCAN__FIELD_NAME.field_name, value)

    def get_SurfaceToScan_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SurfaceToScan' from this record model
        """
        return self.get_field_value(self.SURFACETOSCAN__FIELD_NAME.field_name)

    def set_TempFolder_field(self, value: Optional[str]):
        """
        Set data field with field name 'TempFolder' on this record model
        """
        self.set_field_value(self.TEMPFOLDER__FIELD_NAME.field_name, value)

    def get_TempFolder_field(self) -> Optional[str]:
        """
        Get data field value with field name 'TempFolder' from this record model
        """
        return self.get_field_value(self.TEMPFOLDER__FIELD_NAME.field_name)

    def set_Username_field(self, value: Optional[str]):
        """
        Set data field with field name 'Username' on this record model
        """
        self.set_field_value(self.USERNAME__FIELD_NAME.field_name, value)

    def get_Username_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Username' from this record model
        """
        return self.get_field_value(self.USERNAME__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class IlluminaMiSeqSSSettingsModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type IlluminaMiSeqSSSettings
    Data Type Display Name: Illumina MiSeq Sample Sheet Settings (Illumina MiSeq Sample Sheet Settings)
    Fields: Adapter, AdapterRead2, AdapterTrimmingStringency, Aligner, Assay, BaitManifestFileName, CreatedBy, CustomAmpliconAlignerMaxIndel, CustomIndexPrimerMix, CustomRead1PrimerMix, CustomRead2PrimerMix, CyclesRead1, CyclesRead2, DataRecordName, DateCreated, Description, EnrichmentMaxRegionStatistics, ExcludeRegionsManifestA, ExperimentName, FilterOutSingleStrandVariants, FlagPCRDuplicates, IndexReads, InvestigatorName, Kmer, MinimumCoverageDepth, OutputGenomeVCF, PercentTilesToScan, PicardHSmetrics, QualityScoreTrim, ReadType, ReagentCartridgeBarcode, ReverseComplement, RunDate, StitchReads, TaxonomyFile, VariantCaller, VariantFilterQualityCutoff, VeloxLastModifiedBy, VeloxLastModifiedDate, Workflow
    """
    DATA_TYPE_NAME: str = 'IlluminaMiSeqSSSettings'
    ADAPTER__FIELD_NAME: WrapperField = WrapperField("Adapter", FieldType.STRING)
    ADAPTERREAD2__FIELD_NAME: WrapperField = WrapperField("AdapterRead2", FieldType.STRING)
    ADAPTERTRIMMINGSTRINGENCY__FIELD_NAME: WrapperField = WrapperField("AdapterTrimmingStringency", FieldType.STRING)
    ALIGNER__FIELD_NAME: WrapperField = WrapperField("Aligner", FieldType.STRING)
    ASSAY__FIELD_NAME: WrapperField = WrapperField("Assay", FieldType.STRING)
    BAITMANIFESTFILENAME__FIELD_NAME: WrapperField = WrapperField("BaitManifestFileName", FieldType.STRING)
    CREATEDBY__FIELD_NAME: WrapperField = WrapperField("CreatedBy", FieldType.STRING)
    CUSTOMAMPLICONALIGNERMAXINDEL__FIELD_NAME: WrapperField = WrapperField("CustomAmpliconAlignerMaxIndel", FieldType.STRING)
    CUSTOMINDEXPRIMERMIX__FIELD_NAME: WrapperField = WrapperField("CustomIndexPrimerMix", FieldType.STRING)
    CUSTOMREAD1PRIMERMIX__FIELD_NAME: WrapperField = WrapperField("CustomRead1PrimerMix", FieldType.STRING)
    CUSTOMREAD2PRIMERMIX__FIELD_NAME: WrapperField = WrapperField("CustomRead2PrimerMix", FieldType.STRING)
    CYCLESREAD1__FIELD_NAME: WrapperField = WrapperField("CyclesRead1", FieldType.INTEGER)
    CYCLESREAD2__FIELD_NAME: WrapperField = WrapperField("CyclesRead2", FieldType.INTEGER)
    DATARECORDNAME__FIELD_NAME: WrapperField = WrapperField("DataRecordName", FieldType.IDENTIFIER)
    DATECREATED__FIELD_NAME: WrapperField = WrapperField("DateCreated", FieldType.DATE)
    DESCRIPTION__FIELD_NAME: WrapperField = WrapperField("Description", FieldType.STRING)
    ENRICHMENTMAXREGIONSTATISTICS__FIELD_NAME: WrapperField = WrapperField("EnrichmentMaxRegionStatistics", FieldType.STRING)
    EXCLUDEREGIONSMANIFESTA__FIELD_NAME: WrapperField = WrapperField("ExcludeRegionsManifestA", FieldType.STRING)
    EXPERIMENTNAME__FIELD_NAME: WrapperField = WrapperField("ExperimentName", FieldType.STRING)
    FILTEROUTSINGLESTRANDVARIANTS__FIELD_NAME: WrapperField = WrapperField("FilterOutSingleStrandVariants", FieldType.STRING)
    FLAGPCRDUPLICATES__FIELD_NAME: WrapperField = WrapperField("FlagPCRDuplicates", FieldType.BOOLEAN)
    INDEXREADS__FIELD_NAME: WrapperField = WrapperField("IndexReads", FieldType.SHORT)
    INVESTIGATORNAME__FIELD_NAME: WrapperField = WrapperField("InvestigatorName", FieldType.STRING)
    KMER__FIELD_NAME: WrapperField = WrapperField("Kmer", FieldType.STRING)
    MINIMUMCOVERAGEDEPTH__FIELD_NAME: WrapperField = WrapperField("MinimumCoverageDepth", FieldType.STRING)
    OUTPUTGENOMEVCF__FIELD_NAME: WrapperField = WrapperField("OutputGenomeVCF", FieldType.BOOLEAN)
    PERCENTTILESTOSCAN__FIELD_NAME: WrapperField = WrapperField("PercentTilesToScan", FieldType.STRING)
    PICARDHSMETRICS__FIELD_NAME: WrapperField = WrapperField("PicardHSmetrics", FieldType.BOOLEAN)
    QUALITYSCORETRIM__FIELD_NAME: WrapperField = WrapperField("QualityScoreTrim", FieldType.STRING)
    READTYPE__FIELD_NAME: WrapperField = WrapperField("ReadType", FieldType.PICKLIST)
    REAGENTCARTRIDGEBARCODE__FIELD_NAME: WrapperField = WrapperField("ReagentCartridgeBarcode", FieldType.STRING)
    REVERSECOMPLEMENT__FIELD_NAME: WrapperField = WrapperField("ReverseComplement", FieldType.BOOLEAN)
    RUNDATE__FIELD_NAME: WrapperField = WrapperField("RunDate", FieldType.DATE)
    STITCHREADS__FIELD_NAME: WrapperField = WrapperField("StitchReads", FieldType.BOOLEAN)
    TAXONOMYFILE__FIELD_NAME: WrapperField = WrapperField("TaxonomyFile", FieldType.STRING)
    VARIANTCALLER__FIELD_NAME: WrapperField = WrapperField("VariantCaller", FieldType.STRING)
    VARIANTFILTERQUALITYCUTOFF__FIELD_NAME: WrapperField = WrapperField("VariantFilterQualityCutoff", FieldType.STRING)
    VELOXLASTMODIFIEDBY__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedBy", FieldType.STRING)
    VELOXLASTMODIFIEDDATE__FIELD_NAME: WrapperField = WrapperField("VeloxLastModifiedDate", FieldType.DATE)
    WORKFLOW__FIELD_NAME: WrapperField = WrapperField("Workflow", FieldType.STRING)

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_Adapter_field(self, value: Optional[str]):
        """
        Set data field with field name 'Adapter' on this record model
        """
        self.set_field_value(self.ADAPTER__FIELD_NAME.field_name, value)

    def get_Adapter_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Adapter' from this record model
        """
        return self.get_field_value(self.ADAPTER__FIELD_NAME.field_name)

    def set_AdapterRead2_field(self, value: Optional[str]):
        """
        Set data field with field name 'AdapterRead2' on this record model
        """
        self.set_field_value(self.ADAPTERREAD2__FIELD_NAME.field_name, value)

    def get_AdapterRead2_field(self) -> Optional[str]:
        """
        Get data field value with field name 'AdapterRead2' from this record model
        """
        return self.get_field_value(self.ADAPTERREAD2__FIELD_NAME.field_name)

    def set_AdapterTrimmingStringency_field(self, value: Optional[str]):
        """
        Set data field with field name 'AdapterTrimmingStringency' on this record model
        """
        self.set_field_value(self.ADAPTERTRIMMINGSTRINGENCY__FIELD_NAME.field_name, value)

    def get_AdapterTrimmingStringency_field(self) -> Optional[str]:
        """
        Get data field value with field name 'AdapterTrimmingStringency' from this record model
        """
        return self.get_field_value(self.ADAPTERTRIMMINGSTRINGENCY__FIELD_NAME.field_name)

    def set_Aligner_field(self, value: Optional[str]):
        """
        Set data field with field name 'Aligner' on this record model
        """
        self.set_field_value(self.ALIGNER__FIELD_NAME.field_name, value)

    def get_Aligner_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Aligner' from this record model
        """
        return self.get_field_value(self.ALIGNER__FIELD_NAME.field_name)

    def set_Assay_field(self, value: Optional[str]):
        """
        Set data field with field name 'Assay' on this record model
        """
        self.set_field_value(self.ASSAY__FIELD_NAME.field_name, value)

    def get_Assay_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Assay' from this record model
        """
        return self.get_field_value(self.ASSAY__FIELD_NAME.field_name)

    def set_BaitManifestFileName_field(self, value: Optional[str]):
        """
        Set data field with field name 'BaitManifestFileName' on this record model
        """
        self.set_field_value(self.BAITMANIFESTFILENAME__FIELD_NAME.field_name, value)

    def get_BaitManifestFileName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'BaitManifestFileName' from this record model
        """
        return self.get_field_value(self.BAITMANIFESTFILENAME__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def set_CustomAmpliconAlignerMaxIndel_field(self, value: Optional[str]):
        """
        Set data field with field name 'CustomAmp