from setuptools import setup, find_packages

setup(
    name='textmining_module',
    version='0.1.1',
    packages=find_packages(),
    description='A Python Module for Comprehensive Text Mining, including Keyword Extraction and Text Analysis.',
    long_description=open('README.md').read(),
    long_description_content_type='text/markdown',
    author='Kwadwo Daddy Nyame Owusu - Boakye',
    author_email='kwadwo.owusuboakye@outlook.com',
    url='https://github.com/knowusuboaky/textmining_module',
    install_requires=[
        "pandas>=1.1.5",
        "numpy>=1.19.5",
        "scikit-learn>=0.24.1",
        "imbalanced-learn>=0.7.0",
        "mlxtend>=0.18.0",
        "yake",
        "matplotlib>=3.3.3",
        "seaborn>=0.11.1",
        "scipy>=1.5.4",
        "ipywidgets>=7.6.3",
        "IPython>=7.22.0",
        'pandas>=1.0.0',
        'nltk>=3.5',
        'spacy>=2.3.2',
        'scikit-learn>=0.23.1'
    ],
    python_requires='>=3.6',
    classifiers=[
        'Development Status :: 3 - Alpha',
        'Intended Audience :: Developers',
        'Topic :: Software Development :: Build Tools',
        'License :: OSI Approved :: MIT License',
        'Programming Language :: Python :: 3',
        'Programming Language :: Python :: 3.6',
        'Programming Language :: Python :: 3.7',
        'Programming Language :: Python :: 3.8',
        "Programming Language :: Python :: 3.9",
        "Programming Language :: Python :: 3.10",
        "Programming Language :: Python :: 3.11",
        "Programming Language :: Python :: 3.12",
    ],
    keywords='text mining, clustering, correlation, similarity, keyword extraction, text analysis, scoring, bining, data processing, Python',
)
