# Generated by Django 2.2.28 on 2023-06-21 11:14

import django.contrib.postgres.indexes
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('contenttypes', '0002_remove_content_type_name'),
        ('wcd_notifications', '0003_delete_stats'),
    ]

    operations = [
        migrations.CreateModel(
            name='Stats',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('recipient_object_id', models.CharField(max_length=255, verbose_name='Recipient: Id')),
                ('flag', models.BigIntegerField(default=0, verbose_name='Flag')),
                ('amount', models.BigIntegerField(default=0, verbose_name='Amount')),
            ],
            options={
                'verbose_name': 'Notification stats',
                'verbose_name_plural': 'List of notifications stats',
                'ordering': ('-pk',),
            },
        ),
        migrations.RemoveIndex(
            model_name='notification',
            name='wcdnt_notification_flags',
        ),
        migrations.AlterField(
            model_name='notification',
            name='id',
            field=models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID'),
        ),
        migrations.AddIndex(
            model_name='notification',
            index=django.contrib.postgres.indexes.GinIndex(fields=['flags'], name='wcdnt_%(class)s_flags', opclasses=('gin__int_ops',)),
        ),
        migrations.AddField(
            model_name='stats',
            name='action_content_type',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='notification_stats_action', to='contenttypes.ContentType', verbose_name='Action: Content type'),
        ),
        migrations.AddField(
            model_name='stats',
            name='actor_content_type',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='notification_stats_actor', to='contenttypes.ContentType', verbose_name='Actor: Content type'),
        ),
        migrations.AddField(
            model_name='stats',
            name='recipient_content_type',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='stats_recipient', to='contenttypes.ContentType', verbose_name='Recipient: Content type'),
        ),
        migrations.AddField(
            model_name='stats',
            name='target_content_type',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='notification_stats_target', to='contenttypes.ContentType', verbose_name='Target: Content type'),
        ),
        migrations.AddIndex(
            model_name='stats',
            index=django.contrib.postgres.indexes.BTreeIndex(fields=['recipient_content_type', 'recipient_object_id'], name='wcd_notific_recipie_7a6270_btree'),
        ),
    ]
