# mypy-boto3-codeartifact

[![PyPI - mypy-boto3-codeartifact](https://img.shields.io/pypi/v/mypy-boto3-codeartifact.svg?color=blue)](https://pypi.org/project/mypy-boto3-codeartifact)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-codeartifact.svg?color=blue)](https://pypi.org/project/mypy-boto3-codeartifact)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.CodeArtifact 1.15.1](https://boto3.amazonaws.com/v1/documentation/api/1.15.1/reference/services/codeartifact.html#CodeArtifact) service
compatible with
[VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright)
and other tools.

Generated by [mypy-boto3-buider 3.1.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

- [mypy-boto3-codeartifact](#mypy-boto3-codeartifact)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Service Resource annotations](#service-resource-annotations)
    - [Other resources annotations](#other-resources-annotations)
    - [Collections annotations](#collections-annotations)
    - [Typed dictionations](#typed-dictionations)

## How to install

Install `boto3-stubs` for `CodeArtifact` service.

```bash
python -m pip install boto3-stubs[codeartifact]
```

## Usage

### VSCode

- Install [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[codeartifact]` in your environment: `python -m pip install 'boto3-stubs[codeartifact]'`

Both type checking and auto-complete should work for `CodeArtifact` service.
No explicit type annotations required, write your `boto3` code as usual.

### PyCharm

- Install `boto-stubs[codeartifact]` in your environment: `python -m pip install 'boto3-stubs[codeartifact]'`

Both type checking and auto-complete should work for `CodeArtifact` service.
No explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed `boto3-stubs` submodules.

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything should work.

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[codeartifact]` in your environment: `python -m pip install 'boto3-stubs[codeartifact]'`
- Run `mypy` as usual

Type checking should work for `CodeArtifact` service.
No explicit type annotations required, write your `boto3` code as usual.

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[codeartifact]` in your environment: `python -m pip install 'boto3-stubs[codeartifact]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `CodeArtifact` service.
No explicit type annotations required, write your `boto3` code as usual.

## Explicit type annotations

### Client annotations

`CodeArtifactClient` provides annotations for `boto3.client("codeartifact")`.

```python
import boto3

from mypy_boto3_codeartifact import CodeArtifactClient

client: CodeArtifactClient = boto3.client("codeartifact")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: CodeArtifactClient = session.client("codeartifact")
```

### Paginators annotations

`mypy_boto3_codeartifact.paginator` module contains type annotations for all paginators.

```python
from mypy_boto3_codeartifact import CodeArtifactClient
from mypy_boto3_codeartifact.paginator import (
    ListDomainsPaginator,
    ListPackagesPaginator,
    ListPackageVersionAssetsPaginator,
    ListPackageVersionsPaginator,
    ListRepositoriesInDomainPaginator,
    ListRepositoriesPaginator,
)

client: CodeArtifactClient = boto3.client("codeartifact")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
list_domains_paginator: ListDomainsPaginator = client.get_paginator("list_domains")
list_package_version_assets_paginator: ListPackageVersionAssetsPaginator = client.get_paginator("list_package_version_assets")
list_package_versions_paginator: ListPackageVersionsPaginator = client.get_paginator("list_package_versions")
list_packages_paginator: ListPackagesPaginator = client.get_paginator("list_packages")
list_repositories_paginator: ListRepositoriesPaginator = client.get_paginator("list_repositories")
list_repositories_in_domain_paginator: ListRepositoriesInDomainPaginator = client.get_paginator("list_repositories_in_domain")
```







### Typed dictionations

`mypy_boto3_codeartifact.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_codeartifact.type_defs import (
    AssetSummaryTypeDef,
    AssociateExternalConnectionResultTypeDef,
    CopyPackageVersionsResultTypeDef,
    CreateDomainResultTypeDef,
    CreateRepositoryResultTypeDef,
    DeleteDomainPermissionsPolicyResultTypeDef,
    DeleteDomainResultTypeDef,
    DeletePackageVersionsResultTypeDef,
    DeleteRepositoryPermissionsPolicyResultTypeDef,
    DeleteRepositoryResultTypeDef,
    DescribeDomainResultTypeDef,
    DescribePackageVersionResultTypeDef,
    DescribeRepositoryResultTypeDef,
    DisassociateExternalConnectionResultTypeDef,
    DisposePackageVersionsResultTypeDef,
    DomainDescriptionTypeDef,
    DomainSummaryTypeDef,
    GetAuthorizationTokenResultTypeDef,
    GetDomainPermissionsPolicyResultTypeDef,
    GetPackageVersionAssetResultTypeDef,
    GetPackageVersionReadmeResultTypeDef,
    GetRepositoryEndpointResultTypeDef,
    GetRepositoryPermissionsPolicyResultTypeDef,
    LicenseInfoTypeDef,
    ListDomainsResultTypeDef,
    ListPackagesResultTypeDef,
    ListPackageVersionAssetsResultTypeDef,
    ListPackageVersionDependenciesResultTypeDef,
    ListPackageVersionsResultTypeDef,
    ListRepositoriesInDomainResultTypeDef,
    ListRepositoriesResultTypeDef,
    PackageDependencyTypeDef,
    PackageSummaryTypeDef,
    PackageVersionDescriptionTypeDef,
    PackageVersionErrorTypeDef,
    PackageVersionSummaryTypeDef,
    PaginatorConfigTypeDef,
    PutDomainPermissionsPolicyResultTypeDef,
    PutRepositoryPermissionsPolicyResultTypeDef,
    RepositoryDescriptionTypeDef,
    RepositoryExternalConnectionInfoTypeDef,
    RepositorySummaryTypeDef,
    ResourcePolicyTypeDef,
    SuccessfulPackageVersionInfoTypeDef,
    UpdatePackageVersionsStatusResultTypeDef,
    UpdateRepositoryResultTypeDef,
    UpstreamRepositoryInfoTypeDef,
    UpstreamRepositoryTypeDef,
)

def get_structure() -> AssetSummaryTypeDef:
    return {
      ...
    }
```
