# ruff: noqa: E501, N815, D101, D102, N802
"""Python schema for hpk.capnp.

This file is generated and contains a Cap'n Proto schema in packed binary format;
specifically a serialized reflection_capnp.CapSchema message with the typeId field
not set.

The schema has been compiled from the file hpk.capnp.

This file contains the following schema nodes:
#   - capnp/c++.capnp:allowCancellation @0xac7096ff8cfc9dce
#   - capnp/c++.capnp:namespace @0xb9c6f99ebf805f2c
#   - zhinst/io/protocol/capnp/reflection/reflection.capnp:Reflection @0xf9a52e68104bc776
#   - zhinst/io/protocol/capnp/session/session_protocol.capnp:Session @0xb9d445582da4a55c
#   - hpk.capnp:Hpk @0xa621130a90860008
#   - zhinst/io/protocol/capnp/reflection/reflection.capnp:Reflection.getTheSchema$Params @0x86a77be57bfa08f7
#   - zhinst/io/protocol/capnp/reflection/reflection.capnp:CapSchema @0xcb31ef7a76eb85cf
#   - zhinst/io/protocol/capnp/reflection/reflection.capnp:Reflection.getTheSchema$Results @0xc9db2193e1883dd1
#   - zhinst/io/protocol/capnp/reflection/reflection.capnp:Reflection.getReflectionVersion$Params @0xe3e32fd4d93c1199
#   - zhinst/io/protocol/capnp/reflection/reflection.capnp:Reflection.getReflectionVersion$Results @0xfb31a67fd905411a
#   - capnp/schema.capnp:Node @0xe682ab4cf923a417
#   - capnp/schema.capnp:ElementSize @0xd1958f7dba521926
#   - capnp/schema.capnp:Field @0x9aad50a41f4af45f
#   - capnp/schema.capnp:Node.struct @0x9ea0b19b37fb4435
#   - capnp/schema.capnp:Enumerant @0x978a7cebdc549a4d
#   - capnp/schema.capnp:Node.enum @0xb54ab3364333f598
#   - capnp/schema.capnp:Method @0x9500cce23b334d80
#   - capnp/schema.capnp:Superclass @0xa9962a9ed0a4d7f8
#   - capnp/schema.capnp:Node.interface @0xe82753cff0c2218f
#   - capnp/schema.capnp:Type @0xd07378ede1f9cc60
#   - capnp/schema.capnp:Value @0xce23dcd2d7b00c9b
#   - capnp/schema.capnp:Node.const @0xb18aa5ac7a0d9420
#   - capnp/schema.capnp:Node.annotation @0xec1619d4400a0290
#   - capnp/schema.capnp:Node.NestedNode @0xdebf55bbfa0fc242
#   - capnp/schema.capnp:Annotation @0xf1c8950dab257542
#   - capnp/schema.capnp:Node.Parameter @0xb9521bccf10fa3b1
#   - capnp/schema.capnp:Brand @0x903455f06065422b
#   - capnp/schema.capnp:Brand.Scope @0xabd73485a9636bc9
#   - capnp/schema.capnp:Brand.Binding @0xc863cd16969ee7fc
#   - capnp/schema.capnp:Type.list @0x87e739250a60ea97
#   - capnp/schema.capnp:Type.enum @0x9e0e78711a7f87a9
#   - capnp/schema.capnp:Type.struct @0xac3a6f60ef4cc6d3
#   - capnp/schema.capnp:Type.interface @0xed8bca69f7fb0cbf
#   - capnp/schema.capnp:Type.anyPointer.unconstrained @0x8e3b5f79fe593656
#   - capnp/schema.capnp:Type.anyPointer.parameter @0x9dd1f724f4614a85
#   - capnp/schema.capnp:Type.anyPointer.implicitMethodParameter @0xbaefc9120c56e274
#   - capnp/schema.capnp:Type.anyPointer @0xc2573fe8a23e49f1
#   - capnp/schema.capnp:Field.slot @0xc42305476bb4746f
#   - capnp/schema.capnp:Field.group @0xcafccddb68db1d11
#   - capnp/schema.capnp:Field.ordinal @0xbb90d5c287870be6
#   - zhinst/io/protocol/capnp/session/session_protocol.capnp:Session.listNodes$Params @0x92035429255ef5a8
#   - zhinst/io/protocol/capnp/session/session_protocol.capnp:Session.listNodes$Results @0xebd34bdb74c961b0
#   - zhinst/io/protocol/capnp/session/session_protocol.capnp:Session.deprecatedGetValues$Params @0xcd242e1bb990dfe7
#   - zhinst/io/protocol/capnp/common/result.capnp:Result @0xbab0f33e1934323d
#   - zhinst/io/protocol/capnp/common/value.capnp:AnnotatedValue @0xf408ee376e837cdc
#   - zhinst/io/protocol/capnp/common/error.capnp:Error @0xc4e34e4c517d11d9
#   - zhinst/io/protocol/capnp/session/session_protocol.capnp:Session.deprecatedGetValues$Results @0xe948518c129575bb
#   - zhinst/io/protocol/capnp/common/value.capnp:Value @0xb1838b4771be75ac
#   - zhinst/io/protocol/capnp/session/session_protocol.capnp:ReturnFromSetWhen @0xdd2da53aac55edf9
#   - zhinst/io/protocol/capnp/session/session_protocol.capnp:Session.deprecatedSetValue$Params @0xa8f6fded40f38065
#   - zhinst/io/protocol/capnp/common/value.capnp:VoidStruct @0xdf7fe8e981437816
#   - zhinst/io/protocol/capnp/session/session_protocol.capnp:Session.deprecatedSetValue$Results @0x8aef0146a9595df9
#   - zhinst/io/protocol/capnp/streaming/streaming.capnp:Subscription @0xedac21a53de1b1d4
#   - zhinst/io/protocol/capnp/session/session_protocol.capnp:Session.subscribe$Params @0xb9b18be9afb1b3e4
#   - zhinst/io/protocol/capnp/session/session_protocol.capnp:Session.subscribe$Results @0xa0ca6692df48c93f
#   - zhinst/io/protocol/capnp/session/session_protocol.capnp:Session.disconnectDevice$Params @0xe682e60b2cd90782
#   - zhinst/io/protocol/capnp/session/session_protocol.capnp:Session.listNodesJson$Params @0xcd837fe86531f6c1
#   - zhinst/io/protocol/capnp/session/session_protocol.capnp:Session.listNodesJson$Results @0xa8151642645bfa32
#   - zhinst/io/protocol/capnp/session/session_protocol.capnp:Session.unsubscribe$Params @0xb16a1640db91e61c
#   - zhinst/io/protocol/capnp/session/session_protocol.capnp:Session.getSessionVersion$Params @0xd77d14cf14b3405a
#   - zhinst/io/protocol/capnp/session/session_protocol.capnp:Session.getSessionVersion$Results @0xcc68434da57cf6b3
#   - zhinst/io/protocol/capnp/session/session_protocol.capnp:Session.deprecatedSetValue2$Params @0xdae05cd32680aba1
#   - zhinst/io/protocol/capnp/session/session_protocol.capnp:Session.deprecatedSetValue2$Results @0xfd47648e56c0e689
#   - zhinst/io/protocol/capnp/session/session_protocol.capnp:LookupMode @0xda5049b5e072f425
#   - zhinst/io/protocol/capnp/session/session_protocol.capnp:Session.setValue$Params @0x9fe29a10493e27c7
#   - zhinst/io/protocol/capnp/session/session_protocol.capnp:Session.setValue$Results @0x9474d85f26f63900
#   - zhinst/io/protocol/capnp/session/session_protocol.capnp:Session.getValue$Params @0xc5e872236cc4917b
#   - zhinst/io/protocol/capnp/session/session_protocol.capnp:Session.getValue$Results @0xce98719dbad0a401
#   - zhinst/io/protocol/capnp/session/session_protocol.capnp:Session.cancel$Params @0xb77c3d30c74311fc
#   - zhinst/io/protocol/capnp/common/value.capnp:AnnotatedValue.Metadata @0xad53d8ca57af3018
#   - zhinst/io/protocol/capnp/common/complex.capnp:Complex @0xaaf1afaf97b4b157
#   - zhinst/io/protocol/capnp/common/value.capnp:VectorData @0x994c65b80df38978
#   - zhinst/io/protocol/capnp/common/value.capnp:CntSample @0xe9370bd8287d6065
#   - zhinst/io/protocol/capnp/common/value.capnp:TriggerSample @0xdeb72097c27d0d95
#   - zhinst/io/protocol/capnp/common/shf_vectors.capnp:ShfDemodulatorVectorData @0x9b03e3e3e6006582
#   - zhinst/io/protocol/capnp/common/shf_vectors.capnp:ShfResultLoggerVectorData @0xbba061f579761ddd
#   - zhinst/io/protocol/capnp/common/value.capnp:LargeVectorData @0xd948f7b09959b00a
#   - zhinst/io/protocol/capnp/common/shf_vectors.capnp:ShfScopeVectorData @0xa9b07f1f82a93bc9
#   - zhinst/io/protocol/capnp/common/shf_vectors.capnp:ShfGeneratorWaveformVectorData @0xedcfe06e81c4f3d0
#   - zhinst/io/protocol/capnp/common/shf_vectors.capnp:ShfPidVectorData @0xff6ee171549a2870
#   - zhinst/io/protocol/capnp/common/error.capnp:ErrorKind @0xb7e671e24a9802bd
#   - zhinst/io/protocol/capnp/common/shf_vectors.capnp:ShfDemodulatorVectorData.properties @0xd475786ca25c300d
#   - zhinst/io/protocol/capnp/common/shf_vectors.capnp:ShfResultLoggerVectorData.properties @0xddb7b421ea0eec5e
#   - zhinst/io/protocol/capnp/common/shf_vectors.capnp:ShfResultLoggerVectorData.vector @0x980b68b5449bdf12
#   - zhinst/io/protocol/capnp/common/shf_vectors.capnp:ShfScopeVectorData.properties @0xd707b876f9608924
#   - zhinst/io/protocol/capnp/common/shf_vectors.capnp:ShfScopeVectorData.vector @0xd10aab878c8e14bc
#   - zhinst/io/protocol/capnp/common/shf_vectors.capnp:ShfPidVectorData.properties @0x9be09d0677995544
#   - zhinst/io/protocol/capnp/streaming/streaming.capnp:StreamingHandle @0xf51e28a7f5b41574
#   - zhinst/io/protocol/capnp/streaming/streaming.capnp:StreamingHandle.sendValues$Params @0xa30bad0f967c47b6
#   - capnp/stream.capnp:StreamResult @0x995f9a3377c0b16e

"""
from __future__ import annotations

import typing as t
import warnings

import zhinst.comms
from packaging.version import Version

_GENERATED_WITH = Version("3.0.0")


def _check_version_compatibility() -> None:
    runtime_version = Version(zhinst.comms.__version__)
    if runtime_version.major != _GENERATED_WITH.major:
        warnings.warn(
            f"You are using zhinst.comms version {runtime_version}, but the schema in '{__name__}' was "
            f"generated using version {_GENERATED_WITH}. It is recommended to regenerate "
            "this file using the 'compile' command.",
            stacklevel=3,
        )


_check_version_compatibility()

_CAPNP_BINARY_SCHEMA = b"IQMEMgTiBwPfC1ABAQAAMQH3HlNoAQUG/86d/Iz/lnCsANEQBQED/4FOMLh7ffi9AAABM2EPEgETcQ8HAABTbA8D\
AQAB/yxfgL+e+ca5AFEQBQH/gU4wuHt9+L0AAAETXQ/SE2kPBwAAU2QPAwEAAf92x0sQaC6l+QARNQP/Dq05bJHC\
YYQAAAEzVQ8CAhNxDxcAABEiARHqAQAA/1ylpC1YRdS5ABE4A/9Hc0PViRLCtgAAARH6ARNCAQEAABN6AQETygUB\
AAD9CIaQChMhphEKA/8+zoYLsRu05QAAARPaBQET8gUBAAATAgYBExIGAQAA//cI+nvle6eGABFAAQAABAcAABNC\
BgEABP/Phet2eu8xywBRNQEB/w6tOWyRwmGEAAUBBwAAE6IGARPqBgEAABP6BgEAAf/RPYjhkyHbyQARQAEAAAUB\
BwAAEyIIAQABE4IIAQAB/5kRPNnUL+PjABFAAQAABAcAABMSCQEABP8aQQXZf6Yx+wARQAEAAAUBBwAAE3oJAQAB\
E+IJAQAB/xekI/lMq4LmAFETAQX/2XJMYgnFP6kARQYHBgEGE2oKAROKCgEAABP6CgEAAf8mGVK6fY+V0QAREwL/\
2XJMYgnFP6kAAAETKhEBE1IRAQAAE2IRAQAB/1/0Sh+kUK2aAFETAQP/2XJMYgnFP6kARQQHAgEEE5ISARO6EgEA\
ABPqEgEAAf81RPs3m7GgngBRGAEF/xekI/lMq4LmABUGBwEAABPaFQEAARMCFgEAAf9NmlTc63yKlwBREwEB/9ly\
TGIJxT+pAAUCBwAAE7oZARPiGQEAABPyGQEAAf+Y9TNDNrNKtQBRGAEF/xekI/lMq4LmABUGBwEAABOaGwEAARPC\
GwEAAb+ATTM74syVURMBA//ZckxiCcU/qQAFBQcAABNyHAETmhwBAAATqhwBAAH/+Nek0J4qlqkAURMBAf/Zckxi\
CcU/qQAFAQcAABNKAQITcgECAAATggECAAH/jyHC8M9TJ+gAURgBBf8XpCP5TKuC5gAVBgcBAAATggICAAETsgIC\
AAH/YMz54e14c9AAURMBA//ZckxiCcU/qQBFAQcTAAAT+gMCExoEAgAAEyoEAgAB/5sMsNfS3CPOAFETAQL/2XJM\
YgnFP6kARQEHEwAAExoMAhNCDAIAABNSDAIAAf8glA16rKWKsQBRGAEF/xekI/lMq4LmABUGBwEAABNaFQIAAROC\
FQIAAf+QAgpA1BkW7ABRGAEF/xekI/lMq4LmABUGBwEAABOCFgIAAROyFgIAAf9Cwg/6u1W/3gBRGAEB/xekI/lM\
q4LmAAUBBwAAE1IdAhOCHQIAABOSHQIAAf9CdSWrDZXI8QBREwEB/9lyTGIJxT+pAAUCBwAAE5IeAhO6HgIAABPK\
HgIAAf+xow/xzBtSuQARGAH/F6Qj+UyrguYABQEHAAATQiACE3IgAgAAE4IgAgAB/ytCZWDwVTSQABETAf/Zckxi\
CcU/qQAFAQcAABMKIQITMiECAAATciECAAH/yWtjqYU016sAURkBAv8rQmVg8FU0kABFAQcCAQQTGiICE0IiAgAA\
E1IiAgAB//znnpYWzWPIAFEZAQH/K0JlYPBVNJAARQEHAgAAE+ojAhMaJAIAABMqJAIAAf+X6mAKJTnnhwBRGAED\
/2DM+eHteHPQABUBBwEAABMqJQIAARNSJQIAAf+ph38acXgOngBRGAED/2DM+eHteHPQABUBBwEAABPiJQIAARMK\
JgIAAf/TxkzvYG86rABRGAED/2DM+eHteHPQABUBBwEAABMKJwIAARMyJwIAAf+/DPv3acqL7QBRGAED/2DM+eHt\
eHPQABUBBwEAABMyKAIAARNiKAIAAf9WNln+eV87jgBRIwED//FJPqLoP1fCAFUBBwEEAQUTYikCAAEToikCAAH/\
hUph9CT30Z0AUSMBA//xST6i6D9XwgAVAQcBAAATmisCAAET0isCAAH/dOJWDBLJ77oAUSMBA//xST6i6D9XwgAV\
AQcBAAAT2iwCAAETIi0CAAH/8Uk+oug/V8IAURgBA/9gzPnh7Xhz0ABVAQcBAwEEE7ItAgABE+ItAgAB/290tGtH\
BSPEAFEZAQP/X/RKH6RQrZoAFQQHAQAAE9IuAgABE/ouAgAB/xEd22jbzfzKAFEZAQP/X/RKH6RQrZoAFQQHAQAA\
EwIxAgABEyoxAgAB/+YLh4fC1ZC7AFEZAQP/X/RKH6RQrZoAVQQHAQIBBROyMQIAARPiMQIAAf+o9V4lKVQDkgBR\
QAEBAAAFAgcAABPyMgIAARNSMwIAAf+wYcl020vT6wARQAEAAAUBBwAAE9I0AgABEzI1AgAB/+ffkLkbLiTNABFA\
AQAABQIHAAAT2jUCAAETQjYCAAH/PTI0GT7zsLoAUS0BAf/Vq6TcH+Po9wBFAQcCEAETYjcCE6I3AgAAE7I3AgAA\
E7I4Av/cfINuN+4I9AARLAH/x7wlNLLLpfwABQIHAAAT4jgCEyo5AgAAE1o5AgAB/9kRfVFMTuPEAFEsAQH/65u5\
LNZicLkABQMHAAATYjoCE6I6AgAAE7I6AgAB/7t1lRKMUUjpABFAAQAABQEHAAATIj0CAAETij0CAAH/rHW+cUeL\
g7EAUSwBAv/HvCU0ssul/ABFAQcSAQQTwj4CEwI/AgAAEQIDAAH/+e1VrDqlLd0AETgC/0dzQ9WJEsK2AAABE0oJ\
AxOiCQMAABOyCQMAAf9lgPNA7f32qABRQAEBAAAFAgcAABNiCgMAARPKCgMAAf8WeEOB6eh/3wARLAH/x7wlNLLL\
pfwABAcAABNKDAMTigwDAAP/+V1ZqUYB74oAEUABAAAFAQcAABOaDAMAARMCDQMAAf/UseE9pSGs7QARMwH/yHSc\
awX0k8wABQMHAAATGg4DE2IOAwAAE3IOAwAB/+Szsa/pi7G5ABFAAQAABQEHAAAT+g8DAAETWhADAAH/P8lI35Jm\
yqAAEUABAAAFAQcAABPqEAMAARNKEQMAAf+CB9ksC+aC5gARQAEAAAQHAAATYhIDAAT/wfYxZeh/g80AUUABAQAA\
BQIHAAATwhIDAAETIhMDAAH/MvpbZEIWFagAEUABAAAFAQcAABOiFAMAARMCFQMAAf8c5pHbQBZqsQARQAEAAAUC\
BwAAE5IVAwABE/IVAwAB/1pAsxTPFH3XABFAAQAABAcAABMaFwMABP+z9nylTUNozAARQAEAAAUBBwAAE4IXAwAB\
E+oXAwAB/6GrgCbTXODaAFFAAQEAAAUDBwAAE3IYAwABE9oYAwAB/4nmwFaOZEf9ABFAAQAABQEHAAAT0hoDAAET\
OhsDAAH/JfRy4LVJUNoAETgC/0dzQ9WJEsK2AAABE1IcAxOiHAMAABOyHAMAAf/HJz5JEJrinwBRQAEBAAAFAwcA\
ABMSHQMAARNqHQMAAf459iZf2HSUEUABAAAFAQcAABPqHwMAARNKIAMAAf97kcRsI3LoxQBRQAEBAAAFAgcAABOC\
IQMAARPaIQMAAf8BpNC6nXGYzgARQAEAAAUBBwAAE9ojAwABEzokAwAB//wRQ8cwPXy3ABFAAQAABQEHAAATciUD\
AAETyiUDAAH/GDCvV8rYU60AUTsBAf/cfINuN+4I9AAFAQcAABNSJgMToiYDAAATsiYDAAH/V7G0l6+v8aoAUS4B\
Av/pUI7+FhRj0QAEBwAAE7onAxP6JwMAABMKKAMAAf94ifMNuGVMmQBRLAEB/8e8JTSyy6X8AAUBBwAAEwopAxNK\
KQMAABNaKQMAAf9lYH0o2As36QBRLAEC/8e8JTSyy6X8AAQHAAATaisDE6orAwAAE7orAwAB/5UNfcKXILfeAFEs\
AQX/x7wlNLLLpfwABAcAABM6LQMTgi0DAAATki0DAAH7gmXm4+MDm1EyAQn/lE1kfxiDnbQABQIHAAATEjEDE2ox\
AwAAE3oxAwAB/90ddnn1YaC7AFEyAQn/lE1kfxiDnbQABQEHAAATAjMDE1ozAwAAE2ozAwAB/wqwWZmw90jZAFEs\
AQH/x7wlNLLLpfwABQEHAAATAjQDE0o0AwAAE1o0AwAB/8k7qYIff7CpAFEyAQn/lE1kfxiDnbQABQEHAAATkjYD\
E+I2AwAAE/I2AwAB/9DzxIFu4M/tABEyAf+UTWR/GIOdtAAFAQcAABOKNwMT6jcDAAAT+jcDAAH/cCiaVHHhbv8A\
UTIBCv+UTWR/GIOdtAAFAgcAABOiOAMT8jgDAAATAjkDAAH/vQKYSuJx5rcAESwC/+ubuSzWYnC5AAABE4o6AxPK\
OgMAABPaOgMAAf8NMFyibHh11ABRSwEJ+4Jl5uPjA5sVAgcBAAATYjwDAAETwjwDAAH/XuwO6iG0t90AUUwBCf/d\
HXZ59WGguwAVAQcBAAATykMDAAETKkQDAAH/Et+bRLVoC5gAUUwBCf/dHXZ59WGguwBVAQcBAgEdE1JLAwABE7JL\
AwAB/ySJYPl2uAfXAFFFAQn/yTupgh9/sKkAFQEHAQAAE/JMAwABE0pNAwAB/7wUjoyHqwrRAFFFAQn/yTupgh9/\
sKkAVQEHAQIBIBNqUwMAARPCUwMAAf9EVZl3Bp3gmwBRQwEK/3AomlRx4W7/ABUCBwEAABMCVQMAARNaVQMAAf90\
FbT1pyge9QARMwP/yHScawX0k8wAAAET4lwDEzJdAwAAE0JdAxOqXQMAAP+2R3yWD60LowARQwEAAAUBBwAAE7pd\
AwABExpeAwAB/26xwHczml+ZABETAf/485MTqWbDhgAEBwAAE8JeAxPqXgMAA/9jYXBucC9jKwMrLmNhcG5wOmFs\
bG93Q2FuY2VsbGF0aW8BblABAQAD/2NhcG5wL2MrAisuY2FwbnA6bmFtZXNwYWMBZVABAQEMAAL/emhpbnN0L2kH\
by9wcm90b2NvbC9jYXBucC9yZWZsZWN0aW9uL3JlZmxlY3Rpb24uY2FwbnA6UmVmbGVjdGlvbgBRBAEB/1r9DwZ1\
5cuMABECAREBkv9jYXBhYmlsaQF0eVZlcnNpbwFuEQGHUQgDBQEB//cI+nvle6eGAdE9iOGTIdvJETFqAAIRKQcA\
AP+ZETzZ1C/j4wEaQQXZf6Yx+xEdqgACERkH/2dldFRoZVNjAA9oZW1hQAH/Z2V0UmVmbGUBY3Rpb25WZXIPc2lv\
bkABEQEHUAEBMQECAv96aGluc3QvaQdvL3Byb3RvY29sL2NhcG5wL3Nlc3Npb24vc2Vzc2lvbl9wcm90b2NvbC5j\
YXBucDpTZXNzaW9uABEBF1EEAQH/0AIvlhyuULcAEQGS/2NhcGFiaWxpAXR5VmVyc2lvAW4xAQcDUTADBQEB/6j1\
XiUpVAOSAbBhyXTbS9PrE3EBUgACE2kBBwEL/+ffkLkbLiTNAbt1lRKMUUjpE10BogACE1kBBwEJ/2WA80Dt/fao\
AfldWalGAe+KE00BmgACE0kBBwEF/+Szsa/pi7G5AT/JSN+SZsqgEz0BUgACEzUBBwEH/4IH2SwL5oLmARZ4Q4Hp\
6H/fEykBigACEyUBBwEI/8H2MWXof4PNATL6W2RCFhWoExkBcgACExEBBwEG/xzmkdtAFmqxARZ4Q4Hp6H/fEwUB\
YgACEf0HAAD/WkCzFM8UfdcBs/Z8pU1DaMwR8ZIAAhHtBwEK/6GrgCbTXODaAYnmwFaOZEf9EeGiAAIR3QcBA//H\
Jz5JEJrinwEAOfYmX9h0lBHRSgACEckHAQL/e5HEbCNy6MUBAaTQup1xmM4RvUoAAhG1BwEE//wRQ8cwPXy3ARZ4\
Q4Hp6H/fEak6AAIRnQf/bGlzdE5vZGUAAXNAAf9kZXByZWNhdAFlZEdldFZhbAd1ZXNAAf9kZXByZWNhdAFlZFNl\
dFZhbAN1ZUAB/3N1YnNjcmliAAFlQAH/ZGlzY29ubmUBY3REZXZpY2UAAEAB/2xpc3ROb2RlAB9zSnNvbkAB/3Vu\
c3Vic2NyAAdpYmVAAf9nZXRTZXNzaQFvblZlcnNpbwFuQAH/ZGVwcmVjYXQBZWRTZXRWYWwHdWUyQAH/c2V0VmFs\
dWUAAABAAf9nZXRWYWx1ZQAAAEABP2NhbmNlbEABEQEHUAEBEQFy/2hway5jYXBuAB9wOkhwaxEBB1ABAREBB1AD\
BREBJ1EIAQH/dsdLEGgupfkAAAD/XKWkLVhF1LkAAAAxAaIC/3poaW5zdC9pCW8vcHJvdG9jb2wvY2FwbnAvcmVm\
bGVjdGlvbi9yZWZsZWN0aW9uLmNhcG5wOlJlZmxlY3Rpb24uZ2V0VGhlU2NoZW1hJFBhcgdhbXMxAfoB/3poaW5z\
dC9pBm8vcHJvdG9jb2wvY2FwbnAvcmVmbGVjdGlvbi9yZWZsZWN0aW9uLmNhcG5wOkNhcD9TY2hlbWERAQdQAQER\
AXdRCAMEAAAEAQAAESk6AABRJAMBUTACAQEBFAEBAAARLVIAAFEsAwFRSAIBP3R5cGVJZAEJAAIBCQAB/3RoZVNj\
aGVtAAFhAQ4AAVADAQEQ/xekI/lMq4LmAAABAQ4AATEBqgL/emhpbnN0L2kJby9wcm90b2NvbC9jYXBucC9yZWZs\
ZWN0aW9uL3JlZmxlY3Rpb24uY2FwbnA6UmVmbGVjdGlvbi5nZXRUaGVTY2hlbWEkUmVzD3VsdHMRAT9RBAMEAAAE\
AQAAEQ1SAABRDAMBURgCAf90aGVTY2hlbQABYQEQ/8+F63Z67zHLAAABARAAATEB4gL/emhpbnN0L2kKby9wcm90\
b2NvbC9jYXBucC9yZWZsZWN0aW9uL3JlZmxlY3Rpb24uY2FwbnA6UmVmbGVjdGlvbi5nZXRSZWZsZWN0aW9uVmVy\
c2lvbiRQYXIHYW1zMQHqAv96aGluc3QvaQpvL3Byb3RvY29sL2NhcG5wL3JlZmxlY3Rpb24vcmVmbGVjdGlvbi5j\
YXBucDpSZWZsZWN0aW9uLmdldFJlZmxlY3Rpb25WZXJzaW9uJFJlcw91bHRzEQE/UQQDBAAABAEAABENQgAAUQgD\
AVEUAgF/dmVyc2lvbgEMAAIBDAABEQHC/2NhcG5wL3NjAmhlbWEuY2FwbnA6Tm9kZQARATdRDAEB/7GjD/HMG1K5\
ABERUv9Cwg/6u1W/3gAREVr/rlcTBOMdjvMAERFa/1BhcmFtZXRlAAFy/05lc3RlZE5vAANkZf9Tb3VyY2VJbgAD\
Zm8xARcDUTgDBAAABAEAABN5ARoAAFN0AQMBU4ABAgEBARQBAQAAE30BYgAAU3wBAwFTiAECARECAhQBAgAAE4UB\
wgAAU4gBAwFTlAECAREDAhQBAwAAE5EBQgAAU4wBAwFTmAECAREGARQBBAAAE5UBYgAAU5QBAwFTsAECAREHAhQB\
BQAAE60BYgAAU6wBAwFTyAECAQ0I//8UAQYAABPFASoAAFPAAQMBU8wBAgENCf7/AQH/NUT7N5uxoJ4AE8kBOgAC\
DQr9/wEB/5j1M0M2s0q1ABOxASoAAg0L/P8BAf+PIcLwz1Mn6AATmQFSAAINDPv/AQH/IJQNeqylirEAE4UBMgAC\
DQ36/wEB/5ACCkDUGRbsABNtAVoAAhEEBRQBIAAAE1kBWgAAU1gBAwFTdAECATEFIAEUASEAABNxAVIAAFNwAQMB\
U3wBAgEDaWQBCQACAQkAAf9kaXNwbGF5TgAHYW1lAQwAAgEMAAH/ZGlzcGxheU4CYW1lUHJlZml4TGVuZ3RoAAEI\
AAIBCAABf3Njb3BlSWQBCQACAQkAAf9uZXN0ZWRObwAHZGVzAQ4AAVADAQEQ/0LCD/q7Vb/eAAABAQ4AAf9hbm5v\
dGF0aQAHb25zAQ4AAVADAQEQ/0J1JasNlcjxAAABAQ4AAQ9maWxlAAY/c3RydWN0D2VudW3/aW50ZXJmYWMAAWUf\
Y29uc3T/YW5ub3RhdGkAA29u/3BhcmFtZXRlAANycwEOAAFQAwEBEP+xow/xzBtSuQAAAQEOAAH/aXNHZW5lcmkA\
AWMBAQACAQEAAREB+v9jYXBucC9zYwJoZW1hLmNhcG5wOkVsZW1lP250U2l6ZREBB1ABAREBx1EgAQIAABFZMgAA\
AQERUSIAAAECEUkqAAABAxFBSgAAAQQRPVIAAAEFETlaAAABBhE1QgAAAQcRLYIAAB9lbXB0eQdiaXQPYnl0Zf90\
d29CeXRlcwAAAP9mb3VyQnl0ZQABc/9laWdodEJ5dAADZXN/cG9pbnRlcv9pbmxpbmVDbwFtcG9zaXRlABEByv9j\
YXBucC9zYwJoZW1hLmNhcG5wOkZpZWxkAAARARdRBAEB/xLH/ny+TLGXABEBev9ub0Rpc2NyaQA/bWluYW50MQGP\
AVEcAwQAAAQBAAARtSoAAFGwAwFRvAIBAQEUAQEAABG5UgAAUbgDAVHEAgERAgEUAQIAABHBYgAAUcADAVHcAgER\
AwEUAQMBARHZkgAAUdwDAVHoAgENBP//AQH/b3S0a0cFI8QAEeUqAAINBf7/AQH/ER3baNvN/MoAEc0yAAIBBgEB\
/+YLh4fC1ZC7ABG1QgACD25hbWUBDAACAQwAAf9jb2RlT3JkZQABcgEHAAIBBwAB/2Fubm90YXRpAAdvbnMBDgAB\
UAMBARD/QnUlqw2VyPEAAAEBDgAB/2Rpc2NyaW1pAW5hbnRWYWx1AWUBBwACDQf//wABD3Nsb3QfZ3JvdXB/b3Jk\
aW5hbBEB+v9jYXBucC9zYwJoZW1hLmNhcG5wOk5vZGUuP3N0cnVjdDEBjwFRHAMEEAcUAQcAABG1cgAAUbQDAVHA\
AgERAQwUAQgAABG9agAAUbwDAVHIAgERAg0UAQkAABHFsgAAUcgDAVHUAgERA+AUAQoAABHRQgAAUcwDAVHYAgER\
BA8UAQsAABHVkgAAUdgDAVHkAgERBQgUAQwAABHhmgAAUeQDAVHwAgERBgMUAQ0AABHtOgAAUegDAVMEAQIB/2Rh\
dGFXb3JkAB9Db3VudAEHAAIBBwAB/3BvaW50ZXJDAA9vdW50AQcAAgEHAAH/cHJlZmVycmUBZExpc3RFbmMfb2Rp\
bmcBD/8mGVK6fY+V0QAAAQEPAAF/aXNHcm91cAEBAAIBAQAB/2Rpc2NyaW1pAW5hbnRDb3VuAXQBBwACAQcAAf9k\
aXNjcmltaQFuYW50T2ZmcwNldAEIAAIBCAABP2ZpZWxkcwEOAAFQAwEBEP9f9EofpFCtmgAAAQEOAAERAer/Y2Fw\
bnAvc2MCaGVtYS5jYXBucDpFbnVtZQ9yYW50EQEHUAEBEQGvUQwDBAAABAEAABFFKgAAUUADAVFMAgEBARQBAQAA\
EUlSAABRSAMBUVQCARECARQBAgAAEVFiAABRUAMBUWwCAQ9uYW1lAQwAAgEMAAH/Y29kZU9yZGUAAXIBBwACAQcA\
Af9hbm5vdGF0aQAHb25zAQ4AAVADAQEQ/0J1JasNlcjxAAABAQ4AAREB6v9jYXBucC9zYwJoZW1hLmNhcG5wOk5v\
ZGUuD2VudW0RAT9RBAMEEAMUAQ4AABENWgAAUQwDAVEoAgH/ZW51bWVyYW4AA3RzAQ4AAVADAQEQ/02aVNzrfIqX\
AAABAQ4AAREB0v9jYXBucC9zYwJoZW1hLmNhcG5wOk1ldGhvAWQRAQdQAQExAccBUSADBAAABAEAABHRKgAAUcwD\
AVHYAgEBARQBAQAAEdVSAABR1AMBUeACAREDARQBAgAAEd2CAABR3AMBUegCAREFAhQBAwAAEeWKAABR6AMBUfQC\
AREHARQBBAAAEfFiAABR8AMBUwwBAgERBAIUAQUAABECAgAAERoCEUICEQYDFAEGAAARYgIAABF6AhGiAhECBBQB\
BwAAEcICAAAR4gITKgECD25hbWUBDAACAQwAAf9jb2RlT3JkZQABcgEHAAIBBwAB/3BhcmFtU3RyAXVjdFR5cGUA\
AQkAAgEJAAH/cmVzdWx0U3QBcnVjdFR5cGUAAAEJAAIBCQAB/2Fubm90YXRpAAdvbnMBDgABUAMBARD/QnUlqw2V\
yPEAAAEBDgABEQFa/3BhcmFtQnJhAANuZFADAQEQ/ytCZWDwVTSQAAABUAIBARAAAREBYv9yZXN1bHRCcgAHYW5k\
UAMBARD/K0JlYPBVNJAAAAFQAgEBEAABEQGa/2ltcGxpY2l0AVBhcmFtZXRlA3JzUAMBAQ4AAVADAQEQ/7GjD/HM\
G1K5AAABUAIBAQ4AAREB8v9jYXBucC9zYwJoZW1hLmNhcG5wOlN1cGVyH2NsYXNzEQEHUAEBEQF3UQgDBAAABAEA\
ABEpGgAAUSQDAVEwAgEBARQBAQAAES0yAABRKAMBUTQCAQNpZAEJAAIBCQABH2JyYW5kARD/K0JlYPBVNJAAAAEB\
EAABMQESAf9jYXBucC9zYwNoZW1hLmNhcG5wOk5vZGUuaW50ZXJmYWMBZREBd1EIAwQQAxQBDwAAESlCAABRJAMB\
UUACAREBBBQBHwAAET1qAABRPAMBUVgCAX9tZXRob2RzAQ4AAVADAQEQv4BNMzvizJUAAQEOAAH/c3VwZXJjbGEA\
D3NzZXMBDgABUAMBARD/+Nek0J4qlqkAAAEBDgABEQHC/2NhcG5wL3NjAmhlbWEuY2FwbnA6VHlwZQARAQdQAQEx\
AS8EUUwDBAz//wQBAAATBQIqAABSAgMBUwwCAgENAf7/FAEBAAATCQIqAABTBAIDAVMQAgIBDQL9/xQBAgAAEw0C\
KgAAUwgCAwFTFAICAQ0D/P8UAQMAABMRAjIAAFMMAgMBUxgCAgENBPv/FAEEAAATFQIyAABTEAIDAVMcAgIBDQX6\
/xQBBQAAExkCMgAAUxQCAwFTIAICAQ0G+f8UAQYAABMdAjIAAFMYAgMBUyQCAgENB/j/FAEHAAATIQI6AABTHAID\
AVMoAgIBDQj3/xQBCAAAEyUCOgAAUyACAwFTLAICAQ0J9v8UAQkAABMpAjoAAFMkAgMBUzACAgENCvX/FAEKAAAT\
LQJCAABTKAIDAVM0AgIBDQv0/xQBCwAAEzECQgAAUywCAwFTOAICAQ0M8/8UAQwAABM1AioAAFMwAgMBUzwCAgEN\
DfL/FAENAAATOQIqAABTNAIDAVNAAgIBDQ7x/wEB/5fqYAolOeeHABM9AioAAg0P8P8BAf+ph38acXgOngATJQIq\
AAINEO//AQH/08ZM72BvOqwAEw0COgACDRHu/wEB/78M+/dpyovtABP1AVIAAg0S7f8BAf/xST6i6D9XwgAT4QFa\
AAIPdm9pZAAGD2Jvb2wABg9pbnQ4AAYfaW50MTYABh9pbnQzMgAGH2ludDY0AAYfdWludDgABj91aW50MTYABj91\
aW50MzIABj91aW50NjQABn9mbG9hdDMyAAZ/ZmxvYXQ2NAAGD3RleHQABg9kYXRhAAYPbGlzdA9lbnVtP3N0cnVj\
dP9pbnRlcmZhYwABZf9hbnlQb2ludAADZXIRAcr/Y2FwbnAvc2MCaGVtYS5jYXBucDpWYWx1ZQAAEQEHUAEBMQEv\
BFFMAwQM//8EAQAAEwUCKgAAUgIDAVMMAgIBHQH+/xAUAQEAABMJAioAAFMEAgMBUxACAgEdAv3/AhQBAgAAEw0C\
KgAAUwgCAwFTFAICAR0D/P8BFAEDAAATEQIyAABTDAIDAVMYAgIBHQT7/wEUAQQAABMVAjIAAFMQAgMBUxwCAgEd\
Bfr/ARQBBQAAExkCMgAAUxQCAwFTIAICAR0G+f8CFAEGAAATHQIyAABTGAIDAVMkAgIBHQf4/wEUAQcAABMhAjoA\
AFMcAgMBUygCAgEdCPf/ARQBCAAAEyUCOgAAUyACAwFTLAICAR0J9v8BFAEJAAATKQI6AABTJAIDAVMwAgIBHQr1\
/wEUAQoAABMtAkIAAFMoAgMBUzQCAgEdC/T/ARQBCwAAEzECQgAAUywCAwFTOAICAQ0M8/8UAQwAABM1AioAAFMw\
AgMBUzwCAgENDfL/FAENAAATOQIqAABTNAIDAVNAAgIBDQ7x/xQBDgAAEz0CKgAAUzgCAwFTRAICAR0P8P8BFAEP\
AAATQQIqAABTPAIDAVNIAgIBDRDv/xQBEAAAE0UCOgAAU0ACAwFTTAICAQ0R7v8UAREAABNJAlIAAFNIAgMBU1QC\
AgENEu3/FAESAAATUQJaAABTUAIDAVNcAgIBD3ZvaWQABg9ib29sAQEAAgEBAAEPaW50OAECAAIBAgABH2ludDE2\
AQMAAgEDAAEfaW50MzIBBAACAQQAAR9pbnQ2NAEFAAIBBQABH3VpbnQ4AQYAAgEGAAE/dWludDE2AQcAAgEHAAE/\
dWludDMyAQgAAgEIAAE/dWludDY0AQkAAgEJAAF/ZmxvYXQzMgEKAAIBCgABf2Zsb2F0NjQBCwACAQsAAQ90ZXh0\
AQwAAgEMAAEPZGF0YQENAAIBDQABD2xpc3QBEgACARIAAQ9lbnVtAQcAAgEHAAE/c3RydWN0ARIAAgESAAH/aW50\
ZXJmYWMAAWUABv9hbnlQb2ludAADZXIBEgACARIAAREB8v9jYXBucC9zYwJoZW1hLmNhcG5wOk5vZGUuH2NvbnN0\
EQF3UQgDBBADFAEQAAARKSoAAFEkAwFRMAIBEQEEFAERAAARLTIAAFEoAwFRNAIBD3R5cGUBEP9gzPnh7Xhz0AAA\
AQEQAAEfdmFsdWUBEP+bDLDX0twjzgAAAQEQAAExARoB/2NhcG5wL3NjA2hlbWEuY2FwbnA6Tm9kZS5hbm5vdGF0\
aQNvbjEB3wJRNAMEEAMUARIAABNdASoAAFNYAQMBU2QBAgERAXAUARMAABNhAWIAAFNgAQMBU2wBAgERAnEUARQA\
ABNpAWoAAFNoAQMBU3QBAgERA3IUARUAABNxAWIAAFNwAQMBU3wBAgERBHMUARYAABN5AYoAAFN8AQMBU4gBAgER\
BXQUARcAABOFAXIAAFOEAQMBU5ABAgERBnUUARgAABONAWoAAFOMAQMBU5gBAgERB3YUARkAABOVAWoAAFOUAQMB\
U6ABAgERCHcUARoAABOdAWoAAFOcAQMBU6gBAgERCXgUARsAABOlAYoAAFOoAQMBU7QBAgERCnkUARwAABOxAXIA\
AFOwAQMBU7wBAgERC3oUAR0AABO5AWoAAFO4AQMBU8QBAgERDHsUAR4AABPBAZIAAFPEAQMBU9ABAgEPdHlwZQEQ\
/2DM+eHteHPQAAABARAAAf90YXJnZXRzRgAHaWxlAQEAAgEBAAH/dGFyZ2V0c0MAD29uc3QBAQACAQEAAf90YXJn\
ZXRzRQAHbnVtAQEAAgEBAAH/dGFyZ2V0c0UBbnVtZXJhbnQAAAEBAAIBAQAB/3RhcmdldHNTAB90cnVjdAEBAAIB\
AQAB/3RhcmdldHNGAA9pZWxkAQEAAgEBAAH/dGFyZ2V0c1UAD25pb24BAQACAQEAAf90YXJnZXRzRwAPcm91cAEB\
AAIBAQAB/3RhcmdldHNJAW50ZXJmYWNlAAABAQACAQEAAf90YXJnZXRzTQAfZXRob2QBAQACAQEAAf90YXJnZXRz\
UAAPYXJhbQEBAAIBAQAB/3RhcmdldHNBAW5ub3RhdGlvAW4BAQACAQEAATEBGgH/Y2FwbnAvc2MDaGVtYS5jYXBu\
cDpOb2RlLk5lc3RlZE5vA2RlEQEHUAEBEQF3UQgDBAAABAEAABEpKgAAUSQDAVEwAgEBARQBAQAAES0aAABRKAMB\
UTQCAQ9uYW1lAQwAAgEMAAEDaWQBCQACAQkAAREB8v9jYXBucC9zYwJoZW1hLmNhcG5wOkFubm90H2F0aW9uEQEH\
UAEBEQGvUQwDBAAABAEAABFFGgAAUUADAVFMAgEBAhQBAQAAEUkyAABRRAMBUVACAREBARQBAgAAEU0yAABRSAMB\
UVQCAQNpZAEJAAIBCQABH3ZhbHVlARD/mwyw19LcI84AAAEBEAABH2JyYW5kARD/K0JlYPBVNJAAAAEBEAABMQES\
Af9jYXBucC9zYwNoZW1hLmNhcG5wOk5vZGUuUGFyYW1ldGUBchEBB1ABAREBP1EEAwQAAAQBAAARDSoAAFEIAwFR\
FAIBD25hbWUBDAACAQwAAREByv9jYXBucC9zYwJoZW1hLmNhcG5wOkJyYW5kAAARASdRCAEB/8lrY6mFNNerABEJ\
Mv/8556WFs1jyAARBUIfU2NvcGV/QmluZGluZxEBP1EEAwQAAAQBAAARDToAAFEIAwFRJAIBP3Njb3BlcwEOAAFQ\
AwEBEP/Ja2OphTTXqwAAAQEOAAERAfr/Y2FwbnAvc2MCaGVtYS5jYXBucDpCcmFuZD8uU2NvcGURAQdQAQERAa9R\
DAMEAAAEAQAAEUVCAABRQAMBUUwCAQ0B//8UAQEAABFJKgAAUUQDAVFgAgENAv7/FAECAAARXUIAAFFYAwFRZAIB\
f3Njb3BlSWQBCQACAQkAAQ9iaW5kAQ4AAVADAQEQ//znnpYWzWPIAAABAQ4AAX9pbmhlcml0AAYxAQoB/2NhcG5w\
L3NjA2hlbWEuY2FwbnA6QnJhbmQuQmluZGluZwAAEQEHUAEBEQF3UQgDBAz//wQBAAARKUIAAFEkAwFRMAIBDQH+\
/xQBAQAAES0qAABRKAMBUTQCAX91bmJvdW5kAAYPdHlwZQEQ/2DM+eHteHPQAAABARAAAREB6v9jYXBucC9zYwJo\
ZW1hLmNhcG5wOlR5cGUuD2xpc3QRAT9RBAMEAAAUAQ4AABENYgAAUQwDAVEYAgH/ZWxlbWVudFQAB3lwZQEQ/2DM\
+eHteHPQAAABARAAAREB6v9jYXBucC9zYwJoZW1hLmNhcG5wOlR5cGUuD2VudW0RAXdRCAMEEAEUAQ8AABEpOgAA\
USQDAVEwAgEBARQBFQAAES0yAABRKAMBUTQCAT90eXBlSWQBCQACAQkAAR9icmFuZAEQ/ytCZWDwVTSQAAABARAA\
AREB+v9jYXBucC9zYwJoZW1hLmNhcG5wOlR5cGUuP3N0cnVjdBEBd1EIAwQQARQBEAAAESk6AABRJAMBUTACAQEB\
FAEWAAARLTIAAFEoAwFRNAIBP3R5cGVJZAEJAAIBCQABH2JyYW5kARD/K0JlYPBVNJAAAAEBEAABMQESAf9jYXBu\
cC9zYwNoZW1hLmNhcG5wOlR5cGUuaW50ZXJmYWMBZREBd1EIAwQQARQBEQAAESk6AABRJAMBUTACAQEBFAEXAAAR\
LTIAAFEoAwFRNAIBP3R5cGVJZAEJAAIBCQABH2JyYW5kARD/K0JlYPBVNJAAAAEBEAABMQGKAf9jYXBucC9zYwVo\
ZW1hLmNhcG5wOlR5cGUuYW55UG9pbnRlci51bmNvbnN0cmFpbmVkAAARAedREAMEDP//FAESAAARYUIAAFFcAwFR\
aAIBDQH+/xQBGQAAEWU6AABRYAMBUWwCAQ0C/f8UARoAABFpKgAAUWQDAVFwAgENA/z/FAEbAAARbVoAAFFsAwFR\
eAIBf2FueUtpbmQABj9zdHJ1Y3QABg9saXN0AAb/Y2FwYWJpbGkAA3R5AAYxAWoB/2NhcG5wL3NjBGhlbWEuY2Fw\
bnA6VHlwZS5hbnlQb2ludGVyLnBhcmFtD2V0ZXIRAXdRCAMEEAIUARMAABEpQgAAUSQDAVEwAgERAQUUARQAABEt\
egAAUSwDAVE4AgF/c2NvcGVJZAEJAAIBCQAB/3BhcmFtZXRlAD9ySW5kZXgBBwACAQcAATEB2gH/Y2FwbnAvc2MG\
aGVtYS5jYXBucDpUeXBlLmFueVBvaW50ZXIuaW1wbGljaXRNZXRob2RQYXJhbWV0A2VyEQE/UQQDBBAFFAEYAAAR\
DXoAAFEMAwFRGAIB/3BhcmFtZXRlAD9ySW5kZXgBBwACAQcAATEBGgH/Y2FwbnAvc2MDaGVtYS5jYXBucDpUeXBl\
LmFueVBvaW50A2VyEQGvUQwDBAz//wEB/1Y2Wf55XzuOABFFcgACDQH+/wEB/4VKYfQk99GdABExUgACDQL9/wEB\
/3TiVgwSye+6ABEdwgAC/3VuY29uc3RyAB9haW5lZP9wYXJhbWV0ZQABcv9pbXBsaWNpdAJNZXRob2RQYXJhbWV0\
ZXIAEQHy/2NhcG5wL3NjAmhlbWEuY2FwbnA6RmllbGQfLnNsb3QRAedREAMEEAEUAQQAABFhOgAAUVwDAVFoAgER\
AQIUAQUAABFlKgAAUWADAVFsAgERAgMUAQYAABFpagAAUWgDAVF0AgERA4AUAQoAABFxmgAAUXQDAVGAAgE/b2Zm\
c2V0AQgAAgEIAAEPdHlwZQEQ/2DM+eHteHPQAAABARAAAf9kZWZhdWx0VgAPYWx1ZQEQ/5sMsNfS3CPOAAABARAA\
Af9oYWRFeHBsaQFjaXREZWZhdQNsdAEBAAIBAQABEQH6/2NhcG5wL3NjAmhlbWEuY2FwbnA6RmllbGQ/Lmdyb3Vw\
EQE/UQQDBBACFAEHAAARDToAAFEIAwFRFAIBP3R5cGVJZAEJAAIBCQABMQEKAf9jYXBucC9zYwNoZW1hLmNhcG5w\
OkZpZWxkLm9yZGluYWwAABEBd1EIAwQM//8UAQgAABEpSgAAUSgDAVE0AgEdAf7/BhQBCQAAETFKAABRMAMBUTwC\
Af9pbXBsaWNpdAAAB/9leHBsaWNpdAAAAAEHAAIBBwABMQGKAv96aGluc3QvaQlvL3Byb3RvY29sL2NhcG5wL3Nl\
c3Npb24vc2Vzc2lvbl9wcm90b2NvbC5jYXBucDpTZXNzaW9uLmxpc3ROb2RlcyRQYXJhbXMAABEBr1EMAwQAAAQB\
AAARRXoAAFFEAwFRUAIBAQEUAQEAABFNMgAAUUgDAVFUAgERAgEUAQIAABFROgAAUUwDAVFYAgH/cGF0aEV4cHIA\
P2Vzc2lvbgEMAAIBDAABH2ZsYWdzAQgAAgEIAAE/Y2xpZW50AQ0AAgENAAExAZIC/3poaW5zdC9pCW8vcHJvdG9j\
b2wvY2FwbnAvc2Vzc2lvbi9zZXNzaW9uX3Byb3RvY29sLmNhcG5wOlNlc3Npb24ubGlzdE5vZGVzJFJlc3VsdAFz\
EQE/UQQDBAAABAEAABENMgAAUQgDAVEkAgEfcGF0aHMBDgABUAMBAQwAAgEOAAExAdoC/3poaW5zdC9pCm8vcHJv\
dG9jb2wvY2FwbnAvc2Vzc2lvbi9zZXNzaW9uX3Byb3RvY29sLmNhcG5wOlNlc3Npb24uZGVwcmVjYXRlZEdldFZh\
bHVlcyRQYXJhA21zEQF3UQgDBAAABAEAABEpMgAAUSQDAVFAAgERAQEUAQEBARE9OgAAUTgDAVFEAgEfcGF0aHMB\
DgABUAMBAQwAAgEOAAE/Y2xpZW50AQ0AAgENAAARAQIxAaIB/3poaW5zdC9pBW8vcHJvdG9jb2wvY2FwbnAvY29t\
bW9uL3Jlc3VsdC5jYXBucDpSZXMHdWx0EQEHUAEBEQF3UQgDBAz//wQBAAARKRoAAFEkAwFRMAIBDQH+/xQBAQAA\
ES0iAABRKAMBUTQCAQNvawESAQH/PTI0GT7zsLoAAAABEgABB2VycgESBQEB/z0yNBk+87C6AAAAARIAAREBF0EI\
AREFKhEFMg9UeXBlH0Vycm9yMQHaAf96aGluc3QvaQZvL3Byb3RvY29sL2NhcG5wL2NvbW1vbi92YWx1ZS5jYXBu\
cDpBbm5vdGF0ZWRWYWwDdWURARdRBAEB/xgwr1fK2FOtABEBSv9NZXRhZGF0YQAAABEBd1EIAwQAAAQBAAARKUoA\
AFEoAwFRNAIBEQEBFAEBAAARMTIAAFEsAwFROAIB/21ldGFkYXRhAAAAARD/GDCvV8rYU60AAAEBEAABH3ZhbHVl\
ARD/rHW+cUeLg7EAAAEBEAABMQGSAf96aGluc3QvaQVvL3Byb3RvY29sL2NhcG5wL2NvbW1vbi9lcnJvci5jYXBu\
cDpFcnJvAXIRAQdQAQExAR8BURQDBAAABAEAABF9KgAAUXgDAVGEAgEBARQBAQAAEYFCAABRfAMBUYgCARECARQB\
AgAAEYVKAABRhAMBUZACAREDAhQBAwEBEY0qAABRiAMBUZQCAREEAhQBBAAAEZE6AABRjAMBUZgCAQ9jb2RlAQgA\
AgEIAAF/bWVzc2FnZQEMAAIBDAAB/2NhdGVnb3J5AAAAAQwAAgEMAAEPa2luZAEP/70CmEricea3AAABBQ8CAAE/\
c291cmNlAQwAAgEMAAExAeIC/3poaW5zdC9pCm8vcHJvdG9jb2wvY2FwbnAvc2Vzc2lvbi9zZXNzaW9uX3Byb3Rv\
Y29sLmNhcG5wOlNlc3Npb24uZGVwcmVjYXRlZEdldFZhbHVlcyRSZXN1B2x0cxEBP1EEAwQAAAQBAAARDToAAFEI\
AwFRbAIBP3Jlc3VsdAEOAAFQAwEBEP89MjQZPvOwugAAAEABEQEfUQQCAf89MjQZPvOwugAAABEBJ1EIAQEBAVEI\
AwEBAVEQAwEBEP/cfINuN+4I9AAAAQEQ/9kRfVFMTuPEAAABAQ4AATEBkgH/emhpbnN0L2kFby9wcm90b2NvbC9j\
YXBucC9jb21tb24vdmFsdWUuY2FwbnA6VmFsdQFlEQEHUAEBMQH3A1FIAwQM//8EAQAAE+kBMgAAU+QBAwFT8AEC\
AQ0B/v8UAQEAABPtAToAAFPoAQMBU/QBAgENAv3/FAECAAAT8QFCAABT7AEDAVP4AQIBDQP8/xQBAwAAE/UBOgAA\
U/ABAwFT/AECAQ0E+/8UAQQAABP5AVoAAFP4AQMBUwQCAgENBfr/FAEFAAATAQJSAABSAgMBUwwCAgENBvn/FAEG\
AAATCQJyAABTCAIDAVMUAgIBDQf4/xQBBwAAExECKgAAUwwCAwFTGAICAQ0I9/8UAQgAABMVAnoAAFMUAgMBUyAC\
AgENCfb/FAEJAAATHQJqAABTHAIDAVMoAgIBDQr1/xQBCgAAEyUCogAAUygCAwFTNAICAQ0L9P8UAQsAABMxAooA\
AFM0AgMBU1ACAgENDPP/FAEMAAATTQKqAABTUAIDAVNsAgIBDQ3y/xQBDQAAE2kCggAAU2gCAwFTdAICAQ0O8f8U\
AQ4AABNxAioAAFNsAgMBU3gCAgEND/D/FAEPAAATdQJqAABTdAIDAVOAAgIBDRDv/xQBEAAAE30CygAAU4QCAwFT\
kAICAQ0R7v8UAREAABONAloAAFOMAgMBU5gCAgEfaW50NjQBBQACAQUAAT9kb3VibGUBCwACAQsAAX9jb21wbGV4\
ARD/V7G0l6+v8aoAAAEBEAABP3N0cmluZwEMAAIBDAAB/3ZlY3RvckRhAAN0YQEQ/3iJ8w24ZUyZAAABARAAAf9j\
bnRTYW1wbAABZQEQ/2VgfSjYCzfpAAABARAAAf90cmlnZ2VyUwAfYW1wbGUBEP+VDX3ClyC33gAAAQEQAAEPbm9u\
ZQEQ/xZ4Q4Hp6H/fAAABARAAAf9zdHJlYW1pbgA/Z0Vycm9yARD/2RF9UUxO48QAAAEBEAAB/3NoZkRlbW9kAA9E\
YXRhARD7gmXm4+MDmwABARAAAf9zaGZSZXN1bAF0TG9nZ2VyRAdhdGEBEP/dHXZ59WGguwAAAQEQAAH/dmVjdG9y\
Q24BdFNhbXBsZXMAAAEOAAFQAwEBEP9lYH0o2As36QAAAQEOAAH/dmVjdG9yVHIBaWdnZXJTYW0PcGxlcwEOAAFQ\
AwEBEP+VDX3ClyC33gAAAQEOAAH/bGFyZ2VWZWMBdG9yRGF0YQABEP8KsFmZsPdI2QAAAQEQAAEPYm9vbAEBAAIB\
AQAB/3NoZlNjb3BlAA9EYXRhARD/yTupgh9/sKkAAAEBEAAB/3NoZkdlbmVyAmF0b3JXYXZlZm9ybURhdGEAAAEQ\
/9DzxIFu4M/tAAABARAAAf9zaGZQaWREYQADdGEBEP9wKJpUceFu/wAAAQEQAAExAVIC/3poaW5zdC9pCG8vcHJv\
dG9jb2wvY2FwbnAvc2Vzc2lvbi9zZXNzaW9uX3Byb3RvY29sLmNhcG5wOlJldHVybkZyb21TZXRXaGUBbhEBB1AB\
AREBZ1EQAQIAABEpKgAAAQERIVIAAAECER1iAAABAxEZogAAD2FzYXD/ZGV2aWNlQWMAAWv/dW51c2VkQXMAB3lu\
Y/91bnVzZWRUcgFhbnNhY3RpbwduYWwxAdIC/3poaW5zdC9pCm8vcHJvdG9jb2wvY2FwbnAvc2Vzc2lvbi9zZXNz\
aW9uX3Byb3RvY29sLmNhcG5wOlNlc3Npb24uZGVwcmVjYXRlZFNldFZhbHVlJFBhcmFtAXMRAa9RDAMEAAAEAQAA\
EUUqAABRQAMBUUwCAREBARQBAQAAEUkyAABRRAMBUVACAQECFAECAQERTWoAAFFMAwFRWAIBD3BhdGgBDAACAQwA\
AR92YWx1ZQEQ/6x1vnFHi4OxAAABARAAAf9jb21wbGV0ZQAPV2hlbgEP//ntVaw6pS3dAAABBQ8BAAExAboB/3po\
aW5zdC9pBW8vcHJvdG9jb2wvY2FwbnAvY29tbW9uL3ZhbHVlLmNhcG5wOlZvaWQ/U3RydWN0EQEHUAEBMQHaAv96\
aGluc3QvaQpvL3Byb3RvY29sL2NhcG5wL3Nlc3Npb24vc2Vzc2lvbl9wcm90b2NvbC5jYXBucDpTZXNzaW9uLmRl\
cHJlY2F0ZWRTZXRWYWx1ZSRSZXN1bAN0cxEBP1EEAwQAAAQBAAARDToAAFEIAwFRXAIBP3Jlc3VsdAEQ/z0yNBk+\
87C6AAAAQAERAR9RBAIB/z0yNBk+87C6AAAAEQEnUQgBAQEBUQgDAQEBURADAQEQ/xZ4Q4Hp6H/fAAABARD/2RF9\
UUxO48QAAAEBEAABMQECAv96aGluc3QvaQdvL3Byb3RvY29sL2NhcG5wL3N0cmVhbWluZy9zdHJlYW1pbmcuY2Fw\
bnA6U3Vic2NyaXB0aW9uABEBB1ABAREBr1EMAwQAAAQBAAARRSoAAFFAAwFRTAIBEQEBFAEBAAARSYIAAFFIAwFR\
VAIBEQICFAECAAARUWoAAFFQAwFRXAIBD3BhdGgBDAACAQwAAf9zdHJlYW1pbgFnSGFuZGxlAAER/3QVtPWnKB71\
AAABAREAAf9zdWJzY3JpYgAPZXJJZAENAAIBDQABMQGKAv96aGluc3QvaQlvL3Byb3RvY29sL2NhcG5wL3Nlc3Np\
b24vc2Vzc2lvbl9wcm90b2NvbC5jYXBucDpTZXNzaW9uLnN1YnNjcmliZSRQYXJhbXMAABEBP1EEAwQAAAQBAAAR\
DWoAAFEMAwFRGAIB/3N1YnNjcmlwAA90aW9uARD/1LHhPaUhrO0AAAEBEAABMQGSAv96aGluc3QvaQlvL3Byb3Rv\
Y29sL2NhcG5wL3Nlc3Npb24vc2Vzc2lvbl9wcm90b2NvbC5jYXBucDpTZXNzaW9uLnN1YnNjcmliZSRSZXN1bHQB\
cxEBP1EEAwQAAAQBAAARDToAAFEIAwFRXAIBP3Jlc3VsdAEQ/z0yNBk+87C6AAAAQAERAR9RBAIB/z0yNBk+87C6\
AAAAEQEnUQgBAQEBUQgDAQEBURADAQEQ/xZ4Q4Hp6H/fAAABARD/2RF9UUxO48QAAAEBEAABMQHCAv96aGluc3Qv\
aQpvL3Byb3RvY29sL2NhcG5wL3Nlc3Npb24vc2Vzc2lvbl9wcm90b2NvbC5jYXBucDpTZXNzaW9uLmRpc2Nvbm5l\
Y3REZXZpY2UkUGFyYW1zADEBqgL/emhpbnN0L2kJby9wcm90b2NvbC9jYXBucC9zZXNzaW9uL3Nlc3Npb25fcHJv\
dG9jb2wuY2FwbnA6U2Vzc2lvbi5saXN0Tm9kZXNKc29uJFBhD3JhbXMRAa9RDAMEAAAEAQAAEUV6AABRRAMBUVAC\
AQEBFAEBAAARTTIAAFFIAwFRVAIBEQIBFAECAAARUToAAFFMAwFRWAIB/3BhdGhFeHByAD9lc3Npb24BDAACAQwA\
AR9mbGFncwEIAAIBCAABP2NsaWVudAENAAIBDQABMQGyAv96aGluc3QvaQlvL3Byb3RvY29sL2NhcG5wL3Nlc3Np\
b24vc2Vzc2lvbl9wcm90b2NvbC5jYXBucDpTZXNzaW9uLmxpc3ROb2Rlc0pzb24kUmUfc3VsdHMRAT9RBAMEAAAE\
AQAAEQ1SAABRDAMBURgCAf9ub2RlUHJvcAABcwEMAAIBDAABMQGaAv96aGluc3QvaQlvL3Byb3RvY29sL2NhcG5w\
L3Nlc3Npb24vc2Vzc2lvbl9wcm90b2NvbC5jYXBucDpTZXNzaW9uLnVuc3Vic2NyaWJlJFBhcmEDbXMRAXdRCAME\
AAAEAQAAESlqAABRKAMBUTQCAREBARQBAQAAETEyAABRLAMBUUgCAf9zdWJzY3JpYgAPZXJJZAENAAIBDQABH3Bh\
dGhzAQ4AAVADAQEMAAIBDgABMQHKAv96aGluc3QvaQpvL3Byb3RvY29sL2NhcG5wL3Nlc3Npb24vc2Vzc2lvbl9w\
cm90b2NvbC5jYXBucDpTZXNzaW9uLmdldFNlc3Npb25WZXJzaW9uJFBhcmFtcwAAMQHSAv96aGluc3QvaQpvL3By\
b3RvY29sL2NhcG5wL3Nlc3Npb24vc2Vzc2lvbl9wcm90b2NvbC5jYXBucDpTZXNzaW9uLmdldFNlc3Npb25WZXJz\
aW9uJFJlc3VsdAFzEQE/UQQDBAAABAEAABENQgAAUQgDAVEUAgF/dmVyc2lvbgEMAAIBDAABMQHaAv96aGluc3Qv\
aQpvL3Byb3RvY29sL2NhcG5wL3Nlc3Npb24vc2Vzc2lvbl9wcm90b2NvbC5jYXBucDpTZXNzaW9uLmRlcHJlY2F0\
ZWRTZXRWYWx1ZTIkUGFyYQNtcxEB51EQAwQAAAQBAAARYSoAAFFcAwFRaAIBEQEBFAEBAAARZTIAAFFgAwFRbAIB\
AQIUAQIBARFpagAAUWgDAVF0AgERAwIUAQMBARFxOgAAUWwDAVF4AgEPcGF0aAEMAAIBDAABH3ZhbHVlARD/rHW+\
cUeLg7EAAAEBEAAB/2NvbXBsZXRlAA9XaGVuAQ//+e1VrDqlLd0AAAEFDwEAAT9jbGllbnQBDQACAQ0AABEBAjEB\
4gL/emhpbnN0L2kKby9wcm90b2NvbC9jYXBucC9zZXNzaW9uL3Nlc3Npb25fcHJvdG9jb2wuY2FwbnA6U2Vzc2lv\
bi5kZXByZWNhdGVkU2V0VmFsdWUyJFJlc3UHbHRzEQE/UQQDBAAABAEAABENOgAAUQgDAVFcAgE/cmVzdWx0ARD/\
PTI0GT7zsLoAAABAAREBH1EEAgH/PTI0GT7zsLoAAAARASdRCAEBAQFRCAMBAQFREAMBARD/3HyDbjfuCPQAAAEB\
EP/ZEX1RTE7jxAAAAQEQAAExARoC/3poaW5zdC9pB28vcHJvdG9jb2wvY2FwbnAvc2Vzc2lvbi9zZXNzaW9uX3By\
b3RvY29sLmNhcG5wOkxvb2t1cE1vA2RlEQEHUAEBEQE3UQgBAgAAERFqAAABARENcgAA/2RpcmVjdExvAA9va3Vw\
/3dpdGhFeHBhAB9uc2lvbjEBggL/emhpbnN0L2kJby9wcm90b2NvbC9jYXBucC9zZXNzaW9uL3Nlc3Npb25fcHJv\
dG9jb2wuY2FwbnA6U2Vzc2lvbi5zZXRWYWx1ZSRQYXJhbXMAMQEfAVEUAwQAAAQBAAARfXoAAFF8AwFRiAIBEQEB\
FAEBAAARhTIAAFGAAwFRjAIBAQIUAQIBARGJWgAAUYgDAVGUAgERAwEUAQMBARGRagAAUZADAVGcAgERBAIUAQQB\
ARGZOgAAUZQDAVGgAgH/cGF0aEV4cHIAP2Vzc2lvbgEMAAIBDAABH3ZhbHVlARD/rHW+cUeLg7EAAAEBEAAB/2xv\
b2t1cE1vAANkZQEP/yX0cuC1SVDaAAABAQ8AAf9jb21wbGV0ZQAPV2hlbgEP//ntVaw6pS3dAAABBQ8BAAE/Y2xp\
ZW50AQ0AAgENAAARAQIxAYoC/3poaW5zdC9pCW8vcHJvdG9jb2wvY2FwbnAvc2Vzc2lvbi9zZXNzaW9uX3Byb3Rv\
Y29sLmNhcG5wOlNlc3Npb24uc2V0VmFsdWUkUmVzdWx0cwAAEQE/UQQDBAAABAEAABENOgAAUQgDAVFsAgE/cmVz\
dWx0AQ4AAVADAQEQ/z0yNBk+87C6AAAAQAERAR9RBAIB/z0yNBk+87C6AAAAEQEnUQgBAQEBUQgDAQEBURADAQEQ\
/9x8g2437gj0AAABARD/2RF9UUxO48QAAAEBDgABMQGCAv96aGluc3QvaQlvL3Byb3RvY29sL2NhcG5wL3Nlc3Np\
b24vc2Vzc2lvbl9wcm90b2NvbC5jYXBucDpTZXNzaW9uLmdldFZhbHVlJFBhcmFtcwARAedREAMEAAAEAQAAEWF6\
AABRYAMBUWwCAQEBFAEBAQERaVoAAFFoAwFRdAIBEQIBFAECAQERcTIAAFFsAwFReAIBEQMBFAEDAQERdToAAFFw\
AwFRfAIB/3BhdGhFeHByAD9lc3Npb24BDAACAQwAAf9sb29rdXBNbwADZGUBD/8l9HLgtUlQ2gAAAQEPAAEfZmxh\
Z3MBCAACAQgAAT9jbGllbnQBDQACAQ0AABEBAjEBigL/emhpbnN0L2kJby9wcm90b2NvbC9jYXBucC9zZXNzaW9u\
L3Nlc3Npb25fcHJvdG9jb2wuY2FwbnA6U2Vzc2lvbi5nZXRWYWx1ZSRSZXN1bHRzAAARAT9RBAMEAAAEAQAAEQ06\
AABRCAMBUWwCAT9yZXN1bHQBDgABUAMBARD/PTI0GT7zsLoAAABAAREBH1EEAgH/PTI0GT7zsLoAAAARASdRCAEB\
AQFRCAMBAQFREAMBARD/3HyDbjfuCPQAAAEBEP/ZEX1RTE7jxAAAAQEOAAExAXIC/3poaW5zdC9pCG8vcHJvdG9j\
b2wvY2FwbnAvc2Vzc2lvbi9zZXNzaW9uX3Byb3RvY29sLmNhcG5wOlNlc3Npb24uY2FuY2VsJFAfYXJhbXMRAT9R\
BAMEAAAEAQAAEQ06AABRCAMBURQCAT9jbGllbnQBDQACAQ0AATEBIgL/emhpbnN0L2kHby9wcm90b2NvbC9jYXBu\
cC9jb21tb24vdmFsdWUuY2FwbnA6QW5ub3RhdGVkVmFsdWUuTWV0YWQHYXRhEQEHUAEBEQF3UQgDBAAABAEAABEp\
UgAAUSgDAVE0AgEBARQBAQAAETEqAABRLAMBUTgCAf90aW1lc3RhbQABcAEJAAIBCQABD3BhdGgBDAACAQwAATEB\
sgH/emhpbnN0L2kFby9wcm90b2NvbC9jYXBucC9jb21tb24vY29tcGxleC5jYXBucDpDbx9tcGxleBEBB1ABAREB\
d1EIAwQAAAQBAAARKSoAAFEkAwFRMAIBEQEBFAEBAAARLSoAAFEoAwFRNAIBD3JlYWwBCwACAQsAAQ9pbWFnAQsA\
AgELAAExAboB/3poaW5zdC9pBW8vcHJvdG9jb2wvY2FwbnAvY29tbW9uL3ZhbHVlLmNhcG5wOlZlY3Q/b3JEYXRh\
EQEHUAEBEQHnURADBAAABAEAABFhUgAAUWADAVFsAgERAQIUAQEAABFpkgAAUWwDAVF4AgERAgEUAQIAABF1ggAA\
UXQDAVGAAgEBAxQBAwAAEX0qAABReAMBUYQCAf92YWx1ZVR5cAABZQEHAAIBBwAB/3ZlY3RvckVsAWVtZW50VHlw\
AWUBBgACAQYAAf9leHRyYUhlYQFkZXJJbmZvAAEIAAIBCAABD2RhdGEBDQACAQ0AATEBsgH/emhpbnN0L2kFby9w\
cm90b2NvbC9jYXBucC9jb21tb24vdmFsdWUuY2FwbnA6Q250Ux9hbXBsZREBB1ABAREBr1EMAwQAAAQBAAARRVIA\
AFFEAwFRUAIBEQECFAEBAAARTUIAAFFIAwFRVAIBEQIDFAECAAARUUIAAFFMAwFRWAIB/3RpbWVzdGFtAAFwAQkA\
AgEJAAF/Y291bnRlcgEEAAIBBAABf3RyaWdnZXIBCAACAQgAATEB0gH/emhpbnN0L2kGby9wcm90b2NvbC9jYXBu\
cC9jb21tb24vdmFsdWUuY2FwbnA6VHJpZ2dlclNhbXBsAWURAQdQAQExAY8BURwDBAAABAEAABG1UgAAUbQDAVHA\
AgERAQEUAQEAABG9WgAAUbwDAVHIAgERAgQUAQIAABHFQgAAUcADAVHMAgERAwUUAQMAABHJegAAUcgDAVHUAgER\
BAYUAQQAABHRWgAAUdADAVHcAgERBQcUAQUAABHZIgAAUdQDAVHgAgERBggUAQYAABHdcgAAUdwDAVHoAgH/dGlt\
ZXN0YW0AAXABCQACAQkAAf9zYW1wbGVUaQADY2sBCQACAQkAAX90cmlnZ2VyAQgAAgEIAAH/bWlzc2VkVHIAP2ln\
Z2VycwEIAAIBCAAB/2F3Z1RyaWdnAANlcgEIAAIBCAABB2RpbwEIAAIBCAAB/3NlcXVlbmNlAB9JbmRleAEIAAIB\
CAABMQFaAv96aGluc3QvaQhvL3Byb3RvY29sL2NhcG5wL2NvbW1vbi9zaGZfdmVjdG9ycy5jYXBucDpTaGZEZW1v\
ZHVsYXRvclZlY3RvckRhA3RhEQEHUAEBEQGvUQwDBAAAAQH/DTBcomx4ddQAEUVaAAIBARQBDgAAETESAABRLAMB\
UUgCARECARQBDwAAEUUSAABRQAMBUVwCAf9wcm9wZXJ0aQADZXMBeAEOAAFQAwEBCwACAQ4AAQF5AQ4AAVADAQEL\
AAIBDgABMQFiAv96aGluc3QvaQhvL3Byb3RvY29sL2NhcG5wL2NvbW1vbi9zaGZfdmVjdG9ycy5jYXBucDpTaGZS\
ZXN1bHRMb2dnZXJWZWN0b3JEB2F0YREBB1ABAREBd1EIAwQAAAEB/17sDuohtLfdABEpWgACAQEBAf8S35tEtWgL\
mAARFToAAv9wcm9wZXJ0aQADZXM/dmVjdG9yMQHiAf96aGluc3QvaQZvL3Byb3RvY29sL2NhcG5wL2NvbW1vbi92\
YWx1ZS5jYXBucDpMYXJnZVZlY3RvckQHYXRhEQEHUAEBEQHnURADBAAABAEAABFhUgAAUWADAVFsAgERAQIUAQEA\
ABFpkgAAUWwDAVF4AgERAgEUAQIAABF1ggAAUXQDAVGAAgEBAxQBAwAAEX1qAABRfAMBUZgCAf92YWx1ZVR5cAAB\
ZQEHAAIBBwAB/3ZlY3RvckVsAWVtZW50VHlwAWUBBgACAQYAAf9leHRyYUhlYQFkZXJJbmZvAAEIAAIBCAAB/2Rh\
dGFTZWdtAA9lbnRzAQ4AAVADAQENAAIBDgABMQEqAv96aGluc3QvaQdvL3Byb3RvY29sL2NhcG5wL2NvbW1vbi9z\
aGZfdmVjdG9ycy5jYXBucDpTaGZTY29wZVZlY3Rvcg9EYXRhEQEHUAEBEQF3UQgDBAAAAQH/JIlg+Xa4B9cAESla\
AAIBAQEB/7wUjoyHqwrRABEVOgAC/3Byb3BlcnRpAANlcz92ZWN0b3IxAYoC/3poaW5zdC9pCW8vcHJvdG9jb2wv\
Y2FwbnAvY29tbW9uL3NoZl92ZWN0b3JzLmNhcG5wOlNoZkdlbmVyYXRvcldhdmVmb3JtVmVjdG9yRGF0YQAAEQEH\
UAEBEQE/UQQDBAAABAEAABENQgAAUQgDAVEkAgF/Y29tcGxleAEOAAFQAwEBEP9XsbSXr6/xqgAAAQEOAAExARoC\
/3poaW5zdC9pB28vcHJvdG9jb2wvY2FwbnAvY29tbW9uL3NoZl92ZWN0b3JzLmNhcG5wOlNoZlBpZFZlY3RvckRh\
A3RhEQEHUAEBEQGvUQwDBAAAAQH/RFWZdwad4JsAEUVaAAIBARQBDwAAETEyAABRLAMBUUgCARECARQBEAAAEUUy\
AABRQAMBUVwCAf9wcm9wZXJ0aQADZXMfdmFsdWUBDgABUAMBAQsAAgEOAAEfZXJyb3IBDgABUAMBAQsAAgEOAAEx\
AbIB/3poaW5zdC9pBW8vcHJvdG9jb2wvY2FwbnAvY29tbW9uL2Vycm9yLmNhcG5wOkVycm8fcktpbmQRAQdQAQER\
AfdRKAECAAARcRoAAAEBEWlSAAABAhFlQgAAAQMRXUoAAAEEEVliAAABBRFVWgAAAQYRUXIAAAEHEU1KAAABCBFJ\
YgAAAQkRRUIAAANva/9jYW5jZWxsZQABZH91bmtub3du/25vdEZvdW5kAAAA/292ZXJ3aGVsAAdtZWT/YmFkUmVx\
dWUAA3N0/3VuaW1wbGVtAB9lbnRlZP9pbnRlcm5hbAAAAP91bmF2YWlsYQAHYmxlf3RpbWVvdXQxAbIC/3poaW5z\
dC9pCW8vcHJvdG9jb2wvY2FwbnAvY29tbW9uL3NoZl92ZWN0b3JzLmNhcG5wOlNoZkRlbW9kdWxhdG9yVmVjdG9y\
RGF0YS5wcm9wZR9ydGllczEBFwNROAMEAAAEAQAAE3kBUgAAU3gBAwFThAECAREBARQBAQAAE4EBGgAAU3wBAwFT\
iAECARECBBQBAgAAE4UBYgAAU4QBAwFTkAECAREDBRQBAwAAE40BYgAAU4wBAwFTmAECAREEBhQBBAAAE5UBagAA\
U5QBAwFToAECAREFBBQBBQAAE50BigAAU6ABAwFTrAECAREGBRQBBgAAE6kBWgAAU6gBAwFTtAECAREH4BQBBwAA\
E7EBOgAAU6wBAwFTuAECAREIDxQBCAAAE7UBigAAU7gBAwFTxAECAREJGBQBCQAAE8EBSgAAU8ABAwFTzAECAREK\
HRQBCgAAE8kBcgAAU8gBAwFT1AECARELGRQBCwAAE9EBagAAU9ABAwFT3AECAREMBxQBDAAAE9kBegAAU9gBAwFT\
5AECARENCBQBDQAAE+EBQgAAU9wBAwFT6AECAf90aW1lc3RhbQABcAEJAAIBCQABA2R0AQkAAgEJAAH/YnVyc3RM\
ZW4AB2d0aAEIAAIBCAAB/2J1cnN0T2ZmAAdzZXQBCAACAQgAAf90cmlnZ2VySQAPbmRleAEIAAIBCAAB/3RyaWdn\
ZXJUAWltZXN0YW1wAAABCQACAQkAAf9jZW50ZXJGcgADZXEBCwACAQsAAT9yZlBhdGgBAQACAQEAAf9vc2NpbGxh\
dAFvclNvdXJjZQAAAQcAAgEHAAH/aGFybW9uaWMAAAABBwACAQcAAf90cmlnZ2VyUwAfb3VyY2UBBgACAQYAAf9z\
aWduYWxTbwAPdXJjZQEHAAIBBwAB/29zY2lsbGF0AD9vckZyZXEBCwACAQsAAX9zY2FsaW5nAQsAAgELAAExAboC\
/3poaW5zdC9pCW8vcHJvdG9jb2wvY2FwbnAvY29tbW9uL3NoZl92ZWN0b3JzLmNhcG5wOlNoZlJlc3VsdExvZ2dl\
clZlY3RvckRhdGEucHJvcD9lcnRpZXMxARcDUTgDBAAABAEAABN5AVIAAFN4AQMBU4QBAgERAQIUAQEAABOBATIA\
AFN8AQMBU4gBAgERAgMUAQIAABOFAWoAAFOEAQMBU5ABAgERAwIUAQMAABONAUIAAFOIAQMBU5QBAgERBAMUAQQA\
ABORAYIAAFOQAQMBU5wBAgERBQgUAQUAABOZAVoAAFOYAQMBU6QBAgERBgkUAQYAABOhAVoAAFOgAQMBU6wBAgER\
BwoUAQcAABOpAYoAAFOsAQMBU7gBAgERCAsUAQgAABO1AWIAAFO0AQMBU8ABAgERCQwUAQkAABO9AWIAAFO8AQMB\
U8gBAgERChoUAQoAABPFAaIAAFPIAQMBU9QBAgERCxsUAQsAABPRAaoAAFPUAQMBU+ABAgERDBwUAQwAABPdAaIA\
AFPgAQMBU+wBAgERDQgUAQ0AABPpAaoAAFPsAQMBU/gBAgH/dGltZXN0YW0AAXABCQACAQkAAR9qb2JJZAEIAAIB\
CAAB/3JlcGV0aXRpAA9vbklkAQgAAgEIAAF/c2NhbGluZwELAAIBCwAB/2NlbnRlckZyAWVxdWVuY3kAAQsAAgEL\
AAH/ZGF0YVNvdXIAA2NlAQgAAgEIAAH/bnVtU2FtcGwAA2VzAQgAAgEIAAH/bnVtU3BlY3QBclNhbXBsZXMAAAEI\
AAIBCAAB/251bUF2ZXJhAAdnZXMBCAACAQgAAf9udW1BY3F1aQAHcmVkAQgAAgEIAAH/aG9sZG9mZkUBcnJvcnNS\
ZXMHbG9nAQcAAgEHAAH/aG9sZG9mZkUBcnJvcnNSZWEPZG91dAEHAAIBBwAB/2hvbGRvZmZFAXJyb3JzU3BlB2N0\
cgEHAAIBBwAB/2ZpcnN0U2FtAXBsZVRpbWVzD3RhbXABCQACAQkAATEBmgL/emhpbnN0L2kJby9wcm90b2NvbC9j\
YXBucC9jb21tb24vc2hmX3ZlY3RvcnMuY2FwbnA6U2hmUmVzdWx0TG9nZ2VyVmVjdG9yRGF0YS52ZWN0A29yEQF3\
UQgDBAz//xQBDgAAESkqAABRJAMBUUACAQ0B/v8UAQ8AABE9QgAAUTgDAVFUAgEPcmVhbAEOAAFQAwEBCwACAQ4A\
AX9jb21wbGV4AQ4AAVADAQEQ/1extJevr/GqAAABAQ4AATEBggL/emhpbnN0L2kJby9wcm90b2NvbC9jYXBucC9j\
b21tb24vc2hmX3ZlY3RvcnMuY2FwbnA6U2hmU2NvcGVWZWN0b3JEYXRhLnByb3BlcnRpZXMAMQGnAlEwAwQAAAQB\
AAATQQFSAABTQAEDAVNMAQIBEQECFAEBAAATSQFyAABTSAEDAVNUAQIBEQIDFAECAAATUQEyAABTTAEDAVNYAQIB\
EQMCFAEDAAATVQFCAABTUAEDAVNcAQIBEQQDFAEEAAATWQGCAABTWAEDAVNkAQIBEQUEFAEFAAATYQGKAABTZAED\
AVNwAQIBEQYKFAEGAAATbQFiAABTbAEDAVN4AQIBEQcLFAEHAAATdQFqAABTdAEDAVOAAQIBEQgMFAEIAAATfQFi\
AABTfAEDAVOIAQIBEQkNFAEJAAAThQGKAABTiAEDAVOUAQIBEQoOFAEKAAATkQGSAABTlAEDAVOgAQIBEQsPFAEL\
AAATnQGSAABToAEDAVOsAQIB/3RpbWVzdGFtAAFwAQkAAgEJAAH/dGltZXN0YW0AH3BEaWZmAQgAAgEIAAEfZmxh\
Z3MBCAACAQgAAX9zY2FsaW5nAQsAAgELAAH/Y2VudGVyRnIBZXF1ZW5jeQABCwACAQsAAf90cmlnZ2VyVAFpbWVz\
dGFtcAAAAQkAAgEJAAH/aW5wdXRTZWwAB2VjdAEIAAIBCAAB/2F2ZXJhZ2VDAA9vdW50AQgAAgEIAAH/bnVtU2Vn\
bWUAB250cwEIAAIBCAAB/251bVRvdGFsAVNlZ21lbnRzAAABCAACAQgAAf9maXJzdFNlZwFtZW50SW5kZQF4AQgA\
AgEIAAH/bnVtTWlzc2UBZFRyaWdnZXIBcwEIAAIBCAABMQFiAv96aGluc3QvaQhvL3Byb3RvY29sL2NhcG5wL2Nv\
bW1vbi9zaGZfdmVjdG9ycy5jYXBucDpTaGZTY29wZVZlY3RvckRhdGEudmVjB3RvchEBd1EIAwQM//8UAQwAABEp\
KgAAUSQDAVFAAgENAf7/FAENAAARPUIAAFE4AwFRVAIBD3JlYWwBDgABUAMBAQsAAgEOAAF/Y29tcGxleAEOAAFQ\
AwEBEP9XsbSXr6/xqgAAAQEOAAExAXIC/3poaW5zdC9pCG8vcHJvdG9jb2wvY2FwbnAvY29tbW9uL3NoZl92ZWN0\
b3JzLmNhcG5wOlNoZlBpZFZlY3RvckRhdGEucHJvcGUfcnRpZXMxAU8DUTwDBAAABAEAABOVAVIAAFOUAQMBU6AB\
AgERAQEUAQEAABOdAXIAAFOcAQMBU6gBAgERAgQUAQIAABOlAWIAAFOkAQMBU7ABAgERAwUUAQMAABOtAWIAAFOs\
AQMBU7gBAgERBAYUAQQAABO1AWoAAFO0AQMBU8ABAgERBQQUAQUAABO9AYoAAFPAAQMBU8wBAgERBgUUAQYAABPJ\
AWIAAFPIAQMBU9QBAgERBxwUAQcAABPRAWoAAFPQAQMBU9wBAgERCB0UAQgAABPZATIAAFPUAQMBU+ABAgERCR4U\
AQkAABPdAXIAAFPcAQMBU+gBAgERCh8UAQoAABPlAToAAFPgAQMBU+wBAgERCzAUAQsAABPpAVoAAFPoAQMBU/QB\
AgERDAcUAQwAABPxAVoAAFPwAQMBU/wBAgERDQgUAQ0AABP5AVoAAFP4AQMBUwQCAgERDgkUAQ4AABMBAkoAAFIC\
AwFTDAICAf90aW1lc3RhbQABcAEJAAIBCQAB/3RpbWVzdGFtAB9wRGlmZgEJAAIBCQAB/2J1cnN0TGVuAAdndGgB\
CAACAQgAAf9idXJzdE9mZgAHc2V0AQgAAgEIAAH/dHJpZ2dlckkAD25kZXgBCAACAQgAAf90cmlnZ2VyVAFpbWVz\
dGFtcAAAAQkAAgEJAAH/Y2VudGVyUG8AB2ludAELAAIBCwAB/2lucHV0Q2hhAA9ubmVsAQYAAgEGAAEfaW5wdXQB\
BgACAQYAAf9vdXRwdXRDaAAfYW5uZWwBBgACAQYAAT9vdXRwdXQBBgACAQYAAf90cmlnZ2VyUwADcmMBBgACAQYA\
Af9zY2FsZVZhbAADdWUBCwACAQsAAf9zY2FsZUVycgADb3IBCwACAQsAAf9zZXRQb2ludAAAAAELAAIBCwABMQEa\
Av96aGluc3QvaQdvL3Byb3RvY29sL2NhcG5wL3N0cmVhbWluZy9zdHJlYW1pbmcuY2FwbnA6U3RyZWFtaW5nSGFu\
ZANsZREBB1ABAREBR1EEAwUAAP+2R3yWD60LowFuscB3M5pfmRERWgACEQkH/3NlbmRWYWx1AANlc0ABEQEHUAEB\
MQGqAv96aGluc3QvaQlvL3Byb3RvY29sL2NhcG5wL3N0cmVhbWluZy9zdHJlYW1pbmcuY2FwbnA6U3RyZWFtaW5n\
SGFuZGxlLnNlbmRWYWx1ZXMkUGEPcmFtcxEBP1EEAwQAAAQBAAARDToAAFEIAwFRJAIBP3ZhbHVlcwEOAAFQAwEB\
EP/cfINuN+4I9AAAAQEOAAExAQIB/2NhcG5wL3N0A3JlYW0uY2FwbnA6U3RyZWFtUmVzdWx0ABEBB1ABAQ=="

_SCHEMA_LOADER = None


def get_schema_loader() -> zhinst.comms.SchemaLoader:
    """Get the schema loader for the HPK schema.

    The schema is cached since it is expensive to load and there is no need to
    load it multiple times.

    Returns:
        The schema loader for the HPK schema.
    """
    global _SCHEMA_LOADER  # noqa: PLW0603
    if _SCHEMA_LOADER is None:
        _SCHEMA_LOADER = zhinst.comms.SchemaLoader(
            _CAPNP_BINARY_SCHEMA,  # type: ignore[arg-type]
            version=str(_GENERATED_WITH),
        )
    return _SCHEMA_LOADER


# The following structs are generated for all structs and enums in the schema above.
# They all derive from zhinst.comms.DynamicStruct and have no additional logic on their
# own. They mainly serve two use cases:
#
# 1. Provide a typed interface to the schema and detect breaking changes more easily.
#    Since zhinst.comms is schema agnostic the return types are always DynamicStructs.
#    As a user one can cast the return values to the generated structs to get a typed
#    interface.
#    Example:
#       `result = t.cast(schema.GetValueResults, await client.getValues(...))`
#
#  2. Provide a typed interface for creating new messages.
#     A DynamicStruct can be created by providing a schema loader and the capnp id.
#     The generated structs provide a more convenient way to create new messages.
#     Example:
#       `msg = schema.GetValueParams()`
#     Note that the additional kwargs are passed to the constructor of the DynamicStruct
#     and can be used to set initial values.
#
#  IMPORTANT: There is no additional logic in the generated structs. They are just a
#  typed interface to the schema. All logic is implemented in the DynamicStruct class.
#
#  IMPORTANT: There are quite some differences between how python and capnp handle things.
#  One of them is that capnp struct can have unions. The generator does not support unions
#  and will generate a struct for each union branch. This is not ideal but should be fine.
#
#  For more information see the documentation of zhinst.comms.DynamicStruct.


class ReflectionGetTheSchemaParams(zhinst.comms.DynamicStruct):
    capnp_id = 0x86A77BE57BFA08F7

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)


class CapSchema(zhinst.comms.DynamicStruct):
    capnp_id = 0xCB31EF7A76EB85CF
    typeId: int  # uint64
    theSchema: list[CapnpNode]

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)

    def init_theSchema(self, size: int) -> list[CapnpNode]:  # type: ignore[valid-type]
        return super().init_list("theSchema", size)  # type: ignore[return-value]


class ReflectionGetTheSchemaResults(zhinst.comms.DynamicStruct):
    capnp_id = 0xC9DB2193E1883DD1
    theSchema: CapSchema

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)

    def init_theSchema(self, **kwarg) -> CapSchema:  # type: ignore[valid-type]
        return super().init_struct("theSchema", **kwarg)  # type: ignore[return-value]


class ReflectionGetReflectionVersionParams(zhinst.comms.DynamicStruct):
    capnp_id = 0xE3E32FD4D93C1199

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)


class ReflectionGetReflectionVersionResults(zhinst.comms.DynamicStruct):
    capnp_id = 0xFB31A67FD905411A
    version: str

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)


class CapnpNode(zhinst.comms.DynamicStruct):
    capnp_id = 0xE682AB4CF923A417
    id: int  # uint64
    displayName: str
    displayNamePrefixLength: int  # uint32
    scopeId: int  # uint64
    nestedNodes: list[CapnpNodeNestedNode]
    annotations: list[CapnpAnnotation]
    file: t.Any
    struct: CapnpNodeStruct
    enum: CapnpNodeEnum
    interface: CapnpNodeInterface
    const: CapnpNodeConst
    annotation: CapnpNodeAnnotation
    parameters: list[CapnpNodeParameter]
    isGeneric: bool

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)

    def init_nestedNodes(self, size: int) -> list[CapnpNodeNestedNode]:  # type: ignore[valid-type]
        return super().init_list("nestedNodes", size)  # type: ignore[return-value]

    def init_annotations(self, size: int) -> list[CapnpAnnotation]:  # type: ignore[valid-type]
        return super().init_list("annotations", size)  # type: ignore[return-value]

    def init_enum(self, **kwarg) -> CapnpNodeEnum:  # type: ignore[valid-type]
        return super().init_struct("enum", **kwarg)  # type: ignore[return-value]

    def init_interface(self, **kwarg) -> CapnpNodeInterface:  # type: ignore[valid-type]
        return super().init_struct("interface", **kwarg)  # type: ignore[return-value]

    def init_const(self, **kwarg) -> CapnpNodeConst:  # type: ignore[valid-type]
        return super().init_struct("const", **kwarg)  # type: ignore[return-value]

    def init_annotation(self, **kwarg) -> CapnpNodeAnnotation:  # type: ignore[valid-type]
        return super().init_struct("annotation", **kwarg)  # type: ignore[return-value]

    def init_parameters(self, size: int) -> list[CapnpNodeParameter]:  # type: ignore[valid-type]
        return super().init_list("parameters", size)  # type: ignore[return-value]


class CapnpElementSize(zhinst.comms.DynamicEnum):
    capnp_id = 0xD1958F7DBA521926
    empty = 0
    bit = 1
    byte = 2
    twoBytes = 3
    fourBytes = 4
    eightBytes = 5
    pointer = 6
    inlineComposite = 7


class CapnpField(zhinst.comms.DynamicStruct):
    capnp_id = 0x9AAD50A41F4AF45F
    name: str
    codeOrder: int  # uint16
    annotations: list[CapnpAnnotation]
    discriminantValue: int  # uint16
    slot: CapnpFieldSlot
    group: CapnpFieldGroup
    ordinal: CapnpFieldOrdinal

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)

    def init_annotations(self, size: int) -> list[CapnpAnnotation]:  # type: ignore[valid-type]
        return super().init_list("annotations", size)  # type: ignore[return-value]

    def init_slot(self, **kwarg) -> CapnpFieldSlot:  # type: ignore[valid-type]
        return super().init_struct("slot", **kwarg)  # type: ignore[return-value]

    def init_group(self, **kwarg) -> CapnpFieldGroup:  # type: ignore[valid-type]
        return super().init_struct("group", **kwarg)  # type: ignore[return-value]

    def init_ordinal(self, **kwarg) -> CapnpFieldOrdinal:  # type: ignore[valid-type]
        return super().init_struct("ordinal", **kwarg)  # type: ignore[return-value]


class CapnpNodeStruct(zhinst.comms.DynamicStruct):
    # Group struct. This struct is not instantiable directly.
    capnp_id = 0x9EA0B19B37FB4435
    dataWordCount: int  # uint16
    pointerCount: int  # uint16
    preferredListEncoding: CapnpElementSize
    isGroup: bool
    discriminantCount: int  # uint16
    discriminantOffset: int  # uint32
    fields: list[CapnpField]

    def init_fields(self, size: int) -> list[CapnpField]:  # type: ignore[valid-type]
        return super().init_list("fields", size)  # type: ignore[return-value]


class CapnpEnumerant(zhinst.comms.DynamicStruct):
    capnp_id = 0x978A7CEBDC549A4D
    name: str
    codeOrder: int  # uint16
    annotations: list[CapnpAnnotation]

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)

    def init_annotations(self, size: int) -> list[CapnpAnnotation]:  # type: ignore[valid-type]
        return super().init_list("annotations", size)  # type: ignore[return-value]


class CapnpNodeEnum(zhinst.comms.DynamicStruct):
    # Group struct. This struct is not instantiable directly.
    capnp_id = 0xB54AB3364333F598
    enumerants: list[CapnpEnumerant]

    def init_enumerants(self, size: int) -> list[CapnpEnumerant]:  # type: ignore[valid-type]
        return super().init_list("enumerants", size)  # type: ignore[return-value]


class CapnpMethod(zhinst.comms.DynamicStruct):
    capnp_id = 0x9500CCE23B334D80
    name: str
    codeOrder: int  # uint16
    paramStructType: int  # uint64
    resultStructType: int  # uint64
    annotations: list[CapnpAnnotation]
    paramBrand: CapnpBrand
    resultBrand: CapnpBrand
    implicitParameters: list[CapnpNodeParameter]

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)

    def init_annotations(self, size: int) -> list[CapnpAnnotation]:  # type: ignore[valid-type]
        return super().init_list("annotations", size)  # type: ignore[return-value]

    def init_paramBrand(self, **kwarg) -> CapnpBrand:  # type: ignore[valid-type]
        return super().init_struct("paramBrand", **kwarg)  # type: ignore[return-value]

    def init_resultBrand(self, **kwarg) -> CapnpBrand:  # type: ignore[valid-type]
        return super().init_struct("resultBrand", **kwarg)  # type: ignore[return-value]

    def init_implicitParameters(self, size: int) -> list[CapnpNodeParameter]:  # type: ignore[valid-type]
        return super().init_list("implicitParameters", size)  # type: ignore[return-value]


class CapnpSuperclass(zhinst.comms.DynamicStruct):
    capnp_id = 0xA9962A9ED0A4D7F8
    id: int  # uint64
    brand: CapnpBrand

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)

    def init_brand(self, **kwarg) -> CapnpBrand:  # type: ignore[valid-type]
        return super().init_struct("brand", **kwarg)  # type: ignore[return-value]


class CapnpNodeInterface(zhinst.comms.DynamicStruct):
    # Group struct. This struct is not instantiable directly.
    capnp_id = 0xE82753CFF0C2218F
    methods: list[CapnpMethod]
    superclasses: list[CapnpSuperclass]

    def init_methods(self, size: int) -> list[CapnpMethod]:  # type: ignore[valid-type]
        return super().init_list("methods", size)  # type: ignore[return-value]

    def init_superclasses(self, size: int) -> list[CapnpSuperclass]:  # type: ignore[valid-type]
        return super().init_list("superclasses", size)  # type: ignore[return-value]


class CapnpType(zhinst.comms.DynamicStruct):
    capnp_id = 0xD07378EDE1F9CC60
    void: t.Any
    bool: t.Any
    int8: t.Any
    int16: t.Any
    int32: t.Any
    int64: t.Any
    uint8: t.Any
    uint16: t.Any
    uint32: t.Any
    uint64: t.Any
    float32: t.Any
    float64: t.Any
    text: t.Any
    data: t.Any
    list: CapnpTypeList
    enum: CapnpTypeEnum
    struct: CapnpTypeStruct
    interface: CapnpTypeInterface
    anyPointer: CapnpTypeAnyPointer

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)

    def init_interface(self, **kwarg) -> CapnpTypeInterface:  # type: ignore[valid-type]
        return super().init_struct("interface", **kwarg)  # type: ignore[return-value]

    def init_anyPointer(self, **kwarg) -> CapnpTypeAnyPointer:  # type: ignore[valid-type]
        return super().init_struct("anyPointer", **kwarg)  # type: ignore[return-value]


class CapnpValue(zhinst.comms.DynamicStruct):
    capnp_id = 0xCE23DCD2D7B00C9B
    void: t.Any
    bool: bool
    int8: int  # uint8
    int16: int  # uint16
    int32: int  # uint32
    int64: int  # uint64
    uint8: int  # uint8
    uint16: int  # uint16
    uint32: int  # uint32
    uint64: int  # uint64
    float32: float  # float32
    float64: float  # float64
    text: str
    data: bytes
    list: t.Any
    enum: int  # uint16
    struct: t.Any
    interface: t.Any
    anyPointer: t.Any

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)


class CapnpNodeConst(zhinst.comms.DynamicStruct):
    # Group struct. This struct is not instantiable directly.
    capnp_id = 0xB18AA5AC7A0D9420
    type: CapnpType
    value: CapnpValue

    def init_type(self, **kwarg) -> CapnpType:  # type: ignore[valid-type]
        return super().init_struct("type", **kwarg)  # type: ignore[return-value]

    def init_value(self, **kwarg) -> CapnpValue:  # type: ignore[valid-type]
        return super().init_struct("value", **kwarg)  # type: ignore[return-value]


class CapnpNodeAnnotation(zhinst.comms.DynamicStruct):
    # Group struct. This struct is not instantiable directly.
    capnp_id = 0xEC1619D4400A0290
    type: CapnpType
    targetsFile: bool
    targetsConst: bool
    targetsEnum: bool
    targetsEnumerant: bool
    targetsStruct: bool
    targetsField: bool
    targetsUnion: bool
    targetsGroup: bool
    targetsInterface: bool
    targetsMethod: bool
    targetsParam: bool
    targetsAnnotation: bool

    def init_type(self, **kwarg) -> CapnpType:  # type: ignore[valid-type]
        return super().init_struct("type", **kwarg)  # type: ignore[return-value]


class CapnpNodeNestedNode(zhinst.comms.DynamicStruct):
    capnp_id = 0xDEBF55BBFA0FC242
    name: str
    id: int  # uint64

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)


class CapnpAnnotation(zhinst.comms.DynamicStruct):
    capnp_id = 0xF1C8950DAB257542
    id: int  # uint64
    value: CapnpValue
    brand: CapnpBrand

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)

    def init_value(self, **kwarg) -> CapnpValue:  # type: ignore[valid-type]
        return super().init_struct("value", **kwarg)  # type: ignore[return-value]

    def init_brand(self, **kwarg) -> CapnpBrand:  # type: ignore[valid-type]
        return super().init_struct("brand", **kwarg)  # type: ignore[return-value]


class CapnpNodeParameter(zhinst.comms.DynamicStruct):
    capnp_id = 0xB9521BCCF10FA3B1
    name: str

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)


class CapnpBrand(zhinst.comms.DynamicStruct):
    capnp_id = 0x903455F06065422B
    scopes: list[CapnpBrandScope]

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)

    def init_scopes(self, size: int) -> list[CapnpBrandScope]:  # type: ignore[valid-type]
        return super().init_list("scopes", size)  # type: ignore[return-value]


class CapnpBrandScope(zhinst.comms.DynamicStruct):
    capnp_id = 0xABD73485A9636BC9
    scopeId: int  # uint64
    bind: list[CapnpBrandBinding]
    inherit: t.Any

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)

    def init_bind(self, size: int) -> list[CapnpBrandBinding]:  # type: ignore[valid-type]
        return super().init_list("bind", size)  # type: ignore[return-value]


class CapnpBrandBinding(zhinst.comms.DynamicStruct):
    capnp_id = 0xC863CD16969EE7FC
    unbound: t.Any
    type: CapnpType

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)

    def init_type(self, **kwarg) -> CapnpType:  # type: ignore[valid-type]
        return super().init_struct("type", **kwarg)  # type: ignore[return-value]


class CapnpTypeList(zhinst.comms.DynamicStruct):
    # Group struct. This struct is not instantiable directly.
    capnp_id = 0x87E739250A60EA97
    elementType: CapnpType

    def init_elementType(self, **kwarg) -> CapnpType:  # type: ignore[valid-type]
        return super().init_struct("elementType", **kwarg)  # type: ignore[return-value]


class CapnpTypeEnum(zhinst.comms.DynamicStruct):
    # Group struct. This struct is not instantiable directly.
    capnp_id = 0x9E0E78711A7F87A9
    typeId: int  # uint64
    brand: CapnpBrand

    def init_brand(self, **kwarg) -> CapnpBrand:  # type: ignore[valid-type]
        return super().init_struct("brand", **kwarg)  # type: ignore[return-value]


class CapnpTypeStruct(zhinst.comms.DynamicStruct):
    # Group struct. This struct is not instantiable directly.
    capnp_id = 0xAC3A6F60EF4CC6D3
    typeId: int  # uint64
    brand: CapnpBrand

    def init_brand(self, **kwarg) -> CapnpBrand:  # type: ignore[valid-type]
        return super().init_struct("brand", **kwarg)  # type: ignore[return-value]


class CapnpTypeInterface(zhinst.comms.DynamicStruct):
    # Group struct. This struct is not instantiable directly.
    capnp_id = 0xED8BCA69F7FB0CBF
    typeId: int  # uint64
    brand: CapnpBrand

    def init_brand(self, **kwarg) -> CapnpBrand:  # type: ignore[valid-type]
        return super().init_struct("brand", **kwarg)  # type: ignore[return-value]


class CapnpTypeAnyPointerUnconstrained(zhinst.comms.DynamicStruct):
    # Group struct. This struct is not instantiable directly.
    capnp_id = 0x8E3B5F79FE593656
    anyKind: t.Any
    struct: t.Any
    list: t.Any
    capability: t.Any


class CapnpTypeAnyPointerParameter(zhinst.comms.DynamicStruct):
    # Group struct. This struct is not instantiable directly.
    capnp_id = 0x9DD1F724F4614A85
    scopeId: int  # uint64
    parameterIndex: int  # uint16


class CapnpTypeAnyPointerImplicitMethodParameter(zhinst.comms.DynamicStruct):
    # Group struct. This struct is not instantiable directly.
    capnp_id = 0xBAEFC9120C56E274
    parameterIndex: int  # uint16


class CapnpTypeAnyPointer(zhinst.comms.DynamicStruct):
    # Group struct. This struct is not instantiable directly.
    capnp_id = 0xC2573FE8A23E49F1
    unconstrained: CapnpTypeAnyPointerUnconstrained
    parameter: CapnpTypeAnyPointerParameter
    implicitMethodParameter: CapnpTypeAnyPointerImplicitMethodParameter

    def init_unconstrained(self, **kwarg) -> CapnpTypeAnyPointerUnconstrained:  # type: ignore[valid-type]
        return super().init_struct("unconstrained", **kwarg)  # type: ignore[return-value]

    def init_parameter(self, **kwarg) -> CapnpTypeAnyPointerParameter:  # type: ignore[valid-type]
        return super().init_struct("parameter", **kwarg)  # type: ignore[return-value]

    def init_implicitMethodParameter(self, **kwarg) -> CapnpTypeAnyPointerImplicitMethodParameter:  # type: ignore[valid-type]
        return super().init_struct("implicitMethodParameter", **kwarg)  # type: ignore[return-value]


class CapnpFieldSlot(zhinst.comms.DynamicStruct):
    # Group struct. This struct is not instantiable directly.
    capnp_id = 0xC42305476BB4746F
    offset: int  # uint32
    type: CapnpType
    defaultValue: CapnpValue
    hadExplicitDefault: bool

    def init_type(self, **kwarg) -> CapnpType:  # type: ignore[valid-type]
        return super().init_struct("type", **kwarg)  # type: ignore[return-value]

    def init_defaultValue(self, **kwarg) -> CapnpValue:  # type: ignore[valid-type]
        return super().init_struct("defaultValue", **kwarg)  # type: ignore[return-value]


class CapnpFieldGroup(zhinst.comms.DynamicStruct):
    # Group struct. This struct is not instantiable directly.
    capnp_id = 0xCAFCCDDB68DB1D11
    typeId: int  # uint64


class CapnpFieldOrdinal(zhinst.comms.DynamicStruct):
    # Group struct. This struct is not instantiable directly.
    capnp_id = 0xBB90D5C287870BE6
    implicit: t.Any
    explicit: int  # uint16


class SessionListNodesParams(zhinst.comms.DynamicStruct):
    capnp_id = 0x92035429255EF5A8
    pathExpression: str
    flags: int  # uint32
    client: bytes

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)


class SessionListNodesResults(zhinst.comms.DynamicStruct):
    capnp_id = 0xEBD34BDB74C961B0
    paths: list[str]

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)

    def init_paths(self, size: int) -> list[str]:  # type: ignore[valid-type]
        return super().init_list("paths", size)  # type: ignore[return-value]


class SessionDeprecatedGetValuesParams(zhinst.comms.DynamicStruct):
    capnp_id = 0xCD242E1BB990DFE7
    paths: list[str]
    client: bytes

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)

    def init_paths(self, size: int) -> list[str]:  # type: ignore[valid-type]
        return super().init_list("paths", size)  # type: ignore[return-value]


class Result(zhinst.comms.DynamicStruct):
    capnp_id = 0xBAB0F33E1934323D
    ok: t.Any
    err: t.Any

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)


class AnnotatedValue(zhinst.comms.DynamicStruct):
    capnp_id = 0xF408EE376E837CDC
    metadata: AnnotatedValueMetadata
    value: Value

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)

    def init_metadata(self, **kwarg) -> AnnotatedValueMetadata:  # type: ignore[valid-type]
        return super().init_struct("metadata", **kwarg)  # type: ignore[return-value]

    def init_value(self, **kwarg) -> Value:  # type: ignore[valid-type]
        return super().init_struct("value", **kwarg)  # type: ignore[return-value]


class Error(zhinst.comms.DynamicStruct):
    capnp_id = 0xC4E34E4C517D11D9
    code: int  # uint32
    message: str
    category: str
    kind: ErrorKind
    source: str

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)


class SessionDeprecatedGetValuesResults(zhinst.comms.DynamicStruct):
    capnp_id = 0xE948518C129575BB
    result: list[Result]

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)

    def init_result(self, size: int) -> list[Result]:  # type: ignore[valid-type]
        return super().init_list("result", size)  # type: ignore[return-value]


class Value(zhinst.comms.DynamicStruct):
    capnp_id = 0xB1838B4771BE75AC
    int64: int  # uint64
    double: float  # float64
    complex: complex
    string: str
    vectorData: VectorData
    cntSample: CntSample
    triggerSample: TriggerSample
    none: VoidStruct
    streamingError: Error
    shfDemodData: ShfDemodulatorVectorData
    shfResultLoggerData: ShfResultLoggerVectorData
    vectorCntSamples: list[CntSample]
    vectorTriggerSamples: list[TriggerSample]
    largeVectorData: LargeVectorData
    bool: bool
    shfScopeData: ShfScopeVectorData
    shfGeneratorWaveformData: ShfGeneratorWaveformVectorData
    shfPidData: ShfPidVectorData

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)

    def init_complex(self, **kwarg) -> complex:  # type: ignore[valid-type]
        return super().init_struct("complex", **kwarg)  # type: ignore[return-value]

    def init_vectorData(self, **kwarg) -> VectorData:  # type: ignore[valid-type]
        return super().init_struct("vectorData", **kwarg)  # type: ignore[return-value]

    def init_cntSample(self, **kwarg) -> CntSample:  # type: ignore[valid-type]
        return super().init_struct("cntSample", **kwarg)  # type: ignore[return-value]

    def init_triggerSample(self, **kwarg) -> TriggerSample:  # type: ignore[valid-type]
        return super().init_struct("triggerSample", **kwarg)  # type: ignore[return-value]

    def init_none(self, **kwarg) -> VoidStruct:  # type: ignore[valid-type]
        return super().init_struct("none", **kwarg)  # type: ignore[return-value]

    def init_streamingError(self, **kwarg) -> Error:  # type: ignore[valid-type]
        return super().init_struct("streamingError", **kwarg)  # type: ignore[return-value]

    def init_shfDemodData(self, **kwarg) -> ShfDemodulatorVectorData:  # type: ignore[valid-type]
        return super().init_struct("shfDemodData", **kwarg)  # type: ignore[return-value]

    def init_shfResultLoggerData(self, **kwarg) -> ShfResultLoggerVectorData:  # type: ignore[valid-type]
        return super().init_struct("shfResultLoggerData", **kwarg)  # type: ignore[return-value]

    def init_vectorCntSamples(self, size: int) -> list[CntSample]:  # type: ignore[valid-type]
        return super().init_list("vectorCntSamples", size)  # type: ignore[return-value]

    def init_vectorTriggerSamples(self, size: int) -> list[TriggerSample]:  # type: ignore[valid-type]
        return super().init_list("vectorTriggerSamples", size)  # type: ignore[return-value]

    def init_largeVectorData(self, **kwarg) -> LargeVectorData:  # type: ignore[valid-type]
        return super().init_struct("largeVectorData", **kwarg)  # type: ignore[return-value]

    def init_shfScopeData(self, **kwarg) -> ShfScopeVectorData:  # type: ignore[valid-type]
        return super().init_struct("shfScopeData", **kwarg)  # type: ignore[return-value]

    def init_shfGeneratorWaveformData(self, **kwarg) -> ShfGeneratorWaveformVectorData:  # type: ignore[valid-type]
        return super().init_struct("shfGeneratorWaveformData", **kwarg)  # type: ignore[return-value]

    def init_shfPidData(self, **kwarg) -> ShfPidVectorData:  # type: ignore[valid-type]
        return super().init_struct("shfPidData", **kwarg)  # type: ignore[return-value]


class ReturnFromSetWhen(zhinst.comms.DynamicEnum):
    capnp_id = 0xDD2DA53AAC55EDF9
    asap = 0
    deviceAck = 1
    unusedAsync = 2
    unusedTransactional = 3


class SessionDeprecatedSetValueParams(zhinst.comms.DynamicStruct):
    capnp_id = 0xA8F6FDED40F38065
    path: str
    value: Value
    completeWhen: ReturnFromSetWhen

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)

    def init_value(self, **kwarg) -> Value:  # type: ignore[valid-type]
        return super().init_struct("value", **kwarg)  # type: ignore[return-value]


class VoidStruct(zhinst.comms.DynamicStruct):
    capnp_id = 0xDF7FE8E981437816

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)


class SessionDeprecatedSetValueResults(zhinst.comms.DynamicStruct):
    capnp_id = 0x8AEF0146A9595DF9
    result: Result

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)

    def init_result(self, **kwarg) -> Result:  # type: ignore[valid-type]
        return super().init_struct("result", **kwarg)  # type: ignore[return-value]


class Subscription(zhinst.comms.DynamicStruct):
    capnp_id = 0xEDAC21A53DE1B1D4
    path: str
    streamingHandle: t.Any
    subscriberId: bytes

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)


class SessionSubscribeParams(zhinst.comms.DynamicStruct):
    capnp_id = 0xB9B18BE9AFB1B3E4
    subscription: Subscription

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)

    def init_subscription(self, **kwarg) -> Subscription:  # type: ignore[valid-type]
        return super().init_struct("subscription", **kwarg)  # type: ignore[return-value]


class SessionSubscribeResults(zhinst.comms.DynamicStruct):
    capnp_id = 0xA0CA6692DF48C93F
    result: Result

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)

    def init_result(self, **kwarg) -> Result:  # type: ignore[valid-type]
        return super().init_struct("result", **kwarg)  # type: ignore[return-value]


class SessionDisconnectDeviceParams(zhinst.comms.DynamicStruct):
    capnp_id = 0xE682E60B2CD90782

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)


class SessionListNodesJsonParams(zhinst.comms.DynamicStruct):
    capnp_id = 0xCD837FE86531F6C1
    pathExpression: str
    flags: int  # uint32
    client: bytes

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)


class SessionListNodesJsonResults(zhinst.comms.DynamicStruct):
    capnp_id = 0xA8151642645BFA32
    nodeProps: str

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)


class SessionUnsubscribeParams(zhinst.comms.DynamicStruct):
    capnp_id = 0xB16A1640DB91E61C
    subscriberId: bytes
    paths: list[str]

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)

    def init_paths(self, size: int) -> list[str]:  # type: ignore[valid-type]
        return super().init_list("paths", size)  # type: ignore[return-value]


class SessionGetSessionVersionParams(zhinst.comms.DynamicStruct):
    capnp_id = 0xD77D14CF14B3405A

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)


class SessionGetSessionVersionResults(zhinst.comms.DynamicStruct):
    capnp_id = 0xCC68434DA57CF6B3
    version: str

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)


class SessionDeprecatedSetValue2Params(zhinst.comms.DynamicStruct):
    capnp_id = 0xDAE05CD32680ABA1
    path: str
    value: Value
    completeWhen: ReturnFromSetWhen
    client: bytes

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)

    def init_value(self, **kwarg) -> Value:  # type: ignore[valid-type]
        return super().init_struct("value", **kwarg)  # type: ignore[return-value]


class SessionDeprecatedSetValue2Results(zhinst.comms.DynamicStruct):
    capnp_id = 0xFD47648E56C0E689
    result: Result

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)

    def init_result(self, **kwarg) -> Result:  # type: ignore[valid-type]
        return super().init_struct("result", **kwarg)  # type: ignore[return-value]


class LookupMode(zhinst.comms.DynamicEnum):
    capnp_id = 0xDA5049B5E072F425
    directLookup = 0
    withExpansion = 1


class SessionSetValueParams(zhinst.comms.DynamicStruct):
    capnp_id = 0x9FE29A10493E27C7
    pathExpression: str
    value: Value
    lookupMode: LookupMode
    completeWhen: ReturnFromSetWhen
    client: bytes

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)

    def init_value(self, **kwarg) -> Value:  # type: ignore[valid-type]
        return super().init_struct("value", **kwarg)  # type: ignore[return-value]


class SessionSetValueResults(zhinst.comms.DynamicStruct):
    capnp_id = 0x9474D85F26F63900
    result: list[Result]

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)

    def init_result(self, size: int) -> list[Result]:  # type: ignore[valid-type]
        return super().init_list("result", size)  # type: ignore[return-value]


class SessionGetValueParams(zhinst.comms.DynamicStruct):
    capnp_id = 0xC5E872236CC4917B
    pathExpression: str
    lookupMode: LookupMode
    flags: int  # uint32
    client: bytes

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)


class SessionGetValueResults(zhinst.comms.DynamicStruct):
    capnp_id = 0xCE98719DBAD0A401
    result: list[Result]

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)

    def init_result(self, size: int) -> list[Result]:  # type: ignore[valid-type]
        return super().init_list("result", size)  # type: ignore[return-value]


class SessionCancelParams(zhinst.comms.DynamicStruct):
    capnp_id = 0xB77C3D30C74311FC
    client: bytes

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)


class AnnotatedValueMetadata(zhinst.comms.DynamicStruct):
    capnp_id = 0xAD53D8CA57AF3018
    timestamp: int  # uint64
    path: str

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)


class Complex(zhinst.comms.DynamicStruct):
    capnp_id = 0xAAF1AFAF97B4B157
    real: float  # float64
    imag: float  # float64

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)


class VectorData(zhinst.comms.DynamicStruct):
    capnp_id = 0x994C65B80DF38978
    valueType: int  # uint16
    vectorElementType: int  # uint8
    extraHeaderInfo: int  # uint32
    data: bytes

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)


class CntSample(zhinst.comms.DynamicStruct):
    capnp_id = 0xE9370BD8287D6065
    timestamp: int  # uint64
    counter: int  # uint32
    trigger: int  # uint32

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)


class TriggerSample(zhinst.comms.DynamicStruct):
    capnp_id = 0xDEB72097C27D0D95
    timestamp: int  # uint64
    sampleTick: int  # uint64
    trigger: int  # uint32
    missedTriggers: int  # uint32
    awgTrigger: int  # uint32
    dio: int  # uint32
    sequenceIndex: int  # uint32

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)


class ShfDemodulatorVectorData(zhinst.comms.DynamicStruct):
    capnp_id = 0x9B03E3E3E6006582
    properties: ShfDemodulatorVectorDataProperties
    x: list[float]  # list[float64]
    y: list[float]  # list[float64]

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)

    def init_properties(self, **kwarg) -> ShfDemodulatorVectorDataProperties:  # type: ignore[valid-type]
        return super().init_struct("properties", **kwarg)  # type: ignore[return-value]

    def init_x(self, size: int) -> list[float]:  # type: ignore[valid-type]
        return super().init_list("x", size)  # type: ignore[return-value]

    def init_y(self, size: int) -> list[float]:  # type: ignore[valid-type]
        return super().init_list("y", size)  # type: ignore[return-value]


class ShfResultLoggerVectorData(zhinst.comms.DynamicStruct):
    capnp_id = 0xBBA061F579761DDD
    properties: ShfResultLoggerVectorDataProperties
    vector: ShfResultLoggerVectorDataVector

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)

    def init_properties(self, **kwarg) -> ShfResultLoggerVectorDataProperties:  # type: ignore[valid-type]
        return super().init_struct("properties", **kwarg)  # type: ignore[return-value]

    def init_vector(self, **kwarg) -> ShfResultLoggerVectorDataVector:  # type: ignore[valid-type]
        return super().init_struct("vector", **kwarg)  # type: ignore[return-value]


class LargeVectorData(zhinst.comms.DynamicStruct):
    capnp_id = 0xD948F7B09959B00A
    valueType: int  # uint16
    vectorElementType: int  # uint8
    extraHeaderInfo: int  # uint32
    dataSegments: list[bytes]

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)

    def init_dataSegments(self, size: int) -> list[bytes]:  # type: ignore[valid-type]
        return super().init_list("dataSegments", size)  # type: ignore[return-value]


class ShfScopeVectorData(zhinst.comms.DynamicStruct):
    capnp_id = 0xA9B07F1F82A93BC9
    properties: ShfScopeVectorDataProperties
    vector: ShfScopeVectorDataVector

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)

    def init_properties(self, **kwarg) -> ShfScopeVectorDataProperties:  # type: ignore[valid-type]
        return super().init_struct("properties", **kwarg)  # type: ignore[return-value]

    def init_vector(self, **kwarg) -> ShfScopeVectorDataVector:  # type: ignore[valid-type]
        return super().init_struct("vector", **kwarg)  # type: ignore[return-value]


class ShfGeneratorWaveformVectorData(zhinst.comms.DynamicStruct):
    capnp_id = 0xEDCFE06E81C4F3D0
    complex: list[complex]

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)

    def init_complex(self, size: int) -> list[complex]:  # type: ignore[valid-type]
        return super().init_list("complex", size)  # type: ignore[return-value]


class ShfPidVectorData(zhinst.comms.DynamicStruct):
    capnp_id = 0xFF6EE171549A2870
    properties: ShfPidVectorDataProperties
    value: list[float]  # list[float64]
    error: list[float]  # list[float64]

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)

    def init_properties(self, **kwarg) -> ShfPidVectorDataProperties:  # type: ignore[valid-type]
        return super().init_struct("properties", **kwarg)  # type: ignore[return-value]

    def init_value(self, size: int) -> list[float]:  # type: ignore[valid-type]
        return super().init_list("value", size)  # type: ignore[return-value]

    def init_error(self, size: int) -> list[float]:  # type: ignore[valid-type]
        return super().init_list("error", size)  # type: ignore[return-value]


class ErrorKind(zhinst.comms.DynamicEnum):
    capnp_id = 0xB7E671E24A9802BD
    ok = 0
    cancelled = 1
    unknown = 2
    notFound = 3
    overwhelmed = 4
    badRequest = 5
    unimplemented = 6
    internal = 7
    unavailable = 8
    timeout = 9


class ShfDemodulatorVectorDataProperties(zhinst.comms.DynamicStruct):
    # Group struct. This struct is not instantiable directly.
    capnp_id = 0xD475786CA25C300D
    timestamp: int  # uint64
    dt: int  # uint64
    burstLength: int  # uint32
    burstOffset: int  # uint32
    triggerIndex: int  # uint32
    triggerTimestamp: int  # uint64
    centerFreq: float  # float64
    rfPath: bool
    oscillatorSource: int  # uint16
    harmonic: int  # uint16
    triggerSource: int  # uint8
    signalSource: int  # uint16
    oscillatorFreq: float  # float64
    scaling: float  # float64


class ShfResultLoggerVectorDataProperties(zhinst.comms.DynamicStruct):
    # Group struct. This struct is not instantiable directly.
    capnp_id = 0xDDB7B421EA0EEC5E
    timestamp: int  # uint64
    jobId: int  # uint32
    repetitionId: int  # uint32
    scaling: float  # float64
    centerFrequency: float  # float64
    dataSource: int  # uint32
    numSamples: int  # uint32
    numSpectrSamples: int  # uint32
    numAverages: int  # uint32
    numAcquired: int  # uint32
    holdoffErrorsReslog: int  # uint16
    holdoffErrorsReadout: int  # uint16
    holdoffErrorsSpectr: int  # uint16
    firstSampleTimestamp: int  # uint64


class ShfResultLoggerVectorDataVector(zhinst.comms.DynamicStruct):
    # Group struct. This struct is not instantiable directly.
    capnp_id = 0x980B68B5449BDF12
    real: list[float]  # list[float64]
    complex: list[complex]

    def init_real(self, size: int) -> list[float]:  # type: ignore[valid-type]
        return super().init_list("real", size)  # type: ignore[return-value]

    def init_complex(self, size: int) -> list[complex]:  # type: ignore[valid-type]
        return super().init_list("complex", size)  # type: ignore[return-value]


class ShfScopeVectorDataProperties(zhinst.comms.DynamicStruct):
    # Group struct. This struct is not instantiable directly.
    capnp_id = 0xD707B876F9608924
    timestamp: int  # uint64
    timestampDiff: int  # uint32
    flags: int  # uint32
    scaling: float  # float64
    centerFrequency: float  # float64
    triggerTimestamp: int  # uint64
    inputSelect: int  # uint32
    averageCount: int  # uint32
    numSegments: int  # uint32
    numTotalSegments: int  # uint32
    firstSegmentIndex: int  # uint32
    numMissedTriggers: int  # uint32


class ShfScopeVectorDataVector(zhinst.comms.DynamicStruct):
    # Group struct. This struct is not instantiable directly.
    capnp_id = 0xD10AAB878C8E14BC
    real: list[float]  # list[float64]
    complex: list[complex]

    def init_real(self, size: int) -> list[float]:  # type: ignore[valid-type]
        return super().init_list("real", size)  # type: ignore[return-value]

    def init_complex(self, size: int) -> list[complex]:  # type: ignore[valid-type]
        return super().init_list("complex", size)  # type: ignore[return-value]


class ShfPidVectorDataProperties(zhinst.comms.DynamicStruct):
    # Group struct. This struct is not instantiable directly.
    capnp_id = 0x9BE09D0677995544
    timestamp: int  # uint64
    timestampDiff: int  # uint64
    burstLength: int  # uint32
    burstOffset: int  # uint32
    triggerIndex: int  # uint32
    triggerTimestamp: int  # uint64
    centerPoint: float  # float64
    inputChannel: int  # uint8
    input: int  # uint8
    outputChannel: int  # uint8
    output: int  # uint8
    triggerSrc: int  # uint8
    scaleValue: float  # float64
    scaleError: float  # float64
    setPoint: float  # float64


class StreamingHandleSendValuesParams(zhinst.comms.DynamicStruct):
    capnp_id = 0xA30BAD0F967C47B6
    values: list[AnnotatedValue]

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)

    def init_values(self, size: int) -> list[AnnotatedValue]:  # type: ignore[valid-type]
        return super().init_list("values", size)  # type: ignore[return-value]


class CapnpStreamResult(zhinst.comms.DynamicStruct):
    capnp_id = 0x995F9A3377C0B16E

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)
