# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class AttachDiskRequest(JDCloudRequest):
    """
    
为一台云主机挂载云硬盘。

详细操作说明请参考帮助文档：[挂载云硬盘](https://docs.jdcloud.com/cn/virtual-machines/attach-cloud-disk)

## 接口说明
- 云主机和云硬盘都没有正在进行中的的任务时才可以操作。
- 云主机状态必须是 `running` 或 `stopped` 状态。操作系统盘时必须先停止实例。
- 实例挂载云硬盘的数量，不能超过实例规格的限制。可查询  [DescribeInstanceTypes](https://docs.jdcloud.com/virtual-machines/api/describeinstancetypes)  接口获得指定规格可挂载云硬盘的数量上限。
- 云硬盘作为系统盘时，容量不能小于40GB，并且不能超过500GB。
- 待挂载的云硬盘与云主机实例必须在同一个可用区下。
- 共享型云硬盘最多可挂载16个云主机实例，并且只能用作数据盘，不能用于系统盘。非共享型云盘最多只能挂载一个云主机实例。

    """

    def __init__(self, parameters, header=None, version="v1"):
        super(AttachDiskRequest, self).__init__(
            '/regions/{regionId}/instances/{instanceId}:attachDisk', 'POST', header, version)
        self.parameters = parameters


class AttachDiskParameters(object):

    def __init__(self, regionId,instanceId,diskId, ):
        """
        :param regionId: 地域ID。
        :param instanceId: 云主机ID。
        :param diskId: 云硬盘ID。
        """

        self.regionId = regionId
        self.instanceId = instanceId
        self.diskId = diskId
        self.deviceName = None
        self.autoDelete = None

    def setDeviceName(self, deviceName):
        """
        :param deviceName: (Optional) 磁盘逻辑挂载点。
**系统盘**：必须指定并且只能是vda。
**数据盘**：取值范围：`[vdb~vdbm]`。

        """
        self.deviceName = deviceName

    def setAutoDelete(self, autoDelete):
        """
        :param autoDelete: (Optional) 是否随实例一起删除，即删除实例时是否自动删除此磁盘。此参数仅对按配置计费的非多点挂载云硬盘生效。
可选值：
`true`：随实例删除。
`false`（默认值）：不随实例删除。

        """
        self.autoDelete = autoDelete

