# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class ListRulesRequest(JDCloudRequest):
    """
    包内的搜索、排序和筛选规则
    """

    def __init__(self, parameters, header=None, version="v1"):
        super(ListRulesRequest, self).__init__(
            '/zones/{zone_id}/firewall$$waf$$packages/{package_id}/rules', 'GET', header, version)
        self.parameters = parameters


class ListRulesParameters(object):

    def __init__(self, zone_id, package_id, ):
        """
        :param zone_id: 
        :param package_id: 
        """

        self.zone_id = zone_id
        self.package_id = package_id
        self.mode = None
        self.priority = None
        self.match = None
        self.order = None
        self.page = None
        self.per_page = None
        self.group_id = None
        self.description = None
        self.direction = None

    def setMode(self, mode):
        """
        :param mode: (Optional) 已将规则覆盖到的设置
        """
        self.mode = mode

    def setPriority(self, priority):
        """
        :param priority: (Optional) 在相关组中执行单个规则的顺序
        """
        self.priority = priority

    def setMatch(self, match):
        """
        :param match: (Optional) 是否匹配所有搜索要求或至少一个（任何）
        """
        self.match = match

    def setOrder(self, order):
        """
        :param order: (Optional) 按指定字段排序
        """
        self.order = order

    def setPage(self, page):
        """
        :param page: (Optional) 分页结果的页码
        """
        self.page = page

    def setPer_page(self, per_page):
        """
        :param per_page: (Optional) 每页的规则数
        """
        self.per_page = per_page

    def setGroup_id(self, group_id):
        """
        :param group_id: (Optional) WAF组标识符标签
        """
        self.group_id = group_id

    def setDescription(self, description):
        """
        :param description: (Optional) 规则的公开说明
        """
        self.description = description

    def setDirection(self, direction):
        """
        :param direction: (Optional) asc-升序；desc-降序
        """
        self.direction = direction

