# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class CreateInstanceRequest(JDCloudRequest):
    """
    创建套餐实例
    """

    def __init__(self, parameters, header=None, version="v1"):
        super(CreateInstanceRequest, self).__init__(
            '/regions/{regionId}/instances', 'POST', header, version)
        self.parameters = parameters


class CreateInstanceParameters(object):

    def __init__(self, regionId, ):
        """
        :param regionId: 地域ID
        """

        self.regionId = regionId
        self.chargeMode = None
        self.packType = None
        self.zonePackNum = None
        self.duration = None
        self.durationUnit = None
        self.autoRenewStatus = None
        self.instanceName = None
        self.memo = None
        self.returnUrl = None

    def setChargeMode(self, chargeMode):
        """
        :param chargeMode: (Optional) 计费模式（CONFIG、FLOW、MONTHLY、ONCE）
CONFIG 按配置
FLOW 按用量
MONTHLY 包年包月
ONCE 一次性

        """
        self.chargeMode = chargeMode

    def setPackType(self, packType):
        """
        :param packType: (Optional) 套餐类型（BASIC、PROFESSIONAL、ENTERPRISE、ULTIMATE、SMB_EXPERIENCE、SMB_BASIC、SMB_BUSINESS）
BASIC 包年包月 基础版
PROFESSIONAL 包年包月 专业版
ENTERPRISE 包年包月 企业版
ULTIMATE 包年包月 旗舰版
--------------------------
SMB_EXPERIENCE 按流量 体验版
SMB_BASIC 按流量 基础版
SMB_BUSINESS 按流量 商业版

        """
        self.packType = packType

    def setZonePackNum(self, zonePackNum):
        """
        :param zonePackNum: (Optional) 域名增量包数量
        """
        self.zonePackNum = zonePackNum

    def setDuration(self, duration):
        """
        :param duration: (Optional) 计费时长
        """
        self.duration = duration

    def setDurationUnit(self, durationUnit):
        """
        :param durationUnit: (Optional) 计费时长单位（MONTH、YEAR）
        """
        self.durationUnit = durationUnit

    def setAutoRenewStatus(self, autoRenewStatus):
        """
        :param autoRenewStatus: (Optional) 自动续费状态(OPEN->开通自动续费 CLOSE->关闭自动续费)
        """
        self.autoRenewStatus = autoRenewStatus

    def setInstanceName(self, instanceName):
        """
        :param instanceName: (Optional) 实例名称
        """
        self.instanceName = instanceName

    def setMemo(self, memo):
        """
        :param memo: (Optional) 备注
        """
        self.memo = memo

    def setReturnUrl(self, returnUrl):
        """
        :param returnUrl: (Optional) 支付成功返回路径
        """
        self.returnUrl = returnUrl

