# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class DescribeTagValuesRequest(JDCloudRequest):
    """
    查询某资源下指定tag key的tag value
    """

    def __init__(self, parameters, header=None, version="v2"):
        super(DescribeTagValuesRequest, self).__init__(
            '/regions/{regionId}/tagValues/{tagKey}', 'GET', header, version)
        self.parameters = parameters


class DescribeTagValuesParameters(object):

    def __init__(self, regionId,tagKey,serviceCode, resourceId, ):
        """
        :param regionId: region
        :param tagKey: region
        :param serviceCode: serviceCode
        :param resourceId: 资源标识
        """

        self.regionId = regionId
        self.tagKey = tagKey
        self.serviceCode = serviceCode
        self.resourceId = resourceId
        self.metric = None
        self.startTime = None
        self.endTime = None
        self.timeInterval = None
        self.tags = None

    def setMetric(self, metric):
        """
        :param metric: (Optional) metric
        """
        self.metric = metric

    def setStartTime(self, startTime):
        """
        :param startTime: (Optional) 查询时间范围的开始时间(如不传,则默认为1时前)， UTC时间，格式：2016-12-11T00:00:00+0800（注意在url中+,:要转译,如2019-10-23T10%3A33%3A31%2B0800）。对于非连续的时序数据，开始时间无法保证准确性
        """
        self.startTime = startTime

    def setEndTime(self, endTime):
        """
        :param endTime: (Optional) 查询时间范围的结束时间(如不传,则默认为当前)， UTC时间，格式：2016-12-11T00:00:00+0800（注意在url中+,:要转译,如2019-10-23T10%3A33%3A31%2B0800）.对于非连续的时序数据，结束时间无法保证准确性
        """
        self.endTime = endTime

    def setTimeInterval(self, timeInterval):
        """
        :param timeInterval: (Optional) 时间间隔：1h，6h，12h，1d，3d，7d，14d，固定时间间隔，timeInterval默认为1h，当前时间往 前1h
        """
        self.timeInterval = timeInterval

    def setTags(self, tags):
        """
        :param tags: (Optional) 根据tags进行筛选(传入*和不传的效果一致)
        """
        self.tags = tags

