# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class AllocDedicatedPoolRequest(JDCloudRequest):
    """
    申请专有宿主机池。<br>
专有宿主机池为专有宿主机的集合，为用户提供独享且跨机架的宿主机资源池，基于资源独享及故障隔离实现业务安全、高可用部署。<br>
申请宿主机池需要指定机器类型，目前每一个专有宿主机池只能指定一种机器类型。可供选用的机器类型有通用性，内存性，高频计算型及GPU型。<br>
deployPolicy表示是否强制池中专有宿主机在每个AZ内数量均衡。可选值为prefered和required，默认为prefered。

    """

    def __init__(self, parameters, header=None, version="v1"):
        super(AllocDedicatedPoolRequest, self).__init__(
            '/regions/{regionId}/dedicatedPools', 'POST', header, version)
        self.parameters = parameters


class AllocDedicatedPoolParameters(object):

    def __init__(self, regionId,):
        """
        :param regionId: 地域ID
        """

        self.regionId = regionId
        self.dedicatedHostType = None
        self.name = None
        self.az = None
        self.description = None

    def setDedicatedHostType(self, dedicatedHostType):
        """
        :param dedicatedHostType: (Optional) 支持的专有宿主机机型，每个专有宿主机池只能且必须指定一个专有宿主机机型

        """
        self.dedicatedHostType = dedicatedHostType

    def setName(self, name):
        """
        :param name: (Optional) 专有宿主机池名称

        """
        self.name = name

    def setAz(self, az):
        """
        :param az: (Optional) 指定专有宿主机池支持的可用区，可指定多个。

        """
        self.az = az

    def setDescription(self, description):
        """
        :param description: (Optional) 专有宿主机池的描述信息。

        """
        self.description = description

