# coding: utf-8

"""
    Workato Platform API

    Official Workato Platform API for managing recipes, connections, projects, and other automation resources.  ## Authentication All endpoints require a Bearer token in the Authorization header.  ## Base URL The base URL varies by region: - US: `https://www.workato.com` - EU: `https://app.eu.workato.com` - JP: `https://app.jp.workato.com` - SG: `https://app.sg.workato.com` - AU: `https://app.au.workato.com` - IL: `https://app.il.workato.com` - Trial: `https://app.trial.workato.com` 

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from workato_platform_cli.client.workato_api.models.asset_reference import AssetReference
from typing import Optional, Set
from typing_extensions import Self

class ExportManifestRequest(BaseModel):
    """
    ExportManifestRequest
    """ # noqa: E501
    name: StrictStr = Field(description="Name of the new manifest")
    assets: Optional[List[AssetReference]] = Field(default=None, description="Dependent assets to include in the manifest")
    folder_id: Optional[StrictInt] = Field(default=None, description="The ID of the folder containing the assets")
    include_test_cases: Optional[StrictBool] = Field(default=False, description="Whether the manifest includes test cases")
    auto_generate_assets: Optional[StrictBool] = Field(default=False, description="Auto-generates assets from a folder")
    include_data: Optional[StrictBool] = Field(default=False, description="Include data from automatic asset generation")
    include_tags: Optional[StrictBool] = Field(default=False, description="Include tags assigned to assets in the export manifest")
    __properties: ClassVar[List[str]] = ["name", "assets", "folder_id", "include_test_cases", "auto_generate_assets", "include_data", "include_tags"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ExportManifestRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in assets (list)
        _items = []
        if self.assets:
            for _item_assets in self.assets:
                if _item_assets:
                    _items.append(_item_assets.to_dict())
            _dict['assets'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ExportManifestRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "assets": [AssetReference.from_dict(_item) for _item in obj["assets"]] if obj.get("assets") is not None else None,
            "folder_id": obj.get("folder_id"),
            "include_test_cases": obj.get("include_test_cases") if obj.get("include_test_cases") is not None else False,
            "auto_generate_assets": obj.get("auto_generate_assets") if obj.get("auto_generate_assets") is not None else False,
            "include_data": obj.get("include_data") if obj.get("include_data") is not None else False,
            "include_tags": obj.get("include_tags") if obj.get("include_tags") is not None else False
        })
        return _obj


