# coding: utf-8

"""
    Workato Platform API

    Official Workato Platform API for managing recipes, connections, projects, and other automation resources.  ## Authentication All endpoints require a Bearer token in the Authorization header.  ## Base URL The base URL varies by region: - US: `https://www.workato.com` - EU: `https://app.eu.workato.com` - JP: `https://app.jp.workato.com` - SG: `https://app.sg.workato.com` - AU: `https://app.au.workato.com` - IL: `https://app.il.workato.com` - Trial: `https://app.trial.workato.com` 

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class ConnectionUpdateRequest(BaseModel):
    """
    ConnectionUpdateRequest
    """ # noqa: E501
    name: Optional[StrictStr] = Field(default=None, description="Name of the connection")
    parent_id: Optional[StrictInt] = Field(default=None, description="The ID of the parent connection (must be same provider type)")
    folder_id: Optional[StrictInt] = Field(default=None, description="The ID of the project or folder containing the connection")
    external_id: Optional[StrictStr] = Field(default=None, description="The external ID assigned to the connection")
    shell_connection: Optional[StrictBool] = Field(default=False, description="Specifies whether the connection is a shell connection or authenticated connection. If false, credentials are passed and connection is tested. If true, credentials are passed but connection isn't tested. ")
    input: Optional[Dict[str, Any]] = Field(default=None, description="Connection parameters (varies by provider)")
    __properties: ClassVar[List[str]] = ["name", "parent_id", "folder_id", "external_id", "shell_connection", "input"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ConnectionUpdateRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ConnectionUpdateRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "parent_id": obj.get("parent_id"),
            "folder_id": obj.get("folder_id"),
            "external_id": obj.get("external_id"),
            "shell_connection": obj.get("shell_connection") if obj.get("shell_connection") is not None else False,
            "input": obj.get("input")
        })
        return _obj


