# coding: utf-8

"""
    Workato Platform API

    Official Workato Platform API for managing recipes, connections, projects, and other automation resources.  ## Authentication All endpoints require a Bearer token in the Authorization header.  ## Base URL The base URL varies by region: - US: `https://www.workato.com` - EU: `https://app.eu.workato.com` - JP: `https://app.jp.workato.com` - SG: `https://app.sg.workato.com` - AU: `https://app.au.workato.com` - IL: `https://app.il.workato.com` - Trial: `https://app.trial.workato.com` 

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class Connection(BaseModel):
    """
    Connection
    """ # noqa: E501
    id: StrictInt
    application: StrictStr
    name: StrictStr
    description: Optional[StrictStr]
    authorized_at: Optional[datetime]
    authorization_status: Optional[StrictStr]
    authorization_error: Optional[StrictStr]
    created_at: datetime
    updated_at: datetime
    external_id: Optional[StrictStr]
    folder_id: StrictInt
    connection_lost_at: Optional[datetime]
    connection_lost_reason: Optional[StrictStr]
    parent_id: Optional[StrictInt]
    provider: Optional[StrictStr] = None
    tags: Optional[List[StrictStr]]
    __properties: ClassVar[List[str]] = ["id", "application", "name", "description", "authorized_at", "authorization_status", "authorization_error", "created_at", "updated_at", "external_id", "folder_id", "connection_lost_at", "connection_lost_reason", "parent_id", "provider", "tags"]

    @field_validator('authorization_status')
    def authorization_status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['success', 'failed', 'exception']):
            raise ValueError("must be one of enum values ('success', 'failed', 'exception')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Connection from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if authorized_at (nullable) is None
        # and model_fields_set contains the field
        if self.authorized_at is None and "authorized_at" in self.model_fields_set:
            _dict['authorized_at'] = None

        # set to None if authorization_status (nullable) is None
        # and model_fields_set contains the field
        if self.authorization_status is None and "authorization_status" in self.model_fields_set:
            _dict['authorization_status'] = None

        # set to None if authorization_error (nullable) is None
        # and model_fields_set contains the field
        if self.authorization_error is None and "authorization_error" in self.model_fields_set:
            _dict['authorization_error'] = None

        # set to None if external_id (nullable) is None
        # and model_fields_set contains the field
        if self.external_id is None and "external_id" in self.model_fields_set:
            _dict['external_id'] = None

        # set to None if connection_lost_at (nullable) is None
        # and model_fields_set contains the field
        if self.connection_lost_at is None and "connection_lost_at" in self.model_fields_set:
            _dict['connection_lost_at'] = None

        # set to None if connection_lost_reason (nullable) is None
        # and model_fields_set contains the field
        if self.connection_lost_reason is None and "connection_lost_reason" in self.model_fields_set:
            _dict['connection_lost_reason'] = None

        # set to None if parent_id (nullable) is None
        # and model_fields_set contains the field
        if self.parent_id is None and "parent_id" in self.model_fields_set:
            _dict['parent_id'] = None

        # set to None if tags (nullable) is None
        # and model_fields_set contains the field
        if self.tags is None and "tags" in self.model_fields_set:
            _dict['tags'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Connection from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "application": obj.get("application"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "authorized_at": obj.get("authorized_at"),
            "authorization_status": obj.get("authorization_status"),
            "authorization_error": obj.get("authorization_error"),
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at"),
            "external_id": obj.get("external_id"),
            "folder_id": obj.get("folder_id"),
            "connection_lost_at": obj.get("connection_lost_at"),
            "connection_lost_reason": obj.get("connection_lost_reason"),
            "parent_id": obj.get("parent_id"),
            "provider": obj.get("provider"),
            "tags": obj.get("tags")
        })
        return _obj


