# coding: utf-8

"""
    Workato Platform API

    Official Workato Platform API for managing recipes, connections, projects, and other automation resources.  ## Authentication All endpoints require a Bearer token in the Authorization header.  ## Base URL The base URL varies by region: - US: `https://www.workato.com` - EU: `https://app.eu.workato.com` - JP: `https://app.jp.workato.com` - SG: `https://app.sg.workato.com` - AU: `https://app.au.workato.com` - IL: `https://app.il.workato.com` - Trial: `https://app.trial.workato.com` 

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from datetime import datetime
from pydantic import Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import List, Optional
from typing_extensions import Annotated
from workato_platform_cli.client.workato_api.models.recipe_connection_update_request import RecipeConnectionUpdateRequest
from workato_platform_cli.client.workato_api.models.recipe_list_response import RecipeListResponse
from workato_platform_cli.client.workato_api.models.recipe_start_response import RecipeStartResponse
from workato_platform_cli.client.workato_api.models.success_response import SuccessResponse

from workato_platform_cli.client.workato_api.api_client import ApiClient, RequestSerialized
from workato_platform_cli.client.workato_api.api_response import ApiResponse
from workato_platform_cli.client.workato_api.rest import RESTResponseType


class RecipesApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    async def list_recipes(
        self,
        adapter_names_all: Annotated[Optional[StrictStr], Field(description="Comma-separated adapter names (recipes must use ALL)")] = None,
        adapter_names_any: Annotated[Optional[StrictStr], Field(description="Comma-separated adapter names (recipes must use ANY)")] = None,
        folder_id: Annotated[Optional[StrictInt], Field(description="Return recipes in specified folder")] = None,
        order: Annotated[Optional[StrictStr], Field(description="Set ordering method")] = None,
        page: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="Page number")] = None,
        per_page: Annotated[Optional[Annotated[int, Field(le=100, strict=True, ge=1)]], Field(description="Number of recipes per page")] = None,
        running: Annotated[Optional[StrictBool], Field(description="If true, returns only running recipes")] = None,
        since_id: Annotated[Optional[StrictInt], Field(description="Return recipes with IDs lower than this value")] = None,
        stopped_after: Annotated[Optional[datetime], Field(description="Exclude recipes stopped after this date (ISO 8601 format)")] = None,
        stop_cause: Annotated[Optional[StrictStr], Field(description="Filter by stop reason")] = None,
        updated_after: Annotated[Optional[datetime], Field(description="Include recipes updated after this date (ISO 8601 format)")] = None,
        includes: Annotated[Optional[List[StrictStr]], Field(description="Additional fields to include (e.g., tags)")] = None,
        exclude_code: Annotated[Optional[StrictBool], Field(description="Exclude recipe code from response for better performance")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RecipeListResponse:
        """List recipes

        Returns a list of recipes belonging to the authenticated user. Recipes are returned in descending ID order. 

        :param adapter_names_all: Comma-separated adapter names (recipes must use ALL)
        :type adapter_names_all: str
        :param adapter_names_any: Comma-separated adapter names (recipes must use ANY)
        :type adapter_names_any: str
        :param folder_id: Return recipes in specified folder
        :type folder_id: int
        :param order: Set ordering method
        :type order: str
        :param page: Page number
        :type page: int
        :param per_page: Number of recipes per page
        :type per_page: int
        :param running: If true, returns only running recipes
        :type running: bool
        :param since_id: Return recipes with IDs lower than this value
        :type since_id: int
        :param stopped_after: Exclude recipes stopped after this date (ISO 8601 format)
        :type stopped_after: datetime
        :param stop_cause: Filter by stop reason
        :type stop_cause: str
        :param updated_after: Include recipes updated after this date (ISO 8601 format)
        :type updated_after: datetime
        :param includes: Additional fields to include (e.g., tags)
        :type includes: List[str]
        :param exclude_code: Exclude recipe code from response for better performance
        :type exclude_code: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_recipes_serialize(
            adapter_names_all=adapter_names_all,
            adapter_names_any=adapter_names_any,
            folder_id=folder_id,
            order=order,
            page=page,
            per_page=per_page,
            running=running,
            since_id=since_id,
            stopped_after=stopped_after,
            stop_cause=stop_cause,
            updated_after=updated_after,
            includes=includes,
            exclude_code=exclude_code,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RecipeListResponse",
            '401': "Error",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def list_recipes_with_http_info(
        self,
        adapter_names_all: Annotated[Optional[StrictStr], Field(description="Comma-separated adapter names (recipes must use ALL)")] = None,
        adapter_names_any: Annotated[Optional[StrictStr], Field(description="Comma-separated adapter names (recipes must use ANY)")] = None,
        folder_id: Annotated[Optional[StrictInt], Field(description="Return recipes in specified folder")] = None,
        order: Annotated[Optional[StrictStr], Field(description="Set ordering method")] = None,
        page: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="Page number")] = None,
        per_page: Annotated[Optional[Annotated[int, Field(le=100, strict=True, ge=1)]], Field(description="Number of recipes per page")] = None,
        running: Annotated[Optional[StrictBool], Field(description="If true, returns only running recipes")] = None,
        since_id: Annotated[Optional[StrictInt], Field(description="Return recipes with IDs lower than this value")] = None,
        stopped_after: Annotated[Optional[datetime], Field(description="Exclude recipes stopped after this date (ISO 8601 format)")] = None,
        stop_cause: Annotated[Optional[StrictStr], Field(description="Filter by stop reason")] = None,
        updated_after: Annotated[Optional[datetime], Field(description="Include recipes updated after this date (ISO 8601 format)")] = None,
        includes: Annotated[Optional[List[StrictStr]], Field(description="Additional fields to include (e.g., tags)")] = None,
        exclude_code: Annotated[Optional[StrictBool], Field(description="Exclude recipe code from response for better performance")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[RecipeListResponse]:
        """List recipes

        Returns a list of recipes belonging to the authenticated user. Recipes are returned in descending ID order. 

        :param adapter_names_all: Comma-separated adapter names (recipes must use ALL)
        :type adapter_names_all: str
        :param adapter_names_any: Comma-separated adapter names (recipes must use ANY)
        :type adapter_names_any: str
        :param folder_id: Return recipes in specified folder
        :type folder_id: int
        :param order: Set ordering method
        :type order: str
        :param page: Page number
        :type page: int
        :param per_page: Number of recipes per page
        :type per_page: int
        :param running: If true, returns only running recipes
        :type running: bool
        :param since_id: Return recipes with IDs lower than this value
        :type since_id: int
        :param stopped_after: Exclude recipes stopped after this date (ISO 8601 format)
        :type stopped_after: datetime
        :param stop_cause: Filter by stop reason
        :type stop_cause: str
        :param updated_after: Include recipes updated after this date (ISO 8601 format)
        :type updated_after: datetime
        :param includes: Additional fields to include (e.g., tags)
        :type includes: List[str]
        :param exclude_code: Exclude recipe code from response for better performance
        :type exclude_code: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_recipes_serialize(
            adapter_names_all=adapter_names_all,
            adapter_names_any=adapter_names_any,
            folder_id=folder_id,
            order=order,
            page=page,
            per_page=per_page,
            running=running,
            since_id=since_id,
            stopped_after=stopped_after,
            stop_cause=stop_cause,
            updated_after=updated_after,
            includes=includes,
            exclude_code=exclude_code,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RecipeListResponse",
            '401': "Error",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def list_recipes_without_preload_content(
        self,
        adapter_names_all: Annotated[Optional[StrictStr], Field(description="Comma-separated adapter names (recipes must use ALL)")] = None,
        adapter_names_any: Annotated[Optional[StrictStr], Field(description="Comma-separated adapter names (recipes must use ANY)")] = None,
        folder_id: Annotated[Optional[StrictInt], Field(description="Return recipes in specified folder")] = None,
        order: Annotated[Optional[StrictStr], Field(description="Set ordering method")] = None,
        page: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="Page number")] = None,
        per_page: Annotated[Optional[Annotated[int, Field(le=100, strict=True, ge=1)]], Field(description="Number of recipes per page")] = None,
        running: Annotated[Optional[StrictBool], Field(description="If true, returns only running recipes")] = None,
        since_id: Annotated[Optional[StrictInt], Field(description="Return recipes with IDs lower than this value")] = None,
        stopped_after: Annotated[Optional[datetime], Field(description="Exclude recipes stopped after this date (ISO 8601 format)")] = None,
        stop_cause: Annotated[Optional[StrictStr], Field(description="Filter by stop reason")] = None,
        updated_after: Annotated[Optional[datetime], Field(description="Include recipes updated after this date (ISO 8601 format)")] = None,
        includes: Annotated[Optional[List[StrictStr]], Field(description="Additional fields to include (e.g., tags)")] = None,
        exclude_code: Annotated[Optional[StrictBool], Field(description="Exclude recipe code from response for better performance")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List recipes

        Returns a list of recipes belonging to the authenticated user. Recipes are returned in descending ID order. 

        :param adapter_names_all: Comma-separated adapter names (recipes must use ALL)
        :type adapter_names_all: str
        :param adapter_names_any: Comma-separated adapter names (recipes must use ANY)
        :type adapter_names_any: str
        :param folder_id: Return recipes in specified folder
        :type folder_id: int
        :param order: Set ordering method
        :type order: str
        :param page: Page number
        :type page: int
        :param per_page: Number of recipes per page
        :type per_page: int
        :param running: If true, returns only running recipes
        :type running: bool
        :param since_id: Return recipes with IDs lower than this value
        :type since_id: int
        :param stopped_after: Exclude recipes stopped after this date (ISO 8601 format)
        :type stopped_after: datetime
        :param stop_cause: Filter by stop reason
        :type stop_cause: str
        :param updated_after: Include recipes updated after this date (ISO 8601 format)
        :type updated_after: datetime
        :param includes: Additional fields to include (e.g., tags)
        :type includes: List[str]
        :param exclude_code: Exclude recipe code from response for better performance
        :type exclude_code: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_recipes_serialize(
            adapter_names_all=adapter_names_all,
            adapter_names_any=adapter_names_any,
            folder_id=folder_id,
            order=order,
            page=page,
            per_page=per_page,
            running=running,
            since_id=since_id,
            stopped_after=stopped_after,
            stop_cause=stop_cause,
            updated_after=updated_after,
            includes=includes,
            exclude_code=exclude_code,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RecipeListResponse",
            '401': "Error",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _list_recipes_serialize(
        self,
        adapter_names_all,
        adapter_names_any,
        folder_id,
        order,
        page,
        per_page,
        running,
        since_id,
        stopped_after,
        stop_cause,
        updated_after,
        includes,
        exclude_code,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'includes[]': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if adapter_names_all is not None:
            
            _query_params.append(('adapter_names_all', adapter_names_all))
            
        if adapter_names_any is not None:
            
            _query_params.append(('adapter_names_any', adapter_names_any))
            
        if folder_id is not None:
            
            _query_params.append(('folder_id', folder_id))
            
        if order is not None:
            
            _query_params.append(('order', order))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if per_page is not None:
            
            _query_params.append(('per_page', per_page))
            
        if running is not None:
            
            _query_params.append(('running', running))
            
        if since_id is not None:
            
            _query_params.append(('since_id', since_id))
            
        if stopped_after is not None:
            if isinstance(stopped_after, datetime):
                _query_params.append(
                    (
                        'stopped_after',
                        stopped_after.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('stopped_after', stopped_after))
            
        if stop_cause is not None:
            
            _query_params.append(('stop_cause', stop_cause))
            
        if updated_after is not None:
            if isinstance(updated_after, datetime):
                _query_params.append(
                    (
                        'updated_after',
                        updated_after.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('updated_after', updated_after))
            
        if includes is not None:
            
            _query_params.append(('includes[]', includes))
            
        if exclude_code is not None:
            
            _query_params.append(('exclude_code', exclude_code))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'BearerAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/recipes',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def start_recipe(
        self,
        recipe_id: Annotated[StrictInt, Field(description="Recipe ID")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RecipeStartResponse:
        """Start a recipe

        Starts a recipe specified by recipe ID

        :param recipe_id: Recipe ID (required)
        :type recipe_id: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._start_recipe_serialize(
            recipe_id=recipe_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RecipeStartResponse",
            '400': "Error",
            '401': "Error",
            '422': "Error",
            '500': "Error",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def start_recipe_with_http_info(
        self,
        recipe_id: Annotated[StrictInt, Field(description="Recipe ID")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[RecipeStartResponse]:
        """Start a recipe

        Starts a recipe specified by recipe ID

        :param recipe_id: Recipe ID (required)
        :type recipe_id: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._start_recipe_serialize(
            recipe_id=recipe_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RecipeStartResponse",
            '400': "Error",
            '401': "Error",
            '422': "Error",
            '500': "Error",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def start_recipe_without_preload_content(
        self,
        recipe_id: Annotated[StrictInt, Field(description="Recipe ID")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Start a recipe

        Starts a recipe specified by recipe ID

        :param recipe_id: Recipe ID (required)
        :type recipe_id: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._start_recipe_serialize(
            recipe_id=recipe_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RecipeStartResponse",
            '400': "Error",
            '401': "Error",
            '422': "Error",
            '500': "Error",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _start_recipe_serialize(
        self,
        recipe_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if recipe_id is not None:
            _path_params['recipe_id'] = recipe_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'BearerAuth'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/api/recipes/{recipe_id}/start',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def stop_recipe(
        self,
        recipe_id: Annotated[StrictInt, Field(description="Recipe ID")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> SuccessResponse:
        """Stop a recipe

        Stops a recipe specified by recipe ID

        :param recipe_id: Recipe ID (required)
        :type recipe_id: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._stop_recipe_serialize(
            recipe_id=recipe_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "SuccessResponse",
            '400': "Error",
            '401': "Error",
            '404': "Error",
            '500': "Error",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def stop_recipe_with_http_info(
        self,
        recipe_id: Annotated[StrictInt, Field(description="Recipe ID")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[SuccessResponse]:
        """Stop a recipe

        Stops a recipe specified by recipe ID

        :param recipe_id: Recipe ID (required)
        :type recipe_id: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._stop_recipe_serialize(
            recipe_id=recipe_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "SuccessResponse",
            '400': "Error",
            '401': "Error",
            '404': "Error",
            '500': "Error",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def stop_recipe_without_preload_content(
        self,
        recipe_id: Annotated[StrictInt, Field(description="Recipe ID")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Stop a recipe

        Stops a recipe specified by recipe ID

        :param recipe_id: Recipe ID (required)
        :type recipe_id: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._stop_recipe_serialize(
            recipe_id=recipe_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "SuccessResponse",
            '400': "Error",
            '401': "Error",
            '404': "Error",
            '500': "Error",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _stop_recipe_serialize(
        self,
        recipe_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if recipe_id is not None:
            _path_params['recipe_id'] = recipe_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'BearerAuth'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/api/recipes/{recipe_id}/stop',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def update_recipe_connection(
        self,
        recipe_id: Annotated[StrictInt, Field(description="ID of the recipe")],
        recipe_connection_update_request: RecipeConnectionUpdateRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> SuccessResponse:
        """Update a connection for a recipe

        Updates the chosen connection for a specific connector in a stopped recipe. 

        :param recipe_id: ID of the recipe (required)
        :type recipe_id: int
        :param recipe_connection_update_request: (required)
        :type recipe_connection_update_request: RecipeConnectionUpdateRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_recipe_connection_serialize(
            recipe_id=recipe_id,
            recipe_connection_update_request=recipe_connection_update_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "SuccessResponse",
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '404': "Error",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def update_recipe_connection_with_http_info(
        self,
        recipe_id: Annotated[StrictInt, Field(description="ID of the recipe")],
        recipe_connection_update_request: RecipeConnectionUpdateRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[SuccessResponse]:
        """Update a connection for a recipe

        Updates the chosen connection for a specific connector in a stopped recipe. 

        :param recipe_id: ID of the recipe (required)
        :type recipe_id: int
        :param recipe_connection_update_request: (required)
        :type recipe_connection_update_request: RecipeConnectionUpdateRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_recipe_connection_serialize(
            recipe_id=recipe_id,
            recipe_connection_update_request=recipe_connection_update_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "SuccessResponse",
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '404': "Error",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def update_recipe_connection_without_preload_content(
        self,
        recipe_id: Annotated[StrictInt, Field(description="ID of the recipe")],
        recipe_connection_update_request: RecipeConnectionUpdateRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Update a connection for a recipe

        Updates the chosen connection for a specific connector in a stopped recipe. 

        :param recipe_id: ID of the recipe (required)
        :type recipe_id: int
        :param recipe_connection_update_request: (required)
        :type recipe_connection_update_request: RecipeConnectionUpdateRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_recipe_connection_serialize(
            recipe_id=recipe_id,
            recipe_connection_update_request=recipe_connection_update_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "SuccessResponse",
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '404': "Error",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _update_recipe_connection_serialize(
        self,
        recipe_id,
        recipe_connection_update_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if recipe_id is not None:
            _path_params['recipe_id'] = recipe_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if recipe_connection_update_request is not None:
            _body_params = recipe_connection_update_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'BearerAuth'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/api/recipes/{recipe_id}/connect',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


