# Workato CLI Developer Documentation

## Start Here

**New to Workato CLI?** → [QUICK_START.md](QUICK_START.md) - Get running in 5 minutes

## Documentation Overview

| Document | Purpose | When to Use |
|----------|---------|-------------|
| [QUICK_START.md](QUICK_START.md) | 5-minute setup guide | First time using the CLI |
| [COMMAND_REFERENCE.md](COMMAND_REFERENCE.md) | Complete CLI documentation | Need detailed command syntax |
| [USE_CASES.md](USE_CASES.md) | Real-world examples & scenarios | Looking for implementation patterns |
| [DEVELOPER_GUIDE.md](DEVELOPER_GUIDE.md) | Installation & setup help | Having setup issues or contributing |

## Quick Navigation

### Getting Started
- [Quick Setup](QUICK_START.md#setup)
- [Prerequisites](QUICK_START.md#prerequisites)
- [Installation](QUICK_START.md#installation)

### Using the CLI
- [All Commands](COMMAND_REFERENCE.md#core-commands)
- [Recipe Management](COMMAND_REFERENCE.md#recipe-management)
- [Connection Management](COMMAND_REFERENCE.md#connection-management)
- [Project Management](COMMAND_REFERENCE.md#project-management)

### Examples & Patterns
- [Individual Developer Use Cases](USE_CASES.md#individual-developer-use-cases)
- [Team & Organization Use Cases](USE_CASES.md#team--organization-use-cases)
- [AI Agent Integration](USE_CASES.md#ai-agent--automation-use-cases)
- [Enterprise Integration](USE_CASES.md#enterprise-integration-scenarios)

### Help & Support
- [Setup & Installation Help](DEVELOPER_GUIDE.md) - Installation issues and configuration
- [Command Syntax Help](COMMAND_REFERENCE.md) - Complete CLI reference
- [Workato Documentation](https://docs.workato.com) - Platform documentation
- [Contributing](DEVELOPER_GUIDE.md#contributing-to-the-cli)

---

**Need help?** Start with [QUICK_START.md](QUICK_START.md) and refer to other guides as needed.
