/**
 *  Copyright 2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
import * as api from '@aws-cdk/aws-apigateway';
import * as iam from '@aws-cdk/aws-iam';
import { Construct } from '@aws-cdk/core';
import * as dynamodb from '@aws-cdk/aws-dynamodb';
import * as logs from '@aws-cdk/aws-logs';
/**
 * @summary The properties for the ApiGatewayToDynamoDB class.
 */
export interface ApiGatewayToDynamoDBProps {
    /**
     * Optional user provided props to override the default props.
     *
     * @default - Default props are used
     */
    readonly dynamoTableProps?: dynamodb.TableProps;
    /**
     * Existing instance of DynamoDB table object, If this is set then the dynamoTableProps is ignored.
     *
     * @default - None
     */
    readonly existingTableObj?: dynamodb.Table;
    /**
     * Optional user-provided props to override the default props for the API Gateway.
     *
     * @default - Default properties are used.
     */
    readonly apiGatewayProps?: api.RestApiProps;
    /**
     * Whether to deploy API Gateway Method for Create operation on DynamoDB table.
     *
     * @default - false
     */
    readonly allowCreateOperation?: boolean;
    /**
     * API Gateway Request template for Create method, required if allowCreateOperation set to true.
     *
     * @default - None
     */
    readonly createRequestTemplate?: string;
    /**
     * Whether to deploy API Gateway Method for Read operation on DynamoDB table.
     *
     * @default - true
     */
    readonly allowReadOperation?: boolean;
    /**
     * Whether to deploy API Gateway Method for Update operation on DynamoDB table.
     *
     * @default - false
     */
    readonly allowUpdateOperation?: boolean;
    /**
     * API Gateway Request template for Update method, required if allowUpdateOperation set to true.
     *
     * @default - None
     */
    readonly updateRequestTemplate?: string;
    /**
     * Whether to deploy API Gateway Method for Delete operation on DynamoDB table.
     *
     * @default - false
     */
    readonly allowDeleteOperation?: boolean;
    /**
     * User provided props to override the default props for the CloudWatchLogs LogGroup.
     *
     * @default - Default props are used
     */
    readonly logGroupProps?: logs.LogGroupProps;
}
/**
 * @summary The ApiGatewayToDynamoDB class.
 */
export declare class ApiGatewayToDynamoDB extends Construct {
    readonly dynamoTable: dynamodb.Table;
    readonly apiGatewayRole: iam.Role;
    readonly apiGateway: api.RestApi;
    readonly apiGatewayCloudWatchRole: iam.Role;
    readonly apiGatewayLogGroup: logs.LogGroup;
    /**
     * @param scope - represents the scope for all the resources.
     * @param id - this is a a scope-unique id.
     * @param props - user provided props for the construct.
     * @summary Constructs a new instance of the ApiGatewayToDynamoDB class.
     * @since 0.8.0
     * @access public
     */
    constructor(scope: Construct, id: string, props: ApiGatewayToDynamoDBProps);
    private addActionToPolicy;
}
