"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const sfn = require("@aws-cdk/aws-stepfunctions");
const cdk = require("@aws-cdk/core");
const tasks = require("../../lib");
let stack;
beforeEach(() => {
    // GIVEN
    stack = new cdk.Stack();
});
test('Modify an InstanceFleet with static ClusterId, InstanceFleetName, and InstanceFleetConfiguration', () => {
    // WHEN
    const task = new tasks.EmrModifyInstanceFleetByName(stack, 'Task', {
        clusterId: 'ClusterId',
        instanceFleetName: 'InstanceFleetName',
        targetOnDemandCapacity: 2,
        targetSpotCapacity: 0,
    });
    // THEN
    expect(stack.resolve(task.toStateJson())).toEqual({
        Type: 'Task',
        Resource: {
            'Fn::Join': [
                '',
                [
                    'arn:',
                    {
                        Ref: 'AWS::Partition',
                    },
                    ':states:::elasticmapreduce:modifyInstanceFleetByName',
                ],
            ],
        },
        End: true,
        Parameters: {
            ClusterId: 'ClusterId',
            InstanceFleetName: 'InstanceFleetName',
            InstanceFleet: {
                TargetOnDemandCapacity: 2,
                TargetSpotCapacity: 0,
            },
        },
    });
});
test('Modify an InstanceFleet with ClusterId from payload and static InstanceFleetName and InstanceFleetConfiguration', () => {
    // WHEN
    const task = new tasks.EmrModifyInstanceFleetByName(stack, 'Task', {
        clusterId: sfn.JsonPath.stringAt('$.ClusterId'),
        instanceFleetName: 'InstanceFleetName',
        targetOnDemandCapacity: 2,
        targetSpotCapacity: 0,
    });
    // THEN
    expect(stack.resolve(task.toStateJson())).toEqual({
        Type: 'Task',
        Resource: {
            'Fn::Join': [
                '',
                [
                    'arn:',
                    {
                        Ref: 'AWS::Partition',
                    },
                    ':states:::elasticmapreduce:modifyInstanceFleetByName',
                ],
            ],
        },
        End: true,
        Parameters: {
            'ClusterId.$': '$.ClusterId',
            'InstanceFleetName': 'InstanceFleetName',
            'InstanceFleet': {
                TargetOnDemandCapacity: 2,
                TargetSpotCapacity: 0,
            },
        },
    });
});
test('Modify an InstanceFleet with static ClusterId and InstanceFleetConfigurateion and InstanceFleetName from payload', () => {
    // WHEN
    const task = new tasks.EmrModifyInstanceFleetByName(stack, 'Task', {
        clusterId: 'ClusterId',
        instanceFleetName: sfn.JsonPath.stringAt('$.InstanceFleetName'),
        targetOnDemandCapacity: 2,
        targetSpotCapacity: 0,
    });
    // THEN
    expect(stack.resolve(task.toStateJson())).toEqual({
        Type: 'Task',
        Resource: {
            'Fn::Join': [
                '',
                [
                    'arn:',
                    {
                        Ref: 'AWS::Partition',
                    },
                    ':states:::elasticmapreduce:modifyInstanceFleetByName',
                ],
            ],
        },
        End: true,
        Parameters: {
            'ClusterId': 'ClusterId',
            'InstanceFleetName.$': '$.InstanceFleetName',
            'InstanceFleet': {
                TargetOnDemandCapacity: 2,
                TargetSpotCapacity: 0,
            },
        },
    });
});
test('Modify an InstanceFleet with static ClusterId and InstanceFleetName and Target Capacities from payload', () => {
    // WHEN
    const task = new tasks.EmrModifyInstanceFleetByName(stack, 'Task', {
        clusterId: 'ClusterId',
        instanceFleetName: 'InstanceFleetName',
        targetOnDemandCapacity: sfn.JsonPath.numberAt('$.TargetOnDemandCapacity'),
        targetSpotCapacity: sfn.JsonPath.numberAt('$.TargetSpotCapacity'),
    });
    // THEN
    expect(stack.resolve(task.toStateJson())).toEqual({
        Type: 'Task',
        Resource: {
            'Fn::Join': [
                '',
                [
                    'arn:',
                    {
                        Ref: 'AWS::Partition',
                    },
                    ':states:::elasticmapreduce:modifyInstanceFleetByName',
                ],
            ],
        },
        End: true,
        Parameters: {
            ClusterId: 'ClusterId',
            InstanceFleetName: 'InstanceFleetName',
            InstanceFleet: {
                'TargetOnDemandCapacity.$': '$.TargetOnDemandCapacity',
                'TargetSpotCapacity.$': '$.TargetSpotCapacity',
            },
        },
    });
});
//# sourceMappingURL=data:application/json;base64,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