"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EmrModifyInstanceGroupByName = void 0;
const iam = require("@aws-cdk/aws-iam");
const sfn = require("@aws-cdk/aws-stepfunctions");
const cdk = require("@aws-cdk/core");
const task_utils_1 = require("../private/task-utils");
const cluster_utils_1 = require("./private/cluster-utils");
/**
 * A Step Functions Task to to modify an InstanceGroup on an EMR Cluster.
 *
 * @experimental
 */
class EmrModifyInstanceGroupByName extends sfn.TaskStateBase {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.props = props;
        this.taskPolicies = [
            new iam.PolicyStatement({
                actions: ['elasticmapreduce:ModifyInstanceGroups', 'elasticmapreduce:ListInstanceGroups'],
                resources: [`arn:aws:elasticmapreduce:${cdk.Aws.REGION}:${cdk.Aws.ACCOUNT_ID}:cluster/*`],
            }),
        ];
    }
    /**
     * @internal
     */
    _renderTask() {
        return {
            Resource: task_utils_1.integrationResourceArn('elasticmapreduce', 'modifyInstanceGroupByName', sfn.IntegrationPattern.REQUEST_RESPONSE),
            Parameters: sfn.FieldUtils.renderObject({
                ClusterId: this.props.clusterId,
                InstanceGroupName: this.props.instanceGroupName,
                InstanceGroup: cluster_utils_1.InstanceGroupModifyConfigPropertyToJson(this.props.instanceGroup),
            }),
        };
    }
}
exports.EmrModifyInstanceGroupByName = EmrModifyInstanceGroupByName;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZW1yLW1vZGlmeS1pbnN0YW5jZS1ncm91cC1ieS1uYW1lLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiZW1yLW1vZGlmeS1pbnN0YW5jZS1ncm91cC1ieS1uYW1lLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBLHdDQUF3QztBQUN4QyxrREFBa0Q7QUFDbEQscUNBQXFDO0FBQ3JDLHNEQUErRDtBQUUvRCwyREFBa0Y7QUE0QmxGOzs7O0dBSUc7QUFDSCxNQUFhLDRCQUE2QixTQUFRLEdBQUcsQ0FBQyxhQUFhO0lBSWpFLFlBQVksS0FBb0IsRUFBRSxFQUFVLEVBQW1CLEtBQXdDO1FBQ3JHLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFLEtBQUssQ0FBQyxDQUFDO1FBRHFDLFVBQUssR0FBTCxLQUFLLENBQW1DO1FBRXJHLElBQUksQ0FBQyxZQUFZLEdBQUc7WUFDbEIsSUFBSSxHQUFHLENBQUMsZUFBZSxDQUFDO2dCQUN0QixPQUFPLEVBQUUsQ0FBQyx1Q0FBdUMsRUFBRSxxQ0FBcUMsQ0FBQztnQkFDekYsU0FBUyxFQUFFLENBQUMsNEJBQTRCLEdBQUcsQ0FBQyxHQUFHLENBQUMsTUFBTSxJQUFJLEdBQUcsQ0FBQyxHQUFHLENBQUMsVUFBVSxZQUFZLENBQUM7YUFDMUYsQ0FBQztTQUNILENBQUM7SUFDSixDQUFDO0lBRUQ7O09BRUc7SUFDTyxXQUFXO1FBQ25CLE9BQU87WUFDTCxRQUFRLEVBQUUsbUNBQXNCLENBQUMsa0JBQWtCLEVBQUUsMkJBQTJCLEVBQUUsR0FBRyxDQUFDLGtCQUFrQixDQUFDLGdCQUFnQixDQUFDO1lBQzFILFVBQVUsRUFBRSxHQUFHLENBQUMsVUFBVSxDQUFDLFlBQVksQ0FBQztnQkFDdEMsU0FBUyxFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsU0FBUztnQkFDL0IsaUJBQWlCLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxpQkFBaUI7Z0JBQy9DLGFBQWEsRUFBRSx1REFBdUMsQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLGFBQWEsQ0FBQzthQUNqRixDQUFDO1NBQ0gsQ0FBQztJQUNKLENBQUM7Q0FDRjtBQTNCRCxvRUEyQkMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBpYW0gZnJvbSAnQGF3cy1jZGsvYXdzLWlhbSc7XG5pbXBvcnQgKiBhcyBzZm4gZnJvbSAnQGF3cy1jZGsvYXdzLXN0ZXBmdW5jdGlvbnMnO1xuaW1wb3J0ICogYXMgY2RrIGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuaW1wb3J0IHsgaW50ZWdyYXRpb25SZXNvdXJjZUFybiB9IGZyb20gJy4uL3ByaXZhdGUvdGFzay11dGlscyc7XG5pbXBvcnQgeyBFbXJDcmVhdGVDbHVzdGVyIH0gZnJvbSAnLi9lbXItY3JlYXRlLWNsdXN0ZXInO1xuaW1wb3J0IHsgSW5zdGFuY2VHcm91cE1vZGlmeUNvbmZpZ1Byb3BlcnR5VG9Kc29uIH0gZnJvbSAnLi9wcml2YXRlL2NsdXN0ZXItdXRpbHMnO1xuXG4vKipcbiAqIFByb3BlcnRpZXMgZm9yIEVtck1vZGlmeUluc3RhbmNlR3JvdXBCeU5hbWVcbiAqXG4gKiBAZXhwZXJpbWVudGFsXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgRW1yTW9kaWZ5SW5zdGFuY2VHcm91cEJ5TmFtZVByb3BzIGV4dGVuZHMgc2ZuLlRhc2tTdGF0ZUJhc2VQcm9wcyB7XG4gIC8qKlxuICAgKiBUaGUgQ2x1c3RlcklkIHRvIHVwZGF0ZS5cbiAgICovXG4gIHJlYWRvbmx5IGNsdXN0ZXJJZDogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBUaGUgSW5zdGFuY2VHcm91cE5hbWUgdG8gdXBkYXRlLlxuICAgKi9cbiAgcmVhZG9ubHkgaW5zdGFuY2VHcm91cE5hbWU6IHN0cmluZztcblxuICAvKipcbiAgICogVGhlIEpTT04gdGhhdCB5b3Ugd2FudCB0byBwcm92aWRlIHRvIHlvdXIgTW9kaWZ5SW5zdGFuY2VHcm91cCBjYWxsIGFzIGlucHV0LlxuICAgKlxuICAgKiBUaGlzIHVzZXMgdGhlIHNhbWUgc3ludGF4IGFzIHRoZSBNb2RpZnlJbnN0YW5jZUdyb3VwcyBBUEkuXG4gICAqXG4gICAqIEBzZWUgaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2Vtci9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9Nb2RpZnlJbnN0YW5jZUdyb3Vwcy5odG1sXG4gICAqL1xuICByZWFkb25seSBpbnN0YW5jZUdyb3VwOiBFbXJNb2RpZnlJbnN0YW5jZUdyb3VwQnlOYW1lLkluc3RhbmNlR3JvdXBNb2RpZnlDb25maWdQcm9wZXJ0eTtcbn1cblxuLyoqXG4gKiBBIFN0ZXAgRnVuY3Rpb25zIFRhc2sgdG8gdG8gbW9kaWZ5IGFuIEluc3RhbmNlR3JvdXAgb24gYW4gRU1SIENsdXN0ZXIuXG4gKlxuICogQGV4cGVyaW1lbnRhbFxuICovXG5leHBvcnQgY2xhc3MgRW1yTW9kaWZ5SW5zdGFuY2VHcm91cEJ5TmFtZSBleHRlbmRzIHNmbi5UYXNrU3RhdGVCYXNlIHtcbiAgcHJvdGVjdGVkIHJlYWRvbmx5IHRhc2tQb2xpY2llcz86IGlhbS5Qb2xpY3lTdGF0ZW1lbnRbXTtcbiAgcHJvdGVjdGVkIHJlYWRvbmx5IHRhc2tNZXRyaWNzPzogc2ZuLlRhc2tNZXRyaWNzQ29uZmlnO1xuXG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBjZGsuQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcml2YXRlIHJlYWRvbmx5IHByb3BzOiBFbXJNb2RpZnlJbnN0YW5jZUdyb3VwQnlOYW1lUHJvcHMpIHtcbiAgICBzdXBlcihzY29wZSwgaWQsIHByb3BzKTtcbiAgICB0aGlzLnRhc2tQb2xpY2llcyA9IFtcbiAgICAgIG5ldyBpYW0uUG9saWN5U3RhdGVtZW50KHtcbiAgICAgICAgYWN0aW9uczogWydlbGFzdGljbWFwcmVkdWNlOk1vZGlmeUluc3RhbmNlR3JvdXBzJywgJ2VsYXN0aWNtYXByZWR1Y2U6TGlzdEluc3RhbmNlR3JvdXBzJ10sXG4gICAgICAgIHJlc291cmNlczogW2Bhcm46YXdzOmVsYXN0aWNtYXByZWR1Y2U6JHtjZGsuQXdzLlJFR0lPTn06JHtjZGsuQXdzLkFDQ09VTlRfSUR9OmNsdXN0ZXIvKmBdLFxuICAgICAgfSksXG4gICAgXTtcbiAgfVxuXG4gIC8qKlxuICAgKiBAaW50ZXJuYWxcbiAgICovXG4gIHByb3RlY3RlZCBfcmVuZGVyVGFzaygpOiBhbnkge1xuICAgIHJldHVybiB7XG4gICAgICBSZXNvdXJjZTogaW50ZWdyYXRpb25SZXNvdXJjZUFybignZWxhc3RpY21hcHJlZHVjZScsICdtb2RpZnlJbnN0YW5jZUdyb3VwQnlOYW1lJywgc2ZuLkludGVncmF0aW9uUGF0dGVybi5SRVFVRVNUX1JFU1BPTlNFKSxcbiAgICAgIFBhcmFtZXRlcnM6IHNmbi5GaWVsZFV0aWxzLnJlbmRlck9iamVjdCh7XG4gICAgICAgIENsdXN0ZXJJZDogdGhpcy5wcm9wcy5jbHVzdGVySWQsXG4gICAgICAgIEluc3RhbmNlR3JvdXBOYW1lOiB0aGlzLnByb3BzLmluc3RhbmNlR3JvdXBOYW1lLFxuICAgICAgICBJbnN0YW5jZUdyb3VwOiBJbnN0YW5jZUdyb3VwTW9kaWZ5Q29uZmlnUHJvcGVydHlUb0pzb24odGhpcy5wcm9wcy5pbnN0YW5jZUdyb3VwKSxcbiAgICAgIH0pLFxuICAgIH07XG4gIH1cbn1cblxuZXhwb3J0IG5hbWVzcGFjZSBFbXJNb2RpZnlJbnN0YW5jZUdyb3VwQnlOYW1lIHtcbiAgLyoqXG4gICAqIEN1c3RvbSBwb2xpY3kgZm9yIHJlcXVlc3RpbmcgdGVybWluYXRpb24gcHJvdGVjdGlvbiBvciB0ZXJtaW5hdGlvbiBvZiBzcGVjaWZpYyBpbnN0YW5jZXMgd2hlbiBzaHJpbmtpbmcgYW4gaW5zdGFuY2UgZ3JvdXAuXG4gICAqXG4gICAqIEBzZWUgaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2Vtci9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9JbnN0YW5jZVJlc2l6ZVBvbGljeS5odG1sXG4gICAqXG4gICAqIEBleHBlcmltZW50YWxcbiAgICovXG4gIGV4cG9ydCBpbnRlcmZhY2UgSW5zdGFuY2VSZXNpemVQb2xpY3lQcm9wZXJ0eSB7XG4gICAgLyoqXG4gICAgICogU3BlY2lmaWMgbGlzdCBvZiBpbnN0YW5jZXMgdG8gYmUgcHJvdGVjdGVkIHdoZW4gc2hyaW5raW5nIGFuIGluc3RhbmNlIGdyb3VwLlxuICAgICAqXG4gICAgICogQGRlZmF1bHQgLSBObyBpbnN0YW5jZXMgd2lsbCBiZSBwcm90ZWN0ZWQgd2hlbiBzaHJpbmtpbmcgYW4gaW5zdGFuY2UgZ3JvdXBcbiAgICAgKi9cbiAgICByZWFkb25seSBpbnN0YW5jZXNUb1Byb3RlY3Q/OiBzdHJpbmdbXTtcblxuICAgIC8qKlxuICAgICAqIFNwZWNpZmljIGxpc3Qgb2YgaW5zdGFuY2VzIHRvIGJlIHRlcm1pbmF0ZWQgd2hlbiBzaHJpbmtpbmcgYW4gaW5zdGFuY2UgZ3JvdXAuXG4gICAgICpcbiAgICAgKiBAZGVmYXVsdCAtIE5vIGluc3RhbmNlcyB3aWxsIGJlIHRlcm1pbmF0ZWQgd2hlbiBzaHJpbmtpbmcgYW4gaW5zdGFuY2UgZ3JvdXAuXG4gICAgICovXG4gICAgcmVhZG9ubHkgaW5zdGFuY2VzVG9UZXJtaW5hdGU/OiBzdHJpbmdbXTtcblxuICAgIC8qKlxuICAgICAqIERlY29tbWlzc2lvbmluZyB0aW1lb3V0IG92ZXJyaWRlIGZvciB0aGUgc3BlY2lmaWMgbGlzdCBvZiBpbnN0YW5jZXMgdG8gYmUgdGVybWluYXRlZC5cbiAgICAgKlxuICAgICAqIEBkZWZhdWx0IGNkay5EdXJhdGlvbi5zZWNvbmRzXG4gICAgICovXG4gICAgcmVhZG9ubHkgaW5zdGFuY2VUZXJtaW5hdGlvblRpbWVvdXQ/OiBjZGsuRHVyYXRpb247XG4gIH1cblxuICAvKipcbiAgICogUG9saWN5IGZvciBjdXN0b21pemluZyBzaHJpbmsgb3BlcmF0aW9ucy4gQWxsb3dzIGNvbmZpZ3VyYXRpb24gb2YgZGVjb21taXNzaW9uaW5nIHRpbWVvdXQgYW5kIHRhcmdldGVkIGluc3RhbmNlIHNocmlua2luZy5cbiAgICpcbiAgICogQHNlZSBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vZW1yL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX1Nocmlua1BvbGljeS5odG1sXG4gICAqXG4gICAqIEBleHBlcmltZW50YWxcbiAgICovXG4gIGV4cG9ydCBpbnRlcmZhY2UgU2hyaW5rUG9saWN5UHJvcGVydHkge1xuICAgIC8qKlxuICAgICAqIFRoZSBkZXNpcmVkIHRpbWVvdXQgZm9yIGRlY29tbWlzc2lvbmluZyBhbiBpbnN0YW5jZS4gT3ZlcnJpZGVzIHRoZSBkZWZhdWx0IFlBUk4gZGVjb21taXNzaW9uaW5nIHRpbWVvdXQuXG4gICAgICpcbiAgICAgKiBAZGVmYXVsdCAtIEVNUiBzZWxlY3RlZCBkZWZhdWx0XG4gICAgICovXG4gICAgcmVhZG9ubHkgZGVjb21taXNzaW9uVGltZW91dD86IGNkay5EdXJhdGlvbjtcblxuICAgIC8qKlxuICAgICAqIEN1c3RvbSBwb2xpY3kgZm9yIHJlcXVlc3RpbmcgdGVybWluYXRpb24gcHJvdGVjdGlvbiBvciB0ZXJtaW5hdGlvbiBvZiBzcGVjaWZpYyBpbnN0YW5jZXMgd2hlbiBzaHJpbmtpbmcgYW4gaW5zdGFuY2UgZ3JvdXAuXG4gICAgICpcbiAgICAgKiBAZGVmYXVsdCAtIE5vbmVcbiAgICAgKi9cbiAgICByZWFkb25seSBpbnN0YW5jZVJlc2l6ZVBvbGljeT86IEluc3RhbmNlUmVzaXplUG9saWN5UHJvcGVydHk7XG4gIH1cblxuICAvKipcbiAgICogTW9kaWZ5IHRoZSBzaXplIG9yIGNvbmZpZ3VyYXRpb25zIG9mIGFuIGluc3RhbmNlIGdyb3VwLlxuICAgKlxuICAgKiBAc2VlIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9lbXIvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfSW5zdGFuY2VHcm91cE1vZGlmeUNvbmZpZy5odG1sXG4gICAqXG4gICAqIEBleHBlcmltZW50YWxcbiAgICovXG4gIGV4cG9ydCBpbnRlcmZhY2UgSW5zdGFuY2VHcm91cE1vZGlmeUNvbmZpZ1Byb3BlcnR5IHtcbiAgICAvKipcbiAgICAgKiBBIGxpc3Qgb2YgbmV3IG9yIG1vZGlmaWVkIGNvbmZpZ3VyYXRpb25zIHRvIGFwcGx5IGZvciBhbiBpbnN0YW5jZSBncm91cC5cbiAgICAgKlxuICAgICAqIEBkZWZhdWx0IC0gTm9uZVxuICAgICAqL1xuICAgIHJlYWRvbmx5IGNvbmZpZ3VyYXRpb25zPzogRW1yQ3JlYXRlQ2x1c3Rlci5Db25maWd1cmF0aW9uUHJvcGVydHlbXTtcblxuICAgIC8qKlxuICAgICAqIFRoZSBFQzIgSW5zdGFuY2VJZHMgdG8gdGVybWluYXRlLiBBZnRlciB5b3UgdGVybWluYXRlIHRoZSBpbnN0YW5jZXMsIHRoZSBpbnN0YW5jZSBncm91cCB3aWxsIG5vdCByZXR1cm4gdG8gaXRzIG9yaWdpbmFsIHJlcXVlc3RlZCBzaXplLlxuICAgICAqXG4gICAgICogQGRlZmF1bHQgLSBOb25lXG4gICAgICovXG4gICAgcmVhZG9ubHkgZUMySW5zdGFuY2VJZHNUb1Rlcm1pbmF0ZT86IHN0cmluZ1tdO1xuXG4gICAgLyoqXG4gICAgICogVGFyZ2V0IHNpemUgZm9yIHRoZSBpbnN0YW5jZSBncm91cC5cbiAgICAgKlxuICAgICAqIEBkZWZhdWx0IC0gTm9uZVxuICAgICAqL1xuICAgIHJlYWRvbmx5IGluc3RhbmNlQ291bnQ/OiBudW1iZXI7XG5cbiAgICAvKipcbiAgICAgKiBQb2xpY3kgZm9yIGN1c3RvbWl6aW5nIHNocmluayBvcGVyYXRpb25zLlxuICAgICAqXG4gICAgICogQHNlZSBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vZW1yL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX1Nocmlua1BvbGljeS5odG1sXG4gICAgICpcbiAgICAgKiBAZGVmYXVsdCAtIE5vbmVcbiAgICAgKi9cbiAgICByZWFkb25seSBzaHJpbmtQb2xpY3k/OiBTaHJpbmtQb2xpY3lQcm9wZXJ0eTtcbiAgfVxufVxuIl19