# Generated by Django 5.2.4 on 2025-07-24 12:47

import django.contrib.postgres.indexes
import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        ("contenttypes", "0002_remove_content_type_name"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="DisabledNotificationTypeChannel",
            fields=[
                ("id", models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("notification_type", models.CharField(max_length=50)),
                ("channel", models.CharField(max_length=20)),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="disabled_notification_type_channels",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "unique_together": {("user", "notification_type", "channel")},
            },
        ),
        migrations.CreateModel(
            name="EmailFrequency",
            fields=[
                ("id", models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("notification_type", models.CharField(max_length=50)),
                ("frequency", models.CharField(max_length=20)),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="email_frequencies",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "unique_together": {("user", "notification_type")},
            },
        ),
        migrations.CreateModel(
            name="Notification",
            fields=[
                ("id", models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("notification_type", models.CharField(max_length=50)),
                ("added", models.DateTimeField(auto_now_add=True)),
                ("read", models.DateTimeField(blank=True, null=True)),
                ("subject", models.CharField(blank=True, max_length=255)),
                ("text", models.TextField(blank=True)),
                ("url", models.CharField(blank=True, max_length=500)),
                ("object_id", models.PositiveIntegerField(blank=True, null=True)),
                ("email_sent_at", models.DateTimeField(blank=True, null=True)),
                ("channels", models.JSONField(blank=True, default=list)),
                ("metadata", models.JSONField(blank=True, default=dict)),
                (
                    "actor",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="notifications_sent",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "content_type",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="contenttypes.contenttype",
                    ),
                ),
                (
                    "recipient",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="notifications",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "ordering": ["-added"],
                "indexes": [
                    django.contrib.postgres.indexes.GinIndex(fields=["channels"], name="notification_channels_gin"),
                    models.Index(fields=["recipient", "read", "channels"], name="notification_unread_channel"),
                    models.Index(fields=["recipient", "channels"], name="notification_recipient_channel"),
                    models.Index(
                        fields=["recipient", "email_sent_at", "read", "channels"], name="notification_user_email_digest"
                    ),
                ],
            },
        ),
    ]
