# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.


class BillVo(object):

    def __init__(self, sourceId, startTime, endTime, region, appCode, serviceCode, resourceId, billingType, billFee, actualFee, billTime, payState, currency=None, payTime=None, discountFee=None, eraseFee=None, balancePayFee=None, cashPayFee=None, cashCouponFee=None, freeCashCouponFee=None, payCashCouponFee=None, consumeTime=None, transactionNo=None, refundNo=None, site=None, org=None, tradeType=None, billType=None, formulaDesc=None, isDeleted=None, favorableInfo=None, az=None, couponList=None, billItemList=None):
        """
        :param sourceId:  账单唯一ID，不可重复，更新时根据该ID进行
        :param startTime:  开始时间(格式为：yyyy-MM-dd HH:mm:ss)
        :param endTime:  结束时间(格式为：yyyy-MM-dd HH:mm:ss)
        :param region:  地域，如cn-north-1 ，不可修改
        :param appCode:  业务线，不可修改
        :param serviceCode:  产品编码，不可修改
        :param resourceId:  资源id，资源唯一标识，不可修改
        :param billingType:  计费类型： 1、按配置 2、按用量 3、包年包月 4、按次（一次性），不可修改
        :param billFee:  账单原价,6位精度
        :param actualFee:  应付金额，2位精度
        :param billTime:  账期，不可修改(推送多条账单时，不可跨月,只允许同一个自然月份的账单,格式：yyyy-MM-dd HH:mm:ss)
        :param currency: (Optional) 币种 CNY 人民币， USD 美元， HKD 港元， IDR 印尼卢比
        :param payState:  支付状态 0、未支付 1、己支付
        :param payTime: (Optional) 支付时间，已支付状态必须传支付时间
        :param discountFee: (Optional) 折扣金额，6位精度
        :param eraseFee: (Optional) 抹零金额，6位精度
        :param balancePayFee: (Optional) 余额支付金额：2位精度
        :param cashPayFee: (Optional) 现金支付金额：2位精度
        :param cashCouponFee: (Optional) 代金券支付金额，2位精度，代金券支付金额=免费代金券金额+付费代金券金额
        :param freeCashCouponFee: (Optional) 免费代金券金额，2位精度
        :param payCashCouponFee: (Optional) 付费代金券金额，2位精度
        :param consumeTime: (Optional) 消费时间
        :param transactionNo: (Optional) 交易单号
        :param refundNo: (Optional) 退款单号,如为退款账单，需要传退款单号
        :param site: (Optional) 站点，0:国内，不可修改
        :param org: (Optional) 组织机构代码
        :param tradeType: (Optional) 交易类型 1、使用 2、 新购 3、续费 4、配置变更 5、退款，不可修改
        :param billType: (Optional) 账单类型 0-普通账单 1-退款账单 2-调账账单 3-保底账单，不可修改
        :param formulaDesc: (Optional) 配置描述，用于控制台账单详情中展示
        :param isDeleted: (Optional) 是否删除 0:未删除 1:己删除
        :param favorableInfo: (Optional) 优惠明细
        :param az: (Optional) 可用区
        :param couponList: (Optional) 支付所使用的代金券列表
        :param billItemList: (Optional) 计费项明细账单列表
        """

        self.sourceId = sourceId
        self.startTime = startTime
        self.endTime = endTime
        self.region = region
        self.appCode = appCode
        self.serviceCode = serviceCode
        self.resourceId = resourceId
        self.billingType = billingType
        self.billFee = billFee
        self.actualFee = actualFee
        self.billTime = billTime
        self.currency = currency
        self.payState = payState
        self.payTime = payTime
        self.discountFee = discountFee
        self.eraseFee = eraseFee
        self.balancePayFee = balancePayFee
        self.cashPayFee = cashPayFee
        self.cashCouponFee = cashCouponFee
        self.freeCashCouponFee = freeCashCouponFee
        self.payCashCouponFee = payCashCouponFee
        self.consumeTime = consumeTime
        self.transactionNo = transactionNo
        self.refundNo = refundNo
        self.site = site
        self.org = org
        self.tradeType = tradeType
        self.billType = billType
        self.formulaDesc = formulaDesc
        self.isDeleted = isDeleted
        self.favorableInfo = favorableInfo
        self.az = az
        self.couponList = couponList
        self.billItemList = billItemList
