from . import extras
from .client import Client
from .lemur import Lemur
from .transcriber import RealtimeTranscriber, Transcriber, Transcript, TranscriptGroup
from .types import (
    AssemblyAIError,
    AutohighlightResponse,
    AutohighlightResult,
    Chapter,
    ContentSafetyLabel,
    ContentSafetyLabelResult,
    ContentSafetyResponse,
    ContentSafetySeverityScore,
    Entity,
    EntityType,
    IABLabelResult,
    IABResponse,
    IABResult,
    LanguageCode,
    LemurError,
    LemurModel,
    LemurQuestion,
    LemurQuestionAnswer,
    LemurQuestionResponse,
    LemurSource,
    LemurSourceType,
    LemurSummaryResponse,
    LemurTaskResponse,
    LemurTranscriptSource,
    Paragraph,
    PIIRedactionPolicy,
    PIISubstitutionPolicy,
    RawTranscriptionConfig,
    RealtimeError,
    RealtimeFinalTranscript,
    RealtimePartialTranscript,
    RealtimeSessionOpened,
    RealtimeTranscript,
    RealtimeWord,
    Sentence,
    Sentiment,
    SentimentType,
    Settings,
    StatusResult,
    SummarizationModel,
    SummarizationType,
    Timestamp,
    TranscriptError,
    TranscriptionConfig,
    TranscriptStatus,
    Utterance,
    UtteranceWord,
    Word,
    WordBoost,
    WordSearchMatch,
)

settings = Settings()
"""Global settings object that applies to all classes that use the `Client` class."""


__all__ = [
    # types
    "AssemblyAIError",
    "AutohighlightResponse",
    "AutohighlightResult",
    "Chapter",
    "Client",
    "ContentSafetyLabel",
    "ContentSafetyLabelResult",
    "ContentSafetyResponse",
    "ContentSafetySeverityScore",
    "Entity",
    "EntityType",
    "IABLabelResult",
    "IABResponse",
    "IABResult",
    "LanguageCode",
    "Lemur",
    "LemurError",
    "LemurModel",
    "LemurSource",
    "LemurSourceType",
    "LemurTranscriptSource",
    "LemurQuestion",
    "LemurQuestionAnswer",
    "LemurQuestionResponse",
    "LemurSummaryResponse",
    "LemurTaskResponse",
    "PIIRedactionPolicy",
    "PIISubstitutionPolicy",
    "Sentence",
    "Sentiment",
    "SentimentType",
    "Settings",
    "StatusResult",
    "SummarizationModel",
    "SummarizationType",
    "Timestamp",
    "Transcriber",
    "TranscriptionConfig",
    "Transcript",
    "TranscriptError",
    "TranscriptGroup",
    "TranscriptStatus",
    "Utterance",
    "UtteranceWord",
    "Paragraph",
    "PIISubstitutionPolicy",
    "PIIRedactionPolicy",
    "RawTranscriptionConfig",
    "Word",
    "WordBoost",
    "WordSearchMatch",
    "RealtimeTranscriber",
    "RealtimeError",
    "RealtimeFinalTranscript",
    "RealtimePartialTranscript",
    "RealtimeSessionOpened",
    "RealtimeTranscript",
    "RealtimeWord",
    # package globals
    "settings",
    # packages
    "extras",
]
