# DjStripePaymentIntent


## Properties
Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**djstripe_id** | **int** |  | [readonly] 
**charges** | [**list[DjStripeCharge]**](DjStripeCharge.md) |  | [readonly] 
**djstripe_created** | **datetime** |  | [readonly] 
**djstripe_updated** | **datetime** |  | [readonly] 
**id** | **str** |  | 
**livemode** | **bool** | Null here indicates that the livemode status is unknown or was previously unrecorded. Otherwise, this field indicates whether this record comes from Stripe test mode or live mode operation. | [optional] 
**created** | **datetime** | The datetime this object was created in stripe. | [optional] 
**metadata** | **dict(str, object)** | A set of key/value pairs that you can attach to an object. It can be useful for storing additional information about an object in a structured format. | [optional] 
**amount** | **int** | Amount (in cents) intended to be collected by this PaymentIntent. | 
**amount_capturable** | **int** | Amount (in cents) that can be captured from this PaymentIntent. | 
**amount_received** | **int** | Amount (in cents) that was collected by this PaymentIntent. | 
**canceled_at** | **datetime** | Populated when status is canceled, this is the time at which the PaymentIntent was canceled. Measured in seconds since the Unix epoch. | [optional] 
**cancellation_reason** | [**OneOfCancellationReasonEnumBlankEnum**](OneOfCancellationReasonEnumBlankEnum.md) | Reason for cancellation of this PaymentIntent, either user-provided (duplicate, fraudulent, requested_by_customer, or abandoned) or generated by Stripe internally (failed_invoice, void_invoice, or automatic). | [optional] 
**capture_method** | [**CaptureMethodEnum**](CaptureMethodEnum.md) | Capture method of this PaymentIntent, one of automatic or manual. | 
**client_secret** | **str** | The client secret of this PaymentIntent. Used for client-side retrieval using a publishable key. | 
**confirmation_method** | [**ConfirmationMethodEnum**](ConfirmationMethodEnum.md) | Confirmation method of this PaymentIntent, one of manual or automatic. | 
**currency** | **str** | Three-letter ISO currency code | 
**description** | **str** | An arbitrary string attached to the object. Often useful for displaying to users. | [optional] 
**last_payment_error** | **dict(str, object)** | The payment error encountered in the previous PaymentIntent confirmation. | [optional] 
**next_action** | **dict(str, object)** | If present, this property tells you what actions you need to take in order for your customer to fulfill a payment using the provided source. | [optional] 
**payment_method_types** | **dict(str, object)** | The list of payment method types (e.g. card) that this PaymentIntent is allowed to use. | 
**receipt_email** | **str** | Email address that the receipt for the resulting payment will be sent to. | [optional] 
**setup_future_usage** | [**OneOfSetupFutureUsageEnumBlankEnumNullEnum**](OneOfSetupFutureUsageEnumBlankEnumNullEnum.md) | Indicates that you intend to make future payments with this PaymentIntent&#39;s payment method. If present, the payment method used with this PaymentIntent can be attached to a Customer, even after the transaction completes. Use &#x60;on_session&#x60; if you intend to only reuse the payment method when your customer is present in your checkout flow. Use &#x60;off_session&#x60; if your customer may or may not be in your checkout flow. Stripe uses &#x60;setup_future_usage&#x60; to dynamically optimize your payment flow and comply with regional legislation and network rules. For example, if your customer is impacted by SCA, using &#x60;off_session&#x60; will ensure that they are authenticated while processing this PaymentIntent. You will then be able to make later off-session payments for this customer. | [optional] 
**shipping** | **dict(str, object)** | Shipping information for this PaymentIntent. | [optional] 
**statement_descriptor** | **str** | For non-card charges, you can use this value as the complete description that appears on your customers&#39; statements. Must contain at least one letter, maximum 22 characters. | [optional] 
**status** | [**DjStripePaymentIntentStatusEnum**](DjStripePaymentIntentStatusEnum.md) | Status of this PaymentIntent, one of requires_payment_method, requires_confirmation, requires_action, processing, requires_capture, canceled, or succeeded. You can read more about PaymentIntent statuses here. | 
**transfer_data** | **dict(str, object)** | The data with which to automatically create a Transfer when the payment is finalized. See the PaymentIntents Connect usage guide for details. | [optional] 
**transfer_group** | **str** | A string that identifies the resulting payment as part of a group. See the PaymentIntents Connect usage guide for details. | [optional] 
**djstripe_owner_account** | **str** | The Stripe Account this object belongs to. | [optional] 
**customer** | **str** | Customer this PaymentIntent is for if one exists. | [optional] 
**on_behalf_of** | **str** | The account (if any) for which the funds of the PaymentIntent are intended. | [optional] 
**payment_method** | **str** | Payment method used in this PaymentIntent. | [optional] 

[[Back to Model list]](../README.md#documentation-for-models) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to README]](../README.md)


