import * as iam from '@aws-cdk/aws-iam';
import * as sfn from '@aws-cdk/aws-stepfunctions';
import { Construct } from 'constructs';
/**
 * Properties for EmrModifyInstanceFleetByName.
 *
 * @stability stable
 */
export interface EmrModifyInstanceFleetByNameProps extends sfn.TaskStateBaseProps {
    /**
     * The ClusterId to update.
     *
     * @stability stable
     */
    readonly clusterId: string;
    /**
     * The InstanceFleetName to update.
     *
     * @stability stable
     */
    readonly instanceFleetName: string;
    /**
     * The target capacity of On-Demand units for the instance fleet.
     *
     * @default - None
     * @see https://docs.aws.amazon.com/emr/latest/APIReference/API_InstanceFleetModifyConfig.html
     * @stability stable
     */
    readonly targetOnDemandCapacity: number;
    /**
     * The target capacity of Spot units for the instance fleet.
     *
     * @default - None
     * @see https://docs.aws.amazon.com/emr/latest/APIReference/API_InstanceFleetModifyConfig.html
     * @stability stable
     */
    readonly targetSpotCapacity: number;
}
/**
 * A Step Functions Task to to modify an InstanceFleet on an EMR Cluster.
 *
 * @stability stable
 */
export declare class EmrModifyInstanceFleetByName extends sfn.TaskStateBase {
    private readonly props;
    /**
     * @stability stable
     */
    protected readonly taskPolicies?: iam.PolicyStatement[];
    /**
     * @stability stable
     */
    protected readonly taskMetrics?: sfn.TaskMetricsConfig;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: EmrModifyInstanceFleetByNameProps);
    /**
     * @internal
     */
    protected _renderTask(): any;
}
