/**
 * Determines the level of detail about provisioned throughput consumption that is returned.
 *
 * @stability stable
 */
export declare enum DynamoConsumedCapacity {
    /**
     * The response includes the aggregate ConsumedCapacity for the operation, together with ConsumedCapacity for each table and secondary index that was accessed.
     *
     * @stability stable
     */
    INDEXES = "INDEXES",
    /**
     * The response includes only the aggregate ConsumedCapacity for the operation.
     *
     * @stability stable
     */
    TOTAL = "TOTAL",
    /**
     * No ConsumedCapacity details are included in the response.
     *
     * @stability stable
     */
    NONE = "NONE"
}
/**
 * Determines whether item collection metrics are returned.
 *
 * @stability stable
 */
export declare enum DynamoItemCollectionMetrics {
    /**
     * If set to SIZE, the response includes statistics about item collections, if any, that were modified during the operation.
     *
     * @stability stable
     */
    SIZE = "SIZE",
    /**
     * If set to NONE, no statistics are returned.
     *
     * @stability stable
     */
    NONE = "NONE"
}
/**
 * Use ReturnValues if you want to get the item attributes as they appear before or after they are changed.
 *
 * @stability stable
 */
export declare enum DynamoReturnValues {
    /**
     * Nothing is returned.
     *
     * @stability stable
     */
    NONE = "NONE",
    /**
     * Returns all of the attributes of the item.
     *
     * @stability stable
     */
    ALL_OLD = "ALL_OLD",
    /**
     * Returns only the updated attributes.
     *
     * @stability stable
     */
    UPDATED_OLD = "UPDATED_OLD",
    /**
     * Returns all of the attributes of the item.
     *
     * @stability stable
     */
    ALL_NEW = "ALL_NEW",
    /**
     * Returns only the updated attributes.
     *
     * @stability stable
     */
    UPDATED_NEW = "UPDATED_NEW"
}
/**
 * Class to generate projection expression.
 *
 * @stability stable
 */
export declare class DynamoProjectionExpression {
    private expression;
    /**
     * Adds the passed attribute to the chain.
     *
     * @param attr Attribute name.
     * @stability stable
     */
    withAttribute(attr: string): DynamoProjectionExpression;
    /**
     * Adds the array literal access for passed index.
     *
     * @param index array index.
     * @stability stable
     */
    atIndex(index: number): DynamoProjectionExpression;
    /**
     * converts and return the string expression.
     *
     * @stability stable
     */
    toString(): string;
}
/**
 * Represents the data for an attribute.
 *
 * Each attribute value is described as a name-value pair.
 * The name is the data type, and the value is the data itself.
 *
 * @see https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_AttributeValue.html
 * @stability stable
 */
export declare class DynamoAttributeValue {
    /**
     * Sets an attribute of type String.
     *
     * For example:  "S": "Hello"
     * Strings may be literal values or as JsonPath.
     *
     * @stability stable
     * @example
     *
     * `DynamoAttributeValue.fromString(JsonPath.stringAt('$.bar'))
     */
    static fromString(value: string): DynamoAttributeValue;
    /**
     * Sets a literal number.
     *
     * For example: 1234
     * Numbers are sent across the network to DynamoDB as strings,
     * to maximize compatibility across languages and libraries.
     * However, DynamoDB treats them as number type attributes for mathematical operations.
     *
     * @stability stable
     */
    static fromNumber(value: number): DynamoAttributeValue;
    /**
     * Sets an attribute of type Number.
     *
     * For example:  "N": "123.45"
     * Numbers are sent across the network to DynamoDB as strings,
     * to maximize compatibility across languages and libraries.
     * However, DynamoDB treats them as number type attributes for mathematical operations.
     *
     * Numbers may be expressed as literal strings or as JsonPath
     *
     * @stability stable
     */
    static numberFromString(value: string): DynamoAttributeValue;
    /**
     * Sets an attribute of type Binary.
     *
     * For example:  "B": "dGhpcyB0ZXh0IGlzIGJhc2U2NC1lbmNvZGVk"
     *
     * @param value base-64 encoded string.
     * @stability stable
     */
    static fromBinary(value: string): DynamoAttributeValue;
    /**
     * Sets an attribute of type String Set.
     *
     * For example:  "SS": ["Giraffe", "Hippo" ,"Zebra"]
     *
     * @stability stable
     */
    static fromStringSet(value: string[]): DynamoAttributeValue;
    /**
     * Sets an attribute of type Number Set.
     *
     * For example:  "NS": ["42.2", "-19", "7.5", "3.14"]
     * Numbers are sent across the network to DynamoDB as strings,
     * to maximize compatibility across languages and libraries.
     * However, DynamoDB treats them as number type attributes for mathematical operations.
     *
     * @stability stable
     */
    static fromNumberSet(value: number[]): DynamoAttributeValue;
    /**
     * Sets an attribute of type Number Set.
     *
     * For example:  "NS": ["42.2", "-19", "7.5", "3.14"]
     * Numbers are sent across the network to DynamoDB as strings,
     * to maximize compatibility across languages and libraries.
     * However, DynamoDB treats them as number type attributes for mathematical operations.
     *
     * Numbers may be expressed as literal strings or as JsonPath
     *
     * @stability stable
     */
    static numberSetFromStrings(value: string[]): DynamoAttributeValue;
    /**
     * Sets an attribute of type Binary Set.
     *
     * For example:  "BS": ["U3Vubnk=", "UmFpbnk=", "U25vd3k="]
     *
     * @stability stable
     */
    static fromBinarySet(value: string[]): DynamoAttributeValue;
    /**
     * Sets an attribute of type Map.
     *
     * For example:  "M": {"Name": {"S": "Joe"}, "Age": {"N": "35"}}
     *
     * @stability stable
     */
    static fromMap(value: {
        [key: string]: DynamoAttributeValue;
    }): DynamoAttributeValue;
    /**
     * Sets an attribute of type Map.
     *
     * For example:  "M": {"Name": {"S": "Joe"}, "Age": {"N": "35"}}
     *
     * @param value Json path that specifies state input to be used.
     * @stability stable
     */
    static mapFromJsonPath(value: string): DynamoAttributeValue;
    /**
     * Sets an attribute of type List.
     *
     * For example:  "L": [ {"S": "Cookies"} , {"S": "Coffee"}, {"N", "3.14159"}]
     *
     * @stability stable
     */
    static fromList(value: DynamoAttributeValue[]): DynamoAttributeValue;
    /**
     * Sets an attribute of type Null.
     *
     * For example:  "NULL": true
     *
     * @stability stable
     */
    static fromNull(value: boolean): DynamoAttributeValue;
    /**
     * Sets an attribute of type Boolean.
     *
     * For example:  "BOOL": true
     *
     * @stability stable
     */
    static fromBoolean(value: boolean): DynamoAttributeValue;
    /**
     * Sets an attribute of type Boolean from state input through Json path.
     *
     * For example:  "BOOL": true
     *
     * @param value Json path that specifies state input to be used.
     * @stability stable
     */
    static booleanFromJsonPath(value: string): DynamoAttributeValue;
    /**
     * Represents the data for the attribute.
     *
     * Data can be
     * i.e. "S": "Hello"
     *
     * @stability stable
     */
    readonly attributeValue: any;
    private constructor();
    /**
     * Returns the DynamoDB attribute value.
     *
     * @stability stable
     */
    toObject(): any;
}
