// cmdlib.h

#ifndef __CMDLIB__
#define __CMDLIB__


#include "doomtype.h"
#include "doomdef.h"
#include "m_fixed.h"

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <errno.h>
#include <ctype.h>
#include <stdarg.h>

// the dec offsetof macro doesnt work very well...
#define myoffsetof(type,identifier) ((size_t)&((type *)1)->identifier - 1)

int		Q_filelength (FILE *f);
bool FileExists (const char *filename);
bool DirEntryExists (const char *pathname);

extern	FString progdir;

void	FixPathSeperator (char *path);
static void	inline FixPathSeperator (FString &path) { path.ReplaceChars('\\', '/'); }

void 	DefaultExtension (char *path, const char *extension);
void 	DefaultExtension (FString &path, const char *extension);

FString	ExtractFilePath (const char *path);
FString	ExtractFileBase (const char *path, bool keep_extension=false);

int		ParseHex (const char *str);
int 	ParseNum (const char *str);
bool	IsNum (const char *str);		// [RH] added

char	*copystring(const char *s);
char	*ncopystring(const char *s);
void	ReplaceString (char **ptr, const char *str);

bool CheckWildcards (const char *pattern, const char *text);

void FormatGUID (char *buffer, size_t buffsize, const GUID &guid);

const char *myasctime ();

int strbin (char *str);
FString strbin1 (const char *start);
char *CleanseString (char *str);

void CreatePath(const char * fn);

FString ExpandEnvVars(const char *searchpathstring);
FString NicePath(const char *path);

struct FFileList
{
	FString Filename;
	bool isDirectory;
};

void ScanDirectory(TArray<FFileList> &list, const char *dirpath);


//==========================================================================
//
// Functions to compensate for a tic being a bit short.
// Since ZDoom uses a milliseconds timer for game timing
// 35 tics are actually only 0.98 seconds.
// For real time display this needs to be adjusted
//
//==========================================================================

inline int AdjustTics(int tics)
{
	return Scale(tics, 98, 100);
}

inline int Tics2Seconds(int tics)
{
	return Scale(tics, 98, (100 * TICRATE));
}


#endif
