# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/registry.ipynb.

# %% auto 0
__all__ = ['Config', 'AttrDict', 'registry', 'tryeval', 'parse_base', 'parse', 'parse_and_resolve', 'parse_string']

# %% ../nbs/registry.ipynb 2
from .markup import Config, AttrDict, L
from .thinc_parser.parser import registry
from pathlib import Path as P
from mergedeep import merge

# %% ../nbs/registry.ipynb 3
Config = Config
AttrDict = AttrDict
registry = registry


def tryeval(i):
    try:
        return eval(i)
    except:
        return i


def parse_base(o):
    if "base" not in o["META"]:
        return Config()
    _base = o["META"]["base"]
    base = P(f"{_base}.ini") if not _base.endswith(".ini") else P(_base)
    if not base.exists():
        base = P(o["META"]["file"]).parent / base
    assert (
        base.exists()
    ), f"Missing base file {base} (Please check the `base` key under `META` heading in your config. You gave `{_base}`)"
    base = parse(base, ad_format=False, interpolate=False)
    return base


def parse(file, lazyeval=False, ad_format=True, interpolate=True):
    config = Config().from_disk(file, interpolate=False)
    if "META" not in config:
        config["META"] = {}
    config["META"]["file"] = file = str(P(file).resolve())
    config["META"]["name"] = P(file).stem
    base = parse_base(config)
    config = merge(base, config)
    if interpolate:
        config = config.interpolate()
    if ad_format:
        config = AttrDict(config)
        if not lazyeval:
            config = config.map(tryeval)
    return config


def parse_and_resolve(file):
    o = AttrDict(registry.resolve(Config().from_disk(file)))
    o.map(tryeval)
    return o


def parse_string(string):
    o = AttrDict(Config().from_str(string))
    o.map(tryeval)
    return o
