# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/pdf.ipynb.

# %% auto 0
__all__ = ['PDF', 'dump_pdf_images', 'preview_pdf']

# %% ../nbs/pdf.ipynb 2
from .loader import np, subplots, show, resize, L, Image
from .logger import Info
from .paths import stem
from fastcore.basics import ifnone
from .cli import cli

# %% ../nbs/pdf.ipynb 3
class PDF:
    """Load a PDF file from `path` as a list of images
    Use `show` function to see the images
    **WIP**"""

    def __init__(self, path, dfs=None, dpi=150):
        import fitz

        self.path = path
        self.dpi = dpi
        self.doc = fitz.open(path)
        self.ims = L([self.get_image(page_no) for page_no in range(len(self))])
        self.dfs = L(dfs) if dfs is not None else L([None] * len(self))

    def get_image(self, page_no, dpi=None):
        page = self.doc.load_page(page_no)
        pix = page.get_pixmap(dpi=ifnone(dpi, self.dpi))
        mode = "RGBA" if pix.alpha else "RGB"
        img = Image.frombytes(mode, [pix.width, pix.height], pix.samples)
        return img

    def __len__(self):
        return len(self.doc)

    def __getitem__(self, ix):
        return self.ims[ix]

    def dump_as_images(self, folder, create_new_folder_with_same_name=True):
        from pathlib import Path

        folder = Path(folder)
        folder = (
            folder if not create_new_folder_with_same_name else folder / stem(self.path)
        )

        Path(folder).mkdir(exist_ok=True, parents=True)
        _stem = stem(self.path)
        for ix, im in enumerate(self.ims):
            _to = (
                folder / f"{_stem}--{ix}.jpeg"
                if not create_new_folder_with_same_name
                else folder / f"{ix}.jpeg"
            )
            im.save(_to)
        Info(f"Dumped {len(self)} images to {folder.resolve()}")

    def show(self, ix=None, ixs=None, **kwargs):
        if ixs is not None:
            assert isinstance(ixs, (list, L))
            subplots(L(self.ims)[ixs], **kwargs)
        if ix is not None:
            show(self.ims[ix], **kwargs)
            return

        if len(self) == 1:
            show(self.ims[0], df=self.dfs[0], **kwargs)
        else:
            subplots(self.ims, dfs=self.dfs, **kwargs)


@cli.command()
def dump_pdf_images(
    path,
    folder,
    create_new_folder_with_same_name: bool = True,
    show_after_dump: bool = False,
):
    """Dump all images from a PDF file to a folder"""
    pdf = PDF(path)
    pdf.dump_as_images(
        folder, create_new_folder_with_same_name=create_new_folder_with_same_name
    )
    if show_after_dump:
        pdf.show()


@cli.command()
def preview_pdf(path):
    """Preview a PDF file"""
    pdf = PDF(path)
    pdf.show()
