# libnumerixpy

<p align="center">A Powerful Python/C Library for High-Performance Numerical Computing</p>
<br>
<p align="center">
	<img src="https://img.shields.io/github/languages/top/alexeev-prog/libnumerixpy?style=for-the-badge">
	<img src="https://img.shields.io/github/languages/count/alexeev-prog/libnumerixpy?style=for-the-badge">
	<img src="https://img.shields.io/github/license/alexeev-prog/libnumerixpy?style=for-the-badge">
	<img src="https://img.shields.io/github/stars/alexeev-prog/libnumerixpy?style=for-the-badge">
	<img src="https://img.shields.io/github/issues/alexeev-prog/libnumerixpy?style=for-the-badge">
	<img src="https://img.shields.io/github/last-commit/alexeev-prog/libnumerixpy?style=for-the-badge">
	<img src="https://img.shields.io/pypi/l/libnumerixpy?style=for-the-badge">
    <img src="https://img.shields.io/pypi/wheel/libnumerixpy?style=for-the-badge">
	<img src="https://img.shields.io/badge/coverage-100%25-100%25?style=for-the-badge" alt="">
</p>

> [!CAUTION]
> At the moment, libnumerixpy is under active development (alpha), many things may not work, and this version is not recommended for use (all at your own risk).

libnumerixpy is a powerful, cross-platofrm Python/C library designed for high-performance numerical computing in the domains of physics, mathematics, and computer science.

Libnumerixpy use Python/C API!

You can join to our [small russian telegram blog](https://t.me/hex_warehouse).

## Tests coverage
To test the library, PyTest with the pytest-cov plugin is used. You can look at the tests in [tests directory](./tests)

| Statements | Miss       | Coverage |
|------------|------------|----------|
| 4          | 0          | 100%     |

## Key Features
 - **Extensive Functionality**: libnumerixpy provides a wide range of functions coverint the core areas of mathematics, physics, and computer science, including:
  - Mathematics: linear algebra, calculus, geometry
  - Physics: kinematics, mechanics, thermodynamics, electronics
  - Computer Science: algorithms, numerical methods, data processing
 - **High Performance**: The library is optimized for maximum performance, leveraging modern techniques such as parallel computing and vectorization
 - **Cross-platform Support**: libnumerixpy supports major operating systems (Windows, Linux, macOS).
 - **Ease of Use**: A simple and intuitive API, comprehensive documentation, and numerous examples facilitate the integration of the library into your projects.
 - **Modular Architecture**: libnumerixpy is designed with a modular structure, allowing selective compilation of only the required components.
 - **Extensibility**: The library is open to the developer community, who can contribute improvements and additions.

## Architecture
libnumerixpy has a modular architecture consisting of the following core components:

 - core: Provides essential data types, error handling functions, and utility tools.
 - mathematics: Implements algorithms for linear algebra, calculus, and geometry.
 - physics: Offers functions for solving problems in the areas of kinematics, mechanics, thermodynamics and electronics.

Each module has its own set of header files and source files, ensuring flexibility and the ability to selectively compile the required parts of the library.

## Credits for C/Python API

 + [C/Python API Official Docs](https://docs.python.org/3/c-api)
 + [Enhancing python with custom C extensions](https://stackabuse.com/enhancing-python-with-custom-c-extensions/)
 + [dm-fedorov/python-modules](https://github.com/dm-fedorov/python-modules/blob/master/c-api.md)
 + [Жажда скорости: Python с расширениями C](https://nuancesprog.ru/p/14010/)

## Copyright
libnumerixpy is released under the [GNU LGPL 2.1](https://github.com/alexeev-prog/libnumerixpy/blob/main/LICENSE).

Copyright © 2024 Alexeev Bronislav. All rights reversed.

