The static-website module is able to deploy your pre-packaged static website content into an S3 Bucket, fronted by Cloudfront. This module uses an Origin Access Identity to ensure your Bucket can only be accessed via Cloudfront and is configured to only allow HTTPS requests by default. Custom runtime configurations can also be specified which will emit a runtime-config.json file along with your website content. Typically this includes resource Arns, Id's etc which may need to be referenced from your website. This package uses sane defaults and at a minimum only requires the path to your website assets.

Below is a conceptual view of the default architecture this module creates:

```
Cloudfront Distribution (HTTPS only) -> S3 Bucket (Private via OAI)
|_ WAF V2 ACL                                |_ index.html (+ other website files and assets)
                                             |_ runtime-config.json
```

A typical use case is to create a static website with AuthN. To accomplish this, we can leverage the UserIdentity to create the User Pool (Cognito by default) and Identity Pool. We can then pipe the respective pool id's as runtimeOptions into the StaticWebsite. After the website is deployed, these values can be interrogated from the runtime-config.json deployed alongside the website in order to perform authentication within the app using something like the [Amplify Auth API](https://docs.amplify.aws/lib/client-configuration/configuring-amplify-categories/q/platform/js/#authentication-amazon-cognito).

```ts
const userIdentity = new UserIdentity(this, 'UserIdentity');
new StaticWebsite(this, 'StaticWebsite', {
    websiteContentPath: '<relative>/<path>/<to>/<built>/<website>',
    runtimeOptions: {
        jsonPayload: {
            region: Stack.of(this).region,
            identityPoolId: userIdentity.identityPool.identityPoolId,
            userPoolId: userIdentity.userPool?.userPoolId,
            userPoolWebClientId: userIdentity.userPoolClient?.userPoolClientId,
        }
    },
});
```
# API Reference <a name="API Reference" id="api-reference"></a>

## Constructs <a name="Constructs" id="Constructs"></a>

### CloudfrontWebAcl <a name="CloudfrontWebAcl" id="@aws-prototyping-sdk/static-website.CloudfrontWebAcl"></a>

This construct creates a WAFv2 Web ACL for cloudfront in the us-east-1 region (required for cloudfront) no matter the region of the parent cdk stack.

#### Initializers <a name="Initializers" id="@aws-prototyping-sdk/static-website.CloudfrontWebAcl.Initializer"></a>

```typescript
import { CloudfrontWebAcl } from '@aws-prototyping-sdk/static-website'

new CloudfrontWebAcl(scope: Construct, id: string, props?: CloudFrontWebAclProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/static-website.CloudfrontWebAcl.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/static-website.CloudfrontWebAcl.Initializer.parameter.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/static-website.CloudfrontWebAcl.Initializer.parameter.props">props</a></code> | <code><a href="#@aws-prototyping-sdk/static-website.CloudFrontWebAclProps">CloudFrontWebAclProps</a></code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="@aws-prototyping-sdk/static-website.CloudfrontWebAcl.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

---

##### `id`<sup>Required</sup> <a name="id" id="@aws-prototyping-sdk/static-website.CloudfrontWebAcl.Initializer.parameter.id"></a>

- *Type:* string

---

##### `props`<sup>Optional</sup> <a name="props" id="@aws-prototyping-sdk/static-website.CloudfrontWebAcl.Initializer.parameter.props"></a>

- *Type:* <a href="#@aws-prototyping-sdk/static-website.CloudFrontWebAclProps">CloudFrontWebAclProps</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@aws-prototyping-sdk/static-website.CloudfrontWebAcl.toString">toString</a></code> | Returns a string representation of this construct. |

---

##### `toString` <a name="toString" id="@aws-prototyping-sdk/static-website.CloudfrontWebAcl.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@aws-prototyping-sdk/static-website.CloudfrontWebAcl.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### `isConstruct` <a name="isConstruct" id="@aws-prototyping-sdk/static-website.CloudfrontWebAcl.isConstruct"></a>

```typescript
import { CloudfrontWebAcl } from '@aws-prototyping-sdk/static-website'

CloudfrontWebAcl.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="@aws-prototyping-sdk/static-website.CloudfrontWebAcl.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/static-website.CloudfrontWebAcl.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#@aws-prototyping-sdk/static-website.CloudfrontWebAcl.property.webAclArn">webAclArn</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/static-website.CloudfrontWebAcl.property.webAclId">webAclId</a></code> | <code>string</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="@aws-prototyping-sdk/static-website.CloudfrontWebAcl.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `webAclArn`<sup>Required</sup> <a name="webAclArn" id="@aws-prototyping-sdk/static-website.CloudfrontWebAcl.property.webAclArn"></a>

```typescript
public readonly webAclArn: string;
```

- *Type:* string

---

##### `webAclId`<sup>Required</sup> <a name="webAclId" id="@aws-prototyping-sdk/static-website.CloudfrontWebAcl.property.webAclId"></a>

```typescript
public readonly webAclId: string;
```

- *Type:* string

---


### StaticWebsite <a name="StaticWebsite" id="@aws-prototyping-sdk/static-website.StaticWebsite"></a>

Deploys a Static Website using by default a private S3 bucket as an origin and Cloudfront as the entrypoint.

This construct configures a webAcl containing rules that are generally applicable to web applications. This
provides protection against exploitation of a wide range of vulnerabilities, including some of the high risk
and commonly occurring vulnerabilities described in OWASP publications such as OWASP Top 10.

#### Initializers <a name="Initializers" id="@aws-prototyping-sdk/static-website.StaticWebsite.Initializer"></a>

```typescript
import { StaticWebsite } from '@aws-prototyping-sdk/static-website'

new StaticWebsite(scope: Construct, id: string, props: StaticWebsiteProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsite.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsite.Initializer.parameter.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsite.Initializer.parameter.props">props</a></code> | <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsiteProps">StaticWebsiteProps</a></code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="@aws-prototyping-sdk/static-website.StaticWebsite.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

---

##### `id`<sup>Required</sup> <a name="id" id="@aws-prototyping-sdk/static-website.StaticWebsite.Initializer.parameter.id"></a>

- *Type:* string

---

##### `props`<sup>Required</sup> <a name="props" id="@aws-prototyping-sdk/static-website.StaticWebsite.Initializer.parameter.props"></a>

- *Type:* <a href="#@aws-prototyping-sdk/static-website.StaticWebsiteProps">StaticWebsiteProps</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsite.toString">toString</a></code> | Returns a string representation of this construct. |

---

##### `toString` <a name="toString" id="@aws-prototyping-sdk/static-website.StaticWebsite.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsite.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### `isConstruct` <a name="isConstruct" id="@aws-prototyping-sdk/static-website.StaticWebsite.isConstruct"></a>

```typescript
import { StaticWebsite } from '@aws-prototyping-sdk/static-website'

StaticWebsite.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="@aws-prototyping-sdk/static-website.StaticWebsite.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsite.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsite.property.bucketDeployment">bucketDeployment</a></code> | <code>aws-cdk-lib.aws_s3_deployment.BucketDeployment</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsite.property.cloudFrontDistribution">cloudFrontDistribution</a></code> | <code>aws-cdk-lib.aws_cloudfront.Distribution</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsite.property.websiteBucket">websiteBucket</a></code> | <code>aws-cdk-lib.aws_s3.IBucket</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="@aws-prototyping-sdk/static-website.StaticWebsite.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `bucketDeployment`<sup>Required</sup> <a name="bucketDeployment" id="@aws-prototyping-sdk/static-website.StaticWebsite.property.bucketDeployment"></a>

```typescript
public readonly bucketDeployment: BucketDeployment;
```

- *Type:* aws-cdk-lib.aws_s3_deployment.BucketDeployment

---

##### `cloudFrontDistribution`<sup>Required</sup> <a name="cloudFrontDistribution" id="@aws-prototyping-sdk/static-website.StaticWebsite.property.cloudFrontDistribution"></a>

```typescript
public readonly cloudFrontDistribution: Distribution;
```

- *Type:* aws-cdk-lib.aws_cloudfront.Distribution

---

##### `websiteBucket`<sup>Required</sup> <a name="websiteBucket" id="@aws-prototyping-sdk/static-website.StaticWebsite.property.websiteBucket"></a>

```typescript
public readonly websiteBucket: IBucket;
```

- *Type:* aws-cdk-lib.aws_s3.IBucket

---


## Structs <a name="Structs" id="Structs"></a>

### CidrAllowList <a name="CidrAllowList" id="@aws-prototyping-sdk/static-website.CidrAllowList"></a>

Representation of a CIDR range.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/static-website.CidrAllowList.Initializer"></a>

```typescript
import { CidrAllowList } from '@aws-prototyping-sdk/static-website'

const cidrAllowList: CidrAllowList = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/static-website.CidrAllowList.property.cidrRanges">cidrRanges</a></code> | <code>string[]</code> | Specify an IPv4 address by using CIDR notation. |
| <code><a href="#@aws-prototyping-sdk/static-website.CidrAllowList.property.cidrType">cidrType</a></code> | <code>string</code> | Type of CIDR range. |

---

##### `cidrRanges`<sup>Required</sup> <a name="cidrRanges" id="@aws-prototyping-sdk/static-website.CidrAllowList.property.cidrRanges"></a>

```typescript
public readonly cidrRanges: string[];
```

- *Type:* string[]

Specify an IPv4 address by using CIDR notation.

For example:
To configure AWS WAF to allow, block, or count requests that originated from the IP address 192.0.2.44, specify 192.0.2.44/32 .
To configure AWS WAF to allow, block, or count requests that originated from IP addresses from 192.0.2.0 to 192.0.2.255, specify 192.0.2.0/24 .

For more information about CIDR notation, see the Wikipedia entry Classless Inter-Domain Routing .

Specify an IPv6 address by using CIDR notation. For example:
To configure AWS WAF to allow, block, or count requests that originated from the IP address 1111:0000:0000:0000:0000:0000:0000:0111, specify 1111:0000:0000:0000:0000:0000:0000:0111/128 .
To configure AWS WAF to allow, block, or count requests that originated from IP addresses 1111:0000:0000:0000:0000:0000:0000:0000 to 1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify 1111:0000:0000:0000:0000:0000:0000:0000/64 .

---

##### `cidrType`<sup>Required</sup> <a name="cidrType" id="@aws-prototyping-sdk/static-website.CidrAllowList.property.cidrType"></a>

```typescript
public readonly cidrType: string;
```

- *Type:* string

Type of CIDR range.

---

### CloudFrontWebAclProps <a name="CloudFrontWebAclProps" id="@aws-prototyping-sdk/static-website.CloudFrontWebAclProps"></a>

Properties to configure the web acl.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/static-website.CloudFrontWebAclProps.Initializer"></a>

```typescript
import { CloudFrontWebAclProps } from '@aws-prototyping-sdk/static-website'

const cloudFrontWebAclProps: CloudFrontWebAclProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/static-website.CloudFrontWebAclProps.property.cidrAllowList">cidrAllowList</a></code> | <code><a href="#@aws-prototyping-sdk/static-website.CidrAllowList">CidrAllowList</a></code> | List of cidr ranges to allow. |
| <code><a href="#@aws-prototyping-sdk/static-website.CloudFrontWebAclProps.property.managedRules">managedRules</a></code> | <code><a href="#@aws-prototyping-sdk/static-website.ManagedRule">ManagedRule</a>[]</code> | List of managed rules to apply to the web acl. |

---

##### `cidrAllowList`<sup>Optional</sup> <a name="cidrAllowList" id="@aws-prototyping-sdk/static-website.CloudFrontWebAclProps.property.cidrAllowList"></a>

```typescript
public readonly cidrAllowList: CidrAllowList;
```

- *Type:* <a href="#@aws-prototyping-sdk/static-website.CidrAllowList">CidrAllowList</a>
- *Default:* undefined

List of cidr ranges to allow.

---

##### `managedRules`<sup>Optional</sup> <a name="managedRules" id="@aws-prototyping-sdk/static-website.CloudFrontWebAclProps.property.managedRules"></a>

```typescript
public readonly managedRules: ManagedRule[];
```

- *Type:* <a href="#@aws-prototyping-sdk/static-website.ManagedRule">ManagedRule</a>[]
- *Default:* [{ vendor: "AWS", name: "AWSManagedRulesCommonRuleSet" }]

List of managed rules to apply to the web acl.

---

### ManagedRule <a name="ManagedRule" id="@aws-prototyping-sdk/static-website.ManagedRule"></a>

Represents a WAF V2 managed rule.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/static-website.ManagedRule.Initializer"></a>

```typescript
import { ManagedRule } from '@aws-prototyping-sdk/static-website'

const managedRule: ManagedRule = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/static-website.ManagedRule.property.name">name</a></code> | <code>string</code> | The name of the managed rule group. |
| <code><a href="#@aws-prototyping-sdk/static-website.ManagedRule.property.vendor">vendor</a></code> | <code>string</code> | The name of the managed rule group vendor. |

---

##### `name`<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/static-website.ManagedRule.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the managed rule group.

You use this, along with the vendor name, to identify the rule group.

---

##### `vendor`<sup>Required</sup> <a name="vendor" id="@aws-prototyping-sdk/static-website.ManagedRule.property.vendor"></a>

```typescript
public readonly vendor: string;
```

- *Type:* string

The name of the managed rule group vendor.

You use this, along with the rule group name, to identify the rule group.

---

### RuntimeOptions <a name="RuntimeOptions" id="@aws-prototyping-sdk/static-website.RuntimeOptions"></a>

Dynamic configuration which gets resolved only during deployment.

*Example*

```typescript
// Will store a JSON file called runtime-config.json in the root of the StaticWebsite S3 bucket containing any
// and all resolved values.
const runtimeConfig = {jsonPayload: {bucketArn: s3Bucket.bucketArn}};
new StaticWebsite(scope, 'StaticWebsite', {websiteContentPath: 'path/to/website', runtimeConfig});
```


#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/static-website.RuntimeOptions.Initializer"></a>

```typescript
import { RuntimeOptions } from '@aws-prototyping-sdk/static-website'

const runtimeOptions: RuntimeOptions = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/static-website.RuntimeOptions.property.jsonPayload">jsonPayload</a></code> | <code>any</code> | Arbitrary JSON payload containing runtime values to deploy. |
| <code><a href="#@aws-prototyping-sdk/static-website.RuntimeOptions.property.jsonFileName">jsonFileName</a></code> | <code>string</code> | File name to store runtime configuration (jsonPayload). |

---

##### `jsonPayload`<sup>Required</sup> <a name="jsonPayload" id="@aws-prototyping-sdk/static-website.RuntimeOptions.property.jsonPayload"></a>

```typescript
public readonly jsonPayload: any;
```

- *Type:* any

Arbitrary JSON payload containing runtime values to deploy.

Typically this contains resourceArns, etc which
are only known at deploy time.

---

*Example*

```typescript
{ userPoolId: some.userPool.userPoolId, someResourceArn: some.resource.Arn }
```


##### `jsonFileName`<sup>Optional</sup> <a name="jsonFileName" id="@aws-prototyping-sdk/static-website.RuntimeOptions.property.jsonFileName"></a>

```typescript
public readonly jsonFileName: string;
```

- *Type:* string
- *Default:* "runtime-config.json"

File name to store runtime configuration (jsonPayload).

Must follow pattern: '*.json'

---

### StaticWebsiteProps <a name="StaticWebsiteProps" id="@aws-prototyping-sdk/static-website.StaticWebsiteProps"></a>

Properties for configuring the StaticWebsite.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/static-website.StaticWebsiteProps.Initializer"></a>

```typescript
import { StaticWebsiteProps } from '@aws-prototyping-sdk/static-website'

const staticWebsiteProps: StaticWebsiteProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsiteProps.property.websiteContentPath">websiteContentPath</a></code> | <code>string</code> | Path to the directory containing the static website files and assets. |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsiteProps.property.defaultWebsiteBucketEncryption">defaultWebsiteBucketEncryption</a></code> | <code>aws-cdk-lib.aws_s3.BucketEncryption</code> | Bucket encryption to use for the default bucket. |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsiteProps.property.defaultWebsiteBucketEncryptionKey">defaultWebsiteBucketEncryptionKey</a></code> | <code>aws-cdk-lib.aws_kms.Key</code> | A predefined KMS customer encryption key to use for the default bucket that gets created. |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsiteProps.property.distributionProps">distributionProps</a></code> | <code>aws-cdk-lib.aws_cloudfront.DistributionProps</code> | Custom distribution properties. |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsiteProps.property.runtimeOptions">runtimeOptions</a></code> | <code><a href="#@aws-prototyping-sdk/static-website.RuntimeOptions">RuntimeOptions</a></code> | Dynamic configuration which gets resolved only during deployment. |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsiteProps.property.webAclProps">webAclProps</a></code> | <code><a href="#@aws-prototyping-sdk/static-website.CloudFrontWebAclProps">CloudFrontWebAclProps</a></code> | Limited configuration settings for the generated webAcl. |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsiteProps.property.websiteBucket">websiteBucket</a></code> | <code>aws-cdk-lib.aws_s3.IBucket</code> | Predefined bucket to deploy the website into. |

---

##### `websiteContentPath`<sup>Required</sup> <a name="websiteContentPath" id="@aws-prototyping-sdk/static-website.StaticWebsiteProps.property.websiteContentPath"></a>

```typescript
public readonly websiteContentPath: string;
```

- *Type:* string

Path to the directory containing the static website files and assets.

This directory must contain an index.html file.

---

##### `defaultWebsiteBucketEncryption`<sup>Optional</sup> <a name="defaultWebsiteBucketEncryption" id="@aws-prototyping-sdk/static-website.StaticWebsiteProps.property.defaultWebsiteBucketEncryption"></a>

```typescript
public readonly defaultWebsiteBucketEncryption: BucketEncryption;
```

- *Type:* aws-cdk-lib.aws_s3.BucketEncryption
- *Default:* "S3MANAGED"

Bucket encryption to use for the default bucket.

Supported options are KMS or S3MANAGED.

Note: If planning to use KMS, ensure you associate a Lambda Edge function to sign requests to S3 as OAI does not currently support KMS encryption. Refer to {@link https://aws.amazon.com/blogs/networking-and-content-delivery/serving-sse-kms-encrypted-content-from-s3-using-cloudfront/}

---

##### `defaultWebsiteBucketEncryptionKey`<sup>Optional</sup> <a name="defaultWebsiteBucketEncryptionKey" id="@aws-prototyping-sdk/static-website.StaticWebsiteProps.property.defaultWebsiteBucketEncryptionKey"></a>

```typescript
public readonly defaultWebsiteBucketEncryptionKey: Key;
```

- *Type:* aws-cdk-lib.aws_kms.Key

A predefined KMS customer encryption key to use for the default bucket that gets created.

Note: This is only used if the websiteBucket is left undefined, otherwise all settings from the provided websiteBucket will be used.

---

##### `distributionProps`<sup>Optional</sup> <a name="distributionProps" id="@aws-prototyping-sdk/static-website.StaticWebsiteProps.property.distributionProps"></a>

```typescript
public readonly distributionProps: DistributionProps;
```

- *Type:* aws-cdk-lib.aws_cloudfront.DistributionProps

Custom distribution properties.

Note: defaultBehaviour.origin is a required parameter, however it will not be used as this construct will wire it on your behalf.
You will need to pass in an instance of StaticWebsiteOrigin (NoOp) to keep the compiler happy.

---

##### `runtimeOptions`<sup>Optional</sup> <a name="runtimeOptions" id="@aws-prototyping-sdk/static-website.StaticWebsiteProps.property.runtimeOptions"></a>

```typescript
public readonly runtimeOptions: RuntimeOptions;
```

- *Type:* <a href="#@aws-prototyping-sdk/static-website.RuntimeOptions">RuntimeOptions</a>

Dynamic configuration which gets resolved only during deployment.

---

##### `webAclProps`<sup>Optional</sup> <a name="webAclProps" id="@aws-prototyping-sdk/static-website.StaticWebsiteProps.property.webAclProps"></a>

```typescript
public readonly webAclProps: CloudFrontWebAclProps;
```

- *Type:* <a href="#@aws-prototyping-sdk/static-website.CloudFrontWebAclProps">CloudFrontWebAclProps</a>

Limited configuration settings for the generated webAcl.

For more advanced settings, create your own ACL and pass in the webAclId as a param to distributionProps.

Note: If pass in your own ACL, make sure the SCOPE is CLOUDFRONT and it is created in us-east-1.

---

##### `websiteBucket`<sup>Optional</sup> <a name="websiteBucket" id="@aws-prototyping-sdk/static-website.StaticWebsiteProps.property.websiteBucket"></a>

```typescript
public readonly websiteBucket: IBucket;
```

- *Type:* aws-cdk-lib.aws_s3.IBucket

Predefined bucket to deploy the website into.

---

## Classes <a name="Classes" id="Classes"></a>

### StaticWebsiteOrigin <a name="StaticWebsiteOrigin" id="@aws-prototyping-sdk/static-website.StaticWebsiteOrigin"></a>

- *Implements:* aws-cdk-lib.aws_cloudfront.IOrigin

If passing in distributionProps, the default behaviour.origin is a required parameter. An instance of this class can be passed in to make the compiler happy.

#### Initializers <a name="Initializers" id="@aws-prototyping-sdk/static-website.StaticWebsiteOrigin.Initializer"></a>

```typescript
import { StaticWebsiteOrigin } from '@aws-prototyping-sdk/static-website'

new StaticWebsiteOrigin()
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsiteOrigin.bind">bind</a></code> | The method called when a given Origin is added (for the first time) to a Distribution. |

---

##### `bind` <a name="bind" id="@aws-prototyping-sdk/static-website.StaticWebsiteOrigin.bind"></a>

```typescript
public bind(_scope: Construct, _options: OriginBindOptions): OriginBindConfig
```

The method called when a given Origin is added (for the first time) to a Distribution.

###### `_scope`<sup>Required</sup> <a name="_scope" id="@aws-prototyping-sdk/static-website.StaticWebsiteOrigin.bind.parameter._scope"></a>

- *Type:* constructs.Construct

---

###### `_options`<sup>Required</sup> <a name="_options" id="@aws-prototyping-sdk/static-website.StaticWebsiteOrigin.bind.parameter._options"></a>

- *Type:* aws-cdk-lib.aws_cloudfront.OriginBindOptions

---





