The static-website module is able to deploy your pre-packaged static website content into an S3 Bucket, fronted by Cloudfront. This module uses an Origin Access Identity to ensure your Bucket can only be accessed via Cloudfront and is configured to only allow HTTPS requests by default. Custom runtime configurations can also be specified which will emit a runtime-config.json file along with your website content. Typically this includes resource Arns, Id's etc which may need to be referenced from your website. This package uses sane defaults and at a minimum only requires the path to your website assets.

Below is a conceptual view of the default architecture this module creates:

```
Cloudfront Distribution (HTTPS only) -> S3 Bucket (Private via OAI)
|_ WAF V2 ACL                                |_ index.html (+ other website files and assets)
                                             |_ runtime-config.json
```

A typical use case is to create a static website with AuthN. To accomplish this, we can leverage the UserIdentity to create the User Pool (Cognito by default) and Identity Pool. We can then pipe the respective pool id's as runtimeOptions into the StaticWebsite. After the website is deployed, these values can be interrogated from the runtime-config.json deployed alongside the website in order to perform authentication within the app using something like the [Amplify Auth API](https://docs.amplify.aws/lib/client-configuration/configuring-amplify-categories/q/platform/js/#authentication-amazon-cognito).

```python
# Example automatically generated from non-compiling source. May contain errors.
user_identity = UserIdentity(self, "UserIdentity")
StaticWebsite(self, "StaticWebsite",
    website_content_path="<relative>/<path>/<to>/<built>/<website>",
    runtime_options={
        "json_payload": {
            "region": Stack.of(self).region,
            "identity_pool_id": user_identity.identity_pool.identity_pool_id,
            "user_pool_id": user_identity.user_pool.user_pool_id,
            "user_pool_web_client_id": user_identity.user_pool_client.user_pool_client_id
        }
    }
)
```
# API Reference <a name="API Reference" id="api-reference"></a>

## Constructs <a name="Constructs" id="Constructs"></a>

### CloudfrontWebAcl <a name="CloudfrontWebAcl" id="@aws-prototyping-sdk/static-website.CloudfrontWebAcl"></a>

This construct creates a WAFv2 Web ACL for cloudfront in the us-east-1 region (required for cloudfront) no matter the region of the parent cdk stack.

#### Initializers <a name="Initializers" id="@aws-prototyping-sdk/static-website.CloudfrontWebAcl.Initializer"></a>

```python
import aws_prototyping_sdk.static_website

aws_prototyping_sdk.static_website.CloudfrontWebAcl(
  scope: Construct,
  id: str,
  cidr_allow_list: CidrAllowList = None,
  managed_rules: typing.List[ManagedRule] = None
)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/static-website.CloudfrontWebAcl.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/static-website.CloudfrontWebAcl.Initializer.parameter.id">id</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/static-website.CloudfrontWebAcl.Initializer.parameter.cidrAllowList">cidr_allow_list</a></code> | <code><a href="#@aws-prototyping-sdk/static-website.CidrAllowList">CidrAllowList</a></code> | List of cidr ranges to allow. |
| <code><a href="#@aws-prototyping-sdk/static-website.CloudfrontWebAcl.Initializer.parameter.managedRules">managed_rules</a></code> | <code>typing.List[<a href="#@aws-prototyping-sdk/static-website.ManagedRule">ManagedRule</a>]</code> | List of managed rules to apply to the web acl. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="@aws-prototyping-sdk/static-website.CloudfrontWebAcl.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

---

##### `id`<sup>Required</sup> <a name="id" id="@aws-prototyping-sdk/static-website.CloudfrontWebAcl.Initializer.parameter.id"></a>

- *Type:* str

---

##### `cidr_allow_list`<sup>Optional</sup> <a name="cidr_allow_list" id="@aws-prototyping-sdk/static-website.CloudfrontWebAcl.Initializer.parameter.cidrAllowList"></a>

- *Type:* <a href="#@aws-prototyping-sdk/static-website.CidrAllowList">CidrAllowList</a>
- *Default:* undefined

List of cidr ranges to allow.

---

##### `managed_rules`<sup>Optional</sup> <a name="managed_rules" id="@aws-prototyping-sdk/static-website.CloudfrontWebAcl.Initializer.parameter.managedRules"></a>

- *Type:* typing.List[<a href="#@aws-prototyping-sdk/static-website.ManagedRule">ManagedRule</a>]
- *Default:* [{ vendor: "AWS", name: "AWSManagedRulesCommonRuleSet" }]

List of managed rules to apply to the web acl.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@aws-prototyping-sdk/static-website.CloudfrontWebAcl.toString">to_string</a></code> | Returns a string representation of this construct. |

---

##### `to_string` <a name="to_string" id="@aws-prototyping-sdk/static-website.CloudfrontWebAcl.toString"></a>

```python
def to_string() -> str
```

Returns a string representation of this construct.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@aws-prototyping-sdk/static-website.CloudfrontWebAcl.isConstruct">is_construct</a></code> | Checks if `x` is a construct. |

---

##### `is_construct` <a name="is_construct" id="@aws-prototyping-sdk/static-website.CloudfrontWebAcl.isConstruct"></a>

```python
import aws_prototyping_sdk.static_website

aws_prototyping_sdk.static_website.CloudfrontWebAcl.is_construct(
  x: typing.Any
)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="@aws-prototyping-sdk/static-website.CloudfrontWebAcl.isConstruct.parameter.x"></a>

- *Type:* typing.Any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/static-website.CloudfrontWebAcl.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#@aws-prototyping-sdk/static-website.CloudfrontWebAcl.property.webAclArn">web_acl_arn</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/static-website.CloudfrontWebAcl.property.webAclId">web_acl_id</a></code> | <code>str</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="@aws-prototyping-sdk/static-website.CloudfrontWebAcl.property.node"></a>

```python
node: Node
```

- *Type:* constructs.Node

The tree node.

---

##### `web_acl_arn`<sup>Required</sup> <a name="web_acl_arn" id="@aws-prototyping-sdk/static-website.CloudfrontWebAcl.property.webAclArn"></a>

```python
web_acl_arn: str
```

- *Type:* str

---

##### `web_acl_id`<sup>Required</sup> <a name="web_acl_id" id="@aws-prototyping-sdk/static-website.CloudfrontWebAcl.property.webAclId"></a>

```python
web_acl_id: str
```

- *Type:* str

---


### StaticWebsite <a name="StaticWebsite" id="@aws-prototyping-sdk/static-website.StaticWebsite"></a>

Deploys a Static Website using by default a private S3 bucket as an origin and Cloudfront as the entrypoint.

This construct configures a webAcl containing rules that are generally applicable to web applications. This
provides protection against exploitation of a wide range of vulnerabilities, including some of the high risk
and commonly occurring vulnerabilities described in OWASP publications such as OWASP Top 10.

#### Initializers <a name="Initializers" id="@aws-prototyping-sdk/static-website.StaticWebsite.Initializer"></a>

```python
import aws_prototyping_sdk.static_website

aws_prototyping_sdk.static_website.StaticWebsite(
  scope: Construct,
  id: str,
  website_content_path: str,
  default_website_bucket_encryption: BucketEncryption = None,
  default_website_bucket_encryption_key: Key = None,
  distribution_props: DistributionProps = None,
  runtime_options: RuntimeOptions = None,
  web_acl_props: CloudFrontWebAclProps = None,
  website_bucket: IBucket = None
)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsite.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsite.Initializer.parameter.id">id</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsite.Initializer.parameter.websiteContentPath">website_content_path</a></code> | <code>str</code> | Path to the directory containing the static website files and assets. |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsite.Initializer.parameter.defaultWebsiteBucketEncryption">default_website_bucket_encryption</a></code> | <code>aws_cdk.aws_s3.BucketEncryption</code> | Bucket encryption to use for the default bucket. |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsite.Initializer.parameter.defaultWebsiteBucketEncryptionKey">default_website_bucket_encryption_key</a></code> | <code>aws_cdk.aws_kms.Key</code> | A predefined KMS customer encryption key to use for the default bucket that gets created. |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsite.Initializer.parameter.distributionProps">distribution_props</a></code> | <code>aws_cdk.aws_cloudfront.DistributionProps</code> | Custom distribution properties. |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsite.Initializer.parameter.runtimeOptions">runtime_options</a></code> | <code><a href="#@aws-prototyping-sdk/static-website.RuntimeOptions">RuntimeOptions</a></code> | Dynamic configuration which gets resolved only during deployment. |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsite.Initializer.parameter.webAclProps">web_acl_props</a></code> | <code><a href="#@aws-prototyping-sdk/static-website.CloudFrontWebAclProps">CloudFrontWebAclProps</a></code> | Limited configuration settings for the generated webAcl. |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsite.Initializer.parameter.websiteBucket">website_bucket</a></code> | <code>aws_cdk.aws_s3.IBucket</code> | Predefined bucket to deploy the website into. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="@aws-prototyping-sdk/static-website.StaticWebsite.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

---

##### `id`<sup>Required</sup> <a name="id" id="@aws-prototyping-sdk/static-website.StaticWebsite.Initializer.parameter.id"></a>

- *Type:* str

---

##### `website_content_path`<sup>Required</sup> <a name="website_content_path" id="@aws-prototyping-sdk/static-website.StaticWebsite.Initializer.parameter.websiteContentPath"></a>

- *Type:* str

Path to the directory containing the static website files and assets.

This directory must contain an index.html file.

---

##### `default_website_bucket_encryption`<sup>Optional</sup> <a name="default_website_bucket_encryption" id="@aws-prototyping-sdk/static-website.StaticWebsite.Initializer.parameter.defaultWebsiteBucketEncryption"></a>

- *Type:* aws_cdk.aws_s3.BucketEncryption
- *Default:* "S3MANAGED"

Bucket encryption to use for the default bucket.

Supported options are KMS or S3MANAGED.

Note: If planning to use KMS, ensure you associate a Lambda Edge function to sign requests to S3 as OAI does not currently support KMS encryption. Refer to {@link https://aws.amazon.com/blogs/networking-and-content-delivery/serving-sse-kms-encrypted-content-from-s3-using-cloudfront/}

---

##### `default_website_bucket_encryption_key`<sup>Optional</sup> <a name="default_website_bucket_encryption_key" id="@aws-prototyping-sdk/static-website.StaticWebsite.Initializer.parameter.defaultWebsiteBucketEncryptionKey"></a>

- *Type:* aws_cdk.aws_kms.Key

A predefined KMS customer encryption key to use for the default bucket that gets created.

Note: This is only used if the websiteBucket is left undefined, otherwise all settings from the provided websiteBucket will be used.

---

##### `distribution_props`<sup>Optional</sup> <a name="distribution_props" id="@aws-prototyping-sdk/static-website.StaticWebsite.Initializer.parameter.distributionProps"></a>

- *Type:* aws_cdk.aws_cloudfront.DistributionProps

Custom distribution properties.

Note: defaultBehaviour.origin is a required parameter, however it will not be used as this construct will wire it on your behalf.
You will need to pass in an instance of StaticWebsiteOrigin (NoOp) to keep the compiler happy.

---

##### `runtime_options`<sup>Optional</sup> <a name="runtime_options" id="@aws-prototyping-sdk/static-website.StaticWebsite.Initializer.parameter.runtimeOptions"></a>

- *Type:* <a href="#@aws-prototyping-sdk/static-website.RuntimeOptions">RuntimeOptions</a>

Dynamic configuration which gets resolved only during deployment.

---

##### `web_acl_props`<sup>Optional</sup> <a name="web_acl_props" id="@aws-prototyping-sdk/static-website.StaticWebsite.Initializer.parameter.webAclProps"></a>

- *Type:* <a href="#@aws-prototyping-sdk/static-website.CloudFrontWebAclProps">CloudFrontWebAclProps</a>

Limited configuration settings for the generated webAcl.

For more advanced settings, create your own ACL and pass in the webAclId as a param to distributionProps.

Note: If pass in your own ACL, make sure the SCOPE is CLOUDFRONT and it is created in us-east-1.

---

##### `website_bucket`<sup>Optional</sup> <a name="website_bucket" id="@aws-prototyping-sdk/static-website.StaticWebsite.Initializer.parameter.websiteBucket"></a>

- *Type:* aws_cdk.aws_s3.IBucket

Predefined bucket to deploy the website into.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsite.toString">to_string</a></code> | Returns a string representation of this construct. |

---

##### `to_string` <a name="to_string" id="@aws-prototyping-sdk/static-website.StaticWebsite.toString"></a>

```python
def to_string() -> str
```

Returns a string representation of this construct.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsite.isConstruct">is_construct</a></code> | Checks if `x` is a construct. |

---

##### `is_construct` <a name="is_construct" id="@aws-prototyping-sdk/static-website.StaticWebsite.isConstruct"></a>

```python
import aws_prototyping_sdk.static_website

aws_prototyping_sdk.static_website.StaticWebsite.is_construct(
  x: typing.Any
)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="@aws-prototyping-sdk/static-website.StaticWebsite.isConstruct.parameter.x"></a>

- *Type:* typing.Any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsite.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsite.property.bucketDeployment">bucket_deployment</a></code> | <code>aws_cdk.aws_s3_deployment.BucketDeployment</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsite.property.cloudFrontDistribution">cloud_front_distribution</a></code> | <code>aws_cdk.aws_cloudfront.Distribution</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsite.property.websiteBucket">website_bucket</a></code> | <code>aws_cdk.aws_s3.IBucket</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="@aws-prototyping-sdk/static-website.StaticWebsite.property.node"></a>

```python
node: Node
```

- *Type:* constructs.Node

The tree node.

---

##### `bucket_deployment`<sup>Required</sup> <a name="bucket_deployment" id="@aws-prototyping-sdk/static-website.StaticWebsite.property.bucketDeployment"></a>

```python
bucket_deployment: BucketDeployment
```

- *Type:* aws_cdk.aws_s3_deployment.BucketDeployment

---

##### `cloud_front_distribution`<sup>Required</sup> <a name="cloud_front_distribution" id="@aws-prototyping-sdk/static-website.StaticWebsite.property.cloudFrontDistribution"></a>

```python
cloud_front_distribution: Distribution
```

- *Type:* aws_cdk.aws_cloudfront.Distribution

---

##### `website_bucket`<sup>Required</sup> <a name="website_bucket" id="@aws-prototyping-sdk/static-website.StaticWebsite.property.websiteBucket"></a>

```python
website_bucket: IBucket
```

- *Type:* aws_cdk.aws_s3.IBucket

---


## Structs <a name="Structs" id="Structs"></a>

### CidrAllowList <a name="CidrAllowList" id="@aws-prototyping-sdk/static-website.CidrAllowList"></a>

Representation of a CIDR range.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/static-website.CidrAllowList.Initializer"></a>

```python
import aws_prototyping_sdk.static_website

aws_prototyping_sdk.static_website.CidrAllowList(
  cidr_ranges: typing.List[str],
  cidr_type: str
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/static-website.CidrAllowList.property.cidrRanges">cidr_ranges</a></code> | <code>typing.List[str]</code> | Specify an IPv4 address by using CIDR notation. |
| <code><a href="#@aws-prototyping-sdk/static-website.CidrAllowList.property.cidrType">cidr_type</a></code> | <code>str</code> | Type of CIDR range. |

---

##### `cidr_ranges`<sup>Required</sup> <a name="cidr_ranges" id="@aws-prototyping-sdk/static-website.CidrAllowList.property.cidrRanges"></a>

```python
cidr_ranges: typing.List[str]
```

- *Type:* typing.List[str]

Specify an IPv4 address by using CIDR notation.

For example:
To configure AWS WAF to allow, block, or count requests that originated from the IP address 192.0.2.44, specify 192.0.2.44/32 .
To configure AWS WAF to allow, block, or count requests that originated from IP addresses from 192.0.2.0 to 192.0.2.255, specify 192.0.2.0/24 .

For more information about CIDR notation, see the Wikipedia entry Classless Inter-Domain Routing .

Specify an IPv6 address by using CIDR notation. For example:
To configure AWS WAF to allow, block, or count requests that originated from the IP address 1111:0000:0000:0000:0000:0000:0000:0111, specify 1111:0000:0000:0000:0000:0000:0000:0111/128 .
To configure AWS WAF to allow, block, or count requests that originated from IP addresses 1111:0000:0000:0000:0000:0000:0000:0000 to 1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify 1111:0000:0000:0000:0000:0000:0000:0000/64 .

---

##### `cidr_type`<sup>Required</sup> <a name="cidr_type" id="@aws-prototyping-sdk/static-website.CidrAllowList.property.cidrType"></a>

```python
cidr_type: str
```

- *Type:* str

Type of CIDR range.

---

### CloudFrontWebAclProps <a name="CloudFrontWebAclProps" id="@aws-prototyping-sdk/static-website.CloudFrontWebAclProps"></a>

Properties to configure the web acl.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/static-website.CloudFrontWebAclProps.Initializer"></a>

```python
import aws_prototyping_sdk.static_website

aws_prototyping_sdk.static_website.CloudFrontWebAclProps(
  cidr_allow_list: CidrAllowList = None,
  managed_rules: typing.List[ManagedRule] = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/static-website.CloudFrontWebAclProps.property.cidrAllowList">cidr_allow_list</a></code> | <code><a href="#@aws-prototyping-sdk/static-website.CidrAllowList">CidrAllowList</a></code> | List of cidr ranges to allow. |
| <code><a href="#@aws-prototyping-sdk/static-website.CloudFrontWebAclProps.property.managedRules">managed_rules</a></code> | <code>typing.List[<a href="#@aws-prototyping-sdk/static-website.ManagedRule">ManagedRule</a>]</code> | List of managed rules to apply to the web acl. |

---

##### `cidr_allow_list`<sup>Optional</sup> <a name="cidr_allow_list" id="@aws-prototyping-sdk/static-website.CloudFrontWebAclProps.property.cidrAllowList"></a>

```python
cidr_allow_list: CidrAllowList
```

- *Type:* <a href="#@aws-prototyping-sdk/static-website.CidrAllowList">CidrAllowList</a>
- *Default:* undefined

List of cidr ranges to allow.

---

##### `managed_rules`<sup>Optional</sup> <a name="managed_rules" id="@aws-prototyping-sdk/static-website.CloudFrontWebAclProps.property.managedRules"></a>

```python
managed_rules: typing.List[ManagedRule]
```

- *Type:* typing.List[<a href="#@aws-prototyping-sdk/static-website.ManagedRule">ManagedRule</a>]
- *Default:* [{ vendor: "AWS", name: "AWSManagedRulesCommonRuleSet" }]

List of managed rules to apply to the web acl.

---

### ManagedRule <a name="ManagedRule" id="@aws-prototyping-sdk/static-website.ManagedRule"></a>

Represents a WAF V2 managed rule.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/static-website.ManagedRule.Initializer"></a>

```python
import aws_prototyping_sdk.static_website

aws_prototyping_sdk.static_website.ManagedRule(
  name: str,
  vendor: str
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/static-website.ManagedRule.property.name">name</a></code> | <code>str</code> | The name of the managed rule group. |
| <code><a href="#@aws-prototyping-sdk/static-website.ManagedRule.property.vendor">vendor</a></code> | <code>str</code> | The name of the managed rule group vendor. |

---

##### `name`<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/static-website.ManagedRule.property.name"></a>

```python
name: str
```

- *Type:* str

The name of the managed rule group.

You use this, along with the vendor name, to identify the rule group.

---

##### `vendor`<sup>Required</sup> <a name="vendor" id="@aws-prototyping-sdk/static-website.ManagedRule.property.vendor"></a>

```python
vendor: str
```

- *Type:* str

The name of the managed rule group vendor.

You use this, along with the rule group name, to identify the rule group.

---

### RuntimeOptions <a name="RuntimeOptions" id="@aws-prototyping-sdk/static-website.RuntimeOptions"></a>

Dynamic configuration which gets resolved only during deployment.

*Example*

```python
# Example automatically generated from non-compiling source. May contain errors.
# Will store a JSON file called runtime-config.json in the root of the StaticWebsite S3 bucket containing any
# and all resolved values.
runtime_config = {"json_payload": {"bucket_arn": s3_bucket.bucket_arn}}
StaticWebsite(scope, "StaticWebsite", website_content_path="path/to/website", runtime_config=runtime_config)
```


#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/static-website.RuntimeOptions.Initializer"></a>

```python
import aws_prototyping_sdk.static_website

aws_prototyping_sdk.static_website.RuntimeOptions(
  json_payload: typing.Any,
  json_file_name: str = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/static-website.RuntimeOptions.property.jsonPayload">json_payload</a></code> | <code>typing.Any</code> | Arbitrary JSON payload containing runtime values to deploy. |
| <code><a href="#@aws-prototyping-sdk/static-website.RuntimeOptions.property.jsonFileName">json_file_name</a></code> | <code>str</code> | File name to store runtime configuration (jsonPayload). |

---

##### `json_payload`<sup>Required</sup> <a name="json_payload" id="@aws-prototyping-sdk/static-website.RuntimeOptions.property.jsonPayload"></a>

```python
json_payload: typing.Any
```

- *Type:* typing.Any

Arbitrary JSON payload containing runtime values to deploy.

Typically this contains resourceArns, etc which
are only known at deploy time.

---

*Example*

```python
# Example automatically generated from non-compiling source. May contain errors.
userPoolId: some.userPool.userPoolId, someResourceArnsome.resource.Arn
```


##### `json_file_name`<sup>Optional</sup> <a name="json_file_name" id="@aws-prototyping-sdk/static-website.RuntimeOptions.property.jsonFileName"></a>

```python
json_file_name: str
```

- *Type:* str
- *Default:* "runtime-config.json"

File name to store runtime configuration (jsonPayload).

Must follow pattern: '*.json'

---

### StaticWebsiteProps <a name="StaticWebsiteProps" id="@aws-prototyping-sdk/static-website.StaticWebsiteProps"></a>

Properties for configuring the StaticWebsite.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/static-website.StaticWebsiteProps.Initializer"></a>

```python
import aws_prototyping_sdk.static_website

aws_prototyping_sdk.static_website.StaticWebsiteProps(
  website_content_path: str,
  default_website_bucket_encryption: BucketEncryption = None,
  default_website_bucket_encryption_key: Key = None,
  distribution_props: DistributionProps = None,
  runtime_options: RuntimeOptions = None,
  web_acl_props: CloudFrontWebAclProps = None,
  website_bucket: IBucket = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsiteProps.property.websiteContentPath">website_content_path</a></code> | <code>str</code> | Path to the directory containing the static website files and assets. |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsiteProps.property.defaultWebsiteBucketEncryption">default_website_bucket_encryption</a></code> | <code>aws_cdk.aws_s3.BucketEncryption</code> | Bucket encryption to use for the default bucket. |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsiteProps.property.defaultWebsiteBucketEncryptionKey">default_website_bucket_encryption_key</a></code> | <code>aws_cdk.aws_kms.Key</code> | A predefined KMS customer encryption key to use for the default bucket that gets created. |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsiteProps.property.distributionProps">distribution_props</a></code> | <code>aws_cdk.aws_cloudfront.DistributionProps</code> | Custom distribution properties. |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsiteProps.property.runtimeOptions">runtime_options</a></code> | <code><a href="#@aws-prototyping-sdk/static-website.RuntimeOptions">RuntimeOptions</a></code> | Dynamic configuration which gets resolved only during deployment. |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsiteProps.property.webAclProps">web_acl_props</a></code> | <code><a href="#@aws-prototyping-sdk/static-website.CloudFrontWebAclProps">CloudFrontWebAclProps</a></code> | Limited configuration settings for the generated webAcl. |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsiteProps.property.websiteBucket">website_bucket</a></code> | <code>aws_cdk.aws_s3.IBucket</code> | Predefined bucket to deploy the website into. |

---

##### `website_content_path`<sup>Required</sup> <a name="website_content_path" id="@aws-prototyping-sdk/static-website.StaticWebsiteProps.property.websiteContentPath"></a>

```python
website_content_path: str
```

- *Type:* str

Path to the directory containing the static website files and assets.

This directory must contain an index.html file.

---

##### `default_website_bucket_encryption`<sup>Optional</sup> <a name="default_website_bucket_encryption" id="@aws-prototyping-sdk/static-website.StaticWebsiteProps.property.defaultWebsiteBucketEncryption"></a>

```python
default_website_bucket_encryption: BucketEncryption
```

- *Type:* aws_cdk.aws_s3.BucketEncryption
- *Default:* "S3MANAGED"

Bucket encryption to use for the default bucket.

Supported options are KMS or S3MANAGED.

Note: If planning to use KMS, ensure you associate a Lambda Edge function to sign requests to S3 as OAI does not currently support KMS encryption. Refer to {@link https://aws.amazon.com/blogs/networking-and-content-delivery/serving-sse-kms-encrypted-content-from-s3-using-cloudfront/}

---

##### `default_website_bucket_encryption_key`<sup>Optional</sup> <a name="default_website_bucket_encryption_key" id="@aws-prototyping-sdk/static-website.StaticWebsiteProps.property.defaultWebsiteBucketEncryptionKey"></a>

```python
default_website_bucket_encryption_key: Key
```

- *Type:* aws_cdk.aws_kms.Key

A predefined KMS customer encryption key to use for the default bucket that gets created.

Note: This is only used if the websiteBucket is left undefined, otherwise all settings from the provided websiteBucket will be used.

---

##### `distribution_props`<sup>Optional</sup> <a name="distribution_props" id="@aws-prototyping-sdk/static-website.StaticWebsiteProps.property.distributionProps"></a>

```python
distribution_props: DistributionProps
```

- *Type:* aws_cdk.aws_cloudfront.DistributionProps

Custom distribution properties.

Note: defaultBehaviour.origin is a required parameter, however it will not be used as this construct will wire it on your behalf.
You will need to pass in an instance of StaticWebsiteOrigin (NoOp) to keep the compiler happy.

---

##### `runtime_options`<sup>Optional</sup> <a name="runtime_options" id="@aws-prototyping-sdk/static-website.StaticWebsiteProps.property.runtimeOptions"></a>

```python
runtime_options: RuntimeOptions
```

- *Type:* <a href="#@aws-prototyping-sdk/static-website.RuntimeOptions">RuntimeOptions</a>

Dynamic configuration which gets resolved only during deployment.

---

##### `web_acl_props`<sup>Optional</sup> <a name="web_acl_props" id="@aws-prototyping-sdk/static-website.StaticWebsiteProps.property.webAclProps"></a>

```python
web_acl_props: CloudFrontWebAclProps
```

- *Type:* <a href="#@aws-prototyping-sdk/static-website.CloudFrontWebAclProps">CloudFrontWebAclProps</a>

Limited configuration settings for the generated webAcl.

For more advanced settings, create your own ACL and pass in the webAclId as a param to distributionProps.

Note: If pass in your own ACL, make sure the SCOPE is CLOUDFRONT and it is created in us-east-1.

---

##### `website_bucket`<sup>Optional</sup> <a name="website_bucket" id="@aws-prototyping-sdk/static-website.StaticWebsiteProps.property.websiteBucket"></a>

```python
website_bucket: IBucket
```

- *Type:* aws_cdk.aws_s3.IBucket

Predefined bucket to deploy the website into.

---

## Classes <a name="Classes" id="Classes"></a>

### StaticWebsiteOrigin <a name="StaticWebsiteOrigin" id="@aws-prototyping-sdk/static-website.StaticWebsiteOrigin"></a>

- *Implements:* aws_cdk.aws_cloudfront.IOrigin

If passing in distributionProps, the default behaviour.origin is a required parameter. An instance of this class can be passed in to make the compiler happy.

#### Initializers <a name="Initializers" id="@aws-prototyping-sdk/static-website.StaticWebsiteOrigin.Initializer"></a>

```python
import aws_prototyping_sdk.static_website

aws_prototyping_sdk.static_website.StaticWebsiteOrigin()
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsiteOrigin.bind">bind</a></code> | The method called when a given Origin is added (for the first time) to a Distribution. |

---

##### `bind` <a name="bind" id="@aws-prototyping-sdk/static-website.StaticWebsiteOrigin.bind"></a>

```python
def bind(
  _scope: Construct,
  origin_id: str
) -> OriginBindConfig
```

The method called when a given Origin is added (for the first time) to a Distribution.

###### `_scope`<sup>Required</sup> <a name="_scope" id="@aws-prototyping-sdk/static-website.StaticWebsiteOrigin.bind.parameter._scope"></a>

- *Type:* constructs.Construct

---

###### `origin_id`<sup>Required</sup> <a name="origin_id" id="@aws-prototyping-sdk/static-website.StaticWebsiteOrigin.bind.parameter.originId"></a>

- *Type:* str

The identifier of this Origin, as assigned by the Distribution this Origin has been used added to.

---





