"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EvaluateExpression = void 0;
const path = require("path");
const iam = require("@aws-cdk/aws-iam");
const lambda = require("@aws-cdk/aws-lambda");
const sfn = require("@aws-cdk/aws-stepfunctions");
/**
 * (experimental) A Step Functions Task to evaluate an expression.
 *
 * OUTPUT: the output of this task is the evaluated expression.
 *
 * @experimental
 */
class EvaluateExpression extends sfn.TaskStateBase {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        super(scope, id, props);
        this.props = props;
        this.evalFn = createEvalFn(this.props.runtime || lambda.Runtime.NODEJS_10_X, this);
        this.taskPolicies = [
            new iam.PolicyStatement({
                resources: [this.evalFn.functionArn],
                actions: ['lambda:InvokeFunction'],
            }),
        ];
    }
    /**
     * @internal
     */
    _renderTask() {
        const matches = this.props.expression.match(/\$[.\[][.a-zA-Z[\]0-9]+/g);
        let expressionAttributeValues = {};
        if (matches) {
            expressionAttributeValues = matches.reduce((acc, m) => ({
                ...acc,
                [m]: sfn.JsonPath.stringAt(m),
            }), {});
        }
        const parameters = {
            expression: this.props.expression,
            expressionAttributeValues,
        };
        return {
            Resource: this.evalFn.functionArn,
            Parameters: sfn.FieldUtils.renderObject(parameters),
        };
    }
}
exports.EvaluateExpression = EvaluateExpression;
function createEvalFn(runtime, scope) {
    const code = lambda.Code.asset(path.join(__dirname, `eval-${runtime.name}-handler`));
    const lambdaPurpose = 'Eval';
    switch (runtime) {
        case lambda.Runtime.NODEJS_10_X:
            return new lambda.SingletonFunction(scope, 'EvalFunction', {
                runtime,
                handler: 'index.handler',
                uuid: 'a0d2ce44-871b-4e74-87a1-f5e63d7c3bdc',
                lambdaPurpose,
                code,
            });
        // TODO: implement other runtimes
        default:
            throw new Error(`The runtime ${runtime.name} is currently not supported.`);
    }
}
//# sourceMappingURL=data:application/json;base64,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