"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EncryptionOption = exports.AthenaStartQueryExecution = void 0;
const iam = require("@aws-cdk/aws-iam");
const sfn = require("@aws-cdk/aws-stepfunctions");
const cdk = require("@aws-cdk/core");
const task_utils_1 = require("../private/task-utils");
/**
 * (experimental) Start an Athena Query as a Task.
 *
 * @see https://docs.aws.amazon.com/step-functions/latest/dg/connect-athena.html
 * @experimental
 */
class AthenaStartQueryExecution extends sfn.TaskStateBase {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _a;
        super(scope, id, props);
        this.props = props;
        this.integrationPattern = (_a = props.integrationPattern) !== null && _a !== void 0 ? _a : sfn.IntegrationPattern.REQUEST_RESPONSE;
        task_utils_1.validatePatternSupported(this.integrationPattern, AthenaStartQueryExecution.SUPPORTED_INTEGRATION_PATTERNS);
        this.taskPolicies = this.createPolicyStatements();
    }
    createPolicyStatements() {
        var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q;
        const policyStatements = [
            new iam.PolicyStatement({
                resources: [
                    cdk.Stack.of(this).formatArn({
                        service: 'athena',
                        resource: 'datacatalog',
                        resourceName: (_b = (_a = this.props.queryExecutionContext) === null || _a === void 0 ? void 0 : _a.catalogName) !== null && _b !== void 0 ? _b : 'AwsDataCatalog',
                    }),
                    cdk.Stack.of(this).formatArn({
                        service: 'athena',
                        resource: 'workgroup',
                        resourceName: (_c = this.props.workGroup) !== null && _c !== void 0 ? _c : 'primary',
                    }),
                ],
                actions: ['athena:getDataCatalog', 'athena:startQueryExecution', 'athena:getQueryExecution'],
            }),
        ];
        policyStatements.push(new iam.PolicyStatement({
            actions: ['s3:CreateBucket',
                's3:ListBucket',
                's3:GetBucketLocation',
                's3:GetObject'],
            resources: ['*'],
        }));
        policyStatements.push(new iam.PolicyStatement({
            actions: ['s3:AbortMultipartUpload',
                's3:ListBucketMultipartUploads',
                's3:ListMultipartUploadParts',
                's3:PutObject'],
            resources: [((_e = (_d = this.props.resultConfiguration) === null || _d === void 0 ? void 0 : _d.outputLocation) === null || _e === void 0 ? void 0 : _e.bucketName) ? `arn:aws:s3:::${(_g = (_f = this.props.resultConfiguration) === null || _f === void 0 ? void 0 : _f.outputLocation) === null || _g === void 0 ? void 0 : _g.bucketName}/${(_j = (_h = this.props.resultConfiguration) === null || _h === void 0 ? void 0 : _h.outputLocation) === null || _j === void 0 ? void 0 : _j.objectKey}/*` : '*'],
        }));
        policyStatements.push(new iam.PolicyStatement({
            actions: ['lakeformation:GetDataAccess'],
            resources: ['*'],
        }));
        policyStatements.push(new iam.PolicyStatement({
            actions: ['glue:BatchCreatePartition',
                'glue:BatchDeletePartition',
                'glue:BatchDeleteTable',
                'glue:BatchGetPartition',
                'glue:CreateDatabase',
                'glue:CreatePartition',
                'glue:CreateTable',
                'glue:DeleteDatabase',
                'glue:DeletePartition',
                'glue:DeleteTable',
                'glue:GetDatabase',
                'glue:GetDatabases',
                'glue:GetPartition',
                'glue:GetPartitions',
                'glue:GetTable',
                'glue:GetTables',
                'glue:UpdateDatabase',
                'glue:UpdatePartition',
                'glue:UpdateTable'],
            resources: [
                cdk.Stack.of(this).formatArn({
                    service: 'glue',
                    resource: 'catalog',
                }),
                cdk.Stack.of(this).formatArn({
                    service: 'glue',
                    resource: 'database',
                    resourceName: (_l = (_k = this.props.queryExecutionContext) === null || _k === void 0 ? void 0 : _k.databaseName) !== null && _l !== void 0 ? _l : 'default',
                }),
                cdk.Stack.of(this).formatArn({
                    service: 'glue',
                    resource: 'table',
                    resourceName: ((_o = (_m = this.props.queryExecutionContext) === null || _m === void 0 ? void 0 : _m.databaseName) !== null && _o !== void 0 ? _o : 'default') + '/*',
                }),
                cdk.Stack.of(this).formatArn({
                    service: 'glue',
                    resource: 'userDefinedFunction',
                    resourceName: ((_q = (_p = this.props.queryExecutionContext) === null || _p === void 0 ? void 0 : _p.databaseName) !== null && _q !== void 0 ? _q : 'default') + '/*',
                }),
            ],
        }));
        return policyStatements;
    }
    renderEncryption() {
        var _a;
        const encryptionConfiguration = ((_a = this.props.resultConfiguration) === null || _a === void 0 ? void 0 : _a.encryptionConfiguration) !== undefined
            ? {
                EncryptionOption: this.props.resultConfiguration.encryptionConfiguration.encryptionOption,
                KmsKey: this.props.resultConfiguration.encryptionConfiguration.encryptionKey,
            }
            : undefined;
        return encryptionConfiguration;
    }
    /**
     * Provides the Athena start query execution service integration task configuration
     */
    /**
     * @internal
     */
    _renderTask() {
        var _a, _b, _c, _d, _e, _f, _g, _h, _j;
        if ((_a = this.props.resultConfiguration) === null || _a === void 0 ? void 0 : _a.outputLocation) {
            return {
                Resource: task_utils_1.integrationResourceArn('athena', 'startQueryExecution', this.integrationPattern),
                Parameters: sfn.FieldUtils.renderObject({
                    QueryString: this.props.queryString,
                    ClientRequestToken: this.props.clientRequestToken,
                    QueryExecutionContext: {
                        Catalog: (_b = this.props.queryExecutionContext) === null || _b === void 0 ? void 0 : _b.catalogName,
                        Database: (_c = this.props.queryExecutionContext) === null || _c === void 0 ? void 0 : _c.databaseName,
                    },
                    ResultConfiguration: {
                        EncryptionConfiguration: this.renderEncryption(),
                        OutputLocation: `s3://${(_e = (_d = this.props.resultConfiguration) === null || _d === void 0 ? void 0 : _d.outputLocation) === null || _e === void 0 ? void 0 : _e.bucketName}/${(_g = (_f = this.props.resultConfiguration) === null || _f === void 0 ? void 0 : _f.outputLocation) === null || _g === void 0 ? void 0 : _g.objectKey}/`,
                    },
                    WorkGroup: this.props.workGroup,
                }),
            };
        }
        else {
            return {
                Resource: task_utils_1.integrationResourceArn('athena', 'startQueryExecution', this.integrationPattern),
                Parameters: sfn.FieldUtils.renderObject({
                    QueryString: this.props.queryString,
                    ClientRequestToken: this.props.clientRequestToken,
                    QueryExecutionContext: {
                        Catalog: (_h = this.props.queryExecutionContext) === null || _h === void 0 ? void 0 : _h.catalogName,
                        Database: (_j = this.props.queryExecutionContext) === null || _j === void 0 ? void 0 : _j.databaseName,
                    },
                    ResultConfiguration: {
                        EncryptionConfiguration: this.renderEncryption(),
                    },
                    WorkGroup: this.props.workGroup,
                }),
            };
        }
    }
}
exports.AthenaStartQueryExecution = AthenaStartQueryExecution;
AthenaStartQueryExecution.SUPPORTED_INTEGRATION_PATTERNS = [
    sfn.IntegrationPattern.REQUEST_RESPONSE,
    sfn.IntegrationPattern.RUN_JOB,
];
/**
 * (experimental) Encryption Options of the S3 bucket.
 *
 * @see https://docs.aws.amazon.com/athena/latest/APIReference/API_EncryptionConfiguration.html#athena-Type-EncryptionConfiguration-EncryptionOption
 * @experimental
 */
var EncryptionOption;
(function (EncryptionOption) {
    EncryptionOption["S3_MANAGED"] = "SSE_S3";
    EncryptionOption["KMS"] = "SSE_KMS";
    EncryptionOption["CLIENT_SIDE_KMS"] = "CSE_KMS";
})(EncryptionOption = exports.EncryptionOption || (exports.EncryptionOption = {}));
//# sourceMappingURL=data:application/json;base64,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