# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: eth-trader-api/v1/twamm.proto
# plugin: python-betterproto
from dataclasses import dataclass
from typing import AsyncGenerator, List

import betterproto
import grpclib


class ConfirmationLevel(betterproto.Enum):
    CL_UNKNOWN = 0
    CL_NEW = 1
    CL_PENDING = 2
    CL_BLOCK = 3


class OrderType(betterproto.Enum):
    OT_UNKNOWN = 0
    OT_NEW = 1
    OT_CANCEL = 2

class SwapType(betterproto.Enum):
    ST_UNKNOWN = 0
    ST_LONG_TERM = 1
    ST_PARTNER_SWAP = 2


@dataclass
class VirtualPoolStreamRequest(betterproto.Message):
    pool_i_ds: List[str] = betterproto.string_field(1)


@dataclass
class VirtualPoolStreamResponse(betterproto.Message):
    block_height: int = betterproto.uint64_field(1)
    pool: "VirtualPool" = betterproto.message_field(2)


@dataclass
class VirtualPool(betterproto.Message):
    pool_i_d: str = betterproto.string_field(1)
    token0_symbol: str = betterproto.string_field(2)
    token0_address: str = betterproto.string_field(3)
    virtual_token0_reserve: int = betterproto.uint64_field(4)
    sales_price_token0: float = betterproto.double_field(5)
    sales_price_token0_predicted: float = betterproto.double_field(6)
    sales_rate_token0: int = betterproto.uint64_field(7)
    token1_symbol: str = betterproto.string_field(8)
    token1_address: str = betterproto.string_field(9)
    virtual_token1_reserve: int = betterproto.uint64_field(10)
    sales_price_token1: float = betterproto.double_field(11)
    sales_price_token1_predicted: float = betterproto.double_field(12)
    sales_rate_token1: int = betterproto.uint64_field(13)
    orders: List["VirtualOrder"] = betterproto.message_field(14)


@dataclass
class VirtualOrder(betterproto.Message):
    order_i_d: int = betterproto.uint64_field(1)
    sender: str = betterproto.string_field(2)
    token_in: str = betterproto.string_field(3)
    token_out: str = betterproto.string_field(4)
    start_block: int = betterproto.uint64_field(5)
    end_block: int = betterproto.uint64_field(6)


@dataclass
class OrderPoolStreamRequest(betterproto.Message):
    pool_i_ds: List[str] = betterproto.string_field(1)


@dataclass
class OrderPoolStreamResponse(betterproto.Message):
    block_height: int = betterproto.uint64_field(1)
    pool: "Pool" = betterproto.message_field(2)


@dataclass
class Pool(betterproto.Message):
    pool_i_d: str = betterproto.string_field(1)
    token0_symbol: str = betterproto.string_field(2)
    token0_address: str = betterproto.string_field(3)
    virtual_token0_reserve: int = betterproto.uint64_field(4)
    token1_symbol: str = betterproto.string_field(5)
    token1_address: str = betterproto.string_field(6)
    virtual_token1_reserve: int = betterproto.uint64_field(7)
    sales_price_token0: float = betterproto.double_field(8)
    sales_price_token1: float = betterproto.double_field(9)
    sales_rate_token0: int = betterproto.uint64_field(10)
    sales_rate_token1: int = betterproto.uint64_field(11)
    sales_price_token0_predicted: float = betterproto.double_field(12)
    sales_price_token1_predicted: float = betterproto.double_field(13)


@dataclass
class OrderStreamRequest(betterproto.Message):
    pool_i_ds: List[str] = betterproto.string_field(1)


@dataclass
class OrderStreamResponse(betterproto.Message):
    block_height: int = betterproto.uint64_field(1)
    order: "Order" = betterproto.message_field(2)


@dataclass
class Order(betterproto.Message):
    confirmation_level: "ConfirmationLevel" = betterproto.enum_field(1)
    order_type: "OrderType" = betterproto.enum_field(2)
    swap_type: "SwapType" = betterproto.enum_field(3)
    pool_i_d: str = betterproto.string_field(4)
    sender: str = betterproto.string_field(5)
    token_in: str = betterproto.string_field(6)
    token_out: str = betterproto.string_field(7)
    amount: int = betterproto.uint64_field(8)
    adjusted_amount: float = betterproto.double_field(9)
    intervals: int = betterproto.uint64_field(10)
    block_count: int = betterproto.uint64_field(11)
    tx_hash: str = betterproto.string_field(12)


class EthTraderAPIStub(betterproto.ServiceStub):
    async def virtual_pool_stream(
        self, *, pool_i_ds: List[str] = []
    ) -> AsyncGenerator[VirtualPoolStreamResponse, None]:
        request = VirtualPoolStreamRequest()
        request.pool_i_ds = pool_i_ds

        async for response in self._unary_stream(
            "/proto.EthTraderAPI/VirtualPoolStream",
            request,
            VirtualPoolStreamResponse,
        ):
            yield response

    async def order_pool_stream(
        self, *, pool_i_ds: List[str] = []
    ) -> AsyncGenerator[OrderPoolStreamResponse, None]:
        request = OrderPoolStreamRequest()
        request.pool_i_ds = pool_i_ds

        async for response in self._unary_stream(
            "/proto.EthTraderAPI/OrderPoolStream",
            request,
            OrderPoolStreamResponse,
        ):
            yield response

    async def order_stream(
        self, *, pool_i_ds: List[str] = []
    ) -> AsyncGenerator[OrderStreamResponse, None]:
        request = OrderStreamRequest()
        request.pool_i_ds = pool_i_ds

        async for response in self._unary_stream(
            "/proto.EthTraderAPI/OrderStream",
            request,
            OrderStreamResponse,
        ):
            yield response
