# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['TempUrlArgs', 'TempUrl']

@pulumi.input_type
class TempUrlArgs:
    def __init__(__self__, *,
                 container: pulumi.Input[str],
                 object: pulumi.Input[str],
                 ttl: pulumi.Input[int],
                 method: Optional[pulumi.Input[str]] = None,
                 regenerate: Optional[pulumi.Input[bool]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 split: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a TempUrl resource.
        :param pulumi.Input[str] container: The container name the object belongs to.
        :param pulumi.Input[str] object: The object name the tempurl is for.
        :param pulumi.Input[int] ttl: The TTL, in seconds, for the URL. For how long it should
               be valid.
        :param pulumi.Input[str] method: The method allowed when accessing this URL.
               Valid values are `GET`, and `POST`. Default is `GET`.
        :param pulumi.Input[bool] regenerate: Whether to automatically regenerate the URL when
               it has expired. If set to true, this will create a new resource with a new
               ID and new URL. Defaults to false.
        :param pulumi.Input[str] region: The region the tempurl is located in.
        """
        pulumi.set(__self__, "container", container)
        pulumi.set(__self__, "object", object)
        pulumi.set(__self__, "ttl", ttl)
        if method is not None:
            pulumi.set(__self__, "method", method)
        if regenerate is not None:
            pulumi.set(__self__, "regenerate", regenerate)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if split is not None:
            pulumi.set(__self__, "split", split)

    @property
    @pulumi.getter
    def container(self) -> pulumi.Input[str]:
        """
        The container name the object belongs to.
        """
        return pulumi.get(self, "container")

    @container.setter
    def container(self, value: pulumi.Input[str]):
        pulumi.set(self, "container", value)

    @property
    @pulumi.getter
    def object(self) -> pulumi.Input[str]:
        """
        The object name the tempurl is for.
        """
        return pulumi.get(self, "object")

    @object.setter
    def object(self, value: pulumi.Input[str]):
        pulumi.set(self, "object", value)

    @property
    @pulumi.getter
    def ttl(self) -> pulumi.Input[int]:
        """
        The TTL, in seconds, for the URL. For how long it should
        be valid.
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: pulumi.Input[int]):
        pulumi.set(self, "ttl", value)

    @property
    @pulumi.getter
    def method(self) -> Optional[pulumi.Input[str]]:
        """
        The method allowed when accessing this URL.
        Valid values are `GET`, and `POST`. Default is `GET`.
        """
        return pulumi.get(self, "method")

    @method.setter
    def method(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "method", value)

    @property
    @pulumi.getter
    def regenerate(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to automatically regenerate the URL when
        it has expired. If set to true, this will create a new resource with a new
        ID and new URL. Defaults to false.
        """
        return pulumi.get(self, "regenerate")

    @regenerate.setter
    def regenerate(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "regenerate", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region the tempurl is located in.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def split(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "split")

    @split.setter
    def split(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "split", value)


@pulumi.input_type
class _TempUrlState:
    def __init__(__self__, *,
                 container: Optional[pulumi.Input[str]] = None,
                 method: Optional[pulumi.Input[str]] = None,
                 object: Optional[pulumi.Input[str]] = None,
                 regenerate: Optional[pulumi.Input[bool]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 split: Optional[pulumi.Input[str]] = None,
                 ttl: Optional[pulumi.Input[int]] = None,
                 url: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering TempUrl resources.
        :param pulumi.Input[str] container: The container name the object belongs to.
        :param pulumi.Input[str] method: The method allowed when accessing this URL.
               Valid values are `GET`, and `POST`. Default is `GET`.
        :param pulumi.Input[str] object: The object name the tempurl is for.
        :param pulumi.Input[bool] regenerate: Whether to automatically regenerate the URL when
               it has expired. If set to true, this will create a new resource with a new
               ID and new URL. Defaults to false.
        :param pulumi.Input[str] region: The region the tempurl is located in.
        :param pulumi.Input[int] ttl: The TTL, in seconds, for the URL. For how long it should
               be valid.
        :param pulumi.Input[str] url: The URL
        """
        if container is not None:
            pulumi.set(__self__, "container", container)
        if method is not None:
            pulumi.set(__self__, "method", method)
        if object is not None:
            pulumi.set(__self__, "object", object)
        if regenerate is not None:
            pulumi.set(__self__, "regenerate", regenerate)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if split is not None:
            pulumi.set(__self__, "split", split)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def container(self) -> Optional[pulumi.Input[str]]:
        """
        The container name the object belongs to.
        """
        return pulumi.get(self, "container")

    @container.setter
    def container(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "container", value)

    @property
    @pulumi.getter
    def method(self) -> Optional[pulumi.Input[str]]:
        """
        The method allowed when accessing this URL.
        Valid values are `GET`, and `POST`. Default is `GET`.
        """
        return pulumi.get(self, "method")

    @method.setter
    def method(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "method", value)

    @property
    @pulumi.getter
    def object(self) -> Optional[pulumi.Input[str]]:
        """
        The object name the tempurl is for.
        """
        return pulumi.get(self, "object")

    @object.setter
    def object(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "object", value)

    @property
    @pulumi.getter
    def regenerate(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to automatically regenerate the URL when
        it has expired. If set to true, this will create a new resource with a new
        ID and new URL. Defaults to false.
        """
        return pulumi.get(self, "regenerate")

    @regenerate.setter
    def regenerate(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "regenerate", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region the tempurl is located in.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def split(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "split")

    @split.setter
    def split(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "split", value)

    @property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input[int]]:
        """
        The TTL, in seconds, for the URL. For how long it should
        be valid.
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ttl", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        The URL
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)


class TempUrl(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 container: Optional[pulumi.Input[str]] = None,
                 method: Optional[pulumi.Input[str]] = None,
                 object: Optional[pulumi.Input[str]] = None,
                 regenerate: Optional[pulumi.Input[bool]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 split: Optional[pulumi.Input[str]] = None,
                 ttl: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        Use this resource to generate an OpenStack Object Storage temporary URL.

        The temporary URL will be valid for as long as TTL is set to (in seconds).
        Once the URL has expired, it will no longer be valid, but the resource
        will remain in place. If you wish to automatically regenerate a URL, set
        the `regenerate` argument to `true`. This will create a new resource with
        a new ID and URL.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_openstack as openstack

        container1 = openstack.objectstorage.Container("container1", metadata={
            "Temp-URL-Key": "testkey",
        })
        object1 = openstack.objectstorage.ContainerObject("object1",
            container_name=container1.name,
            content="Hello, world!")
        obj_tempurl = openstack.objectstorage.TempUrl("objTempurl",
            container=container1.name,
            method="post",
            object=object1.name,
            ttl=20)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] container: The container name the object belongs to.
        :param pulumi.Input[str] method: The method allowed when accessing this URL.
               Valid values are `GET`, and `POST`. Default is `GET`.
        :param pulumi.Input[str] object: The object name the tempurl is for.
        :param pulumi.Input[bool] regenerate: Whether to automatically regenerate the URL when
               it has expired. If set to true, this will create a new resource with a new
               ID and new URL. Defaults to false.
        :param pulumi.Input[str] region: The region the tempurl is located in.
        :param pulumi.Input[int] ttl: The TTL, in seconds, for the URL. For how long it should
               be valid.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TempUrlArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Use this resource to generate an OpenStack Object Storage temporary URL.

        The temporary URL will be valid for as long as TTL is set to (in seconds).
        Once the URL has expired, it will no longer be valid, but the resource
        will remain in place. If you wish to automatically regenerate a URL, set
        the `regenerate` argument to `true`. This will create a new resource with
        a new ID and URL.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_openstack as openstack

        container1 = openstack.objectstorage.Container("container1", metadata={
            "Temp-URL-Key": "testkey",
        })
        object1 = openstack.objectstorage.ContainerObject("object1",
            container_name=container1.name,
            content="Hello, world!")
        obj_tempurl = openstack.objectstorage.TempUrl("objTempurl",
            container=container1.name,
            method="post",
            object=object1.name,
            ttl=20)
        ```

        :param str resource_name: The name of the resource.
        :param TempUrlArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TempUrlArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 container: Optional[pulumi.Input[str]] = None,
                 method: Optional[pulumi.Input[str]] = None,
                 object: Optional[pulumi.Input[str]] = None,
                 regenerate: Optional[pulumi.Input[bool]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 split: Optional[pulumi.Input[str]] = None,
                 ttl: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TempUrlArgs.__new__(TempUrlArgs)

            if container is None and not opts.urn:
                raise TypeError("Missing required property 'container'")
            __props__.__dict__["container"] = container
            __props__.__dict__["method"] = method
            if object is None and not opts.urn:
                raise TypeError("Missing required property 'object'")
            __props__.__dict__["object"] = object
            __props__.__dict__["regenerate"] = regenerate
            __props__.__dict__["region"] = region
            __props__.__dict__["split"] = split
            if ttl is None and not opts.urn:
                raise TypeError("Missing required property 'ttl'")
            __props__.__dict__["ttl"] = ttl
            __props__.__dict__["url"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["url"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(TempUrl, __self__).__init__(
            'openstack:objectstorage/tempUrl:TempUrl',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            container: Optional[pulumi.Input[str]] = None,
            method: Optional[pulumi.Input[str]] = None,
            object: Optional[pulumi.Input[str]] = None,
            regenerate: Optional[pulumi.Input[bool]] = None,
            region: Optional[pulumi.Input[str]] = None,
            split: Optional[pulumi.Input[str]] = None,
            ttl: Optional[pulumi.Input[int]] = None,
            url: Optional[pulumi.Input[str]] = None) -> 'TempUrl':
        """
        Get an existing TempUrl resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] container: The container name the object belongs to.
        :param pulumi.Input[str] method: The method allowed when accessing this URL.
               Valid values are `GET`, and `POST`. Default is `GET`.
        :param pulumi.Input[str] object: The object name the tempurl is for.
        :param pulumi.Input[bool] regenerate: Whether to automatically regenerate the URL when
               it has expired. If set to true, this will create a new resource with a new
               ID and new URL. Defaults to false.
        :param pulumi.Input[str] region: The region the tempurl is located in.
        :param pulumi.Input[int] ttl: The TTL, in seconds, for the URL. For how long it should
               be valid.
        :param pulumi.Input[str] url: The URL
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TempUrlState.__new__(_TempUrlState)

        __props__.__dict__["container"] = container
        __props__.__dict__["method"] = method
        __props__.__dict__["object"] = object
        __props__.__dict__["regenerate"] = regenerate
        __props__.__dict__["region"] = region
        __props__.__dict__["split"] = split
        __props__.__dict__["ttl"] = ttl
        __props__.__dict__["url"] = url
        return TempUrl(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def container(self) -> pulumi.Output[str]:
        """
        The container name the object belongs to.
        """
        return pulumi.get(self, "container")

    @property
    @pulumi.getter
    def method(self) -> pulumi.Output[Optional[str]]:
        """
        The method allowed when accessing this URL.
        Valid values are `GET`, and `POST`. Default is `GET`.
        """
        return pulumi.get(self, "method")

    @property
    @pulumi.getter
    def object(self) -> pulumi.Output[str]:
        """
        The object name the tempurl is for.
        """
        return pulumi.get(self, "object")

    @property
    @pulumi.getter
    def regenerate(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to automatically regenerate the URL when
        it has expired. If set to true, this will create a new resource with a new
        ID and new URL. Defaults to false.
        """
        return pulumi.get(self, "regenerate")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The region the tempurl is located in.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def split(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "split")

    @property
    @pulumi.getter
    def ttl(self) -> pulumi.Output[int]:
        """
        The TTL, in seconds, for the URL. For how long it should
        be valid.
        """
        return pulumi.get(self, "ttl")

    @property
    @pulumi.getter
    def url(self) -> pulumi.Output[str]:
        """
        The URL
        """
        return pulumi.get(self, "url")

