# coding: utf-8

"""
    Empire - Platform API

    OpenAPI specification for the Platform REST API of Empire  **System Time:** Europe/Amsterdam  **General data formats:**   * _capacity values_ => kW (integers)   * _dates and local times_ => System Time   * _currencies_ => EUR   # noqa: E501

    The version of the OpenAPI document: 0.178.2
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Optional, Union
from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr, confloat, conint
from empire_platform_api_public_client.models.auction_timescale import AuctionTimescale
from empire_platform_api_public_client.models.border_direction import BorderDirection
from empire_platform_api_public_client.models.date_period import DatePeriod
from empire_platform_api_public_client.models.noticeboard_entry_type import NoticeboardEntryType
from empire_platform_api_public_client.models.secondary_market_noticeboard_entry_status import SecondaryMarketNoticeboardEntryStatus

class SecondaryMarketNoticeboardEntry(BaseModel):
    """
    SecondaryMarketNoticeboardEntry
    """
    id: StrictStr = Field(..., description="Unique identifier for the record in UUID4 format")
    type: NoticeboardEntryType = Field(...)
    delivery_period: DatePeriod = Field(..., alias="deliveryPeriod")
    timescale: AuctionTimescale = Field(...)
    direction: BorderDirection = Field(...)
    notice_capacity: Optional[StrictInt] = Field(None, alias="noticeCapacity", description="Capacity value in kilowatts (kW) - the required system precision allows for handling capacity values as integers")
    notice_price: Optional[Union[confloat(multiple_of=0.01, strict=True), conint(strict=True)]] = Field(None, alias="noticePrice", description="Currency value in Euros (€), accepted with a precision of maximum 2 decimal places")
    posted_at: datetime = Field(..., alias="postedAt", description="Date and time with zone information, marks an **absolute point** on the timeline  - theoretically can be sent and received with any zone offset (until it marks the desired **absolute point** on the timeline) - in practice it is advised to transfer it in UTC timezone (with Z offset, \"Zulu time\") - ISO 8601 compliant string in `yyyy-mm-ddThh:mm:ss.SSSZ` format ")
    status: SecondaryMarketNoticeboardEntryStatus = Field(...)
    expires_at: datetime = Field(..., alias="expiresAt", description="Date and time with zone information, marks an **absolute point** on the timeline  - theoretically can be sent and received with any zone offset (until it marks the desired **absolute point** on the timeline) - in practice it is advised to transfer it in UTC timezone (with Z offset, \"Zulu time\") - ISO 8601 compliant string in `yyyy-mm-ddThh:mm:ss.SSSZ` format ")
    is_own: Optional[StrictBool] = Field(None, alias="isOwn")
    __properties = ["id", "type", "deliveryPeriod", "timescale", "direction", "noticeCapacity", "noticePrice", "postedAt", "status", "expiresAt", "isOwn"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SecondaryMarketNoticeboardEntry:
        """Create an instance of SecondaryMarketNoticeboardEntry from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of delivery_period
        if self.delivery_period:
            _dict['deliveryPeriod'] = self.delivery_period.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SecondaryMarketNoticeboardEntry:
        """Create an instance of SecondaryMarketNoticeboardEntry from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return SecondaryMarketNoticeboardEntry.parse_obj(obj)

        _obj = SecondaryMarketNoticeboardEntry.parse_obj({
            "id": obj.get("id"),
            "type": obj.get("type"),
            "delivery_period": DatePeriod.from_dict(obj.get("deliveryPeriod")) if obj.get("deliveryPeriod") is not None else None,
            "timescale": obj.get("timescale"),
            "direction": obj.get("direction"),
            "notice_capacity": obj.get("noticeCapacity"),
            "notice_price": obj.get("noticePrice"),
            "posted_at": obj.get("postedAt"),
            "status": obj.get("status"),
            "expires_at": obj.get("expiresAt"),
            "is_own": obj.get("isOwn")
        })
        return _obj

