# coding: utf-8

"""
    Empire - Platform API

    OpenAPI specification for the Platform REST API of Empire  **System Time:** Europe/Amsterdam  **General data formats:**   * _capacity values_ => kW (integers)   * _dates and local times_ => System Time   * _currencies_ => EUR   # noqa: E501

    The version of the OpenAPI document: 0.178.2
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Union
from pydantic import BaseModel, Field, confloat, conint, conlist
from empire_platform_api_public_client.models.participant_dashboard_finance_overview_invoice import ParticipantDashboardFinanceOverviewInvoice

class ParticipantDashboardFinanceOverviewData(BaseModel):
    """
    ParticipantDashboardFinanceOverviewData
    """
    credit_cover: Union[confloat(multiple_of=0.01, strict=True), conint(strict=True)] = Field(..., alias="creditCover", description="Currency value in Euros (€), accepted with a precision of maximum 2 decimal places")
    credit_utilization: Union[confloat(multiple_of=0.01, strict=True), conint(strict=True)] = Field(..., alias="creditUtilization", description="Currency value in Euros (€), accepted with a precision of maximum 2 decimal places")
    credit_limit: Union[confloat(multiple_of=0.01, strict=True), conint(strict=True)] = Field(..., alias="creditLimit", description="Currency value in Euros (€), accepted with a precision of maximum 2 decimal places")
    invoices: conlist(ParticipantDashboardFinanceOverviewInvoice) = Field(...)
    __properties = ["creditCover", "creditUtilization", "creditLimit", "invoices"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ParticipantDashboardFinanceOverviewData:
        """Create an instance of ParticipantDashboardFinanceOverviewData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in invoices (list)
        _items = []
        if self.invoices:
            for _item in self.invoices:
                if _item:
                    _items.append(_item.to_dict())
            _dict['invoices'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ParticipantDashboardFinanceOverviewData:
        """Create an instance of ParticipantDashboardFinanceOverviewData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ParticipantDashboardFinanceOverviewData.parse_obj(obj)

        _obj = ParticipantDashboardFinanceOverviewData.parse_obj({
            "credit_cover": obj.get("creditCover"),
            "credit_utilization": obj.get("creditUtilization"),
            "credit_limit": obj.get("creditLimit"),
            "invoices": [ParticipantDashboardFinanceOverviewInvoice.from_dict(_item) for _item in obj.get("invoices")] if obj.get("invoices") is not None else None
        })
        return _obj

