# coding: utf-8

"""
    Empire - Platform API

    OpenAPI specification for the Platform REST API of Empire  **System Time:** Europe/Amsterdam  **General data formats:**   * _capacity values_ => kW (integers)   * _dates and local times_ => System Time   * _currencies_ => EUR   # noqa: E501

    The version of the OpenAPI document: 0.178.2
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json



from pydantic import BaseModel, Field, constr, validator
from empire_platform_api_public_client.models.organisation_market_settings_gb_nomination_settings import OrganisationMarketSettingsGbNominationSettings
from empire_platform_api_public_client.models.organisation_market_settings_nl_nomination_settings import OrganisationMarketSettingsNlNominationSettings

class OrganisationMarketSettings(BaseModel):
    """
    OrganisationMarketSettings
    """
    eic_code: constr(strict=True) = Field(..., alias="eicCode")
    gb_nomination_settings: OrganisationMarketSettingsGbNominationSettings = Field(..., alias="gbNominationSettings")
    nl_nomination_settings: OrganisationMarketSettingsNlNominationSettings = Field(..., alias="nlNominationSettings")
    __properties = ["eicCode", "gbNominationSettings", "nlNominationSettings"]

    # @validator('eic_code')
    def eic_code_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^([0-9]|[A-Z]|-){16}$", value):
            raise ValueError(r"must validate the regular expression /^([0-9]|[A-Z]|-){16}$/")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> OrganisationMarketSettings:
        """Create an instance of OrganisationMarketSettings from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of gb_nomination_settings
        if self.gb_nomination_settings:
            _dict['gbNominationSettings'] = self.gb_nomination_settings.to_dict()
        # override the default output from pydantic by calling `to_dict()` of nl_nomination_settings
        if self.nl_nomination_settings:
            _dict['nlNominationSettings'] = self.nl_nomination_settings.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> OrganisationMarketSettings:
        """Create an instance of OrganisationMarketSettings from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return OrganisationMarketSettings.parse_obj(obj)

        _obj = OrganisationMarketSettings.parse_obj({
            "eic_code": obj.get("eicCode"),
            "gb_nomination_settings": OrganisationMarketSettingsGbNominationSettings.from_dict(obj.get("gbNominationSettings")) if obj.get("gbNominationSettings") is not None else None,
            "nl_nomination_settings": OrganisationMarketSettingsNlNominationSettings.from_dict(obj.get("nlNominationSettings")) if obj.get("nlNominationSettings") is not None else None
        })
        return _obj

