# coding: utf-8

"""
    Empire - Platform API

    OpenAPI specification for the Platform REST API of Empire  **System Time:** Europe/Amsterdam  **General data formats:**   * _capacity values_ => kW (integers)   * _dates and local times_ => System Time   * _currencies_ => EUR   # noqa: E501

    The version of the OpenAPI document: 0.178.2
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


import re  # noqa: F401
import io
import warnings

from pydantic import validate_arguments, ValidationError
from typing_extensions import Annotated

from datetime import date

from pydantic import Field, StrictStr, conlist

from typing import List, Optional

from empire_platform_api_public_client.models.auction_intra_day_product_type import AuctionIntraDayProductType
from empire_platform_api_public_client.models.auction_timescale import AuctionTimescale
from empire_platform_api_public_client.models.border_direction import BorderDirection
from empire_platform_api_public_client.models.buy_now_day_ahead_offer_sort_by import BuyNowDayAheadOfferSortBy
from empire_platform_api_public_client.models.buy_now_offer import BuyNowOffer
from empire_platform_api_public_client.models.buy_now_offer_status import BuyNowOfferStatus

from empire_platform_api_public_client.api_client import ApiClient
from empire_platform_api_public_client.api_response import ApiResponse
from empire_platform_api_public_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class BuyNowOffersApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def get_buy_now_offers(self, delivery_day : date, timescale : Annotated[AuctionTimescale, Field(..., description="Auction Timescale")], border_direction : Annotated[BorderDirection, Field(..., description="Border Direction")], statuses : conlist(BuyNowOfferStatus), sort_by : BuyNowDayAheadOfferSortBy, product_type : Annotated[Optional[AuctionIntraDayProductType], Field(description="Auction Product Type (ID only, optional)")] = None, **kwargs) -> List[BuyNowOffer]:  # noqa: E501
        """get_buy_now_offers  # noqa: E501

        Fetch a filterable, sortable list of Buy Now Offers  ---  __Requires Permission:__ (at least one)   * `VIEW_ANY_BUY_NOW_OFFERS`   * `VIEW_OWN_BUY_NOW_OFFERS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_buy_now_offers(delivery_day, timescale, border_direction, statuses, sort_by, product_type, async_req=True)
        >>> result = thread.get()

        :param delivery_day: (required)
        :type delivery_day: date
        :param timescale: Auction Timescale (required)
        :type timescale: AuctionTimescale
        :param border_direction: Border Direction (required)
        :type border_direction: BorderDirection
        :param statuses: (required)
        :type statuses: List[BuyNowOfferStatus]
        :param sort_by: (required)
        :type sort_by: BuyNowDayAheadOfferSortBy
        :param product_type: Auction Product Type (ID only, optional)
        :type product_type: AuctionIntraDayProductType
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: List[BuyNowOffer]
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_buy_now_offers_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_buy_now_offers_with_http_info(delivery_day, timescale, border_direction, statuses, sort_by, product_type, **kwargs)  # noqa: E501

    @validate_arguments
    def get_buy_now_offers_with_http_info(self, delivery_day : date, timescale : Annotated[AuctionTimescale, Field(..., description="Auction Timescale")], border_direction : Annotated[BorderDirection, Field(..., description="Border Direction")], statuses : conlist(BuyNowOfferStatus), sort_by : BuyNowDayAheadOfferSortBy, product_type : Annotated[Optional[AuctionIntraDayProductType], Field(description="Auction Product Type (ID only, optional)")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """get_buy_now_offers  # noqa: E501

        Fetch a filterable, sortable list of Buy Now Offers  ---  __Requires Permission:__ (at least one)   * `VIEW_ANY_BUY_NOW_OFFERS`   * `VIEW_OWN_BUY_NOW_OFFERS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_buy_now_offers_with_http_info(delivery_day, timescale, border_direction, statuses, sort_by, product_type, async_req=True)
        >>> result = thread.get()

        :param delivery_day: (required)
        :type delivery_day: date
        :param timescale: Auction Timescale (required)
        :type timescale: AuctionTimescale
        :param border_direction: Border Direction (required)
        :type border_direction: BorderDirection
        :param statuses: (required)
        :type statuses: List[BuyNowOfferStatus]
        :param sort_by: (required)
        :type sort_by: BuyNowDayAheadOfferSortBy
        :param product_type: Auction Product Type (ID only, optional)
        :type product_type: AuctionIntraDayProductType
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(List[BuyNowOffer], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'delivery_day',
            'timescale',
            'border_direction',
            'statuses',
            'sort_by',
            'product_type'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_buy_now_offers" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('delivery_day') is not None:  # noqa: E501
            if isinstance(_params['delivery_day'], datetime):
                _query_params.append(('deliveryDay', _params['delivery_day'].strftime(self.api_client.configuration.date_format)))
            else:
                _query_params.append(('deliveryDay', _params['delivery_day']))

        if _params.get('timescale') is not None:  # noqa: E501
            _query_params.append(('timescale', _params['timescale'].value))

        if _params.get('border_direction') is not None:  # noqa: E501
            _query_params.append(('borderDirection', _params['border_direction'].value))

        if _params.get('statuses') is not None:  # noqa: E501
            _query_params.append(('statuses', _params['statuses']))
            _collection_formats['statuses'] = 'multi'

        if _params.get('sort_by') is not None:  # noqa: E501
            _query_params.append(('sortBy', _params['sort_by'].value))

        if _params.get('product_type') is not None:  # noqa: E501
            _query_params.append(('productType', _params['product_type'].value))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKey', 'AuthToken']  # noqa: E501

        _response_types_map = {
            '200': "List[BuyNowOffer]",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '409': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/v1/buy-now-offers', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def purchase_buy_now_offer(self, id : Annotated[StrictStr, Field(..., description="Internal unique ID of an entity")], **kwargs) -> None:  # noqa: E501
        """purchase_buy_now_offer  # noqa: E501

        Purchase an existing Buy Now Offer by its identifier  ---  __Requires Permission:__ (at least one)   * `PURCHASE_BUY_NOW_OFFERS`  __Generates Audit Log Entry:__ `PURCHASE_BUY_NOW_OFFER`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.purchase_buy_now_offer(id, async_req=True)
        >>> result = thread.get()

        :param id: Internal unique ID of an entity (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the purchase_buy_now_offer_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.purchase_buy_now_offer_with_http_info(id, **kwargs)  # noqa: E501

    @validate_arguments
    def purchase_buy_now_offer_with_http_info(self, id : Annotated[StrictStr, Field(..., description="Internal unique ID of an entity")], **kwargs) -> ApiResponse:  # noqa: E501
        """purchase_buy_now_offer  # noqa: E501

        Purchase an existing Buy Now Offer by its identifier  ---  __Requires Permission:__ (at least one)   * `PURCHASE_BUY_NOW_OFFERS`  __Generates Audit Log Entry:__ `PURCHASE_BUY_NOW_OFFER`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.purchase_buy_now_offer_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: Internal unique ID of an entity (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        _params = locals()

        _all_params = [
            'id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method purchase_buy_now_offer" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id']:
            _path_params['id'] = _params['id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKey', 'AuthToken']  # noqa: E501

        _response_types_map = {}

        return self.api_client.call_api(
            '/v1/buy-now-offers/{id}/purchase', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
