# coding: utf-8

"""
    Patch API V1

    The core API used to integrate with Patch's service  # noqa: E501

    The version of the OpenAPI document: v1
    Contact: developers@usepatch.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from patch_api.configuration import Configuration


class Order(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        "id": "str",
        "mass_g": "int",
        "production": "bool",
        "state": "str",
        "allocation_state": "str",
        "price_cents_usd": "str",
        "patch_fee_cents_usd": "str",
        "allocations": "list[Allocation]",
        "metadata": "object",
    }

    attribute_map = {
        "id": "id",
        "mass_g": "mass_g",
        "production": "production",
        "state": "state",
        "allocation_state": "allocation_state",
        "price_cents_usd": "price_cents_usd",
        "patch_fee_cents_usd": "patch_fee_cents_usd",
        "allocations": "allocations",
        "metadata": "metadata",
    }

    def __init__(
        self,
        id=None,
        mass_g=None,
        production=None,
        state=None,
        allocation_state=None,
        price_cents_usd=None,
        patch_fee_cents_usd=None,
        allocations=None,
        metadata=None,
        local_vars_configuration=None,
    ):  # noqa: E501
        """Order - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._mass_g = None
        self._production = None
        self._state = None
        self._allocation_state = None
        self._price_cents_usd = None
        self._patch_fee_cents_usd = None
        self._allocations = None
        self._metadata = None
        self.discriminator = None

        self.id = id
        self.mass_g = mass_g
        self.production = production
        self.state = state
        self.allocation_state = allocation_state
        self.price_cents_usd = price_cents_usd
        self.patch_fee_cents_usd = patch_fee_cents_usd
        self.allocations = allocations
        self.metadata = metadata

    @property
    def id(self):
        """Gets the id of this Order.  # noqa: E501

        A unique uid for the record. UIDs will be prepended by ord_prod or ord_test depending on the mode it was created in.  # noqa: E501

        :return: The id of this Order.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Order.

        A unique uid for the record. UIDs will be prepended by ord_prod or ord_test depending on the mode it was created in.  # noqa: E501

        :param id: The id of this Order.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation and id is None
        ):  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def mass_g(self):
        """Gets the mass_g of this Order.  # noqa: E501

        The amount of carbon offsets in grams purchased through this order.  # noqa: E501

        :return: The mass_g of this Order.  # noqa: E501
        :rtype: int
        """
        return self._mass_g

    @mass_g.setter
    def mass_g(self, mass_g):
        """Sets the mass_g of this Order.

        The amount of carbon offsets in grams purchased through this order.  # noqa: E501

        :param mass_g: The mass_g of this Order.  # noqa: E501
        :type: int
        """
        if (
            self.local_vars_configuration.client_side_validation and mass_g is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `mass_g`, must not be `None`"
            )  # noqa: E501
        if (
            self.local_vars_configuration.client_side_validation
            and mass_g is not None
            and mass_g > 2000000000
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `mass_g`, must be a value less than or equal to `2000000000`"
            )  # noqa: E501
        if (
            self.local_vars_configuration.client_side_validation
            and mass_g is not None
            and mass_g < 1
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `mass_g`, must be a value greater than or equal to `1`"
            )  # noqa: E501

        self._mass_g = mass_g

    @property
    def production(self):
        """Gets the production of this Order.  # noqa: E501

        A boolean indicating if this order is a production or test mode order.  # noqa: E501

        :return: The production of this Order.  # noqa: E501
        :rtype: bool
        """
        return self._production

    @production.setter
    def production(self, production):
        """Sets the production of this Order.

        A boolean indicating if this order is a production or test mode order.  # noqa: E501

        :param production: The production of this Order.  # noqa: E501
        :type: bool
        """
        if (
            self.local_vars_configuration.client_side_validation and production is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `production`, must not be `None`"
            )  # noqa: E501

        self._production = production

    @property
    def state(self):
        """Gets the state of this Order.  # noqa: E501

        The current state of the order.  # noqa: E501

        :return: The state of this Order.  # noqa: E501
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this Order.

        The current state of the order.  # noqa: E501

        :param state: The state of this Order.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation and state is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `state`, must not be `None`"
            )  # noqa: E501
        allowed_values = ["draft", "placed", "complete", "cancelled"]  # noqa: E501
        if (
            self.local_vars_configuration.client_side_validation
            and state not in allowed_values
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `state` ({0}), must be one of {1}".format(  # noqa: E501
                    state, allowed_values
                )
            )

        self._state = state

    @property
    def allocation_state(self):
        """Gets the allocation_state of this Order.  # noqa: E501

        The current state of the allocated carbon offsets of the order.  # noqa: E501

        :return: The allocation_state of this Order.  # noqa: E501
        :rtype: str
        """
        return self._allocation_state

    @allocation_state.setter
    def allocation_state(self, allocation_state):
        """Sets the allocation_state of this Order.

        The current state of the allocated carbon offsets of the order.  # noqa: E501

        :param allocation_state: The allocation_state of this Order.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation
            and allocation_state is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `allocation_state`, must not be `None`"
            )  # noqa: E501
        allowed_values = ["pending", "partially_allocated", "allocated"]  # noqa: E501
        if (
            self.local_vars_configuration.client_side_validation
            and allocation_state not in allowed_values
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `allocation_state` ({0}), must be one of {1}".format(  # noqa: E501
                    allocation_state, allowed_values
                )
            )

        self._allocation_state = allocation_state

    @property
    def price_cents_usd(self):
        """Gets the price_cents_usd of this Order.  # noqa: E501

        The total price in cents USD of the carbon offsets purchased through this order.  # noqa: E501

        :return: The price_cents_usd of this Order.  # noqa: E501
        :rtype: str
        """
        return self._price_cents_usd

    @price_cents_usd.setter
    def price_cents_usd(self, price_cents_usd):
        """Sets the price_cents_usd of this Order.

        The total price in cents USD of the carbon offsets purchased through this order.  # noqa: E501

        :param price_cents_usd: The price_cents_usd of this Order.  # noqa: E501
        :type: str
        """

        self._price_cents_usd = price_cents_usd

    @property
    def patch_fee_cents_usd(self):
        """Gets the patch_fee_cents_usd of this Order.  # noqa: E501

        The Patch Fee in cents USD for this order.  # noqa: E501

        :return: The patch_fee_cents_usd of this Order.  # noqa: E501
        :rtype: str
        """
        return self._patch_fee_cents_usd

    @patch_fee_cents_usd.setter
    def patch_fee_cents_usd(self, patch_fee_cents_usd):
        """Sets the patch_fee_cents_usd of this Order.

        The Patch Fee in cents USD for this order.  # noqa: E501

        :param patch_fee_cents_usd: The patch_fee_cents_usd of this Order.  # noqa: E501
        :type: str
        """

        self._patch_fee_cents_usd = patch_fee_cents_usd

    @property
    def allocations(self):
        """Gets the allocations of this Order.  # noqa: E501

        An array containing the inventory allocations for this order.  # noqa: E501

        :return: The allocations of this Order.  # noqa: E501
        :rtype: list[Allocation]
        """
        return self._allocations

    @allocations.setter
    def allocations(self, allocations):
        """Sets the allocations of this Order.

        An array containing the inventory allocations for this order.  # noqa: E501

        :param allocations: The allocations of this Order.  # noqa: E501
        :type: list[Allocation]
        """
        if (
            self.local_vars_configuration.client_side_validation and allocations is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `allocations`, must not be `None`"
            )  # noqa: E501

        self._allocations = allocations

    @property
    def metadata(self):
        """Gets the metadata of this Order.  # noqa: E501

        An optional JSON object containing metadata for this order.  # noqa: E501

        :return: The metadata of this Order.  # noqa: E501
        :rtype: object
        """
        return self._metadata

    @metadata.setter
    def metadata(self, metadata):
        """Sets the metadata of this Order.

        An optional JSON object containing metadata for this order.  # noqa: E501

        :param metadata: The metadata of this Order.  # noqa: E501
        :type: object
        """
        if (
            self.local_vars_configuration.client_side_validation and metadata is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `metadata`, must not be `None`"
            )  # noqa: E501

        self._metadata = metadata

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(
                    map(lambda x: x.to_dict() if hasattr(x, "to_dict") else x, value)
                )
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(
                    map(
                        lambda item: (item[0], item[1].to_dict())
                        if hasattr(item[1], "to_dict")
                        else item,
                        value.items(),
                    )
                )
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Order):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Order):
            return True

        return self.to_dict() != other.to_dict()
