# coding: utf-8

"""
    Looker API 3.0 Reference

    ### Authorization  The Looker API uses Looker **API3** credentials for authorization and access control. Looker admins can create API3 credentials on Looker's **Admin/Users** page. Pass API3 credentials to the **/login** endpoint to obtain a temporary access_token. Include that access_token in the Authorization header of Looker API requests. For details, see [Looker API Authorization](https://looker.com/docs/r/api/authorization)  ### Client SDKs  The Looker API is a RESTful system that should be usable by any programming language capable of making HTTPS requests. Client SDKs for a variety of programming languages can be generated from the Looker API's Swagger JSON metadata to streamline use of the Looker API in your applications. A client SDK for Ruby is available as an example. For more information, see [Looker API Client SDKs](https://looker.com/docs/r/api/client_sdks)  ### Try It Out!  The 'api-docs' page served by the Looker instance includes 'Try It Out!' buttons for each API method. After logging in with API3 credentials, you can use the \"Try It Out!\" buttons to call the API directly from the documentation page to interactively explore API features and responses.  ### Versioning  Future releases of Looker will expand this API release-by-release to securely expose more and more of the core power of Looker to API client applications. API endpoints marked as \"beta\" may receive breaking changes without warning. Stable (non-beta) API endpoints should not receive breaking changes in future releases. For more information, see [Looker API Versioning](https://looker.com/docs/r/api/versioning) 

    OpenAPI spec version: 3.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import os
import sys
import unittest

import swagger_client
from swagger_client.rest import ApiException
from swagger_client.apis.user_api import UserApi


class TestUserApi(unittest.TestCase):
    """ UserApi unit test stubs """

    def setUp(self):
        self.api = swagger_client.apis.user_api.UserApi()

    def tearDown(self):
        pass

    def test_all_user_access_filters(self):
        """
        Test case for all_user_access_filters

        Get All Access Filters
        """
        pass

    def test_all_user_credentials_api3s(self):
        """
        Test case for all_user_credentials_api3s

        Get All API 3 Credentials
        """
        pass

    def test_all_user_credentials_embeds(self):
        """
        Test case for all_user_credentials_embeds

        Get All Embedding Credentials
        """
        pass

    def test_all_user_sessions(self):
        """
        Test case for all_user_sessions

        Get All Web Login Sessions
        """
        pass

    def test_all_users(self):
        """
        Test case for all_users

        Get All Users
        """
        pass

    def test_create_user(self):
        """
        Test case for create_user

        Create User
        """
        pass

    def test_create_user_access_filter(self):
        """
        Test case for create_user_access_filter

        Create Access Filter
        """
        pass

    def test_create_user_credentials_api(self):
        """
        Test case for create_user_credentials_api

        Create API Credential
        """
        pass

    def test_create_user_credentials_api3(self):
        """
        Test case for create_user_credentials_api3

        Create API 3 Credential
        """
        pass

    def test_create_user_credentials_email(self):
        """
        Test case for create_user_credentials_email

        Create Email/Password Credential
        """
        pass

    def test_create_user_credentials_email_password_reset(self):
        """
        Test case for create_user_credentials_email_password_reset

        Create Password Reset Token
        """
        pass

    def test_create_user_credentials_totp(self):
        """
        Test case for create_user_credentials_totp

        Create Two-Factor Credential
        """
        pass

    def test_delete_user(self):
        """
        Test case for delete_user

        Delete User
        """
        pass

    def test_delete_user_access_filter(self):
        """
        Test case for delete_user_access_filter

        Delete Access Filter
        """
        pass

    def test_delete_user_attribute_user_value(self):
        """
        Test case for delete_user_attribute_user_value

        Delete User Attribute User Value
        """
        pass

    def test_delete_user_credentials_api(self):
        """
        Test case for delete_user_credentials_api

        Delete API Credential
        """
        pass

    def test_delete_user_credentials_api3(self):
        """
        Test case for delete_user_credentials_api3

        Delete API 3 Credential
        """
        pass

    def test_delete_user_credentials_email(self):
        """
        Test case for delete_user_credentials_email

        Delete Email/Password Credential
        """
        pass

    def test_delete_user_credentials_embed(self):
        """
        Test case for delete_user_credentials_embed

        Delete Embedding Credential
        """
        pass

    def test_delete_user_credentials_google(self):
        """
        Test case for delete_user_credentials_google

        Delete Google Auth Credential
        """
        pass

    def test_delete_user_credentials_ldap(self):
        """
        Test case for delete_user_credentials_ldap

        Delete LDAP Credential
        """
        pass

    def test_delete_user_credentials_looker_openid(self):
        """
        Test case for delete_user_credentials_looker_openid

        Delete Looker OpenId Credential
        """
        pass

    def test_delete_user_credentials_oidc(self):
        """
        Test case for delete_user_credentials_oidc

        Delete OIDC Auth Credential
        """
        pass

    def test_delete_user_credentials_saml(self):
        """
        Test case for delete_user_credentials_saml

        Delete Saml Auth Credential
        """
        pass

    def test_delete_user_credentials_totp(self):
        """
        Test case for delete_user_credentials_totp

        Delete Two-Factor Credential
        """
        pass

    def test_delete_user_session(self):
        """
        Test case for delete_user_session

        Delete Web Login Session
        """
        pass

    def test_me(self):
        """
        Test case for me

        Get Current User
        """
        pass

    def test_search_users(self):
        """
        Test case for search_users

        Search Users
        """
        pass

    def test_search_users_names(self):
        """
        Test case for search_users_names

        Search User Names
        """
        pass

    def test_set_user_attribute_user_value(self):
        """
        Test case for set_user_attribute_user_value

        Set User Attribute User Value
        """
        pass

    def test_set_user_roles(self):
        """
        Test case for set_user_roles

        Set User Roles
        """
        pass

    def test_update_user(self):
        """
        Test case for update_user

        Update User
        """
        pass

    def test_update_user_access_filter(self):
        """
        Test case for update_user_access_filter

        Update Access Filter
        """
        pass

    def test_update_user_credentials_email(self):
        """
        Test case for update_user_credentials_email

        Update Email/Password Credential
        """
        pass

    def test_user(self):
        """
        Test case for user

        Get User by Id
        """
        pass

    def test_user_access_filter(self):
        """
        Test case for user_access_filter

        Get Access Filter
        """
        pass

    def test_user_attribute_user_values(self):
        """
        Test case for user_attribute_user_values

        Get User Attribute Values
        """
        pass

    def test_user_credentials_api(self):
        """
        Test case for user_credentials_api

        Get API Credential
        """
        pass

    def test_user_credentials_api3(self):
        """
        Test case for user_credentials_api3

        Get API 3 Credential
        """
        pass

    def test_user_credentials_email(self):
        """
        Test case for user_credentials_email

        Get Email/Password Credential
        """
        pass

    def test_user_credentials_embed(self):
        """
        Test case for user_credentials_embed

        Get Embedding Credential
        """
        pass

    def test_user_credentials_google(self):
        """
        Test case for user_credentials_google

        Get Google Auth Credential
        """
        pass

    def test_user_credentials_ldap(self):
        """
        Test case for user_credentials_ldap

        Get LDAP Credential
        """
        pass

    def test_user_credentials_looker_openid(self):
        """
        Test case for user_credentials_looker_openid

        Get Looker OpenId Credential
        """
        pass

    def test_user_credentials_oidc(self):
        """
        Test case for user_credentials_oidc

        Get OIDC Auth Credential
        """
        pass

    def test_user_credentials_saml(self):
        """
        Test case for user_credentials_saml

        Get Saml Auth Credential
        """
        pass

    def test_user_credentials_totp(self):
        """
        Test case for user_credentials_totp

        Get Two-Factor Credential
        """
        pass

    def test_user_for_credential(self):
        """
        Test case for user_for_credential

        Get User by Credential Id
        """
        pass

    def test_user_roles(self):
        """
        Test case for user_roles

        Get User Roles
        """
        pass

    def test_user_session(self):
        """
        Test case for user_session

        Get Web Login Session
        """
        pass


if __name__ == '__main__':
    unittest.main()
