# coding: utf-8

"""
    Looker API 3.0 Reference

    ### Authorization  The Looker API uses Looker **API3** credentials for authorization and access control. Looker admins can create API3 credentials on Looker's **Admin/Users** page. Pass API3 credentials to the **/login** endpoint to obtain a temporary access_token. Include that access_token in the Authorization header of Looker API requests. For details, see [Looker API Authorization](https://looker.com/docs/r/api/authorization)  ### Client SDKs  The Looker API is a RESTful system that should be usable by any programming language capable of making HTTPS requests. Client SDKs for a variety of programming languages can be generated from the Looker API's Swagger JSON metadata to streamline use of the Looker API in your applications. A client SDK for Ruby is available as an example. For more information, see [Looker API Client SDKs](https://looker.com/docs/r/api/client_sdks)  ### Try It Out!  The 'api-docs' page served by the Looker instance includes 'Try It Out!' buttons for each API method. After logging in with API3 credentials, you can use the \"Try It Out!\" buttons to call the API directly from the documentation page to interactively explore API features and responses.  ### Versioning  Future releases of Looker will expand this API release-by-release to securely expose more and more of the core power of Looker to API client applications. API endpoints marked as \"beta\" may receive breaking changes without warning. Stable (non-beta) API endpoints should not receive breaking changes in future releases. For more information, see [Looker API Versioning](https://looker.com/docs/r/api/versioning) 

    OpenAPI spec version: 3.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class UserPublic(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, id=None, first_name=None, last_name=None, display_name=None, avatar_url=None, url=None, can=None):
        """
        UserPublic - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'int',
            'first_name': 'str',
            'last_name': 'str',
            'display_name': 'str',
            'avatar_url': 'str',
            'url': 'str',
            'can': 'dict(str, bool)'
        }

        self.attribute_map = {
            'id': 'id',
            'first_name': 'first_name',
            'last_name': 'last_name',
            'display_name': 'display_name',
            'avatar_url': 'avatar_url',
            'url': 'url',
            'can': 'can'
        }

        self._id = id
        self._first_name = first_name
        self._last_name = last_name
        self._display_name = display_name
        self._avatar_url = avatar_url
        self._url = url
        self._can = can

    @property
    def id(self):
        """
        Gets the id of this UserPublic.
        Unique Id

        :return: The id of this UserPublic.
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this UserPublic.
        Unique Id

        :param id: The id of this UserPublic.
        :type: int
        """

        self._id = id

    @property
    def first_name(self):
        """
        Gets the first_name of this UserPublic.
        First Name

        :return: The first_name of this UserPublic.
        :rtype: str
        """
        return self._first_name

    @first_name.setter
    def first_name(self, first_name):
        """
        Sets the first_name of this UserPublic.
        First Name

        :param first_name: The first_name of this UserPublic.
        :type: str
        """

        self._first_name = first_name

    @property
    def last_name(self):
        """
        Gets the last_name of this UserPublic.
        Last Name

        :return: The last_name of this UserPublic.
        :rtype: str
        """
        return self._last_name

    @last_name.setter
    def last_name(self, last_name):
        """
        Sets the last_name of this UserPublic.
        Last Name

        :param last_name: The last_name of this UserPublic.
        :type: str
        """

        self._last_name = last_name

    @property
    def display_name(self):
        """
        Gets the display_name of this UserPublic.
        Full name for display (available only if both first_name and last_name are set)

        :return: The display_name of this UserPublic.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this UserPublic.
        Full name for display (available only if both first_name and last_name are set)

        :param display_name: The display_name of this UserPublic.
        :type: str
        """

        self._display_name = display_name

    @property
    def avatar_url(self):
        """
        Gets the avatar_url of this UserPublic.
        URL for the avatar image (may be generic)

        :return: The avatar_url of this UserPublic.
        :rtype: str
        """
        return self._avatar_url

    @avatar_url.setter
    def avatar_url(self, avatar_url):
        """
        Sets the avatar_url of this UserPublic.
        URL for the avatar image (may be generic)

        :param avatar_url: The avatar_url of this UserPublic.
        :type: str
        """

        self._avatar_url = avatar_url

    @property
    def url(self):
        """
        Gets the url of this UserPublic.
        Link to get this item

        :return: The url of this UserPublic.
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """
        Sets the url of this UserPublic.
        Link to get this item

        :param url: The url of this UserPublic.
        :type: str
        """

        self._url = url

    @property
    def can(self):
        """
        Gets the can of this UserPublic.
        Operations the current user is able to perform on this object

        :return: The can of this UserPublic.
        :rtype: dict(str, bool)
        """
        return self._can

    @can.setter
    def can(self, can):
        """
        Sets the can of this UserPublic.
        Operations the current user is able to perform on this object

        :param can: The can of this UserPublic.
        :type: dict(str, bool)
        """

        self._can = can

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, UserPublic):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
