# coding: utf-8

"""
    Looker API 3.0 Reference

    ### Authorization  The Looker API uses Looker **API3** credentials for authorization and access control. Looker admins can create API3 credentials on Looker's **Admin/Users** page. Pass API3 credentials to the **/login** endpoint to obtain a temporary access_token. Include that access_token in the Authorization header of Looker API requests. For details, see [Looker API Authorization](https://looker.com/docs/r/api/authorization)  ### Client SDKs  The Looker API is a RESTful system that should be usable by any programming language capable of making HTTPS requests. Client SDKs for a variety of programming languages can be generated from the Looker API's Swagger JSON metadata to streamline use of the Looker API in your applications. A client SDK for Ruby is available as an example. For more information, see [Looker API Client SDKs](https://looker.com/docs/r/api/client_sdks)  ### Try It Out!  The 'api-docs' page served by the Looker instance includes 'Try It Out!' buttons for each API method. After logging in with API3 credentials, you can use the \"Try It Out!\" buttons to call the API directly from the documentation page to interactively explore API features and responses.  ### Versioning  Future releases of Looker will expand this API release-by-release to securely expose more and more of the core power of Looker to API client applications. API endpoints marked as \"beta\" may receive breaking changes without warning. Stable (non-beta) API endpoints should not receive breaking changes in future releases. For more information, see [Looker API Versioning](https://looker.com/docs/r/api/versioning) 

    OpenAPI spec version: 3.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class SqlQuery(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, slug=None, last_runtime=None, run_count=None, browser_limit=None, sql=None, last_run_at=None, connection=None, model_name=None, creator=None, explore_url=None, plaintext=None, can=None):
        """
        SqlQuery - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'slug': 'str',
            'last_runtime': 'float',
            'run_count': 'int',
            'browser_limit': 'int',
            'sql': 'str',
            'last_run_at': 'str',
            'connection': 'DBConnectionBase',
            'model_name': 'str',
            'creator': 'UserPublic',
            'explore_url': 'str',
            'plaintext': 'bool',
            'can': 'dict(str, bool)'
        }

        self.attribute_map = {
            'slug': 'slug',
            'last_runtime': 'last_runtime',
            'run_count': 'run_count',
            'browser_limit': 'browser_limit',
            'sql': 'sql',
            'last_run_at': 'last_run_at',
            'connection': 'connection',
            'model_name': 'model_name',
            'creator': 'creator',
            'explore_url': 'explore_url',
            'plaintext': 'plaintext',
            'can': 'can'
        }

        self._slug = slug
        self._last_runtime = last_runtime
        self._run_count = run_count
        self._browser_limit = browser_limit
        self._sql = sql
        self._last_run_at = last_run_at
        self._connection = connection
        self._model_name = model_name
        self._creator = creator
        self._explore_url = explore_url
        self._plaintext = plaintext
        self._can = can

    @property
    def slug(self):
        """
        Gets the slug of this SqlQuery.
        The identifier of the SQL query

        :return: The slug of this SqlQuery.
        :rtype: str
        """
        return self._slug

    @slug.setter
    def slug(self, slug):
        """
        Sets the slug of this SqlQuery.
        The identifier of the SQL query

        :param slug: The slug of this SqlQuery.
        :type: str
        """

        self._slug = slug

    @property
    def last_runtime(self):
        """
        Gets the last_runtime of this SqlQuery.
        Number of seconds this query took to run the most recent time it was run

        :return: The last_runtime of this SqlQuery.
        :rtype: float
        """
        return self._last_runtime

    @last_runtime.setter
    def last_runtime(self, last_runtime):
        """
        Sets the last_runtime of this SqlQuery.
        Number of seconds this query took to run the most recent time it was run

        :param last_runtime: The last_runtime of this SqlQuery.
        :type: float
        """

        self._last_runtime = last_runtime

    @property
    def run_count(self):
        """
        Gets the run_count of this SqlQuery.
        Number of times this query has been run

        :return: The run_count of this SqlQuery.
        :rtype: int
        """
        return self._run_count

    @run_count.setter
    def run_count(self, run_count):
        """
        Sets the run_count of this SqlQuery.
        Number of times this query has been run

        :param run_count: The run_count of this SqlQuery.
        :type: int
        """

        self._run_count = run_count

    @property
    def browser_limit(self):
        """
        Gets the browser_limit of this SqlQuery.
        Maximum number of rows this query will display on the SQL Runner page

        :return: The browser_limit of this SqlQuery.
        :rtype: int
        """
        return self._browser_limit

    @browser_limit.setter
    def browser_limit(self, browser_limit):
        """
        Sets the browser_limit of this SqlQuery.
        Maximum number of rows this query will display on the SQL Runner page

        :param browser_limit: The browser_limit of this SqlQuery.
        :type: int
        """

        self._browser_limit = browser_limit

    @property
    def sql(self):
        """
        Gets the sql of this SqlQuery.
        SQL query text

        :return: The sql of this SqlQuery.
        :rtype: str
        """
        return self._sql

    @sql.setter
    def sql(self, sql):
        """
        Sets the sql of this SqlQuery.
        SQL query text

        :param sql: The sql of this SqlQuery.
        :type: str
        """

        self._sql = sql

    @property
    def last_run_at(self):
        """
        Gets the last_run_at of this SqlQuery.
        The most recent time this query was run

        :return: The last_run_at of this SqlQuery.
        :rtype: str
        """
        return self._last_run_at

    @last_run_at.setter
    def last_run_at(self, last_run_at):
        """
        Sets the last_run_at of this SqlQuery.
        The most recent time this query was run

        :param last_run_at: The last_run_at of this SqlQuery.
        :type: str
        """

        self._last_run_at = last_run_at

    @property
    def connection(self):
        """
        Gets the connection of this SqlQuery.
        Connection this query uses

        :return: The connection of this SqlQuery.
        :rtype: DBConnectionBase
        """
        return self._connection

    @connection.setter
    def connection(self, connection):
        """
        Sets the connection of this SqlQuery.
        Connection this query uses

        :param connection: The connection of this SqlQuery.
        :type: DBConnectionBase
        """

        self._connection = connection

    @property
    def model_name(self):
        """
        Gets the model_name of this SqlQuery.
        Model name this query uses

        :return: The model_name of this SqlQuery.
        :rtype: str
        """
        return self._model_name

    @model_name.setter
    def model_name(self, model_name):
        """
        Sets the model_name of this SqlQuery.
        Model name this query uses

        :param model_name: The model_name of this SqlQuery.
        :type: str
        """

        self._model_name = model_name

    @property
    def creator(self):
        """
        Gets the creator of this SqlQuery.
        User who created this SQL query

        :return: The creator of this SqlQuery.
        :rtype: UserPublic
        """
        return self._creator

    @creator.setter
    def creator(self, creator):
        """
        Sets the creator of this SqlQuery.
        User who created this SQL query

        :param creator: The creator of this SqlQuery.
        :type: UserPublic
        """

        self._creator = creator

    @property
    def explore_url(self):
        """
        Gets the explore_url of this SqlQuery.
        Explore page URL for this SQL query

        :return: The explore_url of this SqlQuery.
        :rtype: str
        """
        return self._explore_url

    @explore_url.setter
    def explore_url(self, explore_url):
        """
        Sets the explore_url of this SqlQuery.
        Explore page URL for this SQL query

        :param explore_url: The explore_url of this SqlQuery.
        :type: str
        """

        self._explore_url = explore_url

    @property
    def plaintext(self):
        """
        Gets the plaintext of this SqlQuery.
        Should this query be rendered as plain text

        :return: The plaintext of this SqlQuery.
        :rtype: bool
        """
        return self._plaintext

    @plaintext.setter
    def plaintext(self, plaintext):
        """
        Sets the plaintext of this SqlQuery.
        Should this query be rendered as plain text

        :param plaintext: The plaintext of this SqlQuery.
        :type: bool
        """

        self._plaintext = plaintext

    @property
    def can(self):
        """
        Gets the can of this SqlQuery.
        Operations the current user is able to perform on this object

        :return: The can of this SqlQuery.
        :rtype: dict(str, bool)
        """
        return self._can

    @can.setter
    def can(self, can):
        """
        Sets the can of this SqlQuery.
        Operations the current user is able to perform on this object

        :param can: The can of this SqlQuery.
        :type: dict(str, bool)
        """

        self._can = can

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, SqlQuery):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
