# coding: utf-8

"""
    Looker API 3.0 Reference

    ### Authorization  The Looker API uses Looker **API3** credentials for authorization and access control. Looker admins can create API3 credentials on Looker's **Admin/Users** page. Pass API3 credentials to the **/login** endpoint to obtain a temporary access_token. Include that access_token in the Authorization header of Looker API requests. For details, see [Looker API Authorization](https://looker.com/docs/r/api/authorization)  ### Client SDKs  The Looker API is a RESTful system that should be usable by any programming language capable of making HTTPS requests. Client SDKs for a variety of programming languages can be generated from the Looker API's Swagger JSON metadata to streamline use of the Looker API in your applications. A client SDK for Ruby is available as an example. For more information, see [Looker API Client SDKs](https://looker.com/docs/r/api/client_sdks)  ### Try It Out!  The 'api-docs' page served by the Looker instance includes 'Try It Out!' buttons for each API method. After logging in with API3 credentials, you can use the \"Try It Out!\" buttons to call the API directly from the documentation page to interactively explore API features and responses.  ### Versioning  Future releases of Looker will expand this API release-by-release to securely expose more and more of the core power of Looker to API client applications. API endpoints marked as \"beta\" may receive breaking changes without warning. Stable (non-beta) API endpoints should not receive breaking changes in future releases. For more information, see [Looker API Versioning](https://looker.com/docs/r/api/versioning) 

    OpenAPI spec version: 3.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class SpaceBase(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, id=None, content_metadata_id=None, creator_id=None, name=None, is_personal=None, is_personal_descendant=None, is_shared_root=None, is_users_root=None, is_root=None, is_user_root=None, is_embed=None, is_embed_shared_root=None, is_embed_users_root=None, external_id=None, can=None):
        """
        SpaceBase - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'content_metadata_id': 'int',
            'creator_id': 'int',
            'name': 'str',
            'is_personal': 'bool',
            'is_personal_descendant': 'bool',
            'is_shared_root': 'bool',
            'is_users_root': 'bool',
            'is_root': 'bool',
            'is_user_root': 'bool',
            'is_embed': 'bool',
            'is_embed_shared_root': 'bool',
            'is_embed_users_root': 'bool',
            'external_id': 'str',
            'can': 'dict(str, bool)'
        }

        self.attribute_map = {
            'id': 'id',
            'content_metadata_id': 'content_metadata_id',
            'creator_id': 'creator_id',
            'name': 'name',
            'is_personal': 'is_personal',
            'is_personal_descendant': 'is_personal_descendant',
            'is_shared_root': 'is_shared_root',
            'is_users_root': 'is_users_root',
            'is_root': 'is_root',
            'is_user_root': 'is_user_root',
            'is_embed': 'is_embed',
            'is_embed_shared_root': 'is_embed_shared_root',
            'is_embed_users_root': 'is_embed_users_root',
            'external_id': 'external_id',
            'can': 'can'
        }

        self._id = id
        self._content_metadata_id = content_metadata_id
        self._creator_id = creator_id
        self._name = name
        self._is_personal = is_personal
        self._is_personal_descendant = is_personal_descendant
        self._is_shared_root = is_shared_root
        self._is_users_root = is_users_root
        self._is_root = is_root
        self._is_user_root = is_user_root
        self._is_embed = is_embed
        self._is_embed_shared_root = is_embed_shared_root
        self._is_embed_users_root = is_embed_users_root
        self._external_id = external_id
        self._can = can

    @property
    def id(self):
        """
        Gets the id of this SpaceBase.
        Unique Id

        :return: The id of this SpaceBase.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this SpaceBase.
        Unique Id

        :param id: The id of this SpaceBase.
        :type: str
        """

        self._id = id

    @property
    def content_metadata_id(self):
        """
        Gets the content_metadata_id of this SpaceBase.
        Id of content metadata

        :return: The content_metadata_id of this SpaceBase.
        :rtype: int
        """
        return self._content_metadata_id

    @content_metadata_id.setter
    def content_metadata_id(self, content_metadata_id):
        """
        Sets the content_metadata_id of this SpaceBase.
        Id of content metadata

        :param content_metadata_id: The content_metadata_id of this SpaceBase.
        :type: int
        """

        self._content_metadata_id = content_metadata_id

    @property
    def creator_id(self):
        """
        Gets the creator_id of this SpaceBase.
        User Id of Creator

        :return: The creator_id of this SpaceBase.
        :rtype: int
        """
        return self._creator_id

    @creator_id.setter
    def creator_id(self, creator_id):
        """
        Sets the creator_id of this SpaceBase.
        User Id of Creator

        :param creator_id: The creator_id of this SpaceBase.
        :type: int
        """

        self._creator_id = creator_id

    @property
    def name(self):
        """
        Gets the name of this SpaceBase.
        Unique Name

        :return: The name of this SpaceBase.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this SpaceBase.
        Unique Name

        :param name: The name of this SpaceBase.
        :type: str
        """

        self._name = name

    @property
    def is_personal(self):
        """
        Gets the is_personal of this SpaceBase.
        Space is a user's personal space

        :return: The is_personal of this SpaceBase.
        :rtype: bool
        """
        return self._is_personal

    @is_personal.setter
    def is_personal(self, is_personal):
        """
        Sets the is_personal of this SpaceBase.
        Space is a user's personal space

        :param is_personal: The is_personal of this SpaceBase.
        :type: bool
        """

        self._is_personal = is_personal

    @property
    def is_personal_descendant(self):
        """
        Gets the is_personal_descendant of this SpaceBase.
        Space is descendant of a user's personal space

        :return: The is_personal_descendant of this SpaceBase.
        :rtype: bool
        """
        return self._is_personal_descendant

    @is_personal_descendant.setter
    def is_personal_descendant(self, is_personal_descendant):
        """
        Sets the is_personal_descendant of this SpaceBase.
        Space is descendant of a user's personal space

        :param is_personal_descendant: The is_personal_descendant of this SpaceBase.
        :type: bool
        """

        self._is_personal_descendant = is_personal_descendant

    @property
    def is_shared_root(self):
        """
        Gets the is_shared_root of this SpaceBase.
        Space is the root shared space

        :return: The is_shared_root of this SpaceBase.
        :rtype: bool
        """
        return self._is_shared_root

    @is_shared_root.setter
    def is_shared_root(self, is_shared_root):
        """
        Sets the is_shared_root of this SpaceBase.
        Space is the root shared space

        :param is_shared_root: The is_shared_root of this SpaceBase.
        :type: bool
        """

        self._is_shared_root = is_shared_root

    @property
    def is_users_root(self):
        """
        Gets the is_users_root of this SpaceBase.
        Space is the root user space

        :return: The is_users_root of this SpaceBase.
        :rtype: bool
        """
        return self._is_users_root

    @is_users_root.setter
    def is_users_root(self, is_users_root):
        """
        Sets the is_users_root of this SpaceBase.
        Space is the root user space

        :param is_users_root: The is_users_root of this SpaceBase.
        :type: bool
        """

        self._is_users_root = is_users_root

    @property
    def is_root(self):
        """
        Gets the is_root of this SpaceBase.
        (DEPRECATED) Space is the root shared space (alias of is_shared_root)

        :return: The is_root of this SpaceBase.
        :rtype: bool
        """
        return self._is_root

    @is_root.setter
    def is_root(self, is_root):
        """
        Sets the is_root of this SpaceBase.
        (DEPRECATED) Space is the root shared space (alias of is_shared_root)

        :param is_root: The is_root of this SpaceBase.
        :type: bool
        """

        self._is_root = is_root

    @property
    def is_user_root(self):
        """
        Gets the is_user_root of this SpaceBase.
        (DEPRECATED) Space is the root user space (alias of is_users_root

        :return: The is_user_root of this SpaceBase.
        :rtype: bool
        """
        return self._is_user_root

    @is_user_root.setter
    def is_user_root(self, is_user_root):
        """
        Sets the is_user_root of this SpaceBase.
        (DEPRECATED) Space is the root user space (alias of is_users_root

        :param is_user_root: The is_user_root of this SpaceBase.
        :type: bool
        """

        self._is_user_root = is_user_root

    @property
    def is_embed(self):
        """
        Gets the is_embed of this SpaceBase.
        Space is an embed space

        :return: The is_embed of this SpaceBase.
        :rtype: bool
        """
        return self._is_embed

    @is_embed.setter
    def is_embed(self, is_embed):
        """
        Sets the is_embed of this SpaceBase.
        Space is an embed space

        :param is_embed: The is_embed of this SpaceBase.
        :type: bool
        """

        self._is_embed = is_embed

    @property
    def is_embed_shared_root(self):
        """
        Gets the is_embed_shared_root of this SpaceBase.
        Space is the root embed shared space

        :return: The is_embed_shared_root of this SpaceBase.
        :rtype: bool
        """
        return self._is_embed_shared_root

    @is_embed_shared_root.setter
    def is_embed_shared_root(self, is_embed_shared_root):
        """
        Sets the is_embed_shared_root of this SpaceBase.
        Space is the root embed shared space

        :param is_embed_shared_root: The is_embed_shared_root of this SpaceBase.
        :type: bool
        """

        self._is_embed_shared_root = is_embed_shared_root

    @property
    def is_embed_users_root(self):
        """
        Gets the is_embed_users_root of this SpaceBase.
        Space is the root embed users space

        :return: The is_embed_users_root of this SpaceBase.
        :rtype: bool
        """
        return self._is_embed_users_root

    @is_embed_users_root.setter
    def is_embed_users_root(self, is_embed_users_root):
        """
        Sets the is_embed_users_root of this SpaceBase.
        Space is the root embed users space

        :param is_embed_users_root: The is_embed_users_root of this SpaceBase.
        :type: bool
        """

        self._is_embed_users_root = is_embed_users_root

    @property
    def external_id(self):
        """
        Gets the external_id of this SpaceBase.
        Embedder's Id if this space was autogenerated as an embedding shared space via 'external_group_id' in an SSO embed login

        :return: The external_id of this SpaceBase.
        :rtype: str
        """
        return self._external_id

    @external_id.setter
    def external_id(self, external_id):
        """
        Sets the external_id of this SpaceBase.
        Embedder's Id if this space was autogenerated as an embedding shared space via 'external_group_id' in an SSO embed login

        :param external_id: The external_id of this SpaceBase.
        :type: str
        """

        self._external_id = external_id

    @property
    def can(self):
        """
        Gets the can of this SpaceBase.
        Operations the current user is able to perform on this object

        :return: The can of this SpaceBase.
        :rtype: dict(str, bool)
        """
        return self._can

    @can.setter
    def can(self, can):
        """
        Sets the can of this SpaceBase.
        Operations the current user is able to perform on this object

        :param can: The can of this SpaceBase.
        :type: dict(str, bool)
        """

        self._can = can

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, SpaceBase):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
