# coding: utf-8

"""
    Looker API 3.0 Reference

    ### Authorization  The Looker API uses Looker **API3** credentials for authorization and access control. Looker admins can create API3 credentials on Looker's **Admin/Users** page. Pass API3 credentials to the **/login** endpoint to obtain a temporary access_token. Include that access_token in the Authorization header of Looker API requests. For details, see [Looker API Authorization](https://looker.com/docs/r/api/authorization)  ### Client SDKs  The Looker API is a RESTful system that should be usable by any programming language capable of making HTTPS requests. Client SDKs for a variety of programming languages can be generated from the Looker API's Swagger JSON metadata to streamline use of the Looker API in your applications. A client SDK for Ruby is available as an example. For more information, see [Looker API Client SDKs](https://looker.com/docs/r/api/client_sdks)  ### Try It Out!  The 'api-docs' page served by the Looker instance includes 'Try It Out!' buttons for each API method. After logging in with API3 credentials, you can use the \"Try It Out!\" buttons to call the API directly from the documentation page to interactively explore API features and responses.  ### Versioning  Future releases of Looker will expand this API release-by-release to securely expose more and more of the core power of Looker to API client applications. API endpoints marked as \"beta\" may receive breaking changes without warning. Stable (non-beta) API endpoints should not receive breaking changes in future releases. For more information, see [Looker API Versioning](https://looker.com/docs/r/api/versioning) 

    OpenAPI spec version: 3.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ScheduledPlan(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, id=None, name=None, created_at=None, updated_at=None, title=None, user_id=None, user=None, run_as_recipient=None, enabled=None, next_run_at=None, last_run_at=None, look_id=None, dashboard_id=None, lookml_dashboard_id=None, filters_string=None, dashboard_filters=None, require_results=None, require_no_results=None, require_change=None, send_all_results=None, crontab=None, datagroup=None, timezone=None, query_id=None, scheduled_plan_destination=None, run_once=None, include_links=None, can=None):
        """
        ScheduledPlan - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'int',
            'name': 'str',
            'created_at': 'datetime',
            'updated_at': 'datetime',
            'title': 'str',
            'user_id': 'int',
            'user': 'UserPublic',
            'run_as_recipient': 'bool',
            'enabled': 'bool',
            'next_run_at': 'datetime',
            'last_run_at': 'datetime',
            'look_id': 'int',
            'dashboard_id': 'int',
            'lookml_dashboard_id': 'str',
            'filters_string': 'str',
            'dashboard_filters': 'str',
            'require_results': 'bool',
            'require_no_results': 'bool',
            'require_change': 'bool',
            'send_all_results': 'bool',
            'crontab': 'str',
            'datagroup': 'str',
            'timezone': 'str',
            'query_id': 'str',
            'scheduled_plan_destination': 'list[ScheduledPlanDestination]',
            'run_once': 'bool',
            'include_links': 'bool',
            'can': 'dict(str, bool)'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'created_at': 'created_at',
            'updated_at': 'updated_at',
            'title': 'title',
            'user_id': 'user_id',
            'user': 'user',
            'run_as_recipient': 'run_as_recipient',
            'enabled': 'enabled',
            'next_run_at': 'next_run_at',
            'last_run_at': 'last_run_at',
            'look_id': 'look_id',
            'dashboard_id': 'dashboard_id',
            'lookml_dashboard_id': 'lookml_dashboard_id',
            'filters_string': 'filters_string',
            'dashboard_filters': 'dashboard_filters',
            'require_results': 'require_results',
            'require_no_results': 'require_no_results',
            'require_change': 'require_change',
            'send_all_results': 'send_all_results',
            'crontab': 'crontab',
            'datagroup': 'datagroup',
            'timezone': 'timezone',
            'query_id': 'query_id',
            'scheduled_plan_destination': 'scheduled_plan_destination',
            'run_once': 'run_once',
            'include_links': 'include_links',
            'can': 'can'
        }

        self._id = id
        self._name = name
        self._created_at = created_at
        self._updated_at = updated_at
        self._title = title
        self._user_id = user_id
        self._user = user
        self._run_as_recipient = run_as_recipient
        self._enabled = enabled
        self._next_run_at = next_run_at
        self._last_run_at = last_run_at
        self._look_id = look_id
        self._dashboard_id = dashboard_id
        self._lookml_dashboard_id = lookml_dashboard_id
        self._filters_string = filters_string
        self._dashboard_filters = dashboard_filters
        self._require_results = require_results
        self._require_no_results = require_no_results
        self._require_change = require_change
        self._send_all_results = send_all_results
        self._crontab = crontab
        self._datagroup = datagroup
        self._timezone = timezone
        self._query_id = query_id
        self._scheduled_plan_destination = scheduled_plan_destination
        self._run_once = run_once
        self._include_links = include_links
        self._can = can

    @property
    def id(self):
        """
        Gets the id of this ScheduledPlan.
        Unique Id

        :return: The id of this ScheduledPlan.
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this ScheduledPlan.
        Unique Id

        :param id: The id of this ScheduledPlan.
        :type: int
        """

        self._id = id

    @property
    def name(self):
        """
        Gets the name of this ScheduledPlan.
        Name

        :return: The name of this ScheduledPlan.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this ScheduledPlan.
        Name

        :param name: The name of this ScheduledPlan.
        :type: str
        """

        self._name = name

    @property
    def created_at(self):
        """
        Gets the created_at of this ScheduledPlan.
        Date and time when ScheduledPlan was created

        :return: The created_at of this ScheduledPlan.
        :rtype: datetime
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """
        Sets the created_at of this ScheduledPlan.
        Date and time when ScheduledPlan was created

        :param created_at: The created_at of this ScheduledPlan.
        :type: datetime
        """

        self._created_at = created_at

    @property
    def updated_at(self):
        """
        Gets the updated_at of this ScheduledPlan.
        Date and time when ScheduledPlan was last updated

        :return: The updated_at of this ScheduledPlan.
        :rtype: datetime
        """
        return self._updated_at

    @updated_at.setter
    def updated_at(self, updated_at):
        """
        Sets the updated_at of this ScheduledPlan.
        Date and time when ScheduledPlan was last updated

        :param updated_at: The updated_at of this ScheduledPlan.
        :type: datetime
        """

        self._updated_at = updated_at

    @property
    def title(self):
        """
        Gets the title of this ScheduledPlan.
        Title

        :return: The title of this ScheduledPlan.
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title):
        """
        Sets the title of this ScheduledPlan.
        Title

        :param title: The title of this ScheduledPlan.
        :type: str
        """

        self._title = title

    @property
    def user_id(self):
        """
        Gets the user_id of this ScheduledPlan.
        User Id which owns this ScheduledPlan

        :return: The user_id of this ScheduledPlan.
        :rtype: int
        """
        return self._user_id

    @user_id.setter
    def user_id(self, user_id):
        """
        Sets the user_id of this ScheduledPlan.
        User Id which owns this ScheduledPlan

        :param user_id: The user_id of this ScheduledPlan.
        :type: int
        """

        self._user_id = user_id

    @property
    def user(self):
        """
        Gets the user of this ScheduledPlan.
        User who owns this ScheduledPlan

        :return: The user of this ScheduledPlan.
        :rtype: UserPublic
        """
        return self._user

    @user.setter
    def user(self, user):
        """
        Sets the user of this ScheduledPlan.
        User who owns this ScheduledPlan

        :param user: The user of this ScheduledPlan.
        :type: UserPublic
        """

        self._user = user

    @property
    def run_as_recipient(self):
        """
        Gets the run_as_recipient of this ScheduledPlan.
        Whether schedule is ran as recipient (only applicable for email recipients)

        :return: The run_as_recipient of this ScheduledPlan.
        :rtype: bool
        """
        return self._run_as_recipient

    @run_as_recipient.setter
    def run_as_recipient(self, run_as_recipient):
        """
        Sets the run_as_recipient of this ScheduledPlan.
        Whether schedule is ran as recipient (only applicable for email recipients)

        :param run_as_recipient: The run_as_recipient of this ScheduledPlan.
        :type: bool
        """

        self._run_as_recipient = run_as_recipient

    @property
    def enabled(self):
        """
        Gets the enabled of this ScheduledPlan.
        Whether the ScheduledPlan is enabled

        :return: The enabled of this ScheduledPlan.
        :rtype: bool
        """
        return self._enabled

    @enabled.setter
    def enabled(self, enabled):
        """
        Sets the enabled of this ScheduledPlan.
        Whether the ScheduledPlan is enabled

        :param enabled: The enabled of this ScheduledPlan.
        :type: bool
        """

        self._enabled = enabled

    @property
    def next_run_at(self):
        """
        Gets the next_run_at of this ScheduledPlan.
        When the ScheduledPlan will next run (null if running once)

        :return: The next_run_at of this ScheduledPlan.
        :rtype: datetime
        """
        return self._next_run_at

    @next_run_at.setter
    def next_run_at(self, next_run_at):
        """
        Sets the next_run_at of this ScheduledPlan.
        When the ScheduledPlan will next run (null if running once)

        :param next_run_at: The next_run_at of this ScheduledPlan.
        :type: datetime
        """

        self._next_run_at = next_run_at

    @property
    def last_run_at(self):
        """
        Gets the last_run_at of this ScheduledPlan.
        When the ScheduledPlan was last run

        :return: The last_run_at of this ScheduledPlan.
        :rtype: datetime
        """
        return self._last_run_at

    @last_run_at.setter
    def last_run_at(self, last_run_at):
        """
        Sets the last_run_at of this ScheduledPlan.
        When the ScheduledPlan was last run

        :param last_run_at: The last_run_at of this ScheduledPlan.
        :type: datetime
        """

        self._last_run_at = last_run_at

    @property
    def look_id(self):
        """
        Gets the look_id of this ScheduledPlan.
        Id of a look

        :return: The look_id of this ScheduledPlan.
        :rtype: int
        """
        return self._look_id

    @look_id.setter
    def look_id(self, look_id):
        """
        Sets the look_id of this ScheduledPlan.
        Id of a look

        :param look_id: The look_id of this ScheduledPlan.
        :type: int
        """

        self._look_id = look_id

    @property
    def dashboard_id(self):
        """
        Gets the dashboard_id of this ScheduledPlan.
        Id of a dashboard

        :return: The dashboard_id of this ScheduledPlan.
        :rtype: int
        """
        return self._dashboard_id

    @dashboard_id.setter
    def dashboard_id(self, dashboard_id):
        """
        Sets the dashboard_id of this ScheduledPlan.
        Id of a dashboard

        :param dashboard_id: The dashboard_id of this ScheduledPlan.
        :type: int
        """

        self._dashboard_id = dashboard_id

    @property
    def lookml_dashboard_id(self):
        """
        Gets the lookml_dashboard_id of this ScheduledPlan.
        Id of a LookML dashboard

        :return: The lookml_dashboard_id of this ScheduledPlan.
        :rtype: str
        """
        return self._lookml_dashboard_id

    @lookml_dashboard_id.setter
    def lookml_dashboard_id(self, lookml_dashboard_id):
        """
        Sets the lookml_dashboard_id of this ScheduledPlan.
        Id of a LookML dashboard

        :param lookml_dashboard_id: The lookml_dashboard_id of this ScheduledPlan.
        :type: str
        """

        self._lookml_dashboard_id = lookml_dashboard_id

    @property
    def filters_string(self):
        """
        Gets the filters_string of this ScheduledPlan.
        Query string to run look or dashboard with

        :return: The filters_string of this ScheduledPlan.
        :rtype: str
        """
        return self._filters_string

    @filters_string.setter
    def filters_string(self, filters_string):
        """
        Sets the filters_string of this ScheduledPlan.
        Query string to run look or dashboard with

        :param filters_string: The filters_string of this ScheduledPlan.
        :type: str
        """

        self._filters_string = filters_string

    @property
    def dashboard_filters(self):
        """
        Gets the dashboard_filters of this ScheduledPlan.
        (DEPRECATED) Alias for filters_string field

        :return: The dashboard_filters of this ScheduledPlan.
        :rtype: str
        """
        return self._dashboard_filters

    @dashboard_filters.setter
    def dashboard_filters(self, dashboard_filters):
        """
        Sets the dashboard_filters of this ScheduledPlan.
        (DEPRECATED) Alias for filters_string field

        :param dashboard_filters: The dashboard_filters of this ScheduledPlan.
        :type: str
        """

        self._dashboard_filters = dashboard_filters

    @property
    def require_results(self):
        """
        Gets the require_results of this ScheduledPlan.
        Delivery should occur if running the dashboard or look returns results

        :return: The require_results of this ScheduledPlan.
        :rtype: bool
        """
        return self._require_results

    @require_results.setter
    def require_results(self, require_results):
        """
        Sets the require_results of this ScheduledPlan.
        Delivery should occur if running the dashboard or look returns results

        :param require_results: The require_results of this ScheduledPlan.
        :type: bool
        """

        self._require_results = require_results

    @property
    def require_no_results(self):
        """
        Gets the require_no_results of this ScheduledPlan.
        Delivery should occur if the dashboard look does not return results

        :return: The require_no_results of this ScheduledPlan.
        :rtype: bool
        """
        return self._require_no_results

    @require_no_results.setter
    def require_no_results(self, require_no_results):
        """
        Sets the require_no_results of this ScheduledPlan.
        Delivery should occur if the dashboard look does not return results

        :param require_no_results: The require_no_results of this ScheduledPlan.
        :type: bool
        """

        self._require_no_results = require_no_results

    @property
    def require_change(self):
        """
        Gets the require_change of this ScheduledPlan.
        Delivery should occur if data have changed since the last run

        :return: The require_change of this ScheduledPlan.
        :rtype: bool
        """
        return self._require_change

    @require_change.setter
    def require_change(self, require_change):
        """
        Sets the require_change of this ScheduledPlan.
        Delivery should occur if data have changed since the last run

        :param require_change: The require_change of this ScheduledPlan.
        :type: bool
        """

        self._require_change = require_change

    @property
    def send_all_results(self):
        """
        Gets the send_all_results of this ScheduledPlan.
        Will run an unlimited query and send all results.

        :return: The send_all_results of this ScheduledPlan.
        :rtype: bool
        """
        return self._send_all_results

    @send_all_results.setter
    def send_all_results(self, send_all_results):
        """
        Sets the send_all_results of this ScheduledPlan.
        Will run an unlimited query and send all results.

        :param send_all_results: The send_all_results of this ScheduledPlan.
        :type: bool
        """

        self._send_all_results = send_all_results

    @property
    def crontab(self):
        """
        Gets the crontab of this ScheduledPlan.
        Vixie-Style crontab specification when to run

        :return: The crontab of this ScheduledPlan.
        :rtype: str
        """
        return self._crontab

    @crontab.setter
    def crontab(self, crontab):
        """
        Sets the crontab of this ScheduledPlan.
        Vixie-Style crontab specification when to run

        :param crontab: The crontab of this ScheduledPlan.
        :type: str
        """

        self._crontab = crontab

    @property
    def datagroup(self):
        """
        Gets the datagroup of this ScheduledPlan.
        Name of a datagroup; if specified will run when datagroup triggered (can't be used with cron string)

        :return: The datagroup of this ScheduledPlan.
        :rtype: str
        """
        return self._datagroup

    @datagroup.setter
    def datagroup(self, datagroup):
        """
        Sets the datagroup of this ScheduledPlan.
        Name of a datagroup; if specified will run when datagroup triggered (can't be used with cron string)

        :param datagroup: The datagroup of this ScheduledPlan.
        :type: str
        """

        self._datagroup = datagroup

    @property
    def timezone(self):
        """
        Gets the timezone of this ScheduledPlan.
        Timezone for interpreting the specified crontab (default is Looker instance timezone)

        :return: The timezone of this ScheduledPlan.
        :rtype: str
        """
        return self._timezone

    @timezone.setter
    def timezone(self, timezone):
        """
        Sets the timezone of this ScheduledPlan.
        Timezone for interpreting the specified crontab (default is Looker instance timezone)

        :param timezone: The timezone of this ScheduledPlan.
        :type: str
        """

        self._timezone = timezone

    @property
    def query_id(self):
        """
        Gets the query_id of this ScheduledPlan.
        Query id

        :return: The query_id of this ScheduledPlan.
        :rtype: str
        """
        return self._query_id

    @query_id.setter
    def query_id(self, query_id):
        """
        Sets the query_id of this ScheduledPlan.
        Query id

        :param query_id: The query_id of this ScheduledPlan.
        :type: str
        """

        self._query_id = query_id

    @property
    def scheduled_plan_destination(self):
        """
        Gets the scheduled_plan_destination of this ScheduledPlan.
        Scheduled plan destinations

        :return: The scheduled_plan_destination of this ScheduledPlan.
        :rtype: list[ScheduledPlanDestination]
        """
        return self._scheduled_plan_destination

    @scheduled_plan_destination.setter
    def scheduled_plan_destination(self, scheduled_plan_destination):
        """
        Sets the scheduled_plan_destination of this ScheduledPlan.
        Scheduled plan destinations

        :param scheduled_plan_destination: The scheduled_plan_destination of this ScheduledPlan.
        :type: list[ScheduledPlanDestination]
        """

        self._scheduled_plan_destination = scheduled_plan_destination

    @property
    def run_once(self):
        """
        Gets the run_once of this ScheduledPlan.
        Whether the plan in question should only be run once (usually for testing)

        :return: The run_once of this ScheduledPlan.
        :rtype: bool
        """
        return self._run_once

    @run_once.setter
    def run_once(self, run_once):
        """
        Sets the run_once of this ScheduledPlan.
        Whether the plan in question should only be run once (usually for testing)

        :param run_once: The run_once of this ScheduledPlan.
        :type: bool
        """

        self._run_once = run_once

    @property
    def include_links(self):
        """
        Gets the include_links of this ScheduledPlan.
        Whether links back to Looker should be included in this ScheduledPlan

        :return: The include_links of this ScheduledPlan.
        :rtype: bool
        """
        return self._include_links

    @include_links.setter
    def include_links(self, include_links):
        """
        Sets the include_links of this ScheduledPlan.
        Whether links back to Looker should be included in this ScheduledPlan

        :param include_links: The include_links of this ScheduledPlan.
        :type: bool
        """

        self._include_links = include_links

    @property
    def can(self):
        """
        Gets the can of this ScheduledPlan.
        Operations the current user is able to perform on this object

        :return: The can of this ScheduledPlan.
        :rtype: dict(str, bool)
        """
        return self._can

    @can.setter
    def can(self, can):
        """
        Sets the can of this ScheduledPlan.
        Operations the current user is able to perform on this object

        :param can: The can of this ScheduledPlan.
        :type: dict(str, bool)
        """

        self._can = can

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ScheduledPlan):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
