# coding: utf-8

"""
    Looker API 3.0 Reference

    ### Authorization  The Looker API uses Looker **API3** credentials for authorization and access control. Looker admins can create API3 credentials on Looker's **Admin/Users** page. Pass API3 credentials to the **/login** endpoint to obtain a temporary access_token. Include that access_token in the Authorization header of Looker API requests. For details, see [Looker API Authorization](https://looker.com/docs/r/api/authorization)  ### Client SDKs  The Looker API is a RESTful system that should be usable by any programming language capable of making HTTPS requests. Client SDKs for a variety of programming languages can be generated from the Looker API's Swagger JSON metadata to streamline use of the Looker API in your applications. A client SDK for Ruby is available as an example. For more information, see [Looker API Client SDKs](https://looker.com/docs/r/api/client_sdks)  ### Try It Out!  The 'api-docs' page served by the Looker instance includes 'Try It Out!' buttons for each API method. After logging in with API3 credentials, you can use the \"Try It Out!\" buttons to call the API directly from the documentation page to interactively explore API features and responses.  ### Versioning  Future releases of Looker will expand this API release-by-release to securely expose more and more of the core power of Looker to API client applications. API endpoints marked as \"beta\" may receive breaking changes without warning. Stable (non-beta) API endpoints should not receive breaking changes in future releases. For more information, see [Looker API Versioning](https://looker.com/docs/r/api/versioning) 

    OpenAPI spec version: 3.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class Role(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, id=None, name=None, permission_set=None, permission_set_id=None, model_set=None, model_set_id=None, url=None, users_url=None, can=None):
        """
        Role - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'int',
            'name': 'str',
            'permission_set': 'PermissionSet',
            'permission_set_id': 'int',
            'model_set': 'ModelSet',
            'model_set_id': 'int',
            'url': 'str',
            'users_url': 'str',
            'can': 'dict(str, bool)'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'permission_set': 'permission_set',
            'permission_set_id': 'permission_set_id',
            'model_set': 'model_set',
            'model_set_id': 'model_set_id',
            'url': 'url',
            'users_url': 'users_url',
            'can': 'can'
        }

        self._id = id
        self._name = name
        self._permission_set = permission_set
        self._permission_set_id = permission_set_id
        self._model_set = model_set
        self._model_set_id = model_set_id
        self._url = url
        self._users_url = users_url
        self._can = can

    @property
    def id(self):
        """
        Gets the id of this Role.
        Unique Id

        :return: The id of this Role.
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this Role.
        Unique Id

        :param id: The id of this Role.
        :type: int
        """

        self._id = id

    @property
    def name(self):
        """
        Gets the name of this Role.
        Name of Role

        :return: The name of this Role.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this Role.
        Name of Role

        :param name: The name of this Role.
        :type: str
        """

        self._name = name

    @property
    def permission_set(self):
        """
        Gets the permission_set of this Role.
        (Read only) Permission set

        :return: The permission_set of this Role.
        :rtype: PermissionSet
        """
        return self._permission_set

    @permission_set.setter
    def permission_set(self, permission_set):
        """
        Sets the permission_set of this Role.
        (Read only) Permission set

        :param permission_set: The permission_set of this Role.
        :type: PermissionSet
        """

        self._permission_set = permission_set

    @property
    def permission_set_id(self):
        """
        Gets the permission_set_id of this Role.
        (Write-Only) Id of permission set

        :return: The permission_set_id of this Role.
        :rtype: int
        """
        return self._permission_set_id

    @permission_set_id.setter
    def permission_set_id(self, permission_set_id):
        """
        Sets the permission_set_id of this Role.
        (Write-Only) Id of permission set

        :param permission_set_id: The permission_set_id of this Role.
        :type: int
        """

        self._permission_set_id = permission_set_id

    @property
    def model_set(self):
        """
        Gets the model_set of this Role.
        (Read only) Model set

        :return: The model_set of this Role.
        :rtype: ModelSet
        """
        return self._model_set

    @model_set.setter
    def model_set(self, model_set):
        """
        Sets the model_set of this Role.
        (Read only) Model set

        :param model_set: The model_set of this Role.
        :type: ModelSet
        """

        self._model_set = model_set

    @property
    def model_set_id(self):
        """
        Gets the model_set_id of this Role.
        (Write-Only) Id of model set

        :return: The model_set_id of this Role.
        :rtype: int
        """
        return self._model_set_id

    @model_set_id.setter
    def model_set_id(self, model_set_id):
        """
        Sets the model_set_id of this Role.
        (Write-Only) Id of model set

        :param model_set_id: The model_set_id of this Role.
        :type: int
        """

        self._model_set_id = model_set_id

    @property
    def url(self):
        """
        Gets the url of this Role.
        Link to get this item

        :return: The url of this Role.
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """
        Sets the url of this Role.
        Link to get this item

        :param url: The url of this Role.
        :type: str
        """

        self._url = url

    @property
    def users_url(self):
        """
        Gets the users_url of this Role.
        Link to get list of users with this role

        :return: The users_url of this Role.
        :rtype: str
        """
        return self._users_url

    @users_url.setter
    def users_url(self, users_url):
        """
        Sets the users_url of this Role.
        Link to get list of users with this role

        :param users_url: The users_url of this Role.
        :type: str
        """

        self._users_url = users_url

    @property
    def can(self):
        """
        Gets the can of this Role.
        Operations the current user is able to perform on this object

        :return: The can of this Role.
        :rtype: dict(str, bool)
        """
        return self._can

    @can.setter
    def can(self, can):
        """
        Sets the can of this Role.
        Operations the current user is able to perform on this object

        :param can: The can of this Role.
        :type: dict(str, bool)
        """

        self._can = can

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, Role):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
