# coding: utf-8

"""
    Looker API 3.0 Reference

    ### Authorization  The Looker API uses Looker **API3** credentials for authorization and access control. Looker admins can create API3 credentials on Looker's **Admin/Users** page. Pass API3 credentials to the **/login** endpoint to obtain a temporary access_token. Include that access_token in the Authorization header of Looker API requests. For details, see [Looker API Authorization](https://looker.com/docs/r/api/authorization)  ### Client SDKs  The Looker API is a RESTful system that should be usable by any programming language capable of making HTTPS requests. Client SDKs for a variety of programming languages can be generated from the Looker API's Swagger JSON metadata to streamline use of the Looker API in your applications. A client SDK for Ruby is available as an example. For more information, see [Looker API Client SDKs](https://looker.com/docs/r/api/client_sdks)  ### Try It Out!  The 'api-docs' page served by the Looker instance includes 'Try It Out!' buttons for each API method. After logging in with API3 credentials, you can use the \"Try It Out!\" buttons to call the API directly from the documentation page to interactively explore API features and responses.  ### Versioning  Future releases of Looker will expand this API release-by-release to securely expose more and more of the core power of Looker to API client applications. API endpoints marked as \"beta\" may receive breaking changes without warning. Stable (non-beta) API endpoints should not receive breaking changes in future releases. For more information, see [Looker API Versioning](https://looker.com/docs/r/api/versioning) 

    OpenAPI spec version: 3.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ResultMakerWithIdVisConfigAndDynamicFields(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, id=None, dynamic_fields=None, filterables=None, sorts=None, merge_result_id=None, total=None, query_id=None, query=None, vis_config=None, can=None):
        """
        ResultMakerWithIdVisConfigAndDynamicFields - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'int',
            'dynamic_fields': 'str',
            'filterables': 'list[ResultMakerFilterables]',
            'sorts': 'str',
            'merge_result_id': 'str',
            'total': 'bool',
            'query_id': 'int',
            'query': 'Query',
            'vis_config': 'str',
            'can': 'dict(str, bool)'
        }

        self.attribute_map = {
            'id': 'id',
            'dynamic_fields': 'dynamic_fields',
            'filterables': 'filterables',
            'sorts': 'sorts',
            'merge_result_id': 'merge_result_id',
            'total': 'total',
            'query_id': 'query_id',
            'query': 'query',
            'vis_config': 'vis_config',
            'can': 'can'
        }

        self._id = id
        self._dynamic_fields = dynamic_fields
        self._filterables = filterables
        self._sorts = sorts
        self._merge_result_id = merge_result_id
        self._total = total
        self._query_id = query_id
        self._query = query
        self._vis_config = vis_config
        self._can = can

    @property
    def id(self):
        """
        Gets the id of this ResultMakerWithIdVisConfigAndDynamicFields.
        Unique Id.

        :return: The id of this ResultMakerWithIdVisConfigAndDynamicFields.
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this ResultMakerWithIdVisConfigAndDynamicFields.
        Unique Id.

        :param id: The id of this ResultMakerWithIdVisConfigAndDynamicFields.
        :type: int
        """

        self._id = id

    @property
    def dynamic_fields(self):
        """
        Gets the dynamic_fields of this ResultMakerWithIdVisConfigAndDynamicFields.
        JSON string of dynamic field information.

        :return: The dynamic_fields of this ResultMakerWithIdVisConfigAndDynamicFields.
        :rtype: str
        """
        return self._dynamic_fields

    @dynamic_fields.setter
    def dynamic_fields(self, dynamic_fields):
        """
        Sets the dynamic_fields of this ResultMakerWithIdVisConfigAndDynamicFields.
        JSON string of dynamic field information.

        :param dynamic_fields: The dynamic_fields of this ResultMakerWithIdVisConfigAndDynamicFields.
        :type: str
        """

        self._dynamic_fields = dynamic_fields

    @property
    def filterables(self):
        """
        Gets the filterables of this ResultMakerWithIdVisConfigAndDynamicFields.
        array of items that can be filtered and information about them.

        :return: The filterables of this ResultMakerWithIdVisConfigAndDynamicFields.
        :rtype: list[ResultMakerFilterables]
        """
        return self._filterables

    @filterables.setter
    def filterables(self, filterables):
        """
        Sets the filterables of this ResultMakerWithIdVisConfigAndDynamicFields.
        array of items that can be filtered and information about them.

        :param filterables: The filterables of this ResultMakerWithIdVisConfigAndDynamicFields.
        :type: list[ResultMakerFilterables]
        """

        self._filterables = filterables

    @property
    def sorts(self):
        """
        Gets the sorts of this ResultMakerWithIdVisConfigAndDynamicFields.
        Sorts of the constituent Look, Query, or Merge Query

        :return: The sorts of this ResultMakerWithIdVisConfigAndDynamicFields.
        :rtype: str
        """
        return self._sorts

    @sorts.setter
    def sorts(self, sorts):
        """
        Sets the sorts of this ResultMakerWithIdVisConfigAndDynamicFields.
        Sorts of the constituent Look, Query, or Merge Query

        :param sorts: The sorts of this ResultMakerWithIdVisConfigAndDynamicFields.
        :type: str
        """

        self._sorts = sorts

    @property
    def merge_result_id(self):
        """
        Gets the merge_result_id of this ResultMakerWithIdVisConfigAndDynamicFields.
        ID of merge result if this is a merge_result.

        :return: The merge_result_id of this ResultMakerWithIdVisConfigAndDynamicFields.
        :rtype: str
        """
        return self._merge_result_id

    @merge_result_id.setter
    def merge_result_id(self, merge_result_id):
        """
        Sets the merge_result_id of this ResultMakerWithIdVisConfigAndDynamicFields.
        ID of merge result if this is a merge_result.

        :param merge_result_id: The merge_result_id of this ResultMakerWithIdVisConfigAndDynamicFields.
        :type: str
        """

        self._merge_result_id = merge_result_id

    @property
    def total(self):
        """
        Gets the total of this ResultMakerWithIdVisConfigAndDynamicFields.
        Total of the constituent Look, Query, or Merge Query

        :return: The total of this ResultMakerWithIdVisConfigAndDynamicFields.
        :rtype: bool
        """
        return self._total

    @total.setter
    def total(self, total):
        """
        Sets the total of this ResultMakerWithIdVisConfigAndDynamicFields.
        Total of the constituent Look, Query, or Merge Query

        :param total: The total of this ResultMakerWithIdVisConfigAndDynamicFields.
        :type: bool
        """

        self._total = total

    @property
    def query_id(self):
        """
        Gets the query_id of this ResultMakerWithIdVisConfigAndDynamicFields.
        ID of query if this is a query.

        :return: The query_id of this ResultMakerWithIdVisConfigAndDynamicFields.
        :rtype: int
        """
        return self._query_id

    @query_id.setter
    def query_id(self, query_id):
        """
        Sets the query_id of this ResultMakerWithIdVisConfigAndDynamicFields.
        ID of query if this is a query.

        :param query_id: The query_id of this ResultMakerWithIdVisConfigAndDynamicFields.
        :type: int
        """

        self._query_id = query_id

    @property
    def query(self):
        """
        Gets the query of this ResultMakerWithIdVisConfigAndDynamicFields.
        Query

        :return: The query of this ResultMakerWithIdVisConfigAndDynamicFields.
        :rtype: Query
        """
        return self._query

    @query.setter
    def query(self, query):
        """
        Sets the query of this ResultMakerWithIdVisConfigAndDynamicFields.
        Query

        :param query: The query of this ResultMakerWithIdVisConfigAndDynamicFields.
        :type: Query
        """

        self._query = query

    @property
    def vis_config(self):
        """
        Gets the vis_config of this ResultMakerWithIdVisConfigAndDynamicFields.
        Vis config of the constituent Query, or Merge Query.

        :return: The vis_config of this ResultMakerWithIdVisConfigAndDynamicFields.
        :rtype: str
        """
        return self._vis_config

    @vis_config.setter
    def vis_config(self, vis_config):
        """
        Sets the vis_config of this ResultMakerWithIdVisConfigAndDynamicFields.
        Vis config of the constituent Query, or Merge Query.

        :param vis_config: The vis_config of this ResultMakerWithIdVisConfigAndDynamicFields.
        :type: str
        """

        self._vis_config = vis_config

    @property
    def can(self):
        """
        Gets the can of this ResultMakerWithIdVisConfigAndDynamicFields.
        Operations the current user is able to perform on this object

        :return: The can of this ResultMakerWithIdVisConfigAndDynamicFields.
        :rtype: dict(str, bool)
        """
        return self._can

    @can.setter
    def can(self, can):
        """
        Sets the can of this ResultMakerWithIdVisConfigAndDynamicFields.
        Operations the current user is able to perform on this object

        :param can: The can of this ResultMakerWithIdVisConfigAndDynamicFields.
        :type: dict(str, bool)
        """

        self._can = can

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ResultMakerWithIdVisConfigAndDynamicFields):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
