# coding: utf-8

"""
    Looker API 3.0 Reference

    ### Authorization  The Looker API uses Looker **API3** credentials for authorization and access control. Looker admins can create API3 credentials on Looker's **Admin/Users** page. Pass API3 credentials to the **/login** endpoint to obtain a temporary access_token. Include that access_token in the Authorization header of Looker API requests. For details, see [Looker API Authorization](https://looker.com/docs/r/api/authorization)  ### Client SDKs  The Looker API is a RESTful system that should be usable by any programming language capable of making HTTPS requests. Client SDKs for a variety of programming languages can be generated from the Looker API's Swagger JSON metadata to streamline use of the Looker API in your applications. A client SDK for Ruby is available as an example. For more information, see [Looker API Client SDKs](https://looker.com/docs/r/api/client_sdks)  ### Try It Out!  The 'api-docs' page served by the Looker instance includes 'Try It Out!' buttons for each API method. After logging in with API3 credentials, you can use the \"Try It Out!\" buttons to call the API directly from the documentation page to interactively explore API features and responses.  ### Versioning  Future releases of Looker will expand this API release-by-release to securely expose more and more of the core power of Looker to API client applications. API endpoints marked as \"beta\" may receive breaking changes without warning. Stable (non-beta) API endpoints should not receive breaking changes in future releases. For more information, see [Looker API Versioning](https://looker.com/docs/r/api/versioning) 

    OpenAPI spec version: 3.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ProjectWorkspace(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, project_id=None, workspace_id=None, git_status=None, git_head=None, git_branch=None, lookml_type=None, can=None):
        """
        ProjectWorkspace - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'project_id': 'str',
            'workspace_id': 'str',
            'git_status': 'str',
            'git_head': 'str',
            'git_branch': 'GitBranch',
            'lookml_type': 'str',
            'can': 'dict(str, bool)'
        }

        self.attribute_map = {
            'project_id': 'project_id',
            'workspace_id': 'workspace_id',
            'git_status': 'git_status',
            'git_head': 'git_head',
            'git_branch': 'git_branch',
            'lookml_type': 'lookml_type',
            'can': 'can'
        }

        self._project_id = project_id
        self._workspace_id = workspace_id
        self._git_status = git_status
        self._git_head = git_head
        self._git_branch = git_branch
        self._lookml_type = lookml_type
        self._can = can

    @property
    def project_id(self):
        """
        Gets the project_id of this ProjectWorkspace.
        The id of the project

        :return: The project_id of this ProjectWorkspace.
        :rtype: str
        """
        return self._project_id

    @project_id.setter
    def project_id(self, project_id):
        """
        Sets the project_id of this ProjectWorkspace.
        The id of the project

        :param project_id: The project_id of this ProjectWorkspace.
        :type: str
        """

        self._project_id = project_id

    @property
    def workspace_id(self):
        """
        Gets the workspace_id of this ProjectWorkspace.
        The id of the local workspace containing the project files

        :return: The workspace_id of this ProjectWorkspace.
        :rtype: str
        """
        return self._workspace_id

    @workspace_id.setter
    def workspace_id(self, workspace_id):
        """
        Sets the workspace_id of this ProjectWorkspace.
        The id of the local workspace containing the project files

        :param workspace_id: The workspace_id of this ProjectWorkspace.
        :type: str
        """

        self._workspace_id = workspace_id

    @property
    def git_status(self):
        """
        Gets the git_status of this ProjectWorkspace.
        The status of the local git directory

        :return: The git_status of this ProjectWorkspace.
        :rtype: str
        """
        return self._git_status

    @git_status.setter
    def git_status(self, git_status):
        """
        Sets the git_status of this ProjectWorkspace.
        The status of the local git directory

        :param git_status: The git_status of this ProjectWorkspace.
        :type: str
        """

        self._git_status = git_status

    @property
    def git_head(self):
        """
        Gets the git_head of this ProjectWorkspace.
        Git head revision name

        :return: The git_head of this ProjectWorkspace.
        :rtype: str
        """
        return self._git_head

    @git_head.setter
    def git_head(self, git_head):
        """
        Sets the git_head of this ProjectWorkspace.
        Git head revision name

        :param git_head: The git_head of this ProjectWorkspace.
        :type: str
        """

        self._git_head = git_head

    @property
    def git_branch(self):
        """
        Gets the git_branch of this ProjectWorkspace.
        GitBranch

        :return: The git_branch of this ProjectWorkspace.
        :rtype: GitBranch
        """
        return self._git_branch

    @git_branch.setter
    def git_branch(self, git_branch):
        """
        Sets the git_branch of this ProjectWorkspace.
        GitBranch

        :param git_branch: The git_branch of this ProjectWorkspace.
        :type: GitBranch
        """

        self._git_branch = git_branch

    @property
    def lookml_type(self):
        """
        Gets the lookml_type of this ProjectWorkspace.
        The lookml syntax used by all files in this project

        :return: The lookml_type of this ProjectWorkspace.
        :rtype: str
        """
        return self._lookml_type

    @lookml_type.setter
    def lookml_type(self, lookml_type):
        """
        Sets the lookml_type of this ProjectWorkspace.
        The lookml syntax used by all files in this project

        :param lookml_type: The lookml_type of this ProjectWorkspace.
        :type: str
        """

        self._lookml_type = lookml_type

    @property
    def can(self):
        """
        Gets the can of this ProjectWorkspace.
        Operations the current user is able to perform on this object

        :return: The can of this ProjectWorkspace.
        :rtype: dict(str, bool)
        """
        return self._can

    @can.setter
    def can(self, can):
        """
        Sets the can of this ProjectWorkspace.
        Operations the current user is able to perform on this object

        :param can: The can of this ProjectWorkspace.
        :type: dict(str, bool)
        """

        self._can = can

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ProjectWorkspace):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
