# coding: utf-8

"""
    Looker API 3.0 Reference

    ### Authorization  The Looker API uses Looker **API3** credentials for authorization and access control. Looker admins can create API3 credentials on Looker's **Admin/Users** page. Pass API3 credentials to the **/login** endpoint to obtain a temporary access_token. Include that access_token in the Authorization header of Looker API requests. For details, see [Looker API Authorization](https://looker.com/docs/r/api/authorization)  ### Client SDKs  The Looker API is a RESTful system that should be usable by any programming language capable of making HTTPS requests. Client SDKs for a variety of programming languages can be generated from the Looker API's Swagger JSON metadata to streamline use of the Looker API in your applications. A client SDK for Ruby is available as an example. For more information, see [Looker API Client SDKs](https://looker.com/docs/r/api/client_sdks)  ### Try It Out!  The 'api-docs' page served by the Looker instance includes 'Try It Out!' buttons for each API method. After logging in with API3 credentials, you can use the \"Try It Out!\" buttons to call the API directly from the documentation page to interactively explore API features and responses.  ### Versioning  Future releases of Looker will expand this API release-by-release to securely expose more and more of the core power of Looker to API client applications. API endpoints marked as \"beta\" may receive breaking changes without warning. Stable (non-beta) API endpoints should not receive breaking changes in future releases. For more information, see [Looker API Versioning](https://looker.com/docs/r/api/versioning) 

    OpenAPI spec version: 3.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ProjectError(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, code=None, severity=None, kind=None, message=None, field_name=None, file_path=None, line_number=None, model_id=None, explore=None, help_url=None, params=None, sanitized_message=None):
        """
        ProjectError - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'code': 'str',
            'severity': 'str',
            'kind': 'str',
            'message': 'str',
            'field_name': 'str',
            'file_path': 'str',
            'line_number': 'int',
            'model_id': 'str',
            'explore': 'str',
            'help_url': 'str',
            'params': 'dict(str, str)',
            'sanitized_message': 'str'
        }

        self.attribute_map = {
            'code': 'code',
            'severity': 'severity',
            'kind': 'kind',
            'message': 'message',
            'field_name': 'field_name',
            'file_path': 'file_path',
            'line_number': 'line_number',
            'model_id': 'model_id',
            'explore': 'explore',
            'help_url': 'help_url',
            'params': 'params',
            'sanitized_message': 'sanitized_message'
        }

        self._code = code
        self._severity = severity
        self._kind = kind
        self._message = message
        self._field_name = field_name
        self._file_path = file_path
        self._line_number = line_number
        self._model_id = model_id
        self._explore = explore
        self._help_url = help_url
        self._params = params
        self._sanitized_message = sanitized_message

    @property
    def code(self):
        """
        Gets the code of this ProjectError.
        A stable token that uniquely identifies this class of error, ignoring parameter values. Error message text may vary due to parameters or localization, but error codes do not. For example, a \"File not found\" error will have the same error code regardless of the filename in question or the user's display language

        :return: The code of this ProjectError.
        :rtype: str
        """
        return self._code

    @code.setter
    def code(self, code):
        """
        Sets the code of this ProjectError.
        A stable token that uniquely identifies this class of error, ignoring parameter values. Error message text may vary due to parameters or localization, but error codes do not. For example, a \"File not found\" error will have the same error code regardless of the filename in question or the user's display language

        :param code: The code of this ProjectError.
        :type: str
        """

        self._code = code

    @property
    def severity(self):
        """
        Gets the severity of this ProjectError.
        Severity: fatal, error, warning, info, success

        :return: The severity of this ProjectError.
        :rtype: str
        """
        return self._severity

    @severity.setter
    def severity(self, severity):
        """
        Sets the severity of this ProjectError.
        Severity: fatal, error, warning, info, success

        :param severity: The severity of this ProjectError.
        :type: str
        """

        self._severity = severity

    @property
    def kind(self):
        """
        Gets the kind of this ProjectError.
        Error classification: syntax, deprecation, model_configuration, etc

        :return: The kind of this ProjectError.
        :rtype: str
        """
        return self._kind

    @kind.setter
    def kind(self, kind):
        """
        Sets the kind of this ProjectError.
        Error classification: syntax, deprecation, model_configuration, etc

        :param kind: The kind of this ProjectError.
        :type: str
        """

        self._kind = kind

    @property
    def message(self):
        """
        Gets the message of this ProjectError.
        Error message which may contain information such as dashboard or model names that may be considered sensitive in some use cases. Avoid storing or sending this message outside of Looker

        :return: The message of this ProjectError.
        :rtype: str
        """
        return self._message

    @message.setter
    def message(self, message):
        """
        Sets the message of this ProjectError.
        Error message which may contain information such as dashboard or model names that may be considered sensitive in some use cases. Avoid storing or sending this message outside of Looker

        :param message: The message of this ProjectError.
        :type: str
        """

        self._message = message

    @property
    def field_name(self):
        """
        Gets the field_name of this ProjectError.
        The field associated with this error

        :return: The field_name of this ProjectError.
        :rtype: str
        """
        return self._field_name

    @field_name.setter
    def field_name(self, field_name):
        """
        Sets the field_name of this ProjectError.
        The field associated with this error

        :param field_name: The field_name of this ProjectError.
        :type: str
        """

        self._field_name = field_name

    @property
    def file_path(self):
        """
        Gets the file_path of this ProjectError.
        Name of the file containing this error

        :return: The file_path of this ProjectError.
        :rtype: str
        """
        return self._file_path

    @file_path.setter
    def file_path(self, file_path):
        """
        Sets the file_path of this ProjectError.
        Name of the file containing this error

        :param file_path: The file_path of this ProjectError.
        :type: str
        """

        self._file_path = file_path

    @property
    def line_number(self):
        """
        Gets the line_number of this ProjectError.
        Line number in the file of this error

        :return: The line_number of this ProjectError.
        :rtype: int
        """
        return self._line_number

    @line_number.setter
    def line_number(self, line_number):
        """
        Sets the line_number of this ProjectError.
        Line number in the file of this error

        :param line_number: The line_number of this ProjectError.
        :type: int
        """

        self._line_number = line_number

    @property
    def model_id(self):
        """
        Gets the model_id of this ProjectError.
        The model associated with this error

        :return: The model_id of this ProjectError.
        :rtype: str
        """
        return self._model_id

    @model_id.setter
    def model_id(self, model_id):
        """
        Sets the model_id of this ProjectError.
        The model associated with this error

        :param model_id: The model_id of this ProjectError.
        :type: str
        """

        self._model_id = model_id

    @property
    def explore(self):
        """
        Gets the explore of this ProjectError.
        The explore associated with this error

        :return: The explore of this ProjectError.
        :rtype: str
        """
        return self._explore

    @explore.setter
    def explore(self, explore):
        """
        Sets the explore of this ProjectError.
        The explore associated with this error

        :param explore: The explore of this ProjectError.
        :type: str
        """

        self._explore = explore

    @property
    def help_url(self):
        """
        Gets the help_url of this ProjectError.
        A link to Looker documentation about this error

        :return: The help_url of this ProjectError.
        :rtype: str
        """
        return self._help_url

    @help_url.setter
    def help_url(self, help_url):
        """
        Sets the help_url of this ProjectError.
        A link to Looker documentation about this error

        :param help_url: The help_url of this ProjectError.
        :type: str
        """

        self._help_url = help_url

    @property
    def params(self):
        """
        Gets the params of this ProjectError.
        Error parameters

        :return: The params of this ProjectError.
        :rtype: dict(str, str)
        """
        return self._params

    @params.setter
    def params(self, params):
        """
        Sets the params of this ProjectError.
        Error parameters

        :param params: The params of this ProjectError.
        :type: dict(str, str)
        """

        self._params = params

    @property
    def sanitized_message(self):
        """
        Gets the sanitized_message of this ProjectError.
        A version of the error message that does not contain potentially sensitive information. Suitable for situations in which messages are stored or sent to consumers outside of Looker, such as external logs. Sanitized messages will display \"(?)\" where sensitive information would appear in the corresponding non-sanitized message

        :return: The sanitized_message of this ProjectError.
        :rtype: str
        """
        return self._sanitized_message

    @sanitized_message.setter
    def sanitized_message(self, sanitized_message):
        """
        Sets the sanitized_message of this ProjectError.
        A version of the error message that does not contain potentially sensitive information. Suitable for situations in which messages are stored or sent to consumers outside of Looker, such as external logs. Sanitized messages will display \"(?)\" where sensitive information would appear in the corresponding non-sanitized message

        :param sanitized_message: The sanitized_message of this ProjectError.
        :type: str
        """

        self._sanitized_message = sanitized_message

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ProjectError):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
