# coding: utf-8

"""
    Looker API 3.0 Reference

    ### Authorization  The Looker API uses Looker **API3** credentials for authorization and access control. Looker admins can create API3 credentials on Looker's **Admin/Users** page. Pass API3 credentials to the **/login** endpoint to obtain a temporary access_token. Include that access_token in the Authorization header of Looker API requests. For details, see [Looker API Authorization](https://looker.com/docs/r/api/authorization)  ### Client SDKs  The Looker API is a RESTful system that should be usable by any programming language capable of making HTTPS requests. Client SDKs for a variety of programming languages can be generated from the Looker API's Swagger JSON metadata to streamline use of the Looker API in your applications. A client SDK for Ruby is available as an example. For more information, see [Looker API Client SDKs](https://looker.com/docs/r/api/client_sdks)  ### Try It Out!  The 'api-docs' page served by the Looker instance includes 'Try It Out!' buttons for each API method. After logging in with API3 credentials, you can use the \"Try It Out!\" buttons to call the API directly from the documentation page to interactively explore API features and responses.  ### Versioning  Future releases of Looker will expand this API release-by-release to securely expose more and more of the core power of Looker to API client applications. API endpoints marked as \"beta\" may receive breaking changes without warning. Stable (non-beta) API endpoints should not receive breaking changes in future releases. For more information, see [Looker API Versioning](https://looker.com/docs/r/api/versioning) 

    OpenAPI spec version: 3.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class Project(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, id=None, name=None, uses_git=None, git_remote_url=None, git_username=None, git_password=None, git_username_user_attribute=None, git_password_user_attribute=None, git_service_name=None, pull_request_mode=None, validation_required=None, is_example=None, can=None):
        """
        Project - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'uses_git': 'bool',
            'git_remote_url': 'str',
            'git_username': 'str',
            'git_password': 'str',
            'git_username_user_attribute': 'str',
            'git_password_user_attribute': 'str',
            'git_service_name': 'str',
            'pull_request_mode': 'str',
            'validation_required': 'bool',
            'is_example': 'bool',
            'can': 'dict(str, bool)'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'uses_git': 'uses_git',
            'git_remote_url': 'git_remote_url',
            'git_username': 'git_username',
            'git_password': 'git_password',
            'git_username_user_attribute': 'git_username_user_attribute',
            'git_password_user_attribute': 'git_password_user_attribute',
            'git_service_name': 'git_service_name',
            'pull_request_mode': 'pull_request_mode',
            'validation_required': 'validation_required',
            'is_example': 'is_example',
            'can': 'can'
        }

        self._id = id
        self._name = name
        self._uses_git = uses_git
        self._git_remote_url = git_remote_url
        self._git_username = git_username
        self._git_password = git_password
        self._git_username_user_attribute = git_username_user_attribute
        self._git_password_user_attribute = git_password_user_attribute
        self._git_service_name = git_service_name
        self._pull_request_mode = pull_request_mode
        self._validation_required = validation_required
        self._is_example = is_example
        self._can = can

    @property
    def id(self):
        """
        Gets the id of this Project.
        Project Id

        :return: The id of this Project.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this Project.
        Project Id

        :param id: The id of this Project.
        :type: str
        """

        self._id = id

    @property
    def name(self):
        """
        Gets the name of this Project.
        Project display name

        :return: The name of this Project.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this Project.
        Project display name

        :param name: The name of this Project.
        :type: str
        """

        self._name = name

    @property
    def uses_git(self):
        """
        Gets the uses_git of this Project.
        If true the project is configured with a git repository

        :return: The uses_git of this Project.
        :rtype: bool
        """
        return self._uses_git

    @uses_git.setter
    def uses_git(self, uses_git):
        """
        Sets the uses_git of this Project.
        If true the project is configured with a git repository

        :param uses_git: The uses_git of this Project.
        :type: bool
        """

        self._uses_git = uses_git

    @property
    def git_remote_url(self):
        """
        Gets the git_remote_url of this Project.
        Git remote repository url

        :return: The git_remote_url of this Project.
        :rtype: str
        """
        return self._git_remote_url

    @git_remote_url.setter
    def git_remote_url(self, git_remote_url):
        """
        Sets the git_remote_url of this Project.
        Git remote repository url

        :param git_remote_url: The git_remote_url of this Project.
        :type: str
        """

        self._git_remote_url = git_remote_url

    @property
    def git_username(self):
        """
        Gets the git_username of this Project.
        Git username for HTTPS authentication. (For production only, if using user attributes.)

        :return: The git_username of this Project.
        :rtype: str
        """
        return self._git_username

    @git_username.setter
    def git_username(self, git_username):
        """
        Sets the git_username of this Project.
        Git username for HTTPS authentication. (For production only, if using user attributes.)

        :param git_username: The git_username of this Project.
        :type: str
        """

        self._git_username = git_username

    @property
    def git_password(self):
        """
        Gets the git_password of this Project.
        (Write-Only) Git password for HTTPS authentication. (For production only, if using user attributes.)

        :return: The git_password of this Project.
        :rtype: str
        """
        return self._git_password

    @git_password.setter
    def git_password(self, git_password):
        """
        Sets the git_password of this Project.
        (Write-Only) Git password for HTTPS authentication. (For production only, if using user attributes.)

        :param git_password: The git_password of this Project.
        :type: str
        """

        self._git_password = git_password

    @property
    def git_username_user_attribute(self):
        """
        Gets the git_username_user_attribute of this Project.
        User attribute name for username in per-user HTTPS authentication.

        :return: The git_username_user_attribute of this Project.
        :rtype: str
        """
        return self._git_username_user_attribute

    @git_username_user_attribute.setter
    def git_username_user_attribute(self, git_username_user_attribute):
        """
        Sets the git_username_user_attribute of this Project.
        User attribute name for username in per-user HTTPS authentication.

        :param git_username_user_attribute: The git_username_user_attribute of this Project.
        :type: str
        """

        self._git_username_user_attribute = git_username_user_attribute

    @property
    def git_password_user_attribute(self):
        """
        Gets the git_password_user_attribute of this Project.
        User attribute name for password in per-user HTTPS authentication.

        :return: The git_password_user_attribute of this Project.
        :rtype: str
        """
        return self._git_password_user_attribute

    @git_password_user_attribute.setter
    def git_password_user_attribute(self, git_password_user_attribute):
        """
        Sets the git_password_user_attribute of this Project.
        User attribute name for password in per-user HTTPS authentication.

        :param git_password_user_attribute: The git_password_user_attribute of this Project.
        :type: str
        """

        self._git_password_user_attribute = git_password_user_attribute

    @property
    def git_service_name(self):
        """
        Gets the git_service_name of this Project.
        Name of the git service provider

        :return: The git_service_name of this Project.
        :rtype: str
        """
        return self._git_service_name

    @git_service_name.setter
    def git_service_name(self, git_service_name):
        """
        Sets the git_service_name of this Project.
        Name of the git service provider

        :param git_service_name: The git_service_name of this Project.
        :type: str
        """

        self._git_service_name = git_service_name

    @property
    def pull_request_mode(self):
        """
        Gets the pull_request_mode of this Project.
        The git pull request policy for this project. Valid values are: \"off\", \"links\", \"recommended\", \"required\".

        :return: The pull_request_mode of this Project.
        :rtype: str
        """
        return self._pull_request_mode

    @pull_request_mode.setter
    def pull_request_mode(self, pull_request_mode):
        """
        Sets the pull_request_mode of this Project.
        The git pull request policy for this project. Valid values are: \"off\", \"links\", \"recommended\", \"required\".

        :param pull_request_mode: The pull_request_mode of this Project.
        :type: str
        """

        self._pull_request_mode = pull_request_mode

    @property
    def validation_required(self):
        """
        Gets the validation_required of this Project.
        Validation policy: If true, the project must pass all validation checks before project changes can be committed to the git repository

        :return: The validation_required of this Project.
        :rtype: bool
        """
        return self._validation_required

    @validation_required.setter
    def validation_required(self, validation_required):
        """
        Sets the validation_required of this Project.
        Validation policy: If true, the project must pass all validation checks before project changes can be committed to the git repository

        :param validation_required: The validation_required of this Project.
        :type: bool
        """

        self._validation_required = validation_required

    @property
    def is_example(self):
        """
        Gets the is_example of this Project.
        If true the project is an example project and cannot be modified

        :return: The is_example of this Project.
        :rtype: bool
        """
        return self._is_example

    @is_example.setter
    def is_example(self, is_example):
        """
        Sets the is_example of this Project.
        If true the project is an example project and cannot be modified

        :param is_example: The is_example of this Project.
        :type: bool
        """

        self._is_example = is_example

    @property
    def can(self):
        """
        Gets the can of this Project.
        Operations the current user is able to perform on this object

        :return: The can of this Project.
        :rtype: dict(str, bool)
        """
        return self._can

    @can.setter
    def can(self, can):
        """
        Sets the can of this Project.
        Operations the current user is able to perform on this object

        :param can: The can of this Project.
        :type: dict(str, bool)
        """

        self._can = can

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, Project):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
