# coding: utf-8

"""
    Looker API 3.0 Reference

    ### Authorization  The Looker API uses Looker **API3** credentials for authorization and access control. Looker admins can create API3 credentials on Looker's **Admin/Users** page. Pass API3 credentials to the **/login** endpoint to obtain a temporary access_token. Include that access_token in the Authorization header of Looker API requests. For details, see [Looker API Authorization](https://looker.com/docs/r/api/authorization)  ### Client SDKs  The Looker API is a RESTful system that should be usable by any programming language capable of making HTTPS requests. Client SDKs for a variety of programming languages can be generated from the Looker API's Swagger JSON metadata to streamline use of the Looker API in your applications. A client SDK for Ruby is available as an example. For more information, see [Looker API Client SDKs](https://looker.com/docs/r/api/client_sdks)  ### Try It Out!  The 'api-docs' page served by the Looker instance includes 'Try It Out!' buttons for each API method. After logging in with API3 credentials, you can use the \"Try It Out!\" buttons to call the API directly from the documentation page to interactively explore API features and responses.  ### Versioning  Future releases of Looker will expand this API release-by-release to securely expose more and more of the core power of Looker to API client applications. API endpoints marked as \"beta\" may receive breaking changes without warning. Stable (non-beta) API endpoints should not receive breaking changes in future releases. For more information, see [Looker API Versioning](https://looker.com/docs/r/api/versioning) 

    OpenAPI spec version: 3.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class LookmlModelExploreField(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, align=None, can_filter=None, category=None, default_filter_value=None, description=None, enumerations=None, error=None, field_group_label=None, field_group_variant=None, fill_style=None, fiscal_month_offset=None, has_allowed_values=None, hidden=None, is_filter=None, is_fiscal=None, is_numeric=None, is_timeframe=None, can_time_filter=None, time_interval=None, label=None, label_from_parameter=None, label_short=None, lookml_link=None, map_layer=None, measure=None, name=None, parameter=None, permanent=None, primary_key=None, project_name=None, requires_refresh_on_sort=None, scope=None, sortable=None, source_file=None, source_file_path=None, sql=None, sql_case=None, suggest_dimension=None, suggest_explore=None, suggestable=None, suggestions=None, tags=None, type=None, user_attribute_filter_types=None, value_format=None, view=None, view_label=None, dynamic=None, week_start_day=None):
        """
        LookmlModelExploreField - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'align': 'str',
            'can_filter': 'bool',
            'category': 'str',
            'default_filter_value': 'str',
            'description': 'str',
            'enumerations': 'list[LookmlModelExploreFieldEnumeration]',
            'error': 'str',
            'field_group_label': 'str',
            'field_group_variant': 'str',
            'fill_style': 'str',
            'fiscal_month_offset': 'int',
            'has_allowed_values': 'bool',
            'hidden': 'bool',
            'is_filter': 'bool',
            'is_fiscal': 'bool',
            'is_numeric': 'bool',
            'is_timeframe': 'bool',
            'can_time_filter': 'bool',
            'time_interval': 'LookmlModelExploreFieldTimeInterval',
            'label': 'str',
            'label_from_parameter': 'str',
            'label_short': 'str',
            'lookml_link': 'str',
            'map_layer': 'LookmlModelExploreFieldMapLayer',
            'measure': 'bool',
            'name': 'str',
            'parameter': 'bool',
            'permanent': 'bool',
            'primary_key': 'bool',
            'project_name': 'str',
            'requires_refresh_on_sort': 'bool',
            'scope': 'str',
            'sortable': 'bool',
            'source_file': 'str',
            'source_file_path': 'str',
            'sql': 'str',
            'sql_case': 'list[LookmlModelExploreFieldSqlCase]',
            'suggest_dimension': 'str',
            'suggest_explore': 'str',
            'suggestable': 'bool',
            'suggestions': 'list[str]',
            'tags': 'list[str]',
            'type': 'str',
            'user_attribute_filter_types': 'list[str]',
            'value_format': 'str',
            'view': 'str',
            'view_label': 'str',
            'dynamic': 'bool',
            'week_start_day': 'str'
        }

        self.attribute_map = {
            'align': 'align',
            'can_filter': 'can_filter',
            'category': 'category',
            'default_filter_value': 'default_filter_value',
            'description': 'description',
            'enumerations': 'enumerations',
            'error': 'error',
            'field_group_label': 'field_group_label',
            'field_group_variant': 'field_group_variant',
            'fill_style': 'fill_style',
            'fiscal_month_offset': 'fiscal_month_offset',
            'has_allowed_values': 'has_allowed_values',
            'hidden': 'hidden',
            'is_filter': 'is_filter',
            'is_fiscal': 'is_fiscal',
            'is_numeric': 'is_numeric',
            'is_timeframe': 'is_timeframe',
            'can_time_filter': 'can_time_filter',
            'time_interval': 'time_interval',
            'label': 'label',
            'label_from_parameter': 'label_from_parameter',
            'label_short': 'label_short',
            'lookml_link': 'lookml_link',
            'map_layer': 'map_layer',
            'measure': 'measure',
            'name': 'name',
            'parameter': 'parameter',
            'permanent': 'permanent',
            'primary_key': 'primary_key',
            'project_name': 'project_name',
            'requires_refresh_on_sort': 'requires_refresh_on_sort',
            'scope': 'scope',
            'sortable': 'sortable',
            'source_file': 'source_file',
            'source_file_path': 'source_file_path',
            'sql': 'sql',
            'sql_case': 'sql_case',
            'suggest_dimension': 'suggest_dimension',
            'suggest_explore': 'suggest_explore',
            'suggestable': 'suggestable',
            'suggestions': 'suggestions',
            'tags': 'tags',
            'type': 'type',
            'user_attribute_filter_types': 'user_attribute_filter_types',
            'value_format': 'value_format',
            'view': 'view',
            'view_label': 'view_label',
            'dynamic': 'dynamic',
            'week_start_day': 'week_start_day'
        }

        self._align = align
        self._can_filter = can_filter
        self._category = category
        self._default_filter_value = default_filter_value
        self._description = description
        self._enumerations = enumerations
        self._error = error
        self._field_group_label = field_group_label
        self._field_group_variant = field_group_variant
        self._fill_style = fill_style
        self._fiscal_month_offset = fiscal_month_offset
        self._has_allowed_values = has_allowed_values
        self._hidden = hidden
        self._is_filter = is_filter
        self._is_fiscal = is_fiscal
        self._is_numeric = is_numeric
        self._is_timeframe = is_timeframe
        self._can_time_filter = can_time_filter
        self._time_interval = time_interval
        self._label = label
        self._label_from_parameter = label_from_parameter
        self._label_short = label_short
        self._lookml_link = lookml_link
        self._map_layer = map_layer
        self._measure = measure
        self._name = name
        self._parameter = parameter
        self._permanent = permanent
        self._primary_key = primary_key
        self._project_name = project_name
        self._requires_refresh_on_sort = requires_refresh_on_sort
        self._scope = scope
        self._sortable = sortable
        self._source_file = source_file
        self._source_file_path = source_file_path
        self._sql = sql
        self._sql_case = sql_case
        self._suggest_dimension = suggest_dimension
        self._suggest_explore = suggest_explore
        self._suggestable = suggestable
        self._suggestions = suggestions
        self._tags = tags
        self._type = type
        self._user_attribute_filter_types = user_attribute_filter_types
        self._value_format = value_format
        self._view = view
        self._view_label = view_label
        self._dynamic = dynamic
        self._week_start_day = week_start_day

    @property
    def align(self):
        """
        Gets the align of this LookmlModelExploreField.
        The appropriate horizontal text alignment the values of this field shoud be displayed in. Valid values are: \"left\", \"right\".

        :return: The align of this LookmlModelExploreField.
        :rtype: str
        """
        return self._align

    @align.setter
    def align(self, align):
        """
        Sets the align of this LookmlModelExploreField.
        The appropriate horizontal text alignment the values of this field shoud be displayed in. Valid values are: \"left\", \"right\".

        :param align: The align of this LookmlModelExploreField.
        :type: str
        """

        self._align = align

    @property
    def can_filter(self):
        """
        Gets the can_filter of this LookmlModelExploreField.
        Whether it's possible to filter on this field.

        :return: The can_filter of this LookmlModelExploreField.
        :rtype: bool
        """
        return self._can_filter

    @can_filter.setter
    def can_filter(self, can_filter):
        """
        Sets the can_filter of this LookmlModelExploreField.
        Whether it's possible to filter on this field.

        :param can_filter: The can_filter of this LookmlModelExploreField.
        :type: bool
        """

        self._can_filter = can_filter

    @property
    def category(self):
        """
        Gets the category of this LookmlModelExploreField.
        Field category Valid values are: \"parameter\", \"filter\", \"measure\", \"dimension\".

        :return: The category of this LookmlModelExploreField.
        :rtype: str
        """
        return self._category

    @category.setter
    def category(self, category):
        """
        Sets the category of this LookmlModelExploreField.
        Field category Valid values are: \"parameter\", \"filter\", \"measure\", \"dimension\".

        :param category: The category of this LookmlModelExploreField.
        :type: str
        """

        self._category = category

    @property
    def default_filter_value(self):
        """
        Gets the default_filter_value of this LookmlModelExploreField.
        The default value that this field uses when filtering. Null if there is no default value.

        :return: The default_filter_value of this LookmlModelExploreField.
        :rtype: str
        """
        return self._default_filter_value

    @default_filter_value.setter
    def default_filter_value(self, default_filter_value):
        """
        Sets the default_filter_value of this LookmlModelExploreField.
        The default value that this field uses when filtering. Null if there is no default value.

        :param default_filter_value: The default_filter_value of this LookmlModelExploreField.
        :type: str
        """

        self._default_filter_value = default_filter_value

    @property
    def description(self):
        """
        Gets the description of this LookmlModelExploreField.
        Description

        :return: The description of this LookmlModelExploreField.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this LookmlModelExploreField.
        Description

        :param description: The description of this LookmlModelExploreField.
        :type: str
        """

        self._description = description

    @property
    def enumerations(self):
        """
        Gets the enumerations of this LookmlModelExploreField.
        An array enumerating all the possible values that this field can contain. When null, there is no limit to the set of possible values this field can contain.

        :return: The enumerations of this LookmlModelExploreField.
        :rtype: list[LookmlModelExploreFieldEnumeration]
        """
        return self._enumerations

    @enumerations.setter
    def enumerations(self, enumerations):
        """
        Sets the enumerations of this LookmlModelExploreField.
        An array enumerating all the possible values that this field can contain. When null, there is no limit to the set of possible values this field can contain.

        :param enumerations: The enumerations of this LookmlModelExploreField.
        :type: list[LookmlModelExploreFieldEnumeration]
        """

        self._enumerations = enumerations

    @property
    def error(self):
        """
        Gets the error of this LookmlModelExploreField.
        An error message indicating a problem with the definition of this field. If there are no errors, this will be null.

        :return: The error of this LookmlModelExploreField.
        :rtype: str
        """
        return self._error

    @error.setter
    def error(self, error):
        """
        Sets the error of this LookmlModelExploreField.
        An error message indicating a problem with the definition of this field. If there are no errors, this will be null.

        :param error: The error of this LookmlModelExploreField.
        :type: str
        """

        self._error = error

    @property
    def field_group_label(self):
        """
        Gets the field_group_label of this LookmlModelExploreField.
        A label creating a grouping of fields. All fields with this label should be presented together when displayed in a UI.

        :return: The field_group_label of this LookmlModelExploreField.
        :rtype: str
        """
        return self._field_group_label

    @field_group_label.setter
    def field_group_label(self, field_group_label):
        """
        Sets the field_group_label of this LookmlModelExploreField.
        A label creating a grouping of fields. All fields with this label should be presented together when displayed in a UI.

        :param field_group_label: The field_group_label of this LookmlModelExploreField.
        :type: str
        """

        self._field_group_label = field_group_label

    @property
    def field_group_variant(self):
        """
        Gets the field_group_variant of this LookmlModelExploreField.
        When presented in a field group via field_group_label, a shorter name of the field to be displayed in that context.

        :return: The field_group_variant of this LookmlModelExploreField.
        :rtype: str
        """
        return self._field_group_variant

    @field_group_variant.setter
    def field_group_variant(self, field_group_variant):
        """
        Sets the field_group_variant of this LookmlModelExploreField.
        When presented in a field group via field_group_label, a shorter name of the field to be displayed in that context.

        :param field_group_variant: The field_group_variant of this LookmlModelExploreField.
        :type: str
        """

        self._field_group_variant = field_group_variant

    @property
    def fill_style(self):
        """
        Gets the fill_style of this LookmlModelExploreField.
        The style of dimension fill that is possible for this field. Null if no dimension fill is possible. Valid values are: \"enumeration\", \"range\".

        :return: The fill_style of this LookmlModelExploreField.
        :rtype: str
        """
        return self._fill_style

    @fill_style.setter
    def fill_style(self, fill_style):
        """
        Sets the fill_style of this LookmlModelExploreField.
        The style of dimension fill that is possible for this field. Null if no dimension fill is possible. Valid values are: \"enumeration\", \"range\".

        :param fill_style: The fill_style of this LookmlModelExploreField.
        :type: str
        """

        self._fill_style = fill_style

    @property
    def fiscal_month_offset(self):
        """
        Gets the fiscal_month_offset of this LookmlModelExploreField.
        An offset (in months) from the calendar start month to the fiscal start month defined in the LookML model this field belongs to.

        :return: The fiscal_month_offset of this LookmlModelExploreField.
        :rtype: int
        """
        return self._fiscal_month_offset

    @fiscal_month_offset.setter
    def fiscal_month_offset(self, fiscal_month_offset):
        """
        Sets the fiscal_month_offset of this LookmlModelExploreField.
        An offset (in months) from the calendar start month to the fiscal start month defined in the LookML model this field belongs to.

        :param fiscal_month_offset: The fiscal_month_offset of this LookmlModelExploreField.
        :type: int
        """

        self._fiscal_month_offset = fiscal_month_offset

    @property
    def has_allowed_values(self):
        """
        Gets the has_allowed_values of this LookmlModelExploreField.
        Whether this field has a set of allowed_values specified in LookML.

        :return: The has_allowed_values of this LookmlModelExploreField.
        :rtype: bool
        """
        return self._has_allowed_values

    @has_allowed_values.setter
    def has_allowed_values(self, has_allowed_values):
        """
        Sets the has_allowed_values of this LookmlModelExploreField.
        Whether this field has a set of allowed_values specified in LookML.

        :param has_allowed_values: The has_allowed_values of this LookmlModelExploreField.
        :type: bool
        """

        self._has_allowed_values = has_allowed_values

    @property
    def hidden(self):
        """
        Gets the hidden of this LookmlModelExploreField.
        Whether this field should be hidden from the user interface.

        :return: The hidden of this LookmlModelExploreField.
        :rtype: bool
        """
        return self._hidden

    @hidden.setter
    def hidden(self, hidden):
        """
        Sets the hidden of this LookmlModelExploreField.
        Whether this field should be hidden from the user interface.

        :param hidden: The hidden of this LookmlModelExploreField.
        :type: bool
        """

        self._hidden = hidden

    @property
    def is_filter(self):
        """
        Gets the is_filter of this LookmlModelExploreField.
        Whether this field is a filter.

        :return: The is_filter of this LookmlModelExploreField.
        :rtype: bool
        """
        return self._is_filter

    @is_filter.setter
    def is_filter(self, is_filter):
        """
        Sets the is_filter of this LookmlModelExploreField.
        Whether this field is a filter.

        :param is_filter: The is_filter of this LookmlModelExploreField.
        :type: bool
        """

        self._is_filter = is_filter

    @property
    def is_fiscal(self):
        """
        Gets the is_fiscal of this LookmlModelExploreField.
        Whether this field represents a fiscal time value.

        :return: The is_fiscal of this LookmlModelExploreField.
        :rtype: bool
        """
        return self._is_fiscal

    @is_fiscal.setter
    def is_fiscal(self, is_fiscal):
        """
        Sets the is_fiscal of this LookmlModelExploreField.
        Whether this field represents a fiscal time value.

        :param is_fiscal: The is_fiscal of this LookmlModelExploreField.
        :type: bool
        """

        self._is_fiscal = is_fiscal

    @property
    def is_numeric(self):
        """
        Gets the is_numeric of this LookmlModelExploreField.
        Whether this field is of a type that represents a numeric value.

        :return: The is_numeric of this LookmlModelExploreField.
        :rtype: bool
        """
        return self._is_numeric

    @is_numeric.setter
    def is_numeric(self, is_numeric):
        """
        Sets the is_numeric of this LookmlModelExploreField.
        Whether this field is of a type that represents a numeric value.

        :param is_numeric: The is_numeric of this LookmlModelExploreField.
        :type: bool
        """

        self._is_numeric = is_numeric

    @property
    def is_timeframe(self):
        """
        Gets the is_timeframe of this LookmlModelExploreField.
        Whether this field is of a type that represents a time value.

        :return: The is_timeframe of this LookmlModelExploreField.
        :rtype: bool
        """
        return self._is_timeframe

    @is_timeframe.setter
    def is_timeframe(self, is_timeframe):
        """
        Sets the is_timeframe of this LookmlModelExploreField.
        Whether this field is of a type that represents a time value.

        :param is_timeframe: The is_timeframe of this LookmlModelExploreField.
        :type: bool
        """

        self._is_timeframe = is_timeframe

    @property
    def can_time_filter(self):
        """
        Gets the can_time_filter of this LookmlModelExploreField.
        Whether this field can be time filtered.

        :return: The can_time_filter of this LookmlModelExploreField.
        :rtype: bool
        """
        return self._can_time_filter

    @can_time_filter.setter
    def can_time_filter(self, can_time_filter):
        """
        Sets the can_time_filter of this LookmlModelExploreField.
        Whether this field can be time filtered.

        :param can_time_filter: The can_time_filter of this LookmlModelExploreField.
        :type: bool
        """

        self._can_time_filter = can_time_filter

    @property
    def time_interval(self):
        """
        Gets the time_interval of this LookmlModelExploreField.
        Details on the time interval this field represents, if it is_timeframe.

        :return: The time_interval of this LookmlModelExploreField.
        :rtype: LookmlModelExploreFieldTimeInterval
        """
        return self._time_interval

    @time_interval.setter
    def time_interval(self, time_interval):
        """
        Sets the time_interval of this LookmlModelExploreField.
        Details on the time interval this field represents, if it is_timeframe.

        :param time_interval: The time_interval of this LookmlModelExploreField.
        :type: LookmlModelExploreFieldTimeInterval
        """

        self._time_interval = time_interval

    @property
    def label(self):
        """
        Gets the label of this LookmlModelExploreField.
        Fully-qualified human-readable label of the field.

        :return: The label of this LookmlModelExploreField.
        :rtype: str
        """
        return self._label

    @label.setter
    def label(self, label):
        """
        Sets the label of this LookmlModelExploreField.
        Fully-qualified human-readable label of the field.

        :param label: The label of this LookmlModelExploreField.
        :type: str
        """

        self._label = label

    @property
    def label_from_parameter(self):
        """
        Gets the label_from_parameter of this LookmlModelExploreField.
        The name of the parameter that will provide a parameterized label for this field, if available in the current context.

        :return: The label_from_parameter of this LookmlModelExploreField.
        :rtype: str
        """
        return self._label_from_parameter

    @label_from_parameter.setter
    def label_from_parameter(self, label_from_parameter):
        """
        Sets the label_from_parameter of this LookmlModelExploreField.
        The name of the parameter that will provide a parameterized label for this field, if available in the current context.

        :param label_from_parameter: The label_from_parameter of this LookmlModelExploreField.
        :type: str
        """

        self._label_from_parameter = label_from_parameter

    @property
    def label_short(self):
        """
        Gets the label_short of this LookmlModelExploreField.
        The human-readable label of the field, without the view label.

        :return: The label_short of this LookmlModelExploreField.
        :rtype: str
        """
        return self._label_short

    @label_short.setter
    def label_short(self, label_short):
        """
        Sets the label_short of this LookmlModelExploreField.
        The human-readable label of the field, without the view label.

        :param label_short: The label_short of this LookmlModelExploreField.
        :type: str
        """

        self._label_short = label_short

    @property
    def lookml_link(self):
        """
        Gets the lookml_link of this LookmlModelExploreField.
        A URL linking to the definition of this field in the LookML IDE.

        :return: The lookml_link of this LookmlModelExploreField.
        :rtype: str
        """
        return self._lookml_link

    @lookml_link.setter
    def lookml_link(self, lookml_link):
        """
        Sets the lookml_link of this LookmlModelExploreField.
        A URL linking to the definition of this field in the LookML IDE.

        :param lookml_link: The lookml_link of this LookmlModelExploreField.
        :type: str
        """

        self._lookml_link = lookml_link

    @property
    def map_layer(self):
        """
        Gets the map_layer of this LookmlModelExploreField.
        If applicable, a map layer this field is associated with.

        :return: The map_layer of this LookmlModelExploreField.
        :rtype: LookmlModelExploreFieldMapLayer
        """
        return self._map_layer

    @map_layer.setter
    def map_layer(self, map_layer):
        """
        Sets the map_layer of this LookmlModelExploreField.
        If applicable, a map layer this field is associated with.

        :param map_layer: The map_layer of this LookmlModelExploreField.
        :type: LookmlModelExploreFieldMapLayer
        """

        self._map_layer = map_layer

    @property
    def measure(self):
        """
        Gets the measure of this LookmlModelExploreField.
        Whether this field is a measure.

        :return: The measure of this LookmlModelExploreField.
        :rtype: bool
        """
        return self._measure

    @measure.setter
    def measure(self, measure):
        """
        Sets the measure of this LookmlModelExploreField.
        Whether this field is a measure.

        :param measure: The measure of this LookmlModelExploreField.
        :type: bool
        """

        self._measure = measure

    @property
    def name(self):
        """
        Gets the name of this LookmlModelExploreField.
        Fully-qualified name of the field.

        :return: The name of this LookmlModelExploreField.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this LookmlModelExploreField.
        Fully-qualified name of the field.

        :param name: The name of this LookmlModelExploreField.
        :type: str
        """

        self._name = name

    @property
    def parameter(self):
        """
        Gets the parameter of this LookmlModelExploreField.
        Whether this field is a parameter.

        :return: The parameter of this LookmlModelExploreField.
        :rtype: bool
        """
        return self._parameter

    @parameter.setter
    def parameter(self, parameter):
        """
        Sets the parameter of this LookmlModelExploreField.
        Whether this field is a parameter.

        :param parameter: The parameter of this LookmlModelExploreField.
        :type: bool
        """

        self._parameter = parameter

    @property
    def permanent(self):
        """
        Gets the permanent of this LookmlModelExploreField.
        Whether this field can be removed from a query.

        :return: The permanent of this LookmlModelExploreField.
        :rtype: bool
        """
        return self._permanent

    @permanent.setter
    def permanent(self, permanent):
        """
        Sets the permanent of this LookmlModelExploreField.
        Whether this field can be removed from a query.

        :param permanent: The permanent of this LookmlModelExploreField.
        :type: bool
        """

        self._permanent = permanent

    @property
    def primary_key(self):
        """
        Gets the primary_key of this LookmlModelExploreField.
        Whether or not the field represents a primary key.

        :return: The primary_key of this LookmlModelExploreField.
        :rtype: bool
        """
        return self._primary_key

    @primary_key.setter
    def primary_key(self, primary_key):
        """
        Sets the primary_key of this LookmlModelExploreField.
        Whether or not the field represents a primary key.

        :param primary_key: The primary_key of this LookmlModelExploreField.
        :type: bool
        """

        self._primary_key = primary_key

    @property
    def project_name(self):
        """
        Gets the project_name of this LookmlModelExploreField.
        The name of the project this field is defined in.

        :return: The project_name of this LookmlModelExploreField.
        :rtype: str
        """
        return self._project_name

    @project_name.setter
    def project_name(self, project_name):
        """
        Sets the project_name of this LookmlModelExploreField.
        The name of the project this field is defined in.

        :param project_name: The project_name of this LookmlModelExploreField.
        :type: str
        """

        self._project_name = project_name

    @property
    def requires_refresh_on_sort(self):
        """
        Gets the requires_refresh_on_sort of this LookmlModelExploreField.
        When true, it's not possible to re-sort this field's values without re-running the SQL query, due to database logic that affects the sort.

        :return: The requires_refresh_on_sort of this LookmlModelExploreField.
        :rtype: bool
        """
        return self._requires_refresh_on_sort

    @requires_refresh_on_sort.setter
    def requires_refresh_on_sort(self, requires_refresh_on_sort):
        """
        Sets the requires_refresh_on_sort of this LookmlModelExploreField.
        When true, it's not possible to re-sort this field's values without re-running the SQL query, due to database logic that affects the sort.

        :param requires_refresh_on_sort: The requires_refresh_on_sort of this LookmlModelExploreField.
        :type: bool
        """

        self._requires_refresh_on_sort = requires_refresh_on_sort

    @property
    def scope(self):
        """
        Gets the scope of this LookmlModelExploreField.
        The LookML scope this field belongs to. The scope is typically the field's view.

        :return: The scope of this LookmlModelExploreField.
        :rtype: str
        """
        return self._scope

    @scope.setter
    def scope(self, scope):
        """
        Sets the scope of this LookmlModelExploreField.
        The LookML scope this field belongs to. The scope is typically the field's view.

        :param scope: The scope of this LookmlModelExploreField.
        :type: str
        """

        self._scope = scope

    @property
    def sortable(self):
        """
        Gets the sortable of this LookmlModelExploreField.
        Whether this field can be sorted.

        :return: The sortable of this LookmlModelExploreField.
        :rtype: bool
        """
        return self._sortable

    @sortable.setter
    def sortable(self, sortable):
        """
        Sets the sortable of this LookmlModelExploreField.
        Whether this field can be sorted.

        :param sortable: The sortable of this LookmlModelExploreField.
        :type: bool
        """

        self._sortable = sortable

    @property
    def source_file(self):
        """
        Gets the source_file of this LookmlModelExploreField.
        The path portion of source_file_path.

        :return: The source_file of this LookmlModelExploreField.
        :rtype: str
        """
        return self._source_file

    @source_file.setter
    def source_file(self, source_file):
        """
        Sets the source_file of this LookmlModelExploreField.
        The path portion of source_file_path.

        :param source_file: The source_file of this LookmlModelExploreField.
        :type: str
        """

        self._source_file = source_file

    @property
    def source_file_path(self):
        """
        Gets the source_file_path of this LookmlModelExploreField.
        The fully-qualified path of the project file this field is defined in.

        :return: The source_file_path of this LookmlModelExploreField.
        :rtype: str
        """
        return self._source_file_path

    @source_file_path.setter
    def source_file_path(self, source_file_path):
        """
        Sets the source_file_path of this LookmlModelExploreField.
        The fully-qualified path of the project file this field is defined in.

        :param source_file_path: The source_file_path of this LookmlModelExploreField.
        :type: str
        """

        self._source_file_path = source_file_path

    @property
    def sql(self):
        """
        Gets the sql of this LookmlModelExploreField.
        SQL expression as defined in the LookML model. This will be null if the current user does not have the see_lookml permission for the field's model.

        :return: The sql of this LookmlModelExploreField.
        :rtype: str
        """
        return self._sql

    @sql.setter
    def sql(self, sql):
        """
        Sets the sql of this LookmlModelExploreField.
        SQL expression as defined in the LookML model. This will be null if the current user does not have the see_lookml permission for the field's model.

        :param sql: The sql of this LookmlModelExploreField.
        :type: str
        """

        self._sql = sql

    @property
    def sql_case(self):
        """
        Gets the sql_case of this LookmlModelExploreField.
        An array of conditions and values that make up a SQL Case expression, as defined in the LookML model. This will be null if the current user does not have the see_lookml permission for the field's model.

        :return: The sql_case of this LookmlModelExploreField.
        :rtype: list[LookmlModelExploreFieldSqlCase]
        """
        return self._sql_case

    @sql_case.setter
    def sql_case(self, sql_case):
        """
        Sets the sql_case of this LookmlModelExploreField.
        An array of conditions and values that make up a SQL Case expression, as defined in the LookML model. This will be null if the current user does not have the see_lookml permission for the field's model.

        :param sql_case: The sql_case of this LookmlModelExploreField.
        :type: list[LookmlModelExploreFieldSqlCase]
        """

        self._sql_case = sql_case

    @property
    def suggest_dimension(self):
        """
        Gets the suggest_dimension of this LookmlModelExploreField.
        The name of the dimension to base suggest queries from.

        :return: The suggest_dimension of this LookmlModelExploreField.
        :rtype: str
        """
        return self._suggest_dimension

    @suggest_dimension.setter
    def suggest_dimension(self, suggest_dimension):
        """
        Sets the suggest_dimension of this LookmlModelExploreField.
        The name of the dimension to base suggest queries from.

        :param suggest_dimension: The suggest_dimension of this LookmlModelExploreField.
        :type: str
        """

        self._suggest_dimension = suggest_dimension

    @property
    def suggest_explore(self):
        """
        Gets the suggest_explore of this LookmlModelExploreField.
        The name of the explore to base suggest queries from.

        :return: The suggest_explore of this LookmlModelExploreField.
        :rtype: str
        """
        return self._suggest_explore

    @suggest_explore.setter
    def suggest_explore(self, suggest_explore):
        """
        Sets the suggest_explore of this LookmlModelExploreField.
        The name of the explore to base suggest queries from.

        :param suggest_explore: The suggest_explore of this LookmlModelExploreField.
        :type: str
        """

        self._suggest_explore = suggest_explore

    @property
    def suggestable(self):
        """
        Gets the suggestable of this LookmlModelExploreField.
        Whether or not suggestions are possible for this field.

        :return: The suggestable of this LookmlModelExploreField.
        :rtype: bool
        """
        return self._suggestable

    @suggestable.setter
    def suggestable(self, suggestable):
        """
        Sets the suggestable of this LookmlModelExploreField.
        Whether or not suggestions are possible for this field.

        :param suggestable: The suggestable of this LookmlModelExploreField.
        :type: bool
        """

        self._suggestable = suggestable

    @property
    def suggestions(self):
        """
        Gets the suggestions of this LookmlModelExploreField.
        If available, a list of suggestions for this field. For most fields, a suggest query is a more appropriate way to get an up-to-date list of suggestions. Or use enumerations to list all the possible values.

        :return: The suggestions of this LookmlModelExploreField.
        :rtype: list[str]
        """
        return self._suggestions

    @suggestions.setter
    def suggestions(self, suggestions):
        """
        Sets the suggestions of this LookmlModelExploreField.
        If available, a list of suggestions for this field. For most fields, a suggest query is a more appropriate way to get an up-to-date list of suggestions. Or use enumerations to list all the possible values.

        :param suggestions: The suggestions of this LookmlModelExploreField.
        :type: list[str]
        """

        self._suggestions = suggestions

    @property
    def tags(self):
        """
        Gets the tags of this LookmlModelExploreField.
        An array of arbitrary string tags provided in the model for this field.

        :return: The tags of this LookmlModelExploreField.
        :rtype: list[str]
        """
        return self._tags

    @tags.setter
    def tags(self, tags):
        """
        Sets the tags of this LookmlModelExploreField.
        An array of arbitrary string tags provided in the model for this field.

        :param tags: The tags of this LookmlModelExploreField.
        :type: list[str]
        """

        self._tags = tags

    @property
    def type(self):
        """
        Gets the type of this LookmlModelExploreField.
        The LookML type of the field.

        :return: The type of this LookmlModelExploreField.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this LookmlModelExploreField.
        The LookML type of the field.

        :param type: The type of this LookmlModelExploreField.
        :type: str
        """

        self._type = type

    @property
    def user_attribute_filter_types(self):
        """
        Gets the user_attribute_filter_types of this LookmlModelExploreField.
        An array of user attribute types that are allowed to be used in filters on this field. Valid values are: \"advanced_filter_string\", \"advanced_filter_number\", \"advanced_filter_datetime\", \"string\", \"number\", \"datetime\", \"yesno\", \"zipcode\".

        :return: The user_attribute_filter_types of this LookmlModelExploreField.
        :rtype: list[str]
        """
        return self._user_attribute_filter_types

    @user_attribute_filter_types.setter
    def user_attribute_filter_types(self, user_attribute_filter_types):
        """
        Sets the user_attribute_filter_types of this LookmlModelExploreField.
        An array of user attribute types that are allowed to be used in filters on this field. Valid values are: \"advanced_filter_string\", \"advanced_filter_number\", \"advanced_filter_datetime\", \"string\", \"number\", \"datetime\", \"yesno\", \"zipcode\".

        :param user_attribute_filter_types: The user_attribute_filter_types of this LookmlModelExploreField.
        :type: list[str]
        """

        self._user_attribute_filter_types = user_attribute_filter_types

    @property
    def value_format(self):
        """
        Gets the value_format of this LookmlModelExploreField.
        If specified, the LookML value format string for formatting values of this field.

        :return: The value_format of this LookmlModelExploreField.
        :rtype: str
        """
        return self._value_format

    @value_format.setter
    def value_format(self, value_format):
        """
        Sets the value_format of this LookmlModelExploreField.
        If specified, the LookML value format string for formatting values of this field.

        :param value_format: The value_format of this LookmlModelExploreField.
        :type: str
        """

        self._value_format = value_format

    @property
    def view(self):
        """
        Gets the view of this LookmlModelExploreField.
        The name of the view this field belongs to.

        :return: The view of this LookmlModelExploreField.
        :rtype: str
        """
        return self._view

    @view.setter
    def view(self, view):
        """
        Sets the view of this LookmlModelExploreField.
        The name of the view this field belongs to.

        :param view: The view of this LookmlModelExploreField.
        :type: str
        """

        self._view = view

    @property
    def view_label(self):
        """
        Gets the view_label of this LookmlModelExploreField.
        The human-readable label of the view the field belongs to.

        :return: The view_label of this LookmlModelExploreField.
        :rtype: str
        """
        return self._view_label

    @view_label.setter
    def view_label(self, view_label):
        """
        Sets the view_label of this LookmlModelExploreField.
        The human-readable label of the view the field belongs to.

        :param view_label: The view_label of this LookmlModelExploreField.
        :type: str
        """

        self._view_label = view_label

    @property
    def dynamic(self):
        """
        Gets the dynamic of this LookmlModelExploreField.
        Whether this field was specified in \"dynamic_fields\" and is not part of the model.

        :return: The dynamic of this LookmlModelExploreField.
        :rtype: bool
        """
        return self._dynamic

    @dynamic.setter
    def dynamic(self, dynamic):
        """
        Sets the dynamic of this LookmlModelExploreField.
        Whether this field was specified in \"dynamic_fields\" and is not part of the model.

        :param dynamic: The dynamic of this LookmlModelExploreField.
        :type: bool
        """

        self._dynamic = dynamic

    @property
    def week_start_day(self):
        """
        Gets the week_start_day of this LookmlModelExploreField.
        The name of the starting day of the week. Valid values are: \"monday\", \"tuesday\", \"wednesday\", \"thursday\", \"friday\", \"saturday\", \"sunday\".

        :return: The week_start_day of this LookmlModelExploreField.
        :rtype: str
        """
        return self._week_start_day

    @week_start_day.setter
    def week_start_day(self, week_start_day):
        """
        Sets the week_start_day of this LookmlModelExploreField.
        The name of the starting day of the week. Valid values are: \"monday\", \"tuesday\", \"wednesday\", \"thursday\", \"friday\", \"saturday\", \"sunday\".

        :param week_start_day: The week_start_day of this LookmlModelExploreField.
        :type: str
        """

        self._week_start_day = week_start_day

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, LookmlModelExploreField):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
